/** \file marc8r.c
    \brief Character conversion, generated from ./codetables.xml

    Generated automatically by charconv.tcl
*/
#include <string.h>

        struct yaz_iconv_trie_flat {
            char from[6];
            unsigned combining : 1;
            unsigned  to : 24;
        };
        struct yaz_iconv_trie_dir {
            int ptr : 15;
            unsigned combining : 1;
            unsigned  to : 24;
        };
        
        struct yaz_iconv_trie {
            struct yaz_iconv_trie_flat *flat;
            struct yaz_iconv_trie_dir *dir;
        };
    

        static unsigned long lookup(struct yaz_iconv_trie **ptrs, int ptr, unsigned char *inp,
                                    size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, unsigned int boffset)
        {
            struct yaz_iconv_trie *t = ptrs[ptr-1];
            if (inbytesleft < 1)
                return 0;
            if (t->dir)
            {
                size_t ch = (inp[0] & mask) + boffset;
                unsigned long code;
                if (t->dir[ch].ptr)
                {
                    code = lookup(ptrs, t->dir[ch].ptr, inp+1, inbytesleft-1, no_read, combining, mask, boffset);
		    if (code)
		    {
			(*no_read)++;
			return code;
		    }
		}
                if (t->dir[ch].to)
                {
                    code = t->dir[ch].to;
		    *combining = t->dir[ch].combining;
                    *no_read = 1;
                    return code;
                }
            }
            else
            {
                struct yaz_iconv_trie_flat *flat = t->flat;
                while (flat->to)
                {
                    size_t len = strlen(flat->from);
                    if (len <= inbytesleft)
                    {
                        size_t i;
			for (i = 0; i < len; i++)
			{
			    if (((unsigned char *) flat->from)[i] != (inp[i] & mask) + boffset)
			        break;
		        }
                        if (i == len)
                        {
                            *no_read = len;
			    *combining = flat->combining;
                            return flat->to;
                        }
                    }
                    flat++;
                }
            }
            return 0;
        }
    
/* TRIE: size 99 */
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8r_42page0_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x1B} /* ESCAPE (Unlikely to occur in UCS/Unicode) */,
  {0, 0, 0},
  {0, 0, 0x1D} /* RECORD TERMINATOR / GROUP SEPARATOR */,
  {0, 0, 0x1E} /* FIELD TERMINATOR / RECORD SEPARATOR */,
  {0, 0, 0x1F} /* SUBFIELD DELIMITER / UNIT SEPARATOR */,
  {0, 0, 0x20} /* SPACE, BLANK / SPACE */,
  {0, 0, 0x21} /* EXCLAMATION MARK */,
  {0, 0, 0x22} /* QUOTATION MARK */,
  {0, 0, 0x23} /* NUMBER SIGN */,
  {0, 0, 0x24} /* DOLLAR SIGN */,
  {0, 0, 0x25} /* PERCENT SIGN */,
  {0, 0, 0x26} /* AMPERSAND */,
  {0, 0, 0x27} /* APOSTROPHE */,
  {0, 0, 0x28} /* OPENING PARENTHESIS / LEFT PARENTHESIS */,
  {0, 0, 0x29} /* CLOSING PARENTHESIS / CLOSING PARENTHESIS */,
  {0, 0, 0x2A} /* ASTERISK */,
  {0, 0, 0x2B} /* PLUS SIGN */,
  {0, 0, 0x2C} /* COMMA */,
  {0, 0, 0x2D} /* HYPHEN-MINUS */,
  {0, 0, 0x2E} /* PERIOD, DECIMAL POINT / FULL STOP */,
  {0, 0, 0x2F} /* SLASH / SOLIDUS */,
  {0, 0, 0x30} /* DIGIT ZERO */,
  {0, 0, 0x31} /* DIGIT ONE */,
  {0, 0, 0x32} /* DIGIT TWO */,
  {0, 0, 0x33} /* DIGIT THREE */,
  {0, 0, 0x34} /* DIGIT FOUR */,
  {0, 0, 0x35} /* DIGIT FIVE */,
  {0, 0, 0x36} /* DIGIT SIX */,
  {0, 0, 0x37} /* DIGIT SEVEN */,
  {0, 0, 0x38} /* DIGIT EIGHT */,
  {0, 0, 0x39} /* DIGIT NINE */,
  {0, 0, 0x3A} /* COLON */,
  {0, 0, 0x3B} /* SEMICOLON */,
  {0, 0, 0x3C} /* LESS-THAN SIGN */,
  {0, 0, 0x3D} /* EQUALS SIGN */,
  {0, 0, 0x3E} /* GREATER-THAN SIGN */,
  {0, 0, 0x3F} /* QUESTION MARK */,
  {0, 0, 0x40} /* COMMERCIAL AT */,
  {0, 0, 0x41} /* LATIN CAPITAL LETTER A */,
  {0, 0, 0x42} /* LATIN CAPITAL LETTER B */,
  {0, 0, 0x43} /* LATIN CAPITAL LETTER C */,
  {0, 0, 0x44} /* LATIN CAPITAL LETTER D */,
  {0, 0, 0x45} /* LATIN CAPITAL LETTER E */,
  {0, 0, 0x46} /* LATIN CAPITAL LETTER F */,
  {0, 0, 0x47} /* LATIN CAPITAL LETTER G */,
  {0, 0, 0x48} /* LATIN CAPITAL LETTER H */,
  {0, 0, 0x49} /* LATIN CAPITAL LETTER I */,
  {0, 0, 0x4A} /* LATIN CAPITAL LETTER J */,
  {0, 0, 0x4B} /* LATIN CAPITAL LETTER K */,
  {0, 0, 0x4C} /* LATIN CAPITAL LETTER L */,
  {0, 0, 0x4D} /* LATIN CAPITAL LETTER M */,
  {0, 0, 0x4E} /* LATIN CAPITAL LETTER N */,
  {0, 0, 0x4F} /* LATIN CAPITAL LETTER O */,
  {0, 0, 0x50} /* LATIN CAPITAL LETTER P */,
  {0, 0, 0x51} /* LATIN CAPITAL LETTER Q */,
  {0, 0, 0x52} /* LATIN CAPITAL LETTER R */,
  {0, 0, 0x53} /* LATIN CAPITAL LETTER S */,
  {0, 0, 0x54} /* LATIN CAPITAL LETTER T */,
  {0, 0, 0x55} /* LATIN CAPITAL LETTER U */,
  {0, 0, 0x56} /* LATIN CAPITAL LETTER V */,
  {0, 0, 0x57} /* LATIN CAPITAL LETTER W */,
  {0, 0, 0x58} /* LATIN CAPITAL LETTER X */,
  {0, 0, 0x59} /* LATIN CAPITAL LETTER Y */,
  {0, 0, 0x5A} /* LATIN CAPITAL LETTER Z */,
  {0, 0, 0x5B} /* OPENING SQUARE BRACKET / LEFT SQUARE BRACKET */,
  {0, 0, 0x5C} /* REVERSE SLASH / REVERSE SOLIDUS */,
  {0, 0, 0x5D} /* CLOSING SQUARE BRACKET / RIGHT SQUARE BRACKET */,
  {0, 0, 0x5E} /* SPACING CIRCUMFLEX / CIRCUMFLEX ACCENT */,
  {0, 0, 0x5F} /* SPACING UNDERSCORE / LOW LINE */,
  {0, 0, 0x60} /* SPACING GRAVE / GRAVE ACCENT */,
  {0, 0, 0x61} /* LATIN SMALL LETTER A */,
  {0, 0, 0x62} /* LATIN SMALL LETTER B */,
  {0, 0, 0x63} /* LATIN SMALL LETTER C */,
  {0, 0, 0x64} /* LATIN SMALL LETTER D */,
  {0, 0, 0x65} /* LATIN SMALL LETTER E */,
  {0, 0, 0x66} /* LATIN SMALL LETTER F */,
  {0, 0, 0x67} /* LATIN SMALL LETTER G */,
  {0, 0, 0x68} /* LATIN SMALL LETTER H */,
  {0, 0, 0x69} /* LATIN SMALL LETTER I */,
  {0, 0, 0x6A} /* LATIN SMALL LETTER J */,
  {0, 0, 0x6B} /* LATIN SMALL LETTER K */,
  {0, 0, 0x6C} /* LATIN SMALL LETTER L */,
  {0, 0, 0x6D} /* LATIN SMALL LETTER M */,
  {0, 0, 0x6E} /* LATIN SMALL LETTER N */,
  {0, 0, 0x6F} /* LATIN SMALL LETTER O */,
  {0, 0, 0x70} /* LATIN SMALL LETTER P */,
  {0, 0, 0x71} /* LATIN SMALL LETTER Q */,
  {0, 0, 0x72} /* LATIN SMALL LETTER R */,
  {0, 0, 0x73} /* LATIN SMALL LETTER S */,
  {0, 0, 0x74} /* LATIN SMALL LETTER T */,
  {0, 0, 0x75} /* LATIN SMALL LETTER U */,
  {0, 0, 0x76} /* LATIN SMALL LETTER V */,
  {0, 0, 0x77} /* LATIN SMALL LETTER W */,
  {0, 0, 0x78} /* LATIN SMALL LETTER X */,
  {0, 0, 0x79} /* LATIN SMALL LETTER Y */,
  {0, 0, 0x7A} /* LATIN SMALL LETTER Z */,
  {0, 0, 0x7B} /* OPENING CURLY BRACKET / LEFT CURLY BRACKET */,
  {0, 0, 0x7C} /* VERTICAL BAR (FILL) / VERTICAL LINE */,
  {0, 0, 0x7D} /* CLOSING CURLY BRACKET / RIGHT CURLY BRACKET */,
  {0, 0, 0x7E} /* SPACING TILDE / TILDE */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_42page0 = {
  0, marc8r_42page0_dir
};
struct yaz_iconv_trie *marc8r_42ptrs [] = {
 &marc8r_42page0,
0, };

unsigned long yaz_marc8r_42_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, unsigned int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8r_42ptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 72 */
/* PAGE 10 */
struct yaz_iconv_trie_flat marc8r_45page10_flat[] = {
  {"\xB8\xA0", 1, 0xEB}, /* LIGATURE, FIRST HALF / COMBINING DOUBLE  				INVERTED BREVE */
  {"\xB8\xA1", 1, 0xEC}, /* LIGATURE, SECOND HALF / COMBINING LIGATURE RIGHT HALF */
  {"\xB8\xA2", 1, 0xFA}, /* DOUBLE TILDE, FIRST HALF / COMBINING DOUBLE TILDE */
  {"\xB8\xA3", 1, 0xFB}, /* DOUBLE TILDE, SECOND HALF / COMBINING DOUBLE TILDE RIGHT HALF */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_45page10 = {
  marc8r_45page10_flat, 0
};
/* PAGE 9 */
struct yaz_iconv_trie_flat marc8r_45page9_flat[] = {
  {"\xA1", 1, 0xEB}, /* LIGATURE, FIRST HALF / COMBINING DOUBLE  				INVERTED BREVE */
  {"\xA0", 1, 0xFA}, /* DOUBLE TILDE, FIRST HALF / COMBINING DOUBLE TILDE */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_45page9 = {
  marc8r_45page9_flat, 0
};
/* PAGE 8 */
struct yaz_iconv_trie_flat marc8r_45page8_flat[] = {
  {"\x89", 1, 0xE0}, /* PSEUDO QUESTION MARK / COMBINING HOOK ABOVE */
  {"\x80", 1, 0xE1}, /* GRAVE / COMBINING GRAVE ACCENT (Varia) */
  {"\x81", 1, 0xE2}, /* ACUTE / COMBINING ACUTE ACCENT (Oxia) */
  {"\x82", 1, 0xE3}, /* CIRCUMFLEX / COMBINING CIRCUMFLEX ACCENT */
  {"\x83", 1, 0xE4}, /* TILDE / COMBINING TILDE */
  {"\x84", 1, 0xE5}, /* MACRON / COMBINING MACRON */
  {"\x86", 1, 0xE6}, /* BREVE / COMBINING BREVE (Vrachy) */
  {"\x87", 1, 0xE7}, /* SUPERIOR DOT / COMBINING DOT ABOVE */
  {"\x88", 1, 0xE8}, /* UMLAUT, DIAERESIS / COMBINING DIAERESIS (Dialytika) */
  {"\x8C", 1, 0xE9}, /* HACEK / COMBINING CARON */
  {"\x8A", 1, 0xEA}, /* CIRCLE ABOVE, ANGSTROM / COMBINING RING ABOVE */
  {"\x95", 1, 0xED}, /* HIGH COMMA, OFF CENTER / COMBINING COMMA ABOVE RIGHT */
  {"\x8B", 1, 0xEE}, /* DOUBLE ACUTE / COMBINING DOUBLE ACUTE ACCENT */
  {"\x90", 1, 0xEF}, /* CANDRABINDU / COMBINING CANDRABINDU */
  {"\xA7", 1, 0xF0}, /* CEDILLA / COMBINING CEDILLA */
  {"\xA8", 1, 0xF1}, /* RIGHT HOOK, OGONEK / COMBINING OGONEK */
  {"\xA3", 1, 0xF2}, /* DOT BELOW / COMBINING DOT BELOW */
  {"\xA4", 1, 0xF3}, /* DOUBLE DOT BELOW / COMBINING DIAERESIS BELOW */
  {"\xA5", 1, 0xF4}, /* CIRCLE BELOW / COMBINING RING BELOW */
  {"\xB3", 1, 0xF5}, /* DOUBLE UNDERSCORE / COMBINING DOUBLE LOW LINE */
  {"\xB2", 1, 0xF6}, /* UNDERSCORE / COMBINING LOW LINE */
  {"\xA6", 1, 0xF7}, /* LEFT HOOK (COMMA BELOW) / COMBINING COMMA BELOW */
  {"\x9C", 1, 0xF8}, /* RIGHT CEDILLA / COMBINING LEFT HALF RING BELOW */
  {"\xAE", 1, 0xF9}, /* UPADHMANIYA / COMBINING BREVE BELOW */
  {"\x93", 1, 0xFE}, /* HIGH COMMA, CENTERED / COMBINING COMMA ABOVE (Psili) */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_45page8 = {
  marc8r_45page8_flat, 0
};
/* PAGE 7 */
struct yaz_iconv_trie_flat marc8r_45page7_flat[] = {
  {"\xA0", 0, 0xAC}, /* UPPERCASE O-HOOK / LATIN CAPITAL LETTER O WITH HORN */
  {"\xAF", 0, 0xAD}, /* UPPERCASE U-HOOK / LATIN CAPITAL LETTER U WITH HORN */
  {"\xA1", 0, 0xBC}, /* LOWERCASE O-HOOK / LATIN SMALL LETTER O WITH HORN */
  {"\xB0", 0, 0xBD}, /* LOWERCASE U-HOOK / LATIN SMALL LETTER U WITH HORN */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_45page7 = {
  marc8r_45page7_flat, 0
};
/* PAGE 6 */
struct yaz_iconv_trie_flat marc8r_45page6_flat[] = {
  {"\xB9", 0, 0xA7}, /* SOFT SIGN, PRIME / MODIFIER LETTER PRIME */
  {"\xBC", 0, 0xAE}, /* ALIF / MODIFIER LETTER APOSTROPHE */
  {"\xBE", 0, 0xAE}, /* ALIF / MODIFIER LETTER APOSTROPHE */
  {"\xBB", 0, 0xB0}, /* AYN / MODIFIER LETTER TURNED COMMA */
  {"\xBA", 0, 0xB7}, /* HARD SIGN, DOUBLE PRIME / MODIFIER LETTER DOUBLE PRIME */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_45page6 = {
  marc8r_45page6_flat, 0
};
/* PAGE 5 */
struct yaz_iconv_trie_flat marc8r_45page5_flat[] = {
  {"\x90", 0, 0xA3}, /* UPPERCASE D WITH CROSSBAR / LATIN CAPITAL LETTER D WITH STROKE */
  {"\x91", 0, 0xB3}, /* LOWERCASE D WITH CROSSBAR / LATIN SMALL LETTER D WITH STROKE */
  {"\xB1", 0, 0xB8}, /* LOWERCASE TURKISH I / LATIN SMALL LETTER DOTLESS I */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_45page5 = {
  marc8r_45page5_flat, 0
};
/* PAGE 4 */
struct yaz_iconv_trie_flat marc8r_45page4_flat[] = {
  {"\x98", 0, 0xA2}, /* UPPERCASE SCANDINAVIAN O / LATIN CAPITAL LETTER O WITH STROKE */
  {"\x9E", 0, 0xA4}, /* UPPERCASE ICELANDIC THORN / LATIN CAPITAL LETTER THORN (Icelandic) */
  {"\x86", 0, 0xA5}, /* UPPERCASE DIGRAPH AE / LATIN CAPITAL LIGATURE AE */
  {"\xB8", 0, 0xB2}, /* LOWERCASE SCANDINAVIAN O / LATIN SMALL LETTER O WITH STROKE */
  {"\xBE", 0, 0xB4}, /* LOWERCASE ICELANDIC THORN / LATIN SMALL LETTER THORN (Icelandic) */
  {"\xA6", 0, 0xB5}, /* LOWERCASE DIGRAPH AE / LATIN SMALL LIGATURE AE */
  {"\xB0", 0, 0xBA}, /* LOWERCASE ETH / LATIN SMALL LETTER ETH (Icelandic) */
  {"\x9F", 0, 0xC7}, /* ESZETT SYMBOL */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_45page4 = {
  marc8r_45page4_flat, 0
};
/* PAGE 3 */
struct yaz_iconv_trie_flat marc8r_45page3_flat[] = {
  {"\x81", 0, 0xA1}, /* UPPERCASE POLISH L / LATIN CAPITAL LETTER L WITH STROKE */
  {"\x92", 0, 0xA6}, /* UPPERCASE DIGRAPH OE / LATIN CAPITAL LIGATURE OE */
  {"\x82", 0, 0xB1}, /* LOWERCASE POLISH L / LATIN SMALL LETTER L WITH STROKE */
  {"\x93", 0, 0xB6}, /* LOWERCASE DIGRAPH OE / LATIN SMALL LIGATURE OE */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_45page3 = {
  marc8r_45page3_flat, 0
};
/* PAGE 2 */
struct yaz_iconv_trie_flat marc8r_45page2_flat[] = {
  {"\x80\x8D", 0, 0x8D}, /* JOINER / ZERO WIDTH JOINER */
  {"\x80\x8C", 0, 0x8E}, /* NON-JOINER / ZERO WIDTH NON-JOINER */
  {"\x99\xAD", 0, 0xA9}, /* MUSIC FLAT SIGN */
  {"\x84\x93", 0, 0xC1}, /* SCRIPT SMALL L */
  {"\x84\x97", 0, 0xC2}, /* SOUND RECORDING COPYRIGHT */
  {"\x99\xAF", 0, 0xC4}, /* MUSIC SHARP SIGN */
  {"\x82\xAC", 0, 0xC8}, /* EURO SIGN */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_45page2 = {
  marc8r_45page2_flat, 0
};
/* PAGE 1 */
struct yaz_iconv_trie_flat marc8r_45page1_flat[] = {
  {"\x98", 0, 0x88}, /* NON-SORT BEGIN / START OF STRING */
  {"\x9C", 0, 0x89}, /* NON-SORT END / STRING TERMINATOR */
  {"\xB7", 0, 0xA8}, /* MIDDLE DOT */
  {"\xAE", 0, 0xAA}, /* PATENT MARK / REGISTERED SIGN */
  {"\xB1", 0, 0xAB}, /* PLUS OR MINUS / PLUS-MINUS SIGN */
  {"\xA3", 0, 0xB9}, /* BRITISH POUND / POUND SIGN */
  {"\xB0", 0, 0xC0}, /* DEGREE SIGN */
  {"\xA9", 0, 0xC3}, /* COPYRIGHT SIGN */
  {"\xBF", 0, 0xC5}, /* INVERTED QUESTION MARK */
  {"\xA1", 0, 0xC6}, /* INVERTED EXCLAMATION MARK */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_45page1 = {
  marc8r_45page1_flat, 0
};
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8r_45page0_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {2, 0, 0},
  {5, 0, 0},
  {6, 0, 0},
  {4, 0, 0},
  {8, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {7, 0, 0},
  {0, 0, 0},
  {9, 0, 0},
  {10, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {3, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {11, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_45page0 = {
  0, marc8r_45page0_dir
};
struct yaz_iconv_trie *marc8r_45ptrs [] = {
 &marc8r_45page0,
 &marc8r_45page1,
 &marc8r_45page2,
 &marc8r_45page3,
 &marc8r_45page4,
 &marc8r_45page5,
 &marc8r_45page6,
 &marc8r_45page7,
 &marc8r_45page8,
 &marc8r_45page9,
 &marc8r_45page10,
0, };

unsigned long yaz_marc8r_45_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, unsigned int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8r_45ptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 3 */
/* PAGE 0 */
struct yaz_iconv_trie_flat marc8r_67page0_flat[] = {
  {"\xCE\xB1", 0, 0x61}, /* GREEK SMALL LETTER ALPHA */
  {"\xCE\xB2", 0, 0x62}, /* GREEK SMALL LETTER BETA */
  {"\xCE\xB3", 0, 0x63}, /* GREEK SMALL LETTER GAMMA */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_67page0 = {
  marc8r_67page0_flat, 0
};
struct yaz_iconv_trie *marc8r_67ptrs [] = {
 &marc8r_67page0,
0, };

unsigned long yaz_marc8r_67_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, unsigned int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8r_67ptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 14 */
/* PAGE 0 */
struct yaz_iconv_trie_flat marc8r_62page0_flat[] = {
  {"\xE2\x82\x8D", 0, 0x28}, /* SUBSCRIPT OPENING PARENTHESIS / SUBSCRIPT LEFT PARENTHESIS */
  {"\xE2\x82\x8E", 0, 0x29}, /* SUBSCRIPT CLOSING PARENTHESIS / SUBSCRIPT RIGHT PARENTHESIS */
  {"\xE2\x82\x8A", 0, 0x2B}, /* SUBSCRIPT PLUS SIGN */
  {"\xE2\x82\x8B", 0, 0x2D}, /* SUBSCRIPT HYPHEN-MINUS / SUBSCRIPT MINUS */
  {"\xE2\x82\x80", 0, 0x30}, /* SUBSCRIPT DIGIT ZERO */
  {"\xE2\x82\x81", 0, 0x31}, /* SUBSCRIPT DIGIT ONE */
  {"\xE2\x82\x82", 0, 0x32}, /* SUBSCRIPT DIGIT TWO */
  {"\xE2\x82\x83", 0, 0x33}, /* SUBSCRIPT DIGIT THREE */
  {"\xE2\x82\x84", 0, 0x34}, /* SUBSCRIPT DIGIT FOUR */
  {"\xE2\x82\x85", 0, 0x35}, /* SUBSCRIPT DIGIT FIVE */
  {"\xE2\x82\x86", 0, 0x36}, /* SUBSCRIPT DIGIT SIX */
  {"\xE2\x82\x87", 0, 0x37}, /* SUBSCRIPT DIGIT SEVEN */
  {"\xE2\x82\x88", 0, 0x38}, /* SUBSCRIPT DIGIT EIGHT */
  {"\xE2\x82\x89", 0, 0x39}, /* SUBSCRIPT DIGIT NINE */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_62page0 = {
  marc8r_62page0_flat, 0
};
struct yaz_iconv_trie *marc8r_62ptrs [] = {
 &marc8r_62page0,
0, };

unsigned long yaz_marc8r_62_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, unsigned int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8r_62ptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 14 */
/* PAGE 0 */
struct yaz_iconv_trie_flat marc8r_70page0_flat[] = {
  {"\xE2\x81\xBD", 0, 0x28}, /* SUPERSCRIPT OPENING PARENTHESIS / SUPERSCRIPT LEFT PARENTHESIS */
  {"\xE2\x81\xBE", 0, 0x29}, /* SUPERSCRIPT CLOSING PARENTHESIS / SUPERSCRIPT RIGHT PARENTHESIS */
  {"\xE2\x81\xBA", 0, 0x2B}, /* SUPERSCRIPT PLUS SIGN */
  {"\xE2\x81\xBB", 0, 0x2D}, /* SUPERSCRIPT HYPHEN-MINUS / SUPERSCRIPT MINUS */
  {"\xE2\x81\xB0", 0, 0x30}, /* SUPERSCRIPT DIGIT ZERO */
  {"\xC2\xB9", 0, 0x31}, /* SUPERSCRIPT DIGIT ONE */
  {"\xC2\xB2", 0, 0x32}, /* SUPERSCRIPT DIGIT TWO */
  {"\xC2\xB3", 0, 0x33}, /* SUPERSCRIPT DIGIT THREE */
  {"\xE2\x81\xB4", 0, 0x34}, /* SUPERSCRIPT DIGIT FOUR */
  {"\xE2\x81\xB5", 0, 0x35}, /* SUPERSCRIPT DIGIT FIVE */
  {"\xE2\x81\xB6", 0, 0x36}, /* SUPERSCRIPT DIGIT SIX */
  {"\xE2\x81\xB7", 0, 0x37}, /* SUPERSCRIPT DIGIT SEVEN */
  {"\xE2\x81\xB8", 0, 0x38}, /* SUPERSCRIPT DIGIT EIGHT */
  {"\xE2\x81\xB9", 0, 0x39}, /* SUPERSCRIPT DIGIT NINE */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_70page0 = {
  marc8r_70page0_flat, 0
};
struct yaz_iconv_trie *marc8r_70ptrs [] = {
 &marc8r_70page0,
0, };

unsigned long yaz_marc8r_70_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, unsigned int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8r_70ptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 78 */
/* PAGE 3 */
struct yaz_iconv_trie_flat marc8r_32page3_flat[] = {
  {"\xAC\x9E", 1, 0x4E}, /* VARIKA / HEBREW POINT JUDEO-SPANISH VARIKA */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_32page3 = {
  marc8r_32page3_flat, 0
};
/* PAGE 2 */
struct yaz_iconv_trie_flat marc8r_32page2_flat[] = {
  {"\xBE", 0, 0x2D}, /* HYPHEN-MINUS, MAKEF / HEBREW PUNCTUATION MAQAF */
  {"\xB7", 1, 0x40}, /* HEBREW POINT PATAH */
  {"\xB8", 1, 0x41}, /* KAMATS / HEBREW POINT QAMATS */
  {"\xB6", 1, 0x42}, /* HEBREW POINT SEGOL */
  {"\xB5", 1, 0x43}, /* TSEREH / HEBREW POINT TSERE */
  {"\xB4", 1, 0x44}, /* HIRIK / HEBREW POINT HIRIQ */
  {"\xB9", 1, 0x45}, /* HOLAM, LEFT SIN DOT / HEBREW POINT HOLAM */
  {"\xBB", 1, 0x46}, /* KUBUTS / HEBREW POINT QUBUTS */
  {"\xB0", 1, 0x47}, /* HEBREW POINT SHEVA */
  {"\xB2", 1, 0x48}, /* HEBREW POINT HATAF PATAH */
  {"\xB3", 1, 0x49}, /* HATAF KAMATS / HEBREW POINT HATAF QAMATS */
  {"\xB1", 1, 0x4A}, /* HEBREW POINT HATAF SEGOL */
  {"\xBC", 1, 0x4B}, /* HEBREW POINT DAGESH OR MAPIQ */
  {"\xBF", 1, 0x4C}, /* RAFEH / HEBREW POINT RAFE */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_32page2 = {
  marc8r_32page2_flat, 0
};
/* PAGE 1 */
struct yaz_iconv_trie_flat marc8r_32page1_flat[] = {
  {"\xB4", 0, 0x22}, /* QUOTATION MARK, GERSHAYIM / HEBREW PUNCTUATION GERSHAYIM */
  {"\xB3", 0, 0x27}, /* APOSTROPHE, GERESH / HEBREW PUNCTUATION GERESH */
  {"\x81", 1, 0x4D}, /* RIGHT SHIN DOT / HEBREW POINT  SHIN DOT */
  {"\x90", 0, 0x60}, /* HEBREW LETTER ALEF */
  {"\x91", 0, 0x61}, /* HEBREW LETTER BET */
  {"\x92", 0, 0x62}, /* HEBREW LETTER GIMEL */
  {"\x93", 0, 0x63}, /* HEBREW LETTER DALET */
  {"\x94", 0, 0x64}, /* HEBREW LETTER HE */
  {"\x95", 0, 0x65}, /* HEBREW LETTER VAV */
  {"\x96", 0, 0x66}, /* HEBREW LETTER ZAYIN */
  {"\x97", 0, 0x67}, /* HEBREW LETTER HET */
  {"\x98", 0, 0x68}, /* HEBREW LETTER TET */
  {"\x99", 0, 0x69}, /* HEBREW LETTER YOD */
  {"\x9A", 0, 0x6A}, /* HEBREW LETTER FINAL KAF */
  {"\x9B", 0, 0x6B}, /* HEBREW LETTER KAF */
  {"\x9C", 0, 0x6C}, /* HEBREW LETTER LAMED */
  {"\x9D", 0, 0x6D}, /* HEBREW LETTER FINAL MEM */
  {"\x9E", 0, 0x6E}, /* HEBREW LETTER MEM */
  {"\x9F", 0, 0x6F}, /* HEBREW LETTER FINAL NUN */
  {"\xA0", 0, 0x70}, /* HEBREW LETTER NUN */
  {"\xA1", 0, 0x71}, /* HEBREW LETTER SAMEKH */
  {"\xA2", 0, 0x72}, /* HEBREW LETTER AYIN */
  {"\xA3", 0, 0x73}, /* HEBREW LETTER FINAL PE */
  {"\xA4", 0, 0x74}, /* HEBREW LETTER PE */
  {"\xA5", 0, 0x75}, /* HEBREW LETTER FINAL TSADI */
  {"\xA6", 0, 0x76}, /* HEBREW LETTER TSADI */
  {"\xA7", 0, 0x77}, /* HEBREW LETTER QOF / KOF */
  {"\xA8", 0, 0x78}, /* HEBREW LETTER RESH */
  {"\xA9", 0, 0x79}, /* HEBREW LETTER SHIN */
  {"\xAA", 0, 0x7A}, /* HEBREW LETTER TAV */
  {"\xB0", 0, 0x7B}, /* HEBREW LIGATURE YIDDISH DOUBLE VAV / TSVEY VOVN */
  {"\xB1", 0, 0x7C}, /* HEBREW LIGATURE YIDDISH VAV YOD / VOV YUD */
  {"\xB2", 0, 0x7D}, /* HEBREW LIGATURE YIDDISH DOUBLE YOD / TSVEY YUDN */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_32page1 = {
  marc8r_32page1_flat, 0
};
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8r_32page0_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x21} /* EXCLAMATION MARK */,
  {0, 0, 0},
  {0, 0, 0x23} /* NUMBER SIGN */,
  {0, 0, 0x24} /* DOLLAR SIGN */,
  {0, 0, 0x25} /* PERCENT SIGN */,
  {0, 0, 0x26} /* AMPERSAND */,
  {0, 0, 0},
  {0, 0, 0x28} /* OPENING PARENTHESIS / LEFT PARENTHESIS */,
  {0, 0, 0x29} /* CLOSING PARENTHESIS / RIGHT PARENTHESIS */,
  {0, 0, 0x2A} /* ASTERISK */,
  {0, 0, 0x2B} /* PLUS SIGN */,
  {0, 0, 0x2C} /* COMMA */,
  {0, 0, 0},
  {0, 0, 0x2E} /* PERIOD, DECIMAL POINT / FULL STOP */,
  {0, 0, 0x2F} /* SLASH / SOLIDUS */,
  {0, 0, 0x30} /* DIGIT ZERO */,
  {0, 0, 0x31} /* DIGIT ONE */,
  {0, 0, 0x32} /* DIGIT TWO */,
  {0, 0, 0x33} /* DIGIT THREE */,
  {0, 0, 0x34} /* DIGIT FOUR */,
  {0, 0, 0x35} /* DIGIT FIVE */,
  {0, 0, 0x36} /* DIGIT SIX */,
  {0, 0, 0x37} /* DIGIT SEVEN */,
  {0, 0, 0x38} /* DIGIT EIGHT */,
  {0, 0, 0x39} /* DIGIT NINE */,
  {0, 0, 0x3A} /* COLON */,
  {0, 0, 0x3B} /* SEMICOLON */,
  {0, 0, 0x3C} /* LESS-THAN SIGN */,
  {0, 0, 0x3D} /* EQUALS SIGN */,
  {0, 0, 0x3E} /* GREATER-THAN SIGN */,
  {0, 0, 0x3F} /* QUESTION MARK */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x5B} /* OPENING SQUARE BRACKET / LEFT SQUARE BRACKET */,
  {0, 0, 0},
  {0, 0, 0x5D} /* CLOSING SQUARE BRACKET / RIGHT SQUARE BRACKET */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {3, 0, 0},
  {2, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {4, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_32page0 = {
  0, marc8r_32page0_dir
};
struct yaz_iconv_trie *marc8r_32ptrs [] = {
 &marc8r_32page0,
 &marc8r_32page1,
 &marc8r_32page2,
 &marc8r_32page3,
0, };

unsigned long yaz_marc8r_32_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, unsigned int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8r_32ptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 94 */
/* PAGE 2 */
struct yaz_iconv_trie_flat marc8r_4Epage2_flat[] = {
  {"\xB0", 0, 0x41}, /* CYRILLIC SMALL LETTER A */
  {"\xB1", 0, 0x42}, /* CYRILLIC SMALL LETTER BE */
  {"\xB4", 0, 0x44}, /* CYRILLIC SMALL LETTER DE */
  {"\xB5", 0, 0x45}, /* CYRILLIC SMALL LETTER IE */
  {"\xB3", 0, 0x47}, /* LOWERCASE GE / CYRILLIC SMALL LETTER GHE */
  {"\xB8", 0, 0x49}, /* LOWERCASE II / CYRILLIC SMALL LETTER I */
  {"\xB9", 0, 0x4A}, /* LOWERCASE SHORT II / CYRILLIC SMALL LETTER SHORT I */
  {"\xBA", 0, 0x4B}, /* CYRILLIC SMALL LETTER KA */
  {"\xBB", 0, 0x4C}, /* CYRILLIC SMALL LETTER EL */
  {"\xBC", 0, 0x4D}, /* CYRILLIC SMALL LETTER EM */
  {"\xBD", 0, 0x4E}, /* CYRILLIC SMALL LETTER EN */
  {"\xBE", 0, 0x4F}, /* CYRILLIC SMALL LETTER O */
  {"\xBF", 0, 0x50}, /* CYRILLIC SMALL LETTER PE */
  {"\xB6", 0, 0x56}, /* CYRILLIC SMALL LETTER ZHE */
  {"\xB2", 0, 0x57}, /* CYRILLIC SMALL LETTER VE */
  {"\xB7", 0, 0x5A}, /* CYRILLIC SMALL LETTER ZE */
  {"\xAE", 0, 0x60}, /* UPPERCASE IU / CYRILLIC CAPITAL LETTER YU */
  {"\x90", 0, 0x61}, /* CYRILLIC CAPITAL LETTER A */
  {"\x91", 0, 0x62}, /* CYRILLIC CAPITAL LETTER BE */
  {"\xA6", 0, 0x63}, /* CYRILLIC CAPITAL LETTER TSE */
  {"\x94", 0, 0x64}, /* CYRILLIC CAPITAL LETTER DE */
  {"\x95", 0, 0x65}, /* CYRILLIC CAPITAL LETTER IE */
  {"\xA4", 0, 0x66}, /* CYRILLIC CAPITAL LETTER EF */
  {"\x93", 0, 0x67}, /* UPPERCASE GE / CYRILLIC CAPITAL LETTER GHE */
  {"\xA5", 0, 0x68}, /* UPPERCASE KHA / CYRILLIC CAPITAL LETTER HA */
  {"\x98", 0, 0x69}, /* UPPERCASE II / CYRILLIC CAPITAL LETTER I */
  {"\x99", 0, 0x6A}, /* UPPERCASE SHORT II / CYRILLIC CAPITAL LETTER SHORT I */
  {"\x9A", 0, 0x6B}, /* CYRILLIC CAPITAL LETTER KA */
  {"\x9B", 0, 0x6C}, /* CYRILLIC CAPITAL LETTER EL */
  {"\x9C", 0, 0x6D}, /* CYRILLIC CAPITAL LETTER EM */
  {"\x9D", 0, 0x6E}, /* CYRILLIC CAPITAL LETTER EN */
  {"\x9E", 0, 0x6F}, /* CYRILLIC CAPITAL LETTER O */
  {"\x9F", 0, 0x70}, /* CYRILLIC CAPITAL LETTER PE */
  {"\xAF", 0, 0x71}, /* UPPERCASE IA / CYRILLIC CAPITAL LETTER YA */
  {"\xA0", 0, 0x72}, /* CYRILLIC CAPITAL LETTER ER */
  {"\xA1", 0, 0x73}, /* CYRILLIC CAPITAL LETTER ES */
  {"\xA2", 0, 0x74}, /* CYRILLIC CAPITAL LETTER TE */
  {"\xA3", 0, 0x75}, /* CYRILLIC CAPITAL LETTER U */
  {"\x96", 0, 0x76}, /* CYRILLIC CAPITAL LETTER ZHE */
  {"\x92", 0, 0x77}, /* CYRILLIC CAPITAL LETTER VE */
  {"\xAC", 0, 0x78}, /* CYRILLIC CAPITAL LETTER SOFT SIGN */
  {"\xAB", 0, 0x79}, /* UPPERCASE YERI / CYRILLIC CAPITAL LETTER YERI */
  {"\x97", 0, 0x7A}, /* CYRILLIC CAPITAL LETTER ZE */
  {"\xA8", 0, 0x7B}, /* CYRILLIC CAPITAL LETTER SHA */
  {"\xAD", 0, 0x7C}, /* CYRILLIC CAPITAL LETTER E */
  {"\xA9", 0, 0x7D}, /* CYRILLIC CAPITAL LETTER SHCHA */
  {"\xA7", 0, 0x7E}, /* CYRILLIC CAPITAL LETTER CHE */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_4Epage2 = {
  marc8r_4Epage2_flat, 0
};
/* PAGE 1 */
struct yaz_iconv_trie_flat marc8r_4Epage1_flat[] = {
  {"\x8E", 0, 0x40}, /* LOWERCASE IU / CYRILLIC SMALL LETTER YU */
  {"\x86", 0, 0x43}, /* CYRILLIC SMALL LETTER TSE */
  {"\x84", 0, 0x46}, /* CYRILLIC SMALL LETTER EF */
  {"\x85", 0, 0x48}, /* LOWERCASE KHA / CYRILLIC SMALL LETTER HA */
  {"\x8F", 0, 0x51}, /* LOWERCASE IA / CYRILLIC SMALL LETTER YA */
  {"\x80", 0, 0x52}, /* CYRILLIC SMALL LETTER ER */
  {"\x81", 0, 0x53}, /* CYRILLIC SMALL LETTER ES */
  {"\x82", 0, 0x54}, /* CYRILLIC SMALL LETTER TE */
  {"\x83", 0, 0x55}, /* CYRILLIC SMALL LETTER U */
  {"\x8C", 0, 0x58}, /* CYRILLIC SMALL LETTER SOFT SIGN */
  {"\x8B", 0, 0x59}, /* LOWERCASE YERI / CYRILLIC SMALL LETTER YERI */
  {"\x88", 0, 0x5B}, /* CYRILLIC SMALL LETTER SHA */
  {"\x8D", 0, 0x5C}, /* LOWERCASE REVERSED E / CYRILLIC SMALL LETTER E */
  {"\x89", 0, 0x5D}, /* CYRILLIC SMALL LETTER SHCHA */
  {"\x87", 0, 0x5E}, /* CYRILLIC SMALL LETTER CHE */
  {"\x8A", 0, 0x5F}, /* CYRILLIC SMALL LETTER HARD SIGN */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_4Epage1 = {
  marc8r_4Epage1_flat, 0
};
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8r_4Epage0_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x21} /* EXCLAMATION MARK */,
  {0, 0, 0x22} /* QUOTATION MARK */,
  {0, 0, 0x23} /* NUMBER SIGN */,
  {0, 0, 0x24} /* DOLLAR SIGN */,
  {0, 0, 0x25} /* PERCENT SIGN */,
  {0, 0, 0x26} /* AMPERSAND */,
  {0, 0, 0x27} /* APOSTROPHE */,
  {0, 0, 0x28} /* OPENING PARENTHESIS / LEFT PARENTHESIS */,
  {0, 0, 0x29} /* CLOSING PARENTHESIS / RIGHT PARENTHESIS */,
  {0, 0, 0x2A} /* ASTERISK */,
  {0, 0, 0x2B} /* PLUS SIGN */,
  {0, 0, 0x2C} /* COMMA */,
  {0, 0, 0x2D} /* HYPHEN-MINUS */,
  {0, 0, 0x2E} /* PERIOD, DECIMAL POINT / FULL STOP */,
  {0, 0, 0x2F} /* SLASH / SOLIDUS */,
  {0, 0, 0x30} /* DIGIT ZERO */,
  {0, 0, 0x31} /* DIGIT ONE */,
  {0, 0, 0x32} /* DIGIT TWO */,
  {0, 0, 0x33} /* DIGIT THREE */,
  {0, 0, 0x34} /* DIGIT FOUR */,
  {0, 0, 0x35} /* DIGIT FIVE */,
  {0, 0, 0x36} /* DIGIT SIX */,
  {0, 0, 0x37} /* DIGIT SEVEN */,
  {0, 0, 0x38} /* DIGIT EIGHT */,
  {0, 0, 0x39} /* DIGIT NINE */,
  {0, 0, 0x3A} /* COLON */,
  {0, 0, 0x3B} /* SEMICOLON */,
  {0, 0, 0x3C} /* LESS-THAN SIGN */,
  {0, 0, 0x3D} /* EQUALS SIGN */,
  {0, 0, 0x3E} /* GREATER-THAN SIGN */,
  {0, 0, 0x3F} /* QUESTION MARK */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {3, 0, 0},
  {2, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_4Epage0 = {
  0, marc8r_4Epage0_dir
};
struct yaz_iconv_trie *marc8r_4Eptrs [] = {
 &marc8r_4Epage0,
 &marc8r_4Epage1,
 &marc8r_4Epage2,
0, };

unsigned long yaz_marc8r_4E_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, unsigned int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8r_4Eptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 42 */
/* PAGE 0 */
struct yaz_iconv_trie_flat marc8r_51page0_flat[] = {
  {"\xD2\x91", 0, 0x40}, /* LOWERCASE GE WITH UPTURN / CYRILLIC SMALL LETTER GHE WITH UPTURN */
  {"\xD1\x92", 0, 0x41}, /* LOWERCASE DJE / CYRILLIC SMALL LETTER DJE (Serbian) */
  {"\xD1\x93", 0, 0x42}, /* CYRILLIC SMALL LETTER GJE */
  {"\xD1\x94", 0, 0x43}, /* LOWERCASE E / CYRILLIC SMALL LETTER UKRAINIAN IE */
  {"\xD1\x91", 0, 0x44}, /* CYRILLIC SMALL LETTER IO */
  {"\xD1\x95", 0, 0x45}, /* CYRILLIC SMALL LETTER DZE */
  {"\xD1\x96", 0, 0x46}, /* LOWERCASE I / CYRILLIC SMALL LETTER BYELORUSSIAN-UKRANIAN I */
  {"\xD1\x97", 0, 0x47}, /* LOWERCASE YI / CYRILLIC SMALL LETTER YI (Ukrainian) */
  {"\xD1\x98", 0, 0x48}, /* CYRILLIC SMALL LETTER JE */
  {"\xD1\x99", 0, 0x49}, /* CYRILLIC SMALL LETTER LJE */
  {"\xD1\x9A", 0, 0x4A}, /* CYRILLIC SMALL LETTER NJE */
  {"\xD1\x9B", 0, 0x4B}, /* LOWERCASE TSHE / CYRILLIC SMALL LETTER TSHE (Serbian) */
  {"\xD1\x9C", 0, 0x4C}, /* CYRILLIC SMALL LETTER KJE */
  {"\xD1\x9E", 0, 0x4D}, /* LOWERCASE SHORT U / CYRILLIC SMALL LETTER SHORT U (Byelorussian) */
  {"\xD1\x9F", 0, 0x4E}, /* CYRILLIC SMALL LETTER DZHE */
  {"\xD1\xA3", 0, 0x50}, /* CYRILLIC SMALL LETTER YAT */
  {"\xD1\xB3", 0, 0x51}, /* CYRILLIC SMALL LETTER FITA */
  {"\xD1\xB5", 0, 0x52}, /* CYRILLIC SMALL LETTER IZHITSA */
  {"\xD1\xAB", 0, 0x53}, /* CYRILLIC SMALL LETTER BIG YUS */
  {"\x5B", 0, 0x5B}, /* OPENING SQUARE BRACKET / LEFT SQUARE BRACKET */
  {"\x5D", 0, 0x5D}, /* CLOSING SQUARE BRACKET / RIGHT SQUARE BRACKET */
  {"\x5F", 0, 0x5F}, /* SPACING UNDERSCORE / LOW LINE */
  {"\xD2\x90", 0, 0x60}, /* UPPERCASE GE WITH UPTURN / CYRILLIC CAPITAL LETTER GHE WITH UPTURN */
  {"\xD0\x82", 0, 0x61}, /* UPPERCASE DJE / CYRILLIC CAPITAL LETTER DJE (Serbian) */
  {"\xD0\x83", 0, 0x62}, /* CYRILLIC CAPITAL LETTER GJE */
  {"\xD0\x84", 0, 0x63}, /* UPPERCASE E / CYRILLIC CAPITAL LETTER UKRAINIAN IE */
  {"\xD0\x81", 0, 0x64}, /* CYRILLIC CAPITAL LETTER IO */
  {"\xD0\x85", 0, 0x65}, /* CYRILLIC CAPITAL LETTER DZE */
  {"\xD0\x86", 0, 0x66}, /* UPPERCASE I / CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRANIAN I */
  {"\xD0\x87", 0, 0x67}, /* UPPERCASE YI / CYRILLIC CAPITAL LETTER YI (Ukrainian) */
  {"\xD0\x88", 0, 0x68}, /* CYRILLIC CAPITAL LETTER JE */
  {"\xD0\x89", 0, 0x69}, /* CYRILLIC CAPITAL LETTER LJE */
  {"\xD0\x8A", 0, 0x6A}, /* CYRILLIC CAPITAL LETTER NJE */
  {"\xD0\x8B", 0, 0x6B}, /* UPPERCASE TSHE / CYRILLIC CAPITAL LETTER TSHE (Serbian) */
  {"\xD0\x8C", 0, 0x6C}, /* CYRILLIC CAPITAL LETTER KJE */
  {"\xD0\x8E", 0, 0x6D}, /* UPPERCASE SHORT U / CYRILLIC CAPITAL LETTER SHORT U (Byelorussian) */
  {"\xD0\x8F", 0, 0x6E}, /* CYRILLIC CAPITAL LETTER DZHE */
  {"\xD0\xAA", 0, 0x6F}, /* CYRILLIC CAPITAL LETTER HARD SIGN */
  {"\xD1\xA2", 0, 0x70}, /* CYRILLIC CAPITAL LETTER YAT */
  {"\xD1\xB2", 0, 0x71}, /* CYRILLIC CAPITAL LETTER FITA */
  {"\xD1\xB4", 0, 0x72}, /* CYRILLIC CAPITAL LETTER IZHITSA */
  {"\xD1\xAA", 0, 0x73}, /* CYRILLIC CAPITAL LETTER BIG YUS */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_51page0 = {
  marc8r_51page0_flat, 0
};
struct yaz_iconv_trie *marc8r_51ptrs [] = {
 &marc8r_51page0,
0, };

unsigned long yaz_marc8r_51_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, unsigned int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8r_51ptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 83 */
/* PAGE 3 */
struct yaz_iconv_trie_flat marc8r_33page3_flat[] = {
  {"\x80\x9D", 0, 0x79}, /* RIGHT DOUBLE QUOTATION MARK */
  {"\x80\x9C", 0, 0x7A}, /* LEFT DOUBLE QUOTATION MARK */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_33page3 = {
  marc8r_33page3_flat, 0
};
/* PAGE 2 */
struct yaz_iconv_trie_flat marc8r_33page2_flat[] = {
  {"\x8C", 0, 0x2C}, /* ARABIC COMMA */
  {"\x9B", 0, 0x3B}, /* ARABIC SEMICOLON */
  {"\x9F", 0, 0x3F}, /* ARABIC QUESTION MARK */
  {"\xA1", 0, 0x41}, /* HAMZAH / ARABIC LETTER HAMZA */
  {"\xA2", 0, 0x42}, /* ARABIC LETTER ALEF WITH MADDA ABOVE */
  {"\xA3", 0, 0x43}, /* ARABIC LETTER ALEF WITH HAMZA ABOVE */
  {"\xA4", 0, 0x44}, /* ARABIC LETTER WAW WITH HAMZA ABOVE */
  {"\xA5", 0, 0x45}, /* ARABIC LETTER ALEF WITH HAMZA BELOW */
  {"\xA6", 0, 0x46}, /* ARABIC LETTER YEH WITH HAMZA ABOVE */
  {"\xA7", 0, 0x47}, /* ARABIC LETTER ALEF */
  {"\xA8", 0, 0x48}, /* ARABIC LETTER BEH */
  {"\xA9", 0, 0x49}, /* ARABIC LETTER TEH MARBUTA */
  {"\xAA", 0, 0x4A}, /* ARABIC LETTER TEH */
  {"\xAB", 0, 0x4B}, /* ARABIC LETTER THEH */
  {"\xAC", 0, 0x4C}, /* ARABIC LETTER JEEM */
  {"\xAD", 0, 0x4D}, /* ARABIC LETTER HAH */
  {"\xAE", 0, 0x4E}, /* ARABIC LETTER KHAH */
  {"\xAF", 0, 0x4F}, /* ARABIC LETTER DAL */
  {"\xB0", 0, 0x50}, /* ARABIC LETTER THAL */
  {"\xB1", 0, 0x51}, /* ARABIC LETTER REH */
  {"\xB2", 0, 0x52}, /* ARABIC LETTER ZAIN */
  {"\xB3", 0, 0x53}, /* ARABIC LETTER SEEN */
  {"\xB4", 0, 0x54}, /* ARABIC LETTER SHEEN */
  {"\xB5", 0, 0x55}, /* ARABIC LETTER SAD */
  {"\xB6", 0, 0x56}, /* ARABIC LETTER DAD */
  {"\xB7", 0, 0x57}, /* ARABIC LETTER TAH */
  {"\xB8", 0, 0x58}, /* ARABIC LETTER ZAH */
  {"\xB9", 0, 0x59}, /* ARABIC LETTER AIN */
  {"\xBA", 0, 0x5A}, /* ARABIC LETTER GHAIN */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_33page2 = {
  marc8r_33page2_flat, 0
};
/* PAGE 1 */
struct yaz_iconv_trie_flat marc8r_33page1_flat[] = {
  {"\xAA", 0, 0x25}, /* PERCENT SIGN / ARABIC PERCENT SIGN */
  {"\xAD", 0, 0x2A}, /* ASTERISK / ARABIC FIVE POINTED STAR */
  {"\xA0", 0, 0x30}, /* ARABIC-INDIC DIGIT ZERO */
  {"\xA1", 0, 0x31}, /* ARABIC-INDIC DIGIT ONE */
  {"\xA2", 0, 0x32}, /* ARABIC-INDIC DIGIT TWO */
  {"\xA3", 0, 0x33}, /* ARABIC-INDIC DIGIT THREE */
  {"\xA4", 0, 0x34}, /* ARABIC-INDIC DIGIT FOUR */
  {"\xA5", 0, 0x35}, /* ARABIC-INDIC DIGIT FIVE */
  {"\xA6", 0, 0x36}, /* ARABIC-INDIC DIGIT SIX */
  {"\xA7", 0, 0x37}, /* ARABIC-INDIC DIGIT SEVEN */
  {"\xA8", 0, 0x38}, /* ARABIC-INDIC DIGIT EIGHT */
  {"\xA9", 0, 0x39}, /* ARABIC-INDIC DIGIT NINE */
  {"\x80", 0, 0x60}, /* ARABIC TATWEEL */
  {"\x81", 0, 0x61}, /* ARABIC LETTER FEH */
  {"\x82", 0, 0x62}, /* ARABIC LETTER QAF */
  {"\x83", 0, 0x63}, /* ARABIC LETTER KAF */
  {"\x84", 0, 0x64}, /* ARABIC LETTER LAM */
  {"\x85", 0, 0x65}, /* ARABIC LETTER MEEM */
  {"\x86", 0, 0x66}, /* ARABIC LETTER NOON */
  {"\x87", 0, 0x67}, /* ARABIC LETTER HEH */
  {"\x88", 0, 0x68}, /* ARABIC LETTER WAW */
  {"\x89", 0, 0x69}, /* ARABIC LETTER ALEF MAKSURA */
  {"\x8A", 0, 0x6A}, /* ARABIC LETTER YEH */
  {"\x8B", 1, 0x6B}, /* ARABIC FATHATAN */
  {"\x8C", 1, 0x6C}, /* ARABIC DAMMATAN */
  {"\x8D", 1, 0x6D}, /* ARABIC KASRATAN */
  {"\x8E", 1, 0x6E}, /* ARABIC FATHA */
  {"\x8F", 1, 0x6F}, /* ARABIC DAMMA */
  {"\x90", 1, 0x70}, /* ARABIC KASRA */
  {"\x91", 1, 0x71}, /* ARABIC SHADDA */
  {"\x92", 1, 0x72}, /* ARABIC SUKUN */
  {"\xB1", 0, 0x73}, /* ARABIC LETTER ALEF WASLA */
  {"\xB0", 0, 0x74}, /* ARABIC LETTER SUPERSCRIPT ALEF */
  {"\xAC", 0, 0x78}, /* ARABIC THOUSANDS SEPARATOR */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_33page1 = {
  marc8r_33page1_flat, 0
};
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8r_33page0_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x21} /* EXCLAMATION MARK */,
  {0, 0, 0x22} /* QUOTATION MARK */,
  {0, 0, 0x23} /* NUMBER SIGN */,
  {0, 0, 0x24} /* DOLLAR SIGN */,
  {0, 0, 0},
  {0, 0, 0x26} /* AMPERSAND */,
  {0, 0, 0x27} /* APOSTROPHE */,
  {0, 0, 0x28} /* OPENING PARENTHESIS / LEFT PARENTHESIS */,
  {0, 0, 0x29} /* CLOSING PARENTHESIS / RIGHT PARENTHESIS */,
  {0, 0, 0},
  {0, 0, 0x2B} /* PLUS SIGN */,
  {0, 0, 0},
  {0, 0, 0x2D} /* HYPHEN-MINUS */,
  {0, 0, 0x2E} /* PERIOD, DECIMAL POINT / FULL STOP */,
  {0, 0, 0x2F} /* SLASH / SOLIDUS */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x3A} /* COLON */,
  {0, 0, 0},
  {0, 0, 0x3C} /* LESS-THAN SIGN */,
  {0, 0, 0x3D} /* EQUALS SIGN */,
  {0, 0, 0x3E} /* GREATER-THAN SIGN */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x5B} /* OPENING SQUARE BRACKET / LEFT SQUARE BRACKET */,
  {0, 0, 0},
  {0, 0, 0x5D} /* CLOSING SQUARE BRACKET / RIGHT SQUARE BRACKET */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {3, 0, 0},
  {2, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {4, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_33page0 = {
  0, marc8r_33page0_dir
};
struct yaz_iconv_trie *marc8r_33ptrs [] = {
 &marc8r_33page0,
 &marc8r_33page1,
 &marc8r_33page2,
 &marc8r_33page3,
0, };

unsigned long yaz_marc8r_33_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, unsigned int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8r_33ptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 90 */
/* PAGE 4 */
struct yaz_iconv_trie_flat marc8r_34page4_flat[] = {
  {"\x86", 1, 0x7D}, /* SHORT E / COMBINING BREVE */
  {"\x8C", 1, 0x7E}, /* SHORT U / COMBINING CARON */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_34page4 = {
  marc8r_34page4_flat, 0
};
/* PAGE 3 */
struct yaz_iconv_trie_dir marc8r_34page3_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x2B} /* ARABIC LETTER BEHEH */,
  {0, 0, 0x2C} /* ARABIC LETTER HAH WITH HAMZA ABOVE */,
  {0, 0, 0x2D} /* ARABIC LETTER HAH WITH TWO ABOVE DOTS VERTICAL ABOVE */,
  {0, 0, 0x2E} /* ARABIC LETTER NYEH */,
  {0, 0, 0x2F} /* ARABIC LETTER DYEH */,
  {0, 0, 0x30} /* ARABIC LETTER HAH WITH THREE DOTS ABOVE */,
  {0, 0, 0x31} /* ARABIC LETTER TCHEH */,
  {0, 0, 0x33} /* ARABIC LETTER TCHEHEH */,
  {0, 0, 0x34} /* ARABIC LETTER DDAL */,
  {0, 0, 0x35} /* ARABIC LETTER DAL WITH RING */,
  {0, 0, 0x36} /* ARABIC LETTER DAL WITH DOT BELOW */,
  {0, 0, 0x37} /* ARABIC LETTER DAL WITH DOT BELOW AND SMALL TAH */,
  {0, 0, 0x38} /* ARABIC LETTER DAHAL */,
  {0, 0, 0x39} /* ARABIC LETTER DDAHAL */,
  {0, 0, 0x3A} /* ARABIC LETTER DUL */,
  {0, 0, 0x3B} /* ARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDS */,
  {0, 0, 0x3C} /* ARABIC LETTER DAL WITH FOUR DOTS ABOVE */,
  {0, 0, 0x3D} /* ARABIC LETTER RREH */,
  {0, 0, 0x3E} /* ARABIC LETTER REH WITH SMALL V */,
  {0, 0, 0x3F} /* ARABIC LETTER REH WITH RING */,
  {0, 0, 0x40} /* ARABIC LETTER REH WITH DOT BELOW */,
  {0, 0, 0x41} /* ARABIC LETTER REH WITH SMALL V BELOW */,
  {0, 0, 0x42} /* ARABIC LETTER REH WITH DOT BELOW AND DOT ABOVE */,
  {0, 0, 0x43} /* ARABIC LETTER REH WITH TWO DOTS ABOVE */,
  {0, 0, 0x44} /* ARABIC LETTER JEH */,
  {0, 0, 0x45} /* ARABIC LETTER REH WITH FOUR DOTS ABOVE */,
  {0, 0, 0x46} /* ARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVE */,
  {0, 0, 0x47} /* ARABIC LETTER SEEN WITH THREE DOTS BELOW */,
  {0, 0, 0x48} /* ARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS ABOVE */,
  {0, 0, 0x4A} /* ARABIC LETTER SAD WITH TWO DOTS BELOW */,
  {0, 0, 0x4B} /* ARABIC LETTER SAD WITH THREE DOTS ABOVE */,
  {0, 0, 0x4D} /* ARABIC LETTER TAH WITH THREE DOTS ABOVE */,
  {0, 0, 0x4E} /* ARABIC LETTER AIN WITH THREE DOTS ABOVE */,
  {0, 0, 0x50} /* ARABIC LETTER DOTLESS FEH */,
  {0, 0, 0x51} /* ARABIC LETTER FEH WITH DOT MOVED BELOW */,
  {0, 0, 0x52} /* ARABIC LETTER FEH WITH DOT BELOW */,
  {0, 0, 0x53} /* ARABIC LETTER VEH */,
  {0, 0, 0x54} /* ARABIC LETTER FEH WITH THREE DOTS BELOW */,
  {0, 0, 0x55} /* ARABIC LETTER PEHEH */,
  {0, 0, 0x56} /* ARABIC LETTER QAF WITH DOT ABOVE */,
  {0, 0, 0x57} /* ARABIC LETTER QAF WITH THREE DOTS ABOVE */,
  {0, 0, 0x58} /* ARABIC LETTER KEHEH */,
  {0, 0, 0x59} /* ARABIC LETTER SWASH KAF */,
  {0, 0, 0x5A} /* ARABIC LETTER KAF WITH RING */,
  {0, 0, 0x5B} /* ARABIC LETTER KAF WITH DOT ABOVE */,
  {0, 0, 0x5C} /* ARABIC LETTER NG */,
  {0, 0, 0x5D} /* ARABIC LETTER KAF WITH THREE DOTS BELOW */,
  {0, 0, 0x5E} /* ARABIC LETTER GAF */,
  {0, 0, 0x5F} /* ARABIC LETTER GAF WITH RING */,
  {0, 0, 0x60} /* ARABIC LETTER NGOEH */,
  {0, 0, 0x61} /* ARABIC LETTER GAF WITH TWO DOTS BELOW */,
  {0, 0, 0x62} /* ARABIC LETTER GUEH */,
  {0, 0, 0x63} /* ARABIC LETTER GAF WITH THREE DOTS ABOVE */,
  {0, 0, 0x64} /* ARABIC LETTER LAM WITH SMALL V */,
  {0, 0, 0x65} /* ARABIC LETTER LAM WITH DOT ABOVE */,
  {0, 0, 0x66} /* ARABIC LETTER LAM WITH THREE DOTS ABOVE */,
  {0, 0, 0x67} /* ARABIC LETTER LAM WITH THREE DOTS BELOW */,
  {0, 0, 0x6C} /* ARABIC LETTER NOON WITH DOT BELOW */,
  {0, 0, 0x68} /* ARABIC LETTER NOON GHUNNA */,
  {0, 0, 0x69} /* ARABIC LETTER RNOON */,
  {0, 0, 0x6A} /* ARABIC LETTER NOON WITH RING */,
  {0, 0, 0x6B} /* ARABIC LETTER NOON WITH THREE DOTS ABOVE */,
  {0, 0, 0x6D} /* ARABIC LETTER HEH DOACHASHMEE */,
  {0, 0, 0x32} /* ARABIC LETTER TCHEH WITH DOT ABOVE */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_34page3 = {
  0, marc8r_34page3_dir
};
/* PAGE 2 */
struct yaz_iconv_trie_flat marc8r_34page2_flat[] = {
  {"\xB2", 0, 0x22}, /* ARABIC LETTER ALEF WITH WAVY HAMZA ABOVE */
  {"\xB3", 0, 0x23}, /* ARABIC LETTER ALEF WITH WAVY HAMZA BELOW */
  {"\xB9", 0, 0x24}, /* ARABIC LETTER TTEH */
  {"\xBA", 0, 0x25}, /* ARABIC LETTER TTEHEH */
  {"\xBB", 0, 0x26}, /* ARABIC LETTER BBEH */
  {"\xBC", 0, 0x27}, /* ARABIC LETTER TEH WITH RING */
  {"\xBD", 0, 0x28}, /* ARABIC LETTER TEH WITH THREE DOTS ABOVE DOWNWARDS */
  {"\xBE", 0, 0x29}, /* ARABIC LETTER PEH */
  {"\xBF", 0, 0x2A}, /* ARABIC LETTER TEHEH */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_34page2 = {
  marc8r_34page2_flat, 0
};
/* PAGE 1 */
struct yaz_iconv_trie_flat marc8r_34page1_flat[] = {
  {"\xBD", 0, 0x21}, /* DOUBLE ALEF WITH HAMZA ABOVE / ARABIC SIGN SINDHI AMPERSAND */
  {"\xBA", 0, 0x49}, /* ARABIC LETTER SHEEN WITH DOT BELOW */
  {"\xBB", 0, 0x4C}, /* ARABIC LETTER DAD WITH DOT BELOW */
  {"\xBC", 0, 0x4F}, /* ARABIC LETTER GHAIN WITH DOT BELOW */
  {"\x80", 0, 0x6E}, /* HEH WITH HAMZA ABOVE / ARABIC LETTER HEH WITH YEH ABOVE */
  {"\x84", 0, 0x6F}, /* ARABIC LETTER WAW WITH RING */
  {"\x85", 0, 0x70}, /* KYRGHYZ OE / ARABIC LETTER KIRGHIZ OE */
  {"\x86", 0, 0x71}, /* ARABIC LETTER OE */
  {"\x8A", 0, 0x72}, /* ARABIC LETTER WAW WITH TWO DOTS ABOVE */
  {"\x8B", 0, 0x73}, /* ARABIC LETTER VE */
  {"\x8D", 0, 0x74}, /* ARABIC LETTER YEH WITH TAIL */
  {"\x8E", 0, 0x75}, /* ARABIC LETTER YEH WITH SMALL V */
  {"\x90", 0, 0x76}, /* ARABIC LETTER E */
  {"\x92", 0, 0x77}, /* ARABIC LETTER YEH BARREE */
  {"\x93", 0, 0x78}, /* ARABIC LETTER YEH BARREE WITH HAMZA ABOVE */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_34page1 = {
  marc8r_34page1_flat, 0
};
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8r_34page0_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {5, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {3, 0, 0},
  {4, 0, 0},
  {2, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_34page0 = {
  0, marc8r_34page0_dir
};
struct yaz_iconv_trie *marc8r_34ptrs [] = {
 &marc8r_34page0,
 &marc8r_34page1,
 &marc8r_34page2,
 &marc8r_34page3,
 &marc8r_34page4,
0, };

unsigned long yaz_marc8r_34_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, unsigned int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8r_34ptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 73 */
/* PAGE 6 */
struct yaz_iconv_trie_flat marc8r_53page6_flat[] = {
  {"\x9A", 0, 0x47}, /* GREEK LETTER STIGMA */
  {"\x9C", 0, 0x48}, /* GREEK LETTER DIGAMMA */
  {"\x9E", 0, 0x54}, /* GREEK LETTER KOPPA */
  {"\xA0", 0, 0x5E}, /* GREEK LETTER SAMPI */
  {"\x90", 0, 0x63}, /* GREEK BETA SYMBOL / SMALL LETTER BETA MIDDLE OF WORD */
  {"\x9B", 0, 0x67}, /* GREEK SMALL LETTER STIGMA */
  {"\x9D", 0, 0x68}, /* GREEK SMALL LETTER DIGAMMA */
  {"\x80", 0, 0x73}, /* GREEK SMALL LETTER PI */
  {"\x9F", 0, 0x74}, /* GREEK SMALL LETTER KOPPA */
  {"\x81", 0, 0x75}, /* GREEK SMALL LETTER RHO */
  {"\x83", 0, 0x76}, /* GREEK SMALL LETTER SIGMA */
  {"\x82", 0, 0x77}, /* GREEK SMALL LETTER FINAL SIGMA / SMALL LETTER SIGMA END OF WORD */
  {"\x84", 0, 0x78}, /* GREEK SMALL LETTER TAU */
  {"\x85", 0, 0x79}, /* GREEK SMALL LETTER UPSILON */
  {"\x86", 0, 0x7A}, /* GREEK SMALL LETTER PHI */
  {"\x87", 0, 0x7B}, /* GREEK SMALL LETTER CHI */
  {"\x88", 0, 0x7C}, /* GREEK SMALL LETTER PSI */
  {"\x89", 0, 0x7D}, /* GREEK SMALL LETTER OMEGA */
  {"\xA1", 0, 0x7E}, /* GREEK SMALL LETTER SAMPI */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_53page6 = {
  marc8r_53page6_flat, 0
};
/* PAGE 5 */
struct yaz_iconv_trie_flat marc8r_53page5_flat[] = {
  {"\x87", 0, 0x3B}, /* GREEK ANO TELEIA / RAISED DOT, GREEK SEMICOLON */
  {"\x91", 0, 0x41}, /* GREEK CAPITAL LETTER ALPHA */
  {"\x92", 0, 0x42}, /* GREEK CAPITAL LETTER BETA */
  {"\x93", 0, 0x44}, /* GREEK CAPITAL LETTER GAMMA */
  {"\x94", 0, 0x45}, /* GREEK CAPITAL LETTER DELTA */
  {"\x95", 0, 0x46}, /* GREEK CAPITAL LETTER EPSILON */
  {"\x96", 0, 0x49}, /* GREEK CAPITAL LETTER ZETA */
  {"\x97", 0, 0x4A}, /* GREEK CAPITAL LETTER ETA */
  {"\x98", 0, 0x4B}, /* GREEK CAPITAL LETTER THETA */
  {"\x99", 0, 0x4C}, /* GREEK CAPITAL LETTER IOTA */
  {"\x9A", 0, 0x4D}, /* GREEK CAPITAL LETTER KAPPA */
  {"\x9B", 0, 0x4E}, /* GREEK CAPITAL LETTER LAMDA */
  {"\x9C", 0, 0x4F}, /* GREEK CAPITAL LETTER MU */
  {"\x9D", 0, 0x50}, /* GREEK CAPITAL LETTER NU */
  {"\x9E", 0, 0x51}, /* GREEK CAPITAL LETTER XI */
  {"\x9F", 0, 0x52}, /* GREEK CAPITAL LETTER OMICRON */
  {"\xA0", 0, 0x53}, /* GREEK CAPITAL LETTER PI */
  {"\xA1", 0, 0x55}, /* GREEK CAPITAL LETTER RHO */
  {"\xA3", 0, 0x56}, /* GREEK CAPITAL LETTER SIGMA */
  {"\xA4", 0, 0x58}, /* GREEK CAPITAL LETTER TAU */
  {"\xA5", 0, 0x59}, /* GREEK CAPITAL LETTER UPSILON */
  {"\xA6", 0, 0x5A}, /* GREEK CAPITAL LETTER PHI */
  {"\xA7", 0, 0x5B}, /* GREEK CAPITAL LETTER CHI */
  {"\xA8", 0, 0x5C}, /* GREEK CAPITAL LETTER PSI */
  {"\xA9", 0, 0x5D}, /* GREEK CAPITAL LETTER OMEGA */
  {"\xB1", 0, 0x61}, /* GREEK SMALL LETTER ALPHA */
  {"\xB2", 0, 0x62}, /* GREEK SMALL LETTER BETA / SMALL LETTER BETA BEGINNING OF WORD */
  {"\xB3", 0, 0x64}, /* GREEK SMALL LETTER GAMMA */
  {"\xB4", 0, 0x65}, /* GREEK SMALL LETTER DELTA */
  {"\xB5", 0, 0x66}, /* GREEK SMALL LETTER EPSILON */
  {"\xB6", 0, 0x69}, /* GREEK SMALL LETTER ZETA */
  {"\xB7", 0, 0x6A}, /* GREEK SMALL LETTER ETA */
  {"\xB8", 0, 0x6B}, /* GREEK SMALL LETTER THETA */
  {"\xB9", 0, 0x6C}, /* GREEK SMALL LETTER IOTA */
  {"\xBA", 0, 0x6D}, /* GREEK SMALL LETTER KAPPA */
  {"\xBB", 0, 0x6E}, /* GREEK SMALL LETTER LAMDA */
  {"\xBC", 0, 0x6F}, /* GREEK SMALL LETTER MU */
  {"\xBD", 0, 0x70}, /* GREEK SMALL LETTER NU */
  {"\xBE", 0, 0x71}, /* GREEK SMALL LETTER XI */
  {"\xBF", 0, 0x72}, /* GREEK SMALL LETTER OMICRON */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_53page5 = {
  marc8r_53page5_flat, 0
};
/* PAGE 4 */
struct yaz_iconv_trie_flat marc8r_53page4_flat[] = {
  {"\x80\x9C", 0, 0x32}, /* LEFT DOUBLE QUOTATION MARK */
  {"\x80\x9D", 0, 0x33}, /* RIGHT DOUBLE QUOTATION MARK */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_53page4 = {
  marc8r_53page4_flat, 0
};
/* PAGE 3 */
struct yaz_iconv_trie_flat marc8r_53page3_flat[] = {
  {"\xAB", 0, 0x30}, /* LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */
  {"\xBB", 0, 0x31}, /* RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_53page3 = {
  marc8r_53page3_flat, 0
};
/* PAGE 2 */
struct yaz_iconv_trie_flat marc8r_53page2_flat[] = {
  {"\x82", 1, 0x24}, /* COMBINING GREEK PERISPOMENI / CIRCUMFLEX */
  {"\x85", 1, 0x27}, /* COMBINING GREEK YPOGEGRAMMENI / IOTA SUBSCRIPT */
  {"\xB4", 0, 0x34}, /* GREEK NUMERAL SIGN / UPPER PRIME */
  {"\xB5", 0, 0x35}, /* GREEK LOWER NUMERAL SIGN / LOWER PRIME */
  {"\xBE", 0, 0x3F}, /* GREEK QUESTION MARK */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_53page2 = {
  marc8r_53page2_flat, 0
};
/* PAGE 1 */
struct yaz_iconv_trie_flat marc8r_53page1_flat[] = {
  {"\x80", 1, 0x21}, /* COMBINING GRAVE ACCENT */
  {"\x81", 1, 0x22}, /* COMBINING ACUTE ACCENT */
  {"\x88", 1, 0x23}, /* COMBINING DIAERESIS */
  {"\x93", 1, 0x25}, /* COMBINING COMMA ABOVE / SMOOTH BREATHING */
  {"\x94", 1, 0x26}, /* COMBINING REVERSED COMMA ABOVE / ROUGH BREATHING */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_53page1 = {
  marc8r_53page1_flat, 0
};
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8r_53page0_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {4, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {2, 0, 0},
  {3, 0, 0},
  {6, 0, 0},
  {7, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {5, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_53page0 = {
  0, marc8r_53page0_dir
};
struct yaz_iconv_trie *marc8r_53ptrs [] = {
 &marc8r_53page0,
 &marc8r_53page1,
 &marc8r_53page2,
 &marc8r_53page3,
 &marc8r_53page4,
 &marc8r_53page5,
 &marc8r_53page6,
0, };

unsigned long yaz_marc8r_53_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, unsigned int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8r_53ptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 15800 */
/* PAGE 526 */
struct yaz_iconv_trie_flat marc8r_31page526_flat[] = {
  {"\x80", 0, 0x6F764E}, /* Korean hangul (ancient) */
  {"\x81", 0, 0x6F764F}, /* Korean hangul (ancient) */
  {"\x82", 0, 0x6F7650}, /* Korean hangul (ancient) */
  {"\x83", 0, 0x6F7651}, /* Korean hangul (ancient) */
  {"\x84", 0, 0x6F7652}, /* Korean hangul (ancient) */
  {"\x85", 0, 0x6F7653}, /* Korean hangul (ancient) */
  {"\x86", 0, 0x6F7654}, /* Korean hangul (ancient) */
  {"\x87", 0, 0x6F7655}, /* Korean hangul (ancient) */
  {"\x88", 0, 0x6F7656}, /* Korean hangul (ancient) */
  {"\x89", 0, 0x6F7657}, /* Korean hangul (ancient) */
  {"\x8A", 0, 0x6F7723}, /* Korean hangul */
  {"\x90", 0, 0x212A21}, /* EACC component character */
  {"\x91", 0, 0x212A22}, /* EACC component character */
  {"\x92", 0, 0x212A23}, /* EACC component character */
  {"\x93", 0, 0x212A24}, /* EACC component character */
  {"\x94", 0, 0x212A25}, /* EACC component character */
  {"\x95", 0, 0x212A26}, /* EACC component character */
  {"\x96", 0, 0x212A28}, /* EACC component character */
  {"\x97", 0, 0x212A29}, /* EACC component character */
  {"\x98", 0, 0x212A2A}, /* EACC component character */
  {"\x99", 0, 0x212A2B}, /* EACC component character */
  {"\x9A", 0, 0x212A2C}, /* EACC component character */
  {"\x9B", 0, 0x212A2D}, /* EACC component character */
  {"\x9C", 0, 0x212A2E}, /* EACC component character */
  {"\x9D", 0, 0x212A2F}, /* EACC component character */
  {"\x9E", 0, 0x212A30}, /* EACC component character */
  {"\x9F", 0, 0x212A32}, /* EACC component character */
  {"\xA0", 0, 0x212A33}, /* EACC component character */
  {"\xA1", 0, 0x212A34}, /* EACC component character */
  {"\xA2", 0, 0x212A35}, /* EACC component character */
  {"\xA3", 0, 0x212A36}, /* EACC component character */
  {"\xA4", 0, 0x212A37}, /* EACC component character */
  {"\xA5", 0, 0x212A38}, /* EACC component character */
  {"\xA6", 0, 0x212A39}, /* EACC component character */
  {"\xA7", 0, 0x212A3A}, /* EACC component character */
  {"\xA8", 0, 0x212A3B}, /* EACC component character */
  {"\xA9", 0, 0x212A3C}, /* EACC component character */
  {"\xAA", 0, 0x212A3D}, /* EACC component character */
  {"\xAB", 0, 0x212A3E}, /* EACC component character */
  {"\xAC", 0, 0x212A3F}, /* EACC component character */
  {"\xAD", 0, 0x212A40}, /* EACC component character */
  {"\xAE", 0, 0x212A41}, /* EACC component character */
  {"\xAF", 0, 0x212A42}, /* EACC component character */
  {"\xB0", 0, 0x212A43}, /* EACC component character */
  {"\xB1", 0, 0x212A44}, /* EACC component character */
  {"\xB2", 0, 0x212A45}, /* EACC component character */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page526 = {
  marc8r_31page526_flat, 0
};
/* PAGE 525 */
struct yaz_iconv_trie_flat marc8r_31page525_flat[] = {
  {"\xB0", 0, 0x6F7624}, /* Korean hangul (ancient) */
  {"\xB2", 0, 0x6F7640}, /* Korean hangul (ancient) */
  {"\xB3", 0, 0x6F7641}, /* Korean hangul (ancient) */
  {"\xB4", 0, 0x6F7642}, /* Korean hangul (ancient) */
  {"\xB5", 0, 0x6F7643}, /* Korean hangul (ancient) */
  {"\xB6", 0, 0x6F7644}, /* Korean hangul (ancient) */
  {"\xB7", 0, 0x6F7645}, /* Korean hangul (ancient) */
  {"\xB8", 0, 0x6F7646}, /* Korean hangul (ancient) */
  {"\xB9", 0, 0x6F7647}, /* Korean hangul (ancient) */
  {"\xBA", 0, 0x6F7648}, /* Korean hangul (ancient) */
  {"\xBB", 0, 0x6F7649}, /* Korean hangul (ancient) */
  {"\xBC", 0, 0x6F764A}, /* Korean hangul (ancient) */
  {"\xBD", 0, 0x6F764B}, /* Korean hangul (ancient) */
  {"\xBE", 0, 0x6F764C}, /* Korean hangul (ancient) */
  {"\xBF", 0, 0x6F764D}, /* Korean hangul (ancient) */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page525 = {
  marc8r_31page525_flat, 0
};
/* PAGE 524 */
struct yaz_iconv_trie_flat marc8r_31page524_flat[] = {
  {"\xBC\x88", 0, 0x212328}, /* Ideographic left parenthesis */
  {"\xBC\x89", 0, 0x212329}, /* Ideographic right parenthesis */
  {"\xBC\x8D", 0, 0x21232D}, /* Ideographic hyphen minus */
  {"\xBC\xBB", 0, 0x212B31}, /* Ideographic left square bracket */
  {"\xBC\xBD", 0, 0x212B32}, /* Ideographic right square bracket */
  {"\xBC\x8E", 0, 0x212B34}, /* Ideographic variant full stop */
  {"\xBC\x8C", 0, 0x212B38}, /* Ideographic variant comma */
  {"\xBC\x9B", 0, 0x212B39}, /* Ideographic semicolon */
  {"\xBC\x9A", 0, 0x212B3A}, /* Ideographic colon */
  {"\xBC\x9F", 0, 0x212B3B}, /* Ideographic question mark */
  {"\xBC\x81", 0, 0x212B3D}, /* Ideographic exclamation point */
  {"\xBC\x8F", 0, 0x212B59}, /* Ideographic solidus */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page524 = {
  marc8r_31page524_flat, 0
};
/* PAGE 523 */
struct yaz_iconv_trie_dir marc8r_31page523_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {526, 0, 0},
  {527, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page523 = {
  0, marc8r_31page523_dir
};
/* PAGE 522 */
struct yaz_iconv_trie_flat marc8r_31page522_flat[] = {
  {"\x81", 0, 0x6F7621}, /* Korean hangul */
  {"\x86", 0, 0x6F7622}, /* Korean hangul */
  {"\x8D", 0, 0x6F7625}, /* Korean hangul (ancient) */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page522 = {
  marc8r_31page522_flat, 0
};
/* PAGE 521 */
struct yaz_iconv_trie_flat marc8r_31page521_flat[] = {
  {"\x88", 0, 0x6F5D78}, /* Korean hangul */
  {"\x89", 0, 0x6F5D79}, /* Korean hangul */
  {"\x8C", 0, 0x6F5D7A}, /* Korean hangul */
  {"\x90", 0, 0x6F5D7B}, /* Korean hangul */
  {"\x98", 0, 0x6F5D7C}, /* Korean hangul */
  {"\x99", 0, 0x6F5D7D}, /* Korean hangul */
  {"\x9B", 0, 0x6F5D7E}, /* Korean hangul */
  {"\x9D", 0, 0x6F5E21}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page521 = {
  marc8r_31page521_flat, 0
};
/* PAGE 520 */
struct yaz_iconv_trie_flat marc8r_31page520_flat[] = {
  {"\x84", 0, 0x6F5D68}, /* Korean hangul */
  {"\x89", 0, 0x6F5D69}, /* Korean hangul */
  {"\x90", 0, 0x6F5D6A}, /* Korean hangul */
  {"\x91", 0, 0x6F5D6B}, /* Korean hangul */
  {"\x94", 0, 0x6F5D6C}, /* Korean hangul */
  {"\x97", 0, 0x6F5D6D}, /* Korean hangul */
  {"\x98", 0, 0x6F5D6E}, /* Korean hangul */
  {"\x99", 0, 0x6F5D6F}, /* Korean hangul */
  {"\xA0", 0, 0x6F5D70}, /* Korean hangul */
  {"\xA1", 0, 0x6F5D71}, /* Korean hangul */
  {"\xA3", 0, 0x6F5D72}, /* Korean hangul */
  {"\xA5", 0, 0x6F5D73}, /* Korean hangul */
  {"\xA9", 0, 0x6F5D74}, /* Korean hangul */
  {"\xAC", 0, 0x6F5D75}, /* Korean hangul */
  {"\xB0", 0, 0x6F5D76}, /* Korean hangul */
  {"\xB4", 0, 0x6F5D77}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page520 = {
  marc8r_31page520_flat, 0
};
/* PAGE 519 */
struct yaz_iconv_trie_flat marc8r_31page519_flat[] = {
  {"\x80", 0, 0x6F5D5C}, /* Korean hangul */
  {"\x91", 0, 0x6F5D5D}, /* Korean hangul */
  {"\x98", 0, 0x6F5D5E}, /* Korean hangul */
  {"\x99", 0, 0x6F5D5F}, /* Korean hangul */
  {"\x9C", 0, 0x6F5D60}, /* Korean hangul */
  {"\xA0", 0, 0x6F5D61}, /* Korean hangul */
  {"\xA8", 0, 0x6F5D62}, /* Korean hangul */
  {"\xA9", 0, 0x6F5D63}, /* Korean hangul */
  {"\xAD", 0, 0x6F5D65}, /* Korean hangul */
  {"\xB4", 0, 0x6F5D66}, /* Korean hangul */
  {"\xBC", 0, 0x6F5D67}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page519 = {
  marc8r_31page519_flat, 0
};
/* PAGE 518 */
struct yaz_iconv_trie_flat marc8r_31page518_flat[] = {
  {"\x84", 0, 0x6F5D4F}, /* Korean hangul */
  {"\x85", 0, 0x6F5D50}, /* Korean hangul */
  {"\x88", 0, 0x6F5D51}, /* Korean hangul */
  {"\x8C", 0, 0x6F5D52}, /* Korean hangul */
  {"\x91", 0, 0x6F5D53}, /* Korean hangul */
  {"\x94", 0, 0x6F5D54}, /* Korean hangul */
  {"\x97", 0, 0x6F5D55}, /* Korean hangul */
  {"\xA0", 0, 0x6F5D56}, /* Korean hangul */
  {"\xA4", 0, 0x6F5D57}, /* Korean hangul */
  {"\xA8", 0, 0x6F5D58}, /* Korean hangul */
  {"\xB0", 0, 0x6F5D59}, /* Korean hangul */
  {"\xBC", 0, 0x6F5D5A}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page518 = {
  marc8r_31page518_flat, 0
};
/* PAGE 517 */
struct yaz_iconv_trie_flat marc8r_31page517_flat[] = {
  {"\x83", 0, 0x6F5D48}, /* Korean hangul */
  {"\x8C", 0, 0x6F5D4A}, /* Korean hangul */
  {"\x8D", 0, 0x6F5D4B}, /* Korean hangul */
  {"\x9F", 0, 0x6F5D4C}, /* Korean hangul */
  {"\xA1", 0, 0x6F5D4D}, /* Korean hangul */
  {"\xA8", 0, 0x6F5D4E}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page517 = {
  marc8r_31page517_flat, 0
};
/* PAGE 516 */
struct yaz_iconv_trie_flat marc8r_31page516_flat[] = {
  {"\x80", 0, 0x6F5D39}, /* Korean hangul */
  {"\x88", 0, 0x6F5D3A}, /* Korean hangul */
  {"\x89", 0, 0x6F5D3B}, /* Korean hangul */
  {"\x8B", 0, 0x6F5D3C}, /* Korean hangul */
  {"\x8D", 0, 0x6F5D3D}, /* Korean hangul */
  {"\x94", 0, 0x6F5D3F}, /* Korean hangul */
  {"\x95", 0, 0x6F5D40}, /* Korean hangul */
  {"\x98", 0, 0x6F5D41}, /* Korean hangul */
  {"\x9C", 0, 0x6F5D42}, /* Korean hangul */
  {"\xA7", 0, 0x6F5D44}, /* Korean hangul */
  {"\xA9", 0, 0x6F5D45}, /* Korean hangul */
  {"\xB0", 0, 0x6F5D46}, /* Korean hangul */
  {"\xB1", 0, 0x6F5D47}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page516 = {
  marc8r_31page516_flat, 0
};
/* PAGE 515 */
struct yaz_iconv_trie_flat marc8r_31page515_flat[] = {
  {"\x80", 0, 0x6F5D2C}, /* Korean hangul */
  {"\x81", 0, 0x6F5D2D}, /* Korean hangul */
  {"\x84", 0, 0x6F5D2E}, /* Korean hangul */
  {"\x88", 0, 0x6F5D2F}, /* Korean hangul */
  {"\x90", 0, 0x6F5D30}, /* Korean hangul */
  {"\x91", 0, 0x6F5D31}, /* Korean hangul */
  {"\x93", 0, 0x6F5D32}, /* Korean hangul */
  {"\x94", 0, 0x6F5D33}, /* Korean hangul */
  {"\x95", 0, 0x6F5D34}, /* Korean hangul */
  {"\x9C", 0, 0x6F5D35}, /* Korean hangul */
  {"\xB8", 0, 0x6F5D36}, /* Korean hangul */
  {"\xB9", 0, 0x6F5D37}, /* Korean hangul */
  {"\xBC", 0, 0x6F5D38}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page515 = {
  marc8r_31page515_flat, 0
};
/* PAGE 514 */
struct yaz_iconv_trie_flat marc8r_31page514_flat[] = {
  {"\x88", 0, 0x6F5C79}, /* Korean hangul */
  {"\x89", 0, 0x6F5C7A}, /* Korean hangul */
  {"\x8C", 0, 0x6F5C7B}, /* Korean hangul */
  {"\x90", 0, 0x6F5C7C}, /* Korean hangul */
  {"\x92", 0, 0x6F5C7D}, /* Korean hangul */
  {"\x98", 0, 0x6F5C7E}, /* Korean hangul */
  {"\x99", 0, 0x6F5D21}, /* Korean hangul */
  {"\x9B", 0, 0x6F5D22}, /* Korean hangul */
  {"\x9D", 0, 0x6F5D23}, /* Korean hangul */
  {"\xA4", 0, 0x6F5D24}, /* Korean hangul */
  {"\xA5", 0, 0x6F5D25}, /* Korean hangul */
  {"\xA8", 0, 0x6F5D26}, /* Korean hangul */
  {"\xAC", 0, 0x6F5D27}, /* Korean hangul */
  {"\xB4", 0, 0x6F5D28}, /* Korean hangul */
  {"\xB5", 0, 0x6F5D29}, /* Korean hangul */
  {"\xB7", 0, 0x6F5D2A}, /* Korean hangul */
  {"\xB9", 0, 0x6F5D2B}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page514 = {
  marc8r_31page514_flat, 0
};
/* PAGE 513 */
struct yaz_iconv_trie_flat marc8r_31page513_flat[] = {
  {"\x84", 0, 0x6F5C72}, /* Korean hangul */
  {"\x85", 0, 0x6F5C73}, /* Korean hangul */
  {"\x87", 0, 0x6F5C74}, /* Korean hangul */
  {"\x88", 0, 0x6F5C75}, /* Korean hangul */
  {"\x89", 0, 0x6F5C76}, /* Korean hangul */
  {"\x90", 0, 0x6F5C77}, /* Korean hangul */
  {"\xA5", 0, 0x6F5C78}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page513 = {
  marc8r_31page513_flat, 0
};
/* PAGE 512 */
struct yaz_iconv_trie_flat marc8r_31page512_flat[] = {
  {"\x80", 0, 0x6F5C5B}, /* Korean hangul */
  {"\x84", 0, 0x6F5C5C}, /* Korean hangul */
  {"\x8C", 0, 0x6F5C5D}, /* Korean hangul */
  {"\x8D", 0, 0x6F5C5E}, /* Korean hangul */
  {"\x8F", 0, 0x6F5C5F}, /* Korean hangul */
  {"\x91", 0, 0x6F5C60}, /* Korean hangul */
  {"\x98", 0, 0x6F5C63}, /* Korean hangul */
  {"\x99", 0, 0x6F5C64}, /* Korean hangul */
  {"\x9C", 0, 0x6F5C65}, /* Korean hangul */
  {"\xA0", 0, 0x6F5C66}, /* Korean hangul */
  {"\xA5", 0, 0x6F5C67}, /* Korean hangul */
  {"\xA8", 0, 0x6F5C68}, /* Korean hangul */
  {"\xA9", 0, 0x6F5C69}, /* Korean hangul */
  {"\xAB", 0, 0x6F5C6A}, /* Korean hangul */
  {"\xAC", 0, 0x6F5C6B}, /* Korean hangul */
  {"\xAD", 0, 0x6F5C6C}, /* Korean hangul */
  {"\xB1", 0, 0x6F5C6D}, /* Korean hangul */
  {"\xB4", 0, 0x6F5C6E}, /* Korean hangul */
  {"\xB5", 0, 0x6F5C6F}, /* Korean hangul */
  {"\xB8", 0, 0x6F5C70}, /* Korean hangul */
  {"\xBC", 0, 0x6F5C71}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page512 = {
  marc8r_31page512_flat, 0
};
/* PAGE 511 */
struct yaz_iconv_trie_flat marc8r_31page511_flat[] = {
  {"\x84", 0, 0x6F5C53}, /* Korean hangul */
  {"\x88", 0, 0x6F5C55}, /* Korean hangul */
  {"\x8C", 0, 0x6F5C56}, /* Korean hangul */
  {"\x94", 0, 0x6F5C57}, /* Korean hangul */
  {"\x95", 0, 0x6F5C58}, /* Korean hangul */
  {"\xBC", 0, 0x6F5C59}, /* Korean hangul */
  {"\xBD", 0, 0x6F5C5A}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page511 = {
  marc8r_31page511_flat, 0
};
/* PAGE 510 */
struct yaz_iconv_trie_flat marc8r_31page510_flat[] = {
  {"\x8C", 0, 0x6F5C51}, /* Korean hangul */
  {"\xA8", 0, 0x6F5C52}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page510 = {
  marc8r_31page510_flat, 0
};
/* PAGE 509 */
struct yaz_iconv_trie_flat marc8r_31page509_flat[] = {
  {"\x80", 0, 0x6F5C4C}, /* Korean hangul */
  {"\x88", 0, 0x6F5C4D}, /* Korean hangul */
  {"\x89", 0, 0x6F5C4E}, /* Korean hangul */
  {"\x8B", 0, 0x6F5C4F}, /* Korean hangul */
  {"\x8D", 0, 0x6F5C50}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page509 = {
  marc8r_31page509_flat, 0
};
/* PAGE 508 */
struct yaz_iconv_trie_flat marc8r_31page508_flat[] = {
  {"\x80", 0, 0x6F5C45}, /* Korean hangul */
  {"\x84", 0, 0x6F5C46}, /* Korean hangul */
  {"\x9C", 0, 0x6F5C47}, /* Korean hangul */
  {"\xAF", 0, 0x6F5C48}, /* Korean hangul */
  {"\xB8", 0, 0x6F5C49}, /* Korean hangul */
  {"\xB9", 0, 0x6F5C4A}, /* Korean hangul */
  {"\xBC", 0, 0x6F5C4B}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page508 = {
  marc8r_31page508_flat, 0
};
/* PAGE 507 */
struct yaz_iconv_trie_flat marc8r_31page507_flat[] = {
  {"\x81", 0, 0x6F5C44}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page507 = {
  marc8r_31page507_flat, 0
};
/* PAGE 506 */
struct yaz_iconv_trie_flat marc8r_31page506_flat[] = {
  {"\x84", 0, 0x6F5C38}, /* Korean hangul */
  {"\x85", 0, 0x6F5C39}, /* Korean hangul */
  {"\x88", 0, 0x6F5C3A}, /* Korean hangul */
  {"\x89", 0, 0x6F5C3B}, /* Korean hangul */
  {"\x90", 0, 0x6F5C3C}, /* Korean hangul */
  {"\xAC", 0, 0x6F5C3D}, /* Korean hangul */
  {"\xAD", 0, 0x6F5C3E}, /* Korean hangul */
  {"\xB0", 0, 0x6F5C3F}, /* Korean hangul */
  {"\xB4", 0, 0x6F5C40}, /* Korean hangul */
  {"\xBC", 0, 0x6F5C41}, /* Korean hangul */
  {"\xBD", 0, 0x6F5C42}, /* Korean hangul */
  {"\xBF", 0, 0x6F5C43}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page506 = {
  marc8r_31page506_flat, 0
};
/* PAGE 505 */
struct yaz_iconv_trie_flat marc8r_31page505_flat[] = {
  {"\x80", 0, 0x6F5C25}, /* Korean hangul */
  {"\x84", 0, 0x6F5C26}, /* Korean hangul */
  {"\x8C", 0, 0x6F5C27}, /* Korean hangul */
  {"\x8D", 0, 0x6F5C28}, /* Korean hangul */
  {"\x8F", 0, 0x6F5C29}, /* Korean hangul */
  {"\x90", 0, 0x6F5C2A}, /* Korean hangul */
  {"\x91", 0, 0x6F5C2B}, /* Korean hangul */
  {"\x98", 0, 0x6F5C2C}, /* Korean hangul */
  {"\x99", 0, 0x6F5C2D}, /* Korean hangul */
  {"\x9C", 0, 0x6F5C2E}, /* Korean hangul */
  {"\xA0", 0, 0x6F5C2F}, /* Korean hangul */
  {"\xA8", 0, 0x6F5C30}, /* Korean hangul */
  {"\xA9", 0, 0x6F5C31}, /* Korean hangul */
  {"\xAB", 0, 0x6F5C32}, /* Korean hangul */
  {"\xAD", 0, 0x6F5C33}, /* Korean hangul */
  {"\xB4", 0, 0x6F5C34}, /* Korean hangul */
  {"\xB5", 0, 0x6F5C35}, /* Korean hangul */
  {"\xB8", 0, 0x6F5C36}, /* Korean hangul */
  {"\xBC", 0, 0x6F5C37}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page505 = {
  marc8r_31page505_flat, 0
};
/* PAGE 504 */
struct yaz_iconv_trie_flat marc8r_31page504_flat[] = {
  {"\xBC", 0, 0x6F5C23}, /* Korean hangul */
  {"\xBD", 0, 0x6F5C24}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page504 = {
  marc8r_31page504_flat, 0
};
/* PAGE 503 */
struct yaz_iconv_trie_flat marc8r_31page503_flat[] = {
  {"\x80", 0, 0x6F5B67}, /* Korean hangul */
  {"\x81", 0, 0x6F5B68}, /* Korean hangul */
  {"\x85", 0, 0x6F5B69}, /* Korean hangul */
  {"\x8C", 0, 0x6F5B6C}, /* Korean hangul */
  {"\x8D", 0, 0x6F5B6D}, /* Korean hangul */
  {"\x8E", 0, 0x6F5B6E}, /* Korean hangul */
  {"\x90", 0, 0x6F5B6F}, /* Korean hangul */
  {"\x94", 0, 0x6F5B70}, /* Korean hangul */
  {"\x9C", 0, 0x6F5B71}, /* Korean hangul */
  {"\x9D", 0, 0x6F5B72}, /* Korean hangul */
  {"\x9F", 0, 0x6F5B73}, /* Korean hangul */
  {"\xA0", 0, 0x6F5B74}, /* Korean hangul */
  {"\xA1", 0, 0x6F5B75}, /* Korean hangul */
  {"\xA5", 0, 0x6F5B76}, /* Korean hangul */
  {"\xA8", 0, 0x6F5B77}, /* Korean hangul */
  {"\xA9", 0, 0x6F5B78}, /* Korean hangul */
  {"\xAC", 0, 0x6F5B79}, /* Korean hangul */
  {"\xB0", 0, 0x6F5B7A}, /* Korean hangul */
  {"\xB8", 0, 0x6F5B7B}, /* Korean hangul */
  {"\xB9", 0, 0x6F5B7C}, /* Korean hangul */
  {"\xBB", 0, 0x6F5B7D}, /* Korean hangul */
  {"\xBC", 0, 0x6F5B7E}, /* Korean hangul */
  {"\xBD", 0, 0x6F5C21}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page503 = {
  marc8r_31page503_flat, 0
};
/* PAGE 502 */
struct yaz_iconv_trie_flat marc8r_31page502_flat[] = {
  {"\x80", 0, 0x6F5B5D}, /* Korean hangul */
  {"\x88", 0, 0x6F5B5E}, /* Korean hangul */
  {"\x89", 0, 0x6F5B5F}, /* Korean hangul */
  {"\x8B", 0, 0x6F5B60}, /* Korean hangul */
  {"\x94", 0, 0x6F5B61}, /* Korean hangul */
  {"\xB0", 0, 0x6F5B63}, /* Korean hangul */
  {"\xB1", 0, 0x6F5B64}, /* Korean hangul */
  {"\xB4", 0, 0x6F5B65}, /* Korean hangul */
  {"\xB8", 0, 0x6F5B66}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page502 = {
  marc8r_31page502_flat, 0
};
/* PAGE 501 */
struct yaz_iconv_trie_flat marc8r_31page501_flat[] = {
  {"\x80", 0, 0x6F5B4D}, /* Korean hangul */
  {"\x84", 0, 0x6F5B4E}, /* Korean hangul */
  {"\x88", 0, 0x6F5B4F}, /* Korean hangul */
  {"\x90", 0, 0x6F5B50}, /* Korean hangul */
  {"\x91", 0, 0x6F5B51}, /* Korean hangul */
  {"\x93", 0, 0x6F5B52}, /* Korean hangul */
  {"\x95", 0, 0x6F5B53}, /* Korean hangul */
  {"\x9C", 0, 0x6F5B54}, /* Korean hangul */
  {"\xAC", 0, 0x6F5B57}, /* Korean hangul */
  {"\xB8", 0, 0x6F5B59}, /* Korean hangul */
  {"\xB9", 0, 0x6F5B5A}, /* Korean hangul */
  {"\xBC", 0, 0x6F5B5B}, /* Korean hangul */
  {"\xBF", 0, 0x6F5B5C}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page501 = {
  marc8r_31page501_flat, 0
};
/* PAGE 500 */
struct yaz_iconv_trie_flat marc8r_31page500_flat[] = {
  {"\x81", 0, 0x6F5B4A}, /* Korean hangul */
  {"\xA4", 0, 0x6F5B4B}, /* Korean hangul */
  {"\xB7", 0, 0x6F5B4C}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page500 = {
  marc8r_31page500_flat, 0
};
/* PAGE 499 */
struct yaz_iconv_trie_flat marc8r_31page499_flat[] = {
  {"\xAC", 0, 0x6F5B43}, /* Korean hangul */
  {"\xAD", 0, 0x6F5B44}, /* Korean hangul */
  {"\xB0", 0, 0x6F5B45}, /* Korean hangul */
  {"\xB4", 0, 0x6F5B46}, /* Korean hangul */
  {"\xBC", 0, 0x6F5B47}, /* Korean hangul */
  {"\xBD", 0, 0x6F5B48}, /* Korean hangul */
  {"\xBF", 0, 0x6F5B49}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page499 = {
  marc8r_31page499_flat, 0
};
/* PAGE 498 */
struct yaz_iconv_trie_flat marc8r_31page498_flat[] = {
  {"\x98", 0, 0x6F5B40}, /* Korean hangul */
  {"\xB4", 0, 0x6F5B41}, /* Korean hangul */
  {"\xB8", 0, 0x6F5B62}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page498 = {
  marc8r_31page498_flat, 0
};
/* PAGE 497 */
struct yaz_iconv_trie_flat marc8r_31page497_flat[] = {
  {"\xA0", 0, 0x6F5B38}, /* Korean hangul */
  {"\xA1", 0, 0x6F5B39}, /* Korean hangul */
  {"\xA4", 0, 0x6F5B3A}, /* Korean hangul */
  {"\xA8", 0, 0x6F5B3B}, /* Korean hangul */
  {"\xB0", 0, 0x6F5B3C}, /* Korean hangul */
  {"\xB1", 0, 0x6F5B3D}, /* Korean hangul */
  {"\xB3", 0, 0x6F5B3E}, /* Korean hangul */
  {"\xB5", 0, 0x6F5B3F}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page497 = {
  marc8r_31page497_flat, 0
};
/* PAGE 496 */
struct yaz_iconv_trie_flat marc8r_31page496_flat[] = {
  {"\x80", 0, 0x6F5B29}, /* Korean hangul */
  {"\x81", 0, 0x6F5B2A}, /* Korean hangul */
  {"\x83", 0, 0x6F5B2B}, /* Korean hangul */
  {"\x84", 0, 0x6F5B2C}, /* Korean hangul */
  {"\x85", 0, 0x6F5B2D}, /* Korean hangul */
  {"\x8C", 0, 0x6F5B2E}, /* Korean hangul */
  {"\x8D", 0, 0x6F5B2F}, /* Korean hangul */
  {"\x90", 0, 0x6F5B30}, /* Korean hangul */
  {"\x94", 0, 0x6F5B31}, /* Korean hangul */
  {"\x9C", 0, 0x6F5B32}, /* Korean hangul */
  {"\x9D", 0, 0x6F5B33}, /* Korean hangul */
  {"\x9F", 0, 0x6F5B34}, /* Korean hangul */
  {"\xA0", 0, 0x6F5B35}, /* Korean hangul */
  {"\xA1", 0, 0x6F5B36}, /* Korean hangul */
  {"\xA8", 0, 0x6F5B37}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page496 = {
  marc8r_31page496_flat, 0
};
/* PAGE 495 */
struct yaz_iconv_trie_flat marc8r_31page495_flat[] = {
  {"\xB0", 0, 0x6F5B25}, /* Korean hangul */
  {"\xB1", 0, 0x6F5B26}, /* Korean hangul */
  {"\xB4", 0, 0x6F5B27}, /* Korean hangul */
  {"\xB8", 0, 0x6F5B28}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page495 = {
  marc8r_31page495_flat, 0
};
/* PAGE 494 */
struct yaz_iconv_trie_flat marc8r_31page494_flat[] = {
  {"\x80", 0, 0x6F5A70}, /* Korean hangul */
  {"\x81", 0, 0x6F5A71}, /* Korean hangul */
  {"\x84", 0, 0x6F5A72}, /* Korean hangul */
  {"\x88", 0, 0x6F5A73}, /* Korean hangul */
  {"\x89", 0, 0x6F5A74}, /* Korean hangul */
  {"\x90", 0, 0x6F5A75}, /* Korean hangul */
  {"\x91", 0, 0x6F5A76}, /* Korean hangul */
  {"\x93", 0, 0x6F5A77}, /* Korean hangul */
  {"\x94", 0, 0x6F5A78}, /* Korean hangul */
  {"\x95", 0, 0x6F5A79}, /* Korean hangul */
  {"\x9C", 0, 0x6F5A7A}, /* Korean hangul */
  {"\x9D", 0, 0x6F5A7B}, /* Korean hangul */
  {"\xA0", 0, 0x6F5A7C}, /* Korean hangul */
  {"\xA4", 0, 0x6F5A7D}, /* Korean hangul */
  {"\xAC", 0, 0x6F5A7E}, /* Korean hangul */
  {"\xAD", 0, 0x6F5B21}, /* Korean hangul */
  {"\xAF", 0, 0x6F5B22}, /* Korean hangul */
  {"\xB0", 0, 0x6F5B23}, /* Korean hangul */
  {"\xB1", 0, 0x6F5B24}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page494 = {
  marc8r_31page494_flat, 0
};
/* PAGE 493 */
struct yaz_iconv_trie_flat marc8r_31page493_flat[] = {
  {"\x81", 0, 0x6F5A65}, /* Korean hangul */
  {"\xA4", 0, 0x6F5A66}, /* Korean hangul */
  {"\xA5", 0, 0x6F5A67}, /* Korean hangul */
  {"\xA8", 0, 0x6F5A68}, /* Korean hangul */
  {"\xAC", 0, 0x6F5A69}, /* Korean hangul */
  {"\xB4", 0, 0x6F5A6A}, /* Korean hangul */
  {"\xB5", 0, 0x6F5A6B}, /* Korean hangul */
  {"\xB7", 0, 0x6F5A6C}, /* Korean hangul */
  {"\xB9", 0, 0x6F5A6D}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page493 = {
  marc8r_31page493_flat, 0
};
/* PAGE 492 */
struct yaz_iconv_trie_flat marc8r_31page492_flat[] = {
  {"\x90", 0, 0x6F5A5F}, /* Korean hangul */
  {"\xAC", 0, 0x6F5A60}, /* Korean hangul */
  {"\xB0", 0, 0x6F5A61}, /* Korean hangul */
  {"\xB4", 0, 0x6F5A62}, /* Korean hangul */
  {"\xBC", 0, 0x6F5A63}, /* Korean hangul */
  {"\xBD", 0, 0x6F5A64}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page492 = {
  marc8r_31page492_flat, 0
};
/* PAGE 491 */
struct yaz_iconv_trie_flat marc8r_31page491_flat[] = {
  {"\x98", 0, 0x6F5A5A}, /* Korean hangul */
  {"\xAD", 0, 0x6F5A5B}, /* Korean hangul */
  {"\xB4", 0, 0x6F5A5C}, /* Korean hangul */
  {"\xB5", 0, 0x6F5A5D}, /* Korean hangul */
  {"\xB8", 0, 0x6F5A5E}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page491 = {
  marc8r_31page491_flat, 0
};
/* PAGE 490 */
struct yaz_iconv_trie_dir marc8r_31page490_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {492, 0, 0},
  {493, 0, 0},
  {494, 0, 0},
  {495, 0, 0},
  {496, 0, 0},
  {497, 0, 0},
  {498, 0, 0},
  {499, 0, 0},
  {500, 0, 0},
  {501, 0, 0},
  {502, 0, 0},
  {503, 0, 0},
  {504, 0, 0},
  {505, 0, 0},
  {506, 0, 0},
  {507, 0, 0},
  {508, 0, 0},
  {509, 0, 0},
  {510, 0, 0},
  {511, 0, 0},
  {512, 0, 0},
  {513, 0, 0},
  {514, 0, 0},
  {515, 0, 0},
  {516, 0, 0},
  {517, 0, 0},
  {518, 0, 0},
  {519, 0, 0},
  {520, 0, 0},
  {521, 0, 0},
  {522, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page490 = {
  0, marc8r_31page490_dir
};
/* PAGE 489 */
struct yaz_iconv_trie_flat marc8r_31page489_flat[] = {
  {"\x84", 0, 0x6F5A50}, /* Korean hangul */
  {"\xA0", 0, 0x6F5A51}, /* Korean hangul */
  {"\xA1", 0, 0x6F5A52}, /* Korean hangul */
  {"\xA4", 0, 0x6F5A53}, /* Korean hangul */
  {"\xA8", 0, 0x6F5A54}, /* Korean hangul */
  {"\xB0", 0, 0x6F5A55}, /* Korean hangul */
  {"\xB3", 0, 0x6F5A56}, /* Korean hangul */
  {"\xB5", 0, 0x6F5A57}, /* Korean hangul */
  {"\xBC", 0, 0x6F5A58}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page489 = {
  marc8r_31page489_flat, 0
};
/* PAGE 488 */
struct yaz_iconv_trie_flat marc8r_31page488_flat[] = {
  {"\x80", 0, 0x6F5A49}, /* Korean hangul */
  {"\x85", 0, 0x6F5A4A}, /* Korean hangul */
  {"\x8C", 0, 0x6F5A4B}, /* Korean hangul */
  {"\x8D", 0, 0x6F5A4C}, /* Korean hangul */
  {"\xA1", 0, 0x6F5A4D}, /* Korean hangul */
  {"\xB0", 0, 0x6F5A4F}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page488 = {
  marc8r_31page488_flat, 0
};
/* PAGE 487 */
struct yaz_iconv_trie_flat marc8r_31page487_flat[] = {
  {"\x94", 0, 0x6F5A3D}, /* Korean hangul */
  {"\x95", 0, 0x6F5A3E}, /* Korean hangul */
  {"\x98", 0, 0x6F5A3F}, /* Korean hangul */
  {"\x9C", 0, 0x6F5A40}, /* Korean hangul */
  {"\xA4", 0, 0x6F5A41}, /* Korean hangul */
  {"\xA5", 0, 0x6F5A42}, /* Korean hangul */
  {"\xA7", 0, 0x6F5A43}, /* Korean hangul */
  {"\xA9", 0, 0x6F5A44}, /* Korean hangul */
  {"\xB0", 0, 0x6F5A45}, /* Korean hangul */
  {"\xB1", 0, 0x6F5A46}, /* Korean hangul */
  {"\xB4", 0, 0x6F5A47}, /* Korean hangul */
  {"\xB8", 0, 0x6F5A48}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page487 = {
  marc8r_31page487_flat, 0
};
/* PAGE 486 */
struct yaz_iconv_trie_flat marc8r_31page486_flat[] = {
  {"\x80", 0, 0x6F5A2E}, /* Korean hangul */
  {"\x81", 0, 0x6F5A2F}, /* Korean hangul */
  {"\x84", 0, 0x6F5A30}, /* Korean hangul */
  {"\x88", 0, 0x6F5A31}, /* Korean hangul */
  {"\x90", 0, 0x6F5A32}, /* Korean hangul */
  {"\x91", 0, 0x6F5A33}, /* Korean hangul */
  {"\x93", 0, 0x6F5A34}, /* Korean hangul */
  {"\x95", 0, 0x6F5A35}, /* Korean hangul */
  {"\x9C", 0, 0x6F5A36}, /* Korean hangul */
  {"\xA0", 0, 0x6F5A37}, /* Korean hangul */
  {"\xA4", 0, 0x6F5A38}, /* Korean hangul */
  {"\xAC", 0, 0x6F5A39}, /* Korean hangul */
  {"\xAD", 0, 0x6F5A3A}, /* Korean hangul */
  {"\xAF", 0, 0x6F5A3B}, /* Korean hangul */
  {"\xB0", 0, 0x6F5A3C}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page486 = {
  marc8r_31page486_flat, 0
};
/* PAGE 485 */
struct yaz_iconv_trie_flat marc8r_31page485_flat[] = {
  {"\xA4", 0, 0x6F5A24}, /* Korean hangul */
  {"\xA8", 0, 0x6F5A26}, /* Korean hangul */
  {"\xAC", 0, 0x6F5A27}, /* Korean hangul */
  {"\xB4", 0, 0x6F5A28}, /* Korean hangul */
  {"\xB5", 0, 0x6F5A29}, /* Korean hangul */
  {"\xB7", 0, 0x6F5A2A}, /* Korean hangul */
  {"\xB9", 0, 0x6F5A2C}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page485 = {
  marc8r_31page485_flat, 0
};
/* PAGE 484 */
struct yaz_iconv_trie_flat marc8r_31page484_flat[] = {
  {"\x84", 0, 0x6F5973}, /* Korean hangul */
  {"\x85", 0, 0x6F5974}, /* Korean hangul */
  {"\x87", 0, 0x6F5975}, /* Korean hangul */
  {"\x89", 0, 0x6F5976}, /* Korean hangul */
  {"\x90", 0, 0x6F5977}, /* Korean hangul */
  {"\x91", 0, 0x6F5978}, /* Korean hangul */
  {"\x94", 0, 0x6F5979}, /* Korean hangul */
  {"\x98", 0, 0x6F597A}, /* Korean hangul */
  {"\xA0", 0, 0x6F597B}, /* Korean hangul */
  {"\xA1", 0, 0x6F597C}, /* Korean hangul */
  {"\xA3", 0, 0x6F597D}, /* Korean hangul */
  {"\xA5", 0, 0x6F5A21}, /* Korean hangul */
  {"\xAC", 0, 0x6F5A22}, /* Korean hangul */
  {"\xAD", 0, 0x6F5A23}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page484 = {
  marc8r_31page484_flat, 0
};
/* PAGE 483 */
struct yaz_iconv_trie_flat marc8r_31page483_flat[] = {
  {"\x98", 0, 0x6F5964}, /* Korean hangul */
  {"\x99", 0, 0x6F5965}, /* Korean hangul */
  {"\x9C", 0, 0x6F5966}, /* Korean hangul */
  {"\xA0", 0, 0x6F5967}, /* Korean hangul */
  {"\xA1", 0, 0x6F5968}, /* Korean hangul */
  {"\xA8", 0, 0x6F5969}, /* Korean hangul */
  {"\xA9", 0, 0x6F596A}, /* Korean hangul */
  {"\xAB", 0, 0x6F596B}, /* Korean hangul */
  {"\xAD", 0, 0x6F596C}, /* Korean hangul */
  {"\xB4", 0, 0x6F596F}, /* Korean hangul */
  {"\xB5", 0, 0x6F5970}, /* Korean hangul */
  {"\xB8", 0, 0x6F5971}, /* Korean hangul */
  {"\xBC", 0, 0x6F5972}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page483 = {
  marc8r_31page483_flat, 0
};
/* PAGE 482 */
struct yaz_iconv_trie_flat marc8r_31page482_flat[] = {
  {"\x84", 0, 0x6F595F}, /* Korean hangul */
  {"\xA0", 0, 0x6F5960}, /* Korean hangul */
  {"\xA1", 0, 0x6F5961}, /* Korean hangul */
  {"\xB0", 0, 0x6F5962}, /* Korean hangul */
  {"\xB5", 0, 0x6F5963}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page482 = {
  marc8r_31page482_flat, 0
};
/* PAGE 481 */
struct yaz_iconv_trie_flat marc8r_31page481_flat[] = {
  {"\x84", 0, 0x6F595C}, /* Korean hangul */
  {"\x8C", 0, 0x6F595D}, /* Korean hangul */
  {"\xA8", 0, 0x6F595E}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page481 = {
  marc8r_31page481_flat, 0
};
/* PAGE 480 */
struct yaz_iconv_trie_flat marc8r_31page480_flat[] = {
  {"\x94", 0, 0x6F5953}, /* Korean hangul */
  {"\x95", 0, 0x6F5954}, /* Korean hangul */
  {"\x98", 0, 0x6F5955}, /* Korean hangul */
  {"\x9C", 0, 0x6F5956}, /* Korean hangul */
  {"\xA4", 0, 0x6F5957}, /* Korean hangul */
  {"\xA5", 0, 0x6F5958}, /* Korean hangul */
  {"\xA7", 0, 0x6F5959}, /* Korean hangul */
  {"\xA9", 0, 0x6F595A}, /* Korean hangul */
  {"\xB0", 0, 0x6F595B}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page480 = {
  marc8r_31page480_flat, 0
};
/* PAGE 479 */
struct yaz_iconv_trie_flat marc8r_31page479_flat[] = {
  {"\x9C", 0, 0x6F5951}, /* Korean hangul */
  {"\xB8", 0, 0x6F5952}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page479 = {
  marc8r_31page479_flat, 0
};
/* PAGE 478 */
struct yaz_iconv_trie_flat marc8r_31page478_flat[] = {
  {"\x88", 0, 0x6F5948}, /* Korean hangul */
  {"\x89", 0, 0x6F5949}, /* Korean hangul */
  {"\x8C", 0, 0x6F594A}, /* Korean hangul */
  {"\x90", 0, 0x6F594B}, /* Korean hangul */
  {"\x98", 0, 0x6F594C}, /* Korean hangul */
  {"\x99", 0, 0x6F594D}, /* Korean hangul */
  {"\x9B", 0, 0x6F594E}, /* Korean hangul */
  {"\x9D", 0, 0x6F594F}, /* Korean hangul */
  {"\xAC", 0, 0x6F5950}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page478 = {
  marc8r_31page478_flat, 0
};
/* PAGE 477 */
struct yaz_iconv_trie_flat marc8r_31page477_flat[] = {
  {"\x87", 0, 0x6F5945}, /* Korean hangul */
  {"\x90", 0, 0x6F5946}, /* Korean hangul */
  {"\xA4", 0, 0x6F5947}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page477 = {
  marc8r_31page477_flat, 0
};
/* PAGE 476 */
struct yaz_iconv_trie_flat marc8r_31page476_flat[] = {
  {"\x98", 0, 0x6F5939}, /* Korean hangul */
  {"\x99", 0, 0x6F593A}, /* Korean hangul */
  {"\x9C", 0, 0x6F593B}, /* Korean hangul */
  {"\xA0", 0, 0x6F593C}, /* Korean hangul */
  {"\xA8", 0, 0x6F593D}, /* Korean hangul */
  {"\xA9", 0, 0x6F593E}, /* Korean hangul */
  {"\xAB", 0, 0x6F593F}, /* Korean hangul */
  {"\xAD", 0, 0x6F5940}, /* Korean hangul */
  {"\xB4", 0, 0x6F5941}, /* Korean hangul */
  {"\xB5", 0, 0x6F5942}, /* Korean hangul */
  {"\xB8", 0, 0x6F5943}, /* Korean hangul */
  {"\xBC", 0, 0x6F5944}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page476 = {
  marc8r_31page476_flat, 0
};
/* PAGE 475 */
struct yaz_iconv_trie_flat marc8r_31page475_flat[] = {
  {"\x84", 0, 0x6F592D}, /* Korean hangul */
  {"\x85", 0, 0x6F592E}, /* Korean hangul */
  {"\x88", 0, 0x6F592F}, /* Korean hangul */
  {"\x8C", 0, 0x6F5930}, /* Korean hangul */
  {"\x94", 0, 0x6F5931}, /* Korean hangul */
  {"\x95", 0, 0x6F5932}, /* Korean hangul */
  {"\x98", 0, 0x6F5933}, /* Korean hangul */
  {"\x99", 0, 0x6F5934}, /* Korean hangul */
  {"\xA0", 0, 0x6F5935}, /* Korean hangul */
  {"\xA4", 0, 0x6F5936}, /* Korean hangul */
  {"\xB0", 0, 0x6F5937}, /* Korean hangul */
  {"\xB1", 0, 0x6F5938}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page475 = {
  marc8r_31page475_flat, 0
};
/* PAGE 474 */
struct yaz_iconv_trie_flat marc8r_31page474_flat[] = {
  {"\x8C", 0, 0x6F5873}, /* Korean hangul */
  {"\x8D", 0, 0x6F5874}, /* Korean hangul */
  {"\x90", 0, 0x6F5875}, /* Korean hangul */
  {"\x94", 0, 0x6F5876}, /* Korean hangul */
  {"\x9C", 0, 0x6F5877}, /* Korean hangul */
  {"\x9D", 0, 0x6F5878}, /* Korean hangul */
  {"\xA1", 0, 0x6F5879}, /* Korean hangul */
  {"\xA2", 0, 0x6F587A}, /* Korean hangul */
  {"\xA7", 0, 0x6F587B}, /* Korean hangul */
  {"\xA8", 0, 0x6F587E}, /* Korean hangul */
  {"\xA9", 0, 0x6F5921}, /* Korean hangul */
  {"\xAC", 0, 0x6F5922}, /* Korean hangul */
  {"\xAE", 0, 0x6F5923}, /* Korean hangul */
  {"\xAF", 0, 0x6F5924}, /* Korean hangul */
  {"\xB0", 0, 0x6F5925}, /* Korean hangul */
  {"\xB8", 0, 0x6F5926}, /* Korean hangul */
  {"\xB9", 0, 0x6F5927}, /* Korean hangul */
  {"\xBB", 0, 0x6F5928}, /* Korean hangul */
  {"\xBC", 0, 0x6F5929}, /* Korean hangul */
  {"\xBD", 0, 0x6F592A}, /* Korean hangul */
  {"\xBE", 0, 0x6F592B}, /* Korean hangul */
  {"\xBF", 0, 0x6F592C}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page474 = {
  marc8r_31page474_flat, 0
};
/* PAGE 473 */
struct yaz_iconv_trie_flat marc8r_31page473_flat[] = {
  {"\x94", 0, 0x6F5870}, /* Korean hangul */
  {"\xA4", 0, 0x6F5871}, /* Korean hangul */
  {"\xA7", 0, 0x6F5872}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page473 = {
  marc8r_31page473_flat, 0
};
/* PAGE 472 */
struct yaz_iconv_trie_flat marc8r_31page472_flat[] = {
  {"\xB8", 0, 0x6F586F}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page472 = {
  marc8r_31page472_flat, 0
};
/* PAGE 471 */
struct yaz_iconv_trie_flat marc8r_31page471_flat[] = {
  {"\x81", 0, 0x6F5867}, /* Korean hangul */
  {"\x88", 0, 0x6F5868}, /* Korean hangul */
  {"\x89", 0, 0x6F5869}, /* Korean hangul */
  {"\x90", 0, 0x6F586A}, /* Korean hangul */
  {"\x98", 0, 0x6F586B}, /* Korean hangul */
  {"\x99", 0, 0x6F586C}, /* Korean hangul */
  {"\x9D", 0, 0x6F586D}, /* Korean hangul */
  {"\xA4", 0, 0x6F586E}, /* Korean hangul */
  {"\x8C", 0, 0x6F773E}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page471 = {
  marc8r_31page471_flat, 0
};
/* PAGE 470 */
struct yaz_iconv_trie_flat marc8r_31page470_flat[] = {
  {"\x90", 0, 0x6F5862}, /* Korean hangul */
  {"\x94", 0, 0x6F5863}, /* Korean hangul */
  {"\x98", 0, 0x6F5864}, /* Korean hangul */
  {"\xA0", 0, 0x6F5865}, /* Korean hangul */
  {"\xA1", 0, 0x6F5866}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page470 = {
  marc8r_31page470_flat, 0
};
/* PAGE 469 */
struct yaz_iconv_trie_flat marc8r_31page469_flat[] = {
  {"\x80", 0, 0x6F5859}, /* Korean hangul */
  {"\x84", 0, 0x6F585A}, /* Korean hangul */
  {"\x8C", 0, 0x6F585B}, /* Korean hangul */
  {"\x8D", 0, 0x6F585C}, /* Korean hangul */
  {"\x91", 0, 0x6F585D}, /* Korean hangul */
  {"\x92", 0, 0x6F585E}, /* Korean hangul */
  {"\x93", 0, 0x6F585F}, /* Korean hangul */
  {"\x98", 0, 0x6F5860}, /* Korean hangul */
  {"\x99", 0, 0x6F5861}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page469 = {
  marc8r_31page469_flat, 0
};
/* PAGE 468 */
struct yaz_iconv_trie_flat marc8r_31page468_flat[] = {
  {"\x84", 0, 0x6F5855}, /* Korean hangul */
  {"\x98", 0, 0x6F5856}, /* Korean hangul */
  {"\xBC", 0, 0x6F5857}, /* Korean hangul */
  {"\xBD", 0, 0x6F5858}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page468 = {
  marc8r_31page468_flat, 0
};
/* PAGE 467 */
struct yaz_iconv_trie_flat marc8r_31page467_flat[] = {
  {"\x8C", 0, 0x6F584E}, /* Korean hangul */
  {"\x8D", 0, 0x6F584F}, /* Korean hangul */
  {"\x90", 0, 0x6F5850}, /* Korean hangul */
  {"\x94", 0, 0x6F5851}, /* Korean hangul */
  {"\x9C", 0, 0x6F5852}, /* Korean hangul */
  {"\x9D", 0, 0x6F5853}, /* Korean hangul */
  {"\xA1", 0, 0x6F5854}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page467 = {
  marc8r_31page467_flat, 0
};
/* PAGE 466 */
struct yaz_iconv_trie_flat marc8r_31page466_flat[] = {
  {"\x80", 0, 0x6F5847}, /* Korean hangul */
  {"\x88", 0, 0x6F5848}, /* Korean hangul */
  {"\x89", 0, 0x6F5849}, /* Korean hangul */
  {"\x8B", 0, 0x6F584A}, /* Korean hangul */
  {"\x8C", 0, 0x6F584B}, /* Korean hangul */
  {"\x8D", 0, 0x6F584C}, /* Korean hangul */
  {"\x98", 0, 0x6F584D}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page466 = {
  marc8r_31page466_flat, 0
};
/* PAGE 465 */
struct yaz_iconv_trie_flat marc8r_31page465_flat[] = {
  {"\x80", 0, 0x6F5829}, /* Korean hangul */
  {"\x81", 0, 0x6F582A}, /* Korean hangul */
  {"\x84", 0, 0x6F582B}, /* Korean hangul */
  {"\x87", 0, 0x6F582C}, /* Korean hangul */
  {"\x88", 0, 0x6F582D}, /* Korean hangul */
  {"\x8A", 0, 0x6F582E}, /* Korean hangul */
  {"\x90", 0, 0x6F582F}, /* Korean hangul */
  {"\x91", 0, 0x6F5830}, /* Korean hangul */
  {"\x93", 0, 0x6F5831}, /* Korean hangul */
  {"\x95", 0, 0x6F5832}, /* Korean hangul */
  {"\x96", 0, 0x6F5833}, /* Korean hangul */
  {"\x99", 0, 0x6F5834}, /* Korean hangul */
  {"\x9A", 0, 0x6F5835}, /* Korean hangul */
  {"\x9C", 0, 0x6F5838}, /* Korean hangul */
  {"\x9D", 0, 0x6F5839}, /* Korean hangul */
  {"\xA0", 0, 0x6F583A}, /* Korean hangul */
  {"\xA2", 0, 0x6F583B}, /* Korean hangul */
  {"\xA4", 0, 0x6F583C}, /* Korean hangul */
  {"\xA7", 0, 0x6F583E}, /* Korean hangul */
  {"\xAC", 0, 0x6F583F}, /* Korean hangul */
  {"\xAD", 0, 0x6F5840}, /* Korean hangul */
  {"\xAF", 0, 0x6F5841}, /* Korean hangul */
  {"\xB0", 0, 0x6F5842}, /* Korean hangul */
  {"\xB1", 0, 0x6F5843}, /* Korean hangul */
  {"\xB8", 0, 0x6F5844}, /* Korean hangul */
  {"\xB9", 0, 0x6F5845}, /* Korean hangul */
  {"\xBC", 0, 0x6F5846}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page465 = {
  marc8r_31page465_flat, 0
};
/* PAGE 464 */
struct yaz_iconv_trie_flat marc8r_31page464_flat[] = {
  {"\x88", 0, 0x6F5822}, /* Korean hangul */
  {"\x89", 0, 0x6F5823}, /* Korean hangul */
  {"\x8C", 0, 0x6F5824}, /* Korean hangul */
  {"\x90", 0, 0x6F5825}, /* Korean hangul */
  {"\x98", 0, 0x6F5826}, /* Korean hangul */
  {"\x99", 0, 0x6F5827}, /* Korean hangul */
  {"\x9D", 0, 0x6F5828}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page464 = {
  marc8r_31page464_flat, 0
};
/* PAGE 463 */
struct yaz_iconv_trie_flat marc8r_31page463_flat[] = {
  {"\x90", 0, 0x6F5777}, /* Korean hangul */
  {"\x94", 0, 0x6F5779}, /* Korean hangul */
  {"\x98", 0, 0x6F577A}, /* Korean hangul */
  {"\xA0", 0, 0x6F577B}, /* Korean hangul */
  {"\xA1", 0, 0x6F577C}, /* Korean hangul */
  {"\xAC", 0, 0x6F577D}, /* Korean hangul */
  {"\xB0", 0, 0x6F577E}, /* Korean hangul */
  {"\xB4", 0, 0x6F5821}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page463 = {
  marc8r_31page463_flat, 0
};
/* PAGE 462 */
struct yaz_iconv_trie_flat marc8r_31page462_flat[] = {
  {"\x80", 0, 0x6F576E}, /* Korean hangul */
  {"\x84", 0, 0x6F576F}, /* Korean hangul */
  {"\x86", 0, 0x6F5770}, /* Korean hangul */
  {"\x8C", 0, 0x6F5771}, /* Korean hangul */
  {"\x8D", 0, 0x6F5772}, /* Korean hangul */
  {"\x8F", 0, 0x6F5773}, /* Korean hangul */
  {"\x91", 0, 0x6F5774}, /* Korean hangul */
  {"\x98", 0, 0x6F5775}, /* Korean hangul */
  {"\xAC", 0, 0x6F5776}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page462 = {
  marc8r_31page462_flat, 0
};
/* PAGE 461 */
struct yaz_iconv_trie_flat marc8r_31page461_flat[] = {
  {"\x84", 0, 0x6F5761}, /* Korean hangul */
  {"\x88", 0, 0x6F5762}, /* Korean hangul */
  {"\x8C", 0, 0x6F5763}, /* Korean hangul */
  {"\x94", 0, 0x6F5764}, /* Korean hangul */
  {"\x95", 0, 0x6F5765}, /* Korean hangul */
  {"\x97", 0, 0x6F5766}, /* Korean hangul */
  {"\xA0", 0, 0x6F5767}, /* Korean hangul */
  {"\xA4", 0, 0x6F5768}, /* Korean hangul */
  {"\xB0", 0, 0x6F5769}, /* Korean hangul */
  {"\xB1", 0, 0x6F576A}, /* Korean hangul */
  {"\xB5", 0, 0x6F576B}, /* Korean hangul */
  {"\xBC", 0, 0x6F576C}, /* Korean hangul */
  {"\xBD", 0, 0x6F576D}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page461 = {
  marc8r_31page461_flat, 0
};
/* PAGE 460 */
struct yaz_iconv_trie_flat marc8r_31page460_flat[] = {
  {"\x80", 0, 0x6F574E}, /* Korean hangul */
  {"\x81", 0, 0x6F574F}, /* Korean hangul */
  {"\x85", 0, 0x6F5750}, /* Korean hangul */
  {"\x86", 0, 0x6F5751}, /* Korean hangul */
  {"\x87", 0, 0x6F5752}, /* Korean hangul */
  {"\x8B", 0, 0x6F5753}, /* Korean hangul */
  {"\x8C", 0, 0x6F5754}, /* Korean hangul */
  {"\x8D", 0, 0x6F5755}, /* Korean hangul */
  {"\x90", 0, 0x6F5756}, /* Korean hangul */
  {"\x94", 0, 0x6F5757}, /* Korean hangul */
  {"\x9C", 0, 0x6F5758}, /* Korean hangul */
  {"\x9D", 0, 0x6F5759}, /* Korean hangul */
  {"\x9F", 0, 0x6F575A}, /* Korean hangul */
  {"\xA0", 0, 0x6F575B}, /* Korean hangul */
  {"\xA8", 0, 0x6F575D}, /* Korean hangul */
  {"\xAC", 0, 0x6F575E}, /* Korean hangul */
  {"\xB0", 0, 0x6F575F}, /* Korean hangul */
  {"\xB8", 0, 0x6F5760}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page460 = {
  marc8r_31page460_flat, 0
};
/* PAGE 459 */
struct yaz_iconv_trie_flat marc8r_31page459_flat[] = {
  {"\x8C", 0, 0x6F5748}, /* Korean hangul */
  {"\xB0", 0, 0x6F5749}, /* Korean hangul */
  {"\xB1", 0, 0x6F574A}, /* Korean hangul */
  {"\xB4", 0, 0x6F574B}, /* Korean hangul */
  {"\xB8", 0, 0x6F574C}, /* Korean hangul */
  {"\xBA", 0, 0x6F574D}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page459 = {
  marc8r_31page459_flat, 0
};
/* PAGE 458 */
struct yaz_iconv_trie_flat marc8r_31page458_flat[] = {
  {"\x80", 0, 0x6F5734}, /* Korean hangul */
  {"\x81", 0, 0x6F5735}, /* Korean hangul */
  {"\x84", 0, 0x6F5736}, /* Korean hangul */
  {"\x88", 0, 0x6F5737}, /* Korean hangul */
  {"\x8A", 0, 0x6F5738}, /* Korean hangul */
  {"\x90", 0, 0x6F5739}, /* Korean hangul */
  {"\x91", 0, 0x6F573A}, /* Korean hangul */
  {"\x93", 0, 0x6F573B}, /* Korean hangul */
  {"\x94", 0, 0x6F573C}, /* Korean hangul */
  {"\x95", 0, 0x6F573D}, /* Korean hangul */
  {"\x96", 0, 0x6F573E}, /* Korean hangul */
  {"\x9C", 0, 0x6F573F}, /* Korean hangul */
  {"\x9D", 0, 0x6F5740}, /* Korean hangul */
  {"\xA0", 0, 0x6F5741}, /* Korean hangul */
  {"\xA4", 0, 0x6F5742}, /* Korean hangul */
  {"\xAC", 0, 0x6F5743}, /* Korean hangul */
  {"\xAD", 0, 0x6F5744}, /* Korean hangul */
  {"\xAF", 0, 0x6F5745}, /* Korean hangul */
  {"\xB8", 0, 0x6F5746}, /* Korean hangul */
  {"\xBC", 0, 0x6F5747}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page458 = {
  marc8r_31page458_flat, 0
};
/* PAGE 457 */
struct yaz_iconv_trie_flat marc8r_31page457_flat[] = {
  {"\x80", 0, 0x6F572E}, /* Korean hangul */
  {"\x81", 0, 0x6F572F}, /* Korean hangul */
  {"\x88", 0, 0x6F5730}, /* Korean hangul */
  {"\x89", 0, 0x6F5731}, /* Korean hangul */
  {"\x8C", 0, 0x6F5732}, /* Korean hangul */
  {"\x98", 0, 0x6F5733}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page457 = {
  marc8r_31page457_flat, 0
};
/* PAGE 456 */
struct yaz_iconv_trie_flat marc8r_31page456_flat[] = {
  {"\x83", 0, 0x6F566F}, /* Korean hangul */
  {"\x84", 0, 0x6F5670}, /* Korean hangul */
  {"\x85", 0, 0x6F5671}, /* Korean hangul */
  {"\x87", 0, 0x6F5672}, /* Korean hangul */
  {"\x88", 0, 0x6F5673}, /* Korean hangul */
  {"\x89", 0, 0x6F5674}, /* Korean hangul */
  {"\x8A", 0, 0x6F5675}, /* Korean hangul */
  {"\x8E", 0, 0x6F5676}, /* Korean hangul */
  {"\x90", 0, 0x6F5679}, /* Korean hangul */
  {"\x91", 0, 0x6F567A}, /* Korean hangul */
  {"\x94", 0, 0x6F567B}, /* Korean hangul */
  {"\x96", 0, 0x6F567C}, /* Korean hangul */
  {"\x98", 0, 0x6F567D}, /* Korean hangul */
  {"\xA0", 0, 0x6F567E}, /* Korean hangul */
  {"\xA1", 0, 0x6F5721}, /* Korean hangul */
  {"\xA3", 0, 0x6F5722}, /* Korean hangul */
  {"\xA4", 0, 0x6F5723}, /* Korean hangul */
  {"\xA5", 0, 0x6F5724}, /* Korean hangul */
  {"\xA6", 0, 0x6F5725}, /* Korean hangul */
  {"\xA7", 0, 0x6F5726}, /* Korean hangul */
  {"\xAC", 0, 0x6F5727}, /* Korean hangul */
  {"\xAD", 0, 0x6F5728}, /* Korean hangul */
  {"\xB0", 0, 0x6F5729}, /* Korean hangul */
  {"\xB4", 0, 0x6F572A}, /* Korean hangul */
  {"\xBC", 0, 0x6F572B}, /* Korean hangul */
  {"\xBD", 0, 0x6F572C}, /* Korean hangul */
  {"\xBF", 0, 0x6F572D}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page456 = {
  marc8r_31page456_flat, 0
};
/* PAGE 455 */
struct yaz_iconv_trie_flat marc8r_31page455_flat[] = {
  {"\x80", 0, 0x6F5663}, /* Korean hangul */
  {"\x84", 0, 0x6F5664}, /* Korean hangul */
  {"\x8A", 0, 0x6F5665}, /* Korean hangul */
  {"\x8C", 0, 0x6F5666}, /* Korean hangul */
  {"\x8D", 0, 0x6F5667}, /* Korean hangul */
  {"\x91", 0, 0x6F5668}, /* Korean hangul */
  {"\x98", 0, 0x6F5669}, /* Korean hangul */
  {"\xB4", 0, 0x6F566A}, /* Korean hangul */
  {"\xB5", 0, 0x6F566B}, /* Korean hangul */
  {"\xB8", 0, 0x6F566C}, /* Korean hangul */
  {"\xBC", 0, 0x6F566D}, /* Korean hangul */
  {"\xBD", 0, 0x6F566E}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page455 = {
  marc8r_31page455_flat, 0
};
/* PAGE 454 */
struct yaz_iconv_trie_flat marc8r_31page454_flat[] = {
  {"\x84", 0, 0x6F5653}, /* Korean hangul */
  {"\x85", 0, 0x6F5654}, /* Korean hangul */
  {"\x88", 0, 0x6F5655}, /* Korean hangul */
  {"\x8C", 0, 0x6F5656}, /* Korean hangul */
  {"\x94", 0, 0x6F5657}, /* Korean hangul */
  {"\x97", 0, 0x6F5658}, /* Korean hangul */
  {"\x99", 0, 0x6F5659}, /* Korean hangul */
  {"\xA0", 0, 0x6F565A}, /* Korean hangul */
  {"\xA1", 0, 0x6F565B}, /* Korean hangul */
  {"\xA4", 0, 0x6F565C}, /* Korean hangul */
  {"\xA8", 0, 0x6F565D}, /* Korean hangul */
  {"\xB0", 0, 0x6F565E}, /* Korean hangul */
  {"\xB5", 0, 0x6F565F}, /* Korean hangul */
  {"\xB7", 0, 0x6F5660}, /* Korean hangul */
  {"\xBC", 0, 0x6F5661}, /* Korean hangul */
  {"\xBD", 0, 0x6F5662}, /* Korean hangul */
  {"\xB3", 0, 0x6F773D}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page454 = {
  marc8r_31page454_flat, 0
};
/* PAGE 453 */
struct yaz_iconv_trie_flat marc8r_31page453_flat[] = {
  {"\x80", 0, 0x6F5641}, /* Korean hangul */
  {"\x81", 0, 0x6F5642}, /* Korean hangul */
  {"\x83", 0, 0x6F5643}, /* Korean hangul */
  {"\x85", 0, 0x6F5644}, /* Korean hangul */
  {"\x8C", 0, 0x6F5645}, /* Korean hangul */
  {"\x8D", 0, 0x6F5646}, /* Korean hangul */
  {"\x90", 0, 0x6F5647}, /* Korean hangul */
  {"\x94", 0, 0x6F5648}, /* Korean hangul */
  {"\x9C", 0, 0x6F5649}, /* Korean hangul */
  {"\x9D", 0, 0x6F564A}, /* Korean hangul */
  {"\x9F", 0, 0x6F564B}, /* Korean hangul */
  {"\xA0", 0, 0x6F564C}, /* Korean hangul */
  {"\xA1", 0, 0x6F564D}, /* Korean hangul */
  {"\xA8", 0, 0x6F564E}, /* Korean hangul */
  {"\xA9", 0, 0x6F564F}, /* Korean hangul */
  {"\xAC", 0, 0x6F5650}, /* Korean hangul */
  {"\xB0", 0, 0x6F5651}, /* Korean hangul */
  {"\xB8", 0, 0x6F5652}, /* Korean hangul */
  {"\xBD", 0, 0x6F773B}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page453 = {
  marc8r_31page453_flat, 0
};
/* PAGE 452 */
struct yaz_iconv_trie_flat marc8r_31page452_flat[] = {
  {"\x80", 0, 0x6F5630}, /* Korean hangul */
  {"\x88", 0, 0x6F5631}, /* Korean hangul */
  {"\x8B", 0, 0x6F5632}, /* Korean hangul */
  {"\x8D", 0, 0x6F5633}, /* Korean hangul */
  {"\x94", 0, 0x6F5634}, /* Korean hangul */
  {"\x95", 0, 0x6F5635}, /* Korean hangul */
  {"\x98", 0, 0x6F5636}, /* Korean hangul */
  {"\xA5", 0, 0x6F5637}, /* Korean hangul */
  {"\xA7", 0, 0x6F5638}, /* Korean hangul */
  {"\xA9", 0, 0x6F5639}, /* Korean hangul */
  {"\xB0", 0, 0x6F563A}, /* Korean hangul */
  {"\xB1", 0, 0x6F563B}, /* Korean hangul */
  {"\xB4", 0, 0x6F563C}, /* Korean hangul */
  {"\xB7", 0, 0x6F563D}, /* Korean hangul */
  {"\xB8", 0, 0x6F563E}, /* Korean hangul */
  {"\xB9", 0, 0x6F563F}, /* Korean hangul */
  {"\xBA", 0, 0x6F5640}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page452 = {
  marc8r_31page452_flat, 0
};
/* PAGE 451 */
struct yaz_iconv_trie_flat marc8r_31page451_flat[] = {
  {"\x80", 0, 0x6F557E}, /* Korean hangul */
  {"\x81", 0, 0x6F5621}, /* Korean hangul */
  {"\x84", 0, 0x6F5622}, /* Korean hangul */
  {"\x88", 0, 0x6F5623}, /* Korean hangul */
  {"\x90", 0, 0x6F5624}, /* Korean hangul */
  {"\x91", 0, 0x6F5625}, /* Korean hangul */
  {"\x93", 0, 0x6F5626}, /* Korean hangul */
  {"\x94", 0, 0x6F5627}, /* Korean hangul */
  {"\x9C", 0, 0x6F5629}, /* Korean hangul */
  {"\x9D", 0, 0x6F562A}, /* Korean hangul */
  {"\xA0", 0, 0x6F562B}, /* Korean hangul */
  {"\xB1", 0, 0x6F562C}, /* Korean hangul */
  {"\xB8", 0, 0x6F562D}, /* Korean hangul */
  {"\xB9", 0, 0x6F562E}, /* Korean hangul */
  {"\xBC", 0, 0x6F562F}, /* Korean hangul */
  {"\x95", 0, 0x6F5677}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page451 = {
  marc8r_31page451_flat, 0
};
/* PAGE 450 */
struct yaz_iconv_trie_flat marc8r_31page450_flat[] = {
  {"\x80", 0, 0x6F5569}, /* Korean hangul */
  {"\x81", 0, 0x6F556A}, /* Korean hangul */
  {"\x86", 0, 0x6F556B}, /* Korean hangul */
  {"\x87", 0, 0x6F556C}, /* Korean hangul */
  {"\x88", 0, 0x6F556D}, /* Korean hangul */
  {"\x8C", 0, 0x6F556E}, /* Korean hangul */
  {"\x90", 0, 0x6F556F}, /* Korean hangul */
  {"\x9B", 0, 0x6F5570}, /* Korean hangul */
  {"\xA4", 0, 0x6F5571}, /* Korean hangul */
  {"\xA5", 0, 0x6F5572}, /* Korean hangul */
  {"\xA8", 0, 0x6F5573}, /* Korean hangul */
  {"\xAC", 0, 0x6F5574}, /* Korean hangul */
  {"\xAD", 0, 0x6F5575}, /* Korean hangul */
  {"\xAE", 0, 0x6F5576}, /* Korean hangul */
  {"\xB3", 0, 0x6F5577}, /* Korean hangul */
  {"\xB4", 0, 0x6F5578}, /* Korean hangul */
  {"\xB5", 0, 0x6F5579}, /* Korean hangul */
  {"\xB7", 0, 0x6F557A}, /* Korean hangul */
  {"\xB9", 0, 0x6F557B}, /* Korean hangul */
  {"\xBA", 0, 0x6F557C}, /* Korean hangul */
  {"\xBB", 0, 0x6F557D}, /* Korean hangul */
  {"\x9C", 0, 0x6F7739}, /* Korean hangul */
  {"\x9D", 0, 0x6F773A}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page450 = {
  marc8r_31page450_flat, 0
};
/* PAGE 449 */
struct yaz_iconv_trie_flat marc8r_31page449_flat[] = {
  {"\x84", 0, 0x6F554D}, /* Korean hangul */
  {"\x85", 0, 0x6F554E}, /* Korean hangul */
  {"\x86", 0, 0x6F554F}, /* Korean hangul */
  {"\x87", 0, 0x6F5550}, /* Korean hangul */
  {"\x88", 0, 0x6F5551}, /* Korean hangul */
  {"\x89", 0, 0x6F5552}, /* Korean hangul */
  {"\x8A", 0, 0x6F5553}, /* Korean hangul */
  {"\x8C", 0, 0x6F5554}, /* Korean hangul */
  {"\x8E", 0, 0x6F5555}, /* Korean hangul */
  {"\x90", 0, 0x6F5556}, /* Korean hangul */
  {"\x91", 0, 0x6F5557}, /* Korean hangul */
  {"\x94", 0, 0x6F5558}, /* Korean hangul */
  {"\x98", 0, 0x6F5559}, /* Korean hangul */
  {"\xA0", 0, 0x6F555A}, /* Korean hangul */
  {"\xA1", 0, 0x6F555B}, /* Korean hangul */
  {"\xA3", 0, 0x6F555C}, /* Korean hangul */
  {"\xA5", 0, 0x6F555D}, /* Korean hangul */
  {"\xAC", 0, 0x6F555E}, /* Korean hangul */
  {"\xAD", 0, 0x6F555F}, /* Korean hangul */
  {"\xAE", 0, 0x6F5560}, /* Korean hangul */
  {"\xB0", 0, 0x6F5561}, /* Korean hangul */
  {"\xB4", 0, 0x6F5562}, /* Korean hangul */
  {"\xB6", 0, 0x6F5563}, /* Korean hangul */
  {"\xB7", 0, 0x6F5564}, /* Korean hangul */
  {"\xBC", 0, 0x6F5565}, /* Korean hangul */
  {"\xBD", 0, 0x6F5566}, /* Korean hangul */
  {"\xBE", 0, 0x6F5567}, /* Korean hangul */
  {"\xBF", 0, 0x6F5568}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page449 = {
  marc8r_31page449_flat, 0
};
/* PAGE 448 */
struct yaz_iconv_trie_flat marc8r_31page448_flat[] = {
  {"\x80", 0, 0x6F5538}, /* Korean hangul */
  {"\x84", 0, 0x6F5539}, /* Korean hangul */
  {"\x87", 0, 0x6F553A}, /* Korean hangul */
  {"\x8C", 0, 0x6F553B}, /* Korean hangul */
  {"\x8D", 0, 0x6F553C}, /* Korean hangul */
  {"\x8F", 0, 0x6F553D}, /* Korean hangul */
  {"\x90", 0, 0x6F553E}, /* Korean hangul */
  {"\x91", 0, 0x6F553F}, /* Korean hangul */
  {"\x95", 0, 0x6F5540}, /* Korean hangul */
  {"\x97", 0, 0x6F5541}, /* Korean hangul */
  {"\x98", 0, 0x6F5542}, /* Korean hangul */
  {"\x9C", 0, 0x6F5543}, /* Korean hangul */
  {"\xB4", 0, 0x6F5544}, /* Korean hangul */
  {"\xB5", 0, 0x6F5545}, /* Korean hangul */
  {"\xB6", 0, 0x6F5546}, /* Korean hangul */
  {"\xB8", 0, 0x6F5547}, /* Korean hangul */
  {"\xB9", 0, 0x6F5548}, /* Korean hangul */
  {"\xBA", 0, 0x6F5549}, /* Korean hangul */
  {"\xBB", 0, 0x6F554A}, /* Korean hangul */
  {"\xBC", 0, 0x6F554B}, /* Korean hangul */
  {"\xBD", 0, 0x6F554C}, /* Korean hangul */
  {"\xAB", 0, 0x6F7737}, /* Korean hangul */
  {"\xB1", 0, 0x6F7738}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page448 = {
  marc8r_31page448_flat, 0
};
/* PAGE 447 */
struct yaz_iconv_trie_flat marc8r_31page447_flat[] = {
  {"\x84", 0, 0x6F547C}, /* Korean hangul */
  {"\x85", 0, 0x6F547D}, /* Korean hangul */
  {"\x88", 0, 0x6F547E}, /* Korean hangul */
  {"\x89", 0, 0x6F5521}, /* Korean hangul */
  {"\x8A", 0, 0x6F5522}, /* Korean hangul */
  {"\x8C", 0, 0x6F5523}, /* Korean hangul */
  {"\x8E", 0, 0x6F5524}, /* Korean hangul */
  {"\x93", 0, 0x6F5525}, /* Korean hangul */
  {"\x94", 0, 0x6F5526}, /* Korean hangul */
  {"\x95", 0, 0x6F5527}, /* Korean hangul */
  {"\x97", 0, 0x6F5528}, /* Korean hangul */
  {"\x98", 0, 0x6F5529}, /* Korean hangul */
  {"\x99", 0, 0x6F552A}, /* Korean hangul */
  {"\x9E", 0, 0x6F552B}, /* Korean hangul */
  {"\x9F", 0, 0x6F552C}, /* Korean hangul */
  {"\xA0", 0, 0x6F552D}, /* Korean hangul */
  {"\xA1", 0, 0x6F552E}, /* Korean hangul */
  {"\xA4", 0, 0x6F552F}, /* Korean hangul */
  {"\xA8", 0, 0x6F5530}, /* Korean hangul */
  {"\xB0", 0, 0x6F5531}, /* Korean hangul */
  {"\xB1", 0, 0x6F5532}, /* Korean hangul */
  {"\xB3", 0, 0x6F5533}, /* Korean hangul */
  {"\xB4", 0, 0x6F5534}, /* Korean hangul */
  {"\xB5", 0, 0x6F5535}, /* Korean hangul */
  {"\xBC", 0, 0x6F5536}, /* Korean hangul */
  {"\xBD", 0, 0x6F5537}, /* Korean hangul */
  {"\x8D", 0, 0x6F7734}, /* Korean hangul */
  {"\x8F", 0, 0x6F7735}, /* Korean hangul */
  {"\x92", 0, 0x6F7736}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page447 = {
  marc8r_31page447_flat, 0
};
/* PAGE 446 */
struct yaz_iconv_trie_flat marc8r_31page446_flat[] = {
  {"\x80", 0, 0x6F546E}, /* Korean hangul */
  {"\x81", 0, 0x6F546F}, /* Korean hangul */
  {"\x8C", 0, 0x6F5470}, /* Korean hangul */
  {"\x90", 0, 0x6F5471}, /* Korean hangul */
  {"\xA8", 0, 0x6F5472}, /* Korean hangul */
  {"\xA9", 0, 0x6F5473}, /* Korean hangul */
  {"\xAC", 0, 0x6F5474}, /* Korean hangul */
  {"\xB0", 0, 0x6F5475}, /* Korean hangul */
  {"\xB8", 0, 0x6F5476}, /* Korean hangul */
  {"\xB9", 0, 0x6F5477}, /* Korean hangul */
  {"\xBB", 0, 0x6F5478}, /* Korean hangul */
  {"\xBD", 0, 0x6F5479}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page446 = {
  marc8r_31page446_flat, 0
};
/* PAGE 445 */
struct yaz_iconv_trie_flat marc8r_31page445_flat[] = {
  {"\x94", 0, 0x6F5468}, /* Korean hangul */
  {"\x95", 0, 0x6F5469}, /* Korean hangul */
  {"\xB0", 0, 0x6F546A}, /* Korean hangul */
  {"\xB1", 0, 0x6F546B}, /* Korean hangul */
  {"\xB4", 0, 0x6F546C}, /* Korean hangul */
  {"\xB8", 0, 0x6F546D}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page445 = {
  marc8r_31page445_flat, 0
};
/* PAGE 444 */
struct yaz_iconv_trie_flat marc8r_31page444_flat[] = {
  {"\x80", 0, 0x6F5466}, /* Korean hangul */
  {"\x94", 0, 0x6F5467}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page444 = {
  marc8r_31page444_flat, 0
};
/* PAGE 443 */
struct yaz_iconv_trie_flat marc8r_31page443_flat[] = {
  {"\xA4", 0, 0x6F5460}, /* Korean hangul */
  {"\xA5", 0, 0x6F5461}, /* Korean hangul */
  {"\xA8", 0, 0x6F5462}, /* Korean hangul */
  {"\xAC", 0, 0x6F5463}, /* Korean hangul */
  {"\xB4", 0, 0x6F5464}, /* Korean hangul */
  {"\xB9", 0, 0x6F5465}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page443 = {
  marc8r_31page443_flat, 0
};
/* PAGE 442 */
struct yaz_iconv_trie_flat marc8r_31page442_flat[] = {
  {"\x90", 0, 0x6F545A}, /* Korean hangul */
  {"\xAC", 0, 0x6F545B}, /* Korean hangul */
  {"\xB0", 0, 0x6F545C}, /* Korean hangul */
  {"\xB4", 0, 0x6F545D}, /* Korean hangul */
  {"\xBC", 0, 0x6F545E}, /* Korean hangul */
  {"\xBF", 0, 0x6F545F}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page442 = {
  marc8r_31page442_flat, 0
};
/* PAGE 441 */
struct yaz_iconv_trie_flat marc8r_31page441_flat[] = {
  {"\x98", 0, 0x6F5451}, /* Korean hangul */
  {"\x99", 0, 0x6F5452}, /* Korean hangul */
  {"\x9C", 0, 0x6F5453}, /* Korean hangul */
  {"\x9F", 0, 0x6F5454}, /* Korean hangul */
  {"\xA0", 0, 0x6F5455}, /* Korean hangul */
  {"\xA8", 0, 0x6F5456}, /* Korean hangul */
  {"\xAD", 0, 0x6F5457}, /* Korean hangul */
  {"\xB4", 0, 0x6F5458}, /* Korean hangul */
  {"\xB5", 0, 0x6F5459}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page441 = {
  marc8r_31page441_flat, 0
};
/* PAGE 440 */
struct yaz_iconv_trie_flat marc8r_31page440_flat[] = {
  {"\x84", 0, 0x6F544E}, /* Korean hangul */
  {"\x88", 0, 0x6F544F}, /* Korean hangul */
  {"\x99", 0, 0x6F5450}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page440 = {
  marc8r_31page440_flat, 0
};
/* PAGE 439 */
struct yaz_iconv_trie_flat marc8r_31page439_flat[] = {
  {"\x83", 0, 0x6F5443}, /* Korean hangul */
  {"\x85", 0, 0x6F5444}, /* Korean hangul */
  {"\xA8", 0, 0x6F5445}, /* Korean hangul */
  {"\xA9", 0, 0x6F5446}, /* Korean hangul */
  {"\xAC", 0, 0x6F5447}, /* Korean hangul */
  {"\xB0", 0, 0x6F5448}, /* Korean hangul */
  {"\xB2", 0, 0x6F5449}, /* Korean hangul */
  {"\xB8", 0, 0x6F544A}, /* Korean hangul */
  {"\xB9", 0, 0x6F544B}, /* Korean hangul */
  {"\xBC", 0, 0x6F544C}, /* Korean hangul */
  {"\xBD", 0, 0x6F544D}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page439 = {
  marc8r_31page439_flat, 0
};
/* PAGE 438 */
struct yaz_iconv_trie_flat marc8r_31page438_flat[] = {
  {"\x80", 0, 0x6F5433}, /* Korean hangul */
  {"\x88", 0, 0x6F5434}, /* Korean hangul */
  {"\x89", 0, 0x6F5435}, /* Korean hangul */
  {"\x8B", 0, 0x6F5436}, /* Korean hangul */
  {"\x8C", 0, 0x6F5437}, /* Korean hangul */
  {"\x8D", 0, 0x6F5438}, /* Korean hangul */
  {"\x93", 0, 0x6F5439}, /* Korean hangul */
  {"\x94", 0, 0x6F543A}, /* Korean hangul */
  {"\x95", 0, 0x6F543B}, /* Korean hangul */
  {"\x98", 0, 0x6F543C}, /* Korean hangul */
  {"\x9C", 0, 0x6F543D}, /* Korean hangul */
  {"\xA4", 0, 0x6F543E}, /* Korean hangul */
  {"\xA7", 0, 0x6F543F}, /* Korean hangul */
  {"\xA8", 0, 0x6F5440}, /* Korean hangul */
  {"\xA9", 0, 0x6F5441}, /* Korean hangul */
  {"\xB0", 0, 0x6F5442}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page438 = {
  marc8r_31page438_flat, 0
};
/* PAGE 437 */
struct yaz_iconv_trie_flat marc8r_31page437_flat[] = {
  {"\x9C", 0, 0x6F5423}, /* Korean hangul */
  {"\x9D", 0, 0x6F5424}, /* Korean hangul */
  {"\xA0", 0, 0x6F5425}, /* Korean hangul */
  {"\xA3", 0, 0x6F5426}, /* Korean hangul */
  {"\xA4", 0, 0x6F5427}, /* Korean hangul */
  {"\xAB", 0, 0x6F5428}, /* Korean hangul */
  {"\xAC", 0, 0x6F5429}, /* Korean hangul */
  {"\xAD", 0, 0x6F542A}, /* Korean hangul */
  {"\xAF", 0, 0x6F542B}, /* Korean hangul */
  {"\xB1", 0, 0x6F542C}, /* Korean hangul */
  {"\xB6", 0, 0x6F542D}, /* Korean hangul */
  {"\xB8", 0, 0x6F5430}, /* Korean hangul */
  {"\xB9", 0, 0x6F5431}, /* Korean hangul */
  {"\xBC", 0, 0x6F5432}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page437 = {
  marc8r_31page437_flat, 0
};
/* PAGE 436 */
struct yaz_iconv_trie_flat marc8r_31page436_flat[] = {
  {"\x81", 0, 0x6F5370}, /* Korean hangul */
  {"\x88", 0, 0x6F5371}, /* Korean hangul */
  {"\x89", 0, 0x6F5372}, /* Korean hangul */
  {"\x90", 0, 0x6F5373}, /* Korean hangul */
  {"\x98", 0, 0x6F5374}, /* Korean hangul */
  {"\x9B", 0, 0x6F5375}, /* Korean hangul */
  {"\x9D", 0, 0x6F5376}, /* Korean hangul */
  {"\xA4", 0, 0x6F5377}, /* Korean hangul */
  {"\xA5", 0, 0x6F5378}, /* Korean hangul */
  {"\xA8", 0, 0x6F5379}, /* Korean hangul */
  {"\xAC", 0, 0x6F537A}, /* Korean hangul */
  {"\xAD", 0, 0x6F537B}, /* Korean hangul */
  {"\xB4", 0, 0x6F537D}, /* Korean hangul */
  {"\xB5", 0, 0x6F537E}, /* Korean hangul */
  {"\xB7", 0, 0x6F5421}, /* Korean hangul */
  {"\xB9", 0, 0x6F5422}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page436 = {
  marc8r_31page436_flat, 0
};
/* PAGE 435 */
struct yaz_iconv_trie_flat marc8r_31page435_flat[] = {
  {"\x90", 0, 0x6F5368}, /* Korean hangul */
  {"\x98", 0, 0x6F5369}, /* Korean hangul */
  {"\xAC", 0, 0x6F536A}, /* Korean hangul */
  {"\xB0", 0, 0x6F536B}, /* Korean hangul */
  {"\xB4", 0, 0x6F536C}, /* Korean hangul */
  {"\xBC", 0, 0x6F536D}, /* Korean hangul */
  {"\xBD", 0, 0x6F536E}, /* Korean hangul */
  {"\xBF", 0, 0x6F536F}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page435 = {
  marc8r_31page435_flat, 0
};
/* PAGE 434 */
struct yaz_iconv_trie_flat marc8r_31page434_flat[] = {
  {"\x80", 0, 0x6F5357}, /* Korean hangul */
  {"\x84", 0, 0x6F5358}, /* Korean hangul */
  {"\x8D", 0, 0x6F5359}, /* Korean hangul */
  {"\x98", 0, 0x6F535B}, /* Korean hangul */
  {"\x99", 0, 0x6F535C}, /* Korean hangul */
  {"\x9C", 0, 0x6F535D}, /* Korean hangul */
  {"\x9F", 0, 0x6F535E}, /* Korean hangul */
  {"\xA0", 0, 0x6F535F}, /* Korean hangul */
  {"\xA8", 0, 0x6F5360}, /* Korean hangul */
  {"\xA9", 0, 0x6F5361}, /* Korean hangul */
  {"\xAB", 0, 0x6F5362}, /* Korean hangul */
  {"\xAD", 0, 0x6F5363}, /* Korean hangul */
  {"\xAF", 0, 0x6F5364}, /* Korean hangul */
  {"\xB1", 0, 0x6F5365}, /* Korean hangul */
  {"\xB2", 0, 0x6F5366}, /* Korean hangul */
  {"\xB4", 0, 0x6F5367}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page434 = {
  marc8r_31page434_flat, 0
};
/* PAGE 433 */
struct yaz_iconv_trie_flat marc8r_31page433_flat[] = {
  {"\x84", 0, 0x6F534C}, /* Korean hangul */
  {"\x88", 0, 0x6F534D}, /* Korean hangul */
  {"\x97", 0, 0x6F534E}, /* Korean hangul */
  {"\xA0", 0, 0x6F534F}, /* Korean hangul */
  {"\xA4", 0, 0x6F5350}, /* Korean hangul */
  {"\xA8", 0, 0x6F5351}, /* Korean hangul */
  {"\xB0", 0, 0x6F5352}, /* Korean hangul */
  {"\xB1", 0, 0x6F5353}, /* Korean hangul */
  {"\xB3", 0, 0x6F5354}, /* Korean hangul */
  {"\xBC", 0, 0x6F5355}, /* Korean hangul */
  {"\xBD", 0, 0x6F5356}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page433 = {
  marc8r_31page433_flat, 0
};
/* PAGE 432 */
struct yaz_iconv_trie_flat marc8r_31page432_flat[] = {
  {"\x8C", 0, 0x6F533F}, /* Korean hangul */
  {"\x8D", 0, 0x6F5340}, /* Korean hangul */
  {"\x8E", 0, 0x6F5341}, /* Korean hangul */
  {"\x90", 0, 0x6F5342}, /* Korean hangul */
  {"\x94", 0, 0x6F5343}, /* Korean hangul */
  {"\x9C", 0, 0x6F5344}, /* Korean hangul */
  {"\x9D", 0, 0x6F5345}, /* Korean hangul */
  {"\x9F", 0, 0x6F5346}, /* Korean hangul */
  {"\xA1", 0, 0x6F5347}, /* Korean hangul */
  {"\xA5", 0, 0x6F5348}, /* Korean hangul */
  {"\xA8", 0, 0x6F5349}, /* Korean hangul */
  {"\xA9", 0, 0x6F534A}, /* Korean hangul */
  {"\xB0", 0, 0x6F534B}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page432 = {
  marc8r_31page432_flat, 0
};
/* PAGE 431 */
struct yaz_iconv_trie_flat marc8r_31page431_flat[] = {
  {"\x80", 0, 0x6F5334}, /* Korean hangul */
  {"\x88", 0, 0x6F5335}, /* Korean hangul */
  {"\x89", 0, 0x6F5336}, /* Korean hangul */
  {"\x8B", 0, 0x6F5337}, /* Korean hangul */
  {"\x8D", 0, 0x6F5338}, /* Korean hangul */
  {"\x91", 0, 0x6F5339}, /* Korean hangul */
  {"\x94", 0, 0x6F533A}, /* Korean hangul */
  {"\x98", 0, 0x6F533B}, /* Korean hangul */
  {"\xA7", 0, 0x6F533C}, /* Korean hangul */
  {"\xA8", 0, 0x6F533D}, /* Korean hangul */
  {"\xB0", 0, 0x6F533E}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page431 = {
  marc8r_31page431_flat, 0
};
/* PAGE 430 */
struct yaz_iconv_trie_flat marc8r_31page430_flat[] = {
  {"\x9C", 0, 0x6F5321}, /* Korean hangul */
  {"\x9D", 0, 0x6F5322}, /* Korean hangul */
  {"\x9E", 0, 0x6F5323}, /* Korean hangul */
  {"\xA0", 0, 0x6F5324}, /* Korean hangul */
  {"\xA3", 0, 0x6F5325}, /* Korean hangul */
  {"\xA4", 0, 0x6F5326}, /* Korean hangul */
  {"\xA5", 0, 0x6F5327}, /* Korean hangul */
  {"\xA6", 0, 0x6F5328}, /* Korean hangul */
  {"\xA7", 0, 0x6F5329}, /* Korean hangul */
  {"\xAA", 0, 0x6F532A}, /* Korean hangul */
  {"\xAC", 0, 0x6F532B}, /* Korean hangul */
  {"\xAD", 0, 0x6F532C}, /* Korean hangul */
  {"\xAF", 0, 0x6F532D}, /* Korean hangul */
  {"\xB0", 0, 0x6F532E}, /* Korean hangul */
  {"\xB1", 0, 0x6F532F}, /* Korean hangul */
  {"\xB6", 0, 0x6F5330}, /* Korean hangul */
  {"\xB8", 0, 0x6F5331}, /* Korean hangul */
  {"\xB9", 0, 0x6F5332}, /* Korean hangul */
  {"\xBC", 0, 0x6F5333}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page430 = {
  marc8r_31page430_flat, 0
};
/* PAGE 429 */
struct yaz_iconv_trie_flat marc8r_31page429_flat[] = {
  {"\x80", 0, 0x6F526B}, /* Korean hangul */
  {"\x81", 0, 0x6F526C}, /* Korean hangul */
  {"\x85", 0, 0x6F526D}, /* Korean hangul */
  {"\x88", 0, 0x6F526E}, /* Korean hangul */
  {"\x89", 0, 0x6F526F}, /* Korean hangul */
  {"\x8C", 0, 0x6F5270}, /* Korean hangul */
  {"\x8F", 0, 0x6F5271}, /* Korean hangul */
  {"\x90", 0, 0x6F5272}, /* Korean hangul */
  {"\x98", 0, 0x6F5273}, /* Korean hangul */
  {"\x99", 0, 0x6F5274}, /* Korean hangul */
  {"\x9B", 0, 0x6F5275}, /* Korean hangul */
  {"\x9C", 0, 0x6F5276}, /* Korean hangul */
  {"\x9D", 0, 0x6F5277}, /* Korean hangul */
  {"\xA4", 0, 0x6F5278}, /* Korean hangul */
  {"\xA5", 0, 0x6F5279}, /* Korean hangul */
  {"\xA8", 0, 0x6F527A}, /* Korean hangul */
  {"\xAC", 0, 0x6F527B}, /* Korean hangul */
  {"\xB4", 0, 0x6F527C}, /* Korean hangul */
  {"\xB7", 0, 0x6F527D}, /* Korean hangul */
  {"\xB9", 0, 0x6F527E}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page429 = {
  marc8r_31page429_flat, 0
};
/* PAGE 428 */
struct yaz_iconv_trie_flat marc8r_31page428_flat[] = {
  {"\x90", 0, 0x6F5256}, /* Korean hangul */
  {"\x91", 0, 0x6F5257}, /* Korean hangul */
  {"\x94", 0, 0x6F5258}, /* Korean hangul */
  {"\x98", 0, 0x6F5259}, /* Korean hangul */
  {"\xA0", 0, 0x6F525A}, /* Korean hangul */
  {"\xA3", 0, 0x6F525B}, /* Korean hangul */
  {"\xA5", 0, 0x6F525C}, /* Korean hangul */
  {"\xAC", 0, 0x6F525F}, /* Korean hangul */
  {"\xAD", 0, 0x6F5260}, /* Korean hangul */
  {"\xAE", 0, 0x6F5261}, /* Korean hangul */
  {"\xAF", 0, 0x6F5262}, /* Korean hangul */
  {"\xB0", 0, 0x6F5263}, /* Korean hangul */
  {"\xB3", 0, 0x6F5264}, /* Korean hangul */
  {"\xB4", 0, 0x6F5265}, /* Korean hangul */
  {"\xB5", 0, 0x6F5266}, /* Korean hangul */
  {"\xB6", 0, 0x6F5267}, /* Korean hangul */
  {"\xBC", 0, 0x6F5268}, /* Korean hangul */
  {"\xBD", 0, 0x6F5269}, /* Korean hangul */
  {"\xBF", 0, 0x6F526A}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page428 = {
  marc8r_31page428_flat, 0
};
/* PAGE 427 */
struct yaz_iconv_trie_flat marc8r_31page427_flat[] = {
  {"\x98", 0, 0x6F5250}, /* Korean hangul */
  {"\x99", 0, 0x6F5251}, /* Korean hangul */
  {"\x9C", 0, 0x6F5252}, /* Korean hangul */
  {"\xA0", 0, 0x6F5253}, /* Korean hangul */
  {"\xA8", 0, 0x6F5254}, /* Korean hangul */
  {"\xA9", 0, 0x6F5255}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page427 = {
  marc8r_31page427_flat, 0
};
/* PAGE 426 */
struct yaz_iconv_trie_dir marc8r_31page426_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {428, 0, 0},
  {429, 0, 0},
  {430, 0, 0},
  {431, 0, 0},
  {432, 0, 0},
  {433, 0, 0},
  {434, 0, 0},
  {435, 0, 0},
  {436, 0, 0},
  {437, 0, 0},
  {438, 0, 0},
  {439, 0, 0},
  {440, 0, 0},
  {441, 0, 0},
  {442, 0, 0},
  {443, 0, 0},
  {444, 0, 0},
  {445, 0, 0},
  {446, 0, 0},
  {447, 0, 0},
  {448, 0, 0},
  {449, 0, 0},
  {450, 0, 0},
  {451, 0, 0},
  {452, 0, 0},
  {453, 0, 0},
  {454, 0, 0},
  {455, 0, 0},
  {456, 0, 0},
  {457, 0, 0},
  {458, 0, 0},
  {459, 0, 0},
  {460, 0, 0},
  {461, 0, 0},
  {462, 0, 0},
  {463, 0, 0},
  {464, 0, 0},
  {465, 0, 0},
  {466, 0, 0},
  {467, 0, 0},
  {468, 0, 0},
  {469, 0, 0},
  {470, 0, 0},
  {471, 0, 0},
  {472, 0, 0},
  {473, 0, 0},
  {474, 0, 0},
  {475, 0, 0},
  {476, 0, 0},
  {477, 0, 0},
  {478, 0, 0},
  {479, 0, 0},
  {480, 0, 0},
  {481, 0, 0},
  {482, 0, 0},
  {483, 0, 0},
  {484, 0, 0},
  {485, 0, 0},
  {486, 0, 0},
  {487, 0, 0},
  {488, 0, 0},
  {489, 0, 0},
  {490, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page426 = {
  0, marc8r_31page426_dir
};
/* PAGE 425 */
struct yaz_iconv_trie_flat marc8r_31page425_flat[] = {
  {"\x80", 0, 0x6F5247}, /* Korean hangul */
  {"\x85", 0, 0x6F5248}, /* Korean hangul */
  {"\x8C", 0, 0x6F5249}, /* Korean hangul */
  {"\x8D", 0, 0x6F524A}, /* Korean hangul */
  {"\x90", 0, 0x6F524B}, /* Korean hangul */
  {"\x94", 0, 0x6F524C}, /* Korean hangul */
  {"\x9C", 0, 0x6F524D}, /* Korean hangul */
  {"\x9D", 0, 0x6F524E}, /* Korean hangul */
  {"\xA1", 0, 0x6F524F}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page425 = {
  marc8r_31page425_flat, 0
};
/* PAGE 424 */
struct yaz_iconv_trie_flat marc8r_31page424_flat[] = {
  {"\xB0", 0, 0x6F5246}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page424 = {
  marc8r_31page424_flat, 0
};
/* PAGE 423 */
struct yaz_iconv_trie_flat marc8r_31page423_flat[] = {
  {"\x80", 0, 0x6F523F}, /* Korean hangul */
  {"\x81", 0, 0x6F5240}, /* Korean hangul */
  {"\x84", 0, 0x6F5241}, /* Korean hangul */
  {"\x88", 0, 0x6F5242}, /* Korean hangul */
  {"\x90", 0, 0x6F5243}, /* Korean hangul */
  {"\x91", 0, 0x6F5244}, /* Korean hangul */
  {"\x95", 0, 0x6F5245}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page423 = {
  marc8r_31page423_flat, 0
};
/* PAGE 422 */
struct yaz_iconv_trie_flat marc8r_31page422_flat[] = {
  {"\x88", 0, 0x6F523B}, /* Korean hangul */
  {"\x89", 0, 0x6F523C}, /* Korean hangul */
  {"\x98", 0, 0x6F523D}, /* Korean hangul */
  {"\x9D", 0, 0x6F523E}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page422 = {
  marc8r_31page422_flat, 0
};
/* PAGE 421 */
struct yaz_iconv_trie_flat marc8r_31page421_flat[] = {
  {"\x90", 0, 0x6F5231}, /* Korean hangul */
  {"\x91", 0, 0x6F5232}, /* Korean hangul */
  {"\x94", 0, 0x6F5233}, /* Korean hangul */
  {"\x97", 0, 0x6F5234}, /* Korean hangul */
  {"\x98", 0, 0x6F5235}, /* Korean hangul */
  {"\xA0", 0, 0x6F5236}, /* Korean hangul */
  {"\xA3", 0, 0x6F5237}, /* Korean hangul */
  {"\xA4", 0, 0x6F5238}, /* Korean hangul */
  {"\xA5", 0, 0x6F5239}, /* Korean hangul */
  {"\xAC", 0, 0x6F523A}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page421 = {
  marc8r_31page421_flat, 0
};
/* PAGE 420 */
struct yaz_iconv_trie_flat marc8r_31page420_flat[] = {
  {"\x80", 0, 0x6F5229}, /* Korean hangul */
  {"\x84", 0, 0x6F522A}, /* Korean hangul */
  {"\x8C", 0, 0x6F522B}, /* Korean hangul */
  {"\x8F", 0, 0x6F522C}, /* Korean hangul */
  {"\x90", 0, 0x6F522D}, /* Korean hangul */
  {"\x91", 0, 0x6F522E}, /* Korean hangul */
  {"\x98", 0, 0x6F522F}, /* Korean hangul */
  {"\xA8", 0, 0x6F5230}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page420 = {
  marc8r_31page420_flat, 0
};
/* PAGE 419 */
struct yaz_iconv_trie_flat marc8r_31page419_flat[] = {
  {"\x84", 0, 0x6F516D}, /* Korean hangul */
  {"\x85", 0, 0x6F516E}, /* Korean hangul */
  {"\x88", 0, 0x6F516F}, /* Korean hangul */
  {"\x8B", 0, 0x6F5170}, /* Korean hangul */
  {"\x8C", 0, 0x6F5171}, /* Korean hangul */
  {"\x8E", 0, 0x6F5172}, /* Korean hangul */
  {"\x94", 0, 0x6F5173}, /* Korean hangul */
  {"\x95", 0, 0x6F5174}, /* Korean hangul */
  {"\x97", 0, 0x6F5175}, /* Korean hangul */
  {"\x99", 0, 0x6F5176}, /* Korean hangul */
  {"\x9A", 0, 0x6F5177}, /* Korean hangul */
  {"\x9B", 0, 0x6F5178}, /* Korean hangul */
  {"\xA0", 0, 0x6F517B}, /* Korean hangul */
  {"\xA1", 0, 0x6F517C}, /* Korean hangul */
  {"\xA4", 0, 0x6F517D}, /* Korean hangul */
  {"\xA8", 0, 0x6F517E}, /* Korean hangul */
  {"\xB0", 0, 0x6F5221}, /* Korean hangul */
  {"\xB1", 0, 0x6F5222}, /* Korean hangul */
  {"\xB3", 0, 0x6F5223}, /* Korean hangul */
  {"\xB4", 0, 0x6F5224}, /* Korean hangul */
  {"\xB5", 0, 0x6F5225}, /* Korean hangul */
  {"\xBB", 0, 0x6F5226}, /* Korean hangul */
  {"\xBC", 0, 0x6F5227}, /* Korean hangul */
  {"\xBD", 0, 0x6F5228}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page419 = {
  marc8r_31page419_flat, 0
};
/* PAGE 418 */
struct yaz_iconv_trie_flat marc8r_31page418_flat[] = {
  {"\x8C", 0, 0x6F5166}, /* Korean hangul */
  {"\x8D", 0, 0x6F5167}, /* Korean hangul */
  {"\x90", 0, 0x6F5168}, /* Korean hangul */
  {"\x94", 0, 0x6F5169}, /* Korean hangul */
  {"\x9C", 0, 0x6F516A}, /* Korean hangul */
  {"\x9D", 0, 0x6F516B}, /* Korean hangul */
  {"\x9F", 0, 0x6F516C}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page418 = {
  marc8r_31page418_flat, 0
};
/* PAGE 417 */
struct yaz_iconv_trie_flat marc8r_31page417_flat[] = {
  {"\x94", 0, 0x6F5164}, /* Korean hangul */
  {"\xB0", 0, 0x6F5165}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page417 = {
  marc8r_31page417_flat, 0
};
/* PAGE 416 */
struct yaz_iconv_trie_flat marc8r_31page416_flat[] = {
  {"\x80", 0, 0x6F5158}, /* Korean hangul */
  {"\x81", 0, 0x6F5159}, /* Korean hangul */
  {"\x84", 0, 0x6F515A}, /* Korean hangul */
  {"\x87", 0, 0x6F515B}, /* Korean hangul */
  {"\x88", 0, 0x6F515C}, /* Korean hangul */
  {"\x89", 0, 0x6F515D}, /* Korean hangul */
  {"\x90", 0, 0x6F515E}, /* Korean hangul */
  {"\x91", 0, 0x6F515F}, /* Korean hangul */
  {"\x93", 0, 0x6F5160}, /* Korean hangul */
  {"\x95", 0, 0x6F5161}, /* Korean hangul */
  {"\x99", 0, 0x6F5162}, /* Korean hangul */
  {"\x9C", 0, 0x6F5163}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page416 = {
  marc8r_31page416_flat, 0
};
/* PAGE 415 */
struct yaz_iconv_trie_flat marc8r_31page415_flat[] = {
  {"\x88", 0, 0x6F5151}, /* Korean hangul */
  {"\x89", 0, 0x6F5152}, /* Korean hangul */
  {"\x8C", 0, 0x6F5153}, /* Korean hangul */
  {"\x90", 0, 0x6F5154}, /* Korean hangul */
  {"\x98", 0, 0x6F5155}, /* Korean hangul */
  {"\x99", 0, 0x6F5156}, /* Korean hangul */
  {"\xA4", 0, 0x6F5157}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page415 = {
  marc8r_31page415_flat, 0
};
/* PAGE 414 */
struct yaz_iconv_trie_flat marc8r_31page414_flat[] = {
  {"\x84", 0, 0x6F514A}, /* Korean hangul */
  {"\x85", 0, 0x6F514B}, /* Korean hangul */
  {"\x87", 0, 0x6F514C}, /* Korean hangul */
  {"\x89", 0, 0x6F514D}, /* Korean hangul */
  {"\x90", 0, 0x6F514E}, /* Korean hangul */
  {"\x94", 0, 0x6F514F}, /* Korean hangul */
  {"\xA4", 0, 0x6F5150}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page414 = {
  marc8r_31page414_flat, 0
};
/* PAGE 413 */
struct yaz_iconv_trie_flat marc8r_31page413_flat[] = {
  {"\x80", 0, 0x6F513C}, /* Korean hangul */
  {"\x84", 0, 0x6F513D}, /* Korean hangul */
  {"\x8C", 0, 0x6F513E}, /* Korean hangul */
  {"\x8D", 0, 0x6F513F}, /* Korean hangul */
  {"\x8F", 0, 0x6F5140}, /* Korean hangul */
  {"\x90", 0, 0x6F5141}, /* Korean hangul */
  {"\x91", 0, 0x6F5142}, /* Korean hangul */
  {"\x92", 0, 0x6F5143}, /* Korean hangul */
  {"\x95", 0, 0x6F5144}, /* Korean hangul */
  {"\xB4", 0, 0x6F5145}, /* Korean hangul */
  {"\xB5", 0, 0x6F5146}, /* Korean hangul */
  {"\xB6", 0, 0x6F5147}, /* Korean hangul */
  {"\xB8", 0, 0x6F5148}, /* Korean hangul */
  {"\xBC", 0, 0x6F5149}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page413 = {
  marc8r_31page413_flat, 0
};
/* PAGE 412 */
struct yaz_iconv_trie_flat marc8r_31page412_flat[] = {
  {"\x84", 0, 0x6F5126}, /* Korean hangul */
  {"\x85", 0, 0x6F5127}, /* Korean hangul */
  {"\x88", 0, 0x6F5128}, /* Korean hangul */
  {"\x8B", 0, 0x6F5129}, /* Korean hangul */
  {"\x8C", 0, 0x6F512A}, /* Korean hangul */
  {"\x94", 0, 0x6F512B}, /* Korean hangul */
  {"\x95", 0, 0x6F512C}, /* Korean hangul */
  {"\x97", 0, 0x6F512D}, /* Korean hangul */
  {"\x98", 0, 0x6F512E}, /* Korean hangul */
  {"\x99", 0, 0x6F512F}, /* Korean hangul */
  {"\x9A", 0, 0x6F5130}, /* Korean hangul */
  {"\xA0", 0, 0x6F5131}, /* Korean hangul */
  {"\xA1", 0, 0x6F5132}, /* Korean hangul */
  {"\xA4", 0, 0x6F5133}, /* Korean hangul */
  {"\xA7", 0, 0x6F5134}, /* Korean hangul */
  {"\xA8", 0, 0x6F5135}, /* Korean hangul */
  {"\xB0", 0, 0x6F5136}, /* Korean hangul */
  {"\xB1", 0, 0x6F5137}, /* Korean hangul */
  {"\xB3", 0, 0x6F5138}, /* Korean hangul */
  {"\xB5", 0, 0x6F5139}, /* Korean hangul */
  {"\xBC", 0, 0x6F513A}, /* Korean hangul */
  {"\xBD", 0, 0x6F513B}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page412 = {
  marc8r_31page412_flat, 0
};
/* PAGE 411 */
struct yaz_iconv_trie_flat marc8r_31page411_flat[] = {
  {"\x80", 0, 0x6F5121}, /* Korean hangul */
  {"\x81", 0, 0x6F5122}, /* Korean hangul */
  {"\x83", 0, 0x6F5123}, /* Korean hangul */
  {"\x84", 0, 0x6F5124}, /* Korean hangul */
  {"\x85", 0, 0x6F5125}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page411 = {
  marc8r_31page411_flat, 0
};
/* PAGE 410 */
struct yaz_iconv_trie_flat marc8r_31page410_flat[] = {
  {"\x80", 0, 0x6F5063}, /* Korean hangul */
  {"\x88", 0, 0x6F5064}, /* Korean hangul */
  {"\x89", 0, 0x6F5065}, /* Korean hangul */
  {"\x8B", 0, 0x6F5066}, /* Korean hangul */
  {"\x8D", 0, 0x6F5068}, /* Korean hangul */
  {"\x8F", 0, 0x6F5069}, /* Korean hangul */
  {"\x91", 0, 0x6F506A}, /* Korean hangul */
  {"\x94", 0, 0x6F506D}, /* Korean hangul */
  {"\x95", 0, 0x6F506E}, /* Korean hangul */
  {"\x96", 0, 0x6F506F}, /* Korean hangul */
  {"\x98", 0, 0x6F5070}, /* Korean hangul */
  {"\x9B", 0, 0x6F5071}, /* Korean hangul */
  {"\x9C", 0, 0x6F5072}, /* Korean hangul */
  {"\x9D", 0, 0x6F5073}, /* Korean hangul */
  {"\x9F", 0, 0x6F5074}, /* Korean hangul */
  {"\xA4", 0, 0x6F5075}, /* Korean hangul */
  {"\xA5", 0, 0x6F5076}, /* Korean hangul */
  {"\xA7", 0, 0x6F5077}, /* Korean hangul */
  {"\xA9", 0, 0x6F5078}, /* Korean hangul */
  {"\xAD", 0, 0x6F5079}, /* Korean hangul */
  {"\xB0", 0, 0x6F507A}, /* Korean hangul */
  {"\xB1", 0, 0x6F507B}, /* Korean hangul */
  {"\xB4", 0, 0x6F507C}, /* Korean hangul */
  {"\xB7", 0, 0x6F507D}, /* Korean hangul */
  {"\xB8", 0, 0x6F507E}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page410 = {
  marc8r_31page410_flat, 0
};
/* PAGE 409 */
struct yaz_iconv_trie_flat marc8r_31page409_flat[] = {
  {"\x80", 0, 0x6F505B}, /* Korean hangul */
  {"\x84", 0, 0x6F505C}, /* Korean hangul */
  {"\x88", 0, 0x6F505D}, /* Korean hangul */
  {"\x90", 0, 0x6F505E}, /* Korean hangul */
  {"\xB8", 0, 0x6F505F}, /* Korean hangul */
  {"\xB9", 0, 0x6F5060}, /* Korean hangul */
  {"\xBC", 0, 0x6F5061}, /* Korean hangul */
  {"\xBF", 0, 0x6F5062}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page409 = {
  marc8r_31page409_flat, 0
};
/* PAGE 408 */
struct yaz_iconv_trie_flat marc8r_31page408_flat[] = {
  {"\x88", 0, 0x6F5058}, /* Korean hangul */
  {"\x8C", 0, 0x6F5059}, /* Korean hangul */
  {"\xA4", 0, 0x6F505A}, /* Korean hangul */
  {"\xB4", 0, 0x6F506B}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page408 = {
  marc8r_31page408_flat, 0
};
/* PAGE 407 */
struct yaz_iconv_trie_flat marc8r_31page407_flat[] = {
  {"\x84", 0, 0x6F504E}, /* Korean hangul */
  {"\x87", 0, 0x6F504F}, /* Korean hangul */
  {"\x89", 0, 0x6F5050}, /* Korean hangul */
  {"\x8D", 0, 0x6F5051}, /* Korean hangul */
  {"\x8F", 0, 0x6F5052}, /* Korean hangul */
  {"\x90", 0, 0x6F5053}, /* Korean hangul */
  {"\x94", 0, 0x6F5054}, /* Korean hangul */
  {"\x98", 0, 0x6F5055}, /* Korean hangul */
  {"\xA1", 0, 0x6F5056}, /* Korean hangul */
  {"\xA3", 0, 0x6F5057}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page407 = {
  marc8r_31page407_flat, 0
};
/* PAGE 406 */
struct yaz_iconv_trie_flat marc8r_31page406_flat[] = {
  {"\x8F", 0, 0x6F5045}, /* Korean hangul */
  {"\x98", 0, 0x6F5046}, /* Korean hangul */
  {"\xB4", 0, 0x6F5047}, /* Korean hangul */
  {"\xB5", 0, 0x6F5048}, /* Korean hangul */
  {"\xB6", 0, 0x6F5049}, /* Korean hangul */
  {"\xB8", 0, 0x6F504A}, /* Korean hangul */
  {"\xBB", 0, 0x6F504B}, /* Korean hangul */
  {"\xBC", 0, 0x6F504C}, /* Korean hangul */
  {"\xBD", 0, 0x6F504D}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page406 = {
  marc8r_31page406_flat, 0
};
/* PAGE 405 */
struct yaz_iconv_trie_flat marc8r_31page405_flat[] = {
  {"\x83", 0, 0x6F5043}, /* Korean hangul */
  {"\xBC", 0, 0x6F5044}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page405 = {
  marc8r_31page405_flat, 0
};
/* PAGE 404 */
struct yaz_iconv_trie_flat marc8r_31page404_flat[] = {
  {"\x83", 0, 0x6F5036}, /* Korean hangul */
  {"\x84", 0, 0x6F5037}, /* Korean hangul */
  {"\x85", 0, 0x6F5038}, /* Korean hangul */
  {"\x87", 0, 0x6F5039}, /* Korean hangul */
  {"\xA8", 0, 0x6F503A}, /* Korean hangul */
  {"\xA9", 0, 0x6F503B}, /* Korean hangul */
  {"\xAB", 0, 0x6F503C}, /* Korean hangul */
  {"\xAC", 0, 0x6F503D}, /* Korean hangul */
  {"\xB0", 0, 0x6F503E}, /* Korean hangul */
  {"\xB8", 0, 0x6F503F}, /* Korean hangul */
  {"\xB9", 0, 0x6F5040}, /* Korean hangul */
  {"\xBB", 0, 0x6F5041}, /* Korean hangul */
  {"\xBD", 0, 0x6F5042}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page404 = {
  marc8r_31page404_flat, 0
};
/* PAGE 403 */
struct yaz_iconv_trie_flat marc8r_31page403_flat[] = {
  {"\x80", 0, 0x6F5024}, /* Korean hangul */
  {"\x88", 0, 0x6F5025}, /* Korean hangul */
  {"\x89", 0, 0x6F5026}, /* Korean hangul */
  {"\x8B", 0, 0x6F5027}, /* Korean hangul */
  {"\x8D", 0, 0x6F5028}, /* Korean hangul */
  {"\x8E", 0, 0x6F5029}, /* Korean hangul */
  {"\x93", 0, 0x6F502A}, /* Korean hangul */
  {"\x94", 0, 0x6F502B}, /* Korean hangul */
  {"\x95", 0, 0x6F502C}, /* Korean hangul */
  {"\x98", 0, 0x6F502D}, /* Korean hangul */
  {"\x9C", 0, 0x6F502E}, /* Korean hangul */
  {"\xA4", 0, 0x6F502F}, /* Korean hangul */
  {"\xA5", 0, 0x6F5030}, /* Korean hangul */
  {"\xA7", 0, 0x6F5031}, /* Korean hangul */
  {"\xB0", 0, 0x6F5032}, /* Korean hangul */
  {"\xB1", 0, 0x6F5033}, /* Korean hangul */
  {"\xB4", 0, 0x6F5034}, /* Korean hangul */
  {"\xB8", 0, 0x6F5035}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page403 = {
  marc8r_31page403_flat, 0
};
/* PAGE 402 */
struct yaz_iconv_trie_flat marc8r_31page402_flat[] = {
  {"\x80", 0, 0x6F4F7E}, /* Korean hangul */
  {"\xB8", 0, 0x6F5021}, /* Korean hangul */
  {"\xB9", 0, 0x6F5022}, /* Korean hangul */
  {"\xBC", 0, 0x6F5023}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page402 = {
  marc8r_31page402_flat, 0
};
/* PAGE 401 */
struct yaz_iconv_trie_flat marc8r_31page401_flat[] = {
  {"\x81", 0, 0x6F4F63}, /* Korean hangul */
  {"\x88", 0, 0x6F4F66}, /* Korean hangul */
  {"\x89", 0, 0x6F4F67}, /* Korean hangul */
  {"\x8C", 0, 0x6F4F68}, /* Korean hangul */
  {"\x8E", 0, 0x6F4F69}, /* Korean hangul */
  {"\x8F", 0, 0x6F4F6A}, /* Korean hangul */
  {"\x90", 0, 0x6F4F6B}, /* Korean hangul */
  {"\x91", 0, 0x6F4F6C}, /* Korean hangul */
  {"\x98", 0, 0x6F4F6D}, /* Korean hangul */
  {"\x99", 0, 0x6F4F6E}, /* Korean hangul */
  {"\x9B", 0, 0x6F4F6F}, /* Korean hangul */
  {"\x9D", 0, 0x6F4F70}, /* Korean hangul */
  {"\x9E", 0, 0x6F4F71}, /* Korean hangul */
  {"\xA1", 0, 0x6F4F72}, /* Korean hangul */
  {"\xA3", 0, 0x6F4F73}, /* Korean hangul */
  {"\xA4", 0, 0x6F4F74}, /* Korean hangul */
  {"\xA5", 0, 0x6F4F75}, /* Korean hangul */
  {"\xA8", 0, 0x6F4F76}, /* Korean hangul */
  {"\xAC", 0, 0x6F4F77}, /* Korean hangul */
  {"\xB4", 0, 0x6F4F78}, /* Korean hangul */
  {"\xB5", 0, 0x6F4F79}, /* Korean hangul */
  {"\xB7", 0, 0x6F4F7A}, /* Korean hangul */
  {"\xB8", 0, 0x6F4F7B}, /* Korean hangul */
  {"\xB9", 0, 0x6F4F7C}, /* Korean hangul */
  {"\xBA", 0, 0x6F4F7D}, /* Korean hangul */
  {"\x84", 0, 0x6F7733}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page401 = {
  marc8r_31page401_flat, 0
};
/* PAGE 400 */
struct yaz_iconv_trie_flat marc8r_31page400_flat[] = {
  {"\x84", 0, 0x6F4F57}, /* Korean hangul */
  {"\x85", 0, 0x6F4F58}, /* Korean hangul */
  {"\x87", 0, 0x6F4F59}, /* Korean hangul */
  {"\x89", 0, 0x6F4F5A}, /* Korean hangul */
  {"\x8E", 0, 0x6F4F5B}, /* Korean hangul */
  {"\xAC", 0, 0x6F4F5C}, /* Korean hangul */
  {"\xAD", 0, 0x6F4F5D}, /* Korean hangul */
  {"\xB0", 0, 0x6F4F5E}, /* Korean hangul */
  {"\xB4", 0, 0x6F4F5F}, /* Korean hangul */
  {"\xBC", 0, 0x6F4F60}, /* Korean hangul */
  {"\xBD", 0, 0x6F4F61}, /* Korean hangul */
  {"\xBF", 0, 0x6F4F62}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page400 = {
  marc8r_31page400_flat, 0
};
/* PAGE 399 */
struct yaz_iconv_trie_flat marc8r_31page399_flat[] = {
  {"\x98", 0, 0x6F4F4D}, /* Korean hangul */
  {"\x99", 0, 0x6F4F4E}, /* Korean hangul */
  {"\x9C", 0, 0x6F4F4F}, /* Korean hangul */
  {"\xA0", 0, 0x6F4F50}, /* Korean hangul */
  {"\xA8", 0, 0x6F4F51}, /* Korean hangul */
  {"\xAD", 0, 0x6F4F52}, /* Korean hangul */
  {"\xB4", 0, 0x6F4F53}, /* Korean hangul */
  {"\xB5", 0, 0x6F4F54}, /* Korean hangul */
  {"\xB8", 0, 0x6F4F55}, /* Korean hangul */
  {"\xBC", 0, 0x6F4F56}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page399 = {
  marc8r_31page399_flat, 0
};
/* PAGE 398 */
struct yaz_iconv_trie_flat marc8r_31page398_flat[] = {
  {"\x84", 0, 0x6F4F4B}, /* Korean hangul */
  {"\xBC", 0, 0x6F4F4C}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page398 = {
  marc8r_31page398_flat, 0
};
/* PAGE 397 */
struct yaz_iconv_trie_flat marc8r_31page397_flat[] = {
  {"\x8C", 0, 0x6F4F41}, /* Korean hangul */
  {"\xA1", 0, 0x6F4F42}, /* Korean hangul */
  {"\xA8", 0, 0x6F4F43}, /* Korean hangul */
  {"\xA9", 0, 0x6F4F44}, /* Korean hangul */
  {"\xAC", 0, 0x6F4F45}, /* Korean hangul */
  {"\xB0", 0, 0x6F4F46}, /* Korean hangul */
  {"\xB8", 0, 0x6F4F47}, /* Korean hangul */
  {"\xB9", 0, 0x6F4F48}, /* Korean hangul */
  {"\xBB", 0, 0x6F4F49}, /* Korean hangul */
  {"\xBD", 0, 0x6F4F4A}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page397 = {
  marc8r_31page397_flat, 0
};
/* PAGE 396 */
struct yaz_iconv_trie_flat marc8r_31page396_flat[] = {
  {"\xB0", 0, 0x6F4F40}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page396 = {
  marc8r_31page396_flat, 0
};
/* PAGE 395 */
struct yaz_iconv_trie_flat marc8r_31page395_flat[] = {
  {"\x80", 0, 0x6F4F37}, /* Korean hangul */
  {"\x9C", 0, 0x6F4F38}, /* Korean hangul */
  {"\x9D", 0, 0x6F4F39}, /* Korean hangul */
  {"\xA0", 0, 0x6F4F3A}, /* Korean hangul */
  {"\xA4", 0, 0x6F4F3B}, /* Korean hangul */
  {"\xAC", 0, 0x6F4F3C}, /* Korean hangul */
  {"\xAD", 0, 0x6F4F3D}, /* Korean hangul */
  {"\xAF", 0, 0x6F4F3E}, /* Korean hangul */
  {"\xB1", 0, 0x6F4F3F}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page395 = {
  marc8r_31page395_flat, 0
};
/* PAGE 394 */
struct yaz_iconv_trie_flat marc8r_31page394_flat[] = {
  {"\x80", 0, 0x6F4F23}, /* Korean hangul */
  {"\x81", 0, 0x6F4F24}, /* Korean hangul */
  {"\x87", 0, 0x6F4F25}, /* Korean hangul */
  {"\x88", 0, 0x6F4F26}, /* Korean hangul */
  {"\x89", 0, 0x6F4F27}, /* Korean hangul */
  {"\x8C", 0, 0x6F4F28}, /* Korean hangul */
  {"\x90", 0, 0x6F4F29}, /* Korean hangul */
  {"\x98", 0, 0x6F4F2A}, /* Korean hangul */
  {"\x99", 0, 0x6F4F2B}, /* Korean hangul */
  {"\x9B", 0, 0x6F4F2C}, /* Korean hangul */
  {"\x9D", 0, 0x6F4F2D}, /* Korean hangul */
  {"\xA4", 0, 0x6F4F2E}, /* Korean hangul */
  {"\xA5", 0, 0x6F4F2F}, /* Korean hangul */
  {"\xA8", 0, 0x6F4F30}, /* Korean hangul */
  {"\xAC", 0, 0x6F4F31}, /* Korean hangul */
  {"\xB4", 0, 0x6F4F32}, /* Korean hangul */
  {"\xB5", 0, 0x6F4F33}, /* Korean hangul */
  {"\xB7", 0, 0x6F4F34}, /* Korean hangul */
  {"\xB8", 0, 0x6F4F35}, /* Korean hangul */
  {"\xB9", 0, 0x6F4F36}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page394 = {
  marc8r_31page394_flat, 0
};
/* PAGE 393 */
struct yaz_iconv_trie_flat marc8r_31page393_flat[] = {
  {"\x89", 0, 0x6F4E79}, /* Korean hangul */
  {"\xAC", 0, 0x6F4E7A}, /* Korean hangul */
  {"\xAD", 0, 0x6F4E7B}, /* Korean hangul */
  {"\xB0", 0, 0x6F4E7C}, /* Korean hangul */
  {"\xB4", 0, 0x6F4E7D}, /* Korean hangul */
  {"\xBC", 0, 0x6F4E7E}, /* Korean hangul */
  {"\xBD", 0, 0x6F4F21}, /* Korean hangul */
  {"\xBF", 0, 0x6F4F22}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page393 = {
  marc8r_31page393_flat, 0
};
/* PAGE 392 */
struct yaz_iconv_trie_flat marc8r_31page392_flat[] = {
  {"\x80", 0, 0x6F4E66}, /* Korean hangul */
  {"\x84", 0, 0x6F4E67}, /* Korean hangul */
  {"\x8C", 0, 0x6F4E68}, /* Korean hangul */
  {"\x8D", 0, 0x6F4E69}, /* Korean hangul */
  {"\x8F", 0, 0x6F4E6A}, /* Korean hangul */
  {"\x90", 0, 0x6F4E6B}, /* Korean hangul */
  {"\x91", 0, 0x6F4E6C}, /* Korean hangul */
  {"\x97", 0, 0x6F4E6D}, /* Korean hangul */
  {"\x98", 0, 0x6F4E6E}, /* Korean hangul */
  {"\x99", 0, 0x6F4E6F}, /* Korean hangul */
  {"\x9C", 0, 0x6F4E70}, /* Korean hangul */
  {"\xA0", 0, 0x6F4E71}, /* Korean hangul */
  {"\xA8", 0, 0x6F4E72}, /* Korean hangul */
  {"\xA9", 0, 0x6F4E73}, /* Korean hangul */
  {"\xAB", 0, 0x6F4E74}, /* Korean hangul */
  {"\xAC", 0, 0x6F4E75}, /* Korean hangul */
  {"\xAD", 0, 0x6F4E76}, /* Korean hangul */
  {"\xB4", 0, 0x6F4E77}, /* Korean hangul */
  {"\xB5", 0, 0x6F4E78}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page392 = {
  marc8r_31page392_flat, 0
};
/* PAGE 391 */
struct yaz_iconv_trie_flat marc8r_31page391_flat[] = {
  {"\x84", 0, 0x6F4E5A}, /* Korean hangul */
  {"\x88", 0, 0x6F4E5B}, /* Korean hangul */
  {"\xA0", 0, 0x6F4E5C}, /* Korean hangul */
  {"\xA4", 0, 0x6F4E5D}, /* Korean hangul */
  {"\xA8", 0, 0x6F4E5E}, /* Korean hangul */
  {"\xB0", 0, 0x6F4E5F}, /* Korean hangul */
  {"\xB1", 0, 0x6F4E60}, /* Korean hangul */
  {"\xB5", 0, 0x6F4E61}, /* Korean hangul */
  {"\xBC", 0, 0x6F4E64}, /* Korean hangul */
  {"\xBD", 0, 0x6F4E65}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page391 = {
  marc8r_31page391_flat, 0
};
/* PAGE 390 */
struct yaz_iconv_trie_flat marc8r_31page390_flat[] = {
  {"\x80", 0, 0x6F4E50}, /* Korean hangul */
  {"\x81", 0, 0x6F4E51}, /* Korean hangul */
  {"\xA8", 0, 0x6F4E52}, /* Korean hangul */
  {"\xA9", 0, 0x6F4E53}, /* Korean hangul */
  {"\xAC", 0, 0x6F4E54}, /* Korean hangul */
  {"\xAF", 0, 0x6F4E55}, /* Korean hangul */
  {"\xB0", 0, 0x6F4E56}, /* Korean hangul */
  {"\xB8", 0, 0x6F4E57}, /* Korean hangul */
  {"\xB9", 0, 0x6F4E58}, /* Korean hangul */
  {"\xBB", 0, 0x6F4E59}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page390 = {
  marc8r_31page390_flat, 0
};
/* PAGE 389 */
struct yaz_iconv_trie_flat marc8r_31page389_flat[] = {
  {"\xB0", 0, 0x6F4E4D}, /* Korean hangul */
  {"\xB4", 0, 0x6F4E4E}, /* Korean hangul */
  {"\xB8", 0, 0x6F4E4F}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page389 = {
  marc8r_31page389_flat, 0
};
/* PAGE 388 */
struct yaz_iconv_trie_flat marc8r_31page388_flat[] = {
  {"\x9C", 0, 0x6F4E47}, /* Korean hangul */
  {"\x9D", 0, 0x6F4E48}, /* Korean hangul */
  {"\xA4", 0, 0x6F4E49}, /* Korean hangul */
  {"\xAB", 0, 0x6F4E4A}, /* Korean hangul */
  {"\xAC", 0, 0x6F4E4B}, /* Korean hangul */
  {"\xB1", 0, 0x6F4E4C}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page388 = {
  marc8r_31page388_flat, 0
};
/* PAGE 387 */
struct yaz_iconv_trie_flat marc8r_31page387_flat[] = {
  {"\xA4", 0, 0x6F4E46}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page387 = {
  marc8r_31page387_flat, 0
};
/* PAGE 386 */
struct yaz_iconv_trie_flat marc8r_31page386_flat[] = {
  {"\x90", 0, 0x6F4E41}, /* Korean hangul */
  {"\x91", 0, 0x6F4E42}, /* Korean hangul */
  {"\x94", 0, 0x6F4E43}, /* Korean hangul */
  {"\x98", 0, 0x6F4E44}, /* Korean hangul */
  {"\xA5", 0, 0x6F4E45}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page386 = {
  marc8r_31page386_flat, 0
};
/* PAGE 385 */
struct yaz_iconv_trie_flat marc8r_31page385_flat[] = {
  {"\x80", 0, 0x6F4E3C}, /* Korean hangul */
  {"\x84", 0, 0x6F4E3D}, /* Korean hangul */
  {"\x8C", 0, 0x6F4E3E}, /* Korean hangul */
  {"\x8F", 0, 0x6F4E3F}, /* Korean hangul */
  {"\x91", 0, 0x6F4E40}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page385 = {
  marc8r_31page385_flat, 0
};
/* PAGE 384 */
struct yaz_iconv_trie_flat marc8r_31page384_flat[] = {
  {"\xA0", 0, 0x6F4E30}, /* Korean hangul */
  {"\xA1", 0, 0x6F4E31}, /* Korean hangul */
  {"\xA4", 0, 0x6F4E32}, /* Korean hangul */
  {"\xA8", 0, 0x6F4E33}, /* Korean hangul */
  {"\xAB", 0, 0x6F4E34}, /* Korean hangul */
  {"\xB0", 0, 0x6F4E35}, /* Korean hangul */
  {"\xB1", 0, 0x6F4E36}, /* Korean hangul */
  {"\xB3", 0, 0x6F4E37}, /* Korean hangul */
  {"\xB4", 0, 0x6F4E38}, /* Korean hangul */
  {"\xB5", 0, 0x6F4E39}, /* Korean hangul */
  {"\xBB", 0, 0x6F4E3A}, /* Korean hangul */
  {"\xBC", 0, 0x6F4E3B}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page384 = {
  marc8r_31page384_flat, 0
};
/* PAGE 383 */
struct yaz_iconv_trie_flat marc8r_31page383_flat[] = {
  {"\x80", 0, 0x6F4E21}, /* Korean hangul */
  {"\x81", 0, 0x6F4E22}, /* Korean hangul */
  {"\x83", 0, 0x6F4E23}, /* Korean hangul */
  {"\x84", 0, 0x6F4E24}, /* Korean hangul */
  {"\x85", 0, 0x6F4E25}, /* Korean hangul */
  {"\x8B", 0, 0x6F4E26}, /* Korean hangul */
  {"\x8C", 0, 0x6F4E27}, /* Korean hangul */
  {"\x8D", 0, 0x6F4E28}, /* Korean hangul */
  {"\x90", 0, 0x6F4E29}, /* Korean hangul */
  {"\x94", 0, 0x6F4E2A}, /* Korean hangul */
  {"\x9C", 0, 0x6F4E2B}, /* Korean hangul */
  {"\x9D", 0, 0x6F4E2C}, /* Korean hangul */
  {"\x9F", 0, 0x6F4E2D}, /* Korean hangul */
  {"\xA0", 0, 0x6F4E2E}, /* Korean hangul */
  {"\xA1", 0, 0x6F4E2F}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page383 = {
  marc8r_31page383_flat, 0
};
/* PAGE 382 */
struct yaz_iconv_trie_flat marc8r_31page382_flat[] = {
  {"\x94", 0, 0x6F4D6B}, /* Korean hangul */
  {"\x95", 0, 0x6F4D6C}, /* Korean hangul */
  {"\x98", 0, 0x6F4D6D}, /* Korean hangul */
  {"\x9B", 0, 0x6F4D6E}, /* Korean hangul */
  {"\x9C", 0, 0x6F4D6F}, /* Korean hangul */
  {"\xA4", 0, 0x6F4D70}, /* Korean hangul */
  {"\xA5", 0, 0x6F4D71}, /* Korean hangul */
  {"\xA7", 0, 0x6F4D72}, /* Korean hangul */
  {"\xA8", 0, 0x6F4D73}, /* Korean hangul */
  {"\xA9", 0, 0x6F4D74}, /* Korean hangul */
  {"\xAA", 0, 0x6F4D75}, /* Korean hangul */
  {"\xB0", 0, 0x6F4D78}, /* Korean hangul */
  {"\xB1", 0, 0x6F4D79}, /* Korean hangul */
  {"\xB2", 0, 0x6F4D7A}, /* Korean hangul */
  {"\xB4", 0, 0x6F4D7B}, /* Korean hangul */
  {"\xB7", 0, 0x6F4D7C}, /* Korean hangul */
  {"\xB8", 0, 0x6F4D7D}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page382 = {
  marc8r_31page382_flat, 0
};
/* PAGE 381 */
struct yaz_iconv_trie_flat marc8r_31page381_flat[] = {
  {"\x80", 0, 0x6F4D60}, /* Korean hangul */
  {"\x90", 0, 0x6F4D61}, /* Korean hangul */
  {"\x9C", 0, 0x6F4D62}, /* Korean hangul */
  {"\x9D", 0, 0x6F4D63}, /* Korean hangul */
  {"\xA0", 0, 0x6F4D64}, /* Korean hangul */
  {"\xA3", 0, 0x6F4D65}, /* Korean hangul */
  {"\xA4", 0, 0x6F4D66}, /* Korean hangul */
  {"\xAC", 0, 0x6F4D67}, /* Korean hangul */
  {"\xAD", 0, 0x6F4D68}, /* Korean hangul */
  {"\xAF", 0, 0x6F4D69}, /* Korean hangul */
  {"\xB1", 0, 0x6F4D6A}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page381 = {
  marc8r_31page381_flat, 0
};
/* PAGE 380 */
struct yaz_iconv_trie_flat marc8r_31page380_flat[] = {
  {"\x80", 0, 0x6F4D5C}, /* Korean hangul */
  {"\x88", 0, 0x6F4D5D}, /* Korean hangul */
  {"\xA4", 0, 0x6F4D5E}, /* Korean hangul */
  {"\xB7", 0, 0x6F4D5F}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page380 = {
  marc8r_31page380_flat, 0
};
/* PAGE 379 */
struct yaz_iconv_trie_flat marc8r_31page379_flat[] = {
  {"\x90", 0, 0x6F4D53}, /* Korean hangul */
  {"\x91", 0, 0x6F4D54}, /* Korean hangul */
  {"\x94", 0, 0x6F4D55}, /* Korean hangul */
  {"\x98", 0, 0x6F4D56}, /* Korean hangul */
  {"\xA0", 0, 0x6F4D57}, /* Korean hangul */
  {"\xA1", 0, 0x6F4D58}, /* Korean hangul */
  {"\xA3", 0, 0x6F4D59}, /* Korean hangul */
  {"\xA5", 0, 0x6F4D5A}, /* Korean hangul */
  {"\xAC", 0, 0x6F4D5B}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page379 = {
  marc8r_31page379_flat, 0
};
/* PAGE 378 */
struct yaz_iconv_trie_flat marc8r_31page378_flat[] = {
  {"\x80", 0, 0x6F4D4A}, /* Korean hangul */
  {"\x90", 0, 0x6F4D4B}, /* Korean hangul */
  {"\x98", 0, 0x6F4D4C}, /* Korean hangul */
  {"\x9C", 0, 0x6F4D4D}, /* Korean hangul */
  {"\xA0", 0, 0x6F4D4E}, /* Korean hangul */
  {"\xA8", 0, 0x6F4D4F}, /* Korean hangul */
  {"\xA9", 0, 0x6F4D50}, /* Korean hangul */
  {"\xAB", 0, 0x6F4D51}, /* Korean hangul */
  {"\xAC", 0, 0x6F4D52}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page378 = {
  marc8r_31page378_flat, 0
};
/* PAGE 377 */
struct yaz_iconv_trie_flat marc8r_31page377_flat[] = {
  {"\x84", 0, 0x6F4D3E}, /* Korean hangul */
  {"\x85", 0, 0x6F4D3F}, /* Korean hangul */
  {"\x88", 0, 0x6F4D40}, /* Korean hangul */
  {"\x8B", 0, 0x6F4D41}, /* Korean hangul */
  {"\x8C", 0, 0x6F4D42}, /* Korean hangul */
  {"\x90", 0, 0x6F4D43}, /* Korean hangul */
  {"\x94", 0, 0x6F4D44}, /* Korean hangul */
  {"\x95", 0, 0x6F4D45}, /* Korean hangul */
  {"\x97", 0, 0x6F4D46}, /* Korean hangul */
  {"\x99", 0, 0x6F4D47}, /* Korean hangul */
  {"\x9B", 0, 0x6F4D48}, /* Korean hangul */
  {"\xBC", 0, 0x6F4D49}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page377 = {
  marc8r_31page377_flat, 0
};
/* PAGE 376 */
struct yaz_iconv_trie_flat marc8r_31page376_flat[] = {
  {"\x80", 0, 0x6F4D3A}, /* Korean hangul */
  {"\x83", 0, 0x6F4D3B}, /* Korean hangul */
  {"\x85", 0, 0x6F4D3C}, /* Korean hangul */
  {"\x8C", 0, 0x6F4D3D}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page376 = {
  marc8r_31page376_flat, 0
};
/* PAGE 375 */
struct yaz_iconv_trie_flat marc8r_31page375_flat[] = {
  {"\x94", 0, 0x6F4D28}, /* Korean hangul */
  {"\x95", 0, 0x6F4D29}, /* Korean hangul */
  {"\x98", 0, 0x6F4D2A}, /* Korean hangul */
  {"\x9B", 0, 0x6F4D2B}, /* Korean hangul */
  {"\x9C", 0, 0x6F4D2C}, /* Korean hangul */
  {"\x9F", 0, 0x6F4D2D}, /* Korean hangul */
  {"\xA4", 0, 0x6F4D2E}, /* Korean hangul */
  {"\xA5", 0, 0x6F4D2F}, /* Korean hangul */
  {"\xA7", 0, 0x6F4D30}, /* Korean hangul */
  {"\xA8", 0, 0x6F4D31}, /* Korean hangul */
  {"\xA9", 0, 0x6F4D32}, /* Korean hangul */
  {"\xAA", 0, 0x6F4D33}, /* Korean hangul */
  {"\xAB", 0, 0x6F4D34}, /* Korean hangul */
  {"\xAE", 0, 0x6F4D35}, /* Korean hangul */
  {"\xB0", 0, 0x6F4D36}, /* Korean hangul */
  {"\xB1", 0, 0x6F4D37}, /* Korean hangul */
  {"\xB4", 0, 0x6F4D38}, /* Korean hangul */
  {"\xB8", 0, 0x6F4D39}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page375 = {
  marc8r_31page375_flat, 0
};
/* PAGE 374 */
struct yaz_iconv_trie_flat marc8r_31page374_flat[] = {
  {"\x80", 0, 0x6F4C7D}, /* Korean hangul */
  {"\x81", 0, 0x6F4C7E}, /* Korean hangul */
  {"\x84", 0, 0x6F4D21}, /* Korean hangul */
  {"\x88", 0, 0x6F4D22}, /* Korean hangul */
  {"\x90", 0, 0x6F4D23}, /* Korean hangul */
  {"\x91", 0, 0x6F4D24}, /* Korean hangul */
  {"\x93", 0, 0x6F4D25}, /* Korean hangul */
  {"\x94", 0, 0x6F4D26}, /* Korean hangul */
  {"\x95", 0, 0x6F4D27}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page374 = {
  marc8r_31page374_flat, 0
};
/* PAGE 373 */
struct yaz_iconv_trie_flat marc8r_31page373_flat[] = {
  {"\x88", 0, 0x6F4C62}, /* Korean hangul */
  {"\x89", 0, 0x6F4C63}, /* Korean hangul */
  {"\x8C", 0, 0x6F4C64}, /* Korean hangul */
  {"\x90", 0, 0x6F4C65}, /* Korean hangul */
  {"\x98", 0, 0x6F4C66}, /* Korean hangul */
  {"\x99", 0, 0x6F4C67}, /* Korean hangul */
  {"\x9B", 0, 0x6F4C68}, /* Korean hangul */
  {"\x9D", 0, 0x6F4C69}, /* Korean hangul */
  {"\xA2", 0, 0x6F4C6A}, /* Korean hangul */
  {"\xA4", 0, 0x6F4C6D}, /* Korean hangul */
  {"\xA5", 0, 0x6F4C6E}, /* Korean hangul */
  {"\xA6", 0, 0x6F4C6F}, /* Korean hangul */
  {"\xA8", 0, 0x6F4C70}, /* Korean hangul */
  {"\xAB", 0, 0x6F4C71}, /* Korean hangul */
  {"\xAC", 0, 0x6F4C72}, /* Korean hangul */
  {"\xAD", 0, 0x6F4C73}, /* Korean hangul */
  {"\xAE", 0, 0x6F4C74}, /* Korean hangul */
  {"\xB3", 0, 0x6F4C75}, /* Korean hangul */
  {"\xB4", 0, 0x6F4C76}, /* Korean hangul */
  {"\xB5", 0, 0x6F4C77}, /* Korean hangul */
  {"\xB7", 0, 0x6F4C78}, /* Korean hangul */
  {"\xB9", 0, 0x6F4C79}, /* Korean hangul */
  {"\xBA", 0, 0x6F4C7A}, /* Korean hangul */
  {"\xBB", 0, 0x6F4C7B}, /* Korean hangul */
  {"\xBF", 0, 0x6F4C7C}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page373 = {
  marc8r_31page373_flat, 0
};
/* PAGE 372 */
struct yaz_iconv_trie_flat marc8r_31page372_flat[] = {
  {"\x84", 0, 0x6F4C55}, /* Korean hangul */
  {"\x89", 0, 0x6F4C56}, /* Korean hangul */
  {"\x90", 0, 0x6F4C57}, /* Korean hangul */
  {"\x91", 0, 0x6F4C58}, /* Korean hangul */
  {"\x94", 0, 0x6F4C59}, /* Korean hangul */
  {"\x98", 0, 0x6F4C5A}, /* Korean hangul */
  {"\x99", 0, 0x6F4C5B}, /* Korean hangul */
  {"\xA0", 0, 0x6F4C5C}, /* Korean hangul */
  {"\xA1", 0, 0x6F4C5D}, /* Korean hangul */
  {"\xA5", 0, 0x6F4C5E}, /* Korean hangul */
  {"\xA6", 0, 0x6F4C5F}, /* Korean hangul */
  {"\xAA", 0, 0x6F4C60}, /* Korean hangul */
  {"\xAC", 0, 0x6F4C61}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page372 = {
  marc8r_31page372_flat, 0
};
/* PAGE 371 */
struct yaz_iconv_trie_flat marc8r_31page371_flat[] = {
  {"\x98", 0, 0x6F4C4F}, /* Korean hangul */
  {"\x9C", 0, 0x6F4C50}, /* Korean hangul */
  {"\xA0", 0, 0x6F4C51}, /* Korean hangul */
  {"\xA8", 0, 0x6F4C52}, /* Korean hangul */
  {"\xA9", 0, 0x6F4C53}, /* Korean hangul */
  {"\xB4", 0, 0x6F4C54}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page371 = {
  marc8r_31page371_flat, 0
};
/* PAGE 370 */
struct yaz_iconv_trie_flat marc8r_31page370_flat[] = {
  {"\x84", 0, 0x6F4C43}, /* Korean hangul */
  {"\x85", 0, 0x6F4C44}, /* Korean hangul */
  {"\x88", 0, 0x6F4C45}, /* Korean hangul */
  {"\x8B", 0, 0x6F4C46}, /* Korean hangul */
  {"\x8C", 0, 0x6F4C47}, /* Korean hangul */
  {"\x93", 0, 0x6F4C48}, /* Korean hangul */
  {"\x94", 0, 0x6F4C49}, /* Korean hangul */
  {"\x95", 0, 0x6F4C4A}, /* Korean hangul */
  {"\x97", 0, 0x6F4C4B}, /* Korean hangul */
  {"\xA0", 0, 0x6F4C4C}, /* Korean hangul */
  {"\xB3", 0, 0x6F4C4D}, /* Korean hangul */
  {"\xB4", 0, 0x6F4C4E}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page370 = {
  marc8r_31page370_flat, 0
};
/* PAGE 369 */
struct yaz_iconv_trie_flat marc8r_31page369_flat[] = {
  {"\x8C", 0, 0x6F4C3D}, /* Korean hangul */
  {"\x90", 0, 0x6F4C3E}, /* Korean hangul */
  {"\x94", 0, 0x6F4C3F}, /* Korean hangul */
  {"\x9C", 0, 0x6F4C40}, /* Korean hangul */
  {"\xA8", 0, 0x6F4C41}, /* Korean hangul */
  {"\xBD", 0, 0x6F4C42}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page369 = {
  marc8r_31page369_flat, 0
};
/* PAGE 368 */
struct yaz_iconv_trie_flat marc8r_31page368_flat[] = {
  {"\x80", 0, 0x6F4C34}, /* Korean hangul */
  {"\x88", 0, 0x6F4C35}, /* Korean hangul */
  {"\x89", 0, 0x6F4C36}, /* Korean hangul */
  {"\x8B", 0, 0x6F4C37}, /* Korean hangul */
  {"\x8D", 0, 0x6F4C38}, /* Korean hangul */
  {"\x92", 0, 0x6F4C39}, /* Korean hangul */
  {"\x93", 0, 0x6F4C3A}, /* Korean hangul */
  {"\x94", 0, 0x6F4C3B}, /* Korean hangul */
  {"\xA8", 0, 0x6F4C3C}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page368 = {
  marc8r_31page368_flat, 0
};
/* PAGE 367 */
struct yaz_iconv_trie_flat marc8r_31page367_flat[] = {
  {"\x80", 0, 0x6F4C26}, /* Korean hangul */
  {"\x81", 0, 0x6F4C27}, /* Korean hangul */
  {"\x84", 0, 0x6F4C28}, /* Korean hangul */
  {"\x90", 0, 0x6F4C29}, /* Korean hangul */
  {"\x91", 0, 0x6F4C2A}, /* Korean hangul */
  {"\x93", 0, 0x6F4C2B}, /* Korean hangul */
  {"\x94", 0, 0x6F4C2C}, /* Korean hangul */
  {"\x95", 0, 0x6F4C2D}, /* Korean hangul */
  {"\x98", 0, 0x6F4C2E}, /* Korean hangul */
  {"\x9C", 0, 0x6F4C2F}, /* Korean hangul */
  {"\xB8", 0, 0x6F4C30}, /* Korean hangul */
  {"\xB9", 0, 0x6F4C31}, /* Korean hangul */
  {"\xBA", 0, 0x6F4C32}, /* Korean hangul */
  {"\xBC", 0, 0x6F4C33}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page367 = {
  marc8r_31page367_flat, 0
};
/* PAGE 366 */
struct yaz_iconv_trie_flat marc8r_31page366_flat[] = {
  {"\x88", 0, 0x6F4B6E}, /* Korean hangul */
  {"\x89", 0, 0x6F4B6F}, /* Korean hangul */
  {"\x8B", 0, 0x6F4B71}, /* Korean hangul */
  {"\x8C", 0, 0x6F4B72}, /* Korean hangul */
  {"\x8F", 0, 0x6F4B73}, /* Korean hangul */
  {"\x90", 0, 0x6F4B74}, /* Korean hangul */
  {"\x93", 0, 0x6F4B75}, /* Korean hangul */
  {"\x98", 0, 0x6F4B76}, /* Korean hangul */
  {"\x99", 0, 0x6F4B77}, /* Korean hangul */
  {"\x9B", 0, 0x6F4B78}, /* Korean hangul */
  {"\x9C", 0, 0x6F4B79}, /* Korean hangul */
  {"\x9D", 0, 0x6F4B7A}, /* Korean hangul */
  {"\x9E", 0, 0x6F4B7B}, /* Korean hangul */
  {"\xA3", 0, 0x6F4B7C}, /* Korean hangul */
  {"\xA4", 0, 0x6F4B7D}, /* Korean hangul */
  {"\xA5", 0, 0x6F4B7E}, /* Korean hangul */
  {"\xA8", 0, 0x6F4C21}, /* Korean hangul */
  {"\xAC", 0, 0x6F4C22}, /* Korean hangul */
  {"\xB4", 0, 0x6F4C23}, /* Korean hangul */
  {"\xB5", 0, 0x6F4C24}, /* Korean hangul */
  {"\xB7", 0, 0x6F4C25}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page366 = {
  marc8r_31page366_flat, 0
};
/* PAGE 365 */
struct yaz_iconv_trie_flat marc8r_31page365_flat[] = {
  {"\x84", 0, 0x6F4B64}, /* Korean hangul */
  {"\x85", 0, 0x6F4B65}, /* Korean hangul */
  {"\x87", 0, 0x6F4B66}, /* Korean hangul */
  {"\x88", 0, 0x6F4B67}, /* Korean hangul */
  {"\x89", 0, 0x6F4B68}, /* Korean hangul */
  {"\x90", 0, 0x6F4B69}, /* Korean hangul */
  {"\x91", 0, 0x6F4B6A}, /* Korean hangul */
  {"\xA0", 0, 0x6F4B6B}, /* Korean hangul */
  {"\xA5", 0, 0x6F4B6C}, /* Korean hangul */
  {"\xAC", 0, 0x6F4B6D}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page365 = {
  marc8r_31page365_flat, 0
};
/* PAGE 364 */
struct yaz_iconv_trie_flat marc8r_31page364_flat[] = {
  {"\x80", 0, 0x6F4B46}, /* Korean hangul */
  {"\x84", 0, 0x6F4B47}, /* Korean hangul */
  {"\x8C", 0, 0x6F4B48}, /* Korean hangul */
  {"\x8D", 0, 0x6F4B49}, /* Korean hangul */
  {"\x8F", 0, 0x6F4B4A}, /* Korean hangul */
  {"\x90", 0, 0x6F4B4B}, /* Korean hangul */
  {"\x91", 0, 0x6F4B4C}, /* Korean hangul */
  {"\x98", 0, 0x6F4B4F}, /* Korean hangul */
  {"\x99", 0, 0x6F4B50}, /* Korean hangul */
  {"\x9A", 0, 0x6F4B51}, /* Korean hangul */
  {"\x9C", 0, 0x6F4B52}, /* Korean hangul */
  {"\x9F", 0, 0x6F4B53}, /* Korean hangul */
  {"\xA0", 0, 0x6F4B54}, /* Korean hangul */
  {"\xA1", 0, 0x6F4B55}, /* Korean hangul */
  {"\xA8", 0, 0x6F4B56}, /* Korean hangul */
  {"\xA9", 0, 0x6F4B57}, /* Korean hangul */
  {"\xAB", 0, 0x6F4B58}, /* Korean hangul */
  {"\xAC", 0, 0x6F4B59}, /* Korean hangul */
  {"\xAD", 0, 0x6F4B5A}, /* Korean hangul */
  {"\xAE", 0, 0x6F4B5B}, /* Korean hangul */
  {"\xAF", 0, 0x6F4B5C}, /* Korean hangul */
  {"\xB1", 0, 0x6F4B5D}, /* Korean hangul */
  {"\xB3", 0, 0x6F4B5E}, /* Korean hangul */
  {"\xB4", 0, 0x6F4B5F}, /* Korean hangul */
  {"\xB5", 0, 0x6F4B60}, /* Korean hangul */
  {"\xB8", 0, 0x6F4B61}, /* Korean hangul */
  {"\xBB", 0, 0x6F4B62}, /* Korean hangul */
  {"\xBC", 0, 0x6F4B63}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page364 = {
  marc8r_31page364_flat, 0
};
/* PAGE 363 */
struct yaz_iconv_trie_flat marc8r_31page363_flat[] = {
  {"\x84", 0, 0x6F4B39}, /* Korean hangul */
  {"\x85", 0, 0x6F4B3A}, /* Korean hangul */
  {"\x88", 0, 0x6F4B3B}, /* Korean hangul */
  {"\x8A", 0, 0x6F4B3C}, /* Korean hangul */
  {"\x8C", 0, 0x6F4B3D}, /* Korean hangul */
  {"\x93", 0, 0x6F4B3E}, /* Korean hangul */
  {"\x94", 0, 0x6F4B3F}, /* Korean hangul */
  {"\x95", 0, 0x6F4B40}, /* Korean hangul */
  {"\x97", 0, 0x6F4B41}, /* Korean hangul */
  {"\x99", 0, 0x6F4B42}, /* Korean hangul */
  {"\x9D", 0, 0x6F4B43}, /* Korean hangul */
  {"\xBC", 0, 0x6F4B44}, /* Korean hangul */
  {"\xBD", 0, 0x6F4B45}, /* Korean hangul */
  {"\xA0", 0, 0x6F7732}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page363 = {
  marc8r_31page363_flat, 0
};
/* PAGE 362 */
struct yaz_iconv_trie_flat marc8r_31page362_flat[] = {
  {"\x80", 0, 0x6F4B30}, /* Korean hangul */
  {"\x8C", 0, 0x6F4B32}, /* Korean hangul */
  {"\x8D", 0, 0x6F4B33}, /* Korean hangul */
  {"\x90", 0, 0x6F4B34}, /* Korean hangul */
  {"\x94", 0, 0x6F4B35}, /* Korean hangul */
  {"\x9C", 0, 0x6F4B36}, /* Korean hangul */
  {"\x9D", 0, 0x6F4B37}, /* Korean hangul */
  {"\xA8", 0, 0x6F4B38}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page362 = {
  marc8r_31page362_flat, 0
};
/* PAGE 361 */
struct yaz_iconv_trie_dir marc8r_31page361_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {363, 0, 0},
  {364, 0, 0},
  {365, 0, 0},
  {366, 0, 0},
  {367, 0, 0},
  {368, 0, 0},
  {369, 0, 0},
  {370, 0, 0},
  {371, 0, 0},
  {372, 0, 0},
  {373, 0, 0},
  {374, 0, 0},
  {375, 0, 0},
  {376, 0, 0},
  {377, 0, 0},
  {378, 0, 0},
  {379, 0, 0},
  {380, 0, 0},
  {381, 0, 0},
  {382, 0, 0},
  {383, 0, 0},
  {384, 0, 0},
  {385, 0, 0},
  {386, 0, 0},
  {387, 0, 0},
  {388, 0, 0},
  {389, 0, 0},
  {390, 0, 0},
  {391, 0, 0},
  {392, 0, 0},
  {393, 0, 0},
  {394, 0, 0},
  {395, 0, 0},
  {396, 0, 0},
  {397, 0, 0},
  {398, 0, 0},
  {399, 0, 0},
  {400, 0, 0},
  {401, 0, 0},
  {402, 0, 0},
  {403, 0, 0},
  {404, 0, 0},
  {405, 0, 0},
  {406, 0, 0},
  {407, 0, 0},
  {408, 0, 0},
  {409, 0, 0},
  {410, 0, 0},
  {411, 0, 0},
  {412, 0, 0},
  {413, 0, 0},
  {414, 0, 0},
  {415, 0, 0},
  {416, 0, 0},
  {417, 0, 0},
  {418, 0, 0},
  {419, 0, 0},
  {420, 0, 0},
  {421, 0, 0},
  {422, 0, 0},
  {423, 0, 0},
  {424, 0, 0},
  {425, 0, 0},
  {426, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page361 = {
  0, marc8r_31page361_dir
};
/* PAGE 360 */
struct yaz_iconv_trie_flat marc8r_31page360_flat[] = {
  {"\x80", 0, 0x6F4B25}, /* Korean hangul */
  {"\x87", 0, 0x6F4B26}, /* Korean hangul */
  {"\x88", 0, 0x6F4B27}, /* Korean hangul */
  {"\x89", 0, 0x6F4B28}, /* Korean hangul */
  {"\x8B", 0, 0x6F4B29}, /* Korean hangul */
  {"\x8D", 0, 0x6F4B2A}, /* Korean hangul */
  {"\x8E", 0, 0x6F4B2B}, /* Korean hangul */
  {"\x94", 0, 0x6F4B2C}, /* Korean hangul */
  {"\x98", 0, 0x6F4B2D}, /* Korean hangul */
  {"\xA9", 0, 0x6F4B2E}, /* Korean hangul */
  {"\xB0", 0, 0x6F4B2F}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page360 = {
  marc8r_31page360_flat, 0
};
/* PAGE 359 */
struct yaz_iconv_trie_flat marc8r_31page359_flat[] = {
  {"\x80", 0, 0x6F4A7A}, /* Korean hangul */
  {"\x84", 0, 0x6F4A7B}, /* Korean hangul */
  {"\x88", 0, 0x6F4A7C}, /* Korean hangul */
  {"\x90", 0, 0x6F4A7D}, /* Korean hangul */
  {"\x95", 0, 0x6F4A7E}, /* Korean hangul */
  {"\x9C", 0, 0x6F4B21}, /* Korean hangul */
  {"\xB8", 0, 0x6F4B22}, /* Korean hangul */
  {"\xB9", 0, 0x6F4B23}, /* Korean hangul */
  {"\xBC", 0, 0x6F4B24}, /* Korean hangul */
  {"\xBF", 0, 0x6F7731}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page359 = {
  marc8r_31page359_flat, 0
};
/* PAGE 358 */
struct yaz_iconv_trie_flat marc8r_31page358_flat[] = {
  {"\x81", 0, 0x6F4A6E}, /* Korean hangul */
  {"\x82", 0, 0x6F4A6F}, /* Korean hangul */
  {"\x83", 0, 0x6F4A70}, /* Korean hangul */
  {"\x88", 0, 0x6F4A71}, /* Korean hangul */
  {"\x89", 0, 0x6F4A72}, /* Korean hangul */
  {"\x8C", 0, 0x6F4A73}, /* Korean hangul */
  {"\x98", 0, 0x6F4A74}, /* Korean hangul */
  {"\x9C", 0, 0x6F4A75}, /* Korean hangul */
  {"\x9D", 0, 0x6F4A76}, /* Korean hangul */
  {"\xA4", 0, 0x6F4A77}, /* Korean hangul */
  {"\xA5", 0, 0x6F4A78}, /* Korean hangul */
  {"\xB9", 0, 0x6F4A79}, /* Korean hangul */
  {"\x90", 0, 0x6F7730}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page358 = {
  marc8r_31page358_flat, 0
};
/* PAGE 357 */
struct yaz_iconv_trie_flat marc8r_31page357_flat[] = {
  {"\x8D", 0, 0x6F4A66}, /* Korean hangul */
  {"\xAC", 0, 0x6F4A67}, /* Korean hangul */
  {"\xAD", 0, 0x6F4A68}, /* Korean hangul */
  {"\xB0", 0, 0x6F4A69}, /* Korean hangul */
  {"\xB4", 0, 0x6F4A6A}, /* Korean hangul */
  {"\xBC", 0, 0x6F4A6B}, /* Korean hangul */
  {"\xBD", 0, 0x6F4A6C}, /* Korean hangul */
  {"\xBF", 0, 0x6F4A6D}, /* Korean hangul */
  {"\x89", 0, 0x6F772F}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page357 = {
  marc8r_31page357_flat, 0
};
/* PAGE 356 */
struct yaz_iconv_trie_flat marc8r_31page356_flat[] = {
  {"\x80", 0, 0x6F4A5C}, /* Korean hangul */
  {"\x84", 0, 0x6F4A5D}, /* Korean hangul */
  {"\x8C", 0, 0x6F4A5E}, /* Korean hangul */
  {"\x8D", 0, 0x6F4A5F}, /* Korean hangul */
  {"\x8F", 0, 0x6F4A60}, /* Korean hangul */
  {"\x90", 0, 0x6F4A61}, /* Korean hangul */
  {"\x91", 0, 0x6F4A62}, /* Korean hangul */
  {"\x98", 0, 0x6F4A63}, /* Korean hangul */
  {"\x9C", 0, 0x6F4A64}, /* Korean hangul */
  {"\xB4", 0, 0x6F4A65}, /* Korean hangul */
  {"\xAD", 0, 0x6F772E}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page356 = {
  marc8r_31page356_flat, 0
};
/* PAGE 355 */
struct yaz_iconv_trie_flat marc8r_31page355_flat[] = {
  {"\x84", 0, 0x6F4A57}, /* Korean hangul */
  {"\x85", 0, 0x6F4A58}, /* Korean hangul */
  {"\xBC", 0, 0x6F4A59}, /* Korean hangul */
  {"\xBD", 0, 0x6F4A5A}, /* Korean hangul */
  {"\xBE", 0, 0x6F4A5B}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page355 = {
  marc8r_31page355_flat, 0
};
/* PAGE 354 */
struct yaz_iconv_trie_flat marc8r_31page354_flat[] = {
  {"\x80", 0, 0x6F4A3B}, /* Korean hangul */
  {"\x81", 0, 0x6F4A3C}, /* Korean hangul */
  {"\x83", 0, 0x6F4A3D}, /* Korean hangul */
  {"\x84", 0, 0x6F4A3E}, /* Korean hangul */
  {"\x85", 0, 0x6F4A3F}, /* Korean hangul */
  {"\x8A", 0, 0x6F4A40}, /* Korean hangul */
  {"\x8C", 0, 0x6F4A43}, /* Korean hangul */
  {"\x8D", 0, 0x6F4A44}, /* Korean hangul */
  {"\x8E", 0, 0x6F4A45}, /* Korean hangul */
  {"\x90", 0, 0x6F4A46}, /* Korean hangul */
  {"\x94", 0, 0x6F4A47}, /* Korean hangul */
  {"\x9C", 0, 0x6F4A48}, /* Korean hangul */
  {"\x9D", 0, 0x6F4A49}, /* Korean hangul */
  {"\xA0", 0, 0x6F4A4A}, /* Korean hangul */
  {"\xA1", 0, 0x6F4A4B}, /* Korean hangul */
  {"\xA2", 0, 0x6F4A4C}, /* Korean hangul */
  {"\xA5", 0, 0x6F4A4D}, /* Korean hangul */
  {"\xA8", 0, 0x6F4A4E}, /* Korean hangul */
  {"\xA9", 0, 0x6F4A4F}, /* Korean hangul */
  {"\xAC", 0, 0x6F4A50}, /* Korean hangul */
  {"\xB0", 0, 0x6F4A51}, /* Korean hangul */
  {"\xB8", 0, 0x6F4A52}, /* Korean hangul */
  {"\xB9", 0, 0x6F4A53}, /* Korean hangul */
  {"\xBB", 0, 0x6F4A54}, /* Korean hangul */
  {"\xBC", 0, 0x6F4A55}, /* Korean hangul */
  {"\xBD", 0, 0x6F4A56}, /* Korean hangul */
  {"\x9F", 0, 0x6F772D}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page354 = {
  marc8r_31page354_flat, 0
};
/* PAGE 353 */
struct yaz_iconv_trie_flat marc8r_31page353_flat[] = {
  {"\x80", 0, 0x6F4A30}, /* Korean hangul */
  {"\x81", 0, 0x6F4A31}, /* Korean hangul */
  {"\x88", 0, 0x6F4A32}, /* Korean hangul */
  {"\x89", 0, 0x6F4A33}, /* Korean hangul */
  {"\x8B", 0, 0x6F4A34}, /* Korean hangul */
  {"\x8D", 0, 0x6F4A35}, /* Korean hangul */
  {"\xB0", 0, 0x6F4A36}, /* Korean hangul */
  {"\xB1", 0, 0x6F4A37}, /* Korean hangul */
  {"\xB4", 0, 0x6F4A38}, /* Korean hangul */
  {"\xB7", 0, 0x6F4A39}, /* Korean hangul */
  {"\xB8", 0, 0x6F4A3A}, /* Korean hangul */
  {"\x87", 0, 0x6F7728}, /* Korean hangul */
  {"\x8E", 0, 0x6F7729}, /* Korean hangul */
  {"\x8F", 0, 0x6F772A}, /* Korean hangul */
  {"\x91", 0, 0x6F772B}, /* Korean hangul */
  {"\x94", 0, 0x6F772C}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page353 = {
  marc8r_31page353_flat, 0
};
/* PAGE 352 */
struct yaz_iconv_trie_flat marc8r_31page352_flat[] = {
  {"\x80", 0, 0x6F4A22}, /* Korean hangul */
  {"\x84", 0, 0x6F4A23}, /* Korean hangul */
  {"\x88", 0, 0x6F4A24}, /* Korean hangul */
  {"\x90", 0, 0x6F4A25}, /* Korean hangul */
  {"\x91", 0, 0x6F4A26}, /* Korean hangul */
  {"\x93", 0, 0x6F4A27}, /* Korean hangul */
  {"\x9C", 0, 0x6F4A28}, /* Korean hangul */
  {"\xA0", 0, 0x6F4A29}, /* Korean hangul */
  {"\xA4", 0, 0x6F4A2A}, /* Korean hangul */
  {"\xAC", 0, 0x6F4A2B}, /* Korean hangul */
  {"\xB8", 0, 0x6F4A2C}, /* Korean hangul */
  {"\xB9", 0, 0x6F4A2D}, /* Korean hangul */
  {"\xBC", 0, 0x6F4A2E}, /* Korean hangul */
  {"\xBF", 0, 0x6F4A2F}, /* Korean hangul */
  {"\x95", 0, 0x6F7727}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page352 = {
  marc8r_31page352_flat, 0
};
/* PAGE 351 */
struct yaz_iconv_trie_flat marc8r_31page351_flat[] = {
  {"\x81", 0, 0x6F4978}, /* Korean hangul */
  {"\x82", 0, 0x6F4979}, /* Korean hangul */
  {"\x88", 0, 0x6F497A}, /* Korean hangul */
  {"\x8C", 0, 0x6F497B}, /* Korean hangul */
  {"\x90", 0, 0x6F497C}, /* Korean hangul */
  {"\xA4", 0, 0x6F497E}, /* Korean hangul */
  {"\x89", 0, 0x6F7724}, /* Korean hangul */
  {"\x9D", 0, 0x6F7725}, /* Korean hangul */
  {"\xB9", 0, 0x6F7726}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page351 = {
  marc8r_31page351_flat, 0
};
/* PAGE 350 */
struct yaz_iconv_trie_flat marc8r_31page350_flat[] = {
  {"\x84", 0, 0x6F496A}, /* Korean hangul */
  {"\x89", 0, 0x6F496C}, /* Korean hangul */
  {"\x90", 0, 0x6F496D}, /* Korean hangul */
  {"\xAC", 0, 0x6F496E}, /* Korean hangul */
  {"\xAD", 0, 0x6F496F}, /* Korean hangul */
  {"\xB0", 0, 0x6F4970}, /* Korean hangul */
  {"\xB3", 0, 0x6F4971}, /* Korean hangul */
  {"\xB4", 0, 0x6F4972}, /* Korean hangul */
  {"\xB5", 0, 0x6F4973}, /* Korean hangul */
  {"\xB6", 0, 0x6F4974}, /* Korean hangul */
  {"\xBC", 0, 0x6F4975}, /* Korean hangul */
  {"\xBD", 0, 0x6F4976}, /* Korean hangul */
  {"\xBF", 0, 0x6F4977}, /* Korean hangul */
  {"\xBB", 0, 0x6F7722}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page350 = {
  marc8r_31page350_flat, 0
};
/* PAGE 349 */
struct yaz_iconv_trie_flat marc8r_31page349_flat[] = {
  {"\x80", 0, 0x6F495A}, /* Korean hangul */
  {"\x84", 0, 0x6F495B}, /* Korean hangul */
  {"\x8C", 0, 0x6F495C}, /* Korean hangul */
  {"\x8D", 0, 0x6F495D}, /* Korean hangul */
  {"\x8F", 0, 0x6F495E}, /* Korean hangul */
  {"\x91", 0, 0x6F495F}, /* Korean hangul */
  {"\x98", 0, 0x6F4960}, /* Korean hangul */
  {"\x99", 0, 0x6F4961}, /* Korean hangul */
  {"\x9C", 0, 0x6F4962}, /* Korean hangul */
  {"\xA0", 0, 0x6F4963}, /* Korean hangul */
  {"\xA8", 0, 0x6F4964}, /* Korean hangul */
  {"\xA9", 0, 0x6F4965}, /* Korean hangul */
  {"\xAD", 0, 0x6F4966}, /* Korean hangul */
  {"\xB4", 0, 0x6F4967}, /* Korean hangul */
  {"\xB8", 0, 0x6F4968}, /* Korean hangul */
  {"\xBC", 0, 0x6F4969}, /* Korean hangul */
  {"\xB5", 0, 0x6F7721}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page349 = {
  marc8r_31page349_flat, 0
};
/* PAGE 348 */
struct yaz_iconv_trie_flat marc8r_31page348_flat[] = {
  {"\x81", 0, 0x6F4945}, /* Korean hangul */
  {"\x84", 0, 0x6F4947}, /* Korean hangul */
  {"\x97", 0, 0x6F4949}, /* Korean hangul */
  {"\xA0", 0, 0x6F494A}, /* Korean hangul */
  {"\xA1", 0, 0x6F494B}, /* Korean hangul */
  {"\xA4", 0, 0x6F494C}, /* Korean hangul */
  {"\xA7", 0, 0x6F494D}, /* Korean hangul */
  {"\xA8", 0, 0x6F494E}, /* Korean hangul */
  {"\xAA", 0, 0x6F494F}, /* Korean hangul */
  {"\xAC", 0, 0x6F4950}, /* Korean hangul */
  {"\xAF", 0, 0x6F4951}, /* Korean hangul */
  {"\xB0", 0, 0x6F4952}, /* Korean hangul */
  {"\xB1", 0, 0x6F4953}, /* Korean hangul */
  {"\xB3", 0, 0x6F4954}, /* Korean hangul */
  {"\xB5", 0, 0x6F4955}, /* Korean hangul */
  {"\xB6", 0, 0x6F4956}, /* Korean hangul */
  {"\xBA", 0, 0x6F4957}, /* Korean hangul */
  {"\xBC", 0, 0x6F4958}, /* Korean hangul */
  {"\xBD", 0, 0x6F4959}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page348 = {
  marc8r_31page348_flat, 0
};
/* PAGE 347 */
struct yaz_iconv_trie_flat marc8r_31page347_flat[] = {
  {"\x80", 0, 0x6F4929}, /* Korean hangul */
  {"\x81", 0, 0x6F492A}, /* Korean hangul */
  {"\x83", 0, 0x6F492B}, /* Korean hangul */
  {"\x84", 0, 0x6F492C}, /* Korean hangul */
  {"\x85", 0, 0x6F492D}, /* Korean hangul */
  {"\x86", 0, 0x6F492E}, /* Korean hangul */
  {"\x89", 0, 0x6F4930}, /* Korean hangul */
  {"\x8A", 0, 0x6F4931}, /* Korean hangul */
  {"\x8B", 0, 0x6F4932}, /* Korean hangul */
  {"\x8C", 0, 0x6F4933}, /* Korean hangul */
  {"\x90", 0, 0x6F4934}, /* Korean hangul */
  {"\x94", 0, 0x6F4935}, /* Korean hangul */
  {"\x9C", 0, 0x6F4936}, /* Korean hangul */
  {"\x9F", 0, 0x6F4937}, /* Korean hangul */
  {"\xA0", 0, 0x6F4938}, /* Korean hangul */
  {"\xA1", 0, 0x6F4939}, /* Korean hangul */
  {"\xA8", 0, 0x6F493A}, /* Korean hangul */
  {"\xA9", 0, 0x6F493B}, /* Korean hangul */
  {"\xAA", 0, 0x6F493C}, /* Korean hangul */
  {"\xAC", 0, 0x6F493D}, /* Korean hangul */
  {"\xAF", 0, 0x6F493E}, /* Korean hangul */
  {"\xB0", 0, 0x6F493F}, /* Korean hangul */
  {"\xB8", 0, 0x6F4940}, /* Korean hangul */
  {"\xB9", 0, 0x6F4941}, /* Korean hangul */
  {"\xBC", 0, 0x6F4943}, /* Korean hangul */
  {"\xBD", 0, 0x6F4944}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page347 = {
  marc8r_31page347_flat, 0
};
/* PAGE 346 */
struct yaz_iconv_trie_flat marc8r_31page346_flat[] = {
  {"\x80", 0, 0x6F487D}, /* Korean hangul */
  {"\x94", 0, 0x6F487E}, /* Korean hangul */
  {"\xB0", 0, 0x6F4921}, /* Korean hangul */
  {"\xB1", 0, 0x6F4922}, /* Korean hangul */
  {"\xB4", 0, 0x6F4924}, /* Korean hangul */
  {"\xB7", 0, 0x6F4925}, /* Korean hangul */
  {"\xB8", 0, 0x6F4926}, /* Korean hangul */
  {"\xB9", 0, 0x6F4927}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page346 = {
  marc8r_31page346_flat, 0
};
/* PAGE 345 */
struct yaz_iconv_trie_flat marc8r_31page345_flat[] = {
  {"\x80", 0, 0x6F485F}, /* Korean hangul */
  {"\x81", 0, 0x6F4860}, /* Korean hangul */
  {"\x82", 0, 0x6F4861}, /* Korean hangul */
  {"\x84", 0, 0x6F4862}, /* Korean hangul */
  {"\x87", 0, 0x6F4863}, /* Korean hangul */
  {"\x88", 0, 0x6F4864}, /* Korean hangul */
  {"\x89", 0, 0x6F4865}, /* Korean hangul */
  {"\x90", 0, 0x6F4866}, /* Korean hangul */
  {"\x91", 0, 0x6F4867}, /* Korean hangul */
  {"\x92", 0, 0x6F4868}, /* Korean hangul */
  {"\x93", 0, 0x6F4869}, /* Korean hangul */
  {"\x94", 0, 0x6F486A}, /* Korean hangul */
  {"\x95", 0, 0x6F486B}, /* Korean hangul */
  {"\x96", 0, 0x6F486C}, /* Korean hangul */
  {"\x97", 0, 0x6F486D}, /* Korean hangul */
  {"\x99", 0, 0x6F486E}, /* Korean hangul */
  {"\x9A", 0, 0x6F486F}, /* Korean hangul */
  {"\x9B", 0, 0x6F4870}, /* Korean hangul */
  {"\x9C", 0, 0x6F4871}, /* Korean hangul */
  {"\x9D", 0, 0x6F4872}, /* Korean hangul */
  {"\xA0", 0, 0x6F4873}, /* Korean hangul */
  {"\xA4", 0, 0x6F4875}, /* Korean hangul */
  {"\xAC", 0, 0x6F4876}, /* Korean hangul */
  {"\xAD", 0, 0x6F4877}, /* Korean hangul */
  {"\xAF", 0, 0x6F4878}, /* Korean hangul */
  {"\xB0", 0, 0x6F4879}, /* Korean hangul */
  {"\xB1", 0, 0x6F487A}, /* Korean hangul */
  {"\xB8", 0, 0x6F487B}, /* Korean hangul */
  {"\xB9", 0, 0x6F487C}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page345 = {
  marc8r_31page345_flat, 0
};
/* PAGE 344 */
struct yaz_iconv_trie_dir marc8r_31page344_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {346, 0, 0},
  {347, 0, 0},
  {348, 0, 0},
  {349, 0, 0},
  {350, 0, 0},
  {351, 0, 0},
  {352, 0, 0},
  {353, 0, 0},
  {354, 0, 0},
  {355, 0, 0},
  {356, 0, 0},
  {357, 0, 0},
  {358, 0, 0},
  {359, 0, 0},
  {360, 0, 0},
  {361, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page344 = {
  0, marc8r_31page344_dir
};
/* PAGE 343 */
struct yaz_iconv_trie_flat marc8r_31page343_flat[] = {
  {"\x81", 0, 0x6F245B}, /* Korean hangul */
  {"\x82", 0, 0x6F245C}, /* Korean hangul */
  {"\x85", 0, 0x6F245D}, /* Korean hangul */
  {"\x87", 0, 0x6F245E}, /* Korean hangul */
  {"\x88", 0, 0x6F245F}, /* Korean hangul */
  {"\x8A", 0, 0x6F2460}, /* Korean hangul */
  {"\x8B", 0, 0x6F2461}, /* Korean hangul */
  {"\x8C", 0, 0x6F2462}, /* Korean hangul */
  {"\x8D", 0, 0x6F2463}, /* Korean hangul */
  {"\x8E", 0, 0x6F2464}, /* Korean hangul */
  {"\x83", 0, 0x6F246E}, /* Korean hangul */
  {"\x86", 0, 0x6F2470}, /* Korean hangul */
  {"\x89", 0, 0x6F2471}, /* Korean hangul */
  {"\x8F", 0, 0x6F2472}, /* Korean hangul */
  {"\x90", 0, 0x6F2473}, /* Korean hangul */
  {"\x91", 0, 0x6F2474}, /* Korean hangul */
  {"\x93", 0, 0x6F2476}, /* Korean hangul */
  {"\x94", 0, 0x6F2477}, /* Korean hangul */
  {"\x95", 0, 0x6F2478}, /* Korean hangul */
  {"\x97", 0, 0x6F247A}, /* Korean hangul */
  {"\x98", 0, 0x6F247B}, /* Korean hangul */
  {"\x9B", 0, 0x6F247E}, /* Korean hangul */
  {"\x9C", 0, 0x6F2521}, /* Korean hangul */
  {"\xA0", 0, 0x6F2525}, /* Korean hangul */
  {"\xA1", 0, 0x6F2526}, /* Korean hangul */
  {"\xA2", 0, 0x6F2527}, /* Korean hangul */
  {"\xA3", 0, 0x6F2528}, /* Korean hangul */
  {"\xBF", 0, 0x6F7623}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page343 = {
  marc8r_31page343_flat, 0
};
/* PAGE 342 */
struct yaz_iconv_trie_flat marc8r_31page342_flat[] = {
  {"\xB1", 0, 0x6F2457}, /* Korean hangul */
  {"\xB4", 0, 0x6F2458}, /* Korean hangul */
  {"\xB7", 0, 0x6F2459}, /* Korean hangul */
  {"\xB9", 0, 0x6F245A}, /* Korean hangul */
  {"\xB2", 0, 0x6F2465}, /* Korean hangul */
  {"\xB8", 0, 0x6F2469}, /* Korean hangul */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page342 = {
  marc8r_31page342_flat, 0
};
/* PAGE 341 */
struct yaz_iconv_trie_dir marc8r_31page341_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x692460} /* Hiragana letter MU */,
  {0, 0, 0x692461} /* Hiragana letter ME */,
  {0, 0, 0x692462} /* Hiragana letter MO */,
  {0, 0, 0x692463} /* Hiragana letter small YA */,
  {0, 0, 0x692464} /* Hiragana letter YA */,
  {0, 0, 0x692465} /* Hiragana letter small YU */,
  {0, 0, 0x692466} /* Hiragana letter YU */,
  {0, 0, 0x692467} /* Hiragana letter small YO */,
  {0, 0, 0x692468} /* Hiragana letter YO */,
  {0, 0, 0x692469} /* Hiragana letter RA */,
  {0, 0, 0x69246A} /* Hiragana letter RI */,
  {0, 0, 0x69246B} /* Hiragana letter RU */,
  {0, 0, 0x69246C} /* Hiragana letter RE */,
  {0, 0, 0x69246D} /* Hiragana letter RO */,
  {0, 0, 0x69246E} /* Hiragana letter small WA */,
  {0, 0, 0x69246F} /* Hiragana letter WA */,
  {0, 0, 0x692470} /* Hiragana letter WI */,
  {0, 0, 0x692471} /* Hiragana letter WE */,
  {0, 0, 0x692472} /* Hiragana letter WO */,
  {0, 0, 0x692473} /* Hiragana letter N */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x692577} /* Katakana-hiragana voiced sound mark */,
  {0, 0, 0x692578} /* Katakana-hiragana semi-voiced sound mark */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x692521} /* Katakana letter small A */,
  {0, 0, 0x692522} /* Katakana letter A */,
  {0, 0, 0x692523} /* Katakana letter small I */,
  {0, 0, 0x692524} /* Katakana letter I */,
  {0, 0, 0x692525} /* Katakana letter small U */,
  {0, 0, 0x692526} /* Katakana letter U */,
  {0, 0, 0x692527} /* Katakana letter small E */,
  {0, 0, 0x692528} /* Katakana letter E */,
  {0, 0, 0x692529} /* Katakana letter small O */,
  {0, 0, 0x69252A} /* Katakana letter O */,
  {0, 0, 0x69252B} /* Katakana letter KA */,
  {0, 0, 0x69252C} /* Katakana letter GA */,
  {0, 0, 0x69252D} /* Katakana letter KI */,
  {0, 0, 0x69252E} /* Katakana letter GI */,
  {0, 0, 0x69252F} /* Katakana letter KU */,
  {0, 0, 0x692530} /* Katakana letter GU */,
  {0, 0, 0x692531} /* Katakana letter KE */,
  {0, 0, 0x692532} /* Katakana letter GE */,
  {0, 0, 0x692533} /* Katakana letter KO */,
  {0, 0, 0x692534} /* Katakana letter GO */,
  {0, 0, 0x692535} /* Katakana letter SA */,
  {0, 0, 0x692536} /* Katakana letter ZA */,
  {0, 0, 0x692537} /* Katakana letter SI */,
  {0, 0, 0x692538} /* Katakana letter ZI */,
  {0, 0, 0x692539} /* Katakana letter SU */,
  {0, 0, 0x69253A} /* Katakana letter ZU */,
  {0, 0, 0x69253B} /* Katakana letter SE */,
  {0, 0, 0x69253C} /* Katakana letter ZE */,
  {0, 0, 0x69253D} /* Katakana letter SO */,
  {0, 0, 0x69253E} /* Katakana letter ZO */,
  {0, 0, 0x69253F} /* Katakana letter TA */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page341 = {
  0, marc8r_31page341_dir
};
/* PAGE 340 */
struct yaz_iconv_trie_dir marc8r_31page340_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x692421} /* Hiragana letter small A */,
  {0, 0, 0x692422} /* Hiragana letter A */,
  {0, 0, 0x692423} /* Hiragana letter small I */,
  {0, 0, 0x692424} /* Hiragana letter I */,
  {0, 0, 0x692425} /* Hiragana letter small U */,
  {0, 0, 0x692426} /* Hiragana letter U */,
  {0, 0, 0x692427} /* Hiragana letter small E */,
  {0, 0, 0x692428} /* Hiragana letter E */,
  {0, 0, 0x692429} /* Hiragana letter small O */,
  {0, 0, 0x69242A} /* Hiragana letter O */,
  {0, 0, 0x69242B} /* Hiragana letter KA */,
  {0, 0, 0x69242C} /* Hiragana letter GA */,
  {0, 0, 0x69242D} /* Hiragana letter KI */,
  {0, 0, 0x69242E} /* Hiragana letter GI */,
  {0, 0, 0x69242F} /* Hiragana letter KU */,
  {0, 0, 0x692430} /* Hiragana letter GU */,
  {0, 0, 0x692431} /* Hiragana letter KE */,
  {0, 0, 0x692432} /* Hiragana letter GE */,
  {0, 0, 0x692433} /* Hiragana letter KO */,
  {0, 0, 0x692434} /* Hiragana letter GO */,
  {0, 0, 0x692435} /* Hiragana letter SA */,
  {0, 0, 0x692436} /* Hiragana letter ZA */,
  {0, 0, 0x692437} /* Hiragana letter SI */,
  {0, 0, 0x692438} /* Hiragana letter ZI */,
  {0, 0, 0x692439} /* Hiragana letter SU */,
  {0, 0, 0x69243A} /* Hiragana letter ZU */,
  {0, 0, 0x69243B} /* Hiragana letter SE */,
  {0, 0, 0x69243C} /* Hiragana letter ZE */,
  {0, 0, 0x69243D} /* Hiragana letter SO */,
  {0, 0, 0x69243E} /* Hiragana letter ZO */,
  {0, 0, 0x69243F} /* Hiragana letter TA */,
  {0, 0, 0x692440} /* Hiragana letter DA */,
  {0, 0, 0x692441} /* Hiragana letter TI */,
  {0, 0, 0x692442} /* Hiragana letter DI */,
  {0, 0, 0x692443} /* Hiragana letter small TU */,
  {0, 0, 0x692444} /* Hiragana letter TU */,
  {0, 0, 0x692445} /* Hiragana letter DU */,
  {0, 0, 0x692446} /* Hiragana letter TE */,
  {0, 0, 0x692447} /* Hiragana letter DE */,
  {0, 0, 0x692448} /* Hiragana letter TO */,
  {0, 0, 0x692449} /* Hiragana letter DO */,
  {0, 0, 0x69244A} /* Hiragana letter NA */,
  {0, 0, 0x69244B} /* Hiragana letter NI */,
  {0, 0, 0x69244C} /* Hiragana letter NU */,
  {0, 0, 0x69244D} /* Hiragana letter NE */,
  {0, 0, 0x69244E} /* Hiragana letter NO */,
  {0, 0, 0x69244F} /* Hiragana letter HA */,
  {0, 0, 0x692450} /* Hiragana letter BA */,
  {0, 0, 0x692451} /* Hiragana letter PA */,
  {0, 0, 0x692452} /* Hiragana letter HI */,
  {0, 0, 0x692453} /* Hiragana letter BI */,
  {0, 0, 0x692454} /* Hiragana letter PI */,
  {0, 0, 0x692455} /* Hiragana letter HU */,
  {0, 0, 0x692456} /* Hiragana letter BU */,
  {0, 0, 0x692457} /* Hiragana letter PU */,
  {0, 0, 0x692458} /* Hiragana letter HE */,
  {0, 0, 0x692459} /* Hiragana letter BE */,
  {0, 0, 0x69245A} /* Hiragana letter PE */,
  {0, 0, 0x69245B} /* Hiragana letter HO */,
  {0, 0, 0x69245C} /* Hiragana letter BO */,
  {0, 0, 0x69245D} /* Hiragana letter PO */,
  {0, 0, 0x69245E} /* Hiragana letter MA */,
  {0, 0, 0x69245F} /* Hiragana letter MI */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page340 = {
  0, marc8r_31page340_dir
};
/* PAGE 339 */
struct yaz_iconv_trie_dir marc8r_31page339_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x692540} /* Katakana letter DA */,
  {0, 0, 0x692541} /* Katakana letter TI */,
  {0, 0, 0x692542} /* Katakana letter DI */,
  {0, 0, 0x692543} /* Katakana letter small TU */,
  {0, 0, 0x692544} /* Katakana letter TU */,
  {0, 0, 0x692545} /* Katakana letter DU */,
  {0, 0, 0x692546} /* Katakana letter TE */,
  {0, 0, 0x692547} /* Katakana letter DE */,
  {0, 0, 0x692548} /* Katakana letter TO */,
  {0, 0, 0x692549} /* Katakana letter DO */,
  {0, 0, 0x69254A} /* Katakana letter NA */,
  {0, 0, 0x69254B} /* Katakana letter NI */,
  {0, 0, 0x69254C} /* Katakana letter NU */,
  {0, 0, 0x69254D} /* Katakana letter NE */,
  {0, 0, 0x69254E} /* Katakana letter NO */,
  {0, 0, 0x69254F} /* Katakana letter HA */,
  {0, 0, 0x692550} /* Katakana letter BA */,
  {0, 0, 0x692551} /* Katakana letter PA */,
  {0, 0, 0x692552} /* Katakana letter HI */,
  {0, 0, 0x692553} /* Katakana letter BI */,
  {0, 0, 0x692554} /* Katakana letter PI */,
  {0, 0, 0x692555} /* Katakana letter HU */,
  {0, 0, 0x692556} /* Katakana letter BU */,
  {0, 0, 0x692557} /* Katakana letter PU */,
  {0, 0, 0x692558} /* Katakana letter HE */,
  {0, 0, 0x692559} /* Katakana letter BE */,
  {0, 0, 0x69255A} /* Katakana letter PE */,
  {0, 0, 0x69255B} /* Katakana letter HO */,
  {0, 0, 0x69255C} /* Katakana letter BO */,
  {0, 0, 0x69255D} /* Katakana letter PO */,
  {0, 0, 0x69255E} /* Katakana letter MA */,
  {0, 0, 0x69255F} /* Katakana letter MI */,
  {0, 0, 0x692560} /* Katakana letter MU */,
  {0, 0, 0x692561} /* Katakana letter ME */,
  {0, 0, 0x692562} /* Katakana letter MO */,
  {0, 0, 0x692563} /* Katakana letter small YA */,
  {0, 0, 0x692564} /* Katakana letter YA */,
  {0, 0, 0x692565} /* Katakana letter small YU */,
  {0, 0, 0x692566} /* Katakana letter YU */,
  {0, 0, 0x692567} /* Katakana letter small YO */,
  {0, 0, 0x692568} /* Katakana letter YO */,
  {0, 0, 0x692569} /* Katakana letter RA */,
  {0, 0, 0x69256A} /* Katakana letter RI */,
  {0, 0, 0x69256B} /* Katakana letter RU */,
  {0, 0, 0x69256C} /* Katakana letter RE */,
  {0, 0, 0x69256D} /* Katakana letter RO */,
  {0, 0, 0x69256E} /* Katakana letter small WA */,
  {0, 0, 0x69256F} /* Katakana letter WA */,
  {0, 0, 0x692570} /* Katakana letter WI */,
  {0, 0, 0x692571} /* Katakana letter WE */,
  {0, 0, 0x692572} /* Katakana letter WO */,
  {0, 0, 0x692573} /* Katakana letter N */,
  {0, 0, 0x692574} /* Katakana letter VU */,
  {0, 0, 0x692575} /* Katakana letter small KA */,
  {0, 0, 0x692576} /* Katakana letter small KE */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x692126} /* Ideographic centered point */,
  {0, 0, 0x69213C} /* Vowel elongation mark for kana */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page339 = {
  0, marc8r_31page339_dir
};
/* PAGE 338 */
struct yaz_iconv_trie_flat marc8r_31page338_flat[] = {
  {"\x9E", 0, 0x2D3165}, /* East Asian ideograph (Unicode CJK Extension A) */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page338 = {
  marc8r_31page338_flat, 0
};
/* PAGE 337 */
struct yaz_iconv_trie_flat marc8r_31page337_flat[] = {
  {"\xA1", 0, 0x217E5B}, /* East Asian ideograph (Unicode CJK Extension A) */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page337 = {
  marc8r_31page337_flat, 0
};
/* PAGE 336 */
struct yaz_iconv_trie_flat marc8r_31page336_flat[] = {
  {"\x87", 0, 0x212F30}, /* East Asian ideograph (number zero) */
  {"\x93", 0, 0x6F7624}, /* Korean hangul (ancient) */
  {"\x80", 0, 0x212321}, /* Ideographic space per ANSI Z39.64 */
  {"\x8C", 0, 0x212B25}, /* Ideographic left corner bracket */
  {"\x8D", 0, 0x212B26}, /* Ideographic right corner bracket */
  {"\x82", 0, 0x212B33}, /* Ideographic full stop */
  {"\x81", 0, 0x212B35}, /* Ideographic comma */
  {"\x85", 0, 0x692139}, /* Ideographic iteration mark */
  {"\x88", 0, 0x692152}, /* Ideographic less than sign */
  {"\x89", 0, 0x692153}, /* Ideographic greater than sign */
  {"\x8A", 0, 0x692154}, /* Ideographic left double angle bracket */
  {"\x8B", 0, 0x692155}, /* Ideographic right double angle bracket */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page336 = {
  marc8r_31page336_flat, 0
};
/* PAGE 335 */
struct yaz_iconv_trie_flat marc8r_31page335_flat[] = {
  {"\x81", 0, 0x276176}, /* East Asian ideograph */
  {"\x8D", 0, 0x276177}, /* East Asian ideograph */
  {"\x9B", 0, 0x276178}, /* East Asian ideograph */
  {"\x9C", 0, 0x276179}, /* East Asian ideograph */
  {"\x94", 0, 0x27617A}, /* East Asian ideograph */
  {"\xA8", 0, 0x27617B}, /* East Asian ideograph */
  {"\xA4", 0, 0x27617C}, /* East Asian ideograph */
  {"\xB8", 0, 0x27617D}, /* East Asian ideograph */
  {"\xB3", 0, 0x27617E}, /* East Asian ideograph */
  {"\xAB", 0, 0x276223}, /* East Asian ideograph */
  {"\xA2", 0, 0x276226}, /* East Asian ideograph */
  {"\x88", 0, 0x27622E}, /* East Asian ideograph */
  {"\x82", 0, 0x29565D}, /* East Asian ideograph */
  {"\x86", 0, 0x295721}, /* East Asian ideograph */
  {"\x87", 0, 0x295729}, /* East Asian ideograph */
  {"\x90", 0, 0x29572B}, /* East Asian ideograph */
  {"\x8B", 0, 0x295731}, /* East Asian ideograph */
  {"\x9E", 0, 0x295739}, /* East Asian ideograph */
  {"\x91", 0, 0x29573C}, /* East Asian ideograph */
  {"\x92", 0, 0x29573D}, /* East Asian ideograph */
  {"\x95", 0, 0x295742}, /* East Asian ideograph */
  {"\xA9", 0, 0x295756}, /* East Asian ideograph */
  {"\xA0", 0, 0x29575F}, /* East Asian ideograph */
  {"\xA7", 0, 0x29576E}, /* East Asian ideograph */
  {"\xAD", 0, 0x29577A}, /* East Asian ideograph */
  {"\xB0", 0, 0x29577C}, /* East Asian ideograph */
  {"\xAE", 0, 0x295822}, /* East Asian ideograph */
  {"\xBA", 0, 0x295825}, /* East Asian ideograph */
  {"\xB2", 0, 0x295827}, /* East Asian ideograph */
  {"\xB4", 0, 0x295828}, /* East Asian ideograph */
  {"\xB1", 0, 0x29582C}, /* East Asian ideograph */
  {"\xB7", 0, 0x29582D}, /* East Asian ideograph */
  {"\xB5", 0, 0x29582F}, /* East Asian ideograph */
  {"\xB6", 0, 0x295831}, /* East Asian ideograph */
  {"\xBB", 0, 0x295834}, /* East Asian ideograph */
  {"\xBD", 0, 0x29584B}, /* East Asian ideograph */
  {"\xA5", 0, 0x29586E}, /* East Asian ideograph */
  {"\xA3", 0, 0x295929}, /* East Asian ideograph */
  {"\x85", 0, 0x29593A}, /* East Asian ideograph */
  {"\x9F", 0, 0x29593B}, /* East Asian ideograph */
  {"\xBC", 0, 0x295940}, /* East Asian ideograph */
  {"\x8E", 0, 0x295955}, /* East Asian ideograph */
  {"\x9A", 0, 0x295958}, /* East Asian ideograph */
  {"\xA1", 0, 0x29596B}, /* East Asian ideograph */
  {"\xA6", 0, 0x4D5934}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page335 = {
  marc8r_31page335_flat, 0
};
/* PAGE 334 */
struct yaz_iconv_trie_dir marc8r_31page334_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x275D66} /* East Asian ideograph */,
  {0, 0, 0x275E28} /* East Asian ideograph */,
  {0, 0, 0x29442E} /* East Asian ideograph */,
  {0, 0, 0x29442B} /* East Asian ideograph */,
  {0, 0, 0x275D68} /* East Asian ideograph */,
  {0, 0, 0x275D7C} /* East Asian ideograph */,
  {0, 0, 0x294440} /* East Asian ideograph */,
  {0, 0, 0x294441} /* East Asian ideograph */,
  {0, 0, 0x275E3B} /* East Asian ideograph */,
  {0, 0, 0x275D69} /* East Asian ideograph */,
  {0, 0, 0x294435} /* East Asian ideograph */,
  {0, 0, 0x275D6A} /* East Asian ideograph */,
  {0, 0, 0x275D62} /* East Asian ideograph */,
  {0, 0, 0x29436C} /* East Asian ideograph */,
  {0, 0, 0x294750} /* East Asian ideograph */,
  {0, 0, 0x294751} /* East Asian ideograph */,
  {0, 0, 0x275D64} /* East Asian ideograph */,
  {0, 0, 0x275D63} /* East Asian ideograph */,
  {0, 0, 0x29436A} /* East Asian ideograph */,
  {0, 0, 0x294372} /* East Asian ideograph */,
  {0, 0, 0x294375} /* East Asian ideograph */,
  {0, 0, 0x294466} /* East Asian ideograph */,
  {0, 0, 0x29445B} /* East Asian ideograph */,
  {0, 0, 0x294551} /* East Asian ideograph */,
  {0, 0, 0x294568} /* East Asian ideograph */,
  {0, 0, 0x275D6F} /* East Asian ideograph */,
  {0, 0, 0x275D7D} /* East Asian ideograph */,
  {0, 0, 0x29446D} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x294471} /* East Asian ideograph */,
  {0, 0, 0x294472} /* East Asian ideograph */,
  {0, 0, 0x294474} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x275D72} /* East Asian ideograph */,
  {0, 0, 0x294478} /* East Asian ideograph */,
  {0, 0, 0x275E49} /* East Asian ideograph */,
  {0, 0, 0x275E22} /* East Asian ideograph */,
  {0, 0, 0x275D75} /* East Asian ideograph */,
  {0, 0, 0x275D76} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x294531} /* East Asian ideograph */,
  {0, 0, 0x294457} /* East Asian ideograph */,
  {0, 0, 0x4D472C} /* East Asian ideograph */,
  {0, 0, 0x29444D} /* East Asian ideograph */,
  {0, 0, 0x294458} /* East Asian ideograph */,
  {0, 0, 0x275D6B} /* East Asian ideograph */,
  {0, 0, 0x275D79} /* East Asian ideograph */,
  {0, 0, 0x275D6D} /* East Asian ideograph */,
  {0, 0, 0x275D6E} /* East Asian ideograph */,
  {0, 0, 0x294532} /* East Asian ideograph */,
  {0, 0, 0x275D7A} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x29454D} /* East Asian ideograph */,
  {0, 0, 0x275E37} /* East Asian ideograph */,
  {0, 0, 0x294564} /* East Asian ideograph */,
  {0, 0, 0x294567} /* East Asian ideograph */,
  {0, 0, 0x29456F} /* East Asian ideograph */,
  {0, 0, 0x275E23} /* East Asian ideograph */,
  {0, 0, 0x455E21} /* East Asian ideograph */,
  {0, 0, 0x275E24} /* East Asian ideograph */,
  {0, 0, 0x29464A} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x275D7E} /* East Asian ideograph */,
  {0, 0, 0x4D4832} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page334 = {
  0, marc8r_31page334_dir
};
/* PAGE 333 */
struct yaz_iconv_trie_dir marc8r_31page333_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x275D52} /* East Asian ideograph */,
  {0, 0, 0x275E3D} /* East Asian ideograph */,
  {0, 0, 0x275D57} /* East Asian ideograph */,
  {0, 0, 0x275D58} /* East Asian ideograph */,
  {0, 0, 0x275E45} /* East Asian ideograph */,
  {0, 0, 0x275D55} /* East Asian ideograph */,
  {0, 0, 0x29432B} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x294251} /* East Asian ideograph */,
  {0, 0, 0x294252} /* East Asian ideograph */,
  {0, 0, 0x294255} /* East Asian ideograph */,
  {0, 0, 0x294254} /* East Asian ideograph */,
  {0, 0, 0x29425C} /* East Asian ideograph */,
  {0, 0, 0x29426D} /* East Asian ideograph */,
  {0, 0, 0x275E3F} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x275D5B} /* East Asian ideograph */,
  {0, 0, 0x294346} /* East Asian ideograph */,
  {0, 0, 0x294343} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x294349} /* East Asian ideograph */,
  {0, 0, 0x294340} /* East Asian ideograph */,
  {0, 0, 0x294427} /* East Asian ideograph */,
  {0, 0, 0x29437D} /* East Asian ideograph */,
  {0, 0, 0x275E39} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x275E3E} /* East Asian ideograph */,
  {0, 0, 0x275D5C} /* East Asian ideograph */,
  {0, 0, 0x275D67} /* East Asian ideograph */,
  {0, 0, 0x29434F} /* East Asian ideograph */,
  {0, 0, 0x294350} /* East Asian ideograph */,
  {0, 0, 0x294642} /* East Asian ideograph */,
  {0, 0, 0x29455E} /* East Asian ideograph */,
  {0, 0, 0x275D5E} /* East Asian ideograph */,
  {0, 0, 0x29435B} /* East Asian ideograph */,
  {0, 0, 0x29443E} /* East Asian ideograph */,
  {0, 0, 0x294359} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x294767} /* East Asian ideograph */,
  {0, 0, 0x275D60} /* East Asian ideograph */,
  {0, 0, 0x29472F} /* East Asian ideograph */,
  {0, 0, 0x294362} /* East Asian ideograph */,
  {0, 0, 0x294355} /* East Asian ideograph */,
  {0, 0, 0x275D5F} /* East Asian ideograph */,
  {0, 0, 0x275D5D} /* East Asian ideograph */,
  {0, 0, 0x275D73} /* East Asian ideograph */,
  {0, 0, 0x294358} /* East Asian ideograph */,
  {0, 0, 0x275D59} /* East Asian ideograph */,
  {0, 0, 0x294331} /* East Asian ideograph */,
  {0, 0, 0x275E2F} /* East Asian ideograph */,
  {0, 0, 0x29432F} /* East Asian ideograph */,
  {0, 0, 0x294732} /* East Asian ideograph */,
  {0, 0, 0x294335} /* East Asian ideograph */,
  {0, 0, 0x275D5A} /* East Asian ideograph */,
  {0, 0, 0x294364} /* East Asian ideograph */,
  {0, 0, 0x275E43} /* East Asian ideograph */,
  {0, 0, 0x29473E} /* East Asian ideograph */,
  {0, 0, 0x275D65} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x294469} /* East Asian ideograph */,
  {0, 0, 0x294371} /* East Asian ideograph */,
  {0, 0, 0x275E31} /* East Asian ideograph */,
  {0, 0, 0x275E30} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page333 = {
  0, marc8r_31page333_dir
};
/* PAGE 332 */
struct yaz_iconv_trie_dir marc8r_31page332_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x275845} /* East Asian ideograph */,
  {0, 0, 0x27593F} /* East Asian ideograph */,
  {0, 0, 0x275851} /* East Asian ideograph */,
  {0, 0, 0x51356A} /* East Asian ideograph */,
  {0, 0, 0x27584E} /* East Asian ideograph */,
  {0, 0, 0x275853} /* East Asian ideograph */,
  {0, 0, 0x27593C} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x275854} /* East Asian ideograph */,
  {0, 0, 0x275856} /* East Asian ideograph */,
  {0, 0, 0x275857} /* East Asian ideograph */,
  {0, 0, 0x275855} /* East Asian ideograph */,
  {0, 0, 0x29337A} /* East Asian ideograph */,
  {0, 0, 0x27584F} /* East Asian ideograph */,
  {0, 0, 0x29323B} /* East Asian ideograph */,
  {0, 0, 0x275852} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x275946} /* East Asian ideograph */,
  {0, 0, 0x29323C} /* East Asian ideograph */,
  {0, 0, 0x293250} /* East Asian ideograph */,
  {0, 0, 0x29325D} /* East Asian ideograph */,
  {0, 0, 0x27585B} /* East Asian ideograph */,
  {0, 0, 0x29324F} /* East Asian ideograph */,
  {0, 0, 0x27585C} /* East Asian ideograph */,
  {0, 0, 0x27585D} /* East Asian ideograph */,
  {0, 0, 0x27585F} /* East Asian ideograph */,
  {0, 0, 0x275860} /* East Asian ideograph */,
  {0, 0, 0x275862} /* East Asian ideograph */,
  {0, 0, 0x29325E} /* East Asian ideograph */,
  {0, 0, 0x275866} /* East Asian ideograph */,
  {0, 0, 0x275923} /* East Asian ideograph */,
  {0, 0, 0x275868} /* East Asian ideograph */,
  {0, 0, 0x275867} /* East Asian ideograph */,
  {0, 0, 0x275863} /* East Asian ideograph */,
  {0, 0, 0x275865} /* East Asian ideograph */,
  {0, 0, 0x27585E} /* East Asian ideograph */,
  {0, 0, 0x293336} /* East Asian ideograph */,
  {0, 0, 0x275859} /* East Asian ideograph */,
  {0, 0, 0x27585A} /* East Asian ideograph */,
  {0, 0, 0x275858} /* East Asian ideograph */,
  {0, 0, 0x293345} /* East Asian ideograph */,
  {0, 0, 0x293256} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x27586B} /* East Asian ideograph */,
  {0, 0, 0x27586F} /* East Asian ideograph */,
  {0, 0, 0x27586C} /* East Asian ideograph */,
  {0, 0, 0x293271} /* East Asian ideograph */,
  {0, 0, 0x275871} /* East Asian ideograph */,
  {0, 0, 0x275873} /* East Asian ideograph */,
  {0, 0, 0x275874} /* East Asian ideograph */,
  {0, 0, 0x275872} /* East Asian ideograph */,
  {0, 0, 0x275875} /* East Asian ideograph */,
  {0, 0, 0x275869} /* East Asian ideograph */,
  {0, 0, 0x27586A} /* East Asian ideograph */,
  {0, 0, 0x4B3642} /* East Asian ideograph */,
  {0, 0, 0x27587A} /* East Asian ideograph */,
  {0, 0, 0x27587B} /* East Asian ideograph */,
  {0, 0, 0x293325} /* East Asian ideograph */,
  {0, 0, 0x27592E} /* East Asian ideograph */,
  {0, 0, 0x27594A} /* East Asian ideograph */,
  {0, 0, 0x29332C} /* East Asian ideograph */,
  {0, 0, 0x293338} /* East Asian ideograph */,
  {0, 0, 0x27587C} /* East Asian ideograph */,
  {0, 0, 0x27587E} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page332 = {
  0, marc8r_31page332_dir
};
/* PAGE 331 */
struct yaz_iconv_trie_dir marc8r_31page331_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x287061} /* East Asian ideograph */,
  {0, 0, 0x287062} /* East Asian ideograph */,
  {0, 0, 0x287065} /* East Asian ideograph */,
  {0, 0, 0x275154} /* East Asian ideograph */,
  {0, 0, 0x27512B} /* East Asian ideograph */,
  {0, 0, 0x27512D} /* East Asian ideograph */,
  {0, 0, 0x27512C} /* East Asian ideograph */,
  {0, 0, 0x275171} /* East Asian ideograph */,
  {0, 0, 0x275130} /* East Asian ideograph */,
  {0, 0, 0x287269} /* East Asian ideograph */,
  {0, 0, 0x275126} /* East Asian ideograph */,
  {0, 0, 0x275128} /* East Asian ideograph */,
  {0, 0, 0x27512F} /* East Asian ideograph */,
  {0, 0, 0x27512A} /* East Asian ideograph */,
  {0, 0, 0x275178} /* East Asian ideograph */,
  {0, 0, 0x27513C} /* East Asian ideograph */,
  {0, 0, 0x28706A} /* East Asian ideograph */,
  {0, 0, 0x275140} /* East Asian ideograph */,
  {0, 0, 0x275133} /* East Asian ideograph */,
  {0, 0, 0x275134} /* East Asian ideograph */,
  {0, 0, 0x4B5773} /* East Asian ideograph */,
  {0, 0, 0x275173} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x287134} /* East Asian ideograph */,
  {0, 0, 0x275179} /* East Asian ideograph */,
  {0, 0, 0x275139} /* East Asian ideograph */,
  {0, 0, 0x275136} /* East Asian ideograph */,
  {0, 0, 0x287130} /* East Asian ideograph */,
  {0, 0, 0x275138} /* East Asian ideograph */,
  {0, 0, 0x275137} /* East Asian ideograph */,
  {0, 0, 0x275132} /* East Asian ideograph */,
  {0, 0, 0x275131} /* East Asian ideograph */,
  {0, 0, 0x287144} /* East Asian ideograph */,
  {0, 0, 0x28714D} /* East Asian ideograph */,
  {0, 0, 0x27513E} /* East Asian ideograph */,
  {0, 0, 0x275172} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x27513F} /* East Asian ideograph */,
  {0, 0, 0x4C715A} /* East Asian ideograph */,
  {0, 0, 0x27517D} /* East Asian ideograph */,
  {0, 0, 0x287139} /* East Asian ideograph */,
  {0, 0, 0x275166} /* East Asian ideograph */,
  {0, 0, 0x275155} /* East Asian ideograph */,
  {0, 0, 0x275145} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x275221} /* East Asian ideograph */,
  {0, 0, 0x335147} /* East Asian ideograph */,
  {0, 0, 0x287167} /* East Asian ideograph */,
  {0, 0, 0x27514A} /* East Asian ideograph */,
  {0, 0, 0x4D4D61} /* East Asian ideograph */,
  {0, 0, 0x287174} /* East Asian ideograph */,
  {0, 0, 0x275176} /* East Asian ideograph */,
  {0, 0, 0x27514E} /* East Asian ideograph */,
  {0, 0, 0x27514F} /* East Asian ideograph */,
  {0, 0, 0x287178} /* East Asian ideograph */,
  {0, 0, 0x4B516A} /* East Asian ideograph */,
  {0, 0, 0x27514D} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x28717D} /* East Asian ideograph */,
  {0, 0, 0x287161} /* East Asian ideograph */,
  {0, 0, 0x275141} /* East Asian ideograph */,
  {0, 0, 0x275142} /* East Asian ideograph */,
  {0, 0, 0x275143} /* East Asian ideograph */,
  {0, 0, 0x27514C} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page331 = {
  0, marc8r_31page331_dir
};
/* PAGE 330 */
struct yaz_iconv_trie_dir marc8r_31page330_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x23487C} /* East Asian ideograph */,
  {0, 0, 0x23487B} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x455D3E} /* East Asian ideograph */,
  {0, 0, 0x294162} /* East Asian ideograph */,
  {0, 0, 0x294161} /* East Asian ideograph */,
  {0, 0, 0x275D3F} /* East Asian ideograph */,
  {0, 0, 0x275D40} /* East Asian ideograph */,
  {0, 0, 0x275D41} /* East Asian ideograph */,
  {0, 0, 0x294164} /* East Asian ideograph */,
  {0, 0, 0x294163} /* East Asian ideograph */,
  {0, 0, 0x29416A} /* East Asian ideograph */,
  {0, 0, 0x29416B} /* East Asian ideograph */,
  {0, 0, 0x275D46} /* East Asian ideograph */,
  {0, 0, 0x294222} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x294179} /* East Asian ideograph */,
  {0, 0, 0x275D45} /* East Asian ideograph */,
  {0, 0, 0x294475} /* East Asian ideograph */,
  {0, 0, 0x294221} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x275D43} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x275D47} /* East Asian ideograph */,
  {0, 0, 0x474236} /* East Asian ideograph */,
  {0, 0, 0x294237} /* East Asian ideograph */,
  {0, 0, 0x4B3C38} /* East Asian ideograph */,
  {0, 0, 0x275D48} /* East Asian ideograph */,
  {0, 0, 0x275D4B} /* East Asian ideograph */,
  {0, 0, 0x275E21} /* East Asian ideograph */,
  {0, 0, 0x275D4A} /* East Asian ideograph */,
  {0, 0, 0x29442D} /* East Asian ideograph */,
  {0, 0, 0x275D71} /* East Asian ideograph */,
  {0, 0, 0x29424B} /* East Asian ideograph */,
  {0, 0, 0x275D4D} /* East Asian ideograph */,
  {0, 0, 0x275E47} /* East Asian ideograph */,
  {0, 0, 0x274578} /* East Asian ideograph */,
  {0, 0, 0x275D4C} /* East Asian ideograph */,
  {0, 0, 0x275E29} /* East Asian ideograph */,
  {0, 0, 0x275D56} /* East Asian ideograph */,
  {0, 0, 0x294224} /* East Asian ideograph */,
  {0, 0, 0x294225} /* East Asian ideograph */,
  {0, 0, 0x294228} /* East Asian ideograph */,
  {0, 0, 0x294223} /* East Asian ideograph */,
  {0, 0, 0x275D49} /* East Asian ideograph */,
  {0, 0, 0x294231} /* East Asian ideograph */,
  {0, 0, 0x294258} /* East Asian ideograph */,
  {0, 0, 0x275D70} /* East Asian ideograph */,
  {0, 0, 0x294261} /* East Asian ideograph */,
  {0, 0, 0x27502A} /* East Asian ideograph */,
  {0, 0, 0x275D4F} /* East Asian ideograph */,
  {0, 0, 0x335228} /* East Asian ideograph */,
  {0, 0, 0x29425F} /* East Asian ideograph */,
  {0, 0, 0x294260} /* East Asian ideograph */,
  {0, 0, 0x275D51} /* East Asian ideograph */,
  {0, 0, 0x275D50} /* East Asian ideograph */,
  {0, 0, 0x294264} /* East Asian ideograph */,
  {0, 0, 0x275E4A} /* East Asian ideograph */,
  {0, 0, 0x474270} /* East Asian ideograph */,
  {0, 0, 0x29426F} /* East Asian ideograph */,
  {0, 0, 0x275D53} /* East Asian ideograph */,
  {0, 0, 0x294274} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page330 = {
  0, marc8r_31page330_dir
};
/* PAGE 329 */
struct yaz_iconv_trie_flat marc8r_31page329_flat[] = {
  {"\x90", 0, 0x232D42}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page329 = {
  marc8r_31page329_flat, 0
};
/* PAGE 328 */
struct yaz_iconv_trie_flat marc8r_31page328_flat[] = {
  {"\x8A", 0, 0x21627D}, /* East Asian ideograph */
  {"\x8B", 0, 0x21627E}, /* East Asian ideograph */
  {"\x92", 0, 0x216321}, /* East Asian ideograph */
  {"\x9F", 0, 0x216322}, /* East Asian ideograph */
  {"\xA3", 0, 0x216323}, /* East Asian ideograph */
  {"\xA1", 0, 0x216324}, /* East Asian ideograph (variant of EACC 456324) */
  {"\xA6", 0, 0x216325}, /* East Asian ideograph */
  {"\x9C", 0, 0x216326}, /* East Asian ideograph */
  {"\xAC", 0, 0x216327}, /* East Asian ideograph */
  {"\xAA", 0, 0x216328}, /* East Asian ideograph */
  {"\xB7", 0, 0x216329}, /* East Asian ideograph */
  {"\xB2", 0, 0x21632A}, /* East Asian ideograph */
  {"\x81", 0, 0x235F69}, /* East Asian ideograph */
  {"\x85", 0, 0x235F6D}, /* East Asian ideograph */
  {"\x86", 0, 0x235F6F}, /* East Asian ideograph */
  {"\x88", 0, 0x235F71}, /* East Asian ideograph */
  {"\x89", 0, 0x235F73}, /* East Asian ideograph */
  {"\x8E", 0, 0x235F79}, /* East Asian ideograph */
  {"\x8F", 0, 0x235F7B}, /* East Asian ideograph */
  {"\x94", 0, 0x235F7C}, /* East Asian ideograph */
  {"\x95", 0, 0x235F7E}, /* East Asian ideograph */
  {"\x97", 0, 0x236023}, /* East Asian ideograph */
  {"\xA0", 0, 0x236028}, /* East Asian ideograph */
  {"\xAE", 0, 0x23603F}, /* East Asian ideograph */
  {"\xAF", 0, 0x236040}, /* East Asian ideograph */
  {"\xB6", 0, 0x236047}, /* East Asian ideograph */
  {"\x90", 0, 0x27627D}, /* East Asian ideograph */
  {"\xBF", 0, 0x276321}, /* East Asian ideograph */
  {"\x91", 0, 0x295F7B}, /* East Asian ideograph */
  {"\xA9", 0, 0x333623}, /* East Asian ideograph */
  {"\xA7", 0, 0x337345}, /* East Asian ideograph */
  {"\xA2", 0, 0x4B6324}, /* East Asian ideograph */
  {"\x84", 0, 0x4D5F70}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page328 = {
  marc8r_31page328_flat, 0
};
/* PAGE 327 */
struct yaz_iconv_trie_flat marc8r_31page327_flat[] = {
  {"\x87", 0, 0x216273}, /* East Asian ideograph */
  {"\x8E", 0, 0x216274}, /* East Asian ideograph */
  {"\x93", 0, 0x216275}, /* East Asian ideograph */
  {"\x95", 0, 0x216276}, /* East Asian ideograph */
  {"\x99", 0, 0x216277}, /* East Asian ideograph */
  {"\xA0", 0, 0x216278}, /* East Asian ideograph */
  {"\xAC", 0, 0x216279}, /* East Asian ideograph */
  {"\xB4", 0, 0x21627A}, /* East Asian ideograph */
  {"\xBB", 0, 0x21627B}, /* East Asian ideograph */
  {"\xBE", 0, 0x21627C}, /* East Asian ideograph */
  {"\x82", 0, 0x235E7D}, /* East Asian ideograph */
  {"\x8F", 0, 0x235F2F}, /* East Asian ideograph */
  {"\x90", 0, 0x235F31}, /* East Asian ideograph */
  {"\x92", 0, 0x235F32}, /* East Asian ideograph */
  {"\x96", 0, 0x235F33}, /* East Asian ideograph */
  {"\x97", 0, 0x235F34}, /* East Asian ideograph */
  {"\x9A", 0, 0x235F37}, /* East Asian ideograph */
  {"\xA2", 0, 0x235F45}, /* East Asian ideograph */
  {"\xAB", 0, 0x235F48}, /* East Asian ideograph */
  {"\xA6", 0, 0x235F49}, /* East Asian ideograph */
  {"\xAF", 0, 0x235F53}, /* East Asian ideograph */
  {"\xB9", 0, 0x235F5E}, /* East Asian ideograph */
  {"\xB7", 0, 0x235F5F}, /* East Asian ideograph */
  {"\xBD", 0, 0x235F64}, /* East Asian ideograph */
  {"\x8B", 0, 0x295E7C}, /* East Asian ideograph */
  {"\x8D", 0, 0x295F2B}, /* East Asian ideograph */
  {"\x84", 0, 0x2D5664}, /* East Asian ideograph */
  {"\x85", 0, 0x2D5675}, /* East Asian ideograph */
  {"\x88", 0, 0x2D622C}, /* East Asian ideograph */
  {"\xA1", 0, 0x4B6278}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page327 = {
  marc8r_31page327_flat, 0
};
/* PAGE 326 */
struct yaz_iconv_trie_flat marc8r_31page326_flat[] = {
  {"\x83", 0, 0x216262}, /* East Asian ideograph */
  {"\x8D", 0, 0x216263}, /* East Asian ideograph */
  {"\x8E", 0, 0x216264}, /* East Asian ideograph */
  {"\x8F", 0, 0x216265}, /* East Asian ideograph */
  {"\x91", 0, 0x216266}, /* East Asian ideograph */
  {"\x98", 0, 0x216268}, /* East Asian ideograph */
  {"\x94", 0, 0x216269}, /* East Asian ideograph */
  {"\x9E", 0, 0x21626A}, /* East Asian ideograph */
  {"\x9C", 0, 0x21626B}, /* East Asian ideograph */
  {"\x9B", 0, 0x21626C}, /* East Asian ideograph */
  {"\x9D", 0, 0x21626D}, /* East Asian ideograph */
  {"\xA0", 0, 0x21626E}, /* East Asian ideograph */
  {"\xA8", 0, 0x21626F}, /* East Asian ideograph */
  {"\xAF", 0, 0x216270}, /* East Asian ideograph */
  {"\xB4", 0, 0x216271}, /* East Asian ideograph */
  {"\xB7", 0, 0x216272}, /* East Asian ideograph */
  {"\x81", 0, 0x235E30}, /* East Asian ideograph */
  {"\x86", 0, 0x235E35}, /* East Asian ideograph */
  {"\x88", 0, 0x235E37}, /* East Asian ideograph */
  {"\x8C", 0, 0x235E42}, /* East Asian ideograph */
  {"\x90", 0, 0x235E4A}, /* East Asian ideograph */
  {"\x93", 0, 0x235E4C}, /* East Asian ideograph */
  {"\x9A", 0, 0x235E53}, /* East Asian ideograph */
  {"\x9F", 0, 0x235E55}, /* East Asian ideograph */
  {"\xA3", 0, 0x235E57}, /* East Asian ideograph */
  {"\xA5", 0, 0x235E59}, /* East Asian ideograph */
  {"\xA7", 0, 0x235E5C}, /* East Asian ideograph */
  {"\xAE", 0, 0x235E60}, /* East Asian ideograph */
  {"\xB0", 0, 0x235E66}, /* East Asian ideograph */
  {"\xB6", 0, 0x235E6F}, /* East Asian ideograph */
  {"\xB9", 0, 0x235E74}, /* East Asian ideograph */
  {"\xBB", 0, 0x235E76}, /* East Asian ideograph */
  {"\xBC", 0, 0x235E77}, /* East Asian ideograph */
  {"\xBD", 0, 0x235E7A}, /* East Asian ideograph */
  {"\xBE", 0, 0x235E7B}, /* East Asian ideograph */
  {"\xBF", 0, 0x235E7C}, /* East Asian ideograph */
  {"\xA9", 0, 0x276272}, /* East Asian ideograph */
  {"\xAA", 0, 0x295E6A}, /* East Asian ideograph */
  {"\x84", 0, 0x2D6262}, /* East Asian ideograph */
  {"\x89", 0, 0x2F5E42}, /* East Asian ideograph */
  {"\x92", 0, 0x4B6266}, /* East Asian ideograph */
  {"\x99", 0, 0x4B6268}, /* East Asian ideograph */
  {"\xA2", 0, 0x707771}, /* East Asian ideograph (Version J extension) */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page326 = {
  marc8r_31page326_flat, 0
};
/* PAGE 325 */
struct yaz_iconv_trie_flat marc8r_31page325_flat[] = {
  {"\x82", 0, 0x216254}, /* East Asian ideograph */
  {"\x8B", 0, 0x216255}, /* East Asian ideograph */
  {"\x97", 0, 0x216256}, /* East Asian ideograph */
  {"\x92", 0, 0x216257}, /* East Asian ideograph */
  {"\x93", 0, 0x216258}, /* East Asian ideograph */
  {"\x9D", 0, 0x216259}, /* East Asian ideograph */
  {"\x9F", 0, 0x21625A}, /* East Asian ideograph */
  {"\xA5", 0, 0x21625B}, /* East Asian ideograph */
  {"\xA9", 0, 0x21625C}, /* East Asian ideograph */
  {"\xB4", 0, 0x21625D}, /* East Asian ideograph */
  {"\xB5", 0, 0x21625E}, /* East Asian ideograph */
  {"\xBB", 0, 0x21625F}, /* East Asian ideograph */
  {"\xBC", 0, 0x216260}, /* East Asian ideograph */
  {"\xBE", 0, 0x216261}, /* East Asian ideograph */
  {"\x80", 0, 0x235D47}, /* East Asian ideograph */
  {"\x83", 0, 0x235D48}, /* East Asian ideograph */
  {"\x84", 0, 0x235D49}, /* East Asian ideograph */
  {"\x88", 0, 0x235D4B}, /* East Asian ideograph */
  {"\x87", 0, 0x235D4F}, /* East Asian ideograph */
  {"\x90", 0, 0x235D55}, /* East Asian ideograph */
  {"\x8C", 0, 0x235D58}, /* East Asian ideograph */
  {"\x95", 0, 0x235D5A}, /* East Asian ideograph */
  {"\x91", 0, 0x235D5C}, /* East Asian ideograph */
  {"\x9B", 0, 0x235D5D}, /* East Asian ideograph */
  {"\x9E", 0, 0x235D66}, /* East Asian ideograph */
  {"\xAD", 0, 0x235D77}, /* East Asian ideograph */
  {"\xAF", 0, 0x235D79}, /* East Asian ideograph */
  {"\xB0", 0, 0x235D7A}, /* East Asian ideograph */
  {"\xA6", 0, 0x27625B}, /* East Asian ideograph */
  {"\xB8", 0, 0x27625C}, /* East Asian ideograph */
  {"\xA4", 0, 0x2F5D49}, /* East Asian ideograph */
  {"\xAA", 0, 0x33625E}, /* East Asian ideograph */
  {"\xBD", 0, 0x4B6260}, /* East Asian ideograph */
  {"\x81", 0, 0x4D5D49}, /* East Asian ideograph */
  {"\xBF", 0, 0x694B7B}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page325 = {
  marc8r_31page325_flat, 0
};
/* PAGE 324 */
struct yaz_iconv_trie_flat marc8r_31page324_flat[] = {
  {"\xB9", 0, 0x216250}, /* East Asian ideograph */
  {"\xBD", 0, 0x216251}, /* East Asian ideograph */
  {"\xBC", 0, 0x216252}, /* East Asian ideograph */
  {"\xBF", 0, 0x216253}, /* East Asian ideograph */
  {"\xB5", 0, 0x235D3C}, /* East Asian ideograph */
  {"\xBA", 0, 0x235D42}, /* East Asian ideograph */
  {"\xBB", 0, 0x235D43}, /* East Asian ideograph */
  {"\x89", 0, 0x27623E}, /* East Asian ideograph */
  {"\x83", 0, 0x27623F}, /* East Asian ideograph */
  {"\x84", 0, 0x276240}, /* East Asian ideograph */
  {"\x85", 0, 0x276241}, /* East Asian ideograph */
  {"\x91", 0, 0x276242}, /* East Asian ideograph */
  {"\x8A", 0, 0x276243}, /* East Asian ideograph */
  {"\x8C", 0, 0x276244}, /* East Asian ideograph */
  {"\x8F", 0, 0x276245}, /* East Asian ideograph */
  {"\xA4", 0, 0x276246}, /* East Asian ideograph */
  {"\x9E", 0, 0x276248}, /* East Asian ideograph */
  {"\xA7", 0, 0x276249}, /* East Asian ideograph */
  {"\xB0", 0, 0x27624C}, /* East Asian ideograph */
  {"\xAD", 0, 0x27624D}, /* East Asian ideograph */
  {"\xA6", 0, 0x27624E}, /* East Asian ideograph */
  {"\x88", 0, 0x295A70}, /* East Asian ideograph */
  {"\x81", 0, 0x295A75}, /* East Asian ideograph */
  {"\x86", 0, 0x295B2A}, /* East Asian ideograph */
  {"\x8E", 0, 0x295B52}, /* East Asian ideograph */
  {"\x9C", 0, 0x295B59}, /* East Asian ideograph */
  {"\x9B", 0, 0x295B5C}, /* East Asian ideograph */
  {"\x95", 0, 0x295B60}, /* East Asian ideograph */
  {"\x97", 0, 0x295B6B}, /* East Asian ideograph */
  {"\x8B", 0, 0x295B6C}, /* East Asian ideograph */
  {"\xA3", 0, 0x295B77}, /* East Asian ideograph */
  {"\x9A", 0, 0x295B79}, /* East Asian ideograph */
  {"\x98", 0, 0x295C28}, /* East Asian ideograph */
  {"\xA8", 0, 0x295C47}, /* East Asian ideograph */
  {"\x87", 0, 0x295C49}, /* East Asian ideograph */
  {"\xAB", 0, 0x295C57}, /* East Asian ideograph */
  {"\xAC", 0, 0x295C5B}, /* East Asian ideograph */
  {"\xA9", 0, 0x295C65}, /* East Asian ideograph */
  {"\xAA", 0, 0x295C6C}, /* East Asian ideograph */
  {"\xB1", 0, 0x295D29}, /* East Asian ideograph */
  {"\xB3", 0, 0x295D3A}, /* East Asian ideograph */
  {"\x82", 0, 0x295D3B}, /* East Asian ideograph */
  {"\xBE", 0, 0x295D42}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page324 = {
  marc8r_31page324_flat, 0
};
/* PAGE 323 */
struct yaz_iconv_trie_flat marc8r_31page323_flat[] = {
  {"\x9A", 0, 0x21624E}, /* East Asian ideograph */
  {"\x9E", 0, 0x21624F}, /* East Asian ideograph */
  {"\x82", 0, 0x225021}, /* East Asian ideograph */
  {"\x87", 0, 0x235C71}, /* East Asian ideograph */
  {"\x8E", 0, 0x235D27}, /* East Asian ideograph */
  {"\x91", 0, 0x235D2B}, /* East Asian ideograph */
  {"\x95", 0, 0x235D36}, /* East Asian ideograph */
  {"\x98", 0, 0x235D37}, /* East Asian ideograph */
  {"\x9C", 0, 0x235D39}, /* East Asian ideograph */
  {"\x9B", 0, 0x235D3A}, /* East Asian ideograph */
  {"\x9D", 0, 0x235D3B}, /* East Asian ideograph */
  {"\xA1", 0, 0x275F4C}, /* East Asian ideograph */
  {"\x9F", 0, 0x27622F}, /* East Asian ideograph */
  {"\xA0", 0, 0x276230}, /* East Asian ideograph */
  {"\xA2", 0, 0x276231}, /* East Asian ideograph */
  {"\xA3", 0, 0x276232}, /* East Asian ideograph */
  {"\xA9", 0, 0x276234}, /* East Asian ideograph */
  {"\xA6", 0, 0x276235}, /* East Asian ideograph */
  {"\xB5", 0, 0x276236}, /* East Asian ideograph */
  {"\xAA", 0, 0x276237}, /* East Asian ideograph */
  {"\xAD", 0, 0x276238}, /* East Asian ideograph */
  {"\xAF", 0, 0x276239}, /* East Asian ideograph */
  {"\xB3", 0, 0x27623A}, /* East Asian ideograph */
  {"\xBF", 0, 0x27623C}, /* East Asian ideograph */
  {"\xBD", 0, 0x27623D}, /* East Asian ideograph */
  {"\xA5", 0, 0x27624A}, /* East Asian ideograph */
  {"\xB6", 0, 0x27624B}, /* East Asian ideograph */
  {"\xBE", 0, 0x27624F}, /* East Asian ideograph */
  {"\xA8", 0, 0x295A28}, /* East Asian ideograph */
  {"\xB2", 0, 0x295A44}, /* East Asian ideograph */
  {"\xB1", 0, 0x295A48}, /* East Asian ideograph */
  {"\xB8", 0, 0x295A59}, /* East Asian ideograph */
  {"\xB9", 0, 0x295A65}, /* East Asian ideograph */
  {"\xBA", 0, 0x295A68}, /* East Asian ideograph */
  {"\xAB", 0, 0x295B35}, /* East Asian ideograph */
  {"\xB7", 0, 0x295C3E}, /* East Asian ideograph */
  {"\xAC", 0, 0x295D36}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page323 = {
  marc8r_31page323_flat, 0
};
/* PAGE 322 */
struct yaz_iconv_trie_flat marc8r_31page322_flat[] = {
  {"\x82", 0, 0x216248}, /* East Asian ideograph */
  {"\x93", 0, 0x216249}, /* East Asian ideograph */
  {"\x97", 0, 0x21624A}, /* East Asian ideograph */
  {"\xA5", 0, 0x21624B}, /* East Asian ideograph */
  {"\xB9", 0, 0x21624C}, /* East Asian ideograph */
  {"\xBA", 0, 0x21624D}, /* East Asian ideograph */
  {"\x80", 0, 0x235B79}, /* East Asian ideograph */
  {"\x81", 0, 0x235B7A}, /* East Asian ideograph */
  {"\x8F", 0, 0x235B7E}, /* East Asian ideograph */
  {"\x87", 0, 0x235C22}, /* East Asian ideograph */
  {"\x83", 0, 0x235C27}, /* East Asian ideograph */
  {"\x9F", 0, 0x235C3A}, /* East Asian ideograph */
  {"\x99", 0, 0x235C3E}, /* East Asian ideograph */
  {"\x96", 0, 0x235C45}, /* East Asian ideograph */
  {"\x9E", 0, 0x235C46}, /* East Asian ideograph */
  {"\xA9", 0, 0x235C4F}, /* East Asian ideograph */
  {"\xB2", 0, 0x235C57}, /* East Asian ideograph */
  {"\xB8", 0, 0x235C5B}, /* East Asian ideograph */
  {"\xBC", 0, 0x235C5C}, /* East Asian ideograph */
  {"\xAB", 0, 0x235C5F}, /* East Asian ideograph */
  {"\xAF", 0, 0x235C65}, /* East Asian ideograph */
  {"\xAD", 0, 0x235C6A}, /* East Asian ideograph */
  {"\xA6", 0, 0x235C6C}, /* East Asian ideograph */
  {"\xAE", 0, 0x235C6D}, /* East Asian ideograph */
  {"\xBD", 0, 0x235C7E}, /* East Asian ideograph */
  {"\x84", 0, 0x2D5F4C}, /* East Asian ideograph */
  {"\xB0", 0, 0x3F4A28}, /* East Asian ideograph */
  {"\x86", 0, 0x4D5B7E}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page322 = {
  marc8r_31page322_flat, 0
};
/* PAGE 321 */
struct yaz_iconv_trie_flat marc8r_31page321_flat[] = {
  {"\x89", 0, 0x216242}, /* East Asian ideograph */
  {"\xB4", 0, 0x216246}, /* East Asian ideograph */
  {"\xAF", 0, 0x216247}, /* East Asian ideograph */
  {"\x8A", 0, 0x235B2E}, /* East Asian ideograph */
  {"\x87", 0, 0x235B35}, /* East Asian ideograph */
  {"\x83", 0, 0x235B4F}, /* East Asian ideograph */
  {"\xA9", 0, 0x235B59}, /* East Asian ideograph */
  {"\x92", 0, 0x235B5E}, /* East Asian ideograph */
  {"\x98", 0, 0x235B60}, /* East Asian ideograph */
  {"\xA4", 0, 0x235B66}, /* East Asian ideograph */
  {"\xAA", 0, 0x235B67}, /* East Asian ideograph */
  {"\xA1", 0, 0x235B6A}, /* East Asian ideograph */
  {"\x9A", 0, 0x235B6B}, /* East Asian ideograph */
  {"\x96", 0, 0x235B70}, /* East Asian ideograph */
  {"\xB1", 0, 0x235B74}, /* East Asian ideograph */
  {"\xB6", 0, 0x235B76}, /* East Asian ideograph */
  {"\xBC", 0, 0x235B77}, /* East Asian ideograph */
  {"\xB8", 0, 0x235B7B}, /* East Asian ideograph */
  {"\xBA", 0, 0x235B7C}, /* East Asian ideograph */
  {"\xBB", 0, 0x235C28}, /* East Asian ideograph */
  {"\xB9", 0, 0x235C32}, /* East Asian ideograph */
  {"\xAC", 0, 0x235C34}, /* East Asian ideograph */
  {"\xB2", 0, 0x235C36}, /* East Asian ideograph */
  {"\x8F", 0, 0x4B5F4C}, /* East Asian ideograph */
  {"\xAB", 0, 0x4D5B35}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page321 = {
  marc8r_31page321_flat, 0
};
/* PAGE 320 */
struct yaz_iconv_trie_flat marc8r_31page320_flat[] = {
  {"\xA1", 0, 0x21623E}, /* East Asian ideograph */
  {"\x91", 0, 0x21623F}, /* East Asian ideograph */
  {"\xA0", 0, 0x216240}, /* East Asian ideograph */
  {"\x9D", 0, 0x216241}, /* East Asian ideograph */
  {"\xB2", 0, 0x216243}, /* East Asian ideograph */
  {"\xAA", 0, 0x216244}, /* East Asian ideograph */
  {"\xAC", 0, 0x216245}, /* East Asian ideograph */
  {"\x81", 0, 0x235A4F}, /* East Asian ideograph */
  {"\x82", 0, 0x235A68}, /* East Asian ideograph */
  {"\x80", 0, 0x235A69}, /* East Asian ideograph */
  {"\x9C", 0, 0x235A70}, /* East Asian ideograph */
  {"\x93", 0, 0x235A75}, /* East Asian ideograph */
  {"\x99", 0, 0x235A7B}, /* East Asian ideograph */
  {"\x9A", 0, 0x235B26}, /* East Asian ideograph */
  {"\x92", 0, 0x235B2A}, /* East Asian ideograph */
  {"\xB7", 0, 0x235B2C}, /* East Asian ideograph */
  {"\xBA", 0, 0x235B2F}, /* East Asian ideograph */
  {"\xB8", 0, 0x235B3F}, /* East Asian ideograph */
  {"\xBE", 0, 0x235B42}, /* East Asian ideograph */
  {"\xA9", 0, 0x235B47}, /* East Asian ideograph */
  {"\xBB", 0, 0x235B4D}, /* East Asian ideograph */
  {"\xAF", 0, 0x235B52}, /* East Asian ideograph */
  {"\xB6", 0, 0x2D6235}, /* East Asian ideograph */
  {"\x9E", 0, 0x2D6241}, /* East Asian ideograph */
  {"\x84", 0, 0x2F5A48}, /* East Asian ideograph */
  {"\xB0", 0, 0x335F49}, /* East Asian ideograph */
  {"\x89", 0, 0x4B624F}, /* East Asian ideograph */
  {"\x86", 0, 0x4D5A6C}, /* East Asian ideograph */
  {"\x90", 0, 0x4D5C6B}, /* East Asian ideograph */
  {"\x88", 0, 0x69727E}, /* East Asian ideograph */
  {"\xA4", 0, 0x697323}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page320 = {
  marc8r_31page320_flat, 0
};
/* PAGE 319 */
struct yaz_iconv_trie_flat marc8r_31page319_flat[] = {
  {"\x86", 0, 0x216234}, /* East Asian ideograph */
  {"\x89", 0, 0x216235}, /* East Asian ideograph */
  {"\x95", 0, 0x216236}, /* East Asian ideograph */
  {"\xA3", 0, 0x216237}, /* East Asian ideograph */
  {"\xA8", 0, 0x216238}, /* East Asian ideograph */
  {"\xA6", 0, 0x216239}, /* East Asian ideograph */
  {"\x9B", 0, 0x21623A}, /* East Asian ideograph */
  {"\x92", 0, 0x21623B}, /* East Asian ideograph (variant of EACC 4B623B) */
  {"\xBB", 0, 0x21623C}, /* East Asian ideograph */
  {"\xBF", 0, 0x21623D}, /* East Asian ideograph */
  {"\x82", 0, 0x235A21}, /* East Asian ideograph */
  {"\x83", 0, 0x235A22}, /* East Asian ideograph */
  {"\x84", 0, 0x235A24}, /* East Asian ideograph */
  {"\x87", 0, 0x235A28}, /* East Asian ideograph */
  {"\xAA", 0, 0x235A2F}, /* East Asian ideograph */
  {"\xA5", 0, 0x235A30}, /* East Asian ideograph */
  {"\x9E", 0, 0x235A3F}, /* East Asian ideograph */
  {"\x9D", 0, 0x235A44}, /* East Asian ideograph */
  {"\x9F", 0, 0x235A48}, /* East Asian ideograph */
  {"\xB6", 0, 0x235A53}, /* East Asian ideograph */
  {"\xBE", 0, 0x235A63}, /* East Asian ideograph */
  {"\xB0", 0, 0x235A65}, /* East Asian ideograph */
  {"\xBD", 0, 0x235A6B}, /* East Asian ideograph */
  {"\x88", 0, 0x335F43}, /* East Asian ideograph */
  {"\xAC", 0, 0x4B6247}, /* East Asian ideograph */
  {"\xAB", 0, 0x693C32}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page319 = {
  marc8r_31page319_flat, 0
};
/* PAGE 318 */
struct yaz_iconv_trie_flat marc8r_31page318_flat[] = {
  {"\xA5", 0, 0x21622F}, /* East Asian ideograph */
  {"\xA9", 0, 0x216230}, /* East Asian ideograph */
  {"\xB6", 0, 0x216231}, /* East Asian ideograph */
  {"\xB4", 0, 0x216232}, /* East Asian ideograph */
  {"\xB3", 0, 0x216233}, /* East Asian ideograph */
  {"\xA7", 0, 0x235973}, /* East Asian ideograph */
  {"\xB0", 0, 0x235974}, /* East Asian ideograph */
  {"\xB2", 0, 0x235977}, /* East Asian ideograph */
  {"\xB7", 0, 0x235A23}, /* East Asian ideograph */
  {"\xB8", 0, 0x235A2C}, /* East Asian ideograph */
  {"\x83", 0, 0x276221}, /* East Asian ideograph */
  {"\x85", 0, 0x276222}, /* East Asian ideograph */
  {"\x8D", 0, 0x276224}, /* East Asian ideograph */
  {"\x8F", 0, 0x276225}, /* East Asian ideograph */
  {"\x94", 0, 0x276227}, /* East Asian ideograph */
  {"\x97", 0, 0x276228}, /* East Asian ideograph */
  {"\x9D", 0, 0x276229}, /* East Asian ideograph */
  {"\x9E", 0, 0x27622A}, /* East Asian ideograph */
  {"\x9C", 0, 0x27622B}, /* East Asian ideograph */
  {"\x96", 0, 0x27622C}, /* East Asian ideograph */
  {"\x8A", 0, 0x29583E}, /* East Asian ideograph */
  {"\x84", 0, 0x295854}, /* East Asian ideograph */
  {"\x86", 0, 0x295859}, /* East Asian ideograph */
  {"\x87", 0, 0x29585C}, /* East Asian ideograph */
  {"\x8B", 0, 0x29586A}, /* East Asian ideograph */
  {"\x8E", 0, 0x295871}, /* East Asian ideograph */
  {"\x99", 0, 0x295921}, /* East Asian ideograph */
  {"\x8C", 0, 0x295925}, /* East Asian ideograph */
  {"\x95", 0, 0x295928}, /* East Asian ideograph */
  {"\x93", 0, 0x29592A}, /* East Asian ideograph */
  {"\x98", 0, 0x295932}, /* East Asian ideograph */
  {"\x9F", 0, 0x295938}, /* East Asian ideograph */
  {"\xA2", 0, 0x29594F}, /* East Asian ideograph */
  {"\xAB", 0, 0x2D5F43}, /* East Asian ideograph */
  {"\xAC", 0, 0x2F5973}, /* East Asian ideograph */
  {"\x90", 0, 0x4D5875}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page318 = {
  marc8r_31page318_flat, 0
};
/* PAGE 317 */
struct yaz_iconv_trie_flat marc8r_31page317_flat[] = {
  {"\x94", 0, 0x216229}, /* East Asian ideograph */
  {"\x97", 0, 0x21622A}, /* East Asian ideograph */
  {"\x96", 0, 0x21622B}, /* East Asian ideograph */
  {"\x89", 0, 0x21622C}, /* East Asian ideograph */
  {"\xB7", 0, 0x21622D}, /* East Asian ideograph */
  {"\xB8", 0, 0x21622E}, /* East Asian ideograph */
  {"\x86", 0, 0x23587E}, /* East Asian ideograph */
  {"\x84", 0, 0x235926}, /* East Asian ideograph */
  {"\x88", 0, 0x235928}, /* East Asian ideograph */
  {"\x87", 0, 0x235930}, /* East Asian ideograph */
  {"\x92", 0, 0x235938}, /* East Asian ideograph */
  {"\x98", 0, 0x23593B}, /* East Asian ideograph */
  {"\x91", 0, 0x235945}, /* East Asian ideograph */
  {"\xA3", 0, 0x235949}, /* East Asian ideograph */
  {"\xA7", 0, 0x23594F}, /* East Asian ideograph */
  {"\x9F", 0, 0x235955}, /* East Asian ideograph */
  {"\xA0", 0, 0x235956}, /* East Asian ideograph */
  {"\xAD", 0, 0x235958}, /* East Asian ideograph */
  {"\xA8", 0, 0x23595B}, /* East Asian ideograph */
  {"\xAF", 0, 0x23595C}, /* East Asian ideograph */
  {"\xAE", 0, 0x23595E}, /* East Asian ideograph */
  {"\xBA", 0, 0x23596B}, /* East Asian ideograph */
  {"\xBC", 0, 0x276174}, /* East Asian ideograph */
  {"\xBF", 0, 0x276175}, /* East Asian ideograph */
  {"\x93", 0, 0x2D6229}, /* East Asian ideograph */
  {"\xBB", 0, 0x336179}, /* East Asian ideograph */
  {"\xB6", 0, 0x355739}, /* East Asian ideograph */
  {"\x9A", 0, 0x697265}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page317 = {
  marc8r_31page317_flat, 0
};
/* PAGE 316 */
struct yaz_iconv_trie_flat marc8r_31page316_flat[] = {
  {"\x93", 0, 0x216221}, /* East Asian ideograph */
  {"\x8D", 0, 0x216222}, /* East Asian ideograph */
  {"\xAD", 0, 0x216224}, /* East Asian ideograph */
  {"\xA5", 0, 0x216225}, /* East Asian ideograph */
  {"\xB1", 0, 0x216226}, /* East Asian ideograph */
  {"\xBE", 0, 0x216227}, /* East Asian ideograph */
  {"\xBB", 0, 0x216228}, /* East Asian ideograph */
  {"\x86", 0, 0x235843}, /* East Asian ideograph */
  {"\x95", 0, 0x235844}, /* East Asian ideograph */
  {"\x8A", 0, 0x235849}, /* East Asian ideograph */
  {"\x88", 0, 0x23584B}, /* East Asian ideograph */
  {"\x94", 0, 0x23584C}, /* East Asian ideograph */
  {"\x84", 0, 0x23584D}, /* East Asian ideograph */
  {"\x82", 0, 0x235852}, /* East Asian ideograph */
  {"\x90", 0, 0x235854}, /* East Asian ideograph */
  {"\x92", 0, 0x235859}, /* East Asian ideograph */
  {"\x89", 0, 0x23585C}, /* East Asian ideograph */
  {"\x9C", 0, 0x235866}, /* East Asian ideograph */
  {"\xAF", 0, 0x235869}, /* East Asian ideograph */
  {"\xA3", 0, 0x23586E}, /* East Asian ideograph */
  {"\xAE", 0, 0x235870}, /* East Asian ideograph */
  {"\xA8", 0, 0x235871}, /* East Asian ideograph */
  {"\xA1", 0, 0x235878}, /* East Asian ideograph */
  {"\xA4", 0, 0x235879}, /* East Asian ideograph */
  {"\xB2", 0, 0x235925}, /* East Asian ideograph */
  {"\xB9", 0, 0x235929}, /* East Asian ideograph */
  {"\xB3", 0, 0x23592A}, /* East Asian ideograph */
  {"\xB5", 0, 0x235932}, /* East Asian ideograph */
  {"\xB7", 0, 0x235934}, /* East Asian ideograph */
  {"\x8C", 0, 0x2D6222}, /* East Asian ideograph */
  {"\x9B", 0, 0x2F5870}, /* East Asian ideograph */
  {"\xBA", 0, 0x47594E}, /* East Asian ideograph */
  {"\xB0", 0, 0x697260}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page316 = {
  marc8r_31page316_flat, 0
};
/* PAGE 315 */
struct yaz_iconv_trie_flat marc8r_31page315_flat[] = {
  {"\x8A", 0, 0x21617B}, /* East Asian ideograph */
  {"\x89", 0, 0x21617C}, /* East Asian ideograph */
  {"\xA8", 0, 0x21617D}, /* East Asian ideograph */
  {"\xA7", 0, 0x21617E}, /* East Asian ideograph */
  {"\xBD", 0, 0x216223}, /* East Asian ideograph */
  {"\x87", 0, 0x235756}, /* East Asian ideograph */
  {"\x92", 0, 0x235759}, /* East Asian ideograph */
  {"\x86", 0, 0x23575D}, /* East Asian ideograph */
  {"\x81", 0, 0x23575F}, /* East Asian ideograph */
  {"\x93", 0, 0x23576C}, /* East Asian ideograph */
  {"\x80", 0, 0x23576E}, /* East Asian ideograph */
  {"\x88", 0, 0x235772}, /* East Asian ideograph */
  {"\x97", 0, 0x235777}, /* East Asian ideograph */
  {"\x96", 0, 0x23577A}, /* East Asian ideograph */
  {"\xAB", 0, 0x23577C}, /* East Asian ideograph */
  {"\x95", 0, 0x235823}, /* East Asian ideograph */
  {"\xA4", 0, 0x235827}, /* East Asian ideograph */
  {"\xB1", 0, 0x23582B}, /* East Asian ideograph */
  {"\xA1", 0, 0x23582C}, /* East Asian ideograph */
  {"\x9B", 0, 0x23582D}, /* East Asian ideograph */
  {"\xA2", 0, 0x23582F}, /* East Asian ideograph */
  {"\xB0", 0, 0x235831}, /* East Asian ideograph */
  {"\x94", 0, 0x235834}, /* East Asian ideograph */
  {"\xBF", 0, 0x23583E}, /* East Asian ideograph */
  {"\xA3", 0, 0x4D5858}, /* East Asian ideograph */
  {"\xB5", 0, 0x4D594E}, /* East Asian ideograph */
  {"\x8F", 0, 0x697245}, /* East Asian ideograph */
  {"\x91", 0, 0x697246}, /* East Asian ideograph */
  {"\xB2", 0, 0x69724E}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page315 = {
  marc8r_31page315_flat, 0
};
/* PAGE 314 */
struct yaz_iconv_trie_flat marc8r_31page314_flat[] = {
  {"\x91", 0, 0x216177}, /* East Asian ideograph */
  {"\xAB", 0, 0x216178}, /* East Asian ideograph */
  {"\xAE", 0, 0x216179}, /* East Asian ideograph */
  {"\xAA", 0, 0x21617A}, /* East Asian ideograph */
  {"\x80", 0, 0x235672}, /* East Asian ideograph */
  {"\x8C", 0, 0x235673}, /* East Asian ideograph */
  {"\x95", 0, 0x23567A}, /* East Asian ideograph */
  {"\x83", 0, 0x235721}, /* East Asian ideograph */
  {"\x8E", 0, 0x235729}, /* East Asian ideograph */
  {"\x90", 0, 0x23572B}, /* East Asian ideograph */
  {"\x93", 0, 0x23572E}, /* East Asian ideograph */
  {"\x97", 0, 0x23572F}, /* East Asian ideograph */
  {"\x92", 0, 0x235731}, /* East Asian ideograph */
  {"\x98", 0, 0x235732}, /* East Asian ideograph */
  {"\x9F", 0, 0x235736}, /* East Asian ideograph */
  {"\x9D", 0, 0x235739}, /* East Asian ideograph */
  {"\xAD", 0, 0x23573C}, /* East Asian ideograph */
  {"\x9A", 0, 0x23573D}, /* East Asian ideograph */
  {"\xA8", 0, 0x23573F}, /* East Asian ideograph */
  {"\x9E", 0, 0x235742}, /* East Asian ideograph */
  {"\x99", 0, 0x235743}, /* East Asian ideograph */
  {"\x86", 0, 0x235749}, /* East Asian ideograph */
  {"\xA0", 0, 0x23574E}, /* East Asian ideograph */
  {"\xBF", 0, 0x23575E}, /* East Asian ideograph */
  {"\xB9", 0, 0x235766}, /* East Asian ideograph */
  {"\xBB", 0, 0x23576B}, /* East Asian ideograph */
  {"\x96", 0, 0x69723B}, /* East Asian ideograph */
  {"\xB4", 0, 0x697240}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page314 = {
  marc8r_31page314_flat, 0
};
/* PAGE 313 */
struct yaz_iconv_trie_flat marc8r_31page313_flat[] = {
  {"\x81", 0, 0x21616D}, /* East Asian ideograph */
  {"\x82", 0, 0x21616E}, /* East Asian ideograph */
  {"\x85", 0, 0x21616F}, /* East Asian ideograph */
  {"\x84", 0, 0x216170}, /* East Asian ideograph */
  {"\x8F", 0, 0x216171}, /* East Asian ideograph */
  {"\x94", 0, 0x216172}, /* East Asian ideograph */
  {"\x98", 0, 0x216173}, /* East Asian ideograph */
  {"\x9A", 0, 0x216174}, /* East Asian ideograph */
  {"\xB7", 0, 0x216175}, /* East Asian ideograph */
  {"\xAF", 0, 0x216176}, /* East Asian ideograph */
  {"\x83", 0, 0x235636}, /* East Asian ideograph */
  {"\x88", 0, 0x23563A}, /* East Asian ideograph */
  {"\x8E", 0, 0x23563C}, /* East Asian ideograph */
  {"\x8D", 0, 0x23563E}, /* East Asian ideograph */
  {"\x8B", 0, 0x235641}, /* East Asian ideograph */
  {"\x91", 0, 0x235647}, /* East Asian ideograph */
  {"\xB4", 0, 0x23565D}, /* East Asian ideograph */
  {"\xA8", 0, 0x235663}, /* East Asian ideograph */
  {"\xBD", 0, 0x23567B}, /* East Asian ideograph */
  {"\x87", 0, 0x276173}, /* East Asian ideograph */
  {"\x89", 0, 0x29563C}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page313 = {
  marc8r_31page313_flat, 0
};
/* PAGE 312 */
struct yaz_iconv_trie_flat marc8r_31page312_flat[] = {
  {"\x83", 0, 0x216162}, /* East Asian ideograph */
  {"\x86", 0, 0x216163}, /* East Asian ideograph */
  {"\x8D", 0, 0x216164}, /* East Asian ideograph */
  {"\x9A", 0, 0x216165}, /* East Asian ideograph */
  {"\xA2", 0, 0x216166}, /* East Asian ideograph */
  {"\xA5", 0, 0x216167}, /* East Asian ideograph */
  {"\xA7", 0, 0x216168}, /* East Asian ideograph */
  {"\xB1", 0, 0x21616A}, /* East Asian ideograph */
  {"\xB2", 0, 0x21616B}, /* East Asian ideograph */
  {"\xBC", 0, 0x21616C}, /* East Asian ideograph */
  {"\x81", 0, 0x235536}, /* East Asian ideograph */
  {"\x82", 0, 0x235538}, /* East Asian ideograph */
  {"\x80", 0, 0x23553B}, /* East Asian ideograph */
  {"\x88", 0, 0x23553C}, /* East Asian ideograph */
  {"\x84", 0, 0x23553E}, /* East Asian ideograph */
  {"\x85", 0, 0x235541}, /* East Asian ideograph */
  {"\x8B", 0, 0x235543}, /* East Asian ideograph */
  {"\x8E", 0, 0x235547}, /* East Asian ideograph */
  {"\x91", 0, 0x23554E}, /* East Asian ideograph */
  {"\x90", 0, 0x23554F}, /* East Asian ideograph */
  {"\x98", 0, 0x235554}, /* East Asian ideograph */
  {"\x9D", 0, 0x235556}, /* East Asian ideograph */
  {"\x9F", 0, 0x23555E}, /* East Asian ideograph */
  {"\xA3", 0, 0x235566}, /* East Asian ideograph */
  {"\xA9", 0, 0x23556C}, /* East Asian ideograph */
  {"\xAD", 0, 0x235573}, /* East Asian ideograph */
  {"\xAE", 0, 0x235574}, /* East Asian ideograph */
  {"\xAF", 0, 0x235576}, /* East Asian ideograph */
  {"\xB4", 0, 0x23557D}, /* East Asian ideograph */
  {"\xB5", 0, 0x235622}, /* East Asian ideograph */
  {"\xB7", 0, 0x235623}, /* East Asian ideograph */
  {"\x93", 0, 0x276166}, /* East Asian ideograph */
  {"\x92", 0, 0x2F5E66}, /* East Asian ideograph */
  {"\xA8", 0, 0x33362A}, /* East Asian ideograph */
  {"\xBB", 0, 0x39505B}, /* East Asian ideograph */
  {"\xAA", 0, 0x396167}, /* East Asian ideograph */
  {"\x8F", 0, 0x70775D}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page312 = {
  marc8r_31page312_flat, 0
};
/* PAGE 311 */
struct yaz_iconv_trie_flat marc8r_31page311_flat[] = {
  {"\x8F", 0, 0x216158}, /* East Asian ideograph */
  {"\x93", 0, 0x216159}, /* East Asian ideograph */
  {"\x94", 0, 0x21615A}, /* East Asian ideograph */
  {"\x92", 0, 0x21615B}, /* East Asian ideograph */
  {"\x98", 0, 0x21615C}, /* East Asian ideograph */
  {"\xA5", 0, 0x21615D}, /* East Asian ideograph */
  {"\xAE", 0, 0x21615F}, /* East Asian ideograph */
  {"\xBB", 0, 0x216160}, /* East Asian ideograph */
  {"\xAD", 0, 0x216161}, /* East Asian ideograph */
  {"\x81", 0, 0x235457}, /* East Asian ideograph */
  {"\x80", 0, 0x235459}, /* East Asian ideograph */
  {"\x82", 0, 0x23545A}, /* East Asian ideograph */
  {"\x88", 0, 0x23545D}, /* East Asian ideograph */
  {"\x90", 0, 0x235466}, /* East Asian ideograph */
  {"\x91", 0, 0x23546A}, /* East Asian ideograph */
  {"\x96", 0, 0x23546D}, /* East Asian ideograph */
  {"\x9C", 0, 0x235472}, /* East Asian ideograph */
  {"\x9F", 0, 0x235474}, /* East Asian ideograph */
  {"\xA0", 0, 0x235476}, /* East Asian ideograph */
  {"\xA2", 0, 0x235477}, /* East Asian ideograph */
  {"\xA7", 0, 0x235521}, /* East Asian ideograph */
  {"\xAB", 0, 0x235527}, /* East Asian ideograph */
  {"\xB2", 0, 0x235528}, /* East Asian ideograph */
  {"\xAF", 0, 0x23552A}, /* East Asian ideograph */
  {"\xB9", 0, 0x235532}, /* East Asian ideograph */
  {"\xBD", 0, 0x235535}, /* East Asian ideograph */
  {"\x85", 0, 0x276158}, /* East Asian ideograph */
  {"\x8B", 0, 0x29546D}, /* East Asian ideograph */
  {"\xB4", 0, 0x2D3D5E}, /* East Asian ideograph */
  {"\x97", 0, 0x2D5421}, /* East Asian ideograph */
  {"\x84", 0, 0x2D6159}, /* East Asian ideograph */
  {"\xA1", 0, 0x2F5476}, /* East Asian ideograph */
  {"\x95", 0, 0x33537D}, /* East Asian ideograph */
  {"\xA3", 0, 0x393078}, /* East Asian ideograph */
  {"\xA6", 0, 0x394A60}, /* East Asian ideograph */
  {"\x8C", 0, 0x4B537D}, /* East Asian ideograph */
  {"\xAA", 0, 0x4B615F}, /* East Asian ideograph */
  {"\x9E", 0, 0x697174}, /* East Asian ideograph */
  {"\xB1", 0, 0x69717D}, /* East Asian ideograph */
  {"\xB7", 0, 0x69717E}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page311 = {
  marc8r_31page311_flat, 0
};
/* PAGE 310 */
struct yaz_iconv_trie_flat marc8r_31page310_flat[] = {
  {"\xA8", 0, 0x216152}, /* East Asian ideograph */
  {"\xAF", 0, 0x216153}, /* East Asian ideograph */
  {"\xB0", 0, 0x216154}, /* East Asian ideograph */
  {"\xB7", 0, 0x216155}, /* East Asian ideograph */
  {"\xB8", 0, 0x216156}, /* East Asian ideograph */
  {"\xBC", 0, 0x216157}, /* East Asian ideograph */
  {"\xAD", 0, 0x23543F}, /* East Asian ideograph */
  {"\xAB", 0, 0x235441}, /* East Asian ideograph */
  {"\xB1", 0, 0x235443}, /* East Asian ideograph */
  {"\xB3", 0, 0x235445}, /* East Asian ideograph */
  {"\xB6", 0, 0x235449}, /* East Asian ideograph */
  {"\xBB", 0, 0x23544C}, /* East Asian ideograph */
  {"\xBA", 0, 0x235450}, /* East Asian ideograph */
  {"\xBD", 0, 0x235454}, /* East Asian ideograph */
  {"\x82", 0, 0x275234}, /* East Asian ideograph */
  {"\x87", 0, 0x27613B}, /* East Asian ideograph */
  {"\x86", 0, 0x27613C}, /* East Asian ideograph */
  {"\x8B", 0, 0x27613D}, /* East Asian ideograph */
  {"\x8F", 0, 0x27613E}, /* East Asian ideograph */
  {"\x88", 0, 0x27613F}, /* East Asian ideograph */
  {"\x91", 0, 0x276140}, /* East Asian ideograph */
  {"\x97", 0, 0x276141}, /* East Asian ideograph */
  {"\x9B", 0, 0x276142}, /* East Asian ideograph */
  {"\x9E", 0, 0x276143}, /* East Asian ideograph */
  {"\x9A", 0, 0x276145}, /* East Asian ideograph */
  {"\xA0", 0, 0x276146}, /* East Asian ideograph */
  {"\xA1", 0, 0x276149}, /* East Asian ideograph */
  {"\x84", 0, 0x27614A}, /* East Asian ideograph */
  {"\x8C", 0, 0x27614D}, /* East Asian ideograph */
  {"\xA4", 0, 0x27614E}, /* East Asian ideograph */
  {"\xA5", 0, 0x276150}, /* East Asian ideograph */
  {"\x8A", 0, 0x276151}, /* East Asian ideograph */
  {"\x80", 0, 0x295269}, /* East Asian ideograph */
  {"\x90", 0, 0x29533D}, /* East Asian ideograph */
  {"\x92", 0, 0x295340}, /* East Asian ideograph */
  {"\x93", 0, 0x295347}, /* East Asian ideograph */
  {"\x9F", 0, 0x29535A}, /* East Asian ideograph */
  {"\x98", 0, 0x295360}, /* East Asian ideograph */
  {"\x9D", 0, 0x29536A}, /* East Asian ideograph */
  {"\x9C", 0, 0x295370}, /* East Asian ideograph */
  {"\x96", 0, 0x295379}, /* East Asian ideograph */
  {"\xA2", 0, 0x29537A}, /* East Asian ideograph */
  {"\xA3", 0, 0x295421}, /* East Asian ideograph */
  {"\x81", 0, 0x295422}, /* East Asian ideograph */
  {"\x85", 0, 0x295427}, /* East Asian ideograph */
  {"\xA7", 0, 0x295433}, /* East Asian ideograph */
  {"\xBE", 0, 0x2F575F}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page310 = {
  marc8r_31page310_flat, 0
};
/* PAGE 309 */
struct yaz_iconv_trie_flat marc8r_31page309_flat[] = {
  {"\x83", 0, 0x216146}, /* East Asian ideograph */
  {"\x85", 0, 0x216147}, /* East Asian ideograph */
  {"\x80", 0, 0x216148}, /* East Asian ideograph */
  {"\x95", 0, 0x21614A}, /* East Asian ideograph */
  {"\x9A", 0, 0x21614B}, /* East Asian ideograph */
  {"\x9B", 0, 0x21614C}, /* East Asian ideograph */
  {"\x97", 0, 0x21614D}, /* East Asian ideograph */
  {"\x9F", 0, 0x21614E}, /* East Asian ideograph */
  {"\xA2", 0, 0x21614F}, /* East Asian ideograph */
  {"\xA5", 0, 0x216150}, /* East Asian ideograph */
  {"\xAA", 0, 0x216151}, /* East Asian ideograph */
  {"\x81", 0, 0x235370}, /* East Asian ideograph */
  {"\x82", 0, 0x235379}, /* East Asian ideograph */
  {"\x84", 0, 0x23537A}, /* East Asian ideograph */
  {"\x88", 0, 0x23537D}, /* East Asian ideograph */
  {"\x8C", 0, 0x23537E}, /* East Asian ideograph */
  {"\x8D", 0, 0x235422}, /* East Asian ideograph */
  {"\x92", 0, 0x235424}, /* East Asian ideograph */
  {"\x8A", 0, 0x235427}, /* East Asian ideograph */
  {"\x98", 0, 0x23542A}, /* East Asian ideograph */
  {"\x96", 0, 0x23542C}, /* East Asian ideograph */
  {"\xA4", 0, 0x235433}, /* East Asian ideograph */
  {"\xA6", 0, 0x235434}, /* East Asian ideograph */
  {"\xAB", 0, 0x23543A}, /* East Asian ideograph */
  {"\xAC", 0, 0x27612C}, /* East Asian ideograph */
  {"\xAD", 0, 0x27612E}, /* East Asian ideograph */
  {"\xB0", 0, 0x27612F}, /* East Asian ideograph */
  {"\xAE", 0, 0x276130}, /* East Asian ideograph */
  {"\xAF", 0, 0x276131}, /* East Asian ideograph */
  {"\xB3", 0, 0x276132}, /* East Asian ideograph */
  {"\xBB", 0, 0x276133}, /* East Asian ideograph */
  {"\xBC", 0, 0x276134}, /* East Asian ideograph */
  {"\xBE", 0, 0x276135}, /* East Asian ideograph */
  {"\xB7", 0, 0x276136}, /* East Asian ideograph */
  {"\xB6", 0, 0x276137}, /* East Asian ideograph */
  {"\xB9", 0, 0x276138}, /* East Asian ideograph */
  {"\xB8", 0, 0x276139}, /* East Asian ideograph */
  {"\xBD", 0, 0x27613A}, /* East Asian ideograph */
  {"\xB1", 0, 0x276147}, /* East Asian ideograph */
  {"\xBF", 0, 0x27614C}, /* East Asian ideograph */
  {"\xB4", 0, 0x27614F}, /* East Asian ideograph */
  {"\xB5", 0, 0x295263}, /* East Asian ideograph */
  {"\xBA", 0, 0x295369}, /* East Asian ideograph */
  {"\xA9", 0, 0x3F4621}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page309 = {
  marc8r_31page309_flat, 0
};
/* PAGE 308 */
struct yaz_iconv_trie_flat marc8r_31page308_flat[] = {
  {"\x81", 0, 0x21613D}, /* East Asian ideograph */
  {"\x8E", 0, 0x216140}, /* East Asian ideograph */
  {"\x99", 0, 0x216141}, /* East Asian ideograph */
  {"\x96", 0, 0x216142}, /* East Asian ideograph */
  {"\xAB", 0, 0x216143}, /* East Asian ideograph */
  {"\xB0", 0, 0x216144}, /* East Asian ideograph */
  {"\xB7", 0, 0x216145}, /* East Asian ideograph */
  {"\xBE", 0, 0x216149}, /* East Asian ideograph */
  {"\x82", 0, 0x235324}, /* East Asian ideograph */
  {"\x8F", 0, 0x23533D}, /* East Asian ideograph */
  {"\x8B", 0, 0x23533E}, /* East Asian ideograph */
  {"\x89", 0, 0x23533F}, /* East Asian ideograph */
  {"\x84", 0, 0x235344}, /* East Asian ideograph */
  {"\x91", 0, 0x235345}, /* East Asian ideograph */
  {"\x85", 0, 0x235347}, /* East Asian ideograph */
  {"\x90", 0, 0x235348}, /* East Asian ideograph */
  {"\xA4", 0, 0x23534C}, /* East Asian ideograph */
  {"\xA2", 0, 0x23534D}, /* East Asian ideograph */
  {"\xA0", 0, 0x23534F}, /* East Asian ideograph */
  {"\xA7", 0, 0x235352}, /* East Asian ideograph */
  {"\xAF", 0, 0x235359}, /* East Asian ideograph */
  {"\xB8", 0, 0x23535A}, /* East Asian ideograph */
  {"\xAD", 0, 0x235360}, /* East Asian ideograph */
  {"\xB5", 0, 0x235361}, /* East Asian ideograph */
  {"\xB2", 0, 0x235364}, /* East Asian ideograph */
  {"\xB6", 0, 0x235369}, /* East Asian ideograph */
  {"\xAE", 0, 0x23536A}, /* East Asian ideograph */
  {"\xBB", 0, 0x235374}, /* East Asian ideograph */
  {"\x8C", 0, 0x2D6162}, /* East Asian ideograph */
  {"\x83", 0, 0x333556}, /* East Asian ideograph */
  {"\xA3", 0, 0x336162}, /* East Asian ideograph */
  {"\x88", 0, 0x4B613F}, /* East Asian ideograph */
  {"\x92", 0, 0x4B6145}, /* East Asian ideograph */
  {"\x93", 0, 0x4B614D}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page308 = {
  marc8r_31page308_flat, 0
};
/* PAGE 307 */
struct yaz_iconv_trie_flat marc8r_31page307_flat[] = {
  {"\x81", 0, 0x216132}, /* East Asian ideograph */
  {"\x90", 0, 0x216133}, /* East Asian ideograph */
  {"\x9D", 0, 0x216134}, /* East Asian ideograph */
  {"\x95", 0, 0x216135}, /* East Asian ideograph */
  {"\x9F", 0, 0x216136}, /* East Asian ideograph */
  {"\x9B", 0, 0x216137}, /* East Asian ideograph */
  {"\x92", 0, 0x216138}, /* East Asian ideograph */
  {"\x99", 0, 0x216139}, /* East Asian ideograph */
  {"\x91", 0, 0x21613A}, /* East Asian ideograph */
  {"\xAD", 0, 0x21613B}, /* East Asian ideograph */
  {"\xB1", 0, 0x21613C}, /* East Asian ideograph */
  {"\xBF", 0, 0x21613E}, /* East Asian ideograph */
  {"\xA2", 0, 0x21613F}, /* East Asian ideograph */
  {"\x83", 0, 0x23524F}, /* East Asian ideograph */
  {"\x93", 0, 0x235261}, /* East Asian ideograph */
  {"\x94", 0, 0x235263}, /* East Asian ideograph */
  {"\x89", 0, 0x235265}, /* East Asian ideograph */
  {"\x98", 0, 0x235269}, /* East Asian ideograph */
  {"\xAC", 0, 0x235274}, /* East Asian ideograph */
  {"\xB0", 0, 0x23527A}, /* East Asian ideograph */
  {"\xA3", 0, 0x23527B}, /* East Asian ideograph */
  {"\xAA", 0, 0x23527C}, /* East Asian ideograph */
  {"\xB8", 0, 0x235329}, /* East Asian ideograph */
  {"\xB4", 0, 0x23532A}, /* East Asian ideograph */
  {"\xBB", 0, 0x235330}, /* East Asian ideograph */
  {"\xBD", 0, 0x235331}, /* East Asian ideograph */
  {"\xAE", 0, 0x2D6132}, /* East Asian ideograph */
  {"\x9E", 0, 0x2D6134}, /* East Asian ideograph */
  {"\x88", 0, 0x2D6147}, /* East Asian ideograph */
  {"\xA1", 0, 0x335234}, /* East Asian ideograph */
  {"\x85", 0, 0x3F614C}, /* East Asian ideograph */
  {"\x84", 0, 0x4B6130}, /* East Asian ideograph */
  {"\x86", 0, 0x4B6147}, /* East Asian ideograph */
  {"\xB2", 0, 0x697152}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page307 = {
  marc8r_31page307_flat, 0
};
/* PAGE 306 */
struct yaz_iconv_trie_flat marc8r_31page306_flat[] = {
  {"\x96", 0, 0x216128}, /* East Asian ideograph */
  {"\x99", 0, 0x216129}, /* East Asian ideograph */
  {"\xA5", 0, 0x21612A}, /* East Asian ideograph */
  {"\xA8", 0, 0x21612B}, /* East Asian ideograph */
  {"\xAC", 0, 0x21612C}, /* East Asian ideograph */
  {"\xAE", 0, 0x21612D}, /* East Asian ideograph */
  {"\xAD", 0, 0x21612E}, /* East Asian ideograph */
  {"\xB3", 0, 0x21612F}, /* East Asian ideograph */
  {"\xB1", 0, 0x216130}, /* East Asian ideograph */
  {"\xB4", 0, 0x216131}, /* East Asian ideograph */
  {"\x97", 0, 0x23522F}, /* East Asian ideograph */
  {"\x98", 0, 0x235230}, /* East Asian ideograph */
  {"\xA3", 0, 0x23523B}, /* East Asian ideograph */
  {"\xA1", 0, 0x23523C}, /* East Asian ideograph */
  {"\xA6", 0, 0x23523E}, /* East Asian ideograph */
  {"\xA9", 0, 0x235241}, /* East Asian ideograph */
  {"\xAA", 0, 0x235242}, /* East Asian ideograph */
  {"\xB5", 0, 0x235249}, /* East Asian ideograph */
  {"\xBF", 0, 0x23524D}, /* East Asian ideograph */
  {"\xBC", 0, 0x23524E}, /* East Asian ideograph */
  {"\xB9", 0, 0x235253}, /* East Asian ideograph */
  {"\xBD", 0, 0x235254}, /* East Asian ideograph */
  {"\x81", 0, 0x276075}, /* East Asian ideograph */
  {"\x86", 0, 0x276079}, /* East Asian ideograph */
  {"\x84", 0, 0x27607B}, /* East Asian ideograph */
  {"\x85", 0, 0x27607C}, /* East Asian ideograph */
  {"\x8F", 0, 0x27607E}, /* East Asian ideograph */
  {"\x8A", 0, 0x276121}, /* East Asian ideograph */
  {"\x92", 0, 0x276123}, /* East Asian ideograph */
  {"\x8B", 0, 0x276127}, /* East Asian ideograph */
  {"\x90", 0, 0x29516A}, /* East Asian ideograph */
  {"\x91", 0, 0x29516D}, /* East Asian ideograph */
  {"\x8D", 0, 0x295170}, /* East Asian ideograph */
  {"\x94", 0, 0x295172}, /* East Asian ideograph */
  {"\x93", 0, 0x295175}, /* East Asian ideograph */
  {"\x80", 0, 0x456076}, /* East Asian ideograph */
  {"\x88", 0, 0x516122}, /* East Asian ideograph */
  {"\x87", 0, 0x706247}, /* East Asian ideograph */
  {"\x95", 0, 0x70624E}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page306 = {
  marc8r_31page306_flat, 0
};
/* PAGE 305 */
struct yaz_iconv_trie_flat marc8r_31page305_flat[] = {
  {"\x85", 0, 0x216123}, /* East Asian ideograph */
  {"\x92", 0, 0x216124}, /* East Asian ideograph */
  {"\x91", 0, 0x216125}, /* East Asian ideograph */
  {"\x9C", 0, 0x216126}, /* East Asian ideograph */
  {"\x9E", 0, 0x216127}, /* East Asian ideograph */
  {"\x82", 0, 0x235154}, /* East Asian ideograph (variant of EACC 4D5154) */
  {"\x81", 0, 0x235161}, /* East Asian ideograph */
  {"\x80", 0, 0x235164}, /* East Asian ideograph */
  {"\x88", 0, 0x23516A}, /* East Asian ideograph */
  {"\x87", 0, 0x23516C}, /* East Asian ideograph */
  {"\x89", 0, 0x23516D}, /* East Asian ideograph */
  {"\x83", 0, 0x235170}, /* East Asian ideograph */
  {"\x8D", 0, 0x235171}, /* East Asian ideograph */
  {"\x8C", 0, 0x235172}, /* East Asian ideograph */
  {"\x8E", 0, 0x235173}, /* East Asian ideograph */
  {"\x90", 0, 0x235174}, /* East Asian ideograph */
  {"\x98", 0, 0x23517A}, /* East Asian ideograph */
  {"\x94", 0, 0x23517B}, /* East Asian ideograph */
  {"\x95", 0, 0x23517E}, /* East Asian ideograph */
  {"\x97", 0, 0x235222}, /* East Asian ideograph (variant of EACC 475222) */
  {"\x9D", 0, 0x235229}, /* East Asian ideograph */
  {"\x9F", 0, 0x23522B}, /* East Asian ideograph */
  {"\xA5", 0, 0x276065}, /* East Asian ideograph */
  {"\xA8", 0, 0x276067}, /* East Asian ideograph */
  {"\xAC", 0, 0x276068}, /* East Asian ideograph */
  {"\xAA", 0, 0x276069}, /* East Asian ideograph */
  {"\xAE", 0, 0x27606A}, /* East Asian ideograph */
  {"\xAD", 0, 0x27606B}, /* East Asian ideograph */
  {"\xB2", 0, 0x27606C}, /* East Asian ideograph */
  {"\xB4", 0, 0x27606D}, /* East Asian ideograph */
  {"\xB1", 0, 0x27606E}, /* East Asian ideograph */
  {"\xB0", 0, 0x27606F}, /* East Asian ideograph */
  {"\xBA", 0, 0x276070}, /* East Asian ideograph */
  {"\xB5", 0, 0x276072}, /* East Asian ideograph */
  {"\xB7", 0, 0x276073}, /* East Asian ideograph */
  {"\xBF", 0, 0x276077}, /* East Asian ideograph */
  {"\xBC", 0, 0x276078}, /* East Asian ideograph */
  {"\xAF", 0, 0x27607A}, /* East Asian ideograph */
  {"\xB6", 0, 0x276124}, /* East Asian ideograph */
  {"\xAB", 0, 0x29506C}, /* East Asian ideograph */
  {"\xBD", 0, 0x295132}, /* East Asian ideograph */
  {"\xA7", 0, 0x295153}, /* East Asian ideograph */
  {"\xA9", 0, 0x295166}, /* East Asian ideograph */
  {"\xA3", 0, 0x456064}, /* East Asian ideograph */
  {"\x8B", 0, 0x4B6122}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page305 = {
  marc8r_31page305_flat, 0
};
/* PAGE 304 */
struct yaz_iconv_trie_flat marc8r_31page304_flat[] = {
  {"\x83", 0, 0x216070}, /* East Asian ideograph */
  {"\x8A", 0, 0x216071}, /* East Asian ideograph */
  {"\x8C", 0, 0x216072}, /* East Asian ideograph */
  {"\x89", 0, 0x216073}, /* East Asian ideograph */
  {"\x90", 0, 0x216074}, /* East Asian ideograph */
  {"\x92", 0, 0x216075}, /* East Asian ideograph */
  {"\x98", 0, 0x216076}, /* East Asian ideograph */
  {"\x93", 0, 0x216077}, /* East Asian ideograph */
  {"\x85", 0, 0x216078}, /* East Asian ideograph */
  {"\xA8", 0, 0x216079}, /* East Asian ideograph */
  {"\x9E", 0, 0x21607A}, /* East Asian ideograph */
  {"\x9B", 0, 0x21607B}, /* East Asian ideograph */
  {"\xA1", 0, 0x21607C}, /* East Asian ideograph */
  {"\xB5", 0, 0x21607D}, /* East Asian ideograph */
  {"\xBE", 0, 0x21607E}, /* East Asian ideograph */
  {"\xBF", 0, 0x216121}, /* East Asian ideograph */
  {"\xBD", 0, 0x216122}, /* East Asian ideograph */
  {"\x87", 0, 0x235124}, /* East Asian ideograph */
  {"\x82", 0, 0x235128}, /* East Asian ideograph */
  {"\x96", 0, 0x23512F}, /* East Asian ideograph */
  {"\x94", 0, 0x235130}, /* East Asian ideograph */
  {"\x97", 0, 0x235131}, /* East Asian ideograph */
  {"\x91", 0, 0x235132}, /* East Asian ideograph */
  {"\x95", 0, 0x235138}, /* East Asian ideograph */
  {"\xA4", 0, 0x23513A}, /* East Asian ideograph */
  {"\x9F", 0, 0x23513B}, /* East Asian ideograph */
  {"\x9C", 0, 0x235140}, /* East Asian ideograph */
  {"\xA9", 0, 0x235143}, /* East Asian ideograph */
  {"\xA7", 0, 0x235145}, /* East Asian ideograph */
  {"\x9A", 0, 0x235147}, /* East Asian ideograph */
  {"\xAE", 0, 0x23514F}, /* East Asian ideograph */
  {"\xAC", 0, 0x235150}, /* East Asian ideograph */
  {"\xAA", 0, 0x235151}, /* East Asian ideograph */
  {"\xB3", 0, 0x235153}, /* East Asian ideograph */
  {"\xB2", 0, 0x235155}, /* East Asian ideograph */
  {"\xAB", 0, 0x235156}, /* East Asian ideograph */
  {"\xB1", 0, 0x235158}, /* East Asian ideograph */
  {"\xBB", 0, 0x23515C}, /* East Asian ideograph */
  {"\xBA", 0, 0x235160}, /* East Asian ideograph */
  {"\xBC", 0, 0x235166}, /* East Asian ideograph */
  {"\x8D", 0, 0x276126}, /* East Asian ideograph */
  {"\xA0", 0, 0x2D6078}, /* East Asian ideograph */
  {"\x88", 0, 0x2E6F43}, /* East Asian ideograph */
  {"\xB9", 0, 0x395063}, /* East Asian ideograph */
  {"\x9D", 0, 0x4B606F}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page304 = {
  marc8r_31page304_flat, 0
};
/* PAGE 303 */
struct yaz_iconv_trie_flat marc8r_31page303_flat[] = {
  {"\x84", 0, 0x216062}, /* East Asian ideograph */
  {"\x9B", 0, 0x216063}, /* East Asian ideograph */
  {"\x9F", 0, 0x216064}, /* East Asian ideograph */
  {"\xA2", 0, 0x216065}, /* East Asian ideograph */
  {"\xA7", 0, 0x216066}, /* East Asian ideograph */
  {"\xA9", 0, 0x216067}, /* East Asian ideograph */
  {"\xAD", 0, 0x216068}, /* East Asian ideograph */
  {"\xAA", 0, 0x216069}, /* East Asian ideograph */
  {"\xAE", 0, 0x21606A}, /* East Asian ideograph */
  {"\xAF", 0, 0x21606B}, /* East Asian ideograph */
  {"\xBC", 0, 0x21606C}, /* East Asian ideograph */
  {"\xB4", 0, 0x21606D}, /* East Asian ideograph */
  {"\xBD", 0, 0x21606E}, /* East Asian ideograph */
  {"\xBE", 0, 0x21606F}, /* East Asian ideograph */
  {"\x80", 0, 0x23504E}, /* East Asian ideograph */
  {"\x86", 0, 0x235053}, /* East Asian ideograph */
  {"\xA1", 0, 0x23505F}, /* East Asian ideograph */
  {"\xA3", 0, 0x235060}, /* East Asian ideograph */
  {"\xA4", 0, 0x235061}, /* East Asian ideograph */
  {"\xA5", 0, 0x235063}, /* East Asian ideograph */
  {"\xB1", 0, 0x235068}, /* East Asian ideograph */
  {"\xAB", 0, 0x23506C}, /* East Asian ideograph */
  {"\x8E", 0, 0x27605B}, /* East Asian ideograph */
  {"\x92", 0, 0x27605C}, /* East Asian ideograph */
  {"\x93", 0, 0x27605F}, /* East Asian ideograph */
  {"\x95", 0, 0x276061}, /* East Asian ideograph */
  {"\x98", 0, 0x276062}, /* East Asian ideograph */
  {"\x9E", 0, 0x276063}, /* East Asian ideograph */
  {"\x99", 0, 0x295053}, /* East Asian ideograph */
  {"\xA8", 0, 0x295222}, /* East Asian ideograph */
  {"\x9C", 0, 0x2D5259}, /* East Asian ideograph */
  {"\x83", 0, 0x336062}, /* East Asian ideograph */
  {"\x88", 0, 0x355053}, /* East Asian ideograph */
  {"\xB0", 0, 0x45606B}, /* East Asian ideograph */
  {"\x91", 0, 0x4D503A}, /* East Asian ideograph */
  {"\x9A", 0, 0x4D5053}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page303 = {
  marc8r_31page303_flat, 0
};
/* PAGE 302 */
struct yaz_iconv_trie_flat marc8r_31page302_flat[] = {
  {"\xA8", 0, 0x21605B}, /* East Asian ideograph */
  {"\xAF", 0, 0x21605C}, /* East Asian ideograph */
  {"\xB1", 0, 0x21605D}, /* East Asian ideograph */
  {"\xB3", 0, 0x21605E}, /* East Asian ideograph */
  {"\xB6", 0, 0x21605F}, /* East Asian ideograph */
  {"\xBA", 0, 0x216060}, /* East Asian ideograph */
  {"\xBC", 0, 0x216061}, /* East Asian ideograph */
  {"\xAD", 0, 0x235039}, /* East Asian ideograph */
  {"\xB4", 0, 0x235040}, /* East Asian ideograph */
  {"\xB8", 0, 0x235048}, /* East Asian ideograph */
  {"\xBF", 0, 0x23504A}, /* East Asian ideograph */
  {"\xBB", 0, 0x23504D}, /* East Asian ideograph */
  {"\x84", 0, 0x27603D}, /* East Asian ideograph */
  {"\x81", 0, 0x276041}, /* East Asian ideograph */
  {"\x82", 0, 0x276042}, /* East Asian ideograph */
  {"\x87", 0, 0x276043}, /* East Asian ideograph */
  {"\x86", 0, 0x276044}, /* East Asian ideograph */
  {"\x89", 0, 0x276045}, /* East Asian ideograph */
  {"\x8A", 0, 0x276047}, /* East Asian ideograph */
  {"\x88", 0, 0x276048}, /* East Asian ideograph */
  {"\x91", 0, 0x276049}, /* East Asian ideograph */
  {"\x93", 0, 0x27604A}, /* East Asian ideograph */
  {"\x94", 0, 0x27604B}, /* East Asian ideograph */
  {"\x90", 0, 0x27604C}, /* East Asian ideograph */
  {"\x97", 0, 0x27604D}, /* East Asian ideograph */
  {"\x9C", 0, 0x27604E}, /* East Asian ideograph */
  {"\x9D", 0, 0x27604F}, /* East Asian ideograph */
  {"\x98", 0, 0x276050}, /* East Asian ideograph */
  {"\x9A", 0, 0x276051}, /* East Asian ideograph */
  {"\x9B", 0, 0x276052}, /* East Asian ideograph */
  {"\xA0", 0, 0x276054}, /* East Asian ideograph */
  {"\xA4", 0, 0x276057}, /* East Asian ideograph */
  {"\x85", 0, 0x276059}, /* East Asian ideograph */
  {"\xA6", 0, 0x27605A}, /* East Asian ideograph */
  {"\x8D", 0, 0x284C62}, /* East Asian ideograph */
  {"\x83", 0, 0x294E7B}, /* East Asian ideograph */
  {"\x80", 0, 0x294F23}, /* East Asian ideograph */
  {"\x8F", 0, 0x294F2C}, /* East Asian ideograph */
  {"\xA1", 0, 0x294F6B}, /* East Asian ideograph */
  {"\x9F", 0, 0x294F77}, /* East Asian ideograph */
  {"\xA2", 0, 0x295021}, /* East Asian ideograph */
  {"\xA5", 0, 0x295029}, /* East Asian ideograph */
  {"\x9E", 0, 0x295030}, /* East Asian ideograph */
  {"\xA7", 0, 0x295031}, /* East Asian ideograph */
  {"\x96", 0, 0x454F45}, /* East Asian ideograph */
  {"\x8C", 0, 0x4D4F39}, /* East Asian ideograph */
  {"\xAA", 0, 0x697124}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page302 = {
  marc8r_31page302_flat, 0
};
/* PAGE 301 */
struct yaz_iconv_trie_flat marc8r_31page301_flat[] = {
  {"\x86", 0, 0x21604D}, /* East Asian ideograph */
  {"\x94", 0, 0x21604E}, /* East Asian ideograph */
  {"\x8D", 0, 0x21604F}, /* East Asian ideograph */
  {"\x8C", 0, 0x216050}, /* East Asian ideograph */
  {"\x8E", 0, 0x216051}, /* East Asian ideograph */
  {"\x93", 0, 0x216052}, /* East Asian ideograph */
  {"\x9E", 0, 0x216053}, /* East Asian ideograph (variant of EACC 4B6053) */
  {"\x9A", 0, 0x216054}, /* East Asian ideograph */
  {"\x98", 0, 0x216055}, /* East Asian ideograph */
  {"\xA7", 0, 0x216056}, /* East Asian ideograph */
  {"\xAB", 0, 0x216057}, /* East Asian ideograph */
  {"\xAF", 0, 0x216058}, /* East Asian ideograph */
  {"\xB1", 0, 0x216059}, /* East Asian ideograph */
  {"\xB0", 0, 0x21605A}, /* East Asian ideograph */
  {"\x87", 0, 0x234F4B}, /* East Asian ideograph */
  {"\x84", 0, 0x234F4E}, /* East Asian ideograph */
  {"\x92", 0, 0x234F60}, /* East Asian ideograph */
  {"\x8B", 0, 0x234F62}, /* East Asian ideograph */
  {"\x9C", 0, 0x234F6A}, /* East Asian ideograph */
  {"\x99", 0, 0x234F6B}, /* East Asian ideograph */
  {"\x97", 0, 0x234F6F}, /* East Asian ideograph */
  {"\x96", 0, 0x234F72}, /* East Asian ideograph */
  {"\xA2", 0, 0x234F77}, /* East Asian ideograph */
  {"\xA8", 0, 0x234F7E}, /* East Asian ideograph */
  {"\xA5", 0, 0x235021}, /* East Asian ideograph */
  {"\xA6", 0, 0x235022}, /* East Asian ideograph */
  {"\xAC", 0, 0x235029}, /* East Asian ideograph */
  {"\xB3", 0, 0x235030}, /* East Asian ideograph */
  {"\xB4", 0, 0x235031}, /* East Asian ideograph */
  {"\xB5", 0, 0x276037}, /* East Asian ideograph */
  {"\xB6", 0, 0x276038}, /* East Asian ideograph */
  {"\xB7", 0, 0x276039}, /* East Asian ideograph */
  {"\xB9", 0, 0x27603A}, /* East Asian ideograph */
  {"\xBA", 0, 0x27603B}, /* East Asian ideograph */
  {"\xBB", 0, 0x27603C}, /* East Asian ideograph */
  {"\xBC", 0, 0x27603E}, /* East Asian ideograph */
  {"\xBD", 0, 0x27603F}, /* East Asian ideograph */
  {"\xBF", 0, 0x276040}, /* East Asian ideograph */
  {"\xBE", 0, 0x276056}, /* East Asian ideograph */
  {"\xB8", 0, 0x294E79}, /* East Asian ideograph */
  {"\x9B", 0, 0x336054}, /* East Asian ideograph */
  {"\x95", 0, 0x336058}, /* East Asian ideograph */
  {"\x8F", 0, 0x45604E}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page301 = {
  marc8r_31page301_flat, 0
};
/* PAGE 300 */
struct yaz_iconv_trie_flat marc8r_31page300_flat[] = {
  {"\x81", 0, 0x216037}, /* East Asian ideograph */
  {"\x82", 0, 0x216038}, /* East Asian ideograph */
  {"\x83", 0, 0x216039}, /* East Asian ideograph */
  {"\x85", 0, 0x21603A}, /* East Asian ideograph */
  {"\x86", 0, 0x21603B}, /* East Asian ideograph */
  {"\x88", 0, 0x21603C}, /* East Asian ideograph */
  {"\x90", 0, 0x21603D}, /* East Asian ideograph */
  {"\x8A", 0, 0x21603E}, /* East Asian ideograph */
  {"\x91", 0, 0x21603F}, /* East Asian ideograph */
  {"\x93", 0, 0x216040}, /* East Asian ideograph */
  {"\x92", 0, 0x216041}, /* East Asian ideograph */
  {"\x8C", 0, 0x216042}, /* East Asian ideograph */
  {"\x97", 0, 0x216043}, /* East Asian ideograph */
  {"\x98", 0, 0x216044}, /* East Asian ideograph (variant of EACC 4B6044) */
  {"\xA1", 0, 0x216045}, /* East Asian ideograph */
  {"\xAD", 0, 0x216046}, /* East Asian ideograph */
  {"\xB0", 0, 0x216047}, /* East Asian ideograph */
  {"\xB8", 0, 0x216048}, /* East Asian ideograph */
  {"\xBB", 0, 0x216049}, /* East Asian ideograph */
  {"\xB9", 0, 0x21604A}, /* East Asian ideograph */
  {"\xB7", 0, 0x21604B}, /* East Asian ideograph */
  {"\xA4", 0, 0x21604C}, /* East Asian ideograph */
  {"\x87", 0, 0x234E79}, /* East Asian ideograph */
  {"\x8F", 0, 0x234E7B}, /* East Asian ideograph */
  {"\x8D", 0, 0x234E7E}, /* East Asian ideograph */
  {"\x8E", 0, 0x234F23}, /* East Asian ideograph */
  {"\x96", 0, 0x234F26}, /* East Asian ideograph */
  {"\xA6", 0, 0x234F2C}, /* East Asian ideograph */
  {"\x9E", 0, 0x234F2D}, /* East Asian ideograph */
  {"\xAB", 0, 0x234F34}, /* East Asian ideograph */
  {"\xA0", 0, 0x234F37}, /* East Asian ideograph */
  {"\x9F", 0, 0x234F38}, /* East Asian ideograph */
  {"\xB3", 0, 0x234F3D}, /* East Asian ideograph */
  {"\xAE", 0, 0x234F40}, /* East Asian ideograph */
  {"\xAF", 0, 0x234F44}, /* East Asian ideograph */
  {"\xB2", 0, 0x234F45}, /* East Asian ideograph */
  {"\xBF", 0, 0x234F66}, /* East Asian ideograph */
  {"\xB4", 0, 0x2D4F45}, /* East Asian ideograph */
  {"\x8B", 0, 0x2D6056}, /* East Asian ideograph */
  {"\x80", 0, 0x2E4E56}, /* East Asian ideograph */
  {"\xBC", 0, 0x395A36}, /* East Asian ideograph */
  {"\x9A", 0, 0x4B6048}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page300 = {
  marc8r_31page300_flat, 0
};
/* PAGE 299 */
struct yaz_iconv_trie_flat marc8r_31page299_flat[] = {
  {"\x83", 0, 0x216029}, /* East Asian ideograph */
  {"\x81", 0, 0x21602A}, /* East Asian ideograph */
  {"\x86", 0, 0x21602B}, /* East Asian ideograph */
  {"\x8B", 0, 0x21602C}, /* East Asian ideograph */
  {"\x8C", 0, 0x21602D}, /* East Asian ideograph */
  {"\x93", 0, 0x21602E}, /* East Asian ideograph */
  {"\x9C", 0, 0x21602F}, /* East Asian ideograph */
  {"\xAD", 0, 0x216030}, /* East Asian ideograph */
  {"\xB3", 0, 0x216031}, /* East Asian ideograph */
  {"\xB6", 0, 0x216034}, /* East Asian ideograph */
  {"\xBB", 0, 0x216035}, /* East Asian ideograph */
  {"\xBF", 0, 0x216036}, /* East Asian ideograph (variant of EACC 456036) */
  {"\xAF", 0, 0x222F69}, /* East Asian ideograph */
  {"\x80", 0, 0x234E38}, /* East Asian ideograph */
  {"\x85", 0, 0x234E3B}, /* East Asian ideograph */
  {"\x89", 0, 0x234E43}, /* East Asian ideograph */
  {"\x8E", 0, 0x234E4B}, /* East Asian ideograph */
  {"\x8D", 0, 0x234E4C}, /* East Asian ideograph */
  {"\x90", 0, 0x234E4E}, /* East Asian ideograph */
  {"\x94", 0, 0x234E51}, /* East Asian ideograph */
  {"\x98", 0, 0x234E53}, /* East Asian ideograph */
  {"\x99", 0, 0x234E54}, /* East Asian ideograph */
  {"\x9D", 0, 0x234E59}, /* East Asian ideograph */
  {"\x9E", 0, 0x234E5C}, /* East Asian ideograph */
  {"\xA0", 0, 0x234E5E}, /* East Asian ideograph */
  {"\xA1", 0, 0x234E60}, /* East Asian ideograph */
  {"\xB5", 0, 0x234E6C}, /* East Asian ideograph */
  {"\xBA", 0, 0x234E73}, /* East Asian ideograph */
  {"\xA6", 0, 0x27602C}, /* East Asian ideograph */
  {"\xA7", 0, 0x27602D}, /* East Asian ideograph */
  {"\xA9", 0, 0x27602E}, /* East Asian ideograph */
  {"\xAC", 0, 0x27602F}, /* East Asian ideograph */
  {"\xAA", 0, 0x294E54}, /* East Asian ideograph */
  {"\xAB", 0, 0x294E5C}, /* East Asian ideograph */
  {"\xAE", 0, 0x2D6030}, /* East Asian ideograph */
  {"\x88", 0, 0x335821}, /* East Asian ideograph */
  {"\xA4", 0, 0x395821}, /* East Asian ideograph */
  {"\xB2", 0, 0x4D5F7B}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page299 = {
  marc8r_31page299_flat, 0
};
/* PAGE 298 */
struct yaz_iconv_trie_flat marc8r_31page298_flat[] = {
  {"\x85", 0, 0x215F7E}, /* East Asian ideograph */
  {"\x8D", 0, 0x216021}, /* East Asian ideograph */
  {"\x8B", 0, 0x216022}, /* East Asian ideograph */
  {"\x8F", 0, 0x216023}, /* East Asian ideograph */
  {"\x98", 0, 0x216024}, /* East Asian ideograph */
  {"\xA0", 0, 0x216025}, /* East Asian ideograph */
  {"\xA3", 0, 0x216026}, /* East Asian ideograph */
  {"\xA6", 0, 0x216027}, /* East Asian ideograph */
  {"\xAD", 0, 0x216028}, /* East Asian ideograph */
  {"\x97", 0, 0x216879}, /* East Asian ideograph */
  {"\x83", 0, 0x234D37}, /* East Asian ideograph */
  {"\x80", 0, 0x234D3A}, /* East Asian ideograph */
  {"\x81", 0, 0x234D3C}, /* East Asian ideograph */
  {"\x84", 0, 0x234D40}, /* East Asian ideograph */
  {"\x89", 0, 0x234D49}, /* East Asian ideograph */
  {"\x94", 0, 0x234D54}, /* East Asian ideograph */
  {"\x9B", 0, 0x234D59}, /* East Asian ideograph */
  {"\x9F", 0, 0x234D5A}, /* East Asian ideograph */
  {"\x9A", 0, 0x234D5C}, /* East Asian ideograph */
  {"\x9C", 0, 0x234D62}, /* East Asian ideograph */
  {"\xAC", 0, 0x234D6A}, /* East Asian ideograph */
  {"\xAE", 0, 0x234D70}, /* East Asian ideograph */
  {"\xA8", 0, 0x234D71}, /* East Asian ideograph */
  {"\xAB", 0, 0x234D74}, /* East Asian ideograph */
  {"\xA5", 0, 0x234D78}, /* East Asian ideograph */
  {"\xB2", 0, 0x234D7A}, /* East Asian ideograph */
  {"\xB4", 0, 0x234D7C}, /* East Asian ideograph */
  {"\xB3", 0, 0x234E24}, /* East Asian ideograph */
  {"\xB5", 0, 0x234E26}, /* East Asian ideograph */
  {"\xB9", 0, 0x234E29}, /* East Asian ideograph */
  {"\xB8", 0, 0x234E2D}, /* East Asian ideograph */
  {"\xBE", 0, 0x234E35}, /* East Asian ideograph */
  {"\x91", 0, 0x276029}, /* East Asian ideograph */
  {"\xAF", 0, 0x294E43}, /* East Asian ideograph */
  {"\x8C", 0, 0x2D6021}, /* East Asian ideograph */
  {"\x92", 0, 0x4B4559}, /* East Asian ideograph */
  {"\x86", 0, 0x69705D}, /* East Asian ideograph */
  {"\x90", 0, 0x697060}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page298 = {
  marc8r_31page298_flat, 0
};
/* PAGE 297 */
struct yaz_iconv_trie_flat marc8r_31page297_flat[] = {
  {"\x84", 0, 0x215F6D}, /* East Asian ideograph */
  {"\x82", 0, 0x215F6E}, /* East Asian ideograph */
  {"\x88", 0, 0x215F6F}, /* East Asian ideograph */
  {"\x91", 0, 0x215F70}, /* East Asian ideograph */
  {"\x96", 0, 0x215F71}, /* East Asian ideograph (variant of EACC 4B5F71) */
  {"\x9B", 0, 0x215F72}, /* East Asian ideograph (variant of EACC 4B5F72) */
  {"\x9C", 0, 0x215F73}, /* East Asian ideograph */
  {"\x9E", 0, 0x215F74}, /* East Asian ideograph */
  {"\xA0", 0, 0x215F75}, /* East Asian ideograph */
  {"\xA1", 0, 0x215F76}, /* East Asian ideograph */
  {"\xA6", 0, 0x215F78}, /* East Asian ideograph */
  {"\xA8", 0, 0x215F79}, /* East Asian ideograph */
  {"\xA9", 0, 0x215F7A}, /* East Asian ideograph */
  {"\xB6", 0, 0x215F7B}, /* East Asian ideograph */
  {"\xB4", 0, 0x215F7C}, /* East Asian ideograph */
  {"\xBC", 0, 0x215F7D}, /* East Asian ideograph */
  {"\x81", 0, 0x234C6A}, /* East Asian ideograph */
  {"\x87", 0, 0x234C6B}, /* East Asian ideograph */
  {"\x86", 0, 0x234C6C}, /* East Asian ideograph */
  {"\x89", 0, 0x234C6E}, /* East Asian ideograph */
  {"\x98", 0, 0x234C75}, /* East Asian ideograph */
  {"\x9A", 0, 0x234C76}, /* East Asian ideograph */
  {"\x9D", 0, 0x234C78}, /* East Asian ideograph */
  {"\x9F", 0, 0x234C7B}, /* East Asian ideograph */
  {"\xA4", 0, 0x234C7D}, /* East Asian ideograph */
  {"\xA7", 0, 0x234D25}, /* East Asian ideograph */
  {"\xAB", 0, 0x234D2C}, /* East Asian ideograph */
  {"\xAE", 0, 0x234D30}, /* East Asian ideograph */
  {"\xB7", 0, 0x234D31}, /* East Asian ideograph */
  {"\xB8", 0, 0x234D32}, /* East Asian ideograph */
  {"\xB3", 0, 0x234D35}, /* East Asian ideograph */
  {"\xBA", 0, 0x234D38}, /* East Asian ideograph */
  {"\xBF", 0, 0x234D43}, /* East Asian ideograph */
  {"\xA5", 0, 0x275F79}, /* East Asian ideograph */
  {"\xA2", 0, 0x27625E}, /* East Asian ideograph */
  {"\x93", 0, 0x294C76}, /* East Asian ideograph */
  {"\xAD", 0, 0x2D602D}, /* East Asian ideograph */
  {"\x99", 0, 0x335F73}, /* East Asian ideograph */
  {"\x92", 0, 0x4B5F70}, /* East Asian ideograph */
  {"\xB1", 0, 0x4B602D}, /* East Asian ideograph */
  {"\xB9", 0, 0x697058}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page297 = {
  marc8r_31page297_flat, 0
};
/* PAGE 296 */
struct yaz_iconv_trie_flat marc8r_31page296_flat[] = {
  {"\x80", 0, 0x215F59}, /* East Asian ideograph */
  {"\x87", 0, 0x215F5A}, /* East Asian ideograph */
  {"\x84", 0, 0x215F5B}, /* East Asian ideograph */
  {"\x89", 0, 0x215F5C}, /* East Asian ideograph */
  {"\x86", 0, 0x215F5D}, /* East Asian ideograph */
  {"\x91", 0, 0x215F5E}, /* East Asian ideograph */
  {"\x8E", 0, 0x215F5F}, /* East Asian ideograph */
  {"\x96", 0, 0x215F60}, /* East Asian ideograph */
  {"\x8F", 0, 0x215F61}, /* East Asian ideograph */
  {"\x8D", 0, 0x215F62}, /* East Asian ideograph */
  {"\x93", 0, 0x215F63}, /* East Asian ideograph */
  {"\x9C", 0, 0x215F64}, /* East Asian ideograph */
  {"\x9E", 0, 0x215F65}, /* East Asian ideograph */
  {"\xAA", 0, 0x215F66}, /* East Asian ideograph */
  {"\xA7", 0, 0x215F67}, /* East Asian ideograph */
  {"\xB8", 0, 0x215F68}, /* East Asian ideograph */
  {"\xB9", 0, 0x215F69}, /* East Asian ideograph */
  {"\xB2", 0, 0x215F6A}, /* East Asian ideograph */
  {"\xBD", 0, 0x215F6B}, /* East Asian ideograph */
  {"\xBE", 0, 0x215F6C}, /* East Asian ideograph */
  {"\x82", 0, 0x234C27}, /* East Asian ideograph */
  {"\x88", 0, 0x234C29}, /* East Asian ideograph */
  {"\x85", 0, 0x234C2A}, /* East Asian ideograph */
  {"\x9B", 0, 0x234C38}, /* East Asian ideograph */
  {"\x9D", 0, 0x234C3D}, /* East Asian ideograph */
  {"\x99", 0, 0x234C3E}, /* East Asian ideograph */
  {"\xA3", 0, 0x234C47}, /* East Asian ideograph */
  {"\xA2", 0, 0x234C49}, /* East Asian ideograph */
  {"\xA4", 0, 0x234C4A}, /* East Asian ideograph */
  {"\xA8", 0, 0x234C4E}, /* East Asian ideograph */
  {"\xA6", 0, 0x234C50}, /* East Asian ideograph */
  {"\xB1", 0, 0x234C52}, /* East Asian ideograph */
  {"\xB0", 0, 0x234C58}, /* East Asian ideograph */
  {"\xB6", 0, 0x234C5C}, /* East Asian ideograph */
  {"\x81", 0, 0x275F6B}, /* East Asian ideograph */
  {"\xAD", 0, 0x275F6D}, /* East Asian ideograph */
  {"\x8A", 0, 0x4B5F6F}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page296 = {
  marc8r_31page296_flat, 0
};
/* PAGE 295 */
struct yaz_iconv_trie_flat marc8r_31page295_flat[] = {
  {"\x80", 0, 0x215F3F}, /* East Asian ideograph */
  {"\x87", 0, 0x215F40}, /* East Asian ideograph */
  {"\x86", 0, 0x215F41}, /* East Asian ideograph */
  {"\x84", 0, 0x215F42}, /* East Asian ideograph */
  {"\x81", 0, 0x215F43}, /* East Asian ideograph */
  {"\x85", 0, 0x215F44}, /* East Asian ideograph */
  {"\x8D", 0, 0x215F45}, /* East Asian ideograph */
  {"\x8B", 0, 0x215F46}, /* East Asian ideograph */
  {"\x89", 0, 0x215F47}, /* East Asian ideograph */
  {"\x8C", 0, 0x215F48}, /* East Asian ideograph */
  {"\x95", 0, 0x215F49}, /* East Asian ideograph */
  {"\x96", 0, 0x215F4A}, /* East Asian ideograph */
  {"\x9C", 0, 0x215F4B}, /* East Asian ideograph */
  {"\x9E", 0, 0x215F4C}, /* East Asian ideograph */
  {"\x9B", 0, 0x215F4D}, /* East Asian ideograph */
  {"\x99", 0, 0x215F4E}, /* East Asian ideograph */
  {"\xA2", 0, 0x215F4F}, /* East Asian ideograph */
  {"\xA3", 0, 0x215F50}, /* East Asian ideograph (variant of EACC 4B5F50) */
  {"\xA8", 0, 0x215F51}, /* East Asian ideograph */
  {"\xAA", 0, 0x215F52}, /* East Asian ideograph */
  {"\xAF", 0, 0x215F53}, /* East Asian ideograph */
  {"\xB2", 0, 0x215F54}, /* East Asian ideograph */
  {"\xBB", 0, 0x215F55}, /* East Asian ideograph */
  {"\xB7", 0, 0x215F56}, /* East Asian ideograph */
  {"\xB9", 0, 0x215F57}, /* East Asian ideograph */
  {"\xB6", 0, 0x215F58}, /* East Asian ideograph */
  {"\x8E", 0, 0x234B52}, /* East Asian ideograph */
  {"\x8A", 0, 0x234B53}, /* East Asian ideograph */
  {"\x92", 0, 0x234B57}, /* East Asian ideograph */
  {"\x9F", 0, 0x234B64}, /* East Asian ideograph */
  {"\x98", 0, 0x234B66}, /* East Asian ideograph */
  {"\x9D", 0, 0x234B67}, /* East Asian ideograph */
  {"\xA9", 0, 0x234B71}, /* East Asian ideograph */
  {"\xB1", 0, 0x234B74}, /* East Asian ideograph */
  {"\xB0", 0, 0x234B76}, /* East Asian ideograph */
  {"\xB4", 0, 0x234B77}, /* East Asian ideograph */
  {"\xBA", 0, 0x234B78}, /* East Asian ideograph */
  {"\xB5", 0, 0x234B7A}, /* East Asian ideograph */
  {"\xBF", 0, 0x234C22}, /* East Asian ideograph */
  {"\x8F", 0, 0x275F4D}, /* East Asian ideograph */
  {"\xBE", 0, 0x275F67}, /* East Asian ideograph */
  {"\xB3", 0, 0x275F6E}, /* East Asian ideograph */
  {"\x91", 0, 0x2D5F4B}, /* East Asian ideograph */
  {"\xA0", 0, 0x4B306C}, /* East Asian ideograph */
  {"\xAB", 0, 0x693C36}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page295 = {
  marc8r_31page295_flat, 0
};
/* PAGE 294 */
struct yaz_iconv_trie_flat marc8r_31page294_flat[] = {
  {"\x8A", 0, 0x215F2B}, /* East Asian ideograph */
  {"\x8E", 0, 0x215F2C}, /* East Asian ideograph */
  {"\x8B", 0, 0x215F2D}, /* East Asian ideograph */
  {"\x85", 0, 0x215F2F}, /* East Asian ideograph */
  {"\x86", 0, 0x215F30}, /* East Asian ideograph */
  {"\x8D", 0, 0x215F31}, /* East Asian ideograph */
  {"\x98", 0, 0x215F32}, /* East Asian ideograph */
  {"\x94", 0, 0x215F33}, /* East Asian ideograph */
  {"\x99", 0, 0x215F34}, /* East Asian ideograph */
  {"\x95", 0, 0x215F35}, /* East Asian ideograph */
  {"\x9C", 0, 0x215F36}, /* East Asian ideograph */
  {"\x9B", 0, 0x215F37}, /* East Asian ideograph */
  {"\xA7", 0, 0x215F38}, /* East Asian ideograph */
  {"\xA8", 0, 0x215F39}, /* East Asian ideograph */
  {"\xAA", 0, 0x215F3A}, /* East Asian ideograph */
  {"\xB1", 0, 0x215F3B}, /* East Asian ideograph */
  {"\xB4", 0, 0x215F3C}, /* East Asian ideograph */
  {"\xB8", 0, 0x215F3D}, /* East Asian ideograph */
  {"\xBB", 0, 0x215F3E}, /* East Asian ideograph */
  {"\x84", 0, 0x234A63}, /* East Asian ideograph */
  {"\x88", 0, 0x234A65}, /* East Asian ideograph */
  {"\x89", 0, 0x234A6C}, /* East Asian ideograph */
  {"\x82", 0, 0x234A6D}, /* East Asian ideograph */
  {"\x83", 0, 0x234A6E}, /* East Asian ideograph */
  {"\x96", 0, 0x234A79}, /* East Asian ideograph */
  {"\x97", 0, 0x234A7A}, /* East Asian ideograph */
  {"\xA4", 0, 0x234B2F}, /* East Asian ideograph */
  {"\xA9", 0, 0x234B35}, /* East Asian ideograph */
  {"\xAE", 0, 0x234B37}, /* East Asian ideograph */
  {"\xB0", 0, 0x234B3B}, /* East Asian ideograph */
  {"\xB2", 0, 0x234B3C}, /* East Asian ideograph */
  {"\xB3", 0, 0x234B3E}, /* East Asian ideograph */
  {"\xB9", 0, 0x234B48}, /* East Asian ideograph */
  {"\xBC", 0, 0x234B49}, /* East Asian ideograph */
  {"\x8F", 0, 0x275F39}, /* East Asian ideograph */
  {"\x90", 0, 0x275F3B}, /* East Asian ideograph */
  {"\xB6", 0, 0x275F3D}, /* East Asian ideograph */
  {"\xBE", 0, 0x275F50}, /* East Asian ideograph */
  {"\xA3", 0, 0x2D5C74}, /* East Asian ideograph */
  {"\xA0", 0, 0x2D5F3B}, /* East Asian ideograph */
  {"\xBD", 0, 0x2D5F46}, /* East Asian ideograph */
  {"\xB7", 0, 0x335F3D}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page294 = {
  marc8r_31page294_flat, 0
};
/* PAGE 293 */
struct yaz_iconv_trie_flat marc8r_31page293_flat[] = {
  {"\x80", 0, 0x215E72}, /* East Asian ideograph */
  {"\x84", 0, 0x215E75}, /* East Asian ideograph */
  {"\x90", 0, 0x215E76}, /* East Asian ideograph */
  {"\x8C", 0, 0x215E77}, /* East Asian ideograph */
  {"\x8B", 0, 0x215E78}, /* East Asian ideograph */
  {"\x8D", 0, 0x215E79}, /* East Asian ideograph */
  {"\xA2", 0, 0x215E7A}, /* East Asian ideograph */
  {"\xA3", 0, 0x215E7B}, /* East Asian ideograph */
  {"\x9B", 0, 0x215E7C}, /* East Asian ideograph */
  {"\xA1", 0, 0x215E7D}, /* East Asian ideograph */
  {"\x9D", 0, 0x215E7E}, /* East Asian ideograph */
  {"\xA4", 0, 0x215F21}, /* East Asian ideograph */
  {"\xAA", 0, 0x215F22}, /* East Asian ideograph */
  {"\xB3", 0, 0x215F23}, /* East Asian ideograph */
  {"\xB8", 0, 0x215F24}, /* East Asian ideograph */
  {"\xB5", 0, 0x215F25}, /* East Asian ideograph */
  {"\xB2", 0, 0x215F26}, /* East Asian ideograph */
  {"\xB6", 0, 0x215F27}, /* East Asian ideograph */
  {"\xB7", 0, 0x215F28}, /* East Asian ideograph */
  {"\xB4", 0, 0x215F29}, /* East Asian ideograph */
  {"\xB0", 0, 0x215F2A}, /* East Asian ideograph */
  {"\xBD", 0, 0x215F2E}, /* East Asian ideograph */
  {"\x82", 0, 0x234A2F}, /* East Asian ideograph */
  {"\x91", 0, 0x234A3C}, /* East Asian ideograph */
  {"\xA0", 0, 0x234A42}, /* East Asian ideograph */
  {"\x9C", 0, 0x234A44}, /* East Asian ideograph */
  {"\x98", 0, 0x234A46}, /* East Asian ideograph */
  {"\x9F", 0, 0x234A4A}, /* East Asian ideograph */
  {"\x96", 0, 0x234A4B}, /* East Asian ideograph */
  {"\xAC", 0, 0x234A51}, /* East Asian ideograph */
  {"\xBB", 0, 0x234A5D}, /* East Asian ideograph */
  {"\xBF", 0, 0x234A5E}, /* East Asian ideograph */
  {"\xBE", 0, 0x234A62}, /* East Asian ideograph */
  {"\x88", 0, 0x275F23}, /* East Asian ideograph */
  {"\x86", 0, 0x275F24}, /* East Asian ideograph */
  {"\x85", 0, 0x275F37}, /* East Asian ideograph */
  {"\xA9", 0, 0x275F3A}, /* East Asian ideograph */
  {"\x87", 0, 0x275F3C}, /* East Asian ideograph */
  {"\x95", 0, 0x294A44}, /* East Asian ideograph */
  {"\x89", 0, 0x294A46}, /* East Asian ideograph */
  {"\xA5", 0, 0x2D5F28}, /* East Asian ideograph */
  {"\x8F", 0, 0x2D5F2D}, /* East Asian ideograph */
  {"\x94", 0, 0x2D753A}, /* East Asian ideograph */
  {"\x9E", 0, 0x39345B}, /* East Asian ideograph */
  {"\xA8", 0, 0x455F35}, /* East Asian ideograph (Version J extension) */
  {"\xBA", 0, 0x4B5F3A}, /* East Asian ideograph */
  {"\xA7", 0, 0x4D4A6C}, /* East Asian ideograph */
  {"\xA6", 0, 0x697023}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page293 = {
  marc8r_31page293_flat, 0
};
/* PAGE 292 */
struct yaz_iconv_trie_flat marc8r_31page292_flat[] = {
  {"\x9C", 0, 0x215E6C}, /* East Asian ideograph */
  {"\xA1", 0, 0x215E6D}, /* East Asian ideograph */
  {"\xB2", 0, 0x215E6E}, /* East Asian ideograph */
  {"\xB1", 0, 0x215E6F}, /* East Asian ideograph */
  {"\xAE", 0, 0x215E70}, /* East Asian ideograph */
  {"\xAA", 0, 0x215E71}, /* East Asian ideograph */
  {"\xBF", 0, 0x215E73}, /* East Asian ideograph */
  {"\xBB", 0, 0x215E74}, /* East Asian ideograph */
  {"\x9E", 0, 0x23497A}, /* East Asian ideograph */
  {"\xA4", 0, 0x23497B}, /* East Asian ideograph */
  {"\xA2", 0, 0x23497C}, /* East Asian ideograph */
  {"\xA7", 0, 0x234A21}, /* East Asian ideograph */
  {"\xBD", 0, 0x234A30}, /* East Asian ideograph */
  {"\xBC", 0, 0x234A32}, /* East Asian ideograph */
  {"\x82", 0, 0x275E58}, /* East Asian ideograph */
  {"\x81", 0, 0x275E5B}, /* East Asian ideograph */
  {"\x80", 0, 0x275E5C}, /* East Asian ideograph */
  {"\x85", 0, 0x275E5E}, /* East Asian ideograph */
  {"\x8E", 0, 0x275E60}, /* East Asian ideograph */
  {"\x94", 0, 0x275E61}, /* East Asian ideograph */
  {"\x95", 0, 0x275E62}, /* East Asian ideograph */
  {"\x91", 0, 0x275E63}, /* East Asian ideograph */
  {"\x97", 0, 0x275E68}, /* East Asian ideograph */
  {"\x90", 0, 0x275E6A}, /* East Asian ideograph */
  {"\xB5", 0, 0x275E7B}, /* East Asian ideograph */
  {"\xB4", 0, 0x275F2A}, /* East Asian ideograph */
  {"\x9F", 0, 0x275F2B}, /* East Asian ideograph */
  {"\xB6", 0, 0x275F2C}, /* East Asian ideograph */
  {"\xB3", 0, 0x275F2E}, /* East Asian ideograph */
  {"\x86", 0, 0x294942}, /* East Asian ideograph */
  {"\x83", 0, 0x294944}, /* East Asian ideograph */
  {"\x8F", 0, 0x294948}, /* East Asian ideograph */
  {"\x88", 0, 0x294949}, /* East Asian ideograph */
  {"\x89", 0, 0x29494D}, /* East Asian ideograph */
  {"\x8A", 0, 0x29494F}, /* East Asian ideograph */
  {"\x8C", 0, 0x294950}, /* East Asian ideograph */
  {"\x8D", 0, 0x294952}, /* East Asian ideograph */
  {"\x92", 0, 0x29495A}, /* East Asian ideograph */
  {"\x99", 0, 0x294960}, /* East Asian ideograph */
  {"\x9A", 0, 0x294969}, /* East Asian ideograph */
  {"\x8B", 0, 0x29556C}, /* East Asian ideograph */
  {"\x84", 0, 0x295574}, /* East Asian ideograph */
  {"\xAC", 0, 0x2D377C}, /* East Asian ideograph */
  {"\xAF", 0, 0x2D3821}, /* East Asian ideograph */
  {"\xA8", 0, 0x333475}, /* East Asian ideograph */
  {"\x9D", 0, 0x4B5C5E}, /* East Asian ideograph */
  {"\x96", 0, 0x515E5D}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page292 = {
  marc8r_31page292_flat, 0
};
/* PAGE 291 */
struct yaz_iconv_trie_flat marc8r_31page291_flat[] = {
  {"\x8A", 0, 0x215E61}, /* East Asian ideograph */
  {"\x8B", 0, 0x215E62}, /* East Asian ideograph */
  {"\x8C", 0, 0x215E63}, /* East Asian ideograph */
  {"\x88", 0, 0x215E64}, /* East Asian ideograph */
  {"\x86", 0, 0x215E65}, /* East Asian ideograph */
  {"\x96", 0, 0x215E67}, /* East Asian ideograph */
  {"\x90", 0, 0x215E68}, /* East Asian ideograph */
  {"\x9C", 0, 0x215E69}, /* East Asian ideograph */
  {"\xA1", 0, 0x215E6A}, /* East Asian ideograph */
  {"\xA2", 0, 0x215E6B}, /* East Asian ideograph */
  {"\x8D", 0, 0x23494A}, /* East Asian ideograph */
  {"\x89", 0, 0x234959}, /* East Asian ideograph */
  {"\x8E", 0, 0x23495D}, /* East Asian ideograph */
  {"\x95", 0, 0x234960}, /* East Asian ideograph */
  {"\x92", 0, 0x234962}, /* East Asian ideograph */
  {"\x93", 0, 0x234963}, /* East Asian ideograph */
  {"\x91", 0, 0x234964}, /* East Asian ideograph */
  {"\x83", 0, 0x234965}, /* East Asian ideograph */
  {"\x9A", 0, 0x234966}, /* East Asian ideograph */
  {"\x9E", 0, 0x234969}, /* East Asian ideograph */
  {"\xA0", 0, 0x23496A}, /* East Asian ideograph */
  {"\xA5", 0, 0x23496F}, /* East Asian ideograph */
  {"\xA4", 0, 0x234972}, /* East Asian ideograph */
  {"\xA7", 0, 0x234976}, /* East Asian ideograph */
  {"\xAE", 0, 0x273648}, /* East Asian ideograph */
  {"\xB7", 0, 0x273E5C}, /* East Asian ideograph */
  {"\xBB", 0, 0x275271}, /* East Asian ideograph */
  {"\xA8", 0, 0x275E4D}, /* East Asian ideograph */
  {"\xA9", 0, 0x275E4E}, /* East Asian ideograph */
  {"\xAA", 0, 0x275E4F}, /* East Asian ideograph */
  {"\xAD", 0, 0x275E50}, /* East Asian ideograph */
  {"\xB5", 0, 0x275E51}, /* East Asian ideograph */
  {"\xB0", 0, 0x275E52}, /* East Asian ideograph */
  {"\xB2", 0, 0x275E54}, /* East Asian ideograph */
  {"\xB4", 0, 0x275E55}, /* East Asian ideograph */
  {"\xB8", 0, 0x275E57}, /* East Asian ideograph */
  {"\xBA", 0, 0x275E59}, /* East Asian ideograph */
  {"\xBD", 0, 0x275E5A}, /* East Asian ideograph */
  {"\xBE", 0, 0x275E5F}, /* East Asian ideograph */
  {"\xB1", 0, 0x275E64}, /* East Asian ideograph */
  {"\xAF", 0, 0x275E67}, /* East Asian ideograph */
  {"\xB9", 0, 0x276168}, /* East Asian ideograph */
  {"\xB3", 0, 0x294936}, /* East Asian ideograph */
  {"\xBC", 0, 0x29496F}, /* East Asian ideograph */
  {"\x87", 0, 0x33433E}, /* East Asian ideograph */
  {"\xAB", 0, 0x455E60}, /* East Asian ideograph (Version J extension) */
  {"\xB6", 0, 0x474931}, /* East Asian ideograph */
  {"\x94", 0, 0x4B5E5D}, /* East Asian ideograph */
  {"\x98", 0, 0x4B6167}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page291 = {
  marc8r_31page291_flat, 0
};
/* PAGE 290 */
struct yaz_iconv_trie_flat marc8r_31page290_flat[] = {
  {"\x80", 0, 0x215E4D}, /* East Asian ideograph */
  {"\x82", 0, 0x215E4E}, /* East Asian ideograph */
  {"\x83", 0, 0x215E4F}, /* East Asian ideograph */
  {"\x89", 0, 0x215E50}, /* East Asian ideograph */
  {"\x94", 0, 0x215E51}, /* East Asian ideograph */
  {"\x8F", 0, 0x215E52}, /* East Asian ideograph */
  {"\x8B", 0, 0x215E53}, /* East Asian ideograph */
  {"\x91", 0, 0x215E54}, /* East Asian ideograph */
  {"\x93", 0, 0x215E55}, /* East Asian ideograph */
  {"\x92", 0, 0x215E56}, /* East Asian ideograph */
  {"\x98", 0, 0x215E57}, /* East Asian ideograph */
  {"\xA1", 0, 0x215E58}, /* East Asian ideograph */
  {"\xA8", 0, 0x215E59}, /* East Asian ideograph */
  {"\xA9", 0, 0x215E5A}, /* East Asian ideograph */
  {"\xA3", 0, 0x215E5B}, /* East Asian ideograph */
  {"\xA5", 0, 0x215E5C}, /* East Asian ideograph */
  {"\xA4", 0, 0x215E5D}, /* East Asian ideograph */
  {"\xB1", 0, 0x215E5E}, /* East Asian ideograph */
  {"\xAD", 0, 0x215E5F}, /* East Asian ideograph */
  {"\xBB", 0, 0x215E60}, /* East Asian ideograph */
  {"\x85", 0, 0x23492E}, /* East Asian ideograph */
  {"\x88", 0, 0x234930}, /* East Asian ideograph */
  {"\x8C", 0, 0x234931}, /* East Asian ideograph */
  {"\x97", 0, 0x234934}, /* East Asian ideograph */
  {"\x8E", 0, 0x234936}, /* East Asian ideograph */
  {"\x9F", 0, 0x234938}, /* East Asian ideograph */
  {"\xA0", 0, 0x23493A}, /* East Asian ideograph */
  {"\xAC", 0, 0x234942}, /* East Asian ideograph */
  {"\xAB", 0, 0x234944}, /* East Asian ideograph */
  {"\xBC", 0, 0x234948}, /* East Asian ideograph */
  {"\xBE", 0, 0x234949}, /* East Asian ideograph */
  {"\xB9", 0, 0x23494D}, /* East Asian ideograph */
  {"\xBA", 0, 0x23494E}, /* East Asian ideograph */
  {"\xB6", 0, 0x23494F}, /* East Asian ideograph */
  {"\xBF", 0, 0x234950}, /* East Asian ideograph */
  {"\xBD", 0, 0x234952}, /* East Asian ideograph */
  {"\xA7", 0, 0x2D362A}, /* East Asian ideograph */
  {"\x87", 0, 0x2D5E50}, /* East Asian ideograph */
  {"\x86", 0, 0x3F5E60}, /* East Asian ideograph */
  {"\xA2", 0, 0x4B5E69}, /* East Asian ideograph */
  {"\x99", 0, 0x4B6168}, /* East Asian ideograph */
  {"\x8A", 0, 0x696F5B}, /* East Asian ideograph */
  {"\x96", 0, 0x696F5D}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page290 = {
  marc8r_31page290_flat, 0
};
/* PAGE 289 */
struct yaz_iconv_trie_flat marc8r_31page289_flat[] = {
  {"\xB7", 0, 0x215E4C}, /* East Asian ideograph */
  {"\x80", 0, 0x275D77}, /* East Asian ideograph */
  {"\x81", 0, 0x275D78}, /* East Asian ideograph */
  {"\x91", 0, 0x275E25}, /* East Asian ideograph */
  {"\x87", 0, 0x275E27}, /* East Asian ideograph */
  {"\x8D", 0, 0x275E2A}, /* East Asian ideograph */
  {"\x9C", 0, 0x275E2B}, /* East Asian ideograph */
  {"\x9D", 0, 0x275E2C}, /* East Asian ideograph */
  {"\x9E", 0, 0x275E2E}, /* East Asian ideograph */
  {"\x96", 0, 0x275E32}, /* East Asian ideograph */
  {"\x97", 0, 0x275E33}, /* East Asian ideograph */
  {"\x82", 0, 0x275E34}, /* East Asian ideograph */
  {"\x98", 0, 0x275E35}, /* East Asian ideograph */
  {"\x99", 0, 0x275E36}, /* East Asian ideograph */
  {"\xB0", 0, 0x275E3A}, /* East Asian ideograph */
  {"\xAD", 0, 0x275E3C}, /* East Asian ideograph */
  {"\xAF", 0, 0x275E40}, /* East Asian ideograph */
  {"\xB3", 0, 0x275E44}, /* East Asian ideograph */
  {"\xB6", 0, 0x275E46}, /* East Asian ideograph */
  {"\xBF", 0, 0x275E4C}, /* East Asian ideograph */
  {"\x85", 0, 0x29454E}, /* East Asian ideograph */
  {"\x90", 0, 0x29457A}, /* East Asian ideograph */
  {"\x93", 0, 0x294621}, /* East Asian ideograph */
  {"\x92", 0, 0x294628}, /* East Asian ideograph */
  {"\x89", 0, 0x29462D}, /* East Asian ideograph */
  {"\x8F", 0, 0x294647}, /* East Asian ideograph */
  {"\x9B", 0, 0x294656}, /* East Asian ideograph */
  {"\x9F", 0, 0x29465A}, /* East Asian ideograph */
  {"\xAA", 0, 0x294662}, /* East Asian ideograph */
  {"\x86", 0, 0x29467C}, /* East Asian ideograph */
  {"\xA6", 0, 0x294734}, /* East Asian ideograph */
  {"\xA8", 0, 0x29473C}, /* East Asian ideograph */
  {"\xAB", 0, 0x29474D}, /* East Asian ideograph */
  {"\xA1", 0, 0x294758}, /* East Asian ideograph */
  {"\xA2", 0, 0x29475E}, /* East Asian ideograph */
  {"\xA3", 0, 0x294760}, /* East Asian ideograph */
  {"\xA4", 0, 0x294769}, /* East Asian ideograph */
  {"\xB1", 0, 0x294774}, /* East Asian ideograph */
  {"\x94", 0, 0x29483E}, /* East Asian ideograph */
  {"\xB2", 0, 0x29483F}, /* East Asian ideograph */
  {"\xAC", 0, 0x29484A}, /* East Asian ideograph */
  {"\xA5", 0, 0x29485C}, /* East Asian ideograph */
  {"\xA7", 0, 0x294869}, /* East Asian ideograph */
  {"\xA9", 0, 0x29486F}, /* East Asian ideograph */
  {"\x8A", 0, 0x294871}, /* East Asian ideograph */
  {"\x8E", 0, 0x4D446B}, /* East Asian ideograph */
  {"\x84", 0, 0x4D4754}, /* East Asian ideograph */
  {"\x8C", 0, 0x4D4835}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page289 = {
  marc8r_31page289_flat, 0
};
/* PAGE 288 */
struct yaz_iconv_trie_flat marc8r_31page288_flat[] = {
  {"\x91", 0, 0x215E42}, /* East Asian ideograph */
  {"\x84", 0, 0x215E43}, /* East Asian ideograph */
  {"\xA3", 0, 0x215E44}, /* East Asian ideograph */
  {"\xA0", 0, 0x215E45}, /* East Asian ideograph */
  {"\xB2", 0, 0x215E46}, /* East Asian ideograph */
  {"\xB0", 0, 0x215E47}, /* East Asian ideograph */
  {"\xBE", 0, 0x215E48}, /* East Asian ideograph */
  {"\xBC", 0, 0x215E49}, /* East Asian ideograph */
  {"\xBD", 0, 0x215E4A}, /* East Asian ideograph */
  {"\xBF", 0, 0x215E4B}, /* East Asian ideograph */
  {"\x80", 0, 0x234832}, /* East Asian ideograph */
  {"\x81", 0, 0x234837}, /* East Asian ideograph */
  {"\xA7", 0, 0x23483D}, /* East Asian ideograph */
  {"\x8C", 0, 0x23483E}, /* East Asian ideograph */
  {"\x85", 0, 0x234840}, /* East Asian ideograph */
  {"\x90", 0, 0x234842}, /* East Asian ideograph */
  {"\x8A", 0, 0x23484A}, /* East Asian ideograph */
  {"\xA6", 0, 0x234853}, /* East Asian ideograph */
  {"\xA4", 0, 0x234857}, /* East Asian ideograph */
  {"\xA2", 0, 0x234858}, /* East Asian ideograph */
  {"\xA5", 0, 0x23485C}, /* East Asian ideograph */
  {"\x95", 0, 0x23485D}, /* East Asian ideograph */
  {"\x9E", 0, 0x23485E}, /* East Asian ideograph */
  {"\xAA", 0, 0x234862}, /* East Asian ideograph */
  {"\xAB", 0, 0x234868}, /* East Asian ideograph */
  {"\xAD", 0, 0x234869}, /* East Asian ideograph */
  {"\xAF", 0, 0x23486C}, /* East Asian ideograph */
  {"\xB1", 0, 0x23486D}, /* East Asian ideograph */
  {"\xB7", 0, 0x234871}, /* East Asian ideograph */
  {"\x9B", 0, 0x2D4E5B}, /* East Asian ideograph */
  {"\xB5", 0, 0x2D522B}, /* East Asian ideograph */
  {"\x9A", 0, 0x2D5E4A}, /* East Asian ideograph */
  {"\x92", 0, 0x335E42}, /* East Asian ideograph */
  {"\x93", 0, 0x694C7A}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page288 = {
  marc8r_31page288_flat, 0
};
/* PAGE 287 */
struct yaz_iconv_trie_flat marc8r_31page287_flat[] = {
  {"\x83", 0, 0x215E39}, /* East Asian ideograph */
  {"\xAE", 0, 0x215E3A}, /* East Asian ideograph */
  {"\xB3", 0, 0x215E3C}, /* East Asian ideograph */
  {"\xB5", 0, 0x215E3D}, /* East Asian ideograph */
  {"\xBA", 0, 0x215E3E}, /* East Asian ideograph */
  {"\xB8", 0, 0x215E3F}, /* East Asian ideograph */
  {"\xB2", 0, 0x215E40}, /* East Asian ideograph */
  {"\x8B", 0, 0x234732}, /* East Asian ideograph */
  {"\x93", 0, 0x234734}, /* East Asian ideograph */
  {"\x8F", 0, 0x23473B}, /* East Asian ideograph */
  {"\xA0", 0, 0x23473C}, /* East Asian ideograph */
  {"\x99", 0, 0x23474D}, /* East Asian ideograph */
  {"\x8D", 0, 0x23474E}, /* East Asian ideograph */
  {"\xA6", 0, 0x234750}, /* East Asian ideograph */
  {"\xA7", 0, 0x234751}, /* East Asian ideograph */
  {"\x89", 0, 0x234755}, /* East Asian ideograph */
  {"\x94", 0, 0x234758}, /* East Asian ideograph */
  {"\x84", 0, 0x234759}, /* East Asian ideograph */
  {"\xA2", 0, 0x23475C}, /* East Asian ideograph */
  {"\x86", 0, 0x23475D}, /* East Asian ideograph */
  {"\x90", 0, 0x234760}, /* East Asian ideograph */
  {"\xA3", 0, 0x234762}, /* East Asian ideograph */
  {"\x87", 0, 0x23476A}, /* East Asian ideograph */
  {"\x8E", 0, 0x23476F}, /* East Asian ideograph */
  {"\x91", 0, 0x234771}, /* East Asian ideograph */
  {"\xBF", 0, 0x234774}, /* East Asian ideograph */
  {"\xA9", 0, 0x234779}, /* East Asian ideograph */
  {"\xBD", 0, 0x23477C}, /* East Asian ideograph */
  {"\xB6", 0, 0x234828}, /* East Asian ideograph */
  {"\xBB", 0, 0x23482B}, /* East Asian ideograph */
  {"\xA4", 0, 0x23482D}, /* East Asian ideograph */
  {"\xB7", 0, 0x234830}, /* East Asian ideograph */
  {"\xAB", 0, 0x234835}, /* East Asian ideograph */
  {"\xAD", 0, 0x234836}, /* East Asian ideograph */
  {"\xB1", 0, 0x234838}, /* East Asian ideograph */
  {"\x98", 0, 0x2D5E21}, /* East Asian ideograph */
  {"\x9A", 0, 0x2F445F}, /* East Asian ideograph */
  {"\xA1", 0, 0x4B5E3D}, /* East Asian ideograph */
  {"\xBE", 0, 0x4D477B}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page287 = {
  marc8r_31page287_flat, 0
};
/* PAGE 286 */
struct yaz_iconv_trie_flat marc8r_31page286_flat[] = {
  {"\xA1", 0, 0x215E2B}, /* East Asian ideograph */
  {"\x91", 0, 0x215E2C}, /* East Asian ideograph */
  {"\x96", 0, 0x215E2D}, /* East Asian ideograph */
  {"\x83", 0, 0x215E2E}, /* East Asian ideograph */
  {"\x9F", 0, 0x215E2F}, /* East Asian ideograph */
  {"\x97", 0, 0x215E30}, /* East Asian ideograph */
  {"\x88", 0, 0x215E31}, /* East Asian ideograph */
  {"\xA2", 0, 0x215E32}, /* East Asian ideograph */
  {"\x9C", 0, 0x215E33}, /* East Asian ideograph */
  {"\xA4", 0, 0x215E34}, /* East Asian ideograph */
  {"\x9D", 0, 0x215E35}, /* East Asian ideograph */
  {"\x8D", 0, 0x215E36}, /* East Asian ideograph */
  {"\x98", 0, 0x215E37}, /* East Asian ideograph */
  {"\xBD", 0, 0x215E3B}, /* East Asian ideograph */
  {"\xB1", 0, 0x234653}, /* East Asian ideograph */
  {"\x9E", 0, 0x234656}, /* East Asian ideograph */
  {"\xAE", 0, 0x234657}, /* East Asian ideograph */
  {"\x87", 0, 0x23465A}, /* East Asian ideograph */
  {"\xB2", 0, 0x23465B}, /* East Asian ideograph */
  {"\x94", 0, 0x23465D}, /* East Asian ideograph */
  {"\xA5", 0, 0x23465F}, /* East Asian ideograph */
  {"\xB9", 0, 0x234662}, /* East Asian ideograph */
  {"\x8A", 0, 0x234663}, /* East Asian ideograph */
  {"\x84", 0, 0x234664}, /* East Asian ideograph */
  {"\xA8", 0, 0x234666}, /* East Asian ideograph */
  {"\xA7", 0, 0x234667}, /* East Asian ideograph */
  {"\x9A", 0, 0x234672}, /* East Asian ideograph */
  {"\x90", 0, 0x234673}, /* East Asian ideograph */
  {"\xAF", 0, 0x234674}, /* East Asian ideograph */
  {"\x9B", 0, 0x234675}, /* East Asian ideograph */
  {"\x8C", 0, 0x23467C}, /* East Asian ideograph */
  {"\x93", 0, 0x23472C}, /* East Asian ideograph */
  {"\xA6", 0, 0x234730}, /* East Asian ideograph */
  {"\xBB", 0, 0x23473D}, /* East Asian ideograph */
  {"\xBA", 0, 0x234749}, /* East Asian ideograph */
  {"\xB5", 0, 0x234767}, /* East Asian ideograph */
  {"\xB7", 0, 0x234769}, /* East Asian ideograph */
  {"\xB4", 0, 0x234827}, /* East Asian ideograph */
  {"\x81", 0, 0x2D5E28}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page286 = {
  marc8r_31page286_flat, 0
};
/* PAGE 285 */
struct yaz_iconv_trie_flat marc8r_31page285_flat[] = {
  {"\x82", 0, 0x215D78}, /* East Asian ideograph */
  {"\x8A", 0, 0x215E25}, /* East Asian ideograph */
  {"\x94", 0, 0x215E26}, /* East Asian ideograph */
  {"\xAE", 0, 0x215E27}, /* East Asian ideograph */
  {"\x96", 0, 0x215E28}, /* East Asian ideograph */
  {"\xA2", 0, 0x215E29}, /* East Asian ideograph */
  {"\xB3", 0, 0x215E2A}, /* East Asian ideograph */
  {"\x86", 0, 0x234544}, /* East Asian ideograph */
  {"\xBE", 0, 0x234560}, /* East Asian ideograph */
  {"\x8F", 0, 0x234579}, /* East Asian ideograph */
  {"\xAC", 0, 0x23457A}, /* East Asian ideograph */
  {"\x95", 0, 0x23457B}, /* East Asian ideograph */
  {"\x8B", 0, 0x23457E}, /* East Asian ideograph */
  {"\xB5", 0, 0x234621}, /* East Asian ideograph */
  {"\x8C", 0, 0x234622}, /* East Asian ideograph */
  {"\x88", 0, 0x234623}, /* East Asian ideograph */
  {"\xB9", 0, 0x234625}, /* East Asian ideograph */
  {"\xA1", 0, 0x234627}, /* East Asian ideograph */
  {"\xB0", 0, 0x234628}, /* East Asian ideograph */
  {"\xA3", 0, 0x234629}, /* East Asian ideograph */
  {"\xB7", 0, 0x23462A}, /* East Asian ideograph */
  {"\x9B", 0, 0x23462B}, /* East Asian ideograph */
  {"\x98", 0, 0x23462D}, /* East Asian ideograph */
  {"\x89", 0, 0x23463C}, /* East Asian ideograph */
  {"\xA4", 0, 0x23463D}, /* East Asian ideograph */
  {"\xBC", 0, 0x234640}, /* East Asian ideograph */
  {"\xA7", 0, 0x234642}, /* East Asian ideograph */
  {"\xBD", 0, 0x234644}, /* East Asian ideograph */
  {"\xA6", 0, 0x234647}, /* East Asian ideograph */
  {"\x9A", 0, 0x234648}, /* East Asian ideograph */
  {"\xAA", 0, 0x23464A}, /* East Asian ideograph */
  {"\x9E", 0, 0x23464D}, /* East Asian ideograph */
  {"\x97", 0, 0x23464F}, /* East Asian ideograph */
  {"\xBB", 0, 0x234651}, /* East Asian ideograph */
  {"\xA9", 0, 0x23472F}, /* East Asian ideograph */
  {"\xAD", 0, 0x4B5E27}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page285 = {
  marc8r_31page285_flat, 0
};
/* PAGE 284 */
struct yaz_iconv_trie_flat marc8r_31page284_flat[] = {
  {"\x8D", 0, 0x215D77}, /* East Asian ideograph */
  {"\xB5", 0, 0x215D79}, /* East Asian ideograph */
  {"\xA5", 0, 0x215D7A}, /* East Asian ideograph */
  {"\x8B", 0, 0x215D7C}, /* East Asian ideograph */
  {"\xB0", 0, 0x215D7E}, /* East Asian ideograph */
  {"\xBE", 0, 0x215E21}, /* East Asian ideograph */
  {"\xAC", 0, 0x215E23}, /* East Asian ideograph */
  {"\x9B", 0, 0x215E24}, /* East Asian ideograph */
  {"\x84", 0, 0x23444F}, /* East Asian ideograph */
  {"\x80", 0, 0x234471}, /* East Asian ideograph */
  {"\x82", 0, 0x23452F}, /* East Asian ideograph */
  {"\x81", 0, 0x234531}, /* East Asian ideograph */
  {"\x8C", 0, 0x234535}, /* East Asian ideograph */
  {"\xB9", 0, 0x234541}, /* East Asian ideograph */
  {"\xAA", 0, 0x234547}, /* East Asian ideograph */
  {"\x9C", 0, 0x234548}, /* East Asian ideograph */
  {"\x8F", 0, 0x23454C}, /* East Asian ideograph */
  {"\x87", 0, 0x23454D}, /* East Asian ideograph */
  {"\xBA", 0, 0x234551}, /* East Asian ideograph */
  {"\x96", 0, 0x234553}, /* East Asian ideograph */
  {"\xB1", 0, 0x234554}, /* East Asian ideograph */
  {"\xBC", 0, 0x234556}, /* East Asian ideograph */
  {"\xB7", 0, 0x23455C}, /* East Asian ideograph */
  {"\x89", 0, 0x23455D}, /* East Asian ideograph */
  {"\x98", 0, 0x23455E}, /* East Asian ideograph */
  {"\x9A", 0, 0x23455F}, /* East Asian ideograph */
  {"\x9F", 0, 0x234562}, /* East Asian ideograph */
  {"\xB6", 0, 0x234564}, /* East Asian ideograph */
  {"\x95", 0, 0x234566}, /* East Asian ideograph */
  {"\x94", 0, 0x234567}, /* East Asian ideograph */
  {"\x88", 0, 0x23456A}, /* East Asian ideograph */
  {"\xB4", 0, 0x23456B}, /* East Asian ideograph */
  {"\x91", 0, 0x23456E}, /* East Asian ideograph */
  {"\xA4", 0, 0x23456F}, /* East Asian ideograph */
  {"\xAB", 0, 0x234571}, /* East Asian ideograph */
  {"\xAD", 0, 0x234572}, /* East Asian ideograph */
  {"\xA0", 0, 0x234573}, /* East Asian ideograph */
  {"\xAE", 0, 0x234577}, /* East Asian ideograph */
  {"\x8A", 0, 0x33496A}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page284 = {
  marc8r_31page284_flat, 0
};
/* PAGE 283 */
struct yaz_iconv_trie_flat marc8r_31page283_flat[] = {
  {"\xA0", 0, 0x215D6B}, /* East Asian ideograph */
  {"\xB6", 0, 0x215D6C}, /* East Asian ideograph */
  {"\xB3", 0, 0x215D6E}, /* East Asian ideograph */
  {"\xAF", 0, 0x215D6F}, /* East Asian ideograph */
  {"\xA2", 0, 0x215D70}, /* East Asian ideograph */
  {"\xAB", 0, 0x215D72}, /* East Asian ideograph */
  {"\x9A", 0, 0x215D73}, /* East Asian ideograph */
  {"\x84", 0, 0x215D74}, /* East Asian ideograph */
  {"\x90", 0, 0x215D75}, /* East Asian ideograph */
  {"\xA6", 0, 0x215D76}, /* East Asian ideograph */
  {"\xA8", 0, 0x215D7D}, /* East Asian ideograph */
  {"\x98", 0, 0x215E22}, /* East Asian ideograph */
  {"\x83", 0, 0x23444C}, /* East Asian ideograph */
  {"\x87", 0, 0x23444D}, /* East Asian ideograph */
  {"\x9E", 0, 0x23444E}, /* East Asian ideograph */
  {"\x9D", 0, 0x234453}, /* East Asian ideograph */
  {"\x9F", 0, 0x234458}, /* East Asian ideograph */
  {"\xB1", 0, 0x23445A}, /* East Asian ideograph */
  {"\x86", 0, 0x23445B}, /* East Asian ideograph */
  {"\x8F", 0, 0x23445F}, /* East Asian ideograph */
  {"\x82", 0, 0x234462}, /* East Asian ideograph */
  {"\xA4", 0, 0x234464}, /* East Asian ideograph */
  {"\x92", 0, 0x234466}, /* East Asian ideograph */
  {"\xB8", 0, 0x234469}, /* East Asian ideograph */
  {"\xA3", 0, 0x23446A}, /* East Asian ideograph */
  {"\xA1", 0, 0x23446C}, /* East Asian ideograph */
  {"\x81", 0, 0x234472}, /* East Asian ideograph */
  {"\x95", 0, 0x234474}, /* East Asian ideograph */
  {"\xA9", 0, 0x234476}, /* East Asian ideograph */
  {"\xAE", 0, 0x234478}, /* East Asian ideograph */
  {"\xAA", 0, 0x234479}, /* East Asian ideograph */
  {"\xBF", 0, 0x23447B}, /* East Asian ideograph */
  {"\xBA", 0, 0x23447C}, /* East Asian ideograph */
  {"\xB5", 0, 0x23447E}, /* East Asian ideograph */
  {"\x94", 0, 0x234522}, /* East Asian ideograph */
  {"\x99", 0, 0x234532}, /* East Asian ideograph */
  {"\xBE", 0, 0x294666}, /* East Asian ideograph */
  {"\xAC", 0, 0x4B496A}, /* East Asian ideograph */
  {"\xBB", 0, 0x696F27}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page283 = {
  marc8r_31page283_flat, 0
};
/* PAGE 282 */
struct yaz_iconv_trie_flat marc8r_31page282_flat[] = {
  {"\x85", 0, 0x215D62}, /* East Asian ideograph */
  {"\xAA", 0, 0x215D65}, /* East Asian ideograph */
  {"\x81", 0, 0x215D67}, /* East Asian ideograph */
  {"\xA4", 0, 0x215D68}, /* East Asian ideograph */
  {"\x92", 0, 0x215D6A}, /* East Asian ideograph */
  {"\xB8", 0, 0x215D6D}, /* East Asian ideograph */
  {"\xBC", 0, 0x215D71}, /* East Asian ideograph */
  {"\xAE", 0, 0x234340}, /* East Asian ideograph */
  {"\x88", 0, 0x234366}, /* East Asian ideograph */
  {"\x83", 0, 0x23436A}, /* East Asian ideograph */
  {"\x90", 0, 0x23436F}, /* East Asian ideograph */
  {"\xB1", 0, 0x234371}, /* East Asian ideograph */
  {"\x9F", 0, 0x234372}, /* East Asian ideograph */
  {"\xA6", 0, 0x234375}, /* East Asian ideograph */
  {"\x80", 0, 0x234377}, /* East Asian ideograph */
  {"\x99", 0, 0x23437A}, /* East Asian ideograph */
  {"\x95", 0, 0x23437E}, /* East Asian ideograph */
  {"\x86", 0, 0x234421}, /* East Asian ideograph */
  {"\xB4", 0, 0x234425}, /* East Asian ideograph */
  {"\x8F", 0, 0x234427}, /* East Asian ideograph */
  {"\xA7", 0, 0x23442C}, /* East Asian ideograph */
  {"\x87", 0, 0x23442D}, /* East Asian ideograph */
  {"\xB0", 0, 0x23442E}, /* East Asian ideograph */
  {"\x9B", 0, 0x23442F}, /* East Asian ideograph */
  {"\x9C", 0, 0x234430}, /* East Asian ideograph */
  {"\x98", 0, 0x234431}, /* East Asian ideograph */
  {"\xA9", 0, 0x234433}, /* East Asian ideograph */
  {"\x9D", 0, 0x234435}, /* East Asian ideograph */
  {"\x91", 0, 0x234439}, /* East Asian ideograph */
  {"\x8A", 0, 0x23443A}, /* East Asian ideograph */
  {"\x82", 0, 0x23443C}, /* East Asian ideograph */
  {"\x8C", 0, 0x23443E}, /* East Asian ideograph */
  {"\xAF", 0, 0x234440}, /* East Asian ideograph */
  {"\xA8", 0, 0x234441}, /* East Asian ideograph */
  {"\xAB", 0, 0x234443}, /* East Asian ideograph */
  {"\xB5", 0, 0x234445}, /* East Asian ideograph */
  {"\xB2", 0, 0x234448}, /* East Asian ideograph */
  {"\xBA", 0, 0x234454}, /* East Asian ideograph */
  {"\xB9", 0, 0x23445D}, /* East Asian ideograph */
  {"\xBE", 0, 0x234528}, /* East Asian ideograph */
  {"\xB3", 0, 0x2D5E43}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page282 = {
  marc8r_31page282_flat, 0
};
/* PAGE 281 */
struct yaz_iconv_trie_flat marc8r_31page281_flat[] = {
  {"\x80", 0, 0x215D5A}, /* East Asian ideograph */
  {"\xAC", 0, 0x215D5B}, /* East Asian ideograph */
  {"\x85", 0, 0x215D5C}, /* East Asian ideograph */
  {"\x98", 0, 0x215D5D}, /* East Asian ideograph */
  {"\x96", 0, 0x215D5E}, /* East Asian ideograph */
  {"\x93", 0, 0x215D60}, /* East Asian ideograph */
  {"\x9C", 0, 0x215D61}, /* East Asian ideograph */
  {"\xBB", 0, 0x215D63}, /* East Asian ideograph */
  {"\xB3", 0, 0x215D64}, /* East Asian ideograph */
  {"\xB7", 0, 0x215D66}, /* East Asian ideograph */
  {"\xBC", 0, 0x215D69}, /* East Asian ideograph */
  {"\x92", 0, 0x23422A}, /* East Asian ideograph */
  {"\xA2", 0, 0x23424F}, /* East Asian ideograph */
  {"\x83", 0, 0x23432F}, /* East Asian ideograph */
  {"\xA5", 0, 0x234331}, /* East Asian ideograph */
  {"\x82", 0, 0x234333}, /* East Asian ideograph */
  {"\xA8", 0, 0x234335}, /* East Asian ideograph */
  {"\xA4", 0, 0x234338}, /* East Asian ideograph */
  {"\x8D", 0, 0x23433F}, /* East Asian ideograph */
  {"\x88", 0, 0x234342}, /* East Asian ideograph */
  {"\x8E", 0, 0x234345}, /* East Asian ideograph */
  {"\xA0", 0, 0x234346}, /* East Asian ideograph */
  {"\xAA", 0, 0x234349}, /* East Asian ideograph */
  {"\xA6", 0, 0x234350}, /* East Asian ideograph */
  {"\x9A", 0, 0x234355}, /* East Asian ideograph */
  {"\xAB", 0, 0x234358}, /* East Asian ideograph */
  {"\x91", 0, 0x23435B}, /* East Asian ideograph */
  {"\x9B", 0, 0x23435D}, /* East Asian ideograph */
  {"\xA3", 0, 0x234364}, /* East Asian ideograph */
  {"\xB6", 0, 0x234376}, /* East Asian ideograph */
  {"\xBE", 0, 0x234379}, /* East Asian ideograph */
  {"\xB2", 0, 0x23442A}, /* East Asian ideograph */
  {"\xAE", 0, 0x275E48}, /* East Asian ideograph */
  {"\xB9", 0, 0x2D5E3B}, /* East Asian ideograph */
  {"\x95", 0, 0x395E3D}, /* East Asian ideograph */
  {"\xAD", 0, 0x4B5D70}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page281 = {
  marc8r_31page281_flat, 0
};
/* PAGE 280 */
struct yaz_iconv_trie_flat marc8r_31page280_flat[] = {
  {"\x80", 0, 0x215D53}, /* East Asian ideograph */
  {"\x8B", 0, 0x215D54}, /* East Asian ideograph */
  {"\x9B", 0, 0x215D55}, /* East Asian ideograph */
  {"\xA4", 0, 0x215D56}, /* East Asian ideograph */
  {"\x91", 0, 0x215D57}, /* East Asian ideograph */
  {"\xB8", 0, 0x215D59}, /* East Asian ideograph */
  {"\xBB", 0, 0x215D5F}, /* East Asian ideograph */
  {"\x89", 0, 0x234252}, /* East Asian ideograph */
  {"\x8D", 0, 0x234254}, /* East Asian ideograph */
  {"\x88", 0, 0x234255}, /* East Asian ideograph */
  {"\xA6", 0, 0x234261}, /* East Asian ideograph */
  {"\x9E", 0, 0x234264}, /* East Asian ideograph */
  {"\x90", 0, 0x23426B}, /* East Asian ideograph */
  {"\xAB", 0, 0x23426C}, /* East Asian ideograph */
  {"\xAD", 0, 0x23426F}, /* East Asian ideograph */
  {"\xAC", 0, 0x234270}, /* East Asian ideograph */
  {"\x8F", 0, 0x234271}, /* East Asian ideograph */
  {"\xA0", 0, 0x234277}, /* East Asian ideograph */
  {"\x8E", 0, 0x234323}, /* East Asian ideograph */
  {"\x8C", 0, 0x234326}, /* East Asian ideograph */
  {"\x96", 0, 0x234327}, /* East Asian ideograph */
  {"\x9A", 0, 0x23432B}, /* East Asian ideograph */
  {"\x81", 0, 0x23432E}, /* East Asian ideograph */
  {"\xBC", 0, 0x234337}, /* East Asian ideograph */
  {"\xB6", 0, 0x23433E}, /* East Asian ideograph */
  {"\xBA", 0, 0x234343}, /* East Asian ideograph */
  {"\xB7", 0, 0x234347}, /* East Asian ideograph */
  {"\xBE", 0, 0x234354}, /* East Asian ideograph */
  {"\xBF", 0, 0x234362}, /* East Asian ideograph */
  {"\x85", 0, 0x2D3C38}, /* East Asian ideograph */
  {"\xA2", 0, 0x2D5228}, /* East Asian ideograph */
  {"\x97", 0, 0x33502A}, /* East Asian ideograph */
  {"\x84", 0, 0x335E3D}, /* East Asian ideograph */
  {"\xB4", 0, 0x395E42}, /* East Asian ideograph */
  {"\xB1", 0, 0x514E5B}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page280 = {
  marc8r_31page280_flat, 0
};
/* PAGE 279 */
struct yaz_iconv_trie_flat marc8r_31page279_flat[] = {
  {"\xA3", 0, 0x215D47}, /* East Asian ideograph */
  {"\x8D", 0, 0x215D48}, /* East Asian ideograph */
  {"\x95", 0, 0x215D49}, /* East Asian ideograph */
  {"\x89", 0, 0x215D4A}, /* East Asian ideograph */
  {"\x94", 0, 0x215D4B}, /* East Asian ideograph */
  {"\x9E", 0, 0x215D4C}, /* East Asian ideograph */
  {"\x90", 0, 0x215D4D}, /* East Asian ideograph */
  {"\xB7", 0, 0x215D4F}, /* East Asian ideograph */
  {"\xB8", 0, 0x215D50}, /* East Asian ideograph */
  {"\xBD", 0, 0x215D51}, /* East Asian ideograph */
  {"\xBE", 0, 0x215D52}, /* East Asian ideograph */
  {"\xB4", 0, 0x215D58}, /* East Asian ideograph (variant of EACC 4B5D58) */
  {"\x84", 0, 0x234223}, /* East Asian ideograph */
  {"\x81", 0, 0x234225}, /* East Asian ideograph */
  {"\xAB", 0, 0x234226}, /* East Asian ideograph */
  {"\x8A", 0, 0x234227}, /* East Asian ideograph */
  {"\xA5", 0, 0x234228}, /* East Asian ideograph */
  {"\xA8", 0, 0x23422C}, /* East Asian ideograph */
  {"\x87", 0, 0x23422E}, /* East Asian ideograph */
  {"\x83", 0, 0x23422F}, /* East Asian ideograph */
  {"\x80", 0, 0x234231}, /* East Asian ideograph */
  {"\x98", 0, 0x234232}, /* East Asian ideograph */
  {"\x88", 0, 0x234236}, /* East Asian ideograph */
  {"\xA6", 0, 0x234237}, /* East Asian ideograph */
  {"\x9C", 0, 0x234238}, /* East Asian ideograph */
  {"\xA4", 0, 0x23423B}, /* East Asian ideograph */
  {"\x92", 0, 0x234243}, /* East Asian ideograph */
  {"\x96", 0, 0x23424A}, /* East Asian ideograph */
  {"\x91", 0, 0x23424B}, /* East Asian ideograph */
  {"\x86", 0, 0x23424E}, /* East Asian ideograph */
  {"\xB0", 0, 0x234251}, /* East Asian ideograph */
  {"\xBA", 0, 0x234258}, /* East Asian ideograph */
  {"\xAE", 0, 0x23425C}, /* East Asian ideograph */
  {"\xB3", 0, 0x23425F}, /* East Asian ideograph */
  {"\xB5", 0, 0x234268}, /* East Asian ideograph */
  {"\xB9", 0, 0x23426D}, /* East Asian ideograph */
  {"\xBF", 0, 0x234274}, /* East Asian ideograph */
  {"\xB6", 0, 0x23427E}, /* East Asian ideograph */
  {"\x8E", 0, 0x2D5D56}, /* East Asian ideograph */
  {"\xA1", 0, 0x335E21}, /* East Asian ideograph */
  {"\xAC", 0, 0x4B5E3F}, /* East Asian ideograph */
  {"\xA9", 0, 0x4D4862}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page279 = {
  marc8r_31page279_flat, 0
};
/* PAGE 278 */
struct yaz_iconv_trie_flat marc8r_31page278_flat[] = {
  {"\x80", 0, 0x215D34}, /* East Asian ideograph */
  {"\x81", 0, 0x215D35}, /* East Asian ideograph */
  {"\x87", 0, 0x215D36}, /* East Asian ideograph */
  {"\x89", 0, 0x215D37}, /* East Asian ideograph */
  {"\x8B", 0, 0x215D38}, /* East Asian ideograph */
  {"\x8D", 0, 0x215D3A}, /* East Asian ideograph */
  {"\x8E", 0, 0x215D3B}, /* East Asian ideograph */
  {"\x8F", 0, 0x215D3C}, /* East Asian ideograph */
  {"\x90", 0, 0x215D3D}, /* East Asian ideograph */
  {"\x91", 0, 0x215D3E}, /* East Asian ideograph */
  {"\x9D", 0, 0x215D3F}, /* East Asian ideograph */
  {"\x98", 0, 0x215D40}, /* East Asian ideograph */
  {"\x97", 0, 0x215D41}, /* East Asian ideograph */
  {"\x9C", 0, 0x215D42}, /* East Asian ideograph */
  {"\xB5", 0, 0x215D43}, /* East Asian ideograph */
  {"\xA6", 0, 0x215D44}, /* East Asian ideograph */
  {"\xA3", 0, 0x215D45}, /* East Asian ideograph */
  {"\xA7", 0, 0x215D46}, /* East Asian ideograph */
  {"\x82", 0, 0x23415A}, /* East Asian ideograph */
  {"\x84", 0, 0x23415B}, /* East Asian ideograph */
  {"\x83", 0, 0x23415C}, /* East Asian ideograph */
  {"\x94", 0, 0x234161}, /* East Asian ideograph */
  {"\x93", 0, 0x234162}, /* East Asian ideograph */
  {"\x95", 0, 0x234163}, /* East Asian ideograph */
  {"\x99", 0, 0x234164}, /* East Asian ideograph */
  {"\xA2", 0, 0x234168}, /* East Asian ideograph */
  {"\xAD", 0, 0x234169}, /* East Asian ideograph */
  {"\xB7", 0, 0x23416A}, /* East Asian ideograph */
  {"\xBA", 0, 0x23416B}, /* East Asian ideograph */
  {"\xB2", 0, 0x23416F}, /* East Asian ideograph */
  {"\xA8", 0, 0x234171}, /* East Asian ideograph */
  {"\xB6", 0, 0x234172}, /* East Asian ideograph */
  {"\xAE", 0, 0x234173}, /* East Asian ideograph */
  {"\xB4", 0, 0x234174}, /* East Asian ideograph */
  {"\xB1", 0, 0x234177}, /* East Asian ideograph */
  {"\xA9", 0, 0x234179}, /* East Asian ideograph */
  {"\xB8", 0, 0x23417A}, /* East Asian ideograph */
  {"\xB9", 0, 0x234221}, /* East Asian ideograph */
  {"\xA4", 0, 0x234222}, /* East Asian ideograph */
  {"\xBE", 0, 0x234233}, /* East Asian ideograph */
  {"\xBF", 0, 0x234248}, /* East Asian ideograph */
  {"\x8C", 0, 0x275763}, /* East Asian ideograph */
  {"\x8A", 0, 0x275D38}, /* East Asian ideograph */
  {"\xBC", 0, 0x333421}, /* East Asian ideograph */
  {"\x86", 0, 0x4B5D36}, /* East Asian ideograph */
  {"\x88", 0, 0x4B5D38}, /* East Asian ideograph */
  {"\xA1", 0, 0x4B5D42}, /* East Asian ideograph */
  {"\x9B", 0, 0x4D4176}, /* East Asian ideograph */
  {"\x96", 0, 0x513421}, /* East Asian ideograph */
  {"\x9F", 0, 0x696E5C}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page278 = {
  marc8r_31page278_flat, 0
};
/* PAGE 277 */
struct yaz_iconv_trie_flat marc8r_31page277_flat[] = {
  {"\x87", 0, 0x215D29}, /* East Asian ideograph */
  {"\x89", 0, 0x215D2A}, /* East Asian ideograph */
  {"\x8B", 0, 0x215D2B}, /* East Asian ideograph */
  {"\x83", 0, 0x215D2C}, /* East Asian ideograph */
  {"\x92", 0, 0x215D2D}, /* East Asian ideograph */
  {"\xA3", 0, 0x215D2E}, /* East Asian ideograph */
  {"\x9E", 0, 0x215D2F}, /* East Asian ideograph */
  {"\x9C", 0, 0x215D30}, /* East Asian ideograph */
  {"\xAB", 0, 0x215D31}, /* East Asian ideograph */
  {"\xAC", 0, 0x215D32}, /* East Asian ideograph */
  {"\xBA", 0, 0x215D33}, /* East Asian ideograph */
  {"\x85", 0, 0x23406D}, /* East Asian ideograph */
  {"\x82", 0, 0x23406F}, /* East Asian ideograph */
  {"\x8A", 0, 0x234070}, /* East Asian ideograph */
  {"\x86", 0, 0x234071}, /* East Asian ideograph */
  {"\x8C", 0, 0x234072}, /* East Asian ideograph */
  {"\x81", 0, 0x234073}, /* East Asian ideograph */
  {"\x91", 0, 0x23407B}, /* East Asian ideograph */
  {"\x90", 0, 0x23407D}, /* East Asian ideograph */
  {"\x8E", 0, 0x23407E}, /* East Asian ideograph */
  {"\x8D", 0, 0x234124}, /* East Asian ideograph */
  {"\x93", 0, 0x234125}, /* East Asian ideograph */
  {"\x9D", 0, 0x23412B}, /* East Asian ideograph */
  {"\x9A", 0, 0x23412C}, /* East Asian ideograph */
  {"\xA2", 0, 0x234130}, /* East Asian ideograph */
  {"\x9B", 0, 0x234134}, /* East Asian ideograph (variant of EACC 4D4134) */
  {"\xA8", 0, 0x234137}, /* East Asian ideograph */
  {"\xAA", 0, 0x23413D}, /* East Asian ideograph */
  {"\xAF", 0, 0x234141}, /* East Asian ideograph */
  {"\xB1", 0, 0x234142}, /* East Asian ideograph */
  {"\xAD", 0, 0x234147}, /* East Asian ideograph */
  {"\xAE", 0, 0x234148}, /* East Asian ideograph */
  {"\xB4", 0, 0x23414B}, /* East Asian ideograph */
  {"\xB2", 0, 0x23414C}, /* East Asian ideograph */
  {"\xB5", 0, 0x23414D}, /* East Asian ideograph */
  {"\xBF", 0, 0x234156}, /* East Asian ideograph */
  {"\xBD", 0, 0x234157}, /* East Asian ideograph */
  {"\x96", 0, 0x2D5D2F}, /* East Asian ideograph */
  {"\xBC", 0, 0x334A28}, /* East Asian ideograph */
  {"\xBE", 0, 0x354156}, /* East Asian ideograph */
  {"\xBB", 0, 0x395D23}, /* East Asian ideograph */
  {"\xB8", 0, 0x4B5D34}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page277 = {
  marc8r_31page277_flat, 0
};
/* PAGE 276 */
struct yaz_iconv_trie_flat marc8r_31page276_flat[] = {
  {"\x89", 0, 0x215C78}, /* East Asian ideograph */
  {"\x8B", 0, 0x215C79}, /* East Asian ideograph */
  {"\x8A", 0, 0x215C7A}, /* East Asian ideograph */
  {"\x92", 0, 0x215C7B}, /* East Asian ideograph */
  {"\x8D", 0, 0x215C7C}, /* East Asian ideograph */
  {"\x8C", 0, 0x215C7D}, /* East Asian ideograph */
  {"\x97", 0, 0x215C7E}, /* East Asian ideograph */
  {"\xA3", 0, 0x215D21}, /* East Asian ideograph */
  {"\xA5", 0, 0x215D22}, /* East Asian ideograph */
  {"\xAC", 0, 0x215D23}, /* East Asian ideograph */
  {"\xA9", 0, 0x215D24}, /* East Asian ideograph */
  {"\xAA", 0, 0x215D25}, /* East Asian ideograph */
  {"\xB5", 0, 0x215D26}, /* East Asian ideograph */
  {"\xB8", 0, 0x215D27}, /* East Asian ideograph */
  {"\xB7", 0, 0x215D28}, /* East Asian ideograph */
  {"\x83", 0, 0x23403B}, /* East Asian ideograph */
  {"\x86", 0, 0x23403E}, /* East Asian ideograph */
  {"\x85", 0, 0x23403F}, /* East Asian ideograph */
  {"\x88", 0, 0x234040}, /* East Asian ideograph */
  {"\x87", 0, 0x234041}, /* East Asian ideograph */
  {"\x90", 0, 0x234042}, /* East Asian ideograph */
  {"\x8E", 0, 0x234043}, /* East Asian ideograph */
  {"\x99", 0, 0x234048}, /* East Asian ideograph */
  {"\x9C", 0, 0x234049}, /* East Asian ideograph */
  {"\x96", 0, 0x23404D}, /* East Asian ideograph */
  {"\x98", 0, 0x234050}, /* East Asian ideograph */
  {"\x9A", 0, 0x234052}, /* East Asian ideograph */
  {"\xA1", 0, 0x234053}, /* East Asian ideograph */
  {"\xA4", 0, 0x234056}, /* East Asian ideograph */
  {"\xAF", 0, 0x234061}, /* East Asian ideograph */
  {"\xAE", 0, 0x234062}, /* East Asian ideograph */
  {"\xBA", 0, 0x234066}, /* East Asian ideograph */
  {"\xB2", 0, 0x234068}, /* East Asian ideograph */
  {"\xB9", 0, 0x234069}, /* East Asian ideograph */
  {"\xB6", 0, 0x23406A}, /* East Asian ideograph */
  {"\xB4", 0, 0x23406B}, /* East Asian ideograph */
  {"\xB3", 0, 0x23406C}, /* East Asian ideograph */
  {"\x94", 0, 0x275D2A}, /* East Asian ideograph */
  {"\x9D", 0, 0x275D2F}, /* East Asian ideograph */
  {"\xB1", 0, 0x275D32}, /* East Asian ideograph */
  {"\xBF", 0, 0x275D34}, /* East Asian ideograph */
  {"\xBE", 0, 0x29415C}, /* East Asian ideograph */
  {"\xBD", 0, 0x29415D}, /* East Asian ideograph */
  {"\xA7", 0, 0x2D5D23}, /* East Asian ideograph */
  {"\x8F", 0, 0x2F4053}, /* East Asian ideograph */
  {"\xA2", 0, 0x4B5D2B}, /* East Asian ideograph */
  {"\x9E", 0, 0x704C2A}, /* East Asian ideograph */
  {"\xB0", 0, 0x707523}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page276 = {
  marc8r_31page276_flat, 0
};
/* PAGE 275 */
struct yaz_iconv_trie_flat marc8r_31page275_flat[] = {
  {"\x82", 0, 0x215C6F}, /* East Asian ideograph */
  {"\x89", 0, 0x215C70}, /* East Asian ideograph */
  {"\x92", 0, 0x215C71}, /* East Asian ideograph */
  {"\x99", 0, 0x215C72}, /* East Asian ideograph */
  {"\xAD", 0, 0x215C73}, /* East Asian ideograph */
  {"\xB0", 0, 0x215C74}, /* East Asian ideograph */
  {"\xA7", 0, 0x215C75}, /* East Asian ideograph */
  {"\xB1", 0, 0x215C76}, /* East Asian ideograph */
  {"\xB9", 0, 0x215C77}, /* East Asian ideograph (variant of EACC 4B5C77) */
  {"\x84", 0, 0x233F49}, /* East Asian ideograph */
  {"\x86", 0, 0x233F4C}, /* East Asian ideograph */
  {"\x80", 0, 0x233F4E}, /* East Asian ideograph */
  {"\x87", 0, 0x233F50}, /* East Asian ideograph */
  {"\x8F", 0, 0x233F57}, /* East Asian ideograph */
  {"\x91", 0, 0x233F58}, /* East Asian ideograph */
  {"\x96", 0, 0x233F5A}, /* East Asian ideograph */
  {"\x94", 0, 0x233F5C}, /* East Asian ideograph */
  {"\x8B", 0, 0x233F60}, /* East Asian ideograph */
  {"\xA3", 0, 0x233F62}, /* East Asian ideograph (Version J extension) */
  {"\x98", 0, 0x233F63}, /* East Asian ideograph */
  {"\x9C", 0, 0x233F64}, /* East Asian ideograph */
  {"\xA0", 0, 0x233F66}, /* East Asian ideograph */
  {"\xA2", 0, 0x233F67}, /* East Asian ideograph */
  {"\x9E", 0, 0x233F6A}, /* East Asian ideograph */
  {"\xA4", 0, 0x233F71}, /* East Asian ideograph */
  {"\x9A", 0, 0x233F72}, /* East Asian ideograph */
  {"\xA5", 0, 0x233F74}, /* East Asian ideograph */
  {"\xAF", 0, 0x233F77}, /* East Asian ideograph */
  {"\xAB", 0, 0x233F79}, /* East Asian ideograph */
  {"\xB2", 0, 0x234021}, /* East Asian ideograph */
  {"\xA6", 0, 0x234024}, /* East Asian ideograph */
  {"\xB4", 0, 0x23402B}, /* East Asian ideograph */
  {"\xB6", 0, 0x23402C}, /* East Asian ideograph */
  {"\xBA", 0, 0x234031}, /* East Asian ideograph */
  {"\xBB", 0, 0x234032}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page275 = {
  marc8r_31page275_flat, 0
};
/* PAGE 274 */
struct yaz_iconv_trie_flat marc8r_31page274_flat[] = {
  {"\x8E", 0, 0x215C67}, /* East Asian ideograph */
  {"\x8A", 0, 0x215C68}, /* East Asian ideograph */
  {"\xA1", 0, 0x215C6A}, /* East Asian ideograph */
  {"\xA8", 0, 0x215C6B}, /* East Asian ideograph */
  {"\xAD", 0, 0x215C6C}, /* East Asian ideograph */
  {"\xB5", 0, 0x215C6D}, /* East Asian ideograph */
  {"\xBD", 0, 0x215C6E}, /* East Asian ideograph */
  {"\x89", 0, 0x233E68}, /* East Asian ideograph */
  {"\x95", 0, 0x233E6F}, /* East Asian ideograph */
  {"\x87", 0, 0x233E75}, /* East Asian ideograph */
  {"\x88", 0, 0x233E78}, /* East Asian ideograph */
  {"\x83", 0, 0x233E79}, /* East Asian ideograph */
  {"\x9D", 0, 0x233F22}, /* East Asian ideograph */
  {"\x9F", 0, 0x233F23}, /* East Asian ideograph */
  {"\xA2", 0, 0x233F26}, /* East Asian ideograph */
  {"\x98", 0, 0x233F27}, /* East Asian ideograph */
  {"\x9B", 0, 0x233F28}, /* East Asian ideograph */
  {"\x9C", 0, 0x233F2A}, /* East Asian ideograph */
  {"\x97", 0, 0x233F2C}, /* East Asian ideograph */
  {"\xA4", 0, 0x233F2D}, /* East Asian ideograph */
  {"\xAF", 0, 0x233F2E}, /* East Asian ideograph */
  {"\xAA", 0, 0x233F2F}, /* East Asian ideograph */
  {"\xB0", 0, 0x233F32}, /* East Asian ideograph */
  {"\xB4", 0, 0x233F33}, /* East Asian ideograph */
  {"\xB2", 0, 0x233F34}, /* East Asian ideograph */
  {"\xAB", 0, 0x233F3E}, /* East Asian ideograph */
  {"\xB3", 0, 0x233F3F}, /* East Asian ideograph */
  {"\xBC", 0, 0x233F46}, /* East Asian ideograph */
  {"\xBE", 0, 0x233F47}, /* East Asian ideograph */
  {"\xBF", 0, 0x233F4A}, /* East Asian ideograph */
  {"\x91", 0, 0x275C73}, /* East Asian ideograph */
  {"\x81", 0, 0x27616A}, /* East Asian ideograph */
  {"\x8F", 0, 0x293F23}, /* East Asian ideograph */
  {"\x93", 0, 0x293F4C}, /* East Asian ideograph */
  {"\xA7", 0, 0x293F5A}, /* East Asian ideograph */
  {"\xB8", 0, 0x294021}, /* East Asian ideograph */
  {"\x90", 0, 0x29402C}, /* East Asian ideograph */
  {"\xA6", 0, 0x294040}, /* East Asian ideograph */
  {"\x84", 0, 0x335F34}, /* East Asian ideograph */
  {"\x85", 0, 0x34782A}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page274 = {
  marc8r_31page274_flat, 0
};
/* PAGE 273 */
struct yaz_iconv_trie_flat marc8r_31page273_flat[] = {
  {"\x81", 0, 0x215C56}, /* East Asian ideograph */
  {"\x84", 0, 0x215C57}, /* East Asian ideograph */
  {"\x82", 0, 0x215C58}, /* East Asian ideograph */
  {"\x80", 0, 0x215C59}, /* East Asian ideograph */
  {"\x87", 0, 0x215C5A}, /* East Asian ideograph */
  {"\x8A", 0, 0x215C5B}, /* East Asian ideograph */
  {"\x90", 0, 0x215C5C}, /* East Asian ideograph */
  {"\x8F", 0, 0x215C5D}, /* East Asian ideograph */
  {"\x91", 0, 0x215C5E}, /* East Asian ideograph */
  {"\x95", 0, 0x215C5F}, /* East Asian ideograph */
  {"\xA3", 0, 0x215C60}, /* East Asian ideograph */
  {"\xA2", 0, 0x215C61}, /* East Asian ideograph */
  {"\xAA", 0, 0x215C62}, /* East Asian ideograph */
  {"\xA6", 0, 0x215C63}, /* East Asian ideograph */
  {"\xB5", 0, 0x215C64}, /* East Asian ideograph */
  {"\xB1", 0, 0x215C65}, /* East Asian ideograph */
  {"\xB8", 0, 0x215C66}, /* East Asian ideograph */
  {"\x85", 0, 0x233E2C}, /* East Asian ideograph */
  {"\x83", 0, 0x233E34}, /* East Asian ideograph */
  {"\x88", 0, 0x233E37}, /* East Asian ideograph */
  {"\x8B", 0, 0x233E3A}, /* East Asian ideograph */
  {"\x99", 0, 0x233E3F}, /* East Asian ideograph */
  {"\x97", 0, 0x233E40}, /* East Asian ideograph */
  {"\x9B", 0, 0x233E43}, /* East Asian ideograph */
  {"\x9C", 0, 0x233E44}, /* East Asian ideograph */
  {"\xA1", 0, 0x233E48}, /* East Asian ideograph */
  {"\xA8", 0, 0x233E51}, /* East Asian ideograph */
  {"\xA0", 0, 0x233E54}, /* East Asian ideograph */
  {"\xAF", 0, 0x233E58}, /* East Asian ideograph */
  {"\xB3", 0, 0x233E59}, /* East Asian ideograph */
  {"\xB6", 0, 0x233E5B}, /* East Asian ideograph */
  {"\xB0", 0, 0x233E5D}, /* East Asian ideograph */
  {"\xAD", 0, 0x233E5F}, /* East Asian ideograph */
  {"\xB2", 0, 0x233E61}, /* East Asian ideograph */
  {"\xBD", 0, 0x233E6A}, /* East Asian ideograph */
  {"\xBE", 0, 0x233E72}, /* East Asian ideograph */
  {"\xAE", 0, 0x275C6D}, /* East Asian ideograph */
  {"\xB9", 0, 0x275C71}, /* East Asian ideograph */
  {"\xBB", 0, 0x275C74}, /* East Asian ideograph */
  {"\x93", 0, 0x275C75}, /* East Asian ideograph */
  {"\xAC", 0, 0x293F5C}, /* East Asian ideograph */
  {"\xBA", 0, 0x29402B}, /* East Asian ideograph */
  {"\x9D", 0, 0x294031}, /* East Asian ideograph */
  {"\x89", 0, 0x2D5C5B}, /* East Asian ideograph */
  {"\xB4", 0, 0x2F4A2E}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page273 = {
  marc8r_31page273_flat, 0
};
/* PAGE 272 */
struct yaz_iconv_trie_flat marc8r_31page272_flat[] = {
  {"\x8B", 0, 0x215C34}, /* East Asian ideograph */
  {"\x93", 0, 0x215C36}, /* East Asian ideograph */
  {"\x82", 0, 0x215C37}, /* East Asian ideograph */
  {"\x90", 0, 0x215C38}, /* East Asian ideograph */
  {"\x94", 0, 0x215C39}, /* East Asian ideograph */
  {"\x95", 0, 0x215C3A}, /* East Asian ideograph */
  {"\x87", 0, 0x215C3C}, /* East Asian ideograph */
  {"\x8F", 0, 0x215C3D}, /* East Asian ideograph */
  {"\x8E", 0, 0x215C3E}, /* East Asian ideograph */
  {"\x8D", 0, 0x215C3F}, /* East Asian ideograph */
  {"\x91", 0, 0x215C40}, /* East Asian ideograph */
  {"\x81", 0, 0x215C41}, /* East Asian ideograph */
  {"\x98", 0, 0x215C43}, /* East Asian ideograph */
  {"\xA0", 0, 0x215C44}, /* East Asian ideograph */
  {"\x9C", 0, 0x215C45}, /* East Asian ideograph */
  {"\xA3", 0, 0x215C46}, /* East Asian ideograph */
  {"\xA5", 0, 0x215C47}, /* East Asian ideograph */
  {"\x9E", 0, 0x215C48}, /* East Asian ideograph */
  {"\xA9", 0, 0x215C49}, /* East Asian ideograph */
  {"\xAE", 0, 0x215C4A}, /* East Asian ideograph */
  {"\xA8", 0, 0x215C4B}, /* East Asian ideograph */
  {"\xAD", 0, 0x215C4C}, /* East Asian ideograph */
  {"\xB5", 0, 0x215C4D}, /* East Asian ideograph */
  {"\xB4", 0, 0x215C4E}, /* East Asian ideograph */
  {"\xB8", 0, 0x215C4F}, /* East Asian ideograph */
  {"\xB2", 0, 0x215C50}, /* East Asian ideograph */
  {"\xB7", 0, 0x215C51}, /* East Asian ideograph */
  {"\xBC", 0, 0x215C52}, /* East Asian ideograph */
  {"\xBA", 0, 0x215C53}, /* East Asian ideograph */
  {"\xBF", 0, 0x215C54}, /* East Asian ideograph */
  {"\xBD", 0, 0x215C55}, /* East Asian ideograph */
  {"\x86", 0, 0x233D5B}, /* East Asian ideograph */
  {"\x92", 0, 0x233D5D}, /* East Asian ideograph */
  {"\x89", 0, 0x233D67}, /* East Asian ideograph */
  {"\x84", 0, 0x233D6A}, /* East Asian ideograph */
  {"\xA2", 0, 0x233D74}, /* East Asian ideograph */
  {"\x9D", 0, 0x233D75}, /* East Asian ideograph */
  {"\x9B", 0, 0x233D78}, /* East Asian ideograph */
  {"\xAB", 0, 0x233D7B}, /* East Asian ideograph */
  {"\xB0", 0, 0x233E21}, /* East Asian ideograph */
  {"\xAF", 0, 0x233E25}, /* East Asian ideograph */
  {"\xB9", 0, 0x233E26}, /* East Asian ideograph */
  {"\xB6", 0, 0x233E28}, /* East Asian ideograph */
  {"\xBB", 0, 0x233E2A}, /* East Asian ideograph */
  {"\x97", 0, 0x275C53}, /* East Asian ideograph */
  {"\x8A", 0, 0x33477B}, /* East Asian ideograph */
  {"\xA1", 0, 0x39483B}, /* East Asian ideograph */
  {"\x99", 0, 0x4B5C47}, /* East Asian ideograph */
  {"\x85", 0, 0x4B5C50}, /* East Asian ideograph */
  {"\x96", 0, 0x696E28}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page272 = {
  marc8r_31page272_flat, 0
};
/* PAGE 271 */
struct yaz_iconv_trie_dir marc8r_31page271_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x215B77} /* East Asian ideograph */,
  {0, 0, 0x215B74} /* East Asian ideograph */,
  {0, 0, 0x275C49} /* East Asian ideograph */,
  {0, 0, 0x215B7A} /* East Asian ideograph */,
  {0, 0, 0x233D3F} /* East Asian ideograph */,
  {0, 0, 0x215B7C} /* East Asian ideograph */,
  {0, 0, 0x215B75} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x233D40} /* East Asian ideograph */,
  {0, 0, 0x275C4F} /* East Asian ideograph */,
  {0, 0, 0x275C45} /* East Asian ideograph */,
  {0, 0, 0x233D45} /* East Asian ideograph */,
  {0, 0, 0x233D48} /* East Asian ideograph */,
  {0, 0, 0x215C26} /* East Asian ideograph */,
  {0, 0, 0x2F3D5D} /* East Asian ideograph */,
  {0, 0, 0x215C2A} /* East Asian ideograph */,
  {0, 0, 0x215C24} /* East Asian ideograph */,
  {0, 0, 0x233D44} /* East Asian ideograph */,
  {0, 0, 0x275C48} /* East Asian ideograph */,
  {0, 0, 0x2D5C48} /* East Asian ideograph */,
  {0, 0, 0x215C2E} /* East Asian ideograph */,
  {0, 0, 0x2D3D67} /* East Asian ideograph */,
  {0, 0, 0x215C2C} /* East Asian ideograph */,
  {0, 0, 0x215C22} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x215B7D} /* East Asian ideograph */,
  {0, 0, 0x215C28} /* East Asian ideograph */,
  {0, 0, 0x215C2D} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x215C23} /* East Asian ideograph */,
  {0, 0, 0x215C27} /* East Asian ideograph */,
  {0, 0, 0x215C21} /* East Asian ideograph */,
  {0, 0, 0x215C29} /* East Asian ideograph */,
  {0, 0, 0x233D49} /* East Asian ideograph */,
  {0, 0, 0x215C2B} /* East Asian ideograph */,
  {0, 0, 0x215B7E} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x275C5C} /* East Asian ideograph */,
  {0, 0, 0x696D7A} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x33392F} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x233D4E} /* East Asian ideograph */,
  {0, 0, 0x233D4A} /* East Asian ideograph */,
  {0, 0, 0x215C2F} /* East Asian ideograph */,
  {0, 0, 0x233D58} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x215C31} /* East Asian ideograph */,
  {0, 0, 0x215C33} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x233D57} /* East Asian ideograph */,
  {0, 0, 0x215C30} /* East Asian ideograph */,
  {0, 0, 0x233D59} /* East Asian ideograph */,
  {0, 0, 0x233D56} /* East Asian ideograph */,
  {0, 0, 0x215C32} /* East Asian ideograph (variant of EACC 4B5C32) */,
  {0, 0, 0x4B5C39} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x275C5D} /* East Asian ideograph */,
  {0, 0, 0x215C3B} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x215C42} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page271 = {
  0, marc8r_31page271_dir
};
/* PAGE 270 */
struct yaz_iconv_trie_flat marc8r_31page270_flat[] = {
  {"\x90", 0, 0x213D2D}, /* East Asian ideograph */
  {"\x8D", 0, 0x21632B}, /* East Asian ideograph */
  {"\x94", 0, 0x21632C}, /* East Asian ideograph */
  {"\x9C", 0, 0x21632D}, /* East Asian ideograph */
  {"\x8E", 0, 0x23605B}, /* East Asian ideograph */
  {"\x93", 0, 0x236061}, /* East Asian ideograph */
  {"\x95", 0, 0x236062}, /* East Asian ideograph */
  {"\xA0", 0, 0x23606B}, /* East Asian ideograph */
  {"\xA5", 0, 0x236071}, /* East Asian ideograph */
  {"\xA4", 0, 0x236072}, /* East Asian ideograph */
  {"\x83", 0, 0x276322}, /* East Asian ideograph */
  {"\x84", 0, 0x276324}, /* East Asian ideograph */
  {"\x88", 0, 0x276325}, /* East Asian ideograph */
  {"\x87", 0, 0x276326}, /* East Asian ideograph */
  {"\x89", 0, 0x276327}, /* East Asian ideograph */
  {"\x8A", 0, 0x276328}, /* East Asian ideograph */
  {"\x8C", 0, 0x276329}, /* East Asian ideograph */
  {"\x8B", 0, 0x27632A}, /* East Asian ideograph */
  {"\x99", 0, 0x27632B}, /* East Asian ideograph */
  {"\x9A", 0, 0x27632C}, /* East Asian ideograph */
  {"\x9F", 0, 0x27632D}, /* East Asian ideograph */
  {"\x80", 0, 0x295F7C}, /* East Asian ideograph */
  {"\x86", 0, 0x296028}, /* East Asian ideograph */
  {"\x85", 0, 0x29602B}, /* East Asian ideograph */
  {"\x9B", 0, 0x296062}, /* East Asian ideograph */
  {"\x9D", 0, 0x2D4F29}, /* East Asian ideograph */
  {"\xA2", 0, 0x393577}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page270 = {
  marc8r_31page270_flat, 0
};
/* PAGE 269 */
struct yaz_iconv_trie_flat marc8r_31page269_flat[] = {
  {"\x86", 0, 0x215B66}, /* East Asian ideograph */
  {"\x85", 0, 0x215B67}, /* East Asian ideograph */
  {"\x84", 0, 0x215B68}, /* East Asian ideograph */
  {"\x8E", 0, 0x215B6A}, /* East Asian ideograph */
  {"\x91", 0, 0x215B6B}, /* East Asian ideograph */
  {"\x94", 0, 0x215B6C}, /* East Asian ideograph */
  {"\xB0", 0, 0x215B6D}, /* East Asian ideograph (variant of EACC 275B6D) */
  {"\xA6", 0, 0x215B6E}, /* East Asian ideograph */
  {"\xA2", 0, 0x215B6F}, /* East Asian ideograph */
  {"\xAA", 0, 0x215B70}, /* East Asian ideograph */
  {"\xA5", 0, 0x215B71}, /* East Asian ideograph */
  {"\xAB", 0, 0x215B73}, /* East Asian ideograph */
  {"\xB7", 0, 0x215B76}, /* East Asian ideograph */
  {"\xBD", 0, 0x215B7B}, /* East Asian ideograph */
  {"\x92", 0, 0x233C75}, /* East Asian ideograph */
  {"\x8B", 0, 0x233C77}, /* East Asian ideograph */
  {"\x8A", 0, 0x233C7A}, /* East Asian ideograph */
  {"\x93", 0, 0x233C7B}, /* East Asian ideograph */
  {"\x8D", 0, 0x233C7D}, /* East Asian ideograph */
  {"\x9A", 0, 0x233D21}, /* East Asian ideograph */
  {"\x95", 0, 0x233D22}, /* East Asian ideograph */
  {"\xA4", 0, 0x233D2F}, /* East Asian ideograph */
  {"\xAE", 0, 0x233D30}, /* East Asian ideograph */
  {"\xB9", 0, 0x233D35}, /* East Asian ideograph */
  {"\xBB", 0, 0x233D3C}, /* East Asian ideograph */
  {"\xAD", 0, 0x274C3C}, /* East Asian ideograph */
  {"\x99", 0, 0x275B7D}, /* East Asian ideograph */
  {"\x9E", 0, 0x275B7E}, /* East Asian ideograph */
  {"\x9B", 0, 0x275C33}, /* East Asian ideograph */
  {"\x90", 0, 0x275C34}, /* East Asian ideograph */
  {"\x9D", 0, 0x275C3A}, /* East Asian ideograph */
  {"\x82", 0, 0x275C3C}, /* East Asian ideograph */
  {"\x87", 0, 0x275C3E}, /* East Asian ideograph */
  {"\x9C", 0, 0x275C44}, /* East Asian ideograph */
  {"\x9F", 0, 0x275C50}, /* East Asian ideograph */
  {"\x81", 0, 0x275C51}, /* East Asian ideograph */
  {"\x88", 0, 0x275C56}, /* East Asian ideograph */
  {"\x98", 0, 0x275C57}, /* East Asian ideograph */
  {"\xA9", 0, 0x275C5A}, /* East Asian ideograph (variant of EACC 2D5C5A) */
  {"\xB8", 0, 0x293D4E}, /* East Asian ideograph */
  {"\xAF", 0, 0x2D5B7A}, /* East Asian ideograph */
  {"\xA8", 0, 0x2D5C2F}, /* East Asian ideograph */
  {"\xBA", 0, 0x33303A}, /* East Asian ideograph */
  {"\xB4", 0, 0x333768}, /* East Asian ideograph */
  {"\xB3", 0, 0x513D67}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page269 = {
  marc8r_31page269_flat, 0
};
/* PAGE 268 */
struct yaz_iconv_trie_flat marc8r_31page268_flat[] = {
  {"\x84", 0, 0x215B4F}, /* East Asian ideograph */
  {"\x85", 0, 0x215B51}, /* East Asian ideograph */
  {"\x82", 0, 0x215B52}, /* East Asian ideograph (variant of EACC 4B5B52) */
  {"\x8D", 0, 0x215B54}, /* East Asian ideograph */
  {"\x89", 0, 0x215B55}, /* East Asian ideograph */
  {"\x94", 0, 0x215B56}, /* East Asian ideograph */
  {"\x8E", 0, 0x215B57}, /* East Asian ideograph */
  {"\x9F", 0, 0x215B58}, /* East Asian ideograph */
  {"\xA1", 0, 0x215B59}, /* East Asian ideograph */
  {"\x80", 0, 0x233C2D}, /* East Asian ideograph */
  {"\x86", 0, 0x233C30}, /* East Asian ideograph */
  {"\x8A", 0, 0x233C31}, /* East Asian ideograph */
  {"\x87", 0, 0x233C33}, /* East Asian ideograph */
  {"\x92", 0, 0x233C3D}, /* East Asian ideograph */
  {"\x96", 0, 0x233C48}, /* East Asian ideograph */
  {"\x97", 0, 0x233C49}, /* East Asian ideograph */
  {"\x95", 0, 0x233C4B}, /* East Asian ideograph */
  {"\x98", 0, 0x233C4C}, /* East Asian ideograph */
  {"\x9C", 0, 0x233C4D}, /* East Asian ideograph */
  {"\x9E", 0, 0x233C4E}, /* East Asian ideograph */
  {"\x9D", 0, 0x233C53}, /* East Asian ideograph */
  {"\xA2", 0, 0x233C57}, /* East Asian ideograph */
  {"\xA3", 0, 0x233C59}, /* East Asian ideograph */
  {"\xA4", 0, 0x233C5A}, /* East Asian ideograph */
  {"\xA6", 0, 0x275B32}, /* East Asian ideograph */
  {"\xA7", 0, 0x275B33}, /* East Asian ideograph */
  {"\xA8", 0, 0x275B35}, /* East Asian ideograph */
  {"\xA9", 0, 0x275B36}, /* East Asian ideograph */
  {"\xAB", 0, 0x275B37}, /* East Asian ideograph */
  {"\xAF", 0, 0x275B38}, /* East Asian ideograph */
  {"\xAD", 0, 0x275B39}, /* East Asian ideograph */
  {"\xB2", 0, 0x275B3A}, /* East Asian ideograph */
  {"\xB4", 0, 0x275B3B}, /* East Asian ideograph */
  {"\xB6", 0, 0x275B3C}, /* East Asian ideograph */
  {"\xBC", 0, 0x275B3E}, /* East Asian ideograph */
  {"\xBD", 0, 0x275B3F}, /* East Asian ideograph */
  {"\xBE", 0, 0x275B40}, /* East Asian ideograph */
  {"\xBB", 0, 0x275B43}, /* East Asian ideograph */
  {"\xAE", 0, 0x275B4A}, /* East Asian ideograph */
  {"\xAC", 0, 0x275B55}, /* East Asian ideograph */
  {"\xBF", 0, 0x275B57}, /* East Asian ideograph */
  {"\xB0", 0, 0x275B58}, /* East Asian ideograph */
  {"\xB1", 0, 0x293B3E}, /* East Asian ideograph */
  {"\xBA", 0, 0x293B3F}, /* East Asian ideograph */
  {"\xB5", 0, 0x293B42}, /* East Asian ideograph */
  {"\xB7", 0, 0x293B47}, /* East Asian ideograph */
  {"\xB8", 0, 0x293B4F}, /* East Asian ideograph */
  {"\xB9", 0, 0x293C57}, /* East Asian ideograph */
  {"\xB3", 0, 0x293C5A}, /* East Asian ideograph */
  {"\x8C", 0, 0x696D5A}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page268 = {
  marc8r_31page268_flat, 0
};
/* PAGE 267 */
struct yaz_iconv_trie_flat marc8r_31page267_flat[] = {
  {"\x83", 0, 0x215B3D}, /* East Asian ideograph */
  {"\x89", 0, 0x215B3F}, /* East Asian ideograph */
  {"\x8A", 0, 0x215B40}, /* East Asian ideograph */
  {"\x94", 0, 0x215B41}, /* East Asian ideograph */
  {"\x92", 0, 0x215B42}, /* East Asian ideograph */
  {"\x95", 0, 0x215B43}, /* East Asian ideograph */
  {"\x93", 0, 0x215B44}, /* East Asian ideograph */
  {"\xA6", 0, 0x215B45}, /* East Asian ideograph */
  {"\x9B", 0, 0x215B46}, /* East Asian ideograph */
  {"\x9F", 0, 0x215B47}, /* East Asian ideograph */
  {"\x9D", 0, 0x215B48}, /* East Asian ideograph */
  {"\xA9", 0, 0x215B49}, /* East Asian ideograph */
  {"\xAA", 0, 0x215B4A}, /* East Asian ideograph */
  {"\x9C", 0, 0x215B4B}, /* East Asian ideograph */
  {"\xBB", 0, 0x215B4C}, /* East Asian ideograph */
  {"\xAF", 0, 0x215B4D}, /* East Asian ideograph */
  {"\xB8", 0, 0x215B4E}, /* East Asian ideograph */
  {"\xBE", 0, 0x215B50}, /* East Asian ideograph */
  {"\xBF", 0, 0x215B53}, /* East Asian ideograph */
  {"\x80", 0, 0x233B56}, /* East Asian ideograph */
  {"\x85", 0, 0x233B59}, /* East Asian ideograph */
  {"\x88", 0, 0x233B5A}, /* East Asian ideograph */
  {"\x87", 0, 0x233B5B}, /* East Asian ideograph */
  {"\xA7", 0, 0x233B63}, /* East Asian ideograph */
  {"\xAC", 0, 0x233B64}, /* East Asian ideograph */
  {"\x9E", 0, 0x233B6B}, /* East Asian ideograph */
  {"\xA5", 0, 0x233B6D}, /* East Asian ideograph */
  {"\xA0", 0, 0x233B6E}, /* East Asian ideograph */
  {"\x97", 0, 0x233B75}, /* East Asian ideograph */
  {"\xB6", 0, 0x233B78}, /* East Asian ideograph */
  {"\xAE", 0, 0x233B79}, /* East Asian ideograph */
  {"\xB3", 0, 0x233B7A}, /* East Asian ideograph */
  {"\xAD", 0, 0x233B7D}, /* East Asian ideograph */
  {"\xB9", 0, 0x233C26}, /* East Asian ideograph */
  {"\xB4", 0, 0x233C27}, /* East Asian ideograph */
  {"\x99", 0, 0x2D5B42}, /* East Asian ideograph */
  {"\xBC", 0, 0x2F3C2D}, /* East Asian ideograph */
  {"\x8C", 0, 0x4B5B46}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page267 = {
  marc8r_31page267_flat, 0
};
/* PAGE 266 */
struct yaz_iconv_trie_flat marc8r_31page266_flat[] = {
  {"\x80", 0, 0x215B31}, /* East Asian ideograph */
  {"\x8A", 0, 0x215B32}, /* East Asian ideograph */
  {"\x8B", 0, 0x215B33}, /* East Asian ideograph */
  {"\x8D", 0, 0x215B34}, /* East Asian ideograph */
  {"\x8C", 0, 0x215B35}, /* East Asian ideograph */
  {"\x92", 0, 0x215B36}, /* East Asian ideograph */
  {"\x94", 0, 0x215B37}, /* East Asian ideograph */
  {"\x9F", 0, 0x215B38}, /* East Asian ideograph */
  {"\x9B", 0, 0x215B39}, /* East Asian ideograph */
  {"\xBB", 0, 0x215B3A}, /* East Asian ideograph */
  {"\xB8", 0, 0x215B3B}, /* East Asian ideograph */
  {"\xBC", 0, 0x215B3C}, /* East Asian ideograph */
  {"\xBE", 0, 0x215B3E}, /* East Asian ideograph */
  {"\x89", 0, 0x233B2E}, /* East Asian ideograph */
  {"\x8F", 0, 0x233B2F}, /* East Asian ideograph */
  {"\x8E", 0, 0x233B31}, /* East Asian ideograph */
  {"\x95", 0, 0x233B33}, /* East Asian ideograph */
  {"\xBA", 0, 0x233B3F}, /* East Asian ideograph */
  {"\xB9", 0, 0x233B42}, /* East Asian ideograph */
  {"\xA8", 0, 0x233B4B}, /* East Asian ideograph */
  {"\xAB", 0, 0x233B4F}, /* East Asian ideograph */
  {"\xBF", 0, 0x233B51}, /* East Asian ideograph */
  {"\xBD", 0, 0x2D5B43}, /* East Asian ideograph */
  {"\x86", 0, 0x2D615A}, /* East Asian ideograph */
  {"\xA2", 0, 0x4B5B55}, /* East Asian ideograph */
  {"\xA3", 0, 0x4B5B58}, /* East Asian ideograph */
  {"\x85", 0, 0x696D40}, /* East Asian ideograph */
  {"\x88", 0, 0x696D41}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page266 = {
  marc8r_31page266_flat, 0
};
/* PAGE 265 */
struct yaz_iconv_trie_flat marc8r_31page265_flat[] = {
  {"\x82", 0, 0x215B23}, /* East Asian ideograph */
  {"\x81", 0, 0x215B24}, /* East Asian ideograph */
  {"\x87", 0, 0x215B25}, /* East Asian ideograph */
  {"\x89", 0, 0x215B26}, /* East Asian ideograph */
  {"\x85", 0, 0x215B27}, /* East Asian ideograph */
  {"\x8A", 0, 0x215B28}, /* East Asian ideograph */
  {"\x8D", 0, 0x215B29}, /* East Asian ideograph (variant of EACC 4B5B29) */
  {"\x91", 0, 0x215B2A}, /* East Asian ideograph */
  {"\xA1", 0, 0x215B2B}, /* East Asian ideograph */
  {"\xAA", 0, 0x215B2C}, /* East Asian ideograph */
  {"\xAB", 0, 0x215B2D}, /* East Asian ideograph */
  {"\xAC", 0, 0x215B2E}, /* East Asian ideograph */
  {"\xB2", 0, 0x215B2F}, /* East Asian ideograph */
  {"\xBA", 0, 0x215B30}, /* East Asian ideograph */
  {"\x95", 0, 0x233A46}, /* East Asian ideograph */
  {"\x83", 0, 0x233A52}, /* East Asian ideograph */
  {"\x84", 0, 0x233A53}, /* East Asian ideograph */
  {"\x8B", 0, 0x233A57}, /* East Asian ideograph */
  {"\x94", 0, 0x233A5D}, /* East Asian ideograph */
  {"\x9A", 0, 0x233A5E}, /* East Asian ideograph */
  {"\x92", 0, 0x233A5F}, /* East Asian ideograph */
  {"\x93", 0, 0x233A60}, /* East Asian ideograph */
  {"\x90", 0, 0x233A62}, /* East Asian ideograph */
  {"\x98", 0, 0x233A63}, /* East Asian ideograph */
  {"\x9E", 0, 0x233A64}, /* East Asian ideograph */
  {"\xA5", 0, 0x233A6B}, /* East Asian ideograph */
  {"\xA7", 0, 0x233A6F}, /* East Asian ideograph */
  {"\xA9", 0, 0x233A71}, /* East Asian ideograph */
  {"\x99", 0, 0x233A72}, /* East Asian ideograph */
  {"\xB3", 0, 0x233A78}, /* East Asian ideograph */
  {"\xBC", 0, 0x233A7A}, /* East Asian ideograph */
  {"\xB6", 0, 0x233A7D}, /* East Asian ideograph */
  {"\x8F", 0, 0x275B2C}, /* East Asian ideograph */
  {"\xAF", 0, 0x275B31}, /* East Asian ideograph */
  {"\x9C", 0, 0x293A70}, /* East Asian ideograph */
  {"\xAD", 0, 0x2D526C}, /* East Asian ideograph */
  {"\xB1", 0, 0x2D5B2F}, /* East Asian ideograph */
  {"\xB0", 0, 0x33615A}, /* East Asian ideograph */
  {"\xBE", 0, 0x696D3F}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page265 = {
  marc8r_31page265_flat, 0
};
/* PAGE 264 */
struct yaz_iconv_trie_flat marc8r_31page264_flat[] = {
  {"\x84", 0, 0x215A6E}, /* East Asian ideograph */
  {"\x82", 0, 0x215A70}, /* East Asian ideograph */
  {"\x89", 0, 0x215A74}, /* East Asian ideograph */
  {"\x8B", 0, 0x215A75}, /* East Asian ideograph */
  {"\x88", 0, 0x215A76}, /* East Asian ideograph */
  {"\x8A", 0, 0x215A77}, /* East Asian ideograph */
  {"\xA3", 0, 0x215A78}, /* East Asian ideograph */
  {"\x99", 0, 0x215A79}, /* East Asian ideograph */
  {"\xA6", 0, 0x215A7A}, /* East Asian ideograph */
  {"\xA4", 0, 0x215A7B}, /* East Asian ideograph */
  {"\xB2", 0, 0x215A7C}, /* East Asian ideograph */
  {"\xAC", 0, 0x215A7D}, /* East Asian ideograph */
  {"\xBA", 0, 0x215A7E}, /* East Asian ideograph */
  {"\xB6", 0, 0x215B21}, /* East Asian ideograph */
  {"\xBC", 0, 0x215B22}, /* East Asian ideograph */
  {"\x81", 0, 0x23396F}, /* East Asian ideograph */
  {"\x80", 0, 0x233977}, /* East Asian ideograph */
  {"\x87", 0, 0x233A24}, /* East Asian ideograph */
  {"\x86", 0, 0x233A26}, /* East Asian ideograph */
  {"\x8C", 0, 0x233A2E}, /* East Asian ideograph */
  {"\x90", 0, 0x233A30}, /* East Asian ideograph */
  {"\x8F", 0, 0x233A32}, /* East Asian ideograph */
  {"\x9C", 0, 0x233A34}, /* East Asian ideograph */
  {"\xA2", 0, 0x233A35}, /* East Asian ideograph */
  {"\xA0", 0, 0x233A36}, /* East Asian ideograph */
  {"\x94", 0, 0x233A3A}, /* East Asian ideograph */
  {"\xA7", 0, 0x233A3B}, /* East Asian ideograph */
  {"\x9A", 0, 0x233A3E}, /* East Asian ideograph */
  {"\x9E", 0, 0x233A3F}, /* East Asian ideograph */
  {"\x95", 0, 0x233A40}, /* East Asian ideograph */
  {"\xA1", 0, 0x233A41}, /* East Asian ideograph */
  {"\x9D", 0, 0x233A43}, /* East Asian ideograph */
  {"\xB5", 0, 0x233A44}, /* East Asian ideograph */
  {"\xB4", 0, 0x233A45}, /* East Asian ideograph */
  {"\xAD", 0, 0x233A48}, /* East Asian ideograph */
  {"\xA9", 0, 0x233A4B}, /* East Asian ideograph */
  {"\x92", 0, 0x275A78}, /* East Asian ideograph */
  {"\x91", 0, 0x275B2B}, /* East Asian ideograph */
  {"\xB0", 0, 0x293A46}, /* East Asian ideograph */
  {"\xBF", 0, 0x293A6B}, /* East Asian ideograph */
  {"\x9F", 0, 0x2D5A5F}, /* East Asian ideograph */
  {"\xBB", 0, 0x2D5A7E}, /* East Asian ideograph */
  {"\xAE", 0, 0x2F3A5E}, /* East Asian ideograph */
  {"\xAF", 0, 0x334C37}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page264 = {
  marc8r_31page264_flat, 0
};
/* PAGE 263 */
struct yaz_iconv_trie_flat marc8r_31page263_flat[] = {
  {"\xAB", 0, 0x215A67}, /* East Asian ideograph */
  {"\x90", 0, 0x215A68}, /* East Asian ideograph */
  {"\xA2", 0, 0x215A69}, /* East Asian ideograph */
  {"\x9D", 0, 0x215A6A}, /* East Asian ideograph */
  {"\x8F", 0, 0x215A6B}, /* East Asian ideograph */
  {"\xA9", 0, 0x215A6C}, /* East Asian ideograph */
  {"\x9F", 0, 0x215A6D}, /* East Asian ideograph */
  {"\xB1", 0, 0x215A6F}, /* East Asian ideograph */
  {"\xB4", 0, 0x215A71}, /* East Asian ideograph */
  {"\xB9", 0, 0x215A72}, /* East Asian ideograph */
  {"\xB5", 0, 0x215A73}, /* East Asian ideograph */
  {"\x89", 0, 0x23393F}, /* East Asian ideograph */
  {"\x85", 0, 0x233946}, /* East Asian ideograph */
  {"\x81", 0, 0x233949}, /* East Asian ideograph */
  {"\x84", 0, 0x23394E}, /* East Asian ideograph */
  {"\x86", 0, 0x233950}, /* East Asian ideograph */
  {"\xAA", 0, 0x233952}, /* East Asian ideograph */
  {"\xA3", 0, 0x233954}, /* East Asian ideograph */
  {"\xAE", 0, 0x233957}, /* East Asian ideograph */
  {"\xA1", 0, 0x233958}, /* East Asian ideograph */
  {"\x9E", 0, 0x23395C}, /* East Asian ideograph */
  {"\x96", 0, 0x233964}, /* East Asian ideograph */
  {"\xA6", 0, 0x233966}, /* East Asian ideograph */
  {"\xA7", 0, 0x233967}, /* East Asian ideograph */
  {"\x94", 0, 0x233968}, /* East Asian ideograph */
  {"\x98", 0, 0x233969}, /* East Asian ideograph */
  {"\xB6", 0, 0x233979}, /* East Asian ideograph */
  {"\xBD", 0, 0x23397E}, /* East Asian ideograph */
  {"\xB0", 0, 0x233A21}, /* East Asian ideograph */
  {"\x8A", 0, 0x275A71}, /* East Asian ideograph */
  {"\x8C", 0, 0x275B28}, /* East Asian ideograph */
  {"\xAF", 0, 0x275B2A}, /* East Asian ideograph */
  {"\xAC", 0, 0x293A60}, /* East Asian ideograph */
  {"\x88", 0, 0x334C3E}, /* East Asian ideograph */
  {"\xA8", 0, 0x335A7B}, /* East Asian ideograph */
  {"\xBA", 0, 0x70755D}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page263 = {
  marc8r_31page263_flat, 0
};
/* PAGE 262 */
struct yaz_iconv_trie_flat marc8r_31page262_flat[] = {
  {"\x8E", 0, 0x215A57}, /* East Asian ideograph */
  {"\x9D", 0, 0x215A58}, /* East Asian ideograph */
  {"\x9B", 0, 0x215A59}, /* East Asian ideograph */
  {"\x8B", 0, 0x215A5A}, /* East Asian ideograph */
  {"\x9A", 0, 0x215A5B}, /* East Asian ideograph */
  {"\x86", 0, 0x215A5C}, /* East Asian ideograph */
  {"\x91", 0, 0x215A5D}, /* East Asian ideograph */
  {"\x8C", 0, 0x215A5E}, /* East Asian ideograph */
  {"\xA1", 0, 0x215A5F}, /* East Asian ideograph */
  {"\x9F", 0, 0x215A60}, /* East Asian ideograph */
  {"\xA8", 0, 0x215A61}, /* East Asian ideograph */
  {"\xB3", 0, 0x215A62}, /* East Asian ideograph */
  {"\xBA", 0, 0x215A63}, /* East Asian ideograph */
  {"\xAA", 0, 0x215A64}, /* East Asian ideograph */
  {"\xAF", 0, 0x215A65}, /* East Asian ideograph */
  {"\xBC", 0, 0x215A66}, /* East Asian ideograph */
  {"\x82", 0, 0x233871}, /* East Asian ideograph */
  {"\x81", 0, 0x233872}, /* East Asian ideograph */
  {"\x8F", 0, 0x233921}, /* East Asian ideograph */
  {"\x96", 0, 0x233922}, /* East Asian ideograph */
  {"\x90", 0, 0x233927}, /* East Asian ideograph */
  {"\x85", 0, 0x23392B}, /* East Asian ideograph */
  {"\xA4", 0, 0x23392F}, /* East Asian ideograph */
  {"\xAC", 0, 0x233934}, /* East Asian ideograph */
  {"\xAB", 0, 0x233935}, /* East Asian ideograph */
  {"\xB4", 0, 0x233936}, /* East Asian ideograph */
  {"\xA9", 0, 0x233938}, /* East Asian ideograph */
  {"\xA6", 0, 0x23393A}, /* East Asian ideograph */
  {"\xA3", 0, 0x23393B}, /* East Asian ideograph */
  {"\xA7", 0, 0x23393D}, /* East Asian ideograph */
  {"\xB2", 0, 0x23393E}, /* East Asian ideograph */
  {"\xBD", 0, 0x233941}, /* East Asian ideograph */
  {"\xBF", 0, 0x233944}, /* East Asian ideograph */
  {"\xB5", 0, 0x275A68}, /* East Asian ideograph */
  {"\xB7", 0, 0x275A7E}, /* East Asian ideograph */
  {"\x83", 0, 0x275B29}, /* East Asian ideograph */
  {"\x84", 0, 0x293A2E}, /* East Asian ideograph */
  {"\xB8", 0, 0x293A40}, /* East Asian ideograph */
  {"\xBB", 0, 0x293A57}, /* East Asian ideograph */
  {"\xB9", 0, 0x293A5E}, /* East Asian ideograph */
  {"\x9E", 0, 0x293A5F}, /* East Asian ideograph */
  {"\xA5", 0, 0x2D5A63}, /* East Asian ideograph */
  {"\x97", 0, 0x2F386F}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page262 = {
  marc8r_31page262_flat, 0
};
/* PAGE 261 */
struct yaz_iconv_trie_flat marc8r_31page261_flat[] = {
  {"\x85", 0, 0x215A4C}, /* East Asian ideograph */
  {"\x8A", 0, 0x215A4D}, /* East Asian ideograph */
  {"\x81", 0, 0x215A4E}, /* East Asian ideograph */
  {"\x99", 0, 0x215A4F}, /* East Asian ideograph */
  {"\x95", 0, 0x215A50}, /* East Asian ideograph */
  {"\xA3", 0, 0x215A51}, /* East Asian ideograph */
  {"\x9F", 0, 0x215A52}, /* East Asian ideograph */
  {"\xA8", 0, 0x215A53}, /* East Asian ideograph */
  {"\xB3", 0, 0x215A54}, /* East Asian ideograph */
  {"\xB4", 0, 0x215A55}, /* East Asian ideograph */
  {"\xBE", 0, 0x215A56}, /* East Asian ideograph */
  {"\x84", 0, 0x233761}, /* East Asian ideograph */
  {"\x94", 0, 0x233771}, /* East Asian ideograph */
  {"\x8D", 0, 0x233775}, /* East Asian ideograph */
  {"\x96", 0, 0x233822}, /* East Asian ideograph */
  {"\xA1", 0, 0x23382F}, /* East Asian ideograph */
  {"\xA6", 0, 0x233833}, /* East Asian ideograph */
  {"\xAB", 0, 0x233852}, /* East Asian ideograph */
  {"\xAF", 0, 0x233859}, /* East Asian ideograph */
  {"\xB0", 0, 0x23385A}, /* East Asian ideograph */
  {"\xB2", 0, 0x233866}, /* East Asian ideograph */
  {"\xBC", 0, 0x23386E}, /* East Asian ideograph */
  {"\xBA", 0, 0x23386F}, /* East Asian ideograph */
  {"\xB9", 0, 0x233870}, /* East Asian ideograph */
  {"\xBF", 0, 0x233873}, /* East Asian ideograph */
  {"\x8B", 0, 0x275A53}, /* East Asian ideograph */
  {"\xB8", 0, 0x275B26}, /* East Asian ideograph */
  {"\xB1", 0, 0x293866}, /* East Asian ideograph */
  {"\x82", 0, 0x2D5A4E}, /* East Asian ideograph */
  {"\x91", 0, 0x2F3833}, /* East Asian ideograph */
  {"\xB5", 0, 0x3B3922}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page261 = {
  marc8r_31page261_flat, 0
};
/* PAGE 260 */
struct yaz_iconv_trie_flat marc8r_31page260_flat[] = {
  {"\xA4", 0, 0x215A43}, /* East Asian ideograph */
  {"\xA7", 0, 0x215A44}, /* East Asian ideograph */
  {"\xA6", 0, 0x215A45}, /* East Asian ideograph */
  {"\xAB", 0, 0x215A46}, /* East Asian ideograph */
  {"\xAD", 0, 0x215A47}, /* East Asian ideograph */
  {"\xB0", 0, 0x215A48}, /* East Asian ideograph */
  {"\xB4", 0, 0x215A49}, /* East Asian ideograph */
  {"\xB3", 0, 0x215A4A}, /* East Asian ideograph */
  {"\xB7", 0, 0x215A4B}, /* East Asian ideograph */
  {"\xAC", 0, 0x233748}, /* East Asian ideograph */
  {"\xB8", 0, 0x233752}, /* East Asian ideograph */
  {"\xBA", 0, 0x23375C}, /* East Asian ideograph */
  {"\x85", 0, 0x275A21}, /* East Asian ideograph */
  {"\x84", 0, 0x275A22}, /* East Asian ideograph */
  {"\x80", 0, 0x275A26}, /* East Asian ideograph */
  {"\x81", 0, 0x275A27}, /* East Asian ideograph */
  {"\x82", 0, 0x275A28}, /* East Asian ideograph */
  {"\x88", 0, 0x275A2A}, /* East Asian ideograph */
  {"\x8A", 0, 0x275A2B}, /* East Asian ideograph */
  {"\x94", 0, 0x275A2C}, /* East Asian ideograph */
  {"\x8B", 0, 0x275A2D}, /* East Asian ideograph */
  {"\x8F", 0, 0x275A32}, /* East Asian ideograph */
  {"\x90", 0, 0x275A33}, /* East Asian ideograph */
  {"\x8C", 0, 0x275A35}, /* East Asian ideograph */
  {"\x96", 0, 0x275A36}, /* East Asian ideograph */
  {"\x9B", 0, 0x275A37}, /* East Asian ideograph */
  {"\x9A", 0, 0x275A38}, /* East Asian ideograph */
  {"\x98", 0, 0x275A39}, /* East Asian ideograph */
  {"\xA0", 0, 0x275A3B}, /* East Asian ideograph */
  {"\x9D", 0, 0x275A3C}, /* East Asian ideograph */
  {"\x9E", 0, 0x275A3D}, /* East Asian ideograph */
  {"\xA2", 0, 0x275A3E}, /* East Asian ideograph */
  {"\xA1", 0, 0x275A3F}, /* East Asian ideograph */
  {"\x83", 0, 0x275A40}, /* East Asian ideograph */
  {"\x8E", 0, 0x275A41}, /* East Asian ideograph */
  {"\xA3", 0, 0x275A42}, /* East Asian ideograph */
  {"\xB5", 0, 0x275A4F}, /* East Asian ideograph */
  {"\xB6", 0, 0x275A50}, /* East Asian ideograph */
  {"\x87", 0, 0x29365F}, /* East Asian ideograph */
  {"\x93", 0, 0x29366A}, /* East Asian ideograph */
  {"\x95", 0, 0x29366B}, /* East Asian ideograph */
  {"\x89", 0, 0x293670}, /* East Asian ideograph */
  {"\x99", 0, 0x29367E}, /* East Asian ideograph */
  {"\x9C", 0, 0x293726}, /* East Asian ideograph */
  {"\x86", 0, 0x29373A}, /* East Asian ideograph */
  {"\xB1", 0, 0x2D5A48}, /* East Asian ideograph */
  {"\x8D", 0, 0x47366F}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page260 = {
  marc8r_31page260_flat, 0
};
/* PAGE 259 */
struct yaz_iconv_trie_dir marc8r_31page259_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x233725} /* East Asian ideograph */,
  {0, 0, 0x215A39} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x23372B} /* East Asian ideograph */,
  {0, 0, 0x215A3B} /* East Asian ideograph (variant of EACC 4B5A3B) */,
  {0, 0, 0x23372D} /* East Asian ideograph */,
  {0, 0, 0x215A3D} /* East Asian ideograph */,
  {0, 0, 0x215A3C} /* East Asian ideograph */,
  {0, 0, 0x233732} /* East Asian ideograph */,
  {0, 0, 0x215A3F} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x215A3E} /* East Asian ideograph */,
  {0, 0, 0x23373A} /* East Asian ideograph */,
  {0, 0, 0x233739} /* East Asian ideograph */,
  {0, 0, 0x23373B} /* East Asian ideograph */,
  {0, 0, 0x215A40} /* East Asian ideograph */,
  {0, 0, 0x23373D} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x215A41} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x23373E} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x215A42} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x275968} /* East Asian ideograph */,
  {0, 0, 0x275969} /* East Asian ideograph */,
  {0, 0, 0x27596A} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x27596B} /* East Asian ideograph */,
  {0, 0, 0x27596C} /* East Asian ideograph */,
  {0, 0, 0x27596D} /* East Asian ideograph */,
  {0, 0, 0x275A30} /* East Asian ideograph */,
  {0, 0, 0x274247} /* East Asian ideograph */,
  {0, 0, 0x393C52} /* East Asian ideograph */,
  {0, 0, 0x27596F} /* East Asian ideograph */,
  {0, 0, 0x275A34} /* East Asian ideograph */,
  {0, 0, 0x275972} /* East Asian ideograph */,
  {0, 0, 0x275970} /* East Asian ideograph */,
  {0, 0, 0x275971} /* East Asian ideograph */,
  {0, 0, 0x27597B} /* East Asian ideograph */,
  {0, 0, 0x275A3A} /* East Asian ideograph */,
  {0, 0, 0x4B5973} /* East Asian ideograph */,
  {0, 0, 0x27596E} /* East Asian ideograph */,
  {0, 0, 0x453051} /* East Asian ideograph */,
  {0, 0, 0x275A31} /* East Asian ideograph */,
  {0, 0, 0x275976} /* East Asian ideograph */,
  {0, 0, 0x29364E} /* East Asian ideograph */,
  {0, 0, 0x275979} /* East Asian ideograph */,
  {0, 0, 0x275978} /* East Asian ideograph */,
  {0, 0, 0x293651} /* East Asian ideograph */,
  {0, 0, 0x27597D} /* East Asian ideograph */,
  {0, 0, 0x27597E} /* East Asian ideograph */,
  {0, 0, 0x275975} /* East Asian ideograph */,
  {0, 0, 0x275977} /* East Asian ideograph */,
  {0, 0, 0x27597C} /* East Asian ideograph */,
  {0, 0, 0x275A23} /* East Asian ideograph */,
  {0, 0, 0x293725} /* East Asian ideograph */,
  {0, 0, 0x275A24} /* East Asian ideograph */,
  {0, 0, 0x275A25} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page259 = {
  0, marc8r_31page259_dir
};
/* PAGE 258 */
struct yaz_iconv_trie_flat marc8r_31page258_flat[] = {
  {"\x81", 0, 0x215976}, /* East Asian ideograph */
  {"\x80", 0, 0x215977}, /* East Asian ideograph */
  {"\x85", 0, 0x215A21}, /* East Asian ideograph */
  {"\x87", 0, 0x215A22}, /* East Asian ideograph */
  {"\x8A", 0, 0x215A23}, /* East Asian ideograph */
  {"\x88", 0, 0x215A24}, /* East Asian ideograph */
  {"\x84", 0, 0x215A25}, /* East Asian ideograph */
  {"\x83", 0, 0x215A27}, /* East Asian ideograph */
  {"\x82", 0, 0x215A28}, /* East Asian ideograph */
  {"\x93", 0, 0x215A29}, /* East Asian ideograph */
  {"\x91", 0, 0x215A2A}, /* East Asian ideograph */
  {"\x92", 0, 0x215A2B}, /* East Asian ideograph */
  {"\xA0", 0, 0x215A2C}, /* East Asian ideograph */
  {"\xA6", 0, 0x215A2D}, /* East Asian ideograph */
  {"\xA3", 0, 0x215A2F}, /* East Asian ideograph */
  {"\xA2", 0, 0x215A30}, /* East Asian ideograph */
  {"\xA4", 0, 0x215A31}, /* East Asian ideograph */
  {"\x9E", 0, 0x215A32}, /* East Asian ideograph */
  {"\x9C", 0, 0x215A33}, /* East Asian ideograph */
  {"\xAA", 0, 0x215A34}, /* East Asian ideograph */
  {"\xAD", 0, 0x215A35}, /* East Asian ideograph */
  {"\xB4", 0, 0x215A36}, /* East Asian ideograph */
  {"\xBD", 0, 0x215A37}, /* East Asian ideograph */
  {"\xBA", 0, 0x215A38}, /* East Asian ideograph */
  {"\xBC", 0, 0x215A3A}, /* East Asian ideograph */
  {"\x8D", 0, 0x233657}, /* East Asian ideograph */
  {"\x98", 0, 0x23365E}, /* East Asian ideograph */
  {"\x95", 0, 0x23365F}, /* East Asian ideograph */
  {"\xA8", 0, 0x233667}, /* East Asian ideograph */
  {"\xA9", 0, 0x233668}, /* East Asian ideograph */
  {"\xA1", 0, 0x23366A}, /* East Asian ideograph */
  {"\xAB", 0, 0x23366F}, /* East Asian ideograph */
  {"\x9A", 0, 0x233670}, /* East Asian ideograph */
  {"\x9D", 0, 0x233672}, /* East Asian ideograph */
  {"\x99", 0, 0x233674}, /* East Asian ideograph */
  {"\xAE", 0, 0x233676}, /* East Asian ideograph */
  {"\xB1", 0, 0x23367B}, /* East Asian ideograph */
  {"\xB5", 0, 0x23367C}, /* East Asian ideograph */
  {"\xBB", 0, 0x23367E}, /* East Asian ideograph */
  {"\xB7", 0, 0x233721}, /* East Asian ideograph */
  {"\xBE", 0, 0x233726}, /* East Asian ideograph */
  {"\xB8", 0, 0x2D3377}, /* East Asian ideograph */
  {"\x9B", 0, 0x2D5A3D}, /* East Asian ideograph */
  {"\xAC", 0, 0x333C52}, /* East Asian ideograph */
  {"\x89", 0, 0x393E47}, /* East Asian ideograph */
  {"\x8E", 0, 0x4B5A31}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page258 = {
  marc8r_31page258_flat, 0
};
/* PAGE 257 */
struct yaz_iconv_trie_flat marc8r_31page257_flat[] = {
  {"\x82", 0, 0x215962}, /* East Asian ideograph */
  {"\x8A", 0, 0x215963}, /* East Asian ideograph */
  {"\x89", 0, 0x215964}, /* East Asian ideograph */
  {"\x8D", 0, 0x215965}, /* East Asian ideograph */
  {"\x8C", 0, 0x215966}, /* East Asian ideograph */
  {"\x93", 0, 0x215967}, /* East Asian ideograph */
  {"\x9D", 0, 0x215968}, /* East Asian ideograph */
  {"\x9E", 0, 0x215969}, /* East Asian ideograph */
  {"\xA0", 0, 0x21596A}, /* East Asian ideograph */
  {"\xA2", 0, 0x21596B}, /* East Asian ideograph */
  {"\xA1", 0, 0x21596C}, /* East Asian ideograph */
  {"\xAC", 0, 0x21596D}, /* East Asian ideograph */
  {"\xAB", 0, 0x21596E}, /* East Asian ideograph */
  {"\xA8", 0, 0x21596F}, /* East Asian ideograph */
  {"\xAA", 0, 0x215970}, /* East Asian ideograph */
  {"\xA7", 0, 0x215971}, /* East Asian ideograph */
  {"\xA9", 0, 0x215972}, /* East Asian ideograph */
  {"\xAF", 0, 0x215973}, /* East Asian ideograph */
  {"\xBB", 0, 0x215975}, /* East Asian ideograph */
  {"\xB4", 0, 0x215978}, /* East Asian ideograph */
  {"\xBC", 0, 0x215979}, /* East Asian ideograph */
  {"\xB7", 0, 0x21597A}, /* East Asian ideograph */
  {"\xB6", 0, 0x21597B}, /* East Asian ideograph */
  {"\xBD", 0, 0x21597C}, /* East Asian ideograph */
  {"\xB8", 0, 0x21597D}, /* East Asian ideograph */
  {"\xBF", 0, 0x21597E}, /* East Asian ideograph */
  {"\xB2", 0, 0x215A26}, /* East Asian ideograph */
  {"\x86", 0, 0x23362A}, /* East Asian ideograph */
  {"\x85", 0, 0x23362D}, /* East Asian ideograph */
  {"\x88", 0, 0x23362E}, /* East Asian ideograph */
  {"\x94", 0, 0x233639}, /* East Asian ideograph */
  {"\x9B", 0, 0x233641}, /* East Asian ideograph */
  {"\x9F", 0, 0x233643}, /* East Asian ideograph */
  {"\xA4", 0, 0x233644}, /* East Asian ideograph */
  {"\xB0", 0, 0x23364E}, /* East Asian ideograph */
  {"\xBA", 0, 0x233651}, /* East Asian ideograph */
  {"\xB5", 0, 0x233652}, /* East Asian ideograph */
  {"\xB9", 0, 0x233653}, /* East Asian ideograph */
  {"\x98", 0, 0x2D5963}, /* East Asian ideograph */
  {"\xAD", 0, 0x2D5A34}, /* East Asian ideograph */
  {"\xB3", 0, 0x333051}, /* East Asian ideograph */
  {"\x8E", 0, 0x355D5C}, /* East Asian ideograph */
  {"\xAE", 0, 0x513051}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page257 = {
  marc8r_31page257_flat, 0
};
/* PAGE 256 */
struct yaz_iconv_trie_dir marc8r_31page256_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x29333B} /* East Asian ideograph */,
  {0, 0, 0x275922} /* East Asian ideograph */,
  {0, 0, 0x293340} /* East Asian ideograph */,
  {0, 0, 0x27587D} /* East Asian ideograph */,
  {0, 0, 0x275921} /* East Asian ideograph */,
  {0, 0, 0x275878} /* East Asian ideograph */,
  {0, 0, 0x275877} /* East Asian ideograph */,
  {0, 0, 0x29327E} /* East Asian ideograph */,
  {0, 0, 0x275879} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x275876} /* East Asian ideograph */,
  {0, 0, 0x27592B} /* East Asian ideograph */,
  {0, 0, 0x29334E} /* East Asian ideograph */,
  {0, 0, 0x27592A} /* East Asian ideograph */,
  {0, 0, 0x275935} /* East Asian ideograph */,
  {0, 0, 0x275927} /* East Asian ideograph */,
  {0, 0, 0x275929} /* East Asian ideograph */,
  {0, 0, 0x293359} /* East Asian ideograph */,
  {0, 0, 0x27592C} /* East Asian ideograph */,
  {0, 0, 0x27592D} /* East Asian ideograph */,
  {0, 0, 0x293357} /* East Asian ideograph */,
  {0, 0, 0x275930} /* East Asian ideograph */,
  {0, 0, 0x29335D} /* East Asian ideograph */,
  {0, 0, 0x27594E} /* East Asian ideograph */,
  {0, 0, 0x4B3622} /* East Asian ideograph */,
  {0, 0, 0x293344} /* East Asian ideograph */,
  {0, 0, 0x275926} /* East Asian ideograph */,
  {0, 0, 0x275925} /* East Asian ideograph */,
  {0, 0, 0x275933} /* East Asian ideograph */,
  {0, 0, 0x293362} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x27593B} /* East Asian ideograph */,
  {0, 0, 0x293537} /* East Asian ideograph */,
  {0, 0, 0x293373} /* East Asian ideograph */,
  {0, 0, 0x275938} /* East Asian ideograph */,
  {0, 0, 0x275936} /* East Asian ideograph */,
  {0, 0, 0x275931} /* East Asian ideograph */,
  {0, 0, 0x4D3363} /* East Asian ideograph */,
  {0, 0, 0x275932} /* East Asian ideograph */,
  {0, 0, 0x29337D} /* East Asian ideograph */,
  {0, 0, 0x275939} /* East Asian ideograph */,
  {0, 0, 0x293438} /* East Asian ideograph */,
  {0, 0, 0x473422} /* East Asian ideograph */,
  {0, 0, 0x47347B} /* East Asian ideograph */,
  {0, 0, 0x27593A} /* East Asian ideograph */,
  {0, 0, 0x275940} /* East Asian ideograph */,
  {0, 0, 0x29344D} /* East Asian ideograph */,
  {0, 0, 0x293459} /* East Asian ideograph */,
  {0, 0, 0x29352D} /* East Asian ideograph */,
  {0, 0, 0x27593D} /* East Asian ideograph */,
  {0, 0, 0x27593E} /* East Asian ideograph */,
  {0, 0, 0x293539} /* East Asian ideograph */,
  {0, 0, 0x275947} /* East Asian ideograph */,
  {0, 0, 0x293468} /* East Asian ideograph */,
  {0, 0, 0x27594D} /* East Asian ideograph */,
  {0, 0, 0x274F40} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x23353D} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x215952} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page256 = {
  0, marc8r_31page256_dir
};
/* PAGE 255 */
struct yaz_iconv_trie_flat marc8r_31page255_flat[] = {
  {"\x81", 0, 0x215951}, /* East Asian ideograph */
  {"\x86", 0, 0x215953}, /* East Asian ideograph */
  {"\x88", 0, 0x215954}, /* East Asian ideograph */
  {"\x89", 0, 0x215955}, /* East Asian ideograph */
  {"\x8C", 0, 0x215956}, /* East Asian ideograph */
  {"\x8E", 0, 0x215957}, /* East Asian ideograph */
  {"\x90", 0, 0x215958}, /* East Asian ideograph */
  {"\x94", 0, 0x215959}, /* East Asian ideograph */
  {"\x9A", 0, 0x21595A}, /* East Asian ideograph */
  {"\xA2", 0, 0x21595C}, /* East Asian ideograph */
  {"\xAA", 0, 0x21595D}, /* East Asian ideograph */
  {"\xAB", 0, 0x21595E}, /* East Asian ideograph */
  {"\xAC", 0, 0x21595F}, /* East Asian ideograph */
  {"\xBA", 0, 0x215960}, /* East Asian ideograph */
  {"\xB9", 0, 0x215961}, /* East Asian ideograph */
  {"\x80", 0, 0x233544}, /* East Asian ideograph */
  {"\x82", 0, 0x233545}, /* East Asian ideograph */
  {"\x87", 0, 0x23354B}, /* East Asian ideograph */
  {"\x8B", 0, 0x23354D}, /* East Asian ideograph */
  {"\x8F", 0, 0x233550}, /* East Asian ideograph */
  {"\x95", 0, 0x233552}, /* East Asian ideograph */
  {"\x97", 0, 0x233554}, /* East Asian ideograph */
  {"\x9C", 0, 0x233555}, /* East Asian ideograph */
  {"\x9D", 0, 0x233556}, /* East Asian ideograph */
  {"\xA8", 0, 0x233563}, /* East Asian ideograph */
  {"\xAD", 0, 0x233565}, /* East Asian ideograph */
  {"\xB3", 0, 0x23356D}, /* East Asian ideograph */
  {"\xB4", 0, 0x23356F}, /* East Asian ideograph */
  {"\xB5", 0, 0x233571}, /* East Asian ideograph */
  {"\xB7", 0, 0x233573}, /* East Asian ideograph */
  {"\xB6", 0, 0x233574}, /* East Asian ideograph */
  {"\xB8", 0, 0x23357B}, /* East Asian ideograph */
  {"\xBB", 0, 0x23357D}, /* East Asian ideograph */
  {"\xA1", 0, 0x273257}, /* East Asian ideograph */
  {"\xBC", 0, 0x2F3639}, /* East Asian ideograph */
  {"\x8A", 0, 0x335958}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page255 = {
  marc8r_31page255_flat, 0
};
/* PAGE 254 */
struct yaz_iconv_trie_flat marc8r_31page254_flat[] = {
  {"\x80", 0, 0x21594A}, /* East Asian ideograph */
  {"\x8A", 0, 0x21594B}, /* East Asian ideograph */
  {"\x93", 0, 0x21594C}, /* East Asian ideograph */
  {"\x96", 0, 0x21594D}, /* East Asian ideograph */
  {"\x92", 0, 0x21594E}, /* East Asian ideograph */
  {"\x9A", 0, 0x21594F}, /* East Asian ideograph */
  {"\x85", 0, 0x233478}, /* East Asian ideograph */
  {"\x81", 0, 0x233479}, /* East Asian ideograph */
  {"\x8B", 0, 0x233523}, /* East Asian ideograph */
  {"\x87", 0, 0x233526}, /* East Asian ideograph */
  {"\x95", 0, 0x23352D}, /* East Asian ideograph */
  {"\x94", 0, 0x23352E}, /* East Asian ideograph */
  {"\x9C", 0, 0x233537}, /* East Asian ideograph */
  {"\x9F", 0, 0x23353A}, /* East Asian ideograph */
  {"\xA1", 0, 0x275838}, /* East Asian ideograph */
  {"\xA2", 0, 0x275839}, /* East Asian ideograph */
  {"\xA3", 0, 0x27583A}, /* East Asian ideograph */
  {"\xA6", 0, 0x27583B}, /* East Asian ideograph */
  {"\xB0", 0, 0x27583C}, /* East Asian ideograph */
  {"\xA8", 0, 0x27583D}, /* East Asian ideograph */
  {"\xA7", 0, 0x27583E}, /* East Asian ideograph */
  {"\xAA", 0, 0x27583F}, /* East Asian ideograph */
  {"\xAF", 0, 0x275840}, /* East Asian ideograph */
  {"\xAB", 0, 0x275841}, /* East Asian ideograph */
  {"\xAD", 0, 0x275843}, /* East Asian ideograph */
  {"\xBF", 0, 0x275844}, /* East Asian ideograph */
  {"\xB6", 0, 0x275846}, /* East Asian ideograph */
  {"\xB7", 0, 0x275847}, /* East Asian ideograph */
  {"\xB8", 0, 0x275848}, /* East Asian ideograph */
  {"\xBE", 0, 0x275849}, /* East Asian ideograph */
  {"\xB9", 0, 0x27584A}, /* East Asian ideograph */
  {"\xBC", 0, 0x27584B}, /* East Asian ideograph */
  {"\xA4", 0, 0x275870}, /* East Asian ideograph */
  {"\xBA", 0, 0x275924}, /* East Asian ideograph */
  {"\xB3", 0, 0x275928}, /* East Asian ideograph */
  {"\xBD", 0, 0x27592F}, /* East Asian ideograph */
  {"\xB2", 0, 0x275934}, /* East Asian ideograph */
  {"\xA5", 0, 0x275942}, /* East Asian ideograph */
  {"\xAE", 0, 0x275943}, /* East Asian ideograph */
  {"\xA9", 0, 0x27594C}, /* East Asian ideograph */
  {"\xB5", 0, 0x29322A}, /* East Asian ideograph */
  {"\xB4", 0, 0x293430}, /* East Asian ideograph */
  {"\x8E", 0, 0x2D306C}, /* East Asian ideograph */
  {"\x8C", 0, 0x2D4A28}, /* East Asian ideograph */
  {"\x83", 0, 0x2D594F}, /* East Asian ideograph */
  {"\x90", 0, 0x33306C}, /* East Asian ideograph */
  {"\x99", 0, 0x334621}, /* East Asian ideograph */
  {"\xA0", 0, 0x455837}, /* East Asian ideograph */
  {"\x9E", 0, 0x473539}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page254 = {
  marc8r_31page254_flat, 0
};
/* PAGE 253 */
struct yaz_iconv_trie_flat marc8r_31page253_flat[] = {
  {"\x98", 0, 0x21593C}, /* East Asian ideograph */
  {"\x9C", 0, 0x21593D}, /* East Asian ideograph */
  {"\x8E", 0, 0x21593E}, /* East Asian ideograph */
  {"\x89", 0, 0x21593F}, /* East Asian ideograph */
  {"\x9A", 0, 0x215940}, /* East Asian ideograph */
  {"\x81", 0, 0x215941}, /* East Asian ideograph */
  {"\x8F", 0, 0x215942}, /* East Asian ideograph */
  {"\xB0", 0, 0x215943}, /* East Asian ideograph */
  {"\xAC", 0, 0x215944}, /* East Asian ideograph */
  {"\xA6", 0, 0x215945}, /* East Asian ideograph */
  {"\xAF", 0, 0x215946}, /* East Asian ideograph */
  {"\xB4", 0, 0x215947}, /* East Asian ideograph */
  {"\xB7", 0, 0x215948}, /* East Asian ideograph */
  {"\xBD", 0, 0x215949}, /* East Asian ideograph */
  {"\x8C", 0, 0x233349}, /* East Asian ideograph */
  {"\x88", 0, 0x233442}, /* East Asian ideograph */
  {"\x94", 0, 0x233444}, /* East Asian ideograph */
  {"\x93", 0, 0x233448}, /* East Asian ideograph */
  {"\x8A", 0, 0x233449}, /* East Asian ideograph */
  {"\x86", 0, 0x23344A}, /* East Asian ideograph */
  {"\x96", 0, 0x23344D}, /* East Asian ideograph */
  {"\x99", 0, 0x233459}, /* East Asian ideograph */
  {"\x8D", 0, 0x23345F}, /* East Asian ideograph */
  {"\xAB", 0, 0x233468}, /* East Asian ideograph */
  {"\xAD", 0, 0x23346B}, /* East Asian ideograph */
  {"\xB8", 0, 0x233470}, /* East Asian ideograph */
  {"\x85", 0, 0x233473}, /* East Asian ideograph */
  {"\xBE", 0, 0x23347B}, /* East Asian ideograph */
  {"\x9F", 0, 0x2D3748}, /* East Asian ideograph */
  {"\xB2", 0, 0x2D594C}, /* East Asian ideograph */
  {"\xB1", 0, 0x33523F}, /* East Asian ideograph */
  {"\x9B", 0, 0x35344D}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page253 = {
  marc8r_31page253_flat, 0
};
/* PAGE 252 */
struct yaz_iconv_trie_flat marc8r_31page252_flat[] = {
  {"\x80", 0, 0x21592B}, /* East Asian ideograph */
  {"\x81", 0, 0x21592C}, /* East Asian ideograph (variant of EACC 2D592C) */
  {"\x82", 0, 0x21592D}, /* East Asian ideograph */
  {"\x97", 0, 0x215931}, /* East Asian ideograph */
  {"\x99", 0, 0x215932}, /* East Asian ideograph */
  {"\x8E", 0, 0x215933}, /* East Asian ideograph */
  {"\x9B", 0, 0x215934}, /* East Asian ideograph */
  {"\x8A", 0, 0x215935}, /* East Asian ideograph */
  {"\xA1", 0, 0x215936}, /* East Asian ideograph */
  {"\x84", 0, 0x215937}, /* East Asian ideograph */
  {"\x9D", 0, 0x215938}, /* East Asian ideograph */
  {"\xB9", 0, 0x215939}, /* East Asian ideograph */
  {"\xAC", 0, 0x21593A}, /* East Asian ideograph */
  {"\xA8", 0, 0x21593B}, /* East Asian ideograph */
  {"\x83", 0, 0x233356}, /* East Asian ideograph */
  {"\x94", 0, 0x233359}, /* East Asian ideograph */
  {"\x87", 0, 0x233364}, /* East Asian ideograph */
  {"\x8C", 0, 0x23336B}, /* East Asian ideograph */
  {"\x9C", 0, 0x23336F}, /* East Asian ideograph */
  {"\x96", 0, 0x233373}, /* East Asian ideograph */
  {"\x9F", 0, 0x233376}, /* East Asian ideograph */
  {"\x8B", 0, 0x233378}, /* East Asian ideograph */
  {"\x86", 0, 0x233379}, /* East Asian ideograph */
  {"\x85", 0, 0x23337A}, /* East Asian ideograph */
  {"\x8F", 0, 0x23337C}, /* East Asian ideograph */
  {"\x90", 0, 0x23337D}, /* East Asian ideograph */
  {"\xAB", 0, 0x233422}, /* East Asian ideograph */
  {"\xB7", 0, 0x23342A}, /* East Asian ideograph */
  {"\xA6", 0, 0x23342D}, /* East Asian ideograph */
  {"\xB3", 0, 0x233430}, /* East Asian ideograph */
  {"\xBE", 0, 0x233438}, /* East Asian ideograph */
  {"\xA9", 0, 0x23343A}, /* East Asian ideograph */
  {"\xBF", 0, 0x23344F}, /* East Asian ideograph */
  {"\x9A", 0, 0x2F3363}, /* East Asian ideograph */
  {"\xAD", 0, 0x35347B}, /* East Asian ideograph */
  {"\xBC", 0, 0x3F3573}, /* East Asian ideograph */
  {"\xA0", 0, 0x4B5936}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page252 = {
  marc8r_31page252_flat, 0
};
/* PAGE 251 */
struct yaz_iconv_trie_flat marc8r_31page251_flat[] = {
  {"\x84", 0, 0x215877}, /* East Asian ideograph */
  {"\x92", 0, 0x215878}, /* East Asian ideograph */
  {"\x87", 0, 0x215879}, /* East Asian ideograph */
  {"\x8B", 0, 0x21587A}, /* East Asian ideograph (variant of EACC 4B587A) */
  {"\xB8", 0, 0x21587B}, /* East Asian ideograph */
  {"\x89", 0, 0x21587E}, /* East Asian ideograph */
  {"\x82", 0, 0x215921}, /* East Asian ideograph */
  {"\x96", 0, 0x215924}, /* East Asian ideograph */
  {"\xA6", 0, 0x215925}, /* East Asian ideograph */
  {"\xBA", 0, 0x215926}, /* East Asian ideograph */
  {"\xAB", 0, 0x215927}, /* East Asian ideograph */
  {"\xB1", 0, 0x215928}, /* East Asian ideograph */
  {"\xA7", 0, 0x215929}, /* East Asian ideograph */
  {"\x9C", 0, 0x21592A}, /* East Asian ideograph */
  {"\xBE", 0, 0x21592E}, /* East Asian ideograph */
  {"\xB7", 0, 0x21592F}, /* East Asian ideograph */
  {"\xAD", 0, 0x215930}, /* East Asian ideograph */
  {"\x8F", 0, 0x233325}, /* East Asian ideograph */
  {"\x86", 0, 0x233327}, /* East Asian ideograph */
  {"\x91", 0, 0x23332C}, /* East Asian ideograph */
  {"\x93", 0, 0x23332D}, /* East Asian ideograph */
  {"\x94", 0, 0x233333}, /* East Asian ideograph */
  {"\x8D", 0, 0x233336}, /* East Asian ideograph */
  {"\x9B", 0, 0x23333B}, /* East Asian ideograph */
  {"\x90", 0, 0x23333F}, /* East Asian ideograph */
  {"\x97", 0, 0x233340}, /* East Asian ideograph */
  {"\xB3", 0, 0x233344}, /* East Asian ideograph */
  {"\xA2", 0, 0x233345}, /* East Asian ideograph */
  {"\x9D", 0, 0x23334C}, /* East Asian ideograph */
  {"\xB6", 0, 0x23334E}, /* East Asian ideograph */
  {"\xB4", 0, 0x23334F}, /* East Asian ideograph */
  {"\xB5", 0, 0x233350}, /* East Asian ideograph */
  {"\x9F", 0, 0x233353}, /* East Asian ideograph */
  {"\xA4", 0, 0x233357}, /* East Asian ideograph */
  {"\xBC", 0, 0x23335D}, /* East Asian ideograph */
  {"\x9E", 0, 0x233362}, /* East Asian ideograph */
  {"\xA1", 0, 0x233363}, /* East Asian ideograph */
  {"\xAE", 0, 0x2D3622}, /* East Asian ideograph */
  {"\x8C", 0, 0x2D5927}, /* East Asian ideograph */
  {"\xA9", 0, 0x2D593D}, /* East Asian ideograph */
  {"\xA0", 0, 0x39365A}, /* East Asian ideograph */
  {"\x9A", 0, 0x696B5C}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page251 = {
  marc8r_31page251_flat, 0
};
/* PAGE 250 */
struct yaz_iconv_trie_flat marc8r_31page250_flat[] = {
  {"\xA0", 0, 0x215860}, /* East Asian ideograph */
  {"\x87", 0, 0x215861}, /* East Asian ideograph */
  {"\x85", 0, 0x215862}, /* East Asian ideograph */
  {"\xAA", 0, 0x215869}, /* East Asian ideograph */
  {"\xA6", 0, 0x21586A}, /* East Asian ideograph */
  {"\xA1", 0, 0x21586B}, /* East Asian ideograph */
  {"\x9E", 0, 0x21586C}, /* East Asian ideograph */
  {"\x8C", 0, 0x21586D}, /* East Asian ideograph */
  {"\x93", 0, 0x21586E}, /* East Asian ideograph */
  {"\xA3", 0, 0x21586F}, /* East Asian ideograph */
  {"\x8D", 0, 0x215870}, /* East Asian ideograph */
  {"\xA4", 0, 0x215871}, /* East Asian ideograph (variant of EACC 4B5871) */
  {"\xA8", 0, 0x215872}, /* East Asian ideograph */
  {"\xA5", 0, 0x215873}, /* East Asian ideograph */
  {"\x98", 0, 0x215874}, /* East Asian ideograph */
  {"\x91", 0, 0x215875}, /* East Asian ideograph */
  {"\xBC", 0, 0x215876}, /* East Asian ideograph */
  {"\xB2", 0, 0x21587C}, /* East Asian ideograph */
  {"\xBF", 0, 0x21587D}, /* East Asian ideograph */
  {"\xB0", 0, 0x215922}, /* East Asian ideograph */
  {"\x95", 0, 0x215923}, /* East Asian ideograph */
  {"\x86", 0, 0x233250}, /* East Asian ideograph */
  {"\x82", 0, 0x233259}, /* East Asian ideograph */
  {"\x84", 0, 0x23325D}, /* East Asian ideograph */
  {"\x8F", 0, 0x233269}, /* East Asian ideograph */
  {"\x96", 0, 0x23326F}, /* East Asian ideograph */
  {"\x9A", 0, 0x233271}, /* East Asian ideograph */
  {"\xB6", 0, 0x23327E}, /* East Asian ideograph */
  {"\xBE", 0, 0x233321}, /* East Asian ideograph */
  {"\xAF", 0, 0x233331}, /* East Asian ideograph */
  {"\xB9", 0, 0x233338}, /* East Asian ideograph */
  {"\x8A", 0, 0x275937}, /* East Asian ideograph */
  {"\x89", 0, 0x275949}, /* East Asian ideograph */
  {"\x92", 0, 0x333642}, /* East Asian ideograph */
  {"\xAD", 0, 0x4B594A}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page250 = {
  marc8r_31page250_flat, 0
};
/* PAGE 249 */
struct yaz_iconv_trie_flat marc8r_31page249_flat[] = {
  {"\xA0", 0, 0x21584D}, /* East Asian ideograph */
  {"\x95", 0, 0x21584E}, /* East Asian ideograph */
  {"\x9E", 0, 0x21584F}, /* East Asian ideograph */
  {"\x81", 0, 0x215851}, /* East Asian ideograph */
  {"\x94", 0, 0x215852}, /* East Asian ideograph */
  {"\x9B", 0, 0x215853}, /* East Asian ideograph */
  {"\x90", 0, 0x215854}, /* East Asian ideograph */
  {"\x86", 0, 0x215855}, /* East Asian ideograph */
  {"\xAB", 0, 0x215858}, /* East Asian ideograph */
  {"\xB2", 0, 0x215859}, /* East Asian ideograph */
  {"\xB3", 0, 0x21585A}, /* East Asian ideograph */
  {"\xA6", 0, 0x21585B}, /* East Asian ideograph */
  {"\xA9", 0, 0x21585C}, /* East Asian ideograph */
  {"\xB0", 0, 0x21585D}, /* East Asian ideograph */
  {"\xA3", 0, 0x21585E}, /* East Asian ideograph */
  {"\xBC", 0, 0x21585F}, /* East Asian ideograph */
  {"\xAD", 0, 0x215863}, /* East Asian ideograph */
  {"\xB9", 0, 0x215864}, /* East Asian ideograph */
  {"\xA2", 0, 0x215865}, /* East Asian ideograph */
  {"\xB1", 0, 0x215866}, /* East Asian ideograph */
  {"\xAE", 0, 0x215867}, /* East Asian ideograph */
  {"\xAC", 0, 0x215868}, /* East Asian ideograph */
  {"\x91", 0, 0x233227}, /* East Asian ideograph */
  {"\x8A", 0, 0x233228}, /* East Asian ideograph */
  {"\x8E", 0, 0x23322A}, /* East Asian ideograph */
  {"\x96", 0, 0x233230}, /* East Asian ideograph */
  {"\x97", 0, 0x233237}, /* East Asian ideograph */
  {"\x88", 0, 0x233239}, /* East Asian ideograph */
  {"\x98", 0, 0x23323B}, /* East Asian ideograph */
  {"\x92", 0, 0x23323C}, /* East Asian ideograph */
  {"\x85", 0, 0x233242}, /* East Asian ideograph */
  {"\xBF", 0, 0x23324F}, /* East Asian ideograph */
  {"\xA1", 0, 0x233256}, /* East Asian ideograph */
  {"\xB5", 0, 0x23325E}, /* East Asian ideograph */
  {"\xBB", 0, 0x2D3632}, /* East Asian ideograph */
  {"\xA7", 0, 0x2D3B33}, /* East Asian ideograph */
  {"\xBE", 0, 0x2F317D}, /* East Asian ideograph */
  {"\xB6", 0, 0x335D23}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page249 = {
  marc8r_31page249_flat, 0
};
/* PAGE 248 */
struct yaz_iconv_trie_flat marc8r_31page248_flat[] = {
  {"\x80", 0, 0x215837}, /* East Asian ideograph */
  {"\x88", 0, 0x215838}, /* East Asian ideograph */
  {"\x82", 0, 0x215839}, /* East Asian ideograph */
  {"\x83", 0, 0x21583A}, /* East Asian ideograph */
  {"\x90", 0, 0x21583B}, /* East Asian ideograph */
  {"\x98", 0, 0x21583C}, /* East Asian ideograph */
  {"\x8E", 0, 0x21583D}, /* East Asian ideograph */
  {"\x8C", 0, 0x21583E}, /* East Asian ideograph */
  {"\x95", 0, 0x21583F}, /* East Asian ideograph */
  {"\x8A", 0, 0x215840}, /* East Asian ideograph */
  {"\x96", 0, 0x215841}, /* East Asian ideograph */
  {"\x97", 0, 0x215842}, /* East Asian ideograph */
  {"\x93", 0, 0x215843}, /* East Asian ideograph */
  {"\xAA", 0, 0x215844}, /* East Asian ideograph */
  {"\xA3", 0, 0x215845}, /* East Asian ideograph */
  {"\x9D", 0, 0x215846}, /* East Asian ideograph */
  {"\xA5", 0, 0x215847}, /* East Asian ideograph */
  {"\xB1", 0, 0x215848}, /* East Asian ideograph */
  {"\xAD", 0, 0x215849}, /* East Asian ideograph */
  {"\x9B", 0, 0x21584A}, /* East Asian ideograph */
  {"\x9F", 0, 0x21584B}, /* East Asian ideograph */
  {"\xBB", 0, 0x21584C}, /* East Asian ideograph */
  {"\xB4", 0, 0x215856}, /* East Asian ideograph */
  {"\xBA", 0, 0x215857}, /* East Asian ideograph */
  {"\x86", 0, 0x23316C}, /* East Asian ideograph */
  {"\x87", 0, 0x23316D}, /* East Asian ideograph */
  {"\x84", 0, 0x23316E}, /* East Asian ideograph */
  {"\x8F", 0, 0x233170}, /* East Asian ideograph */
  {"\x91", 0, 0x233171}, /* East Asian ideograph */
  {"\x92", 0, 0x233172}, /* East Asian ideograph */
  {"\x8D", 0, 0x233173}, /* East Asian ideograph */
  {"\xA7", 0, 0x23317A}, /* East Asian ideograph */
  {"\xA9", 0, 0x23317D}, /* East Asian ideograph */
  {"\xA2", 0, 0x233225}, /* East Asian ideograph */
  {"\xBD", 0, 0x233240}, /* East Asian ideograph */
  {"\xBE", 0, 0x233258}, /* East Asian ideograph */
  {"\xB6", 0, 0x2D356A}, /* East Asian ideograph */
  {"\xBC", 0, 0x39593F}, /* East Asian ideograph */
  {"\xB3", 0, 0x4B5946}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page248 = {
  marc8r_31page248_flat, 0
};
/* PAGE 247 */
struct yaz_iconv_trie_flat marc8r_31page247_flat[] = {
  {"\x80", 0, 0x215832}, /* East Asian ideograph */
  {"\x92", 0, 0x215833}, /* East Asian ideograph */
  {"\xA3", 0, 0x215834}, /* East Asian ideograph */
  {"\xB4", 0, 0x215835}, /* East Asian ideograph */
  {"\xB8", 0, 0x215836}, /* East Asian ideograph */
  {"\x96", 0, 0x23313A}, /* East Asian ideograph */
  {"\x95", 0, 0x23313B}, /* East Asian ideograph */
  {"\x9A", 0, 0x23313F}, /* East Asian ideograph */
  {"\xA5", 0, 0x233143}, /* East Asian ideograph */
  {"\x9C", 0, 0x233145}, /* East Asian ideograph */
  {"\xA1", 0, 0x233147}, /* East Asian ideograph */
  {"\xA9", 0, 0x23314C}, /* East Asian ideograph */
  {"\xAB", 0, 0x23314D}, /* East Asian ideograph */
  {"\xAD", 0, 0x233153}, /* East Asian ideograph */
  {"\xB1", 0, 0x233158}, /* East Asian ideograph */
  {"\xB3", 0, 0x23315C}, /* East Asian ideograph */
  {"\xB5", 0, 0x23315E}, /* East Asian ideograph */
  {"\xB6", 0, 0x233160}, /* East Asian ideograph */
  {"\xB7", 0, 0x233164}, /* East Asian ideograph */
  {"\xBF", 0, 0x23316B}, /* East Asian ideograph */
  {"\x81", 0, 0x275828}, /* East Asian ideograph */
  {"\x84", 0, 0x275829}, /* East Asian ideograph */
  {"\x85", 0, 0x27582A}, /* East Asian ideograph */
  {"\x86", 0, 0x27582B}, /* East Asian ideograph */
  {"\x8E", 0, 0x27582D}, /* East Asian ideograph */
  {"\x8A", 0, 0x27582E}, /* East Asian ideograph */
  {"\x90", 0, 0x27582F}, /* East Asian ideograph */
  {"\x89", 0, 0x275830}, /* East Asian ideograph */
  {"\x88", 0, 0x275831}, /* East Asian ideograph */
  {"\x82", 0, 0x275832}, /* East Asian ideograph */
  {"\x9E", 0, 0x275835}, /* East Asian ideograph */
  {"\x87", 0, 0x293066}, /* East Asian ideograph */
  {"\x8B", 0, 0x29306F}, /* East Asian ideograph */
  {"\x8F", 0, 0x29307D}, /* East Asian ideograph */
  {"\x91", 0, 0x29312B}, /* East Asian ideograph */
  {"\x8C", 0, 0x293132}, /* East Asian ideograph */
  {"\xAF", 0, 0x293160}, /* East Asian ideograph */
  {"\xA6", 0, 0x2D5836}, /* East Asian ideograph */
  {"\x94", 0, 0x334260}, /* East Asian ideograph */
  {"\x9D", 0, 0x334A58}, /* East Asian ideograph */
  {"\xA7", 0, 0x335834}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page247 = {
  marc8r_31page247_flat, 0
};
/* PAGE 246 */
struct yaz_iconv_trie_flat marc8r_31page246_flat[] = {
  {"\x81", 0, 0x215825}, /* East Asian ideograph */
  {"\x83", 0, 0x215826}, /* East Asian ideograph */
  {"\x8B", 0, 0x215828}, /* East Asian ideograph */
  {"\x8F", 0, 0x215829}, /* East Asian ideograph */
  {"\x93", 0, 0x21582A}, /* East Asian ideograph */
  {"\x96", 0, 0x21582B}, /* East Asian ideograph */
  {"\xAA", 0, 0x21582C}, /* East Asian ideograph */
  {"\xA6", 0, 0x21582D}, /* East Asian ideograph */
  {"\xAC", 0, 0x21582E}, /* East Asian ideograph */
  {"\xB2", 0, 0x21582F}, /* East Asian ideograph */
  {"\xBA", 0, 0x215830}, /* East Asian ideograph */
  {"\xBD", 0, 0x215831}, /* East Asian ideograph */
  {"\x84", 0, 0x233053}, /* East Asian ideograph */
  {"\x85", 0, 0x233055}, /* East Asian ideograph */
  {"\x91", 0, 0x233062}, /* East Asian ideograph */
  {"\x97", 0, 0x233064}, /* East Asian ideograph */
  {"\x98", 0, 0x233066}, /* East Asian ideograph */
  {"\x9C", 0, 0x23306B}, /* East Asian ideograph */
  {"\xA1", 0, 0x23306F}, /* East Asian ideograph */
  {"\xA5", 0, 0x233076}, /* East Asian ideograph */
  {"\xA9", 0, 0x233079}, /* East Asian ideograph */
  {"\xAF", 0, 0x23307D}, /* East Asian ideograph */
  {"\xB8", 0, 0x23312A}, /* East Asian ideograph */
  {"\xB7", 0, 0x23312B}, /* East Asian ideograph */
  {"\xB6", 0, 0x23312C}, /* East Asian ideograph */
  {"\xBC", 0, 0x23312F}, /* East Asian ideograph */
  {"\xBF", 0, 0x233132}, /* East Asian ideograph */
  {"\x8A", 0, 0x2D5238}, /* East Asian ideograph */
  {"\xA7", 0, 0x2D5831}, /* East Asian ideograph */
  {"\xBB", 0, 0x2F312B}, /* East Asian ideograph */
  {"\x89", 0, 0x335238}, /* East Asian ideograph */
  {"\x88", 0, 0x394444}, /* East Asian ideograph */
  {"\x87", 0, 0x395F68}, /* East Asian ideograph */
  {"\x86", 0, 0x3F3D6F}, /* East Asian ideograph */
  {"\x9A", 0, 0x4B5830}, /* East Asian ideograph */
  {"\xB3", 0, 0x4B5832}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page246 = {
  marc8r_31page246_flat, 0
};
/* PAGE 245 */
struct yaz_iconv_trie_flat marc8r_31page245_flat[] = {
  {"\x84", 0, 0x21577A}, /* East Asian ideograph */
  {"\x9F", 0, 0x21577B}, /* East Asian ideograph */
  {"\xA0", 0, 0x21577C}, /* East Asian ideograph */
  {"\x96", 0, 0x21577D}, /* East Asian ideograph */
  {"\xA4", 0, 0x21577E}, /* East Asian ideograph */
  {"\xAA", 0, 0x215821}, /* East Asian ideograph */
  {"\xAF", 0, 0x215822}, /* East Asian ideograph */
  {"\xB2", 0, 0x215823}, /* East Asian ideograph */
  {"\xBF", 0, 0x215824}, /* East Asian ideograph */
  {"\x81", 0, 0x232F5D}, /* East Asian ideograph */
  {"\x94", 0, 0x232F66}, /* East Asian ideograph */
  {"\x8F", 0, 0x232F6F}, /* East Asian ideograph */
  {"\x87", 0, 0x232F72}, /* East Asian ideograph */
  {"\x8C", 0, 0x232F7A}, /* East Asian ideograph */
  {"\x86", 0, 0x232F7B}, /* East Asian ideograph */
  {"\x8D", 0, 0x233021}, /* East Asian ideograph */
  {"\xA2", 0, 0x233023}, /* East Asian ideograph */
  {"\x9A", 0, 0x233024}, /* East Asian ideograph */
  {"\x9E", 0, 0x233025}, /* East Asian ideograph */
  {"\x9B", 0, 0x233029}, /* East Asian ideograph */
  {"\x9C", 0, 0x23302C}, /* East Asian ideograph */
  {"\x9D", 0, 0x23302D}, /* East Asian ideograph */
  {"\xA6", 0, 0x233031}, /* East Asian ideograph */
  {"\xAD", 0, 0x233037}, /* East Asian ideograph */
  {"\xAB", 0, 0x23303A}, /* East Asian ideograph */
  {"\xAE", 0, 0x23303B}, /* East Asian ideograph */
  {"\xAC", 0, 0x23303C}, /* East Asian ideograph */
  {"\xB6", 0, 0x233041}, /* East Asian ideograph */
  {"\xB4", 0, 0x233042}, /* East Asian ideograph */
  {"\xBB", 0, 0x233049}, /* East Asian ideograph */
  {"\xBC", 0, 0x23304A}, /* East Asian ideograph */
  {"\x83", 0, 0x335772}, /* East Asian ideograph */
  {"\xBE", 0, 0x4B5824}, /* East Asian ideograph */
  {"\xB7", 0, 0x696B27}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page245 = {
  marc8r_31page245_flat, 0
};
/* PAGE 244 */
struct yaz_iconv_trie_flat marc8r_31page244_flat[] = {
  {"\x82", 0, 0x215767}, /* East Asian ideograph */
  {"\x9A", 0, 0x21576E}, /* East Asian ideograph */
  {"\x90", 0, 0x21576F}, /* East Asian ideograph */
  {"\x93", 0, 0x215771}, /* East Asian ideograph */
  {"\x92", 0, 0x215772}, /* East Asian ideograph */
  {"\xB2", 0, 0x215773}, /* East Asian ideograph */
  {"\xAA", 0, 0x215774}, /* East Asian ideograph */
  {"\xA5", 0, 0x215775}, /* East Asian ideograph */
  {"\xAB", 0, 0x215776}, /* East Asian ideograph */
  {"\xBB", 0, 0x215777}, /* East Asian ideograph */
  {"\xB6", 0, 0x215778}, /* East Asian ideograph */
  {"\xB8", 0, 0x215779}, /* East Asian ideograph */
  {"\x80", 0, 0x232E78}, /* East Asian ideograph */
  {"\x83", 0, 0x232F24}, /* East Asian ideograph */
  {"\x89", 0, 0x232F2D}, /* East Asian ideograph */
  {"\x98", 0, 0x232F2F}, /* East Asian ideograph */
  {"\x86", 0, 0x232F35}, /* East Asian ideograph */
  {"\x8C", 0, 0x232F36}, /* East Asian ideograph */
  {"\x99", 0, 0x232F37}, /* East Asian ideograph */
  {"\x8A", 0, 0x232F3D}, /* East Asian ideograph */
  {"\x95", 0, 0x232F43}, /* East Asian ideograph */
  {"\xAF", 0, 0x232F45}, /* East Asian ideograph */
  {"\xB0", 0, 0x232F47}, /* East Asian ideograph */
  {"\xA1", 0, 0x232F4E}, /* East Asian ideograph */
  {"\xA7", 0, 0x232F4F}, /* East Asian ideograph */
  {"\x9F", 0, 0x232F51}, /* East Asian ideograph */
  {"\xB1", 0, 0x232F53}, /* East Asian ideograph */
  {"\x9E", 0, 0x232F54}, /* East Asian ideograph */
  {"\xA6", 0, 0x232F56}, /* East Asian ideograph */
  {"\xA2", 0, 0x232F57}, /* East Asian ideograph */
  {"\xB5", 0, 0x232F5A}, /* East Asian ideograph */
  {"\xB3", 0, 0x232F60}, /* East Asian ideograph */
  {"\xB4", 0, 0x275771}, /* East Asian ideograph */
  {"\x9B", 0, 0x275779}, /* East Asian ideograph */
  {"\x8E", 0, 0x2D5758}, /* East Asian ideograph */
  {"\x87", 0, 0x393D6F}, /* East Asian ideograph */
  {"\x9D", 0, 0x4D2F7A}, /* East Asian ideograph */
  {"\x84", 0, 0x696A6D}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page244 = {
  marc8r_31page244_flat, 0
};
/* PAGE 243 */
struct yaz_iconv_trie_flat marc8r_31page243_flat[] = {
  {"\x81", 0, 0x21575C}, /* East Asian ideograph */
  {"\x82", 0, 0x21575D}, /* East Asian ideograph */
  {"\x9F", 0, 0x21575F}, /* East Asian ideograph */
  {"\x99", 0, 0x215760}, /* East Asian ideograph */
  {"\x98", 0, 0x215761}, /* East Asian ideograph */
  {"\x9C", 0, 0x215762}, /* East Asian ideograph */
  {"\x8F", 0, 0x215763}, /* East Asian ideograph */
  {"\x94", 0, 0x215764}, /* East Asian ideograph */
  {"\x9D", 0, 0x215765}, /* East Asian ideograph */
  {"\x95", 0, 0x215766}, /* East Asian ideograph */
  {"\xB3", 0, 0x215768}, /* East Asian ideograph */
  {"\xB8", 0, 0x215769}, /* East Asian ideograph */
  {"\xB9", 0, 0x21576A}, /* East Asian ideograph */
  {"\xB4", 0, 0x21576B}, /* East Asian ideograph */
  {"\xBD", 0, 0x21576C}, /* East Asian ideograph */
  {"\xA8", 0, 0x21576D}, /* East Asian ideograph */
  {"\x89", 0, 0x232E48}, /* East Asian ideograph */
  {"\x80", 0, 0x232E4F}, /* East Asian ideograph */
  {"\x84", 0, 0x232E5A}, /* East Asian ideograph */
  {"\x8B", 0, 0x232E5E}, /* East Asian ideograph */
  {"\x8C", 0, 0x232E60}, /* East Asian ideograph */
  {"\x9B", 0, 0x232E62}, /* East Asian ideograph */
  {"\x8E", 0, 0x232E64}, /* East Asian ideograph */
  {"\x92", 0, 0x232E68}, /* East Asian ideograph */
  {"\xB1", 0, 0x232E71}, /* East Asian ideograph */
  {"\xBE", 0, 0x232E72}, /* East Asian ideograph */
  {"\xB2", 0, 0x232E75}, /* East Asian ideograph */
  {"\xB0", 0, 0x232E7A}, /* East Asian ideograph */
  {"\xBC", 0, 0x232F21}, /* East Asian ideograph */
  {"\xAF", 0, 0x232F23}, /* East Asian ideograph */
  {"\x85", 0, 0x275765}, /* East Asian ideograph */
  {"\xA4", 0, 0x275773}, /* East Asian ideograph */
  {"\x86", 0, 0x27577C}, /* East Asian ideograph */
  {"\xA2", 0, 0x292F60}, /* East Asian ideograph */
  {"\xA5", 0, 0x292F72}, /* East Asian ideograph */
  {"\xA3", 0, 0x29302D}, /* East Asian ideograph */
  {"\xA1", 0, 0x2D5763}, /* East Asian ideograph */
  {"\xA0", 0, 0x335760}, /* East Asian ideograph */
  {"\x8A", 0, 0x4B3A47}, /* East Asian ideograph */
  {"\x83", 0, 0x696A61}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page243 = {
  marc8r_31page243_flat, 0
};
/* PAGE 242 */
struct yaz_iconv_trie_flat marc8r_31page242_flat[] = {
  {"\x82", 0, 0x215751}, /* East Asian ideograph */
  {"\x81", 0, 0x215752}, /* East Asian ideograph */
  {"\x88", 0, 0x215755}, /* East Asian ideograph */
  {"\xAB", 0, 0x215756}, /* East Asian ideograph */
  {"\x92", 0, 0x215757}, /* East Asian ideograph */
  {"\x96", 0, 0x215758}, /* East Asian ideograph */
  {"\x8D", 0, 0x215759}, /* East Asian ideograph */
  {"\x8B", 0, 0x21575A}, /* East Asian ideograph */
  {"\x9E", 0, 0x21575B}, /* East Asian ideograph */
  {"\xB1", 0, 0x21575E}, /* East Asian ideograph */
  {"\xA2", 0, 0x232E28}, /* East Asian ideograph */
  {"\xA4", 0, 0x232E2A}, /* East Asian ideograph */
  {"\xAA", 0, 0x232E2F}, /* East Asian ideograph */
  {"\x9A", 0, 0x232E34}, /* East Asian ideograph */
  {"\x90", 0, 0x232E3A}, /* East Asian ideograph */
  {"\x8C", 0, 0x232E3B}, /* East Asian ideograph */
  {"\xA0", 0, 0x232E3D}, /* East Asian ideograph */
  {"\x99", 0, 0x232E40}, /* East Asian ideograph */
  {"\x97", 0, 0x232E45}, /* East Asian ideograph */
  {"\xBF", 0, 0x232E49}, /* East Asian ideograph */
  {"\xBA", 0, 0x232E4A}, /* East Asian ideograph */
  {"\xB2", 0, 0x232E51}, /* East Asian ideograph */
  {"\xBC", 0, 0x232E54}, /* East Asian ideograph */
  {"\xB7", 0, 0x232E57}, /* East Asian ideograph */
  {"\xBD", 0, 0x232E59}, /* East Asian ideograph */
  {"\x84", 0, 0x27577D}, /* East Asian ideograph */
  {"\x9C", 0, 0x275821}, /* East Asian ideograph */
  {"\xAD", 0, 0x275823}, /* East Asian ideograph */
  {"\xB5", 0, 0x2F2D79}, /* East Asian ideograph */
  {"\xB4", 0, 0x335773}, /* East Asian ideograph */
  {"\xAE", 0, 0x4D3032}, /* East Asian ideograph */
  {"\x85", 0, 0x513A47}, /* East Asian ideograph */
  {"\xB0", 0, 0x696A5E}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page242 = {
  marc8r_31page242_flat, 0
};
/* PAGE 241 */
struct yaz_iconv_trie_flat marc8r_31page241_flat[] = {
  {"\x80", 0, 0x215743}, /* East Asian ideograph */
  {"\x8C", 0, 0x215744}, /* East Asian ideograph */
  {"\x8D", 0, 0x215745}, /* East Asian ideograph */
  {"\x93", 0, 0x215746}, /* East Asian ideograph (variant of EACC 4B5746) */
  {"\x97", 0, 0x215747}, /* East Asian ideograph */
  {"\x99", 0, 0x215748}, /* East Asian ideograph */
  {"\x9B", 0, 0x215749}, /* East Asian ideograph */
  {"\x9D", 0, 0x21574A}, /* East Asian ideograph */
  {"\xA1", 0, 0x21574B}, /* East Asian ideograph */
  {"\xA2", 0, 0x21574C}, /* East Asian ideograph */
  {"\xA3", 0, 0x21574D}, /* East Asian ideograph */
  {"\xA8", 0, 0x21574F}, /* East Asian ideograph */
  {"\xAB", 0, 0x215750}, /* East Asian ideograph */
  {"\xB0", 0, 0x215753}, /* East Asian ideograph */
  {"\xB7", 0, 0x215754}, /* East Asian ideograph */
  {"\x81", 0, 0x232D41}, /* East Asian ideograph */
  {"\x84", 0, 0x232D44}, /* East Asian ideograph */
  {"\x87", 0, 0x232D4B}, /* East Asian ideograph */
  {"\x8A", 0, 0x232D51}, /* East Asian ideograph */
  {"\x8E", 0, 0x232D53}, /* East Asian ideograph */
  {"\x92", 0, 0x232D56}, /* East Asian ideograph */
  {"\x90", 0, 0x232D57}, /* East Asian ideograph */
  {"\x96", 0, 0x232D59}, /* East Asian ideograph */
  {"\x95", 0, 0x232D5A}, /* East Asian ideograph */
  {"\x9C", 0, 0x232D5E}, /* East Asian ideograph */
  {"\x9A", 0, 0x232D5F}, /* East Asian ideograph */
  {"\xA9", 0, 0x232D69}, /* East Asian ideograph */
  {"\xAD", 0, 0x232D6D}, /* East Asian ideograph */
  {"\xBA", 0, 0x232D6E}, /* East Asian ideograph */
  {"\xB5", 0, 0x232D71}, /* East Asian ideograph */
  {"\xB2", 0, 0x232D75}, /* East Asian ideograph */
  {"\xBD", 0, 0x232D79}, /* East Asian ideograph */
  {"\xB9", 0, 0x232D7C}, /* East Asian ideograph */
  {"\xBF", 0, 0x232D7D}, /* East Asian ideograph */
  {"\xBE", 0, 0x232D7E}, /* East Asian ideograph */
  {"\xA5", 0, 0x275762}, /* East Asian ideograph */
  {"\xAC", 0, 0x275822}, /* East Asian ideograph */
  {"\x85", 0, 0x275D35}, /* East Asian ideograph */
  {"\x94", 0, 0x275D61}, /* East Asian ideograph */
  {"\x9E", 0, 0x2D5749}, /* East Asian ideograph */
  {"\xAE", 0, 0x2D575B}, /* East Asian ideograph */
  {"\x82", 0, 0x3B2D44}, /* East Asian ideograph */
  {"\x86", 0, 0x4B4D56}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page241 = {
  marc8r_31page241_flat, 0
};
/* PAGE 240 */
struct yaz_iconv_trie_flat marc8r_31page240_flat[] = {
  {"\x85", 0, 0x215736}, /* East Asian ideograph */
  {"\x8D", 0, 0x215737}, /* East Asian ideograph */
  {"\x94", 0, 0x215739}, /* East Asian ideograph */
  {"\x95", 0, 0x21573A}, /* East Asian ideograph */
  {"\xA2", 0, 0x21573B}, /* East Asian ideograph */
  {"\xA3", 0, 0x21573C}, /* East Asian ideograph */
  {"\xA1", 0, 0x21573D}, /* East Asian ideograph */
  {"\x9F", 0, 0x21573E}, /* East Asian ideograph */
  {"\xB1", 0, 0x21573F}, /* East Asian ideograph */
  {"\xB9", 0, 0x215740}, /* East Asian ideograph */
  {"\xB6", 0, 0x215741}, /* East Asian ideograph */
  {"\xBB", 0, 0x215742}, /* East Asian ideograph */
  {"\x81", 0, 0x232C4D}, /* East Asian ideograph */
  {"\x83", 0, 0x232C4F}, /* East Asian ideograph */
  {"\x8A", 0, 0x232C50}, /* East Asian ideograph */
  {"\x8B", 0, 0x232C5C}, /* East Asian ideograph */
  {"\x86", 0, 0x232C5D}, /* East Asian ideograph */
  {"\x90", 0, 0x232C61}, /* East Asian ideograph */
  {"\x99", 0, 0x232C63}, /* East Asian ideograph */
  {"\x91", 0, 0x232C64}, /* East Asian ideograph */
  {"\x98", 0, 0x232C66}, /* East Asian ideograph */
  {"\x93", 0, 0x232C6A}, /* East Asian ideograph */
  {"\x96", 0, 0x232C6B}, /* East Asian ideograph */
  {"\xB4", 0, 0x232C72}, /* East Asian ideograph */
  {"\x9C", 0, 0x232C73}, /* East Asian ideograph */
  {"\x9B", 0, 0x232C7A}, /* East Asian ideograph */
  {"\xA8", 0, 0x232D23}, /* East Asian ideograph */
  {"\xB2", 0, 0x232D2A}, /* East Asian ideograph */
  {"\xAE", 0, 0x232D2E}, /* East Asian ideograph */
  {"\xAD", 0, 0x232D32}, /* East Asian ideograph */
  {"\xBC", 0, 0x232D3C}, /* East Asian ideograph */
  {"\x8E", 0, 0x33572E}, /* East Asian ideograph */
  {"\x8F", 0, 0x335738}, /* East Asian ideograph */
  {"\xA7", 0, 0x4B5740}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page240 = {
  marc8r_31page240_flat, 0
};
/* PAGE 239 */
struct yaz_iconv_trie_flat marc8r_31page239_flat[] = {
  {"\x91", 0, 0x215728}, /* East Asian ideograph */
  {"\x80", 0, 0x215729}, /* East Asian ideograph */
  {"\x88", 0, 0x21572D}, /* East Asian ideograph */
  {"\x92", 0, 0x21572E}, /* East Asian ideograph */
  {"\x86", 0, 0x215730}, /* East Asian ideograph */
  {"\x8B", 0, 0x215731}, /* East Asian ideograph */
  {"\xAF", 0, 0x215732}, /* East Asian ideograph */
  {"\xB2", 0, 0x215733}, /* East Asian ideograph */
  {"\xAC", 0, 0x215734}, /* East Asian ideograph */
  {"\xBB", 0, 0x215735}, /* East Asian ideograph */
  {"\xB9", 0, 0x215738}, /* East Asian ideograph */
  {"\x84", 0, 0x232B6E}, /* East Asian ideograph */
  {"\xAE", 0, 0x232C2C}, /* East Asian ideograph */
  {"\xB3", 0, 0x232C30}, /* East Asian ideograph */
  {"\xB0", 0, 0x232C31}, /* East Asian ideograph */
  {"\xAA", 0, 0x232C34}, /* East Asian ideograph */
  {"\x9B", 0, 0x232C36}, /* East Asian ideograph */
  {"\xA2", 0, 0x232C37}, /* East Asian ideograph */
  {"\xAB", 0, 0x232C39}, /* East Asian ideograph */
  {"\x96", 0, 0x232C3A}, /* East Asian ideograph */
  {"\xB5", 0, 0x232C3F}, /* East Asian ideograph */
  {"\xA0", 0, 0x232C47}, /* East Asian ideograph */
  {"\x93", 0, 0x232C48}, /* East Asian ideograph */
  {"\x9C", 0, 0x232C49}, /* East Asian ideograph */
  {"\xA3", 0, 0x232C4C}, /* East Asian ideograph */
  {"\xB6", 0, 0x232C55}, /* East Asian ideograph */
  {"\xB7", 0, 0x232C57}, /* East Asian ideograph */
  {"\xBE", 0, 0x232C5F}, /* East Asian ideograph */
  {"\x87", 0, 0x2D5730}, /* East Asian ideograph */
  {"\x8A", 0, 0x2F2A73}, /* East Asian ideograph */
  {"\x81", 0, 0x335652}, /* East Asian ideograph */
  {"\xA5", 0, 0x4D2C3C}, /* East Asian ideograph */
  {"\x90", 0, 0x696A2C}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page239 = {
  marc8r_31page239_flat, 0
};
/* PAGE 238 */
struct yaz_iconv_trie_flat marc8r_31page238_flat[] = {
  {"\x83", 0, 0x215722}, /* East Asian ideograph */
  {"\x82", 0, 0x215723}, /* East Asian ideograph */
  {"\xA2", 0, 0x215724}, /* East Asian ideograph */
  {"\x9E", 0, 0x215725}, /* East Asian ideograph */
  {"\x8D", 0, 0x215726}, /* East Asian ideograph */
  {"\x9F", 0, 0x215727}, /* East Asian ideograph */
  {"\xAB", 0, 0x21572A}, /* East Asian ideograph */
  {"\xB3", 0, 0x21572B}, /* East Asian ideograph */
  {"\xBB", 0, 0x21572C}, /* East Asian ideograph */
  {"\xBA", 0, 0x21572F}, /* East Asian ideograph */
  {"\xA3", 0, 0x232B3A}, /* East Asian ideograph */
  {"\x93", 0, 0x232B3D}, /* East Asian ideograph */
  {"\x99", 0, 0x232B45}, /* East Asian ideograph */
  {"\x88", 0, 0x232B48}, /* East Asian ideograph */
  {"\x98", 0, 0x232B4C}, /* East Asian ideograph */
  {"\x85", 0, 0x232B53}, /* East Asian ideograph */
  {"\x8B", 0, 0x232B54}, /* East Asian ideograph */
  {"\x84", 0, 0x232B55}, /* East Asian ideograph */
  {"\xA9", 0, 0x232B58}, /* East Asian ideograph */
  {"\x89", 0, 0x232B5D}, /* East Asian ideograph */
  {"\xAD", 0, 0x232B60}, /* East Asian ideograph */
  {"\xBE", 0, 0x232B66}, /* East Asian ideograph */
  {"\xAF", 0, 0x232B6F}, /* East Asian ideograph */
  {"\xAC", 0, 0x232B72}, /* East Asian ideograph */
  {"\xAE", 0, 0x232B78}, /* East Asian ideograph */
  {"\xBF", 0, 0x232B7E}, /* East Asian ideograph */
  {"\xBD", 0, 0x232C24}, /* East Asian ideograph */
  {"\x97", 0, 0x2D572B}, /* East Asian ideograph */
  {"\xB5", 0, 0x2F2A64}, /* East Asian ideograph */
  {"\xA1", 0, 0x395652}, /* East Asian ideograph */
  {"\xA8", 0, 0x70727D}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page238 = {
  marc8r_31page238_flat, 0
};
/* PAGE 237 */
struct yaz_iconv_trie_flat marc8r_31page237_flat[] = {
  {"\x95", 0, 0x215676}, /* East Asian ideograph */
  {"\xA0", 0, 0x215677}, /* East Asian ideograph */
  {"\xB6", 0, 0x215678}, /* East Asian ideograph */
  {"\xB4", 0, 0x215679}, /* East Asian ideograph */
  {"\xA6", 0, 0x21567A}, /* East Asian ideograph */
  {"\xB8", 0, 0x21567B}, /* East Asian ideograph */
  {"\xA8", 0, 0x21567C}, /* East Asian ideograph */
  {"\x8C", 0, 0x21567D}, /* East Asian ideograph */
  {"\x97", 0, 0x21567E}, /* East Asian ideograph */
  {"\x99", 0, 0x215721}, /* East Asian ideograph */
  {"\x8A", 0, 0x232A42}, /* East Asian ideograph */
  {"\x80", 0, 0x232A49}, /* East Asian ideograph */
  {"\x83", 0, 0x232A53}, /* East Asian ideograph */
  {"\x84", 0, 0x232A55}, /* East Asian ideograph */
  {"\x8F", 0, 0x232A6B}, /* East Asian ideograph */
  {"\xB1", 0, 0x232A6C}, /* East Asian ideograph */
  {"\xA3", 0, 0x232A6D}, /* East Asian ideograph */
  {"\xA4", 0, 0x232A71}, /* East Asian ideograph */
  {"\xA5", 0, 0x232A73}, /* East Asian ideograph */
  {"\xBD", 0, 0x232A74}, /* East Asian ideograph */
  {"\x98", 0, 0x232A79}, /* East Asian ideograph */
  {"\xBB", 0, 0x232A7B}, /* East Asian ideograph */
  {"\xA1", 0, 0x232B21}, /* East Asian ideograph */
  {"\xAA", 0, 0x232B24}, /* East Asian ideograph */
  {"\x8E", 0, 0x232B27}, /* East Asian ideograph */
  {"\x9F", 0, 0x232B28}, /* East Asian ideograph */
  {"\xAF", 0, 0x232B2D}, /* East Asian ideograph */
  {"\x9D", 0, 0x232B2E}, /* East Asian ideograph */
  {"\xAE", 0, 0x232B30}, /* East Asian ideograph */
  {"\x8D", 0, 0x232B33}, /* East Asian ideograph */
  {"\x93", 0, 0x232B35}, /* East Asian ideograph */
  {"\xBC", 0, 0x27572C}, /* East Asian ideograph */
  {"\x89", 0, 0x275734}, /* East Asian ideograph */
  {"\x87", 0, 0x275736}, /* East Asian ideograph */
  {"\xBE", 0, 0x292C64}, /* East Asian ideograph */
  {"\x88", 0, 0x2D572D}, /* East Asian ideograph */
  {"\xBF", 0, 0x4B5736}, /* East Asian ideograph */
  {"\xB0", 0, 0x4D2925}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page237 = {
  marc8r_31page237_flat, 0
};
/* PAGE 236 */
struct yaz_iconv_trie_flat marc8r_31page236_flat[] = {
  {"\x87", 0, 0x215668}, /* East Asian ideograph */
  {"\x83", 0, 0x215669}, /* East Asian ideograph */
  {"\x88", 0, 0x21566A}, /* East Asian ideograph */
  {"\x80", 0, 0x21566B}, /* East Asian ideograph */
  {"\x93", 0, 0x21566D}, /* East Asian ideograph */
  {"\x82", 0, 0x21566E}, /* East Asian ideograph */
  {"\x9C", 0, 0x21566F}, /* East Asian ideograph */
  {"\xBF", 0, 0x215670}, /* East Asian ideograph */
  {"\xBB", 0, 0x215671}, /* East Asian ideograph */
  {"\xA2", 0, 0x215672}, /* East Asian ideograph */
  {"\xA5", 0, 0x215673}, /* East Asian ideograph */
  {"\xB4", 0, 0x215674}, /* East Asian ideograph */
  {"\x98", 0, 0x215675}, /* East Asian ideograph */
  {"\x8B", 0, 0x232A25}, /* East Asian ideograph */
  {"\x86", 0, 0x232A34}, /* East Asian ideograph */
  {"\x8E", 0, 0x232A36}, /* East Asian ideograph */
  {"\x89", 0, 0x232A38}, /* East Asian ideograph */
  {"\x8A", 0, 0x232A3A}, /* East Asian ideograph */
  {"\x8D", 0, 0x232A3E}, /* East Asian ideograph */
  {"\xA3", 0, 0x232A43}, /* East Asian ideograph */
  {"\xB7", 0, 0x232A44}, /* East Asian ideograph */
  {"\xA8", 0, 0x232A45}, /* East Asian ideograph */
  {"\xAE", 0, 0x232A4B}, /* East Asian ideograph */
  {"\xBD", 0, 0x232A4C}, /* East Asian ideograph */
  {"\x9E", 0, 0x232A4E}, /* East Asian ideograph */
  {"\xBE", 0, 0x232A57}, /* East Asian ideograph */
  {"\xA9", 0, 0x232A59}, /* East Asian ideograph */
  {"\xB9", 0, 0x232A5A}, /* East Asian ideograph */
  {"\x9A", 0, 0x232A5F}, /* East Asian ideograph */
  {"\xB1", 0, 0x232A64}, /* East Asian ideograph */
  {"\x91", 0, 0x232A65}, /* East Asian ideograph */
  {"\x92", 0, 0x232A66}, /* East Asian ideograph */
  {"\xA1", 0, 0x27573E}, /* East Asian ideograph */
  {"\x97", 0, 0x2D567B}, /* East Asian ideograph */
  {"\xBA", 0, 0x2D5F63}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page236 = {
  marc8r_31page236_flat, 0
};
/* PAGE 235 */
struct yaz_iconv_trie_flat marc8r_31page235_flat[] = {
  {"\x80", 0, 0x215657}, /* East Asian ideograph */
  {"\x87", 0, 0x215658}, /* East Asian ideograph */
  {"\x8B", 0, 0x21565A}, /* East Asian ideograph */
  {"\x84", 0, 0x21565C}, /* East Asian ideograph */
  {"\x86", 0, 0x21565D}, /* East Asian ideograph */
  {"\x9F", 0, 0x215660}, /* East Asian ideograph */
  {"\x99", 0, 0x215661}, /* East Asian ideograph */
  {"\xAD", 0, 0x215662}, /* East Asian ideograph */
  {"\x94", 0, 0x215663}, /* East Asian ideograph */
  {"\x9B", 0, 0x215664}, /* East Asian ideograph */
  {"\xA4", 0, 0x215665}, /* East Asian ideograph */
  {"\xBB", 0, 0x215666}, /* East Asian ideograph */
  {"\xB9", 0, 0x215667}, /* East Asian ideograph */
  {"\xBE", 0, 0x21566C}, /* East Asian ideograph */
  {"\x89", 0, 0x232962}, /* East Asian ideograph */
  {"\x98", 0, 0x232967}, /* East Asian ideograph */
  {"\xA3", 0, 0x23296E}, /* East Asian ideograph */
  {"\xA9", 0, 0x23296F}, /* East Asian ideograph */
  {"\xAC", 0, 0x232971}, /* East Asian ideograph */
  {"\x95", 0, 0x232974}, /* East Asian ideograph */
  {"\x90", 0, 0x232977}, /* East Asian ideograph */
  {"\x91", 0, 0x23297A}, /* East Asian ideograph */
  {"\x9E", 0, 0x23297E}, /* East Asian ideograph */
  {"\xBA", 0, 0x232A2F}, /* East Asian ideograph */
  {"\xB8", 0, 0x232A33}, /* East Asian ideograph */
  {"\x83", 0, 0x23355C}, /* East Asian ideograph */
  {"\xB2", 0, 0x275732}, /* East Asian ideograph */
  {"\x8E", 0, 0x27573C}, /* East Asian ideograph */
  {"\x8A", 0, 0x27573F}, /* East Asian ideograph */
  {"\xAE", 0, 0x275742}, /* East Asian ideograph */
  {"\xB1", 0, 0x292A2F}, /* East Asian ideograph */
  {"\xB3", 0, 0x292B55}, /* East Asian ideograph */
  {"\xB0", 0, 0x292B6E}, /* East Asian ideograph */
  {"\x8F", 0, 0x292C55}, /* East Asian ideograph */
  {"\xB4", 0, 0x292C61}, /* East Asian ideograph */
  {"\x8D", 0, 0x4B5724}, /* East Asian ideograph */
  {"\xAF", 0, 0x696962}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page235 = {
  marc8r_31page235_flat, 0
};
/* PAGE 234 */
struct yaz_iconv_trie_flat marc8r_31page234_flat[] = {
  {"\xA9", 0, 0x215650}, /* East Asian ideograph */
  {"\xAA", 0, 0x215651}, /* East Asian ideograph */
  {"\x8A", 0, 0x215652}, /* East Asian ideograph */
  {"\x93", 0, 0x215653}, /* East Asian ideograph */
  {"\xA4", 0, 0x215654}, /* East Asian ideograph */
  {"\x8C", 0, 0x215655}, /* East Asian ideograph */
  {"\xA3", 0, 0x215656}, /* East Asian ideograph */
  {"\xB5", 0, 0x215659}, /* East Asian ideograph */
  {"\xB6", 0, 0x21565B}, /* East Asian ideograph */
  {"\xB1", 0, 0x21565E}, /* East Asian ideograph */
  {"\xAF", 0, 0x21565F}, /* East Asian ideograph */
  {"\x96", 0, 0x23292E}, /* East Asian ideograph */
  {"\xA8", 0, 0x23292F}, /* East Asian ideograph */
  {"\x91", 0, 0x232936}, /* East Asian ideograph */
  {"\x9C", 0, 0x232937}, /* East Asian ideograph */
  {"\x98", 0, 0x232939}, /* East Asian ideograph */
  {"\x8D", 0, 0x23293C}, /* East Asian ideograph */
  {"\x8B", 0, 0x23293D}, /* East Asian ideograph */
  {"\xA6", 0, 0x232940}, /* East Asian ideograph */
  {"\x9D", 0, 0x232942}, /* East Asian ideograph */
  {"\xA0", 0, 0x232946}, /* East Asian ideograph */
  {"\xA7", 0, 0x232948}, /* East Asian ideograph */
  {"\xBF", 0, 0x23294B}, /* East Asian ideograph */
  {"\xBA", 0, 0x232958}, /* East Asian ideograph */
  {"\xB0", 0, 0x232959}, /* East Asian ideograph */
  {"\xB3", 0, 0x232960}, /* East Asian ideograph */
  {"\xB4", 0, 0x232963}, /* East Asian ideograph */
  {"\x80", 0, 0x275676}, /* East Asian ideograph */
  {"\x82", 0, 0x275725}, /* East Asian ideograph */
  {"\x81", 0, 0x275735}, /* East Asian ideograph */
  {"\x95", 0, 0x275741}, /* East Asian ideograph */
  {"\xAC", 0, 0x292A34}, /* East Asian ideograph */
  {"\xA1", 0, 0x2F5F45}, /* East Asian ideograph */
  {"\xAB", 0, 0x69695B}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page234 = {
  marc8r_31page234_flat, 0
};
/* PAGE 233 */
struct yaz_iconv_trie_flat marc8r_31page233_flat[] = {
  {"\x8E", 0, 0x215643}, /* East Asian ideograph */
  {"\x90", 0, 0x215644}, /* East Asian ideograph */
  {"\x94", 0, 0x215645}, /* East Asian ideograph */
  {"\x95", 0, 0x215647}, /* East Asian ideograph */
  {"\x9C", 0, 0x215648}, /* East Asian ideograph */
  {"\x9B", 0, 0x215649}, /* East Asian ideograph */
  {"\x9F", 0, 0x21564A}, /* East Asian ideograph */
  {"\x9E", 0, 0x21564B}, /* East Asian ideograph */
  {"\xA7", 0, 0x21564C}, /* East Asian ideograph */
  {"\xB9", 0, 0x21564F}, /* East Asian ideograph */
  {"\x92", 0, 0x216D74}, /* East Asian ideograph */
  {"\x81", 0, 0x21787C}, /* East Asian ideograph */
  {"\x80", 0, 0x23283F}, /* East Asian ideograph */
  {"\x85", 0, 0x23284C}, /* East Asian ideograph */
  {"\x8D", 0, 0x232859}, /* East Asian ideograph */
  {"\x93", 0, 0x23285A}, /* East Asian ideograph */
  {"\x99", 0, 0x23285E}, /* East Asian ideograph */
  {"\xA1", 0, 0x232866}, /* East Asian ideograph */
  {"\xA2", 0, 0x232869}, /* East Asian ideograph */
  {"\xA3", 0, 0x23286A}, /* East Asian ideograph */
  {"\xA9", 0, 0x232871}, /* East Asian ideograph */
  {"\xAC", 0, 0x232878}, /* East Asian ideograph */
  {"\xB2", 0, 0x23287B}, /* East Asian ideograph */
  {"\xAF", 0, 0x23287C}, /* East Asian ideograph */
  {"\xBB", 0, 0x23287E}, /* East Asian ideograph */
  {"\xBA", 0, 0x232925}, /* East Asian ideograph */
  {"\xB3", 0, 0x232926}, /* East Asian ideograph */
  {"\xBC", 0, 0x232927}, /* East Asian ideograph */
  {"\x91", 0, 0x273F36}, /* East Asian ideograph */
  {"\x8F", 0, 0x275648}, /* East Asian ideograph */
  {"\xBE", 0, 0x27567A}, /* East Asian ideograph */
  {"\xAB", 0, 0x275733}, /* East Asian ideograph */
  {"\xBD", 0, 0x275F4A}, /* East Asian ideograph */
  {"\xAE", 0, 0x292C4C}, /* East Asian ideograph */
  {"\xBF", 0, 0x292C5D}, /* East Asian ideograph */
  {"\x96", 0, 0x333573}, /* East Asian ideograph */
  {"\xB1", 0, 0x33567C}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page233 = {
  marc8r_31page233_flat, 0
};
/* PAGE 232 */
struct yaz_iconv_trie_flat marc8r_31page232_flat[] = {
  {"\x91", 0, 0x215638}, /* East Asian ideograph */
  {"\x86", 0, 0x21563A}, /* East Asian ideograph */
  {"\x8B", 0, 0x21563B}, /* East Asian ideograph */
  {"\x87", 0, 0x21563C}, /* East Asian ideograph */
  {"\x8A", 0, 0x21563D}, /* East Asian ideograph */
  {"\xAD", 0, 0x21563E}, /* East Asian ideograph */
  {"\x97", 0, 0x21563F}, /* East Asian ideograph */
  {"\x9A", 0, 0x215640}, /* East Asian ideograph */
  {"\xB8", 0, 0x215641}, /* East Asian ideograph */
  {"\xBF", 0, 0x215642}, /* East Asian ideograph */
  {"\xA4", 0, 0x232724}, /* East Asian ideograph */
  {"\xA2", 0, 0x232752}, /* East Asian ideograph */
  {"\x90", 0, 0x232754}, /* East Asian ideograph */
  {"\x80", 0, 0x232760}, /* East Asian ideograph */
  {"\x84", 0, 0x232768}, /* East Asian ideograph */
  {"\x85", 0, 0x232771}, /* East Asian ideograph */
  {"\xAB", 0, 0x232775}, /* East Asian ideograph */
  {"\xA7", 0, 0x232822}, /* East Asian ideograph */
  {"\xA9", 0, 0x232826}, /* East Asian ideograph */
  {"\xB7", 0, 0x232832}, /* East Asian ideograph */
  {"\xB6", 0, 0x232838}, /* East Asian ideograph */
  {"\xBC", 0, 0x23283E}, /* East Asian ideograph */
  {"\xBA", 0, 0x232840}, /* East Asian ideograph */
  {"\x93", 0, 0x2D563C}, /* East Asian ideograph */
  {"\x82", 0, 0x335577}, /* East Asian ideograph */
  {"\xAF", 0, 0x4B4D41}, /* East Asian ideograph */
  {"\x96", 0, 0x51563F}, /* East Asian ideograph */
  {"\xB0", 0, 0x696946}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page232 = {
  marc8r_31page232_flat, 0
};
/* PAGE 231 */
struct yaz_iconv_trie_flat marc8r_31page231_flat[] = {
  {"\x8D", 0, 0x215629}, /* East Asian ideograph (variant of EACC 4B5629) */
  {"\x8F", 0, 0x21562B}, /* East Asian ideograph */
  {"\x90", 0, 0x21562D}, /* East Asian ideograph */
  {"\x89", 0, 0x21562E}, /* East Asian ideograph */
  {"\xA9", 0, 0x215630}, /* East Asian ideograph */
  {"\x9D", 0, 0x215631}, /* East Asian ideograph */
  {"\xAA", 0, 0x215632}, /* East Asian ideograph */
  {"\xA4", 0, 0x215633}, /* East Asian ideograph */
  {"\x95", 0, 0x215634}, /* East Asian ideograph */
  {"\xA5", 0, 0x215635}, /* East Asian ideograph */
  {"\xBB", 0, 0x215636}, /* East Asian ideograph */
  {"\xB9", 0, 0x215637}, /* East Asian ideograph */
  {"\xBA", 0, 0x215639}, /* East Asian ideograph */
  {"\x81", 0, 0x23265D}, /* East Asian ideograph */
  {"\x8E", 0, 0x232668}, /* East Asian ideograph */
  {"\x82", 0, 0x23266A}, /* East Asian ideograph */
  {"\x84", 0, 0x232670}, /* East Asian ideograph */
  {"\xB7", 0, 0x232728}, /* East Asian ideograph */
  {"\xA6", 0, 0x23272C}, /* East Asian ideograph */
  {"\x94", 0, 0x23272E}, /* East Asian ideograph */
  {"\xAD", 0, 0x232731}, /* East Asian ideograph */
  {"\x9A", 0, 0x232739}, /* East Asian ideograph */
  {"\x9F", 0, 0x232743}, /* East Asian ideograph */
  {"\x98", 0, 0x232745}, /* East Asian ideograph */
  {"\x9C", 0, 0x23274C}, /* East Asian ideograph */
  {"\xB5", 0, 0x23274E}, /* East Asian ideograph */
  {"\xBC", 0, 0x232757}, /* East Asian ideograph */
  {"\xBF", 0, 0x23275B}, /* East Asian ideograph */
  {"\xBE", 0, 0x23275E}, /* East Asian ideograph */
  {"\x93", 0, 0x275640}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page231 = {
  marc8r_31page231_flat, 0
};
/* PAGE 230 */
struct yaz_iconv_trie_flat marc8r_31page230_flat[] = {
  {"\x84", 0, 0x21557E}, /* East Asian ideograph */
  {"\xAA", 0, 0x215621}, /* East Asian ideograph */
  {"\x9B", 0, 0x215623}, /* East Asian ideograph */
  {"\x91", 0, 0x215624}, /* East Asian ideograph */
  {"\x94", 0, 0x215626}, /* East Asian ideograph */
  {"\x9C", 0, 0x215627}, /* East Asian ideograph */
  {"\x87", 0, 0x215628}, /* East Asian ideograph */
  {"\xA9", 0, 0x21562A}, /* East Asian ideograph */
  {"\xAF", 0, 0x21562C}, /* East Asian ideograph */
  {"\xB0", 0, 0x21562F}, /* East Asian ideograph */
  {"\x8C", 0, 0x232577}, /* East Asian ideograph */
  {"\x80", 0, 0x232625}, /* East Asian ideograph */
  {"\x8F", 0, 0x232628}, /* East Asian ideograph */
  {"\x98", 0, 0x232635}, /* East Asian ideograph */
  {"\xA4", 0, 0x23263D}, /* East Asian ideograph */
  {"\x97", 0, 0x232644}, /* East Asian ideograph */
  {"\xA8", 0, 0x232649}, /* East Asian ideograph */
  {"\x86", 0, 0x23264E}, /* East Asian ideograph */
  {"\x99", 0, 0x232650}, /* East Asian ideograph */
  {"\x8A", 0, 0x232651}, /* East Asian ideograph */
  {"\xA2", 0, 0x232652}, /* East Asian ideograph */
  {"\x90", 0, 0x232654}, /* East Asian ideograph */
  {"\x85", 0, 0x232656}, /* East Asian ideograph */
  {"\x88", 0, 0x232657}, /* East Asian ideograph */
  {"\xB8", 0, 0x23265A}, /* East Asian ideograph */
  {"\xBA", 0, 0x232661}, /* East Asian ideograph */
  {"\xB7", 0, 0x23266B}, /* East Asian ideograph */
  {"\xB9", 0, 0x23266C}, /* East Asian ideograph */
  {"\xB3", 0, 0x23266E}, /* East Asian ideograph */
  {"\xBD", 0, 0x23266F}, /* East Asian ideograph */
  {"\xBF", 0, 0x232672}, /* East Asian ideograph */
  {"\xBE", 0, 0x232675}, /* East Asian ideograph */
  {"\xB6", 0, 0x23267E}, /* East Asian ideograph */
  {"\xAE", 0, 0x275632}, /* East Asian ideograph */
  {"\xAC", 0, 0x335635}, /* East Asian ideograph */
  {"\xA6", 0, 0x395477}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page230 = {
  marc8r_31page230_flat, 0
};
/* PAGE 229 */
struct yaz_iconv_trie_flat marc8r_31page229_flat[] = {
  {"\xA9", 0, 0x215576}, /* East Asian ideograph */
  {"\x8A", 0, 0x215577}, /* East Asian ideograph */
  {"\x99", 0, 0x215578}, /* East Asian ideograph */
  {"\x88", 0, 0x215579}, /* East Asian ideograph */
  {"\xA8", 0, 0x21557A}, /* East Asian ideograph */
  {"\x83", 0, 0x21557B}, /* East Asian ideograph */
  {"\xAA", 0, 0x21557C}, /* East Asian ideograph */
  {"\x89", 0, 0x21557D}, /* East Asian ideograph */
  {"\xAD", 0, 0x215622}, /* East Asian ideograph */
  {"\xBE", 0, 0x215625}, /* East Asian ideograph */
  {"\x96", 0, 0x232536}, /* East Asian ideograph */
  {"\x81", 0, 0x232546}, /* East Asian ideograph */
  {"\x98", 0, 0x23254B}, /* East Asian ideograph */
  {"\x93", 0, 0x23254D}, /* East Asian ideograph */
  {"\xA1", 0, 0x23254E}, /* East Asian ideograph */
  {"\x80", 0, 0x23254F}, /* East Asian ideograph */
  {"\x86", 0, 0x23255A}, /* East Asian ideograph */
  {"\xA4", 0, 0x23255C}, /* East Asian ideograph */
  {"\x9E", 0, 0x23255D}, /* East Asian ideograph */
  {"\xB3", 0, 0x23255E}, /* East Asian ideograph */
  {"\x91", 0, 0x23255F}, /* East Asian ideograph */
  {"\xA2", 0, 0x232564}, /* East Asian ideograph */
  {"\xA3", 0, 0x23256B}, /* East Asian ideograph */
  {"\x82", 0, 0x23256D}, /* East Asian ideograph */
  {"\x8E", 0, 0x232571}, /* East Asian ideograph */
  {"\x95", 0, 0x232574}, /* East Asian ideograph */
  {"\x9D", 0, 0x232576}, /* East Asian ideograph */
  {"\xB9", 0, 0x23262D}, /* East Asian ideograph */
  {"\xBF", 0, 0x232632}, /* East Asian ideograph */
  {"\xB7", 0, 0x232633}, /* East Asian ideograph */
  {"\xB8", 0, 0x232634}, /* East Asian ideograph */
  {"\xBB", 0, 0x232636}, /* East Asian ideograph */
  {"\xBA", 0, 0x232642}, /* East Asian ideograph */
  {"\x97", 0, 0x232645}, /* East Asian ideograph */
  {"\xB4", 0, 0x27563D}, /* East Asian ideograph */
  {"\xB2", 0, 0x292768}, /* East Asian ideograph */
  {"\x9A", 0, 0x2D5554}, /* East Asian ideograph */
  {"\x8B", 0, 0x395577}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page229 = {
  marc8r_31page229_flat, 0
};
/* PAGE 228 */
struct yaz_iconv_trie_flat marc8r_31page228_flat[] = {
  {"\xBD", 0, 0x215568}, /* East Asian ideograph */
  {"\x97", 0, 0x21556A}, /* East Asian ideograph */
  {"\x9A", 0, 0x21556B}, /* East Asian ideograph */
  {"\xAC", 0, 0x21556D}, /* East Asian ideograph */
  {"\xAD", 0, 0x21556E}, /* East Asian ideograph */
  {"\x93", 0, 0x21556F}, /* East Asian ideograph */
  {"\xA3", 0, 0x215571}, /* East Asian ideograph */
  {"\xA1", 0, 0x215572}, /* East Asian ideograph */
  {"\x94", 0, 0x215573}, /* East Asian ideograph */
  {"\xA5", 0, 0x215575}, /* East Asian ideograph */
  {"\x86", 0, 0x232446}, /* East Asian ideograph */
  {"\x8B", 0, 0x232447}, /* East Asian ideograph */
  {"\x80", 0, 0x23244D}, /* East Asian ideograph */
  {"\x9F", 0, 0x232459}, /* East Asian ideograph */
  {"\xBB", 0, 0x23245C}, /* East Asian ideograph */
  {"\x8C", 0, 0x23246A}, /* East Asian ideograph */
  {"\xAF", 0, 0x232472}, /* East Asian ideograph */
  {"\x95", 0, 0x232475}, /* East Asian ideograph */
  {"\x9E", 0, 0x232524}, /* East Asian ideograph */
  {"\x98", 0, 0x23252A}, /* East Asian ideograph */
  {"\xA6", 0, 0x23252D}, /* East Asian ideograph */
  {"\x87", 0, 0x23252E}, /* East Asian ideograph (variant of EACC 2F252E) */
  {"\xB7", 0, 0x275626}, /* East Asian ideograph */
  {"\xBC", 0, 0x275637}, /* East Asian ideograph */
  {"\xBA", 0, 0x275639}, /* East Asian ideograph */
  {"\xB9", 0, 0x29282A}, /* East Asian ideograph */
  {"\x91", 0, 0x292D51}, /* East Asian ideograph */
  {"\xB4", 0, 0x33625F}, /* East Asian ideograph */
  {"\xB5", 0, 0x4B562B}, /* East Asian ideograph */
  {"\xB8", 0, 0x4C4146}, /* East Asian ideograph */
  {"\xAB", 0, 0x51496B}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page228 = {
  marc8r_31page228_flat, 0
};
/* PAGE 227 */
struct yaz_iconv_trie_flat marc8r_31page227_flat[] = {
  {"\x86", 0, 0x21555D}, /* East Asian ideograph */
  {"\x84", 0, 0x21555E}, /* East Asian ideograph */
  {"\x89", 0, 0x21555F}, /* East Asian ideograph */
  {"\x8B", 0, 0x215561}, /* East Asian ideograph */
  {"\x80", 0, 0x215563}, /* East Asian ideograph */
  {"\x93", 0, 0x215565}, /* East Asian ideograph */
  {"\xBF", 0, 0x215569}, /* East Asian ideograph */
  {"\xAE", 0, 0x21556C}, /* East Asian ideograph */
  {"\xAC", 0, 0x215574}, /* East Asian ideograph */
  {"\x81", 0, 0x23235E}, /* East Asian ideograph */
  {"\x8D", 0, 0x232368}, /* East Asian ideograph */
  {"\x90", 0, 0x232372}, /* East Asian ideograph */
  {"\x87", 0, 0x232379}, /* East Asian ideograph */
  {"\x82", 0, 0x23237C}, /* East Asian ideograph */
  {"\x96", 0, 0x232433}, /* East Asian ideograph */
  {"\x9A", 0, 0x232435}, /* East Asian ideograph */
  {"\x8F", 0, 0x23243F}, /* East Asian ideograph */
  {"\x8A", 0, 0x232441}, /* East Asian ideograph */
  {"\xAA", 0, 0x23245F}, /* East Asian ideograph */
  {"\xB4", 0, 0x232466}, /* East Asian ideograph */
  {"\xB7", 0, 0x232477}, /* East Asian ideograph */
  {"\xBC", 0, 0x23247A}, /* East Asian ideograph */
  {"\xAB", 0, 0x23247C}, /* East Asian ideograph */
  {"\xBD", 0, 0x23247D}, /* East Asian ideograph */
  {"\xA7", 0, 0x23252F}, /* East Asian ideograph */
  {"\xB0", 0, 0x232534}, /* East Asian ideograph */
  {"\xAF", 0, 0x232535}, /* East Asian ideograph */
  {"\x9D", 0, 0x275629}, /* East Asian ideograph */
  {"\xA6", 0, 0x276148}, /* East Asian ideograph */
  {"\xA3", 0, 0x292633}, /* East Asian ideograph */
  {"\x9F", 0, 0x292651}, /* East Asian ideograph */
  {"\xA0", 0, 0x292840}, /* East Asian ideograph */
  {"\xA5", 0, 0x294629}, /* East Asian ideograph */
  {"\x91", 0, 0x2D5036}, /* East Asian ideograph */
  {"\xA1", 0, 0x3F347D}, /* East Asian ideograph */
  {"\x99", 0, 0x696868}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page227 = {
  marc8r_31page227_flat, 0
};
/* PAGE 226 */
struct yaz_iconv_trie_flat marc8r_31page226_flat[] = {
  {"\xB5", 0, 0x21554C}, /* East Asian ideograph */
  {"\xA6", 0, 0x21554D}, /* East Asian ideograph */
  {"\x97", 0, 0x21554E}, /* East Asian ideograph */
  {"\x89", 0, 0x21554F}, /* East Asian ideograph */
  {"\xAC", 0, 0x215550}, /* East Asian ideograph */
  {"\xAB", 0, 0x215551}, /* East Asian ideograph */
  {"\x9B", 0, 0x215552}, /* East Asian ideograph */
  {"\xB7", 0, 0x215553}, /* East Asian ideograph */
  {"\xA1", 0, 0x215556}, /* East Asian ideograph */
  {"\xA3", 0, 0x215557}, /* East Asian ideograph */
  {"\xA9", 0, 0x215558}, /* East Asian ideograph */
  {"\x93", 0, 0x232248}, /* East Asian ideograph */
  {"\xB6", 0, 0x23224D}, /* East Asian ideograph */
  {"\xB9", 0, 0x23224E}, /* East Asian ideograph */
  {"\x91", 0, 0x23225C}, /* East Asian ideograph */
  {"\xBD", 0, 0x23225F}, /* East Asian ideograph */
  {"\x9A", 0, 0x232262}, /* East Asian ideograph */
  {"\x99", 0, 0x232266}, /* East Asian ideograph */
  {"\xB3", 0, 0x232269}, /* East Asian ideograph */
  {"\xAD", 0, 0x232271}, /* East Asian ideograph */
  {"\xBA", 0, 0x232278}, /* East Asian ideograph */
  {"\xB8", 0, 0x23227C}, /* East Asian ideograph */
  {"\x9C", 0, 0x232329}, /* East Asian ideograph */
  {"\xB1", 0, 0x232332}, /* East Asian ideograph */
  {"\x9F", 0, 0x232335}, /* East Asian ideograph */
  {"\xA0", 0, 0x232336}, /* East Asian ideograph */
  {"\xAE", 0, 0x232337}, /* East Asian ideograph */
  {"\x86", 0, 0x23233A}, /* East Asian ideograph */
  {"\x92", 0, 0x23233C}, /* East Asian ideograph */
  {"\x8A", 0, 0x23233F}, /* East Asian ideograph */
  {"\x8E", 0, 0x232345}, /* East Asian ideograph */
  {"\xAF", 0, 0x2D5635}, /* East Asian ideograph */
  {"\xA2", 0, 0x335561}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page226 = {
  marc8r_31page226_flat, 0
};
/* PAGE 225 */
struct yaz_iconv_trie_flat marc8r_31page225_flat[] = {
  {"\x82", 0, 0x21554A}, /* East Asian ideograph */
  {"\xB2", 0, 0x21555A}, /* East Asian ideograph */
  {"\x9E", 0, 0x21555B}, /* East Asian ideograph */
  {"\xBF", 0, 0x21555C}, /* East Asian ideograph */
  {"\x9C", 0, 0x215560}, /* East Asian ideograph */
  {"\xB8", 0, 0x215562}, /* East Asian ideograph */
  {"\x99", 0, 0x215564}, /* East Asian ideograph */
  {"\x90", 0, 0x215566}, /* East Asian ideograph */
  {"\xBC", 0, 0x215567}, /* East Asian ideograph */
  {"\x8E", 0, 0x23224A}, /* East Asian ideograph */
  {"\x84", 0, 0x23227B}, /* East Asian ideograph */
  {"\x97", 0, 0x232349}, /* East Asian ideograph */
  {"\xA1", 0, 0x232350}, /* East Asian ideograph */
  {"\x9F", 0, 0x232353}, /* East Asian ideograph */
  {"\xBA", 0, 0x232356}, /* East Asian ideograph */
  {"\xB9", 0, 0x232358}, /* East Asian ideograph */
  {"\xB4", 0, 0x23235C}, /* East Asian ideograph */
  {"\xBB", 0, 0x23235F}, /* East Asian ideograph */
  {"\xB1", 0, 0x232370}, /* East Asian ideograph */
  {"\x9D", 0, 0x232371}, /* East Asian ideograph */
  {"\x94", 0, 0x232375}, /* East Asian ideograph */
  {"\xBD", 0, 0x23237A}, /* East Asian ideograph */
  {"\x95", 0, 0x232421}, /* East Asian ideograph */
  {"\xAF", 0, 0x232427}, /* East Asian ideograph */
  {"\xAD", 0, 0x232429}, /* East Asian ideograph */
  {"\xA8", 0, 0x232432}, /* East Asian ideograph */
  {"\x93", 0, 0x23243A}, /* East Asian ideograph */
  {"\x8D", 0, 0x23256C}, /* East Asian ideograph */
  {"\x8B", 0, 0x275571}, /* East Asian ideograph */
  {"\x8C", 0, 0x292524}, /* East Asian ideograph */
  {"\x87", 0, 0x29255A}, /* East Asian ideograph */
  {"\x89", 0, 0x292564}, /* East Asian ideograph */
  {"\x88", 0, 0x705D5C}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page225 = {
  marc8r_31page225_flat, 0
};
/* PAGE 224 */
struct yaz_iconv_trie_flat marc8r_31page224_flat[] = {
  {"\xA0", 0, 0x215535}, /* East Asian ideograph */
  {"\xA9", 0, 0x215536}, /* East Asian ideograph */
  {"\x85", 0, 0x215539}, /* East Asian ideograph */
  {"\x81", 0, 0x21553A}, /* East Asian ideograph */
  {"\xAF", 0, 0x21553C}, /* East Asian ideograph */
  {"\xB1", 0, 0x21553E}, /* East Asian ideograph */
  {"\x8C", 0, 0x215543}, /* East Asian ideograph */
  {"\x9C", 0, 0x215544}, /* East Asian ideograph */
  {"\x8A", 0, 0x215545}, /* East Asian ideograph */
  {"\xB2", 0, 0x215546}, /* East Asian ideograph */
  {"\x8F", 0, 0x227E41}, /* East Asian ideograph */
  {"\xB9", 0, 0x227E43}, /* East Asian ideograph */
  {"\xAA", 0, 0x227E52}, /* East Asian ideograph */
  {"\xBC", 0, 0x227E56}, /* East Asian ideograph */
  {"\xB6", 0, 0x227E57}, /* East Asian ideograph */
  {"\xA1", 0, 0x227E5A}, /* East Asian ideograph */
  {"\x86", 0, 0x227E60}, /* East Asian ideograph */
  {"\xAB", 0, 0x227E63}, /* East Asian ideograph */
  {"\xA2", 0, 0x227E6B}, /* East Asian ideograph */
  {"\x98", 0, 0x227E71}, /* East Asian ideograph */
  {"\xA5", 0, 0x227E72}, /* East Asian ideograph */
  {"\x8E", 0, 0x227E79}, /* East Asian ideograph */
  {"\x93", 0, 0x227E7B}, /* East Asian ideograph */
  {"\x96", 0, 0x227E7D}, /* East Asian ideograph */
  {"\xBD", 0, 0x232223}, /* East Asian ideograph */
  {"\x89", 0, 0x232229}, /* East Asian ideograph */
  {"\x9F", 0, 0x23222A}, /* East Asian ideograph */
  {"\xB3", 0, 0x23223C}, /* East Asian ideograph */
  {"\x91", 0, 0x232243}, /* East Asian ideograph */
  {"\xB7", 0, 0x2D3C49}, /* East Asian ideograph */
  {"\xB4", 0, 0x2D3C7C}, /* East Asian ideograph */
  {"\x80", 0, 0x2D546F}, /* East Asian ideograph */
  {"\x94", 0, 0x2D5573}, /* East Asian ideograph */
  {"\xBB", 0, 0x2D625F}, /* East Asian ideograph */
  {"\xB0", 0, 0x2E7D24}, /* East Asian ideograph */
  {"\x87", 0, 0x347D24}, /* East Asian ideograph */
  {"\x9D", 0, 0x395568}, /* East Asian ideograph */
  {"\xB8", 0, 0x4B496B}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page224 = {
  marc8r_31page224_flat, 0
};
/* PAGE 223 */
struct yaz_iconv_trie_flat marc8r_31page223_flat[] = {
  {"\x8E", 0, 0x215524}, /* East Asian ideograph */
  {"\x98", 0, 0x215525}, /* East Asian ideograph */
  {"\x9E", 0, 0x215526}, /* East Asian ideograph */
  {"\xA2", 0, 0x215528}, /* East Asian ideograph */
  {"\x96", 0, 0x215529}, /* East Asian ideograph */
  {"\xA7", 0, 0x21552A}, /* East Asian ideograph */
  {"\xAB", 0, 0x21552B}, /* East Asian ideograph */
  {"\x92", 0, 0x21552C}, /* East Asian ideograph (variant of EACC 4B552C) */
  {"\x8A", 0, 0x21552D}, /* East Asian ideograph */
  {"\x93", 0, 0x21552E}, /* East Asian ideograph */
  {"\xA0", 0, 0x21552F}, /* East Asian ideograph */
  {"\x89", 0, 0x215530}, /* East Asian ideograph */
  {"\xBD", 0, 0x21553F}, /* East Asian ideograph */
  {"\xA8", 0, 0x227D62}, /* East Asian ideograph */
  {"\xAD", 0, 0x227D67}, /* East Asian ideograph */
  {"\xB0", 0, 0x227D72}, /* East Asian ideograph */
  {"\x8F", 0, 0x227D7A}, /* East Asian ideograph */
  {"\x95", 0, 0x227D7C}, /* East Asian ideograph */
  {"\x99", 0, 0x227E22}, /* East Asian ideograph */
  {"\xA6", 0, 0x227E23}, /* East Asian ideograph */
  {"\x87", 0, 0x227E25}, /* East Asian ideograph */
  {"\xB9", 0, 0x227E26}, /* East Asian ideograph */
  {"\xA9", 0, 0x227E2B}, /* East Asian ideograph */
  {"\x9B", 0, 0x227E2F}, /* East Asian ideograph */
  {"\xAA", 0, 0x227E33}, /* East Asian ideograph */
  {"\x9C", 0, 0x227E37}, /* East Asian ideograph */
  {"\x9F", 0, 0x227E38}, /* East Asian ideograph */
  {"\xBF", 0, 0x227E6A}, /* East Asian ideograph */
  {"\x9A", 0, 0x232236}, /* East Asian ideograph */
  {"\xB7", 0, 0x274B29}, /* East Asian ideograph */
  {"\xB1", 0, 0x275541}, /* East Asian ideograph */
  {"\xB4", 0, 0x275555}, /* East Asian ideograph */
  {"\xB2", 0, 0x27556C}, /* East Asian ideograph */
  {"\xBA", 0, 0x276247}, /* East Asian ideograph */
  {"\xB3", 0, 0x292375}, /* East Asian ideograph */
  {"\xBC", 0, 0x29243A}, /* East Asian ideograph */
  {"\xB8", 0, 0x292574}, /* East Asian ideograph */
  {"\xB6", 0, 0x292658}, /* East Asian ideograph */
  {"\x86", 0, 0x2D555A}, /* East Asian ideograph */
  {"\x85", 0, 0x2D555B}, /* East Asian ideograph */
  {"\xB5", 0, 0x4D222A}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page223 = {
  marc8r_31page223_flat, 0
};
/* PAGE 222 */
struct yaz_iconv_trie_flat marc8r_31page222_flat[] = {
  {"\x92", 0, 0x215473}, /* East Asian ideograph */
  {"\x8A", 0, 0x215474}, /* East Asian ideograph */
  {"\x94", 0, 0x215476}, /* East Asian ideograph */
  {"\x90", 0, 0x215477}, /* East Asian ideograph */
  {"\x89", 0, 0x215478}, /* East Asian ideograph */
  {"\x80", 0, 0x21547D}, /* East Asian ideograph */
  {"\x8F", 0, 0x215522}, /* East Asian ideograph */
  {"\xB8", 0, 0x215527}, /* East Asian ideograph */
  {"\xB7", 0, 0x215531}, /* East Asian ideograph */
  {"\xBC", 0, 0x215532}, /* East Asian ideograph */
  {"\xBB", 0, 0x215533}, /* East Asian ideograph */
  {"\x84", 0, 0x227D2B}, /* East Asian ideograph */
  {"\x91", 0, 0x227D2E}, /* East Asian ideograph */
  {"\x96", 0, 0x227D3B}, /* East Asian ideograph */
  {"\x8D", 0, 0x227D4A}, /* East Asian ideograph */
  {"\x83", 0, 0x227D4D}, /* East Asian ideograph (variant of EACC 4C7D4D) */
  {"\x88", 0, 0x227D53}, /* East Asian ideograph */
  {"\x87", 0, 0x227D5F}, /* East Asian ideograph */
  {"\xB3", 0, 0x227D6D}, /* East Asian ideograph */
  {"\xB5", 0, 0x227D7E}, /* East Asian ideograph */
  {"\xBF", 0, 0x227E21}, /* East Asian ideograph */
  {"\xA3", 0, 0x274537}, /* East Asian ideograph */
  {"\xA6", 0, 0x274A5E}, /* East Asian ideograph */
  {"\x85", 0, 0x275023}, /* East Asian ideograph */
  {"\x9A", 0, 0x275528}, /* East Asian ideograph */
  {"\xA4", 0, 0x275553}, /* East Asian ideograph */
  {"\xAA", 0, 0x275563}, /* East Asian ideograph */
  {"\xAB", 0, 0x27556E}, /* East Asian ideograph */
  {"\xA1", 0, 0x275576}, /* East Asian ideograph */
  {"\xAF", 0, 0x275635}, /* East Asian ideograph */
  {"\xA5", 0, 0x284B43}, /* East Asian ideograph */
  {"\xA7", 0, 0x285323}, /* East Asian ideograph */
  {"\xAD", 0, 0x29233C}, /* East Asian ideograph */
  {"\xAE", 0, 0x29233D}, /* East Asian ideograph */
  {"\x9C", 0, 0x29247D}, /* East Asian ideograph */
  {"\xA8", 0, 0x292546}, /* East Asian ideograph */
  {"\x9B", 0, 0x29254B}, /* East Asian ideograph */
  {"\xAC", 0, 0x292567}, /* East Asian ideograph */
  {"\x9E", 0, 0x292571}, /* East Asian ideograph */
  {"\x9F", 0, 0x292657}, /* East Asian ideograph */
  {"\xA0", 0, 0x292661}, /* East Asian ideograph */
  {"\xA9", 0, 0x292668}, /* East Asian ideograph */
  {"\x98", 0, 0x2D552D}, /* East Asian ideograph */
  {"\xBD", 0, 0x2D5547}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page222 = {
  marc8r_31page222_flat, 0
};
/* PAGE 221 */
struct yaz_iconv_trie_flat marc8r_31page221_flat[] = {
  {"\x85", 0, 0x215461}, /* East Asian ideograph */
  {"\x89", 0, 0x215462}, /* East Asian ideograph */
  {"\x84", 0, 0x215466}, /* East Asian ideograph */
  {"\x82", 0, 0x215468}, /* East Asian ideograph */
  {"\x81", 0, 0x21546C}, /* East Asian ideograph */
  {"\xAB", 0, 0x215472}, /* East Asian ideograph */
  {"\xB8", 0, 0x215475}, /* East Asian ideograph */
  {"\xB5", 0, 0x215479}, /* East Asian ideograph */
  {"\xB4", 0, 0x21547A}, /* East Asian ideograph */
  {"\xB6", 0, 0x21547B}, /* East Asian ideograph */
  {"\xB1", 0, 0x21547C}, /* East Asian ideograph */
  {"\x97", 0, 0x21547E}, /* East Asian ideograph */
  {"\xB9", 0, 0x215523}, /* East Asian ideograph */
  {"\x80", 0, 0x227C5C}, /* East Asian ideograph */
  {"\xBA", 0, 0x227C63}, /* East Asian ideograph */
  {"\x87", 0, 0x227C67}, /* East Asian ideograph */
  {"\x94", 0, 0x227C6E}, /* East Asian ideograph */
  {"\x90", 0, 0x227C7B}, /* East Asian ideograph */
  {"\x8C", 0, 0x227D21}, /* East Asian ideograph */
  {"\xB3", 0, 0x227D26}, /* East Asian ideograph */
  {"\xA8", 0, 0x227D29}, /* East Asian ideograph */
  {"\x9B", 0, 0x227D35}, /* East Asian ideograph */
  {"\xA2", 0, 0x227D3F}, /* East Asian ideograph */
  {"\xAC", 0, 0x227D40}, /* East Asian ideograph */
  {"\xBC", 0, 0x227D48}, /* East Asian ideograph */
  {"\xAF", 0, 0x227D52}, /* East Asian ideograph */
  {"\x92", 0, 0x227D54}, /* East Asian ideograph */
  {"\x96", 0, 0x227D56}, /* East Asian ideograph */
  {"\x9A", 0, 0x227D58}, /* East Asian ideograph */
  {"\x9D", 0, 0x227D76}, /* East Asian ideograph */
  {"\xAD", 0, 0x27447C}, /* East Asian ideograph */
  {"\x83", 0, 0x275030}, /* East Asian ideograph */
  {"\xA7", 0, 0x275177}, /* East Asian ideograph */
  {"\x8E", 0, 0x275529}, /* East Asian ideograph */
  {"\x91", 0, 0x29252D}, /* East Asian ideograph */
  {"\x8F", 0, 0x292752}, /* East Asian ideograph */
  {"\x88", 0, 0x2D4450}, /* East Asian ideograph */
  {"\x86", 0, 0x2D5461}, /* East Asian ideograph */
  {"\x98", 0, 0x2D5476}, /* East Asian ideograph */
  {"\x9C", 0, 0x2E7C2E}, /* East Asian ideograph */
  {"\xB2", 0, 0x4B5521}, /* East Asian ideograph */
  {"\x95", 0, 0x4C5175}, /* East Asian ideograph */
  {"\xA3", 0, 0x4C7D6A}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page221 = {
  marc8r_31page221_flat, 0
};
/* PAGE 220 */
struct yaz_iconv_trie_flat marc8r_31page220_flat[] = {
  {"\xA7", 0, 0x215460}, /* East Asian ideograph */
  {"\xA3", 0, 0x215463}, /* East Asian ideograph */
  {"\x9B", 0, 0x215464}, /* East Asian ideograph */
  {"\xA6", 0, 0x215465}, /* East Asian ideograph */
  {"\xA5", 0, 0x215467}, /* East Asian ideograph */
  {"\x9C", 0, 0x215469}, /* East Asian ideograph */
  {"\x97", 0, 0x21546A}, /* East Asian ideograph */
  {"\xB1", 0, 0x21546B}, /* East Asian ideograph */
  {"\x93", 0, 0x21546D}, /* East Asian ideograph */
  {"\x94", 0, 0x21546E}, /* East Asian ideograph */
  {"\x91", 0, 0x21546F}, /* East Asian ideograph */
  {"\x9E", 0, 0x215470}, /* East Asian ideograph */
  {"\x9F", 0, 0x215471}, /* East Asian ideograph */
  {"\x99", 0, 0x227C55}, /* East Asian ideograph */
  {"\xBE", 0, 0x227C57}, /* East Asian ideograph */
  {"\xA0", 0, 0x227C5A}, /* East Asian ideograph */
  {"\x90", 0, 0x227C5B}, /* East Asian ideograph */
  {"\xAA", 0, 0x227C5F}, /* East Asian ideograph */
  {"\xB7", 0, 0x227C60}, /* East Asian ideograph */
  {"\xAF", 0, 0x227C62}, /* East Asian ideograph */
  {"\xA4", 0, 0x227C64}, /* East Asian ideograph */
  {"\x95", 0, 0x227C65}, /* East Asian ideograph */
  {"\xBA", 0, 0x227C68}, /* East Asian ideograph */
  {"\xB4", 0, 0x227C69}, /* East Asian ideograph */
  {"\xA2", 0, 0x227C6A}, /* East Asian ideograph */
  {"\x92", 0, 0x227C6D}, /* East Asian ideograph */
  {"\xAB", 0, 0x227C71}, /* East Asian ideograph */
  {"\x98", 0, 0x227C72}, /* East Asian ideograph */
  {"\xA1", 0, 0x227C73}, /* East Asian ideograph */
  {"\xB6", 0, 0x227C75}, /* East Asian ideograph */
  {"\xB3", 0, 0x227C7C}, /* East Asian ideograph */
  {"\xBB", 0, 0x227D22}, /* East Asian ideograph */
  {"\xBD", 0, 0x227D24}, /* East Asian ideograph */
  {"\x8B", 0, 0x27552A}, /* East Asian ideograph */
  {"\x87", 0, 0x27554D}, /* East Asian ideograph */
  {"\x8E", 0, 0x275564}, /* East Asian ideograph */
  {"\x8D", 0, 0x275567}, /* East Asian ideograph */
  {"\xB9", 0, 0x27563B}, /* East Asian ideograph */
  {"\x8F", 0, 0x27563C}, /* East Asian ideograph */
  {"\x8C", 0, 0x287E61}, /* East Asian ideograph */
  {"\x81", 0, 0x292535}, /* East Asian ideograph */
  {"\x88", 0, 0x292765}, /* East Asian ideograph */
  {"\x85", 0, 0x4B3354}, /* East Asian ideograph */
  {"\x8A", 0, 0x705C43}, /* East Asian ideograph */
  {"\x84", 0, 0x705C50}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page220 = {
  marc8r_31page220_flat, 0
};
/* PAGE 219 */
struct yaz_iconv_trie_flat marc8r_31page219_flat[] = {
  {"\x92", 0, 0x215451}, /* East Asian ideograph */
  {"\x8B", 0, 0x215452}, /* East Asian ideograph */
  {"\x8D", 0, 0x215453}, /* East Asian ideograph */
  {"\xB3", 0, 0x215454}, /* East Asian ideograph */
  {"\x9D", 0, 0x215455}, /* East Asian ideograph */
  {"\x99", 0, 0x215456}, /* East Asian ideograph */
  {"\xBD", 0, 0x215457}, /* East Asian ideograph */
  {"\xAD", 0, 0x215458}, /* East Asian ideograph */
  {"\xAC", 0, 0x215459}, /* East Asian ideograph */
  {"\xA5", 0, 0x21545A}, /* East Asian ideograph */
  {"\x9F", 0, 0x21545B}, /* East Asian ideograph */
  {"\xBB", 0, 0x21545C}, /* East Asian ideograph */
  {"\xB1", 0, 0x21545D}, /* East Asian ideograph */
  {"\xB9", 0, 0x21545E}, /* East Asian ideograph */
  {"\x88", 0, 0x216330}, /* East Asian ideograph */
  {"\x8E", 0, 0x227C24}, /* East Asian ideograph */
  {"\x91", 0, 0x227C25}, /* East Asian ideograph */
  {"\x8F", 0, 0x227C27}, /* East Asian ideograph */
  {"\x84", 0, 0x227C28}, /* East Asian ideograph */
  {"\x83", 0, 0x227C2D}, /* East Asian ideograph */
  {"\x8A", 0, 0x227C2E}, /* East Asian ideograph */
  {"\xAF", 0, 0x227C31}, /* East Asian ideograph */
  {"\xA7", 0, 0x227C34}, /* East Asian ideograph */
  {"\xAB", 0, 0x227C38}, /* East Asian ideograph */
  {"\xB0", 0, 0x227C3A}, /* East Asian ideograph */
  {"\xA4", 0, 0x227C3C}, /* East Asian ideograph */
  {"\x9A", 0, 0x227C3F}, /* East Asian ideograph */
  {"\xA3", 0, 0x227C42}, /* East Asian ideograph */
  {"\xB7", 0, 0x227C44}, /* East Asian ideograph */
  {"\xAE", 0, 0x227C45}, /* East Asian ideograph (variant of EACC 4C7C45) */
  {"\xA9", 0, 0x227C46}, /* East Asian ideograph */
  {"\xBC", 0, 0x227C49}, /* East Asian ideograph */
  {"\xA8", 0, 0x227C4C}, /* East Asian ideograph */
  {"\xB4", 0, 0x227C4E}, /* East Asian ideograph */
  {"\xA1", 0, 0x227C50}, /* East Asian ideograph */
  {"\xAA", 0, 0x227C53}, /* East Asian ideograph */
  {"\x82", 0, 0x275033}, /* East Asian ideograph */
  {"\x98", 0, 0x275568}, /* East Asian ideograph */
  {"\x9C", 0, 0x27557C}, /* East Asian ideograph */
  {"\xA6", 0, 0x27563A}, /* East Asian ideograph */
  {"\x97", 0, 0x292577}, /* East Asian ideograph */
  {"\xBE", 0, 0x355E76}, /* East Asian ideograph */
  {"\xB8", 0, 0x4B5631}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page219 = {
  marc8r_31page219_flat, 0
};
/* PAGE 218 */
struct yaz_iconv_trie_flat marc8r_31page218_flat[] = {
  {"\x87", 0, 0x215448}, /* East Asian ideograph */
  {"\x98", 0, 0x215449}, /* East Asian ideograph */
  {"\x99", 0, 0x21544A}, /* East Asian ideograph */
  {"\xA6", 0, 0x21544B}, /* East Asian ideograph */
  {"\xAE", 0, 0x21544C}, /* East Asian ideograph */
  {"\xAF", 0, 0x21544D}, /* East Asian ideograph */
  {"\xB1", 0, 0x21544E}, /* East Asian ideograph */
  {"\xB2", 0, 0x21544F}, /* East Asian ideograph */
  {"\xBE", 0, 0x215450}, /* East Asian ideograph */
  {"\x88", 0, 0x227B42}, /* East Asian ideograph */
  {"\x89", 0, 0x227B43}, /* East Asian ideograph */
  {"\x84", 0, 0x227B45}, /* East Asian ideograph */
  {"\x80", 0, 0x227B47}, /* East Asian ideograph */
  {"\x81", 0, 0x227B48}, /* East Asian ideograph */
  {"\x85", 0, 0x227B4A}, /* East Asian ideograph */
  {"\x8B", 0, 0x227B4B}, /* East Asian ideograph */
  {"\x8F", 0, 0x227B50}, /* East Asian ideograph */
  {"\x8E", 0, 0x227B53}, /* East Asian ideograph */
  {"\x96", 0, 0x227B56}, /* East Asian ideograph */
  {"\x97", 0, 0x227B57}, /* East Asian ideograph */
  {"\x9A", 0, 0x227B5E}, /* East Asian ideograph */
  {"\x9F", 0, 0x227B62}, /* East Asian ideograph */
  {"\xA2", 0, 0x227B67}, /* East Asian ideograph */
  {"\xA8", 0, 0x227B6B}, /* East Asian ideograph */
  {"\xAD", 0, 0x227B6F}, /* East Asian ideograph */
  {"\xB8", 0, 0x227B77}, /* East Asian ideograph */
  {"\xBF", 0, 0x227B7D}, /* East Asian ideograph */
  {"\xB0", 0, 0x27544E}, /* East Asian ideograph */
  {"\xBA", 0, 0x275631}, /* East Asian ideograph */
  {"\xBD", 0, 0x276030}, /* East Asian ideograph */
  {"\xB4", 0, 0x2D342E}, /* East Asian ideograph */
  {"\x8A", 0, 0x2D5447}, /* East Asian ideograph */
  {"\xB7", 0, 0x2D5959}, /* East Asian ideograph */
  {"\xAA", 0, 0x33456D}, /* East Asian ideograph */
  {"\xA4", 0, 0x344177}, /* East Asian ideograph */
  {"\xAB", 0, 0x39456D}, /* East Asian ideograph */
  {"\xA3", 0, 0x3F456D}, /* East Asian ideograph */
  {"\xB6", 0, 0x3F5959}, /* East Asian ideograph */
  {"\xB3", 0, 0x4B5959}, /* East Asian ideograph */
  {"\x9D", 0, 0x69675C}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page218 = {
  marc8r_31page218_flat, 0
};
/* PAGE 217 */
struct yaz_iconv_trie_dir marc8r_31page217_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x21542F} /* East Asian ideograph */,
  {0, 0, 0x227A70} /* East Asian ideograph */,
  {0, 0, 0x215430} /* East Asian ideograph */,
  {0, 0, 0x227A74} /* East Asian ideograph */,
  {0, 0, 0x227A75} /* East Asian ideograph */,
  {0, 0, 0x215431} /* East Asian ideograph */,
  {0, 0, 0x275B53} /* East Asian ideograph */,
  {0, 0, 0x215432} /* East Asian ideograph */,
  {0, 0, 0x215433} /* East Asian ideograph */,
  {0, 0, 0x215434} /* East Asian ideograph */,
  {0, 0, 0x215435} /* East Asian ideograph */,
  {0, 0, 0x227A77} /* East Asian ideograph */,
  {0, 0, 0x215436} /* East Asian ideograph */,
  {0, 0, 0x215437} /* East Asian ideograph */,
  {0, 0, 0x4B5437} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x215438} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x215439} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x21543A} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x2D5D65} /* East Asian ideograph */,
  {0, 0, 0x4B5D65} /* East Asian ideograph */,
  {0, 0, 0x2D6079} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x21543B} /* East Asian ideograph */,
  {0, 0, 0x21543C} /* East Asian ideograph */,
  {0, 0, 0x227B27} /* East Asian ideograph */,
  {0, 0, 0x21543D} /* East Asian ideograph */,
  {0, 0, 0x21543E} /* East Asian ideograph */,
  {0, 0, 0x227B29} /* East Asian ideograph */,
  {0, 0, 0x335446} /* East Asian ideograph */,
  {0, 0, 0x21543F} /* East Asian ideograph */,
  {0, 0, 0x4C4177} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x215443} /* East Asian ideograph */,
  {0, 0, 0x2D5446} /* East Asian ideograph */,
  {0, 0, 0x215440} /* East Asian ideograph */,
  {0, 0, 0x215441} /* East Asian ideograph */,
  {0, 0, 0x215442} /* East Asian ideograph */,
  {0, 0, 0x227B2E} /* East Asian ideograph */,
  {0, 0, 0x51456D} /* East Asian ideograph */,
  {0, 0, 0x227B2F} /* East Asian ideograph */,
  {0, 0, 0x27544B} /* East Asian ideograph */,
  {0, 0, 0x27544A} /* East Asian ideograph */,
  {0, 0, 0x227B3A} /* East Asian ideograph */,
  {0, 0, 0x227B35} /* East Asian ideograph */,
  {0, 0, 0x227B36} /* East Asian ideograph */,
  {0, 0, 0x215445} /* East Asian ideograph */,
  {0, 0, 0x215447} /* East Asian ideograph */,
  {0, 0, 0x215444} /* East Asian ideograph */,
  {0, 0, 0x227B32} /* East Asian ideograph */,
  {0, 0, 0x215446} /* East Asian ideograph */,
  {0, 0, 0x227B34} /* East Asian ideograph */,
  {0, 0, 0x4B456D} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x707438} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page217 = {
  0, marc8r_31page217_dir
};
/* PAGE 216 */
struct yaz_iconv_trie_flat marc8r_31page216_flat[] = {
  {"\x86", 0, 0x215373}, /* East Asian ideograph */
  {"\x83", 0, 0x215375}, /* East Asian ideograph */
  {"\x80", 0, 0x215376}, /* East Asian ideograph */
  {"\x82", 0, 0x215377}, /* East Asian ideograph */
  {"\x89", 0, 0x21537A}, /* East Asian ideograph */
  {"\x8D", 0, 0x21537C}, /* East Asian ideograph */
  {"\x8F", 0, 0x21537D}, /* East Asian ideograph */
  {"\x98", 0, 0x21537E}, /* East Asian ideograph */
  {"\x9A", 0, 0x215421}, /* East Asian ideograph */
  {"\x9F", 0, 0x215422}, /* East Asian ideograph */
  {"\xA3", 0, 0x215423}, /* East Asian ideograph */
  {"\xA5", 0, 0x215424}, /* East Asian ideograph */
  {"\xA8", 0, 0x215425}, /* East Asian ideograph */
  {"\xAA", 0, 0x215426}, /* East Asian ideograph */
  {"\xAC", 0, 0x215427}, /* East Asian ideograph */
  {"\xAD", 0, 0x215428}, /* East Asian ideograph */
  {"\xB3", 0, 0x215429}, /* East Asian ideograph */
  {"\xBA", 0, 0x21542B}, /* East Asian ideograph */
  {"\xBB", 0, 0x21542C}, /* East Asian ideograph */
  {"\xBC", 0, 0x21542D}, /* East Asian ideograph */
  {"\xBE", 0, 0x21542E}, /* East Asian ideograph */
  {"\x81", 0, 0x227A38}, /* East Asian ideograph */
  {"\x8C", 0, 0x227A39}, /* East Asian ideograph */
  {"\x8A", 0, 0x227A3A}, /* East Asian ideograph */
  {"\x84", 0, 0x227A3B}, /* East Asian ideograph */
  {"\x91", 0, 0x227A40}, /* East Asian ideograph */
  {"\x8E", 0, 0x227A41}, /* East Asian ideograph */
  {"\x90", 0, 0x227A43}, /* East Asian ideograph */
  {"\x9B", 0, 0x227A4B}, /* East Asian ideograph */
  {"\x9D", 0, 0x227A4F}, /* East Asian ideograph */
  {"\x9E", 0, 0x227A53}, /* East Asian ideograph */
  {"\xA0", 0, 0x227A56}, /* East Asian ideograph */
  {"\xA2", 0, 0x227A57}, /* East Asian ideograph */
  {"\xA7", 0, 0x227A5B}, /* East Asian ideograph */
  {"\xAF", 0, 0x227A60}, /* East Asian ideograph */
  {"\xB2", 0, 0x227A65}, /* East Asian ideograph */
  {"\xB6", 0, 0x227A68}, /* East Asian ideograph */
  {"\xB4", 0, 0x275163}, /* East Asian ideograph */
  {"\x88", 0, 0x2D537E}, /* East Asian ideograph */
  {"\x99", 0, 0x335347}, /* East Asian ideograph */
  {"\x95", 0, 0x3A7970}, /* East Asian ideograph */
  {"\x93", 0, 0x4B5422}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page216 = {
  marc8r_31page216_flat, 0
};
/* PAGE 215 */
struct yaz_iconv_trie_flat marc8r_31page215_flat[] = {
  {"\x80", 0, 0x215366}, /* East Asian ideograph */
  {"\x8F", 0, 0x215367}, /* East Asian ideograph */
  {"\x8A", 0, 0x215369}, /* East Asian ideograph */
  {"\x88", 0, 0x21536A}, /* East Asian ideograph */
  {"\x9D", 0, 0x21536B}, /* East Asian ideograph */
  {"\xA0", 0, 0x21536C}, /* East Asian ideograph */
  {"\x9B", 0, 0x21536D}, /* East Asian ideograph */
  {"\x9A", 0, 0x21536E}, /* East Asian ideograph */
  {"\x9C", 0, 0x21536F}, /* East Asian ideograph */
  {"\xB3", 0, 0x215370}, /* East Asian ideograph */
  {"\xA9", 0, 0x215371}, /* East Asian ideograph */
  {"\xA8", 0, 0x215372}, /* East Asian ideograph */
  {"\xBA", 0, 0x215374}, /* East Asian ideograph */
  {"\xBF", 0, 0x215378}, /* East Asian ideograph */
  {"\xBD", 0, 0x215379}, /* East Asian ideograph */
  {"\xBE", 0, 0x21537B}, /* East Asian ideograph */
  {"\x82", 0, 0x22794D}, /* East Asian ideograph */
  {"\x8B", 0, 0x227951}, /* East Asian ideograph */
  {"\x86", 0, 0x227952}, /* East Asian ideograph */
  {"\x83", 0, 0x227959}, /* East Asian ideograph */
  {"\x9F", 0, 0x22796A}, /* East Asian ideograph */
  {"\xA3", 0, 0x22796B}, /* East Asian ideograph */
  {"\x98", 0, 0x227970}, /* East Asian ideograph */
  {"\x95", 0, 0x227975}, /* East Asian ideograph */
  {"\x97", 0, 0x227977}, /* East Asian ideograph */
  {"\xAA", 0, 0x22797C}, /* East Asian ideograph */
  {"\xA6", 0, 0x22797D}, /* East Asian ideograph */
  {"\xB5", 0, 0x227A2C}, /* East Asian ideograph */
  {"\xB0", 0, 0x227A2E}, /* East Asian ideograph */
  {"\xB4", 0, 0x227A2F}, /* East Asian ideograph */
  {"\xB7", 0, 0x227A33}, /* East Asian ideograph */
  {"\xBB", 0, 0x227A37}, /* East Asian ideograph */
  {"\x91", 0, 0x27537D}, /* East Asian ideograph */
  {"\x93", 0, 0x2D535E}, /* East Asian ideograph */
  {"\xB8", 0, 0x4B6159}, /* East Asian ideograph */
  {"\xA4", 0, 0x696733}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page215 = {
  marc8r_31page215_flat, 0
};
/* PAGE 214 */
struct yaz_iconv_trie_flat marc8r_31page214_flat[] = {
  {"\x95", 0, 0x215353}, /* East Asian ideograph */
  {"\x94", 0, 0x215354}, /* East Asian ideograph */
  {"\x8B", 0, 0x215355}, /* East Asian ideograph */
  {"\x91", 0, 0x215356}, /* East Asian ideograph */
  {"\x90", 0, 0x215357}, /* East Asian ideograph */
  {"\x8E", 0, 0x215358}, /* East Asian ideograph */
  {"\x86", 0, 0x21535A}, /* East Asian ideograph */
  {"\xB1", 0, 0x21535C}, /* East Asian ideograph */
  {"\xB0", 0, 0x21535D}, /* East Asian ideograph */
  {"\xB8", 0, 0x21535E}, /* East Asian ideograph */
  {"\xA5", 0, 0x21535F}, /* East Asian ideograph */
  {"\xAE", 0, 0x215360}, /* East Asian ideograph */
  {"\xB3", 0, 0x215361}, /* East Asian ideograph */
  {"\xAB", 0, 0x215362}, /* East Asian ideograph */
  {"\xB9", 0, 0x215363}, /* East Asian ideograph */
  {"\xBA", 0, 0x215364}, /* East Asian ideograph */
  {"\xA6", 0, 0x215365}, /* East Asian ideograph */
  {"\xBF", 0, 0x215368}, /* East Asian ideograph */
  {"\x9A", 0, 0x22786A}, /* East Asian ideograph */
  {"\x88", 0, 0x22786D}, /* East Asian ideograph */
  {"\x8C", 0, 0x227877}, /* East Asian ideograph */
  {"\x93", 0, 0x22787C}, /* East Asian ideograph */
  {"\x81", 0, 0x22787D}, /* East Asian ideograph */
  {"\x8D", 0, 0x227925}, /* East Asian ideograph */
  {"\xA0", 0, 0x227932}, /* East Asian ideograph */
  {"\xA9", 0, 0x22793B}, /* East Asian ideograph */
  {"\xBC", 0, 0x22793C}, /* East Asian ideograph */
  {"\xA1", 0, 0x227941}, /* East Asian ideograph */
  {"\xB6", 0, 0x227946}, /* East Asian ideograph */
  {"\xB4", 0, 0x227947}, /* East Asian ideograph */
  {"\xA7", 0, 0x227948}, /* East Asian ideograph */
  {"\xAF", 0, 0x22794B}, /* East Asian ideograph */
  {"\xBB", 0, 0x275371}, /* East Asian ideograph */
  {"\x8A", 0, 0x27537E}, /* East Asian ideograph */
  {"\xBE", 0, 0x276144}, /* East Asian ideograph */
  {"\xBD", 0, 0x4C7959}, /* East Asian ideograph */
  {"\x9F", 0, 0x4C796B}, /* East Asian ideograph */
  {"\xAD", 0, 0x4D6047}, /* East Asian ideograph */
  {"\x99", 0, 0x706B6A}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page214 = {
  marc8r_31page214_flat, 0
};
/* PAGE 213 */
struct yaz_iconv_trie_flat marc8r_31page213_flat[] = {
  {"\x82", 0, 0x215343}, /* East Asian ideograph */
  {"\x85", 0, 0x215344}, /* East Asian ideograph */
  {"\x86", 0, 0x215349}, /* East Asian ideograph */
  {"\x8A", 0, 0x21534C}, /* East Asian ideograph */
  {"\x88", 0, 0x21534D}, /* East Asian ideograph */
  {"\xAB", 0, 0x21534E}, /* East Asian ideograph */
  {"\xAF", 0, 0x21534F}, /* East Asian ideograph */
  {"\x96", 0, 0x215350}, /* East Asian ideograph */
  {"\xA9", 0, 0x215352}, /* East Asian ideograph */
  {"\xB9", 0, 0x215359}, /* East Asian ideograph */
  {"\xBE", 0, 0x21535B}, /* East Asian ideograph */
  {"\x83", 0, 0x22783C}, /* East Asian ideograph */
  {"\x9D", 0, 0x227849}, /* East Asian ideograph */
  {"\x98", 0, 0x22784B}, /* East Asian ideograph */
  {"\xB0", 0, 0x227850}, /* East Asian ideograph */
  {"\xA4", 0, 0x227854}, /* East Asian ideograph */
  {"\x9B", 0, 0x227855}, /* East Asian ideograph */
  {"\xAA", 0, 0x227860}, /* East Asian ideograph */
  {"\x9E", 0, 0x227861}, /* East Asian ideograph */
  {"\xA1", 0, 0x227864}, /* East Asian ideograph */
  {"\x97", 0, 0x227866}, /* East Asian ideograph */
  {"\xBA", 0, 0x227869}, /* East Asian ideograph */
  {"\x89", 0, 0x27534D}, /* East Asian ideograph */
  {"\x91", 0, 0x275365}, /* East Asian ideograph */
  {"\x93", 0, 0x275378}, /* East Asian ideograph */
  {"\xB8", 0, 0x27537A}, /* East Asian ideograph */
  {"\x8D", 0, 0x27537B}, /* East Asian ideograph */
  {"\x90", 0, 0x27537C}, /* East Asian ideograph */
  {"\x8F", 0, 0x275422}, /* East Asian ideograph (duplicate simplified) */
  {"\xB6", 0, 0x287941}, /* East Asian ideograph */
  {"\x94", 0, 0x287A56}, /* East Asian ideograph */
  {"\xAC", 0, 0x2D5340}, /* East Asian ideograph */
  {"\x87", 0, 0x2D5344}, /* East Asian ideograph */
  {"\x9A", 0, 0x2D5361}, /* East Asian ideograph */
  {"\xA3", 0, 0x2D6F7D}, /* East Asian ideograph */
  {"\xB2", 0, 0x4B3B52}, /* East Asian ideograph */
  {"\xB3", 0, 0x4B5365}, /* East Asian ideograph */
  {"\x8E", 0, 0x706B5B}, /* East Asian ideograph */
  {"\x92", 0, 0x706B5F}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page213 = {
  marc8r_31page213_flat, 0
};
/* PAGE 212 */
struct yaz_iconv_trie_flat marc8r_31page212_flat[] = {
  {"\x96", 0, 0x215337}, /* East Asian ideograph */
  {"\x8C", 0, 0x215338}, /* East Asian ideograph */
  {"\xA5", 0, 0x215339}, /* East Asian ideograph */
  {"\x9A", 0, 0x21533A}, /* East Asian ideograph */
  {"\xA1", 0, 0x21533B}, /* East Asian ideograph */
  {"\x83", 0, 0x21533C}, /* East Asian ideograph */
  {"\x9B", 0, 0x21533D}, /* East Asian ideograph */
  {"\x84", 0, 0x21533E}, /* East Asian ideograph */
  {"\x8E", 0, 0x21533F}, /* East Asian ideograph */
  {"\x9E", 0, 0x215340}, /* East Asian ideograph */
  {"\xA4", 0, 0x215341}, /* East Asian ideograph */
  {"\xB0", 0, 0x215342}, /* East Asian ideograph */
  {"\xB1", 0, 0x215345}, /* East Asian ideograph */
  {"\xB4", 0, 0x215346}, /* East Asian ideograph */
  {"\xAD", 0, 0x215347}, /* East Asian ideograph */
  {"\xBD", 0, 0x215348}, /* East Asian ideograph */
  {"\xB3", 0, 0x21534A}, /* East Asian ideograph */
  {"\xB8", 0, 0x21534B}, /* East Asian ideograph */
  {"\xA0", 0, 0x227773}, /* East Asian ideograph */
  {"\x9F", 0, 0x22777B}, /* East Asian ideograph */
  {"\x82", 0, 0x22777D}, /* East Asian ideograph */
  {"\x99", 0, 0x227827}, /* East Asian ideograph */
  {"\x9D", 0, 0x22782A}, /* East Asian ideograph */
  {"\x8F", 0, 0x22782D}, /* East Asian ideograph */
  {"\x8D", 0, 0x22782F}, /* East Asian ideograph */
  {"\x97", 0, 0x227830}, /* East Asian ideograph */
  {"\xB2", 0, 0x227833}, /* East Asian ideograph */
  {"\xBA", 0, 0x227834}, /* East Asian ideograph */
  {"\xBE", 0, 0x227838}, /* East Asian ideograph */
  {"\xB9", 0, 0x227840}, /* East Asian ideograph */
  {"\xAF", 0, 0x227841}, /* East Asian ideograph */
  {"\x94", 0, 0x227842}, /* East Asian ideograph */
  {"\x9C", 0, 0x273437}, /* East Asian ideograph */
  {"\xA7", 0, 0x274366}, /* East Asian ideograph */
  {"\x81", 0, 0x275344}, /* East Asian ideograph */
  {"\x80", 0, 0x275359}, /* East Asian ideograph */
  {"\xB6", 0, 0x27536C}, /* East Asian ideograph */
  {"\x86", 0, 0x275379}, /* East Asian ideograph */
  {"\xAA", 0, 0x275421}, /* East Asian ideograph */
  {"\xAB", 0, 0x287855}, /* East Asian ideograph */
  {"\xA8", 0, 0x28786E}, /* East Asian ideograph */
  {"\xB7", 0, 0x2D534B}, /* East Asian ideograph */
  {"\xBC", 0, 0x3A787D}, /* East Asian ideograph */
  {"\xAC", 0, 0x706640}, /* East Asian ideograph */
  {"\xA9", 0, 0x706B4C}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page212 = {
  marc8r_31page212_flat, 0
};
/* PAGE 211 */
struct yaz_iconv_trie_flat marc8r_31page211_flat[] = {
  {"\x84", 0, 0x21527E}, /* East Asian ideograph */
  {"\x85", 0, 0x215321}, /* East Asian ideograph */
  {"\x87", 0, 0x215322}, /* East Asian ideograph */
  {"\x89", 0, 0x215323}, /* East Asian ideograph */
  {"\x8B", 0, 0x215324}, /* East Asian ideograph */
  {"\x8C", 0, 0x215325}, /* East Asian ideograph */
  {"\x93", 0, 0x215326}, /* East Asian ideograph */
  {"\x9D", 0, 0x215327}, /* East Asian ideograph */
  {"\x98", 0, 0x215328}, /* East Asian ideograph */
  {"\x9B", 0, 0x215329}, /* East Asian ideograph */
  {"\x9A", 0, 0x21532A}, /* East Asian ideograph */
  {"\x96", 0, 0x21532B}, /* East Asian ideograph */
  {"\xB2", 0, 0x21532C}, /* East Asian ideograph */
  {"\xAA", 0, 0x21532D}, /* East Asian ideograph */
  {"\xBA", 0, 0x21532E}, /* East Asian ideograph */
  {"\xA5", 0, 0x21532F}, /* East Asian ideograph */
  {"\xA2", 0, 0x215330}, /* East Asian ideograph */
  {"\xAB", 0, 0x215331}, /* East Asian ideograph */
  {"\xB1", 0, 0x215332}, /* East Asian ideograph */
  {"\xAF", 0, 0x215333}, /* East Asian ideograph */
  {"\xA1", 0, 0x215334}, /* East Asian ideograph */
  {"\xA9", 0, 0x215335}, /* East Asian ideograph */
  {"\xB4", 0, 0x215336}, /* East Asian ideograph */
  {"\x9C", 0, 0x222973}, /* East Asian ideograph */
  {"\x8A", 0, 0x227747}, /* East Asian ideograph */
  {"\x8E", 0, 0x227749}, /* East Asian ideograph */
  {"\x9F", 0, 0x22774E}, /* East Asian ideograph */
  {"\xA7", 0, 0x227760}, /* East Asian ideograph */
  {"\xB0", 0, 0x227761}, /* East Asian ideograph */
  {"\xB8", 0, 0x227768}, /* East Asian ideograph */
  {"\xB5", 0, 0x227769}, /* East Asian ideograph */
  {"\xA6", 0, 0x22776A}, /* East Asian ideograph */
  {"\x83", 0, 0x275321}, /* East Asian ideograph */
  {"\x90", 0, 0x27534A}, /* East Asian ideograph */
  {"\xBE", 0, 0x275358}, /* East Asian ideograph */
  {"\xA0", 0, 0x27535E}, /* East Asian ideograph */
  {"\xBF", 0, 0x275362}, /* East Asian ideograph */
  {"\xA4", 0, 0x27536E}, /* East Asian ideograph */
  {"\xAE", 0, 0x276153}, /* East Asian ideograph */
  {"\x86", 0, 0x2D3765}, /* East Asian ideograph */
  {"\xAD", 0, 0x2E3A33}, /* East Asian ideograph */
  {"\xBB", 0, 0x335333}, /* East Asian ideograph */
  {"\xAC", 0, 0x345E3B}, /* East Asian ideograph */
  {"\x80", 0, 0x4B527C}, /* East Asian ideograph */
  {"\xB7", 0, 0x4C794E}, /* East Asian ideograph */
  {"\xBC", 0, 0x706B42}, /* East Asian ideograph */
  {"\xBD", 0, 0x706B44}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page211 = {
  marc8r_31page211_flat, 0
};
/* PAGE 210 */
struct yaz_iconv_trie_flat marc8r_31page210_flat[] = {
  {"\x8A", 0, 0x21526D}, /* East Asian ideograph */
  {"\x86", 0, 0x21526E}, /* East Asian ideograph */
  {"\x96", 0, 0x21526F}, /* East Asian ideograph */
  {"\x98", 0, 0x215270}, /* East Asian ideograph */
  {"\x9E", 0, 0x215271}, /* East Asian ideograph */
  {"\x9A", 0, 0x215272}, /* East Asian ideograph */
  {"\xB1", 0, 0x215273}, /* East Asian ideograph */
  {"\xB2", 0, 0x215274}, /* East Asian ideograph */
  {"\xB3", 0, 0x215275}, /* East Asian ideograph */
  {"\xB0", 0, 0x215276}, /* East Asian ideograph */
  {"\xAF", 0, 0x215277}, /* East Asian ideograph */
  {"\xB7", 0, 0x215278}, /* East Asian ideograph */
  {"\xB6", 0, 0x215279}, /* East Asian ideograph */
  {"\xBE", 0, 0x21527A}, /* East Asian ideograph */
  {"\xBD", 0, 0x21527B}, /* East Asian ideograph */
  {"\xBF", 0, 0x21527C}, /* East Asian ideograph */
  {"\x81", 0, 0x22766B}, /* East Asian ideograph */
  {"\x83", 0, 0x227670}, /* East Asian ideograph */
  {"\x92", 0, 0x22767B}, /* East Asian ideograph */
  {"\xA2", 0, 0x22767E}, /* East Asian ideograph */
  {"\xA3", 0, 0x227728}, /* East Asian ideograph */
  {"\xAC", 0, 0x227732}, /* East Asian ideograph */
  {"\xB5", 0, 0x227739}, /* East Asian ideograph */
  {"\xBB", 0, 0x22773E}, /* East Asian ideograph */
  {"\xB9", 0, 0x22773F}, /* East Asian ideograph */
  {"\xAA", 0, 0x275276}, /* East Asian ideograph */
  {"\x94", 0, 0x275277}, /* East Asian ideograph */
  {"\x8C", 0, 0x275278}, /* East Asian ideograph */
  {"\x82", 0, 0x275279}, /* East Asian ideograph */
  {"\x8B", 0, 0x27527A}, /* East Asian ideograph */
  {"\xA9", 0, 0x287739}, /* East Asian ideograph */
  {"\x8D", 0, 0x28773F}, /* East Asian ideograph */
  {"\xB4", 0, 0x2D527B}, /* East Asian ideograph */
  {"\xA1", 0, 0x335276}, /* East Asian ideograph */
  {"\x9F", 0, 0x4B3A2F}, /* East Asian ideograph */
  {"\xA8", 0, 0x4B5277}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page210 = {
  marc8r_31page210_flat, 0
};
/* PAGE 209 */
struct yaz_iconv_trie_flat marc8r_31page209_flat[] = {
  {"\x80", 0, 0x21525B}, /* East Asian ideograph */
  {"\x81", 0, 0x21525C}, /* East Asian ideograph */
  {"\x83", 0, 0x21525D}, /* East Asian ideograph */
  {"\x86", 0, 0x21525E}, /* East Asian ideograph */
  {"\x85", 0, 0x21525F}, /* East Asian ideograph */
  {"\x8C", 0, 0x215260}, /* East Asian ideograph */
  {"\x90", 0, 0x215261}, /* East Asian ideograph */
  {"\x8D", 0, 0x215262}, /* East Asian ideograph */
  {"\x92", 0, 0x215263}, /* East Asian ideograph */
  {"\x95", 0, 0x215264}, /* East Asian ideograph */
  {"\x98", 0, 0x215265}, /* East Asian ideograph */
  {"\x99", 0, 0x215266}, /* East Asian ideograph */
  {"\x97", 0, 0x215267}, /* East Asian ideograph */
  {"\x9C", 0, 0x215268}, /* East Asian ideograph */
  {"\xB3", 0, 0x215269}, /* East Asian ideograph */
  {"\xB6", 0, 0x21526A}, /* East Asian ideograph */
  {"\xBF", 0, 0x21526B}, /* East Asian ideograph */
  {"\xBD", 0, 0x21526C}, /* East Asian ideograph */
  {"\x84", 0, 0x22762E}, /* East Asian ideograph */
  {"\x88", 0, 0x227631}, /* East Asian ideograph */
  {"\x8B", 0, 0x227633}, /* East Asian ideograph */
  {"\x8E", 0, 0x227634}, /* East Asian ideograph */
  {"\x91", 0, 0x227635}, /* East Asian ideograph */
  {"\x8F", 0, 0x227636}, /* East Asian ideograph */
  {"\x94", 0, 0x227637}, /* East Asian ideograph */
  {"\x96", 0, 0x227639}, /* East Asian ideograph */
  {"\x9F", 0, 0x22763B}, /* East Asian ideograph */
  {"\x9E", 0, 0x22763D}, /* East Asian ideograph */
  {"\x9D", 0, 0x22763E}, /* East Asian ideograph */
  {"\xA5", 0, 0x22764B}, /* East Asian ideograph */
  {"\xA6", 0, 0x22764C}, /* East Asian ideograph */
  {"\xAA", 0, 0x22764D}, /* East Asian ideograph */
  {"\xA9", 0, 0x22764E}, /* East Asian ideograph */
  {"\xA8", 0, 0x22764F}, /* East Asian ideograph */
  {"\xB0", 0, 0x22765B}, /* East Asian ideograph */
  {"\xB1", 0, 0x22765D}, /* East Asian ideograph */
  {"\xB5", 0, 0x227660}, /* East Asian ideograph */
  {"\xB9", 0, 0x227669}, /* East Asian ideograph */
  {"\xB8", 0, 0x275275}, /* East Asian ideograph */
  {"\xA7", 0, 0x287655}, /* East Asian ideograph */
  {"\xBB", 0, 0x2D3E3C}, /* East Asian ideograph */
  {"\xA4", 0, 0x2D562E}, /* East Asian ideograph */
  {"\xA1", 0, 0x2D5D68}, /* East Asian ideograph */
  {"\xA0", 0, 0x2E684E}, /* East Asian ideograph */
  {"\xB7", 0, 0x2E765F}, /* East Asian ideograph */
  {"\xA2", 0, 0x344138}, /* East Asian ideograph */
  {"\x82", 0, 0x4B525C}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page209 = {
  marc8r_31page209_flat, 0
};
/* PAGE 208 */
struct yaz_iconv_trie_dir marc8r_31page208_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x293B5B} /* East Asian ideograph */,
  {0, 0, 0x293B59} /* East Asian ideograph */,
  {0, 0, 0x275B3D} /* East Asian ideograph */,
  {0, 0, 0x275B42} /* East Asian ideograph */,
  {0, 0, 0x275B41} /* East Asian ideograph */,
  {0, 0, 0x275B46} /* East Asian ideograph */,
  {0, 0, 0x275B45} /* East Asian ideograph */,
  {0, 0, 0x275B49} /* East Asian ideograph */,
  {0, 0, 0x275B48} /* East Asian ideograph */,
  {0, 0, 0x293B6D} /* East Asian ideograph */,
  {0, 0, 0x293B6B} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x275B47} /* East Asian ideograph */,
  {0, 0, 0x275B4B} /* East Asian ideograph */,
  {0, 0, 0x293B7A} /* East Asian ideograph */,
  {0, 0, 0x275B4C} /* East Asian ideograph */,
  {0, 0, 0x275B4D} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x275B4E} /* East Asian ideograph */,
  {0, 0, 0x275B59} /* East Asian ideograph */,
  {0, 0, 0x275B51} /* East Asian ideograph */,
  {0, 0, 0x275B4F} /* East Asian ideograph */,
  {0, 0, 0x275B50} /* East Asian ideograph */,
  {0, 0, 0x293C30} /* East Asian ideograph */,
  {0, 0, 0x275B54} /* East Asian ideograph */,
  {0, 0, 0x275B56} /* East Asian ideograph */,
  {0, 0, 0x215B5A} /* East Asian ideograph */,
  {0, 0, 0x215B5B} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x275B60} /* East Asian ideograph */,
  {0, 0, 0x215B5C} /* East Asian ideograph */,
  {0, 0, 0x2D5232} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x2D5B5D} /* East Asian ideograph */,
  {0, 0, 0x215B5D} /* East Asian ideograph */,
  {0, 0, 0x233C65} /* East Asian ideograph */,
  {0, 0, 0x233C66} /* East Asian ideograph */,
  {0, 0, 0x215B5F} /* East Asian ideograph */,
  {0, 0, 0x2D5B5E} /* East Asian ideograph */,
  {0, 0, 0x215B5E} /* East Asian ideograph */,
  {0, 0, 0x275B61} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x27517A} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x215B60} /* East Asian ideograph */,
  {0, 0, 0x21517A} /* East Asian ideograph */,
  {0, 0, 0x215B61} /* East Asian ideograph */,
  {0, 0, 0x215B62} /* East Asian ideograph */,
  {0, 0, 0x215B63} /* East Asian ideograph */,
  {0, 0, 0x215B64} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x233C6C} /* East Asian ideograph */,
  {0, 0, 0x4D3C6C} /* East Asian ideograph */,
  {0, 0, 0x233C6D} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x275C5B} /* East Asian ideograph */,
  {0, 0, 0x4B5C5B} /* East Asian ideograph */,
  {0, 0, 0x233C6E} /* East Asian ideograph */,
  {0, 0, 0x233C70} /* East Asian ideograph */,
  {0, 0, 0x275C52} /* East Asian ideograph */,
  {0, 0, 0x275C39} /* East Asian ideograph */,
  {0, 0, 0x233C74} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page208 = {
  0, marc8r_31page208_dir
};
/* PAGE 207 */
struct yaz_iconv_trie_flat marc8r_31page207_flat[] = {
  {"\xAC", 0, 0x214F22}, /* East Asian ideograph */
  {"\x8D", 0, 0x215534}, /* East Asian ideograph */
  {"\x83", 0, 0x215538}, /* East Asian ideograph */
  {"\x8B", 0, 0x21553B}, /* East Asian ideograph */
  {"\x8A", 0, 0x215541}, /* East Asian ideograph */
  {"\x8C", 0, 0x215542}, /* East Asian ideograph */
  {"\x8E", 0, 0x215547}, /* East Asian ideograph */
  {"\x84", 0, 0x215548}, /* East Asian ideograph */
  {"\xBD", 0, 0x215549}, /* East Asian ideograph */
  {"\xB1", 0, 0x21554B}, /* East Asian ideograph */
  {"\xBC", 0, 0x215554}, /* East Asian ideograph */
  {"\xB5", 0, 0x215555}, /* East Asian ideograph */
  {"\xB8", 0, 0x215559}, /* East Asian ideograph */
  {"\xA1", 0, 0x227E45}, /* East Asian ideograph */
  {"\xA3", 0, 0x227E51}, /* East Asian ideograph */
  {"\x93", 0, 0x227E53}, /* East Asian ideograph */
  {"\x90", 0, 0x227E59}, /* East Asian ideograph */
  {"\x87", 0, 0x227E61}, /* East Asian ideograph */
  {"\x81", 0, 0x227E6D}, /* East Asian ideograph */
  {"\x98", 0, 0x227E74}, /* East Asian ideograph */
  {"\x9E", 0, 0x232225}, /* East Asian ideograph */
  {"\x9F", 0, 0x23222C}, /* East Asian ideograph */
  {"\x8F", 0, 0x23222E}, /* East Asian ideograph */
  {"\x91", 0, 0x232230}, /* East Asian ideograph */
  {"\xB9", 0, 0x23224C}, /* East Asian ideograph */
  {"\xBE", 0, 0x23226E}, /* East Asian ideograph */
  {"\xB2", 0, 0x232324}, /* East Asian ideograph */
  {"\xAA", 0, 0x23232D}, /* East Asian ideograph */
  {"\xA9", 0, 0x23232E}, /* East Asian ideograph */
  {"\xA5", 0, 0x274A2E}, /* East Asian ideograph */
  {"\xA6", 0, 0x275161}, /* East Asian ideograph */
  {"\xA7", 0, 0x275622}, /* East Asian ideograph */
  {"\xA8", 0, 0x27562A}, /* East Asian ideograph */
  {"\x9D", 0, 0x275642}, /* East Asian ideograph */
  {"\xA4", 0, 0x275724}, /* East Asian ideograph */
  {"\x86", 0, 0x335568}, /* East Asian ideograph */
  {"\xA0", 0, 0x4B5542}, /* East Asian ideograph */
  {"\xA2", 0, 0x69684D}, /* East Asian ideograph */
  {"\x9C", 0, 0x705D46}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page207 = {
  marc8r_31page207_flat, 0
};
/* PAGE 206 */
struct yaz_iconv_trie_flat marc8r_31page206_flat[] = {
  {"\x85", 0, 0x21524A}, /* East Asian ideograph */
  {"\x81", 0, 0x21524B}, /* East Asian ideograph */
  {"\x8C", 0, 0x21524C}, /* East Asian ideograph */
  {"\x92", 0, 0x21524D}, /* East Asian ideograph */
  {"\x8E", 0, 0x21524E}, /* East Asian ideograph (variant of EACC 4B524E) */
  {"\x94", 0, 0x21524F}, /* East Asian ideograph */
  {"\x95", 0, 0x215250}, /* East Asian ideograph */
  {"\xA0", 0, 0x215251}, /* East Asian ideograph */
  {"\xA1", 0, 0x215252}, /* East Asian ideograph */
  {"\x9F", 0, 0x215253}, /* East Asian ideograph */
  {"\xA9", 0, 0x215254}, /* East Asian ideograph */
  {"\xB0", 0, 0x215255}, /* East Asian ideograph */
  {"\xB3", 0, 0x215256}, /* East Asian ideograph */
  {"\xBC", 0, 0x215257}, /* East Asian ideograph */
  {"\xB9", 0, 0x215258}, /* East Asian ideograph */
  {"\xBB", 0, 0x215259}, /* East Asian ideograph */
  {"\xB1", 0, 0x21525A}, /* East Asian ideograph */
  {"\x83", 0, 0x227551}, /* East Asian ideograph */
  {"\x8A", 0, 0x227557}, /* East Asian ideograph */
  {"\x9B", 0, 0x227567}, /* East Asian ideograph */
  {"\xA3", 0, 0x227568}, /* East Asian ideograph */
  {"\xA6", 0, 0x22756C}, /* East Asian ideograph */
  {"\xA5", 0, 0x22756F}, /* East Asian ideograph */
  {"\xAC", 0, 0x227572}, /* East Asian ideograph */
  {"\xAB", 0, 0x227573}, /* East Asian ideograph */
  {"\xAF", 0, 0x227577}, /* East Asian ideograph */
  {"\xAE", 0, 0x22757A}, /* East Asian ideograph */
  {"\xBD", 0, 0x227629}, /* East Asian ideograph */
  {"\xBE", 0, 0x22762A}, /* East Asian ideograph */
  {"\xBF", 0, 0x22762C}, /* East Asian ideograph */
  {"\x86", 0, 0x275251}, /* East Asian ideograph */
  {"\x98", 0, 0x275258}, /* East Asian ideograph */
  {"\x84", 0, 0x2D524A}, /* East Asian ideograph */
  {"\xBA", 0, 0x4B525A}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page206 = {
  marc8r_31page206_flat, 0
};
/* PAGE 205 */
struct yaz_iconv_trie_flat marc8r_31page205_flat[] = {
  {"\x85", 0, 0x215237}, /* East Asian ideograph */
  {"\x88", 0, 0x215238}, /* East Asian ideograph */
  {"\x8A", 0, 0x215239}, /* East Asian ideograph */
  {"\x8C", 0, 0x21523A}, /* East Asian ideograph */
  {"\x8E", 0, 0x21523B}, /* East Asian ideograph */
  {"\x94", 0, 0x21523C}, /* East Asian ideograph */
  {"\x9E", 0, 0x21523D}, /* East Asian ideograph */
  {"\x9A", 0, 0x21523E}, /* East Asian ideograph */
  {"\xA8", 0, 0x215240}, /* East Asian ideograph */
  {"\xA4", 0, 0x215241}, /* East Asian ideograph */
  {"\xA9", 0, 0x215242}, /* East Asian ideograph */
  {"\xAF", 0, 0x215243}, /* East Asian ideograph */
  {"\xB2", 0, 0x215244}, /* East Asian ideograph */
  {"\xB6", 0, 0x215245}, /* East Asian ideograph */
  {"\xB8", 0, 0x215246}, /* East Asian ideograph */
  {"\xB9", 0, 0x215247}, /* East Asian ideograph */
  {"\xBD", 0, 0x215248}, /* East Asian ideograph */
  {"\xBF", 0, 0x215249}, /* East Asian ideograph */
  {"\x86", 0, 0x227472}, /* East Asian ideograph */
  {"\x91", 0, 0x22747A}, /* East Asian ideograph */
  {"\x96", 0, 0x22747E}, /* East Asian ideograph */
  {"\x97", 0, 0x227523}, /* East Asian ideograph */
  {"\x95", 0, 0x227524}, /* East Asian ideograph */
  {"\xA2", 0, 0x22752C}, /* East Asian ideograph */
  {"\xA7", 0, 0x227533}, /* East Asian ideograph */
  {"\xB0", 0, 0x22753B}, /* East Asian ideograph */
  {"\xAD", 0, 0x22753C}, /* East Asian ideograph */
  {"\xB1", 0, 0x22753F}, /* East Asian ideograph */
  {"\xB4", 0, 0x227540}, /* East Asian ideograph */
  {"\xB5", 0, 0x227542}, /* East Asian ideograph */
  {"\xBC", 0, 0x22754A}, /* East Asian ideograph */
  {"\xBE", 0, 0x22754C}, /* East Asian ideograph */
  {"\x81", 0, 0x275238}, /* East Asian ideograph */
  {"\x9F", 0, 0x287531}, /* East Asian ideograph */
  {"\x9D", 0, 0x2D4A58}, /* East Asian ideograph */
  {"\xA1", 0, 0x2D5240}, /* East Asian ideograph */
  {"\xA3", 0, 0x2D5241}, /* East Asian ideograph */
  {"\x82", 0, 0x2E7450}, /* East Asian ideograph */
  {"\x87", 0, 0x4B5238}, /* East Asian ideograph */
  {"\xAE", 0, 0x4B5247}, /* East Asian ideograph */
  {"\x83", 0, 0x4B6A22}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page205 = {
  marc8r_31page205_flat, 0
};
/* PAGE 204 */
struct yaz_iconv_trie_flat marc8r_31page204_flat[] = {
  {"\x84", 0, 0x215229}, /* East Asian ideograph */
  {"\x90", 0, 0x21522B}, /* East Asian ideograph */
  {"\x95", 0, 0x21522C}, /* East Asian ideograph */
  {"\x94", 0, 0x21522D}, /* East Asian ideograph */
  {"\x9F", 0, 0x21522E}, /* East Asian ideograph */
  {"\xB2", 0, 0x21522F}, /* East Asian ideograph */
  {"\xAE", 0, 0x215230}, /* East Asian ideograph */
  {"\xA9", 0, 0x215231}, /* East Asian ideograph */
  {"\xAA", 0, 0x215232}, /* East Asian ideograph */
  {"\xB0", 0, 0x215233}, /* East Asian ideograph */
  {"\xB5", 0, 0x215234}, /* East Asian ideograph */
  {"\xB7", 0, 0x215235}, /* East Asian ideograph */
  {"\xB9", 0, 0x215236}, /* East Asian ideograph */
  {"\x83", 0, 0x227425}, /* East Asian ideograph */
  {"\x86", 0, 0x227427}, /* East Asian ideograph */
  {"\x85", 0, 0x227428}, /* East Asian ideograph */
  {"\x8B", 0, 0x22742B}, /* East Asian ideograph */
  {"\x8C", 0, 0x22742E}, /* East Asian ideograph */
  {"\x8D", 0, 0x22742F}, /* East Asian ideograph */
  {"\x8E", 0, 0x227431}, /* East Asian ideograph */
  {"\x8F", 0, 0x227432}, /* East Asian ideograph */
  {"\xA0", 0, 0x22743E}, /* East Asian ideograph */
  {"\xA1", 0, 0x22743F}, /* East Asian ideograph */
  {"\x9D", 0, 0x227443}, /* East Asian ideograph */
  {"\x9B", 0, 0x227445}, /* East Asian ideograph */
  {"\xA3", 0, 0x227447}, /* East Asian ideograph */
  {"\xA5", 0, 0x227450}, /* East Asian ideograph */
  {"\xA6", 0, 0x227451}, /* East Asian ideograph */
  {"\xAD", 0, 0x227453}, /* East Asian ideograph */
  {"\xAB", 0, 0x227454}, /* East Asian ideograph */
  {"\xA7", 0, 0x227455}, /* East Asian ideograph */
  {"\xA8", 0, 0x227457}, /* East Asian ideograph */
  {"\xB1", 0, 0x22745E}, /* East Asian ideograph */
  {"\xB3", 0, 0x227460}, /* East Asian ideograph */
  {"\xB6", 0, 0x227463}, /* East Asian ideograph */
  {"\xBF", 0, 0x22746A}, /* East Asian ideograph */
  {"\xBE", 0, 0x22746B}, /* East Asian ideograph */
  {"\xBD", 0, 0x22746C}, /* East Asian ideograph */
  {"\x97", 0, 0x273761}, /* East Asian ideograph (duplicate simplified) */
  {"\x91", 0, 0x275148}, /* East Asian ideograph */
  {"\x9A", 0, 0x275233}, /* East Asian ideograph */
  {"\xA2", 0, 0x275235}, /* East Asian ideograph */
  {"\x82", 0, 0x28742E}, /* East Asian ideograph */
  {"\xB4", 0, 0x287472}, /* East Asian ideograph */
  {"\xB8", 0, 0x2D5233}, /* East Asian ideograph */
  {"\x88", 0, 0x2E7431}, /* East Asian ideograph */
  {"\x98", 0, 0x2E7451}, /* East Asian ideograph */
  {"\x87", 0, 0x334550}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page204 = {
  marc8r_31page204_flat, 0
};
/* PAGE 203 */
struct yaz_iconv_trie_dir marc8r_31page203_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x275146} /* East Asian ideograph */,
  {0, 0, 0x275151} /* East Asian ideograph */,
  {0, 0, 0x28722A} /* East Asian ideograph */,
  {0, 0, 0x287231} /* East Asian ideograph */,
  {0, 0, 0x275156} /* East Asian ideograph */,
  {0, 0, 0x275157} /* East Asian ideograph */,
  {0, 0, 0x275224} /* East Asian ideograph */,
  {0, 0, 0x287236} /* East Asian ideograph */,
  {0, 0, 0x28723C} /* East Asian ideograph */,
  {0, 0, 0x275158} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x4B5179} /* East Asian ideograph */,
  {0, 0, 0x28723E} /* East Asian ideograph */,
  {0, 0, 0x27515D} /* East Asian ideograph */,
  {0, 0, 0x27515E} /* East Asian ideograph */,
  {0, 0, 0x287248} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x287247} /* East Asian ideograph */,
  {0, 0, 0x287253} /* East Asian ideograph */,
  {0, 0, 0x275159} /* East Asian ideograph */,
  {0, 0, 0x275152} /* East Asian ideograph */,
  {0, 0, 0x275168} /* East Asian ideograph */,
  {0, 0, 0x27515B} /* East Asian ideograph */,
  {0, 0, 0x287229} /* East Asian ideograph */,
  {0, 0, 0x27515A} /* East Asian ideograph */,
  {0, 0, 0x28725E} /* East Asian ideograph */,
  {0, 0, 0x275162} /* East Asian ideograph */,
  {0, 0, 0x28725F} /* East Asian ideograph */,
  {0, 0, 0x28725D} /* East Asian ideograph */,
  {0, 0, 0x27516C} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x287251} /* East Asian ideograph */,
  {0, 0, 0x27517E} /* East Asian ideograph */,
  {0, 0, 0x287272} /* East Asian ideograph */,
  {0, 0, 0x275160} /* East Asian ideograph */,
  {0, 0, 0x27515F} /* East Asian ideograph */,
  {0, 0, 0x27517B} /* East Asian ideograph */,
  {0, 0, 0x287279} /* East Asian ideograph */,
  {0, 0, 0x287321} /* East Asian ideograph */,
  {0, 0, 0x275169} /* East Asian ideograph */,
  {0, 0, 0x275222} /* East Asian ideograph */,
  {0, 0, 0x275165} /* East Asian ideograph */,
  {0, 0, 0x275167} /* East Asian ideograph */,
  {0, 0, 0x27516F} /* East Asian ideograph */,
  {0, 0, 0x287360} /* East Asian ideograph */,
  {0, 0, 0x275174} /* East Asian ideograph */,
  {0, 0, 0x275170} /* East Asian ideograph */,
  {0, 0, 0x28732D} /* East Asian ideograph */,
  {0, 0, 0x287349} /* East Asian ideograph */,
  {0, 0, 0x287359} /* East Asian ideograph */,
  {0, 0, 0x28734E} /* East Asian ideograph */,
  {0, 0, 0x287351} /* East Asian ideograph */,
  {0, 0, 0x287352} /* East Asian ideograph */,
  {0, 0, 0x287374} /* East Asian ideograph */,
  {0, 0, 0x4B522B} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x215226} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x215227} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x215228} /* East Asian ideograph */,
  {0, 0, 0x2D4B71} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page203 = {
  0, marc8r_31page203_dir
};
/* PAGE 202 */
struct yaz_iconv_trie_dir marc8r_31page202_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x22735B} /* East Asian ideograph */,
  {0, 0, 0x21517C} /* East Asian ideograph */,
  {0, 0, 0x69656D} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x227364} /* East Asian ideograph */,
  {0, 0, 0x22735E} /* East Asian ideograph */,
  {0, 0, 0x227360} /* East Asian ideograph */,
  {0, 0, 0x2E7374} /* East Asian ideograph */,
  {0, 0, 0x22735D} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x215221} /* East Asian ideograph */,
  {0, 0, 0x33512E} /* East Asian ideograph */,
  {0, 0, 0x335223} /* East Asian ideograph */,
  {0, 0, 0x21517E} /* East Asian ideograph */,
  {0, 0, 0x696576} /* East Asian ideograph */,
  {0, 0, 0x22736A} /* East Asian ideograph */,
  {0, 0, 0x4B517E} /* East Asian ideograph */,
  {0, 0, 0x215222} /* East Asian ideograph */,
  {0, 0, 0x22736D} /* East Asian ideograph */,
  {0, 0, 0x22736B} /* East Asian ideograph */,
  {0, 0, 0x215223} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x227374} /* East Asian ideograph */,
  {0, 0, 0x227373} /* East Asian ideograph */,
  {0, 0, 0x227371} /* East Asian ideograph */,
  {0, 0, 0x227370} /* East Asian ideograph */,
  {0, 0, 0x215224} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x51513B} /* East Asian ideograph */,
  {0, 0, 0x27506F} /* East Asian ideograph */,
  {0, 0, 0x287042} /* East Asian ideograph */,
  {0, 0, 0x275072} /* East Asian ideograph */,
  {0, 0, 0x275071} /* East Asian ideograph */,
  {0, 0, 0x275223} /* East Asian ideograph */,
  {0, 0, 0x275075} /* East Asian ideograph */,
  {0, 0, 0x275074} /* East Asian ideograph */,
  {0, 0, 0x275123} /* East Asian ideograph */,
  {0, 0, 0x287045} /* East Asian ideograph */,
  {0, 0, 0x28735D} /* East Asian ideograph */,
  {0, 0, 0x275070} /* East Asian ideograph */,
  {0, 0, 0x275073} /* East Asian ideograph */,
  {0, 0, 0x275153} /* East Asian ideograph */,
  {0, 0, 0x27507A} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x27507D} /* East Asian ideograph */,
  {0, 0, 0x27507C} /* East Asian ideograph */,
  {0, 0, 0x275121} /* East Asian ideograph */,
  {0, 0, 0x275149} /* East Asian ideograph */,
  {0, 0, 0x275122} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x27516E} /* East Asian ideograph */,
  {0, 0, 0x275150} /* East Asian ideograph */,
  {0, 0, 0x275125} /* East Asian ideograph */,
  {0, 0, 0x275124} /* East Asian ideograph */,
  {0, 0, 0x275077} /* East Asian ideograph */,
  {0, 0, 0x275076} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x27507E} /* East Asian ideograph */,
  {0, 0, 0x28704A} /* East Asian ideograph */,
  {0, 0, 0x27515C} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page202 = {
  0, marc8r_31page202_dir
};
/* PAGE 201 */
struct yaz_iconv_trie_flat marc8r_31page201_flat[] = {
  {"\x86", 0, 0x215167}, /* East Asian ideograph */
  {"\x83", 0, 0x21516A}, /* East Asian ideograph */
  {"\x81", 0, 0x21516B}, /* East Asian ideograph */
  {"\x85", 0, 0x21516F}, /* East Asian ideograph */
  {"\x95", 0, 0x215170}, /* East Asian ideograph */
  {"\x94", 0, 0x215171}, /* East Asian ideograph */
  {"\xA1", 0, 0x215172}, /* East Asian ideograph */
  {"\x9E", 0, 0x215173}, /* East Asian ideograph */
  {"\x9A", 0, 0x215174}, /* East Asian ideograph */
  {"\xAB", 0, 0x215175}, /* East Asian ideograph */
  {"\xA9", 0, 0x215176}, /* East Asian ideograph */
  {"\xAD", 0, 0x215177}, /* East Asian ideograph */
  {"\xB9", 0, 0x215178}, /* East Asian ideograph */
  {"\xAA", 0, 0x215179}, /* East Asian ideograph */
  {"\xBD", 0, 0x21517B}, /* East Asian ideograph */
  {"\xBC", 0, 0x21517D}, /* East Asian ideograph */
  {"\x84", 0, 0x22727D}, /* East Asian ideograph */
  {"\x87", 0, 0x227328}, /* East Asian ideograph */
  {"\x92", 0, 0x22732D}, /* East Asian ideograph */
  {"\x91", 0, 0x22732F}, /* East Asian ideograph */
  {"\x90", 0, 0x227333}, /* East Asian ideograph */
  {"\xA7", 0, 0x227334}, /* East Asian ideograph */
  {"\x96", 0, 0x227337}, /* East Asian ideograph */
  {"\xA8", 0, 0x227348}, /* East Asian ideograph */
  {"\xAE", 0, 0x227349}, /* East Asian ideograph */
  {"\xB0", 0, 0x22734E}, /* East Asian ideograph */
  {"\xAF", 0, 0x227351}, /* East Asian ideograph */
  {"\xB3", 0, 0x227352}, /* East Asian ideograph */
  {"\xBB", 0, 0x227358}, /* East Asian ideograph */
  {"\xBE", 0, 0x227359}, /* East Asian ideograph */
  {"\xA2", 0, 0x2D5179}, /* East Asian ideograph */
  {"\x88", 0, 0x2F2F5D}, /* East Asian ideograph */
  {"\x99", 0, 0x335259}, /* East Asian ideograph */
  {"\x8A", 0, 0x4B5223}, /* East Asian ideograph */
  {"\xBF", 0, 0x4B577E}, /* East Asian ideograph */
  {"\x9D", 0, 0x4D2F73}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page201 = {
  marc8r_31page201_flat, 0
};
/* PAGE 200 */
struct yaz_iconv_trie_flat marc8r_31page200_flat[] = {
  {"\x91", 0, 0x21515F}, /* East Asian ideograph */
  {"\x8A", 0, 0x215160}, /* East Asian ideograph */
  {"\x88", 0, 0x215161}, /* East Asian ideograph */
  {"\x9B", 0, 0x215162}, /* East Asian ideograph */
  {"\xA3", 0, 0x215164}, /* East Asian ideograph */
  {"\xAE", 0, 0x215165}, /* East Asian ideograph */
  {"\xBE", 0, 0x215166}, /* East Asian ideograph */
  {"\xB7", 0, 0x215168}, /* East Asian ideograph */
  {"\xB2", 0, 0x215169}, /* East Asian ideograph */
  {"\xAB", 0, 0x21516C}, /* East Asian ideograph */
  {"\xBD", 0, 0x21516D}, /* East Asian ideograph */
  {"\xB1", 0, 0x21516E}, /* East Asian ideograph */
  {"\x86", 0, 0x22723A}, /* East Asian ideograph */
  {"\x97", 0, 0x227250}, /* East Asian ideograph */
  {"\x9E", 0, 0x227251}, /* East Asian ideograph */
  {"\xA1", 0, 0x227252}, /* East Asian ideograph */
  {"\x8B", 0, 0x227253}, /* East Asian ideograph */
  {"\x92", 0, 0x227255}, /* East Asian ideograph */
  {"\xA2", 0, 0x227256}, /* East Asian ideograph */
  {"\xA0", 0, 0x22725B}, /* East Asian ideograph */
  {"\x9D", 0, 0x22725D}, /* East Asian ideograph */
  {"\x89", 0, 0x22725E}, /* East Asian ideograph */
  {"\x9F", 0, 0x22725F}, /* East Asian ideograph */
  {"\x95", 0, 0x227265}, /* East Asian ideograph */
  {"\x90", 0, 0x227269}, /* East Asian ideograph */
  {"\x8F", 0, 0x22726A}, /* East Asian ideograph */
  {"\xBB", 0, 0x22726D}, /* East Asian ideograph */
  {"\xB4", 0, 0x227271}, /* East Asian ideograph */
  {"\xAD", 0, 0x227272}, /* East Asian ideograph */
  {"\xAF", 0, 0x227273}, /* East Asian ideograph */
  {"\xB6", 0, 0x227275}, /* East Asian ideograph */
  {"\xBA", 0, 0x227277}, /* East Asian ideograph */
  {"\xB9", 0, 0x227279}, /* East Asian ideograph */
  {"\xB5", 0, 0x227321}, /* East Asian ideograph */
  {"\xBF", 0, 0x227326}, /* East Asian ideograph */
  {"\xA7", 0, 0x2E715A}, /* East Asian ideograph */
  {"\x9A", 0, 0x34715A}, /* East Asian ideograph */
  {"\x81", 0, 0x4B515A}, /* East Asian ideograph */
  {"\xA6", 0, 0x4B516E}, /* East Asian ideograph */
  {"\x84", 0, 0x4B5176}, /* East Asian ideograph */
  {"\x85", 0, 0x69654F}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page200 = {
  marc8r_31page200_flat, 0
};
/* PAGE 199 */
struct yaz_iconv_trie_flat marc8r_31page199_flat[] = {
  {"\x8A", 0, 0x215144}, /* East Asian ideograph */
  {"\x87", 0, 0x215151}, /* East Asian ideograph */
  {"\xA0", 0, 0x215152}, /* East Asian ideograph */
  {"\xAF", 0, 0x215153}, /* East Asian ideograph */
  {"\xB4", 0, 0x215154}, /* East Asian ideograph (variant of EACC 4B5154) */
  {"\x96", 0, 0x215155}, /* East Asian ideograph */
  {"\x98", 0, 0x215156}, /* East Asian ideograph */
  {"\xAC", 0, 0x215157}, /* East Asian ideograph */
  {"\x9D", 0, 0x215158}, /* East Asian ideograph */
  {"\xA9", 0, 0x215159}, /* East Asian ideograph */
  {"\xA3", 0, 0x21515A}, /* East Asian ideograph */
  {"\xA8", 0, 0x21515B}, /* East Asian ideograph */
  {"\x9A", 0, 0x21515C}, /* East Asian ideograph */
  {"\x9E", 0, 0x21515E}, /* East Asian ideograph */
  {"\xBB", 0, 0x215163}, /* East Asian ideograph */
  {"\x8B", 0, 0x227167}, /* East Asian ideograph */
  {"\x8E", 0, 0x22716A}, /* East Asian ideograph */
  {"\x89", 0, 0x22716B}, /* East Asian ideograph */
  {"\x85", 0, 0x22716E}, /* East Asian ideograph */
  {"\x84", 0, 0x227174}, /* East Asian ideograph */
  {"\xA1", 0, 0x227229}, /* East Asian ideograph */
  {"\x99", 0, 0x22722A}, /* East Asian ideograph */
  {"\xA4", 0, 0x22722B}, /* East Asian ideograph */
  {"\x97", 0, 0x227231}, /* East Asian ideograph */
  {"\xB9", 0, 0x227236}, /* East Asian ideograph */
  {"\xB2", 0, 0x22723C}, /* East Asian ideograph */
  {"\xA6", 0, 0x22723E}, /* East Asian ideograph */
  {"\x9C", 0, 0x227246}, /* East Asian ideograph */
  {"\xB1", 0, 0x227247}, /* East Asian ideograph */
  {"\xB6", 0, 0x227248}, /* East Asian ideograph */
  {"\xA5", 0, 0x227249}, /* East Asian ideograph */
  {"\xB5", 0, 0x22724B}, /* East Asian ideograph */
  {"\x91", 0, 0x33514C}, /* East Asian ideograph */
  {"\x90", 0, 0x33516B}, /* East Asian ideograph */
  {"\x8F", 0, 0x4B516D}, /* East Asian ideograph */
  {"\xBC", 0, 0x4C7265}, /* East Asian ideograph */
  {"\x95", 0, 0x69656E}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page199 = {
  marc8r_31page199_flat, 0
};
/* PAGE 198 */
struct yaz_iconv_trie_flat marc8r_31page198_flat[] = {
  {"\x93", 0, 0x21513C}, /* East Asian ideograph */
  {"\x91", 0, 0x21513D}, /* East Asian ideograph */
  {"\x8F", 0, 0x21513F}, /* East Asian ideograph */
  {"\x81", 0, 0x215140}, /* East Asian ideograph */
  {"\x9C", 0, 0x215141}, /* East Asian ideograph */
  {"\xBB", 0, 0x215142}, /* East Asian ideograph */
  {"\xB0", 0, 0x215143}, /* East Asian ideograph */
  {"\xBE", 0, 0x215145}, /* East Asian ideograph */
  {"\xB4", 0, 0x215146}, /* East Asian ideograph */
  {"\xBA", 0, 0x215147}, /* East Asian ideograph */
  {"\xB2", 0, 0x215148}, /* East Asian ideograph */
  {"\xB1", 0, 0x215149}, /* East Asian ideograph */
  {"\xBD", 0, 0x21514A}, /* East Asian ideograph */
  {"\xB5", 0, 0x21514B}, /* East Asian ideograph */
  {"\xA0", 0, 0x21514C}, /* East Asian ideograph */
  {"\xA2", 0, 0x21514D}, /* East Asian ideograph */
  {"\xAD", 0, 0x21514E}, /* East Asian ideograph */
  {"\xBF", 0, 0x21514F}, /* East Asian ideograph */
  {"\xB8", 0, 0x215150}, /* East Asian ideograph */
  {"\x9E", 0, 0x21515D}, /* East Asian ideograph */
  {"\x8B", 0, 0x227137}, /* East Asian ideograph */
  {"\x88", 0, 0x227139}, /* East Asian ideograph */
  {"\x85", 0, 0x22713B}, /* East Asian ideograph */
  {"\x8E", 0, 0x22713D}, /* East Asian ideograph */
  {"\x86", 0, 0x227144}, /* East Asian ideograph */
  {"\x8D", 0, 0x227148}, /* East Asian ideograph */
  {"\x9B", 0, 0x22714B}, /* East Asian ideograph */
  {"\x83", 0, 0x22714D}, /* East Asian ideograph */
  {"\x96", 0, 0x227159}, /* East Asian ideograph */
  {"\x8C", 0, 0x22715B}, /* East Asian ideograph */
  {"\xA3", 0, 0x227161}, /* East Asian ideograph */
  {"\xAE", 0, 0x227162}, /* East Asian ideograph */
  {"\xAA", 0, 0x227169}, /* East Asian ideograph */
  {"\xA6", 0, 0x22716F}, /* East Asian ideograph */
  {"\xAC", 0, 0x227178}, /* East Asian ideograph */
  {"\xB9", 0, 0x22717D}, /* East Asian ideograph */
  {"\x9F", 0, 0x227222}, /* East Asian ideograph */
  {"\xB3", 0, 0x2D516A}, /* East Asian ideograph */
  {"\x99", 0, 0x2D517D}, /* East Asian ideograph */
  {"\xAB", 0, 0x33515C}, /* East Asian ideograph */
  {"\x89", 0, 0x335172}, /* East Asian ideograph */
  {"\xAF", 0, 0x395773}, /* East Asian ideograph */
  {"\x9A", 0, 0x4B5221}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page198 = {
  marc8r_31page198_flat, 0
};
/* PAGE 197 */
struct yaz_iconv_trie_flat marc8r_31page197_flat[] = {
  {"\x86", 0, 0x215126}, /* East Asian ideograph */
  {"\x84", 0, 0x21512B}, /* East Asian ideograph */
  {"\x80", 0, 0x21512F}, /* East Asian ideograph */
  {"\x82", 0, 0x215130}, /* East Asian ideograph */
  {"\xB1", 0, 0x215131}, /* East Asian ideograph */
  {"\x9E", 0, 0x215132}, /* East Asian ideograph */
  {"\xA8", 0, 0x215133}, /* East Asian ideograph */
  {"\x90", 0, 0x215134}, /* East Asian ideograph */
  {"\xA2", 0, 0x215136}, /* East Asian ideograph */
  {"\xB6", 0, 0x215137}, /* East Asian ideograph */
  {"\xA1", 0, 0x215138}, /* East Asian ideograph */
  {"\xA6", 0, 0x215139}, /* East Asian ideograph */
  {"\xAE", 0, 0x21513A}, /* East Asian ideograph */
  {"\xB2", 0, 0x21513B}, /* East Asian ideograph */
  {"\xB9", 0, 0x21513E}, /* East Asian ideograph */
  {"\x85", 0, 0x227068}, /* East Asian ideograph */
  {"\x81", 0, 0x22706F}, /* East Asian ideograph */
  {"\x9C", 0, 0x22707A}, /* East Asian ideograph */
  {"\x93", 0, 0x22707C}, /* East Asian ideograph */
  {"\x9A", 0, 0x22707E}, /* East Asian ideograph */
  {"\xB0", 0, 0x227122}, /* East Asian ideograph */
  {"\xA7", 0, 0x227129}, /* East Asian ideograph */
  {"\xAA", 0, 0x22712B}, /* East Asian ideograph */
  {"\xAB", 0, 0x22712C}, /* East Asian ideograph */
  {"\xB3", 0, 0x227130}, /* East Asian ideograph */
  {"\x8E", 0, 0x227134}, /* East Asian ideograph */
  {"\xBF", 0, 0x227142}, /* East Asian ideograph */
  {"\xBD", 0, 0x22714F}, /* East Asian ideograph */
  {"\xBB", 0, 0x227154}, /* East Asian ideograph */
  {"\xBA", 0, 0x227158}, /* East Asian ideograph */
  {"\x9B", 0, 0x22715A}, /* East Asian ideograph */
  {"\xB7", 0, 0x287275}, /* East Asian ideograph */
  {"\x9D", 0, 0x2D5773}, /* East Asian ideograph */
  {"\x8F", 0, 0x2E7062}, /* East Asian ideograph */
  {"\xA3", 0, 0x2E717C}, /* East Asian ideograph */
  {"\x96", 0, 0x2E735D}, /* East Asian ideograph */
  {"\x83", 0, 0x333D42}, /* East Asian ideograph */
  {"\x8C", 0, 0x33513C}, /* East Asian ideograph */
  {"\xB5", 0, 0x395179}, /* East Asian ideograph */
  {"\x8B", 0, 0x4C735D}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page197 = {
  marc8r_31page197_flat, 0
};
/* PAGE 196 */
struct yaz_iconv_trie_flat marc8r_31page196_flat[] = {
  {"\x80", 0, 0x215070}, /* East Asian ideograph */
  {"\x82", 0, 0x215071}, /* East Asian ideograph */
  {"\x85", 0, 0x215072}, /* East Asian ideograph */
  {"\x89", 0, 0x215073}, /* East Asian ideograph */
  {"\x84", 0, 0x215074}, /* East Asian ideograph */
  {"\x87", 0, 0x215075}, /* East Asian ideograph */
  {"\xA1", 0, 0x215076}, /* East Asian ideograph */
  {"\x8B", 0, 0x215077}, /* East Asian ideograph */
  {"\x8A", 0, 0x215078}, /* East Asian ideograph */
  {"\xA0", 0, 0x215079}, /* East Asian ideograph */
  {"\x9C", 0, 0x21507A}, /* East Asian ideograph */
  {"\xA2", 0, 0x21507B}, /* East Asian ideograph */
  {"\x95", 0, 0x21507C}, /* East Asian ideograph */
  {"\x94", 0, 0x21507D}, /* East Asian ideograph */
  {"\x90", 0, 0x21507E}, /* East Asian ideograph */
  {"\x97", 0, 0x215121}, /* East Asian ideograph */
  {"\x8D", 0, 0x215122}, /* East Asian ideograph (variant of EACC 455122) */
  {"\x9A", 0, 0x215123}, /* East Asian ideograph */
  {"\x99", 0, 0x215124}, /* East Asian ideograph */
  {"\x9B", 0, 0x215125}, /* East Asian ideograph */
  {"\xBC", 0, 0x215128}, /* East Asian ideograph */
  {"\xAE", 0, 0x215129}, /* East Asian ideograph */
  {"\xB9", 0, 0x21512A}, /* East Asian ideograph */
  {"\xB0", 0, 0x21512C}, /* East Asian ideograph */
  {"\xB3", 0, 0x21512D}, /* East Asian ideograph */
  {"\xAF", 0, 0x21512E}, /* East Asian ideograph */
  {"\xAB", 0, 0x215135}, /* East Asian ideograph */
  {"\x86", 0, 0x227042}, /* East Asian ideograph */
  {"\x83", 0, 0x227044}, /* East Asian ideograph */
  {"\x88", 0, 0x227045}, /* East Asian ideograph */
  {"\x8F", 0, 0x227049}, /* East Asian ideograph */
  {"\x93", 0, 0x22704A}, /* East Asian ideograph */
  {"\x98", 0, 0x227050}, /* East Asian ideograph */
  {"\x9E", 0, 0x227051}, /* East Asian ideograph */
  {"\x9D", 0, 0x227052}, /* East Asian ideograph */
  {"\xB5", 0, 0x227059}, /* East Asian ideograph */
  {"\xBD", 0, 0x22705A}, /* East Asian ideograph */
  {"\xBA", 0, 0x227061}, /* East Asian ideograph */
  {"\xB2", 0, 0x227062}, /* East Asian ideograph */
  {"\xB1", 0, 0x227065}, /* East Asian ideograph */
  {"\xBF", 0, 0x22706A}, /* East Asian ideograph */
  {"\xA9", 0, 0x22706C}, /* East Asian ideograph */
  {"\xBE", 0, 0x227071}, /* East Asian ideograph */
  {"\xA7", 0, 0x275144}, /* East Asian ideograph */
  {"\xA5", 0, 0x2D5129}, /* East Asian ideograph */
  {"\xAC", 0, 0x2D514D}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page196 = {
  marc8r_31page196_flat, 0
};
/* PAGE 195 */
struct yaz_iconv_trie_flat marc8r_31page195_flat[] = {
  {"\x8A", 0, 0x215062}, /* East Asian ideograph */
  {"\x96", 0, 0x215063}, /* East Asian ideograph */
  {"\x95", 0, 0x215064}, /* East Asian ideograph */
  {"\xA0", 0, 0x215065}, /* East Asian ideograph */
  {"\x9C", 0, 0x215066}, /* East Asian ideograph */
  {"\x9F", 0, 0x215067}, /* East Asian ideograph */
  {"\x9E", 0, 0x215068}, /* East Asian ideograph */
  {"\xA2", 0, 0x215069}, /* East Asian ideograph */
  {"\x99", 0, 0x21506A}, /* East Asian ideograph */
  {"\xA7", 0, 0x21506B}, /* East Asian ideograph */
  {"\xAF", 0, 0x21506C}, /* East Asian ideograph */
  {"\xBB", 0, 0x21506E}, /* East Asian ideograph */
  {"\xBE", 0, 0x21506F}, /* East Asian ideograph */
  {"\x82", 0, 0x226F64}, /* East Asian ideograph */
  {"\x8E", 0, 0x226F66}, /* East Asian ideograph */
  {"\x88", 0, 0x226F68}, /* East Asian ideograph */
  {"\x85", 0, 0x226F69}, /* East Asian ideograph */
  {"\x8C", 0, 0x226F6D}, /* East Asian ideograph */
  {"\x89", 0, 0x226F6F}, /* East Asian ideograph */
  {"\x92", 0, 0x226F71}, /* East Asian ideograph */
  {"\x97", 0, 0x226F75}, /* East Asian ideograph */
  {"\xA1", 0, 0x226F77}, /* East Asian ideograph */
  {"\xA8", 0, 0x226F7B}, /* East Asian ideograph (variant of EACC 4C6F7B) */
  {"\x9D", 0, 0x227022}, /* East Asian ideograph */
  {"\xAD", 0, 0x227028}, /* East Asian ideograph */
  {"\xB0", 0, 0x22702E}, /* East Asian ideograph */
  {"\xB2", 0, 0x227030}, /* East Asian ideograph */
  {"\xB4", 0, 0x227035}, /* East Asian ideograph */
  {"\xB6", 0, 0x227039}, /* East Asian ideograph */
  {"\x81", 0, 0x287022}, /* East Asian ideograph */
  {"\xBA", 0, 0x2D506F}, /* East Asian ideograph */
  {"\x87", 0, 0x2F5158}, /* East Asian ideograph */
  {"\xB8", 0, 0x4B513B}, /* East Asian ideograph */
  {"\x8D", 0, 0x4C6F43}, /* East Asian ideograph */
  {"\x80", 0, 0x696471}, /* East Asian ideograph */
  {"\x98", 0, 0x696474}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page195 = {
  marc8r_31page195_flat, 0
};
/* PAGE 194 */
struct yaz_iconv_trie_flat marc8r_31page194_flat[] = {
  {"\x89", 0, 0x215057}, /* East Asian ideograph */
  {"\x92", 0, 0x215058}, /* East Asian ideograph */
  {"\x97", 0, 0x215059}, /* East Asian ideograph */
  {"\x9F", 0, 0x21505A}, /* East Asian ideograph */
  {"\xA5", 0, 0x21505B}, /* East Asian ideograph */
  {"\xA4", 0, 0x21505C}, /* East Asian ideograph */
  {"\xB1", 0, 0x21505D}, /* East Asian ideograph */
  {"\xB3", 0, 0x21505E}, /* East Asian ideograph */
  {"\xBD", 0, 0x21505F}, /* East Asian ideograph */
  {"\xB9", 0, 0x215060}, /* East Asian ideograph */
  {"\xBE", 0, 0x215061}, /* East Asian ideograph (variant of EACC 4B5061) */
  {"\x81", 0, 0x226F21}, /* East Asian ideograph */
  {"\x8E", 0, 0x226F28}, /* East Asian ideograph */
  {"\x91", 0, 0x226F29}, /* East Asian ideograph */
  {"\x83", 0, 0x226F2A}, /* East Asian ideograph */
  {"\x8D", 0, 0x226F2C}, /* East Asian ideograph */
  {"\x99", 0, 0x226F3A}, /* East Asian ideograph */
  {"\x98", 0, 0x226F3B}, /* East Asian ideograph */
  {"\x9C", 0, 0x226F3E}, /* East Asian ideograph */
  {"\x95", 0, 0x226F40}, /* East Asian ideograph */
  {"\xA7", 0, 0x226F42}, /* East Asian ideograph */
  {"\xA2", 0, 0x226F43}, /* East Asian ideograph */
  {"\x9E", 0, 0x226F45}, /* East Asian ideograph */
  {"\xA9", 0, 0x226F46}, /* East Asian ideograph */
  {"\xA8", 0, 0x226F48}, /* East Asian ideograph */
  {"\xA1", 0, 0x226F49}, /* East Asian ideograph */
  {"\xAC", 0, 0x226F4A}, /* East Asian ideograph */
  {"\xA6", 0, 0x226F4C}, /* East Asian ideograph */
  {"\xB2", 0, 0x226F54}, /* East Asian ideograph */
  {"\xBB", 0, 0x226F58}, /* East Asian ideograph */
  {"\xBF", 0, 0x226F59}, /* East Asian ideograph */
  {"\xBA", 0, 0x226F5E}, /* East Asian ideograph */
  {"\xBC", 0, 0x226F5F}, /* East Asian ideograph */
  {"\x8B", 0, 0x275060}, /* East Asian ideograph */
  {"\xAA", 0, 0x275068}, /* East Asian ideograph */
  {"\xAE", 0, 0x27506B}, /* East Asian ideograph */
  {"\x9D", 0, 0x287030}, /* East Asian ideograph */
  {"\x9B", 0, 0x2D5321}, /* East Asian ideograph */
  {"\xAB", 0, 0x4B506C}, /* East Asian ideograph */
  {"\x82", 0, 0x693729}, /* East Asian ideograph */
  {"\x90", 0, 0x696464}, /* East Asian ideograph */
  {"\xAD", 0, 0x696466}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page194 = {
  marc8r_31page194_flat, 0
};
/* PAGE 193 */
struct yaz_iconv_trie_flat marc8r_31page193_flat[] = {
  {"\x83", 0, 0x21504C}, /* East Asian ideograph */
  {"\x8C", 0, 0x21504D}, /* East Asian ideograph */
  {"\x8D", 0, 0x21504E}, /* East Asian ideograph */
  {"\x90", 0, 0x21504F}, /* East Asian ideograph */
  {"\xA0", 0, 0x215050}, /* East Asian ideograph */
  {"\x9F", 0, 0x215051}, /* East Asian ideograph */
  {"\xA4", 0, 0x215052}, /* East Asian ideograph */
  {"\xAC", 0, 0x215053}, /* East Asian ideograph */
  {"\xAE", 0, 0x215054}, /* East Asian ideograph */
  {"\xB2", 0, 0x215055}, /* East Asian ideograph */
  {"\xB3", 0, 0x215056}, /* East Asian ideograph */
  {"\x80", 0, 0x226E2A}, /* East Asian ideograph */
  {"\x82", 0, 0x226E3B}, /* East Asian ideograph */
  {"\x8E", 0, 0x226E46}, /* East Asian ideograph */
  {"\x9D", 0, 0x226E54}, /* East Asian ideograph */
  {"\x9C", 0, 0x226E56}, /* East Asian ideograph */
  {"\x9A", 0, 0x226E57}, /* East Asian ideograph */
  {"\x9B", 0, 0x226E58}, /* East Asian ideograph */
  {"\x99", 0, 0x226E59}, /* East Asian ideograph */
  {"\x9E", 0, 0x226E5B}, /* East Asian ideograph */
  {"\xA7", 0, 0x226E5C}, /* East Asian ideograph */
  {"\xA3", 0, 0x226E5E}, /* East Asian ideograph */
  {"\xA8", 0, 0x226E61}, /* East Asian ideograph */
  {"\xA5", 0, 0x226E62}, /* East Asian ideograph */
  {"\xAF", 0, 0x226E6F}, /* East Asian ideograph */
  {"\xB5", 0, 0x226E75}, /* East Asian ideograph */
  {"\xBE", 0, 0x226E79}, /* East Asian ideograph */
  {"\xB8", 0, 0x226E7A}, /* East Asian ideograph */
  {"\xBD", 0, 0x226E7D}, /* East Asian ideograph */
  {"\x81", 0, 0x275051}, /* East Asian ideograph */
  {"\xBB", 0, 0x276053}, /* East Asian ideograph */
  {"\xB4", 0, 0x287035}, /* East Asian ideograph */
  {"\x98", 0, 0x2D504F}, /* East Asian ideograph */
  {"\xBC", 0, 0x34682A}, /* East Asian ideograph */
  {"\x96", 0, 0x4B5052}, /* East Asian ideograph */
  {"\x94", 0, 0x4B5632}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page193 = {
  marc8r_31page193_flat, 0
};
/* PAGE 192 */
struct yaz_iconv_trie_flat marc8r_31page192_flat[] = {
  {"\x91", 0, 0x215036}, /* East Asian ideograph */
  {"\x87", 0, 0x21503D}, /* East Asian ideograph */
  {"\x8D", 0, 0x21503E}, /* East Asian ideograph */
  {"\xA1", 0, 0x215041}, /* East Asian ideograph */
  {"\xAB", 0, 0x215042}, /* East Asian ideograph */
  {"\xAA", 0, 0x215043}, /* East Asian ideograph */
  {"\xA7", 0, 0x215044}, /* East Asian ideograph */
  {"\x9E", 0, 0x215045}, /* East Asian ideograph */
  {"\xA3", 0, 0x215046}, /* East Asian ideograph */
  {"\xBF", 0, 0x215047}, /* East Asian ideograph */
  {"\xBE", 0, 0x215048}, /* East Asian ideograph */
  {"\xB8", 0, 0x215049}, /* East Asian ideograph */
  {"\xB7", 0, 0x21504A}, /* East Asian ideograph */
  {"\xBD", 0, 0x21504B}, /* East Asian ideograph */
  {"\x86", 0, 0x226D3B}, /* East Asian ideograph */
  {"\x8F", 0, 0x226D41}, /* East Asian ideograph */
  {"\x8B", 0, 0x226D46}, /* East Asian ideograph */
  {"\x80", 0, 0x226D47}, /* East Asian ideograph */
  {"\x8C", 0, 0x226D4B}, /* East Asian ideograph */
  {"\x89", 0, 0x226D5A}, /* East Asian ideograph */
  {"\x83", 0, 0x226D5B}, /* East Asian ideograph */
  {"\x9C", 0, 0x226D5F}, /* East Asian ideograph */
  {"\xA6", 0, 0x226D61}, /* East Asian ideograph */
  {"\xA8", 0, 0x226D62}, /* East Asian ideograph */
  {"\xA0", 0, 0x226D63}, /* East Asian ideograph */
  {"\x9F", 0, 0x226D66}, /* East Asian ideograph */
  {"\xAF", 0, 0x226D68}, /* East Asian ideograph */
  {"\xB0", 0, 0x226D75}, /* East Asian ideograph */
  {"\xB5", 0, 0x226E27}, /* East Asian ideograph */
  {"\xB9", 0, 0x226E30}, /* East Asian ideograph */
  {"\xBB", 0, 0x226E34}, /* East Asian ideograph */
  {"\xB4", 0, 0x226E35}, /* East Asian ideograph */
  {"\x96", 0, 0x286E69}, /* East Asian ideograph */
  {"\x94", 0, 0x4B5036}, /* East Asian ideograph */
  {"\x92", 0, 0x4B503B}, /* East Asian ideograph */
  {"\xB1", 0, 0x4C6E42}, /* East Asian ideograph */
  {"\x93", 0, 0x696449}, /* East Asian ideograph */
  {"\x97", 0, 0x69644C}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page192 = {
  marc8r_31page192_flat, 0
};
/* PAGE 191 */
struct yaz_iconv_trie_flat marc8r_31page191_flat[] = {
  {"\x87", 0, 0x21502E}, /* East Asian ideograph */
  {"\x84", 0, 0x215030}, /* East Asian ideograph */
  {"\x80", 0, 0x215033}, /* East Asian ideograph */
  {"\x86", 0, 0x215034}, /* East Asian ideograph */
  {"\x81", 0, 0x215035}, /* East Asian ideograph */
  {"\x99", 0, 0x215037}, /* East Asian ideograph */
  {"\x9B", 0, 0x215038}, /* East Asian ideograph */
  {"\xA4", 0, 0x215039}, /* East Asian ideograph */
  {"\x89", 0, 0x21503A}, /* East Asian ideograph */
  {"\xA1", 0, 0x21503B}, /* East Asian ideograph */
  {"\xA9", 0, 0x21503C}, /* East Asian ideograph */
  {"\xBE", 0, 0x21503F}, /* East Asian ideograph */
  {"\xB7", 0, 0x215040}, /* East Asian ideograph */
  {"\x8B", 0, 0x226C58}, /* East Asian ideograph */
  {"\x8F", 0, 0x226C5A}, /* East Asian ideograph */
  {"\x90", 0, 0x226C5C}, /* East Asian ideograph */
  {"\x8C", 0, 0x226C6F}, /* East Asian ideograph */
  {"\x9D", 0, 0x226D22}, /* East Asian ideograph */
  {"\xA5", 0, 0x226D24}, /* East Asian ideograph */
  {"\xA8", 0, 0x226D29}, /* East Asian ideograph */
  {"\xB9", 0, 0x226D2E}, /* East Asian ideograph */
  {"\x94", 0, 0x226D2F}, /* East Asian ideograph */
  {"\x9F", 0, 0x226D32}, /* East Asian ideograph */
  {"\x98", 0, 0x226D35}, /* East Asian ideograph */
  {"\xAA", 0, 0x226D37}, /* East Asian ideograph (unrelated variant of EACC 3A6A7C) */
  {"\xB0", 0, 0x226D3E}, /* East Asian ideograph */
  {"\xB4", 0, 0x226D4F}, /* East Asian ideograph */
  {"\xB3", 0, 0x226D54}, /* East Asian ideograph */
  {"\xBC", 0, 0x226D5C}, /* East Asian ideograph */
  {"\x93", 0, 0x27503E}, /* East Asian ideograph */
  {"\x91", 0, 0x275046}, /* East Asian ideograph */
  {"\xAE", 0, 0x27504C}, /* East Asian ideograph */
  {"\xB1", 0, 0x275053}, /* East Asian ideograph */
  {"\xB2", 0, 0x2D3D4E}, /* East Asian ideograph */
  {"\xA0", 0, 0x2E6C26}, /* East Asian ideograph */
  {"\xA6", 0, 0x2E6C46}, /* East Asian ideograph */
  {"\x9A", 0, 0x343E38}, /* East Asian ideograph */
  {"\xAD", 0, 0x395050}, /* East Asian ideograph */
  {"\xB6", 0, 0x69644E}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page191 = {
  marc8r_31page191_flat, 0
};
/* PAGE 190 */
struct yaz_iconv_trie_flat marc8r_31page190_flat[] = {
  {"\xA1", 0, 0x215027}, /* East Asian ideograph */
  {"\x94", 0, 0x215028}, /* East Asian ideograph */
  {"\x95", 0, 0x215029}, /* East Asian ideograph */
  {"\x9D", 0, 0x21502A}, /* East Asian ideograph */
  {"\x8B", 0, 0x21502B}, /* East Asian ideograph */
  {"\x97", 0, 0x21502C}, /* East Asian ideograph */
  {"\x8F", 0, 0x21502D}, /* East Asian ideograph */
  {"\xAD", 0, 0x21502F}, /* East Asian ideograph */
  {"\xB1", 0, 0x215031}, /* East Asian ideograph */
  {"\xB4", 0, 0x215032}, /* East Asian ideograph */
  {"\x9A", 0, 0x216B5F}, /* East Asian ideograph */
  {"\x9C", 0, 0x226C2D}, /* East Asian ideograph */
  {"\x92", 0, 0x226C33}, /* East Asian ideograph */
  {"\x91", 0, 0x226C34}, /* East Asian ideograph */
  {"\x90", 0, 0x226C35}, /* East Asian ideograph */
  {"\xA3", 0, 0x226C38}, /* East Asian ideograph */
  {"\x8D", 0, 0x226C3A}, /* East Asian ideograph */
  {"\x85", 0, 0x226C41}, /* East Asian ideograph */
  {"\x8E", 0, 0x226C43}, /* East Asian ideograph */
  {"\x98", 0, 0x226C44}, /* East Asian ideograph */
  {"\x86", 0, 0x226C46}, /* East Asian ideograph */
  {"\x99", 0, 0x226C48}, /* East Asian ideograph */
  {"\xB2", 0, 0x226C52}, /* East Asian ideograph */
  {"\xB8", 0, 0x226C59}, /* East Asian ideograph */
  {"\xBE", 0, 0x226C60}, /* East Asian ideograph */
  {"\xAC", 0, 0x275038}, /* East Asian ideograph */
  {"\x80", 0, 0x275041}, /* East Asian ideograph */
  {"\xAB", 0, 0x275042}, /* East Asian ideograph */
  {"\xAA", 0, 0x275045}, /* East Asian ideograph */
  {"\xA9", 0, 0x275054}, /* East Asian ideograph */
  {"\xA7", 0, 0x286C58}, /* East Asian ideograph */
  {"\xA6", 0, 0x286D47}, /* East Asian ideograph */
  {"\xA8", 0, 0x286E56}, /* East Asian ideograph */
  {"\x87", 0, 0x2D3224}, /* East Asian ideograph */
  {"\xA0", 0, 0x2E3E3F}, /* East Asian ideograph */
  {"\x9F", 0, 0x4C6C46}, /* East Asian ideograph */
  {"\xA2", 0, 0x70736E}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page190 = {
  marc8r_31page190_flat, 0
};
/* PAGE 189 */
struct yaz_iconv_trie_flat marc8r_31page189_flat[] = {
  {"\x86", 0, 0x214F79}, /* East Asian ideograph */
  {"\x89", 0, 0x214F7A}, /* East Asian ideograph */
  {"\x90", 0, 0x214F7B}, /* East Asian ideograph */
  {"\x96", 0, 0x214F7C}, /* East Asian ideograph */
  {"\x92", 0, 0x214F7D}, /* East Asian ideograph */
  {"\x8B", 0, 0x214F7E}, /* East Asian ideograph */
  {"\x8D", 0, 0x215021}, /* East Asian ideograph */
  {"\x8F", 0, 0x215022}, /* East Asian ideograph */
  {"\x94", 0, 0x215023}, /* East Asian ideograph */
  {"\xA0", 0, 0x215024}, /* East Asian ideograph */
  {"\xB7", 0, 0x215025}, /* East Asian ideograph */
  {"\xB5", 0, 0x215026}, /* East Asian ideograph */
  {"\x8A", 0, 0x226B52}, /* East Asian ideograph */
  {"\x99", 0, 0x226B53}, /* East Asian ideograph */
  {"\x87", 0, 0x226B55}, /* East Asian ideograph */
  {"\x98", 0, 0x226B59}, /* East Asian ideograph */
  {"\xAC", 0, 0x226B5B}, /* East Asian ideograph */
  {"\x88", 0, 0x226B60}, /* East Asian ideograph */
  {"\x85", 0, 0x226B61}, /* East Asian ideograph */
  {"\x8C", 0, 0x226B62}, /* East Asian ideograph */
  {"\x8E", 0, 0x226B63}, /* East Asian ideograph */
  {"\xA6", 0, 0x226B68}, /* East Asian ideograph */
  {"\xA4", 0, 0x226B6C}, /* East Asian ideograph */
  {"\xA9", 0, 0x226B6E}, /* East Asian ideograph */
  {"\xAD", 0, 0x226B70}, /* East Asian ideograph */
  {"\xA2", 0, 0x226B74}, /* East Asian ideograph */
  {"\xAE", 0, 0x226B75}, /* East Asian ideograph */
  {"\xB4", 0, 0x226B76}, /* East Asian ideograph */
  {"\xB2", 0, 0x226B79}, /* East Asian ideograph */
  {"\xB8", 0, 0x226B7A}, /* East Asian ideograph */
  {"\xAF", 0, 0x226B7B}, /* East Asian ideograph */
  {"\xA7", 0, 0x226B7C}, /* East Asian ideograph */
  {"\xA5", 0, 0x226B7E}, /* East Asian ideograph */
  {"\xB1", 0, 0x226C26}, /* East Asian ideograph */
  {"\xB0", 0, 0x226C27}, /* East Asian ideograph */
  {"\xB3", 0, 0x226C29}, /* East Asian ideograph */
  {"\x91", 0, 0x27503A}, /* East Asian ideograph */
  {"\x9B", 0, 0x27503C}, /* East Asian ideograph */
  {"\xBE", 0, 0x27504B}, /* East Asian ideograph */
  {"\xB9", 0, 0x27504D}, /* East Asian ideograph */
  {"\x9A", 0, 0x286D54}, /* East Asian ideograph */
  {"\x9E", 0, 0x2D4F7C}, /* East Asian ideograph */
  {"\x9D", 0, 0x2D502D}, /* East Asian ideograph */
  {"\xBA", 0, 0x4B4F7B}, /* East Asian ideograph */
  {"\xBB", 0, 0x707360}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page189 = {
  marc8r_31page189_flat, 0
};
/* PAGE 188 */
struct yaz_iconv_trie_flat marc8r_31page188_flat[] = {
  {"\x86", 0, 0x214F70}, /* East Asian ideograph */
  {"\x91", 0, 0x214F71}, /* East Asian ideograph */
  {"\xA0", 0, 0x214F72}, /* East Asian ideograph */
  {"\xAC", 0, 0x214F73}, /* East Asian ideograph */
  {"\xA8", 0, 0x214F74}, /* East Asian ideograph */
  {"\x9B", 0, 0x214F75}, /* East Asian ideograph */
  {"\x9E", 0, 0x214F76}, /* East Asian ideograph */
  {"\x99", 0, 0x214F77}, /* East Asian ideograph */
  {"\xA6", 0, 0x214F78}, /* East Asian ideograph */
  {"\xB9", 0, 0x226B27}, /* East Asian ideograph */
  {"\x8F", 0, 0x226B2D}, /* East Asian ideograph */
  {"\x88", 0, 0x226B2E}, /* East Asian ideograph */
  {"\x8A", 0, 0x226B33}, /* East Asian ideograph */
  {"\xB5", 0, 0x226B35}, /* East Asian ideograph */
  {"\xA5", 0, 0x226B36}, /* East Asian ideograph */
  {"\xB8", 0, 0x226B39}, /* East Asian ideograph */
  {"\xBB", 0, 0x226B3B}, /* East Asian ideograph */
  {"\xA4", 0, 0x226B3F}, /* East Asian ideograph */
  {"\xB3", 0, 0x226B40}, /* East Asian ideograph */
  {"\xAA", 0, 0x226B42}, /* East Asian ideograph */
  {"\x98", 0, 0x226B44}, /* East Asian ideograph */
  {"\xB1", 0, 0x226B47}, /* East Asian ideograph */
  {"\xAB", 0, 0x226B4A}, /* East Asian ideograph */
  {"\xB7", 0, 0x226B4B}, /* East Asian ideograph */
  {"\x9F", 0, 0x226B4D}, /* East Asian ideograph */
  {"\x84", 0, 0x226B54}, /* East Asian ideograph (variant of EACC 2E6B54) */
  {"\x94", 0, 0x274F79}, /* East Asian ideograph */
  {"\x8B", 0, 0x275021}, /* East Asian ideograph */
  {"\xBA", 0, 0x27502B}, /* East Asian ideograph */
  {"\x83", 0, 0x275039}, /* East Asian ideograph */
  {"\xBC", 0, 0x275050}, /* East Asian ideograph */
  {"\x95", 0, 0x286B7C}, /* East Asian ideograph */
  {"\xBE", 0, 0x286E68}, /* East Asian ideograph */
  {"\xAE", 0, 0x2E6C27}, /* East Asian ideograph */
  {"\xB6", 0, 0x4B4E21}, /* East Asian ideograph */
  {"\x82", 0, 0x696373}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page188 = {
  marc8r_31page188_flat, 0
};
/* PAGE 187 */
struct yaz_iconv_trie_flat marc8r_31page187_flat[] = {
  {"\x85", 0, 0x214F61}, /* East Asian ideograph */
  {"\x84", 0, 0x214F62}, /* East Asian ideograph */
  {"\x87", 0, 0x214F63}, /* East Asian ideograph */
  {"\x8A", 0, 0x214F64}, /* East Asian ideograph */
  {"\x8B", 0, 0x214F65}, /* East Asian ideograph */
  {"\x99", 0, 0x214F66}, /* East Asian ideograph */
  {"\xA5", 0, 0x214F67}, /* East Asian ideograph */
  {"\xA3", 0, 0x214F68}, /* East Asian ideograph */
  {"\xAD", 0, 0x214F69}, /* East Asian ideograph */
  {"\xAF", 0, 0x214F6A}, /* East Asian ideograph */
  {"\xB6", 0, 0x214F6B}, /* East Asian ideograph */
  {"\xB9", 0, 0x214F6C}, /* East Asian ideograph */
  {"\xBA", 0, 0x214F6D}, /* East Asian ideograph */
  {"\xBF", 0, 0x214F6E}, /* East Asian ideograph */
  {"\xBD", 0, 0x214F6F}, /* East Asian ideograph */
  {"\xA0", 0, 0x216032}, /* East Asian ideograph */
  {"\x9F", 0, 0x216033}, /* East Asian ideograph */
  {"\x8D", 0, 0x226A49}, /* East Asian ideograph */
  {"\x8F", 0, 0x226A4B}, /* East Asian ideograph */
  {"\x91", 0, 0x226A4F}, /* East Asian ideograph */
  {"\x93", 0, 0x226A51}, /* East Asian ideograph */
  {"\x94", 0, 0x226A52}, /* East Asian ideograph */
  {"\x95", 0, 0x226A54}, /* East Asian ideograph */
  {"\x9A", 0, 0x226A55}, /* East Asian ideograph */
  {"\xA1", 0, 0x226A5A}, /* East Asian ideograph */
  {"\xA6", 0, 0x226A5E}, /* East Asian ideograph */
  {"\xAB", 0, 0x226A66}, /* East Asian ideograph */
  {"\xB0", 0, 0x226A6B}, /* East Asian ideograph */
  {"\xB5", 0, 0x226A76}, /* East Asian ideograph */
  {"\xBE", 0, 0x226A7C}, /* East Asian ideograph */
  {"\x9E", 0, 0x274F6B}, /* East Asian ideograph */
  {"\x96", 0, 0x275957}, /* East Asian ideograph */
  {"\x9D", 0, 0x2D3032}, /* East Asian ideograph */
  {"\xA2", 0, 0x2D3164}, /* East Asian ideograph */
  {"\x92", 0, 0x2D3932}, /* East Asian ideograph */
  {"\x88", 0, 0x2D4947}, /* East Asian ideograph */
  {"\xB8", 0, 0x2D4F6B}, /* East Asian ideograph */
  {"\xAA", 0, 0x2D5957}, /* East Asian ideograph */
  {"\x9C", 0, 0x33632B}, /* East Asian ideograph */
  {"\x83", 0, 0x4B4947}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page187 = {
  marc8r_31page187_flat, 0
};
/* PAGE 186 */
struct yaz_iconv_trie_flat marc8r_31page186_flat[] = {
  {"\x81", 0, 0x214F52}, /* East Asian ideograph */
  {"\x84", 0, 0x214F53}, /* East Asian ideograph */
  {"\x88", 0, 0x214F54}, /* East Asian ideograph */
  {"\x92", 0, 0x214F55}, /* East Asian ideograph */
  {"\x95", 0, 0x214F56}, /* East Asian ideograph */
  {"\x98", 0, 0x214F57}, /* East Asian ideograph */
  {"\x96", 0, 0x214F58}, /* East Asian ideograph */
  {"\x97", 0, 0x214F59}, /* East Asian ideograph */
  {"\x9F", 0, 0x214F5A}, /* East Asian ideograph */
  {"\xA0", 0, 0x214F5B}, /* East Asian ideograph */
  {"\xAA", 0, 0x214F5C}, /* East Asian ideograph */
  {"\xA9", 0, 0x214F5D}, /* East Asian ideograph */
  {"\xAF", 0, 0x214F5E}, /* East Asian ideograph */
  {"\xAE", 0, 0x214F5F}, /* East Asian ideograph */
  {"\xBA", 0, 0x214F60}, /* East Asian ideograph */
  {"\x80", 0, 0x22696B}, /* East Asian ideograph */
  {"\x85", 0, 0x226970}, /* East Asian ideograph */
  {"\x86", 0, 0x226975}, /* East Asian ideograph */
  {"\x8A", 0, 0x226978}, /* East Asian ideograph */
  {"\x94", 0, 0x22697A}, /* East Asian ideograph */
  {"\xA3", 0, 0x226A28}, /* East Asian ideograph */
  {"\x9E", 0, 0x226A2B}, /* East Asian ideograph */
  {"\xA7", 0, 0x226A2C}, /* East Asian ideograph */
  {"\xA8", 0, 0x226A2E}, /* East Asian ideograph */
  {"\xAC", 0, 0x226A31}, /* East Asian ideograph */
  {"\xB3", 0, 0x226A36}, /* East Asian ideograph */
  {"\xBD", 0, 0x226A3A}, /* East Asian ideograph */
  {"\xB6", 0, 0x226A3C}, /* East Asian ideograph */
  {"\xB8", 0, 0x226A3D}, /* East Asian ideograph */
  {"\xB5", 0, 0x226A3E}, /* East Asian ideograph */
  {"\xBB", 0, 0x226A3F}, /* East Asian ideograph */
  {"\xBF", 0, 0x226A43}, /* East Asian ideograph */
  {"\x9D", 0, 0x274F5D}, /* East Asian ideograph */
  {"\xA5", 0, 0x274F60}, /* East Asian ideograph */
  {"\x8D", 0, 0x274F61}, /* East Asian ideograph */
  {"\x9C", 0, 0x274F62}, /* East Asian ideograph */
  {"\xA6", 0, 0x274F63}, /* East Asian ideograph */
  {"\x83", 0, 0x274F64}, /* East Asian ideograph */
  {"\xAD", 0, 0x286A3C}, /* East Asian ideograph */
  {"\xB0", 0, 0x2D4F5E}, /* East Asian ideograph */
  {"\x93", 0, 0x334F59}, /* East Asian ideograph */
  {"\x91", 0, 0x334F5E}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page186 = {
  marc8r_31page186_flat, 0
};
/* PAGE 185 */
struct yaz_iconv_trie_flat marc8r_31page185_flat[] = {
  {"\x80", 0, 0x214F40}, /* East Asian ideograph */
  {"\x8D", 0, 0x214F44}, /* East Asian ideograph */
  {"\x8E", 0, 0x214F45}, /* East Asian ideograph */
  {"\x8C", 0, 0x214F46}, /* East Asian ideograph */
  {"\x86", 0, 0x214F47}, /* East Asian ideograph */
  {"\x97", 0, 0x214F48}, /* East Asian ideograph */
  {"\xA1", 0, 0x214F49}, /* East Asian ideograph */
  {"\xA2", 0, 0x214F4A}, /* East Asian ideograph */
  {"\xAB", 0, 0x214F4B}, /* East Asian ideograph */
  {"\xA9", 0, 0x214F4C}, /* East Asian ideograph */
  {"\xB4", 0, 0x214F4D}, /* East Asian ideograph */
  {"\xB6", 0, 0x214F4E}, /* East Asian ideograph */
  {"\xB9", 0, 0x214F4F}, /* East Asian ideograph */
  {"\xBA", 0, 0x214F50}, /* East Asian ideograph */
  {"\xBF", 0, 0x214F51}, /* East Asian ideograph */
  {"\x88", 0, 0x226939}, /* East Asian ideograph */
  {"\x8B", 0, 0x22693D}, /* East Asian ideograph */
  {"\x87", 0, 0x22693E}, /* East Asian ideograph */
  {"\x84", 0, 0x22693F}, /* East Asian ideograph */
  {"\x9C", 0, 0x226940}, /* East Asian ideograph */
  {"\x9F", 0, 0x22694D}, /* East Asian ideograph */
  {"\xA0", 0, 0x22694F}, /* East Asian ideograph */
  {"\xAE", 0, 0x226957}, /* East Asian ideograph */
  {"\xB0", 0, 0x22695F}, /* East Asian ideograph */
  {"\xB5", 0, 0x226966}, /* East Asian ideograph */
  {"\xB8", 0, 0x226969}, /* East Asian ideograph */
  {"\x91", 0, 0x274F49}, /* East Asian ideograph */
  {"\xB7", 0, 0x274F5F}, /* East Asian ideograph */
  {"\x82", 0, 0x2D4F48}, /* East Asian ideograph */
  {"\x89", 0, 0x334F3A}, /* East Asian ideograph */
  {"\x85", 0, 0x335065}, /* East Asian ideograph */
  {"\xBD", 0, 0x395E6F}, /* East Asian ideograph */
  {"\x90", 0, 0x4B4F29}, /* East Asian ideograph */
  {"\x8F", 0, 0x4B4F4C}, /* East Asian ideograph */
  {"\xA3", 0, 0x4C695F}, /* East Asian ideograph */
  {"\x83", 0, 0x69634E}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page185 = {
  marc8r_31page185_flat, 0
};
/* PAGE 184 */
struct yaz_iconv_trie_flat marc8r_31page184_flat[] = {
  {"\x85", 0, 0x214F32}, /* East Asian ideograph */
  {"\x8D", 0, 0x214F33}, /* East Asian ideograph */
  {"\x88", 0, 0x214F34}, /* East Asian ideograph */
  {"\x8B", 0, 0x214F35}, /* East Asian ideograph */
  {"\x80", 0, 0x214F36}, /* East Asian ideograph */
  {"\x9F", 0, 0x214F37}, /* East Asian ideograph */
  {"\xA0", 0, 0x214F39}, /* East Asian ideograph */
  {"\x9A", 0, 0x214F3A}, /* East Asian ideograph */
  {"\x94", 0, 0x214F3B}, /* East Asian ideograph */
  {"\xB1", 0, 0x214F3C}, /* East Asian ideograph */
  {"\xAE", 0, 0x214F3D}, /* East Asian ideograph */
  {"\xBF", 0, 0x214F3E}, /* East Asian ideograph */
  {"\xBC", 0, 0x214F3F}, /* East Asian ideograph */
  {"\xBD", 0, 0x214F41}, /* East Asian ideograph */
  {"\xB7", 0, 0x214F42}, /* East Asian ideograph */
  {"\xBB", 0, 0x214F43}, /* East Asian ideograph */
  {"\xA5", 0, 0x223924}, /* East Asian ideograph */
  {"\x82", 0, 0x22684F}, /* East Asian ideograph */
  {"\x8A", 0, 0x226850}, /* East Asian ideograph */
  {"\x89", 0, 0x226854}, /* East Asian ideograph */
  {"\x83", 0, 0x22685C}, /* East Asian ideograph */
  {"\x8C", 0, 0x226861}, /* East Asian ideograph */
  {"\x91", 0, 0x22686B}, /* East Asian ideograph */
  {"\x98", 0, 0x22686C}, /* East Asian ideograph */
  {"\x99", 0, 0x22686F}, /* East Asian ideograph (variant of EACC 2E686F) */
  {"\x9E", 0, 0x226871}, /* East Asian ideograph */
  {"\x97", 0, 0x226876}, /* East Asian ideograph */
  {"\xAD", 0, 0x22687E}, /* East Asian ideograph */
  {"\xAC", 0, 0x226922}, /* East Asian ideograph */
  {"\xA3", 0, 0x274F46}, /* East Asian ideograph */
  {"\xB3", 0, 0x274F4C}, /* East Asian ideograph */
  {"\xBE", 0, 0x2D4F3E}, /* East Asian ideograph */
  {"\x9C", 0, 0x2E3D73}, /* East Asian ideograph */
  {"\xB2", 0, 0x4B4F43}, /* East Asian ideograph */
  {"\x86", 0, 0x4C695C}, /* East Asian ideograph */
  {"\xB9", 0, 0x4C725D}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page184 = {
  marc8r_31page184_flat, 0
};
/* PAGE 183 */
struct yaz_iconv_trie_flat marc8r_31page183_flat[] = {
  {"\x80", 0, 0x214F24}, /* East Asian ideograph */
  {"\x81", 0, 0x214F25}, /* East Asian ideograph */
  {"\x89", 0, 0x214F27}, /* East Asian ideograph */
  {"\x91", 0, 0x214F28}, /* East Asian ideograph */
  {"\x8B", 0, 0x214F29}, /* East Asian ideograph */
  {"\x92", 0, 0x214F2A}, /* East Asian ideograph */
  {"\xA4", 0, 0x214F2B}, /* East Asian ideograph */
  {"\xA6", 0, 0x214F2C}, /* East Asian ideograph */
  {"\xA3", 0, 0x214F2D}, /* East Asian ideograph */
  {"\x9F", 0, 0x214F2E}, /* East Asian ideograph */
  {"\xA7", 0, 0x214F2F}, /* East Asian ideograph */
  {"\xA9", 0, 0x214F30}, /* East Asian ideograph */
  {"\xBB", 0, 0x214F31}, /* East Asian ideograph */
  {"\x8C", 0, 0x225070}, /* East Asian ideograph */
  {"\x86", 0, 0x226828}, /* East Asian ideograph */
  {"\x88", 0, 0x22682A}, /* East Asian ideograph */
  {"\x94", 0, 0x22682D}, /* East Asian ideograph */
  {"\x95", 0, 0x22682E}, /* East Asian ideograph */
  {"\x96", 0, 0x226832}, /* East Asian ideograph */
  {"\xAC", 0, 0x22683D}, /* East Asian ideograph */
  {"\xAB", 0, 0x22683E}, /* East Asian ideograph (variant of EACC 4C683E) */
  {"\xA1", 0, 0x226842}, /* East Asian ideograph */
  {"\x9D", 0, 0x226844}, /* East Asian ideograph */
  {"\xAD", 0, 0x226845}, /* East Asian ideograph */
  {"\xB8", 0, 0x226848}, /* East Asian ideograph */
  {"\xB0", 0, 0x274F3C}, /* East Asian ideograph */
  {"\x8D", 0, 0x274F3D}, /* East Asian ideograph */
  {"\xAF", 0, 0x274F44}, /* East Asian ideograph */
  {"\xBD", 0, 0x274F4A}, /* East Asian ideograph */
  {"\x8A", 0, 0x2D3C65}, /* East Asian ideograph */
  {"\x90", 0, 0x2D5265}, /* East Asian ideograph */
  {"\x8F", 0, 0x2D5267}, /* East Asian ideograph */
  {"\x98", 0, 0x4B4E67}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page183 = {
  marc8r_31page183_flat, 0
};
/* PAGE 182 */
struct yaz_iconv_trie_dir marc8r_31page182_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {210, 0, 0},
  {211, 0, 0},
  {212, 0, 0},
  {213, 0, 0},
  {214, 0, 0},
  {215, 0, 0},
  {216, 0, 0},
  {217, 0, 0},
  {218, 0, 0},
  {219, 0, 0},
  {220, 0, 0},
  {221, 0, 0},
  {222, 0, 0},
  {223, 0, 0},
  {224, 0, 0},
  {225, 0, 0},
  {208, 0, 0},
  {227, 0, 0},
  {226, 0, 0},
  {228, 0, 0},
  {229, 0, 0},
  {230, 0, 0},
  {231, 0, 0},
  {232, 0, 0},
  {233, 0, 0},
  {234, 0, 0},
  {235, 0, 0},
  {236, 0, 0},
  {237, 0, 0},
  {238, 0, 0},
  {239, 0, 0},
  {240, 0, 0},
  {241, 0, 0},
  {242, 0, 0},
  {243, 0, 0},
  {244, 0, 0},
  {245, 0, 0},
  {246, 0, 0},
  {247, 0, 0},
  {248, 0, 0},
  {249, 0, 0},
  {250, 0, 0},
  {251, 0, 0},
  {252, 0, 0},
  {253, 0, 0},
  {254, 0, 0},
  {255, 0, 0},
  {333, 0, 0},
  {257, 0, 0},
  {256, 0, 0},
  {258, 0, 0},
  {259, 0, 0},
  {260, 0, 0},
  {261, 0, 0},
  {262, 0, 0},
  {263, 0, 0},
  {264, 0, 0},
  {265, 0, 0},
  {266, 0, 0},
  {267, 0, 0},
  {268, 0, 0},
  {269, 0, 0},
  {209, 0, 0},
  {270, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page182 = {
  0, marc8r_31page182_dir
};
/* PAGE 181 */
struct yaz_iconv_trie_flat marc8r_31page181_flat[] = {
  {"\x81", 0, 0x214E74}, /* East Asian ideograph */
  {"\x8F", 0, 0x214E76}, /* East Asian ideograph */
  {"\x8D", 0, 0x214E77}, /* East Asian ideograph */
  {"\x8E", 0, 0x214E78}, /* East Asian ideograph */
  {"\xA6", 0, 0x214E79}, /* East Asian ideograph */
  {"\xA7", 0, 0x214E7A}, /* East Asian ideograph */
  {"\xAA", 0, 0x214E7B}, /* East Asian ideograph */
  {"\xAE", 0, 0x214E7C}, /* East Asian ideograph */
  {"\xB1", 0, 0x214E7D}, /* East Asian ideograph */
  {"\xB9", 0, 0x214E7E}, /* East Asian ideograph */
  {"\xBD", 0, 0x214F21}, /* East Asian ideograph */
  {"\xBE", 0, 0x214F23}, /* East Asian ideograph */
  {"\xBF", 0, 0x214F26}, /* East Asian ideograph */
  {"\x98", 0, 0x22674A}, /* East Asian ideograph */
  {"\x8A", 0, 0x22674B}, /* East Asian ideograph */
  {"\x99", 0, 0x22674D}, /* East Asian ideograph */
  {"\x95", 0, 0x22674E}, /* East Asian ideograph */
  {"\x8B", 0, 0x22674F}, /* East Asian ideograph */
  {"\x96", 0, 0x226750}, /* East Asian ideograph */
  {"\x94", 0, 0x226754}, /* East Asian ideograph */
  {"\x93", 0, 0x226755}, /* East Asian ideograph */
  {"\x9A", 0, 0x22675C}, /* East Asian ideograph */
  {"\xA1", 0, 0x22675F}, /* East Asian ideograph */
  {"\x9B", 0, 0x226760}, /* East Asian ideograph */
  {"\xA3", 0, 0x226761}, /* East Asian ideograph */
  {"\x9D", 0, 0x226764}, /* East Asian ideograph */
  {"\xA9", 0, 0x22676E}, /* East Asian ideograph */
  {"\xAB", 0, 0x226770}, /* East Asian ideograph */
  {"\xA8", 0, 0x226771}, /* East Asian ideograph */
  {"\xB0", 0, 0x226775}, /* East Asian ideograph */
  {"\xB3", 0, 0x22677A}, /* East Asian ideograph */
  {"\xB4", 0, 0x22677B}, /* East Asian ideograph */
  {"\xB8", 0, 0x226822}, /* East Asian ideograph */
  {"\xBA", 0, 0x226823}, /* East Asian ideograph */
  {"\xBC", 0, 0x226825}, /* East Asian ideograph */
  {"\x85", 0, 0x274E7B}, /* East Asian ideograph */
  {"\xBB", 0, 0x275F4F}, /* East Asian ideograph */
  {"\x80", 0, 0x2D4F37}, /* East Asian ideograph */
  {"\xA5", 0, 0x334E73}, /* East Asian ideograph */
  {"\x84", 0, 0x454E75}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page181 = {
  marc8r_31page181_flat, 0
};
/* PAGE 180 */
struct yaz_iconv_trie_flat marc8r_31page180_flat[] = {
  {"\x80", 0, 0x214E60}, /* East Asian ideograph */
  {"\x81", 0, 0x214E62}, /* East Asian ideograph */
  {"\x85", 0, 0x214E63}, /* East Asian ideograph */
  {"\x89", 0, 0x214E64}, /* East Asian ideograph */
  {"\x88", 0, 0x214E65}, /* East Asian ideograph */
  {"\x87", 0, 0x214E66}, /* East Asian ideograph */
  {"\x95", 0, 0x214E67}, /* East Asian ideograph */
  {"\xA0", 0, 0x214E68}, /* East Asian ideograph */
  {"\x90", 0, 0x214E69}, /* East Asian ideograph */
  {"\x96", 0, 0x214E6A}, /* East Asian ideograph */
  {"\x9E", 0, 0x214E6B}, /* East Asian ideograph */
  {"\x9D", 0, 0x214E6C}, /* East Asian ideograph */
  {"\x9F", 0, 0x214E6D}, /* East Asian ideograph */
  {"\x9A", 0, 0x214E6E}, /* East Asian ideograph */
  {"\x97", 0, 0x214E6F}, /* East Asian ideograph */
  {"\xA5", 0, 0x214E70}, /* East Asian ideograph */
  {"\xA8", 0, 0x214E71}, /* East Asian ideograph */
  {"\xAD", 0, 0x214E72}, /* East Asian ideograph */
  {"\xBA", 0, 0x214E73}, /* East Asian ideograph */
  {"\xBF", 0, 0x214E75}, /* East Asian ideograph */
  {"\x82", 0, 0x226667}, /* East Asian ideograph */
  {"\x8A", 0, 0x22666A}, /* East Asian ideograph */
  {"\x8D", 0, 0x22666B}, /* East Asian ideograph */
  {"\x86", 0, 0x226675}, /* East Asian ideograph */
  {"\x98", 0, 0x226677}, /* East Asian ideograph */
  {"\x9B", 0, 0x226679}, /* East Asian ideograph */
  {"\x9C", 0, 0x22667A}, /* East Asian ideograph */
  {"\x8F", 0, 0x22667B}, /* East Asian ideograph */
  {"\x93", 0, 0x22667C}, /* East Asian ideograph */
  {"\x91", 0, 0x226721}, /* East Asian ideograph */
  {"\x94", 0, 0x226723}, /* East Asian ideograph */
  {"\xA7", 0, 0x22672A}, /* East Asian ideograph */
  {"\xAB", 0, 0x22672D}, /* East Asian ideograph */
  {"\xB2", 0, 0x226730}, /* East Asian ideograph */
  {"\xBC", 0, 0x22673E}, /* East Asian ideograph */
  {"\xB8", 0, 0x274E77}, /* East Asian ideograph */
  {"\xAF", 0, 0x274E78}, /* East Asian ideograph */
  {"\xB7", 0, 0x274E7D}, /* East Asian ideograph */
  {"\xA2", 0, 0x293032}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page180 = {
  marc8r_31page180_flat, 0
};
/* PAGE 179 */
struct yaz_iconv_trie_flat marc8r_31page179_flat[] = {
  {"\x81", 0, 0x214E57}, /* East Asian ideograph */
  {"\x8E", 0, 0x214E59}, /* East Asian ideograph */
  {"\x99", 0, 0x214E5A}, /* East Asian ideograph */
  {"\xA6", 0, 0x214E5B}, /* East Asian ideograph */
  {"\xAC", 0, 0x214E5C}, /* East Asian ideograph */
  {"\xAA", 0, 0x214E5D}, /* East Asian ideograph */
  {"\xAB", 0, 0x214E5E}, /* East Asian ideograph */
  {"\xBA", 0, 0x214E5F}, /* East Asian ideograph */
  {"\xBE", 0, 0x214E61}, /* East Asian ideograph */
  {"\x85", 0, 0x22657E}, /* East Asian ideograph */
  {"\x84", 0, 0x22662B}, /* East Asian ideograph */
  {"\x92", 0, 0x22662E}, /* East Asian ideograph */
  {"\x8C", 0, 0x226632}, /* East Asian ideograph */
  {"\x93", 0, 0x226634}, /* East Asian ideograph */
  {"\x91", 0, 0x226635}, /* East Asian ideograph */
  {"\x9E", 0, 0x226643}, /* East Asian ideograph */
  {"\xA2", 0, 0x226646}, /* East Asian ideograph */
  {"\xA4", 0, 0x22664C}, /* East Asian ideograph */
  {"\xA7", 0, 0x22664D}, /* East Asian ideograph */
  {"\xA9", 0, 0x226650}, /* East Asian ideograph */
  {"\xB1", 0, 0x226655}, /* East Asian ideograph */
  {"\xB4", 0, 0x22665D}, /* East Asian ideograph */
  {"\xB6", 0, 0x226660}, /* East Asian ideograph */
  {"\xBD", 0, 0x226665}, /* East Asian ideograph */
  {"\xBF", 0, 0x226668}, /* East Asian ideograph */
  {"\xBC", 0, 0x274E7C}, /* East Asian ideograph */
  {"\xAE", 0, 0x394956}, /* East Asian ideograph */
  {"\x87", 0, 0x696325}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page179 = {
  marc8r_31page179_flat, 0
};
/* PAGE 178 */
struct yaz_iconv_trie_flat marc8r_31page178_flat[] = {
  {"\x8B", 0, 0x214E48}, /* East Asian ideograph */
  {"\x81", 0, 0x214E4A}, /* East Asian ideograph */
  {"\x85", 0, 0x214E4B}, /* East Asian ideograph */
  {"\x95", 0, 0x214E4D}, /* East Asian ideograph */
  {"\x8A", 0, 0x214E4F}, /* East Asian ideograph */
  {"\x90", 0, 0x214E50}, /* East Asian ideograph */
  {"\xA8", 0, 0x214E51}, /* East Asian ideograph */
  {"\xAC", 0, 0x214E52}, /* East Asian ideograph */
  {"\x9A", 0, 0x214E53}, /* East Asian ideograph */
  {"\xB7", 0, 0x214E54}, /* East Asian ideograph */
  {"\xB4", 0, 0x214E55}, /* East Asian ideograph */
  {"\xBA", 0, 0x214E56}, /* East Asian ideograph (variant of EACC 4B4E56) */
  {"\xAF", 0, 0x214E58}, /* East Asian ideograph */
  {"\x8C", 0, 0x226555}, /* East Asian ideograph */
  {"\x89", 0, 0x226556}, /* East Asian ideograph */
  {"\x91", 0, 0x226558}, /* East Asian ideograph */
  {"\x98", 0, 0x22655A}, /* East Asian ideograph */
  {"\x88", 0, 0x22655E}, /* East Asian ideograph */
  {"\x94", 0, 0x226560}, /* East Asian ideograph */
  {"\x9F", 0, 0x226568}, /* East Asian ideograph */
  {"\xA7", 0, 0x22656A}, /* East Asian ideograph */
  {"\x9B", 0, 0x22656E}, /* East Asian ideograph */
  {"\xA1", 0, 0x22656F}, /* East Asian ideograph */
  {"\xA0", 0, 0x226573}, /* East Asian ideograph */
  {"\xAE", 0, 0x226576}, /* East Asian ideograph */
  {"\xA3", 0, 0x226577}, /* East Asian ideograph */
  {"\xB2", 0, 0x226579}, /* East Asian ideograph */
  {"\xB9", 0, 0x226621}, /* East Asian ideograph */
  {"\xBD", 0, 0x226622}, /* East Asian ideograph */
  {"\xBE", 0, 0x226627}, /* East Asian ideograph */
  {"\xBB", 0, 0x226629}, /* East Asian ideograph */
  {"\x92", 0, 0x2D5F35}, /* East Asian ideograph */
  {"\x86", 0, 0x4B4846}, /* East Asian ideograph */
  {"\x99", 0, 0x4C6564}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page178 = {
  marc8r_31page178_flat, 0
};
/* PAGE 177 */
struct yaz_iconv_trie_flat marc8r_31page177_flat[] = {
  {"\xB0", 0, 0x214E3C}, /* East Asian ideograph */
  {"\x97", 0, 0x214E3D}, /* East Asian ideograph */
  {"\x8E", 0, 0x214E3E}, /* East Asian ideograph */
  {"\x98", 0, 0x214E3F}, /* East Asian ideograph */
  {"\x89", 0, 0x214E40}, /* East Asian ideograph */
  {"\x91", 0, 0x214E41}, /* East Asian ideograph */
  {"\x8C", 0, 0x214E43}, /* East Asian ideograph */
  {"\xA7", 0, 0x214E44}, /* East Asian ideograph */
  {"\xA9", 0, 0x214E45}, /* East Asian ideograph */
  {"\x9F", 0, 0x214E46}, /* East Asian ideograph */
  {"\xB3", 0, 0x214E47}, /* East Asian ideograph */
  {"\xBA", 0, 0x214E49}, /* East Asian ideograph */
  {"\xBC", 0, 0x214E4C}, /* East Asian ideograph */
  {"\xBE", 0, 0x214E4E}, /* East Asian ideograph */
  {"\x86", 0, 0x226469}, /* East Asian ideograph */
  {"\x9A", 0, 0x22646B}, /* East Asian ideograph */
  {"\x87", 0, 0x22646D}, /* East Asian ideograph */
  {"\x94", 0, 0x226470}, /* East Asian ideograph */
  {"\x8F", 0, 0x226476}, /* East Asian ideograph */
  {"\x99", 0, 0x22647E}, /* East Asian ideograph */
  {"\x93", 0, 0x226529}, /* East Asian ideograph */
  {"\x92", 0, 0x22652C}, /* East Asian ideograph */
  {"\x96", 0, 0x22652D}, /* East Asian ideograph */
  {"\xB2", 0, 0x22652F}, /* East Asian ideograph */
  {"\xA1", 0, 0x226531}, /* East Asian ideograph */
  {"\xB6", 0, 0x226532}, /* East Asian ideograph */
  {"\xB7", 0, 0x226539}, /* East Asian ideograph */
  {"\xA4", 0, 0x22653B}, /* East Asian ideograph */
  {"\xB4", 0, 0x22653E}, /* East Asian ideograph */
  {"\xAD", 0, 0x226540}, /* East Asian ideograph */
  {"\xA3", 0, 0x226541}, /* East Asian ideograph */
  {"\x9E", 0, 0x226543}, /* East Asian ideograph */
  {"\xA8", 0, 0x226544}, /* East Asian ideograph */
  {"\xAB", 0, 0x226548}, /* East Asian ideograph */
  {"\xBB", 0, 0x22654E}, /* East Asian ideograph */
  {"\x8D", 0, 0x274E5A}, /* East Asian ideograph */
  {"\x9B", 0, 0x28656A}, /* East Asian ideograph */
  {"\x9C", 0, 0x286577}, /* East Asian ideograph */
  {"\xA5", 0, 0x2D3F76}, /* East Asian ideograph */
  {"\xAF", 0, 0x2D4B5B}, /* East Asian ideograph */
  {"\xAA", 0, 0x2D4E33}, /* East Asian ideograph */
  {"\xB1", 0, 0x2D6252}, /* East Asian ideograph */
  {"\x95", 0, 0x333C21}, /* East Asian ideograph */
  {"\x81", 0, 0x3F4472}, /* East Asian ideograph */
  {"\xB9", 0, 0x4C6565}, /* East Asian ideograph */
  {"\xB5", 0, 0x696273}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page177 = {
  marc8r_31page177_flat, 0
};
/* PAGE 176 */
struct yaz_iconv_trie_flat marc8r_31page176_flat[] = {
  {"\xAB", 0, 0x214E36}, /* East Asian ideograph */
  {"\x8F", 0, 0x214E37}, /* East Asian ideograph */
  {"\x83", 0, 0x214E38}, /* East Asian ideograph */
  {"\xAC", 0, 0x214E39}, /* East Asian ideograph */
  {"\x9D", 0, 0x214E3A}, /* East Asian ideograph */
  {"\xAF", 0, 0x214E3B}, /* East Asian ideograph */
  {"\xBC", 0, 0x214E42}, /* East Asian ideograph */
  {"\x8D", 0, 0x226444}, /* East Asian ideograph */
  {"\x88", 0, 0x226448}, /* East Asian ideograph */
  {"\x93", 0, 0x226449}, /* East Asian ideograph */
  {"\x94", 0, 0x22644A}, /* East Asian ideograph */
  {"\x85", 0, 0x22644B}, /* East Asian ideograph */
  {"\x92", 0, 0x22644C}, /* East Asian ideograph */
  {"\x90", 0, 0x22644E}, /* East Asian ideograph */
  {"\x98", 0, 0x22644F}, /* East Asian ideograph */
  {"\x87", 0, 0x226452}, /* East Asian ideograph */
  {"\x8C", 0, 0x226456}, /* East Asian ideograph */
  {"\xA8", 0, 0x22645A}, /* East Asian ideograph */
  {"\xAD", 0, 0x22645B}, /* East Asian ideograph */
  {"\xA4", 0, 0x226460}, /* East Asian ideograph */
  {"\x9C", 0, 0x226461}, /* East Asian ideograph */
  {"\xB6", 0, 0x226464}, /* East Asian ideograph */
  {"\xAA", 0, 0x226466}, /* East Asian ideograph */
  {"\xBF", 0, 0x22646C}, /* East Asian ideograph */
  {"\x95", 0, 0x274E45}, /* East Asian ideograph */
  {"\xAE", 0, 0x274E49}, /* East Asian ideograph */
  {"\x80", 0, 0x274E59}, /* East Asian ideograph */
  {"\xB7", 0, 0x276252}, /* East Asian ideograph */
  {"\x96", 0, 0x286460}, /* East Asian ideograph */
  {"\x97", 0, 0x286622}, /* East Asian ideograph */
  {"\x8E", 0, 0x334E37}, /* East Asian ideograph */
  {"\xB2", 0, 0x694823}, /* East Asian ideograph */
  {"\xB4", 0, 0x69626D}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page176 = {
  marc8r_31page176_flat, 0
};
/* PAGE 175 */
struct yaz_iconv_trie_flat marc8r_31page175_flat[] = {
  {"\x82", 0, 0x214E2A}, /* East Asian ideograph */
  {"\x8D", 0, 0x214E2B}, /* East Asian ideograph */
  {"\x8C", 0, 0x214E2C}, /* East Asian ideograph */
  {"\xB0", 0, 0x214E2E}, /* East Asian ideograph */
  {"\x9D", 0, 0x214E2F}, /* East Asian ideograph */
  {"\xB4", 0, 0x214E30}, /* East Asian ideograph */
  {"\xB8", 0, 0x214E31}, /* East Asian ideograph */
  {"\xB7", 0, 0x214E32}, /* East Asian ideograph */
  {"\xA7", 0, 0x214E33}, /* East Asian ideograph */
  {"\xAD", 0, 0x214E34}, /* East Asian ideograph */
  {"\xA5", 0, 0x214E35}, /* East Asian ideograph */
  {"\x89", 0, 0x226370}, /* East Asian ideograph */
  {"\x86", 0, 0x226371}, /* East Asian ideograph */
  {"\x99", 0, 0x226373}, /* East Asian ideograph */
  {"\x91", 0, 0x226374}, /* East Asian ideograph */
  {"\x92", 0, 0x226378}, /* East Asian ideograph */
  {"\x9B", 0, 0x226424}, /* East Asian ideograph */
  {"\xAC", 0, 0x226426}, /* East Asian ideograph */
  {"\xA3", 0, 0x226427}, /* East Asian ideograph */
  {"\xAB", 0, 0x226428}, /* East Asian ideograph */
  {"\xA9", 0, 0x22642A}, /* East Asian ideograph */
  {"\xA2", 0, 0x22642D}, /* East Asian ideograph */
  {"\xB5", 0, 0x226431}, /* East Asian ideograph */
  {"\xB3", 0, 0x226432}, /* East Asian ideograph */
  {"\xAE", 0, 0x226433}, /* East Asian ideograph */
  {"\xA0", 0, 0x226435}, /* East Asian ideograph */
  {"\xBD", 0, 0x226438}, /* East Asian ideograph */
  {"\x9F", 0, 0x22643B}, /* East Asian ideograph */
  {"\xB1", 0, 0x22643D}, /* East Asian ideograph */
  {"\xA6", 0, 0x226450}, /* East Asian ideograph */
  {"\x9A", 0, 0x274E3B}, /* East Asian ideograph */
  {"\x95", 0, 0x274E3E}, /* East Asian ideograph */
  {"\x81", 0, 0x274E4C}, /* East Asian ideograph */
  {"\x96", 0, 0x274E53}, /* East Asian ideograph */
  {"\xBA", 0, 0x274E5D}, /* East Asian ideograph */
  {"\xBE", 0, 0x274E5E}, /* East Asian ideograph */
  {"\x97", 0, 0x28645A}, /* East Asian ideograph */
  {"\x80", 0, 0x286540}, /* East Asian ideograph */
  {"\xBB", 0, 0x286655}, /* East Asian ideograph */
  {"\xB2", 0, 0x3F4956}, /* East Asian ideograph */
  {"\x94", 0, 0x4B4E37}, /* East Asian ideograph */
  {"\xBF", 0, 0x4B4E5B}, /* East Asian ideograph */
  {"\xB9", 0, 0x4C6376}, /* East Asian ideograph */
  {"\x98", 0, 0x706D3B}, /* East Asian ideograph */
  {"\x9C", 0, 0x706D3F}, /* East Asian ideograph */
  {"\xBC", 0, 0x706D45}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page175 = {
  marc8r_31page175_flat, 0
};
/* PAGE 174 */
struct yaz_iconv_trie_flat marc8r_31page174_flat[] = {
  {"\x93", 0, 0x214D7A}, /* East Asian ideograph */
  {"\x97", 0, 0x214D7B}, /* East Asian ideograph */
  {"\x9A", 0, 0x214D7C}, /* East Asian ideograph */
  {"\x9B", 0, 0x214D7D}, /* East Asian ideograph */
  {"\x9C", 0, 0x214D7E}, /* East Asian ideograph */
  {"\xA2", 0, 0x214E21}, /* East Asian ideograph */
  {"\xA3", 0, 0x214E22}, /* East Asian ideograph */
  {"\xA5", 0, 0x214E23}, /* East Asian ideograph */
  {"\xA9", 0, 0x214E24}, /* East Asian ideograph */
  {"\xAD", 0, 0x214E25}, /* East Asian ideograph */
  {"\xAE", 0, 0x214E26}, /* East Asian ideograph */
  {"\xAF", 0, 0x214E27}, /* East Asian ideograph */
  {"\xB3", 0, 0x214E28}, /* East Asian ideograph */
  {"\xBD", 0, 0x214E29}, /* East Asian ideograph */
  {"\x8D", 0, 0x226335}, /* East Asian ideograph */
  {"\x91", 0, 0x22633A}, /* East Asian ideograph */
  {"\x9E", 0, 0x226345}, /* East Asian ideograph */
  {"\x9F", 0, 0x226346}, /* East Asian ideograph */
  {"\xA7", 0, 0x22634F}, /* East Asian ideograph */
  {"\xA6", 0, 0x226352}, /* East Asian ideograph */
  {"\xAC", 0, 0x226355}, /* East Asian ideograph */
  {"\xB0", 0, 0x226359}, /* East Asian ideograph */
  {"\xB1", 0, 0x22635A}, /* East Asian ideograph */
  {"\xB4", 0, 0x22635C}, /* East Asian ideograph */
  {"\xBC", 0, 0x226360}, /* East Asian ideograph */
  {"\xB8", 0, 0x226367}, /* East Asian ideograph */
  {"\xBB", 0, 0x226368}, /* East Asian ideograph */
  {"\xAB", 0, 0x274E27}, /* East Asian ideograph */
  {"\xB6", 0, 0x274E58}, /* East Asian ideograph */
  {"\xBF", 0, 0x274E5B}, /* East Asian ideograph */
  {"\xBE", 0, 0x274E5C}, /* East Asian ideograph */
  {"\x81", 0, 0x2E625F}, /* East Asian ideograph */
  {"\x87", 0, 0x4B5564}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page174 = {
  marc8r_31page174_flat, 0
};
/* PAGE 173 */
struct yaz_iconv_trie_flat marc8r_31page173_flat[] = {
  {"\x84", 0, 0x214D66}, /* East Asian ideograph */
  {"\x87", 0, 0x214D68}, /* East Asian ideograph */
  {"\x8E", 0, 0x214D69}, /* East Asian ideograph */
  {"\x8C", 0, 0x214D6A}, /* East Asian ideograph */
  {"\x91", 0, 0x214D6B}, /* East Asian ideograph */
  {"\x9F", 0, 0x214D6C}, /* East Asian ideograph */
  {"\x9E", 0, 0x214D6D}, /* East Asian ideograph */
  {"\xA0", 0, 0x214D6E}, /* East Asian ideograph */
  {"\xA5", 0, 0x214D6F}, /* East Asian ideograph */
  {"\xB3", 0, 0x214D70}, /* East Asian ideograph */
  {"\xAA", 0, 0x214D71}, /* East Asian ideograph */
  {"\xB0", 0, 0x214D72}, /* East Asian ideograph */
  {"\xAD", 0, 0x214D73}, /* East Asian ideograph */
  {"\xAC", 0, 0x214D74}, /* East Asian ideograph */
  {"\xA7", 0, 0x214D75}, /* East Asian ideograph */
  {"\xBD", 0, 0x214D76}, /* East Asian ideograph */
  {"\xBF", 0, 0x214D77}, /* East Asian ideograph */
  {"\xBB", 0, 0x214D78}, /* East Asian ideograph */
  {"\x80", 0, 0x226252}, /* East Asian ideograph */
  {"\x85", 0, 0x22625F}, /* East Asian ideograph */
  {"\x8B", 0, 0x226266}, /* East Asian ideograph (variant of EACC 4C6266) */
  {"\x8D", 0, 0x22626A}, /* East Asian ideograph */
  {"\x98", 0, 0x226272}, /* East Asian ideograph */
  {"\x96", 0, 0x226273}, /* East Asian ideograph */
  {"\xA2", 0, 0x226275}, /* East Asian ideograph */
  {"\x99", 0, 0x226276}, /* East Asian ideograph */
  {"\xB5", 0, 0x22627A}, /* East Asian ideograph */
  {"\xB7", 0, 0x22627D}, /* East Asian ideograph */
  {"\xB6", 0, 0x226323}, /* East Asian ideograph */
  {"\xBE", 0, 0x226329}, /* East Asian ideograph */
  {"\xB9", 0, 0x22632B}, /* East Asian ideograph */
  {"\xBC", 0, 0x22632C}, /* East Asian ideograph */
  {"\xA9", 0, 0x274D7C}, /* East Asian ideograph */
  {"\x92", 0, 0x2D4D6D}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page173 = {
  marc8r_31page173_flat, 0
};
/* PAGE 172 */
struct yaz_iconv_trie_flat marc8r_31page172_flat[] = {
  {"\x8F", 0, 0x214D57}, /* East Asian ideograph */
  {"\xAB", 0, 0x214D58}, /* East Asian ideograph */
  {"\x9B", 0, 0x214D59}, /* East Asian ideograph */
  {"\xAA", 0, 0x214D5A}, /* East Asian ideograph */
  {"\xA6", 0, 0x214D5B}, /* East Asian ideograph */
  {"\xB9", 0, 0x214D5C}, /* East Asian ideograph */
  {"\x9E", 0, 0x214D5D}, /* East Asian ideograph */
  {"\xA3", 0, 0x214D5E}, /* East Asian ideograph */
  {"\x9C", 0, 0x214D5F}, /* East Asian ideograph */
  {"\xAC", 0, 0x214D60}, /* East Asian ideograph */
  {"\xA8", 0, 0x214D61}, /* East Asian ideograph */
  {"\xA5", 0, 0x214D62}, /* East Asian ideograph */
  {"\xBD", 0, 0x214D63}, /* East Asian ideograph */
  {"\xB1", 0, 0x214D64}, /* East Asian ideograph */
  {"\xBF", 0, 0x214D65}, /* East Asian ideograph */
  {"\xA1", 0, 0x214D67}, /* East Asian ideograph */
  {"\x80", 0, 0x226174}, /* East Asian ideograph */
  {"\x87", 0, 0x22622D}, /* East Asian ideograph */
  {"\x85", 0, 0x226231}, /* East Asian ideograph */
  {"\x8D", 0, 0x226232}, /* East Asian ideograph */
  {"\x8A", 0, 0x226233}, /* East Asian ideograph */
  {"\x83", 0, 0x226235}, /* East Asian ideograph */
  {"\x8E", 0, 0x226237}, /* East Asian ideograph */
  {"\x9F", 0, 0x22623A}, /* East Asian ideograph */
  {"\xA0", 0, 0x22623D}, /* East Asian ideograph */
  {"\x92", 0, 0x22623E}, /* East Asian ideograph */
  {"\x98", 0, 0x226242}, /* East Asian ideograph */
  {"\x96", 0, 0x226244}, /* East Asian ideograph */
  {"\x9A", 0, 0x226245}, /* East Asian ideograph */
  {"\xA2", 0, 0x22624F}, /* East Asian ideograph */
  {"\xAF", 0, 0x226256}, /* East Asian ideograph */
  {"\xBE", 0, 0x22625D}, /* East Asian ideograph */
  {"\xBA", 0, 0x226260}, /* East Asian ideograph */
  {"\x90", 0, 0x274D5D}, /* East Asian ideograph */
  {"\x91", 0, 0x28632C}, /* East Asian ideograph */
  {"\x81", 0, 0x2D4D5F}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page172 = {
  marc8r_31page172_flat, 0
};
/* PAGE 171 */
struct yaz_iconv_trie_flat marc8r_31page171_flat[] = {
  {"\x89", 0, 0x214D46}, /* East Asian ideograph */
  {"\x81", 0, 0x214D49}, /* East Asian ideograph */
  {"\x8B", 0, 0x214D4A}, /* East Asian ideograph */
  {"\xA9", 0, 0x214D4D}, /* East Asian ideograph */
  {"\xA0", 0, 0x214D4E}, /* East Asian ideograph */
  {"\x9E", 0, 0x214D4F}, /* East Asian ideograph */
  {"\xA8", 0, 0x214D50}, /* East Asian ideograph */
  {"\xB7", 0, 0x214D51}, /* East Asian ideograph */
  {"\xBC", 0, 0x214D52}, /* East Asian ideograph */
  {"\xB6", 0, 0x214D53}, /* East Asian ideograph */
  {"\xB8", 0, 0x214D54}, /* East Asian ideograph */
  {"\xBA", 0, 0x214D55}, /* East Asian ideograph */
  {"\xBE", 0, 0x214D56}, /* East Asian ideograph */
  {"\x84", 0, 0x22614B}, /* East Asian ideograph */
  {"\x88", 0, 0x22614F}, /* East Asian ideograph */
  {"\x87", 0, 0x226150}, /* East Asian ideograph */
  {"\x8A", 0, 0x226154}, /* East Asian ideograph */
  {"\xAB", 0, 0x22615E}, /* East Asian ideograph */
  {"\x8E", 0, 0x226160}, /* East Asian ideograph */
  {"\x9B", 0, 0x226162}, /* East Asian ideograph */
  {"\xA4", 0, 0x226163}, /* East Asian ideograph */
  {"\xA2", 0, 0x22616C}, /* East Asian ideograph */
  {"\x9A", 0, 0x22616D}, /* East Asian ideograph */
  {"\xA1", 0, 0x22616F}, /* East Asian ideograph */
  {"\xB9", 0, 0x226175}, /* East Asian ideograph */
  {"\xAF", 0, 0x226176}, /* East Asian ideograph */
  {"\xB1", 0, 0x226177}, /* East Asian ideograph */
  {"\xA5", 0, 0x226222}, /* East Asian ideograph */
  {"\xB5", 0, 0x226225}, /* East Asian ideograph */
  {"\xB4", 0, 0x226226}, /* East Asian ideograph */
  {"\xA6", 0, 0x286222}, /* East Asian ideograph */
  {"\x8D", 0, 0x286272}, /* East Asian ideograph */
  {"\x9F", 0, 0x2D4D4F}, /* East Asian ideograph */
  {"\x99", 0, 0x2D4D71}, /* East Asian ideograph */
  {"\xAD", 0, 0x2E624F}, /* East Asian ideograph */
  {"\x98", 0, 0x333F24}, /* East Asian ideograph */
  {"\x8C", 0, 0x4B5164}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page171 = {
  marc8r_31page171_flat, 0
};
/* PAGE 170 */
struct yaz_iconv_trie_flat marc8r_31page170_flat[] = {
  {"\x82", 0, 0x214D2F}, /* East Asian ideograph */
  {"\x88", 0, 0x214D31}, /* East Asian ideograph */
  {"\x86", 0, 0x214D32}, /* East Asian ideograph */
  {"\x8A", 0, 0x214D33}, /* East Asian ideograph */
  {"\x8D", 0, 0x214D34}, /* East Asian ideograph */
  {"\x8E", 0, 0x214D35}, /* East Asian ideograph */
  {"\x94", 0, 0x214D36}, /* East Asian ideograph */
  {"\x92", 0, 0x214D37}, /* East Asian ideograph */
  {"\x9C", 0, 0x214D38}, /* East Asian ideograph */
  {"\x9B", 0, 0x214D39}, /* East Asian ideograph */
  {"\x9E", 0, 0x214D3A}, /* East Asian ideograph */
  {"\x9F", 0, 0x214D3B}, /* East Asian ideograph */
  {"\xA1", 0, 0x214D3C}, /* East Asian ideograph */
  {"\xA3", 0, 0x214D3D}, /* East Asian ideograph */
  {"\xA4", 0, 0x214D3E}, /* East Asian ideograph */
  {"\xA7", 0, 0x214D3F}, /* East Asian ideograph */
  {"\xA5", 0, 0x214D40}, /* East Asian ideograph */
  {"\xAA", 0, 0x214D41}, /* East Asian ideograph */
  {"\xAE", 0, 0x214D42}, /* East Asian ideograph */
  {"\xAF", 0, 0x214D43}, /* East Asian ideograph */
  {"\xB2", 0, 0x214D44}, /* East Asian ideograph */
  {"\xB4", 0, 0x214D45}, /* East Asian ideograph */
  {"\xB9", 0, 0x214D47}, /* East Asian ideograph */
  {"\xB8", 0, 0x214D48}, /* East Asian ideograph */
  {"\xBC", 0, 0x214D4B}, /* East Asian ideograph */
  {"\xBE", 0, 0x214D4C}, /* East Asian ideograph */
  {"\x8B", 0, 0x226123}, /* East Asian ideograph */
  {"\x8C", 0, 0x226126}, /* East Asian ideograph */
  {"\xA6", 0, 0x22613B}, /* East Asian ideograph */
  {"\xA9", 0, 0x22613C}, /* East Asian ideograph */
  {"\xAC", 0, 0x226140}, /* East Asian ideograph */
  {"\xAD", 0, 0x226144}, /* East Asian ideograph */
  {"\xB1", 0, 0x226148}, /* East Asian ideograph */
  {"\xB7", 0, 0x226153}, /* East Asian ideograph */
  {"\xBB", 0, 0x226159}, /* East Asian ideograph */
  {"\x8F", 0, 0x274D3A}, /* East Asian ideograph */
  {"\x91", 0, 0x274D3D}, /* East Asian ideograph */
  {"\x98", 0, 0x274D3E}, /* East Asian ideograph */
  {"\x90", 0, 0x276251}, /* East Asian ideograph */
  {"\x87", 0, 0x2D4D34}, /* East Asian ideograph */
  {"\x97", 0, 0x2D4D38}, /* East Asian ideograph */
  {"\x96", 0, 0x2D5561}, /* East Asian ideograph */
  {"\x83", 0, 0x334425}, /* East Asian ideograph */
  {"\x85", 0, 0x334674}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page170 = {
  marc8r_31page170_flat, 0
};
/* PAGE 169 */
struct yaz_iconv_trie_flat marc8r_31page169_flat[] = {
  {"\x82", 0, 0x214D21}, /* East Asian ideograph */
  {"\x84", 0, 0x214D22}, /* East Asian ideograph */
  {"\x87", 0, 0x214D23}, /* East Asian ideograph */
  {"\x86", 0, 0x214D24}, /* East Asian ideograph */
  {"\x8E", 0, 0x214D26}, /* East Asian ideograph */
  {"\x96", 0, 0x214D27}, /* East Asian ideograph */
  {"\x93", 0, 0x214D28}, /* East Asian ideograph */
  {"\x9A", 0, 0x214D29}, /* East Asian ideograph */
  {"\xAE", 0, 0x214D2A}, /* East Asian ideograph */
  {"\xB0", 0, 0x214D2B}, /* East Asian ideograph */
  {"\xB4", 0, 0x214D2C}, /* East Asian ideograph */
  {"\xBA", 0, 0x214D2D}, /* East Asian ideograph */
  {"\xBF", 0, 0x214D2E}, /* East Asian ideograph */
  {"\x80", 0, 0x226048}, /* East Asian ideograph */
  {"\x8B", 0, 0x22604A}, /* East Asian ideograph */
  {"\x95", 0, 0x226052}, /* East Asian ideograph */
  {"\x99", 0, 0x226059}, /* East Asian ideograph */
  {"\x9C", 0, 0x22605D}, /* East Asian ideograph */
  {"\x9D", 0, 0x22605F}, /* East Asian ideograph */
  {"\xA4", 0, 0x226065}, /* East Asian ideograph */
  {"\xA5", 0, 0x226066}, /* East Asian ideograph */
  {"\xA6", 0, 0x226067}, /* East Asian ideograph */
  {"\xAA", 0, 0x22606A}, /* East Asian ideograph */
  {"\xAD", 0, 0x22606D}, /* East Asian ideograph */
  {"\xB8", 0, 0x226074}, /* East Asian ideograph */
  {"\xBD", 0, 0x226077}, /* East Asian ideograph */
  {"\x91", 0, 0x274D29}, /* East Asian ideograph */
  {"\xB1", 0, 0x274D2D}, /* East Asian ideograph */
  {"\x83", 0, 0x275966}, /* East Asian ideograph */
  {"\x81", 0, 0x2D4D21}, /* East Asian ideograph */
  {"\xB7", 0, 0x2D6275}, /* East Asian ideograph */
  {"\x90", 0, 0x2E604A}, /* East Asian ideograph */
  {"\xA1", 0, 0x2E6060}, /* East Asian ideograph */
  {"\xBC", 0, 0x336275}, /* East Asian ideograph */
  {"\x88", 0, 0x45462B}, /* East Asian ideograph */
  {"\xB2", 0, 0x466074}, /* East Asian ideograph */
  {"\xB9", 0, 0x4C6074}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page169 = {
  marc8r_31page169_flat, 0
};
/* PAGE 168 */
struct yaz_iconv_trie_flat marc8r_31page168_flat[] = {
  {"\x86", 0, 0x214C6D}, /* East Asian ideograph */
  {"\x82", 0, 0x214C6E}, /* East Asian ideograph */
  {"\x8C", 0, 0x214C6F}, /* East Asian ideograph */
  {"\x96", 0, 0x214C70}, /* East Asian ideograph */
  {"\x98", 0, 0x214C71}, /* East Asian ideograph */
  {"\xA2", 0, 0x214C73}, /* East Asian ideograph */
  {"\xA5", 0, 0x214C74}, /* East Asian ideograph */
  {"\xA9", 0, 0x214C75}, /* East Asian ideograph */
  {"\xAE", 0, 0x214C76}, /* East Asian ideograph */
  {"\xAC", 0, 0x214C77}, /* East Asian ideograph */
  {"\xB1", 0, 0x214C78}, /* East Asian ideograph */
  {"\xB2", 0, 0x214C79}, /* East Asian ideograph (variant of EACC 4B4C79) */
  {"\xB8", 0, 0x214C7A}, /* East Asian ideograph */
  {"\xBC", 0, 0x214C7B}, /* East Asian ideograph */
  {"\xBB", 0, 0x214C7C}, /* East Asian ideograph */
  {"\xBD", 0, 0x214C7D}, /* East Asian ideograph */
  {"\xBE", 0, 0x214C7E}, /* East Asian ideograph */
  {"\x88", 0, 0x225F67}, /* East Asian ideograph */
  {"\x8E", 0, 0x225F68}, /* East Asian ideograph */
  {"\x87", 0, 0x225F69}, /* East Asian ideograph */
  {"\x83", 0, 0x225F6A}, /* East Asian ideograph */
  {"\x8D", 0, 0x225F6E}, /* East Asian ideograph */
  {"\x89", 0, 0x225F6F}, /* East Asian ideograph */
  {"\x94", 0, 0x225F75}, /* East Asian ideograph */
  {"\x9C", 0, 0x225F7A}, /* East Asian ideograph */
  {"\x97", 0, 0x225F7B}, /* East Asian ideograph */
  {"\xA4", 0, 0x226022}, /* East Asian ideograph */
  {"\x99", 0, 0x226024}, /* East Asian ideograph */
  {"\x9F", 0, 0x22602B}, /* East Asian ideograph */
  {"\xA7", 0, 0x226032}, /* East Asian ideograph */
  {"\xAA", 0, 0x226035}, /* East Asian ideograph */
  {"\xAD", 0, 0x226037}, /* East Asian ideograph */
  {"\xAF", 0, 0x226038}, /* East Asian ideograph */
  {"\xB0", 0, 0x22603A}, /* East Asian ideograph */
  {"\xB6", 0, 0x226040}, /* East Asian ideograph */
  {"\xB7", 0, 0x226041}, /* East Asian ideograph */
  {"\x9E", 0, 0x274C75}, /* East Asian ideograph */
  {"\xA3", 0, 0x274C77}, /* East Asian ideograph */
  {"\xAB", 0, 0x274C79}, /* East Asian ideograph */
  {"\xA1", 0, 0x2D4C5D}, /* East Asian ideograph */
  {"\x92", 0, 0x333E7D}, /* East Asian ideograph */
  {"\xBA", 0, 0x334C7B}, /* East Asian ideograph */
  {"\xA8", 0, 0x4B5F62}, /* East Asian ideograph */
  {"\x80", 0, 0x4C5F58}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page168 = {
  marc8r_31page168_flat, 0
};
/* PAGE 167 */
struct yaz_iconv_trie_flat marc8r_31page167_flat[] = {
  {"\x81", 0, 0x214C58}, /* East Asian ideograph */
  {"\x80", 0, 0x214C59}, /* East Asian ideograph */
  {"\x8D", 0, 0x214C60}, /* East Asian ideograph */
  {"\xA7", 0, 0x214C61}, /* East Asian ideograph */
  {"\x93", 0, 0x214C62}, /* East Asian ideograph */
  {"\x8B", 0, 0x214C63}, /* East Asian ideograph */
  {"\xA0", 0, 0x214C65}, /* East Asian ideograph */
  {"\xA9", 0, 0x214C66}, /* East Asian ideograph */
  {"\x9F", 0, 0x214C67}, /* East Asian ideograph */
  {"\xA4", 0, 0x214C68}, /* East Asian ideograph */
  {"\xA6", 0, 0x214C69}, /* East Asian ideograph */
  {"\xA1", 0, 0x214C6A}, /* East Asian ideograph */
  {"\xB4", 0, 0x214C6B}, /* East Asian ideograph */
  {"\xB8", 0, 0x214C6C}, /* East Asian ideograph */
  {"\x82", 0, 0x225E7A}, /* East Asian ideograph */
  {"\x83", 0, 0x225E7E}, /* East Asian ideograph */
  {"\x96", 0, 0x225F29}, /* East Asian ideograph */
  {"\x88", 0, 0x225F2C}, /* East Asian ideograph */
  {"\x95", 0, 0x225F2D}, /* East Asian ideograph */
  {"\x8C", 0, 0x225F2E}, /* East Asian ideograph */
  {"\x8F", 0, 0x225F2F}, /* East Asian ideograph */
  {"\x90", 0, 0x225F3B}, /* East Asian ideograph */
  {"\x8A", 0, 0x225F3C}, /* East Asian ideograph */
  {"\xA5", 0, 0x225F3E}, /* East Asian ideograph */
  {"\x9A", 0, 0x225F3F}, /* East Asian ideograph */
  {"\x9B", 0, 0x225F40}, /* East Asian ideograph */
  {"\x99", 0, 0x225F47}, /* East Asian ideograph */
  {"\x9E", 0, 0x225F48}, /* East Asian ideograph */
  {"\x9D", 0, 0x225F4C}, /* East Asian ideograph */
  {"\xA2", 0, 0x225F50}, /* East Asian ideograph */
  {"\xAF", 0, 0x225F51}, /* East Asian ideograph */
  {"\xAD", 0, 0x225F54}, /* East Asian ideograph */
  {"\xB3", 0, 0x225F5C}, /* East Asian ideograph */
  {"\xBB", 0, 0x225F5E}, /* East Asian ideograph */
  {"\xB0", 0, 0x225F5F}, /* East Asian ideograph */
  {"\xBC", 0, 0x225F60}, /* East Asian ideograph */
  {"\xB5", 0, 0x225F62}, /* East Asian ideograph */
  {"\xBE", 0, 0x274C76}, /* East Asian ideograph */
  {"\xAB", 0, 0x274C78}, /* East Asian ideograph */
  {"\x97", 0, 0x285F48}, /* East Asian ideograph */
  {"\x98", 0, 0x285F5E}, /* East Asian ideograph */
  {"\x85", 0, 0x285F6F}, /* East Asian ideograph */
  {"\xAA", 0, 0x28602B}, /* East Asian ideograph */
  {"\xBF", 0, 0x286037}, /* East Asian ideograph */
  {"\x89", 0, 0x393E7D}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page167 = {
  marc8r_31page167_flat, 0
};
/* PAGE 166 */
struct yaz_iconv_trie_flat marc8r_31page166_flat[] = {
  {"\x87", 0, 0x214C46}, /* East Asian ideograph */
  {"\x85", 0, 0x214C47}, /* East Asian ideograph */
  {"\x95", 0, 0x214C4E}, /* East Asian ideograph */
  {"\x94", 0, 0x214C4F}, /* East Asian ideograph */
  {"\x8A", 0, 0x214C51}, /* East Asian ideograph (variant of EACC 4B4C51) */
  {"\x9B", 0, 0x214C52}, /* East Asian ideograph */
  {"\xA3", 0, 0x214C53}, /* East Asian ideograph */
  {"\x98", 0, 0x214C54}, /* East Asian ideograph */
  {"\x9E", 0, 0x214C55}, /* East Asian ideograph */
  {"\x99", 0, 0x214C56}, /* East Asian ideograph */
  {"\xA2", 0, 0x214C57}, /* East Asian ideograph */
  {"\xB0", 0, 0x214C5A}, /* East Asian ideograph */
  {"\xB2", 0, 0x214C5B}, /* East Asian ideograph */
  {"\xB1", 0, 0x214C5C}, /* East Asian ideograph */
  {"\xB4", 0, 0x214C5D}, /* East Asian ideograph */
  {"\xBF", 0, 0x214C5E}, /* East Asian ideograph */
  {"\xBA", 0, 0x214C5F}, /* East Asian ideograph */
  {"\x83", 0, 0x225E44}, /* East Asian ideograph */
  {"\x82", 0, 0x225E4A}, /* East Asian ideograph */
  {"\x81", 0, 0x225E4E}, /* East Asian ideograph */
  {"\x84", 0, 0x225E51}, /* East Asian ideograph */
  {"\x8D", 0, 0x225E58}, /* East Asian ideograph */
  {"\x8F", 0, 0x225E5C}, /* East Asian ideograph */
  {"\x8C", 0, 0x225E5E}, /* East Asian ideograph */
  {"\x90", 0, 0x225E5F}, /* East Asian ideograph */
  {"\xA7", 0, 0x225E63}, /* East Asian ideograph */
  {"\xA1", 0, 0x225E66}, /* East Asian ideograph */
  {"\xA6", 0, 0x225E67}, /* East Asian ideograph */
  {"\xA4", 0, 0x225E71}, /* East Asian ideograph */
  {"\xA0", 0, 0x225E72}, /* East Asian ideograph */
  {"\x97", 0, 0x225E73}, /* East Asian ideograph */
  {"\xB9", 0, 0x225F21}, /* East Asian ideograph */
  {"\xBC", 0, 0x225F22}, /* East Asian ideograph */
  {"\x89", 0, 0x274C56}, /* East Asian ideograph */
  {"\xAA", 0, 0x274C62}, /* East Asian ideograph */
  {"\xA8", 0, 0x274C6D}, /* East Asian ideograph */
  {"\x92", 0, 0x274C73}, /* East Asian ideograph */
  {"\x96", 0, 0x285E7A}, /* East Asian ideograph */
  {"\x88", 0, 0x28603A}, /* East Asian ideograph */
  {"\xBE", 0, 0x345E47}, /* East Asian ideograph */
  {"\xB3", 0, 0x4B4C5B}, /* East Asian ideograph */
  {"\xAB", 0, 0x4C5F69}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page166 = {
  marc8r_31page166_flat, 0
};
/* PAGE 165 */
struct yaz_iconv_trie_flat marc8r_31page165_flat[] = {
  {"\x86", 0, 0x214C3A}, /* East Asian ideograph */
  {"\x87", 0, 0x214C3B}, /* East Asian ideograph */
  {"\x8A", 0, 0x214C3C}, /* East Asian ideograph */
  {"\x8F", 0, 0x214C3E}, /* East Asian ideograph */
  {"\x91", 0, 0x214C3F}, /* East Asian ideograph */
  {"\x9D", 0, 0x214C40}, /* East Asian ideograph */
  {"\x99", 0, 0x214C41}, /* East Asian ideograph */
  {"\x9A", 0, 0x214C42}, /* East Asian ideograph */
  {"\xA4", 0, 0x214C43}, /* East Asian ideograph */
  {"\xAB", 0, 0x214C44}, /* East Asian ideograph */
  {"\xA5", 0, 0x214C45}, /* East Asian ideograph */
  {"\xB3", 0, 0x214C48}, /* East Asian ideograph */
  {"\xB2", 0, 0x214C49}, /* East Asian ideograph */
  {"\xBD", 0, 0x214C4A}, /* East Asian ideograph */
  {"\xBE", 0, 0x214C4B}, /* East Asian ideograph */
  {"\xBC", 0, 0x214C4C}, /* East Asian ideograph */
  {"\xB9", 0, 0x214C4D}, /* East Asian ideograph */
  {"\xB5", 0, 0x214C50}, /* East Asian ideograph */
  {"\x83", 0, 0x225E25}, /* East Asian ideograph */
  {"\x90", 0, 0x225E2C}, /* East Asian ideograph */
  {"\x92", 0, 0x225E2D}, /* East Asian ideograph */
  {"\x94", 0, 0x225E2E}, /* East Asian ideograph */
  {"\x95", 0, 0x225E31}, /* East Asian ideograph */
  {"\x98", 0, 0x225E35}, /* East Asian ideograph */
  {"\xA2", 0, 0x225E37}, /* East Asian ideograph */
  {"\xA3", 0, 0x225E3B}, /* East Asian ideograph */
  {"\xBA", 0, 0x225E3E}, /* East Asian ideograph */
  {"\xB0", 0, 0x225E43}, /* East Asian ideograph */
  {"\xBF", 0, 0x225E46}, /* East Asian ideograph */
  {"\xB4", 0, 0x225E47}, /* East Asian ideograph */
  {"\xB1", 0, 0x225E50}, /* East Asian ideograph */
  {"\xA1", 0, 0x274C60}, /* East Asian ideograph */
  {"\x9F", 0, 0x274C61}, /* East Asian ideograph */
  {"\xAF", 0, 0x274C63}, /* East Asian ideograph */
  {"\xAE", 0, 0x274C6A}, /* East Asian ideograph */
  {"\x97", 0, 0x274C6E}, /* East Asian ideograph */
  {"\xA0", 0, 0x274C71}, /* East Asian ideograph */
  {"\xAC", 0, 0x286032}, /* East Asian ideograph */
  {"\x8B", 0, 0x2D3453}, /* East Asian ideograph */
  {"\x8E", 0, 0x2D4C3E}, /* East Asian ideograph */
  {"\xB8", 0, 0x2E5F6F}, /* East Asian ideograph */
  {"\x82", 0, 0x3F4C3C}, /* East Asian ideograph */
  {"\x89", 0, 0x454C3C}, /* East Asian ideograph */
  {"\x96", 0, 0x4C6022}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page165 = {
  marc8r_31page165_flat, 0
};
/* PAGE 164 */
struct yaz_iconv_trie_flat marc8r_31page164_flat[] = {
  {"\x8F", 0, 0x214C2B}, /* East Asian ideograph */
  {"\x8C", 0, 0x214C2C}, /* East Asian ideograph */
  {"\x9D", 0, 0x214C2D}, /* East Asian ideograph */
  {"\x9C", 0, 0x214C2E}, /* East Asian ideograph */
  {"\x94", 0, 0x214C2F}, /* East Asian ideograph */
  {"\x9A", 0, 0x214C30}, /* East Asian ideograph */
  {"\x99", 0, 0x214C31}, /* East Asian ideograph */
  {"\xA6", 0, 0x214C32}, /* East Asian ideograph */
  {"\xA2", 0, 0x214C33}, /* East Asian ideograph */
  {"\xB0", 0, 0x214C34}, /* East Asian ideograph */
  {"\xA5", 0, 0x214C35}, /* East Asian ideograph */
  {"\xAB", 0, 0x214C36}, /* East Asian ideograph */
  {"\xAA", 0, 0x214C37}, /* East Asian ideograph */
  {"\xB8", 0, 0x214C38}, /* East Asian ideograph */
  {"\xB6", 0, 0x214C39}, /* East Asian ideograph */
  {"\x93", 0, 0x22477B}, /* East Asian ideograph */
  {"\x91", 0, 0x225068}, /* East Asian ideograph */
  {"\x80", 0, 0x225D51}, /* East Asian ideograph */
  {"\x8A", 0, 0x225D55}, /* East Asian ideograph */
  {"\x8E", 0, 0x225D57}, /* East Asian ideograph */
  {"\x87", 0, 0x225D58}, /* East Asian ideograph */
  {"\x8B", 0, 0x225D59}, /* East Asian ideograph */
  {"\x88", 0, 0x225D5A}, /* East Asian ideograph */
  {"\x9F", 0, 0x225D5F}, /* East Asian ideograph */
  {"\x9B", 0, 0x225D60}, /* East Asian ideograph */
  {"\xA4", 0, 0x225D62}, /* East Asian ideograph */
  {"\xA3", 0, 0x225D67}, /* East Asian ideograph */
  {"\xAF", 0, 0x225D69}, /* East Asian ideograph */
  {"\xAC", 0, 0x225D6B}, /* East Asian ideograph */
  {"\xB9", 0, 0x225D6D}, /* East Asian ideograph */
  {"\xBA", 0, 0x225D6E}, /* East Asian ideograph */
  {"\xB7", 0, 0x225D71}, /* East Asian ideograph */
  {"\xB1", 0, 0x225D75}, /* East Asian ideograph */
  {"\xBD", 0, 0x225D79}, /* East Asian ideograph */
  {"\xBF", 0, 0x225D7E}, /* East Asian ideograph */
  {"\x85", 0, 0x274343}, /* East Asian ideograph */
  {"\x84", 0, 0x274C31}, /* East Asian ideograph */
  {"\xB4", 0, 0x274C3B}, /* East Asian ideograph */
  {"\xB2", 0, 0x285D6B}, /* East Asian ideograph */
  {"\xAE", 0, 0x2D4C2D}, /* East Asian ideograph */
  {"\xA7", 0, 0x2D4C35}, /* East Asian ideograph */
  {"\x8D", 0, 0x334C2C}, /* East Asian ideograph */
  {"\xAD", 0, 0x345D6B}, /* East Asian ideograph */
  {"\x86", 0, 0x394C2D}, /* East Asian ideograph */
  {"\xB5", 0, 0x4B4C36}, /* East Asian ideograph */
  {"\xB3", 0, 0x4B4C3C}, /* East Asian ideograph */
  {"\xA0", 0, 0x69482B}, /* East Asian ideograph */
  {"\x89", 0, 0x69613A}, /* East Asian ideograph */
  {"\xA9", 0, 0x69613E}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page164 = {
  marc8r_31page164_flat, 0
};
/* PAGE 163 */
struct yaz_iconv_trie_flat marc8r_31page163_flat[] = {
  {"\x84", 0, 0x214B73}, /* East Asian ideograph */
  {"\x8C", 0, 0x214B74}, /* East Asian ideograph */
  {"\x95", 0, 0x214B75}, /* East Asian ideograph */
  {"\x98", 0, 0x214B76}, /* East Asian ideograph */
  {"\x9A", 0, 0x214B77}, /* East Asian ideograph */
  {"\x9C", 0, 0x214B78}, /* East Asian ideograph */
  {"\x9F", 0, 0x214B79}, /* East Asian ideograph */
  {"\xA2", 0, 0x214B7A}, /* East Asian ideograph */
  {"\xA6", 0, 0x214B7B}, /* East Asian ideograph */
  {"\xA5", 0, 0x214B7C}, /* East Asian ideograph */
  {"\xA8", 0, 0x214B7D}, /* East Asian ideograph */
  {"\xA9", 0, 0x214B7E}, /* East Asian ideograph */
  {"\xAC", 0, 0x214C21}, /* East Asian ideograph */
  {"\xAB", 0, 0x214C22}, /* East Asian ideograph */
  {"\xAD", 0, 0x214C23}, /* East Asian ideograph */
  {"\xB0", 0, 0x214C24}, /* East Asian ideograph */
  {"\xB2", 0, 0x214C25}, /* East Asian ideograph */
  {"\xB1", 0, 0x214C26}, /* East Asian ideograph */
  {"\xB3", 0, 0x214C27}, /* East Asian ideograph */
  {"\xB7", 0, 0x214C28}, /* East Asian ideograph */
  {"\xB8", 0, 0x214C29}, /* East Asian ideograph */
  {"\xBD", 0, 0x214C2A}, /* East Asian ideograph */
  {"\x85", 0, 0x225C71}, /* East Asian ideograph */
  {"\x83", 0, 0x225C77}, /* East Asian ideograph */
  {"\x87", 0, 0x225C7D}, /* East Asian ideograph */
  {"\x8E", 0, 0x225D25}, /* East Asian ideograph */
  {"\x8D", 0, 0x225D28}, /* East Asian ideograph */
  {"\x91", 0, 0x225D2C}, /* East Asian ideograph */
  {"\x8F", 0, 0x225D2D}, /* East Asian ideograph */
  {"\x92", 0, 0x225D32}, /* East Asian ideograph */
  {"\x93", 0, 0x225D33}, /* East Asian ideograph */
  {"\x97", 0, 0x225D39}, /* East Asian ideograph */
  {"\xA1", 0, 0x225D42}, /* East Asian ideograph */
  {"\xA4", 0, 0x225D44}, /* East Asian ideograph */
  {"\xAF", 0, 0x225D49}, /* East Asian ideograph */
  {"\xBA", 0, 0x225D4D}, /* East Asian ideograph */
  {"\xBF", 0, 0x225D4F}, /* East Asian ideograph */
  {"\xBE", 0, 0x225D52}, /* East Asian ideograph */
  {"\xBB", 0, 0x274C36}, /* East Asian ideograph */
  {"\xB5", 0, 0x275F55}, /* East Asian ideograph */
  {"\x9E", 0, 0x2D3730}, /* East Asian ideograph */
  {"\x86", 0, 0x2D4B72}, /* East Asian ideograph */
  {"\xAA", 0, 0x2D5833}, /* East Asian ideograph */
  {"\x96", 0, 0x2E742E}, /* East Asian ideograph */
  {"\xA3", 0, 0x454B7A}, /* East Asian ideograph */
  {"\xBC", 0, 0x696136}, /* East Asian ideograph */
  {"\x99", 0, 0x705F30}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page163 = {
  marc8r_31page163_flat, 0
};
/* PAGE 162 */
struct yaz_iconv_trie_flat marc8r_31page162_flat[] = {
  {"\x8A", 0, 0x214B6A}, /* East Asian ideograph */
  {"\x8F", 0, 0x214B6B}, /* East Asian ideograph */
  {"\x9C", 0, 0x214B6C}, /* East Asian ideograph */
  {"\xA0", 0, 0x214B6D}, /* East Asian ideograph */
  {"\xA2", 0, 0x214B6E}, /* East Asian ideograph */
  {"\xA3", 0, 0x214B6F}, /* East Asian ideograph */
  {"\xA6", 0, 0x214B70}, /* East Asian ideograph */
  {"\xB6", 0, 0x214B71}, /* East Asian ideograph */
  {"\xB7", 0, 0x214B72}, /* East Asian ideograph */
  {"\x80", 0, 0x225B7A}, /* East Asian ideograph */
  {"\x88", 0, 0x225C30}, /* East Asian ideograph */
  {"\x85", 0, 0x225C31}, /* East Asian ideograph */
  {"\x8C", 0, 0x225C32}, /* East Asian ideograph */
  {"\x96", 0, 0x225C38}, /* East Asian ideograph */
  {"\x94", 0, 0x225C3A}, /* East Asian ideograph */
  {"\x98", 0, 0x225C3D}, /* East Asian ideograph */
  {"\x9A", 0, 0x225C40}, /* East Asian ideograph */
  {"\x9B", 0, 0x225C41}, /* East Asian ideograph */
  {"\x9E", 0, 0x225C47}, /* East Asian ideograph */
  {"\xA4", 0, 0x225C50}, /* East Asian ideograph */
  {"\xA7", 0, 0x225C52}, /* East Asian ideograph */
  {"\xA9", 0, 0x225C54}, /* East Asian ideograph */
  {"\xB1", 0, 0x225C58}, /* East Asian ideograph */
  {"\xB0", 0, 0x225C5A}, /* East Asian ideograph */
  {"\xAE", 0, 0x225C5C}, /* East Asian ideograph */
  {"\xB4", 0, 0x225C61}, /* East Asian ideograph */
  {"\xB8", 0, 0x225C63}, /* East Asian ideograph */
  {"\xBB", 0, 0x225C66}, /* East Asian ideograph */
  {"\xBF", 0, 0x225C67}, /* East Asian ideograph */
  {"\xAF", 0, 0x274B74}, /* East Asian ideograph */
  {"\x92", 0, 0x285C40}, /* East Asian ideograph */
  {"\xB2", 0, 0x696126}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page162 = {
  marc8r_31page162_flat, 0
};
/* PAGE 161 */
struct yaz_iconv_trie_flat marc8r_31page161_flat[] = {
  {"\x83", 0, 0x214B5C}, /* East Asian ideograph */
  {"\x8B", 0, 0x214B62}, /* East Asian ideograph */
  {"\x9C", 0, 0x214B63}, /* East Asian ideograph (variant of EACC 4B4B63) */
  {"\xA3", 0, 0x214B64}, /* East Asian ideograph */
  {"\xA7", 0, 0x214B65}, /* East Asian ideograph */
  {"\xA9", 0, 0x214B66}, /* East Asian ideograph */
  {"\xB0", 0, 0x214B67}, /* East Asian ideograph */
  {"\xA6", 0, 0x214B68}, /* East Asian ideograph */
  {"\xBD", 0, 0x214B69}, /* East Asian ideograph */
  {"\x84", 0, 0x225A7A}, /* East Asian ideograph */
  {"\x87", 0, 0x225A7B}, /* East Asian ideograph */
  {"\x88", 0, 0x225A7E}, /* East Asian ideograph */
  {"\x89", 0, 0x225B21}, /* East Asian ideograph */
  {"\x82", 0, 0x225B27}, /* East Asian ideograph */
  {"\x8A", 0, 0x225B2A}, /* East Asian ideograph */
  {"\x86", 0, 0x225B2D}, /* East Asian ideograph */
  {"\x80", 0, 0x225B38}, /* East Asian ideograph */
  {"\x81", 0, 0x225B3C}, /* East Asian ideograph */
  {"\x85", 0, 0x225B3F}, /* East Asian ideograph */
  {"\x97", 0, 0x225B40}, /* East Asian ideograph */
  {"\x98", 0, 0x225B43}, /* East Asian ideograph */
  {"\x9A", 0, 0x225B45}, /* East Asian ideograph */
  {"\xA4", 0, 0x225B4D}, /* East Asian ideograph */
  {"\x9F", 0, 0x225B54}, /* East Asian ideograph */
  {"\x9D", 0, 0x225B55}, /* East Asian ideograph */
  {"\x8D", 0, 0x225B56}, /* East Asian ideograph */
  {"\x9E", 0, 0x225B57}, /* East Asian ideograph */
  {"\xA0", 0, 0x225B59}, /* East Asian ideograph */
  {"\xA1", 0, 0x225B5D}, /* East Asian ideograph */
  {"\xB2", 0, 0x225B60}, /* East Asian ideograph */
  {"\xB1", 0, 0x225B61}, /* East Asian ideograph */
  {"\xB4", 0, 0x225B66}, /* East Asian ideograph */
  {"\xAB", 0, 0x225B67}, /* East Asian ideograph */
  {"\xAA", 0, 0x225B69}, /* East Asian ideograph */
  {"\x90", 0, 0x225B6A}, /* East Asian ideograph */
  {"\xA5", 0, 0x225B6C}, /* East Asian ideograph */
  {"\xA8", 0, 0x225B6E}, /* East Asian ideograph */
  {"\xB8", 0, 0x225B76}, /* East Asian ideograph */
  {"\xBF", 0, 0x225C25}, /* East Asian ideograph */
  {"\xB5", 0, 0x225C28}, /* East Asian ideograph */
  {"\xBA", 0, 0x225C29}, /* East Asian ideograph */
  {"\x8E", 0, 0x285C3A}, /* East Asian ideograph */
  {"\xA2", 0, 0x2E5A78}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page161 = {
  marc8r_31page161_flat, 0
};
/* PAGE 160 */
struct yaz_iconv_trie_flat marc8r_31page160_flat[] = {
  {"\x95", 0, 0x214B53}, /* East Asian ideograph */
  {"\x9F", 0, 0x214B54}, /* East Asian ideograph */
  {"\x9A", 0, 0x214B55}, /* East Asian ideograph */
  {"\x81", 0, 0x214B56}, /* East Asian ideograph */
  {"\x9B", 0, 0x214B58}, /* East Asian ideograph */
  {"\x9E", 0, 0x214B59}, /* East Asian ideograph */
  {"\x9C", 0, 0x214B5A}, /* East Asian ideograph */
  {"\x99", 0, 0x214B5B}, /* East Asian ideograph */
  {"\xA9", 0, 0x214B5D}, /* East Asian ideograph */
  {"\xAA", 0, 0x214B5E}, /* East Asian ideograph */
  {"\xA3", 0, 0x214B5F}, /* East Asian ideograph */
  {"\xA4", 0, 0x214B60}, /* East Asian ideograph */
  {"\xB0", 0, 0x214B61}, /* East Asian ideograph */
  {"\x84", 0, 0x225A36}, /* East Asian ideograph */
  {"\x87", 0, 0x225A40}, /* East Asian ideograph */
  {"\x98", 0, 0x225A43}, /* East Asian ideograph */
  {"\x82", 0, 0x225A45}, /* East Asian ideograph */
  {"\x8B", 0, 0x225A47}, /* East Asian ideograph */
  {"\x8A", 0, 0x225A4A}, /* East Asian ideograph */
  {"\x92", 0, 0x225A4F}, /* East Asian ideograph */
  {"\x97", 0, 0x225A55}, /* East Asian ideograph */
  {"\x91", 0, 0x225A56}, /* East Asian ideograph */
  {"\x9D", 0, 0x225A5A}, /* East Asian ideograph */
  {"\x94", 0, 0x225A5B}, /* East Asian ideograph */
  {"\x80", 0, 0x225A5D}, /* East Asian ideograph */
  {"\xAD", 0, 0x225A60}, /* East Asian ideograph */
  {"\xA2", 0, 0x225A61}, /* East Asian ideograph */
  {"\xB3", 0, 0x225A62}, /* East Asian ideograph */
  {"\xB4", 0, 0x225A68}, /* East Asian ideograph */
  {"\xAE", 0, 0x225A69}, /* East Asian ideograph */
  {"\xB1", 0, 0x225A6A}, /* East Asian ideograph */
  {"\xA8", 0, 0x225A6B}, /* East Asian ideograph */
  {"\xA0", 0, 0x225A78}, /* East Asian ideograph */
  {"\xB2", 0, 0x225A79}, /* East Asian ideograph */
  {"\xBC", 0, 0x225B22}, /* East Asian ideograph */
  {"\xBE", 0, 0x225B28}, /* East Asian ideograph */
  {"\xBA", 0, 0x225B30}, /* East Asian ideograph */
  {"\xBD", 0, 0x225B3E}, /* East Asian ideograph */
  {"\xB7", 0, 0x274B68}, /* East Asian ideograph */
  {"\xAF", 0, 0x2D4B43}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page160 = {
  marc8r_31page160_flat, 0
};
/* PAGE 159 */
struct yaz_iconv_trie_flat marc8r_31page159_flat[] = {
  {"\x85", 0, 0x214B43}, /* East Asian ideograph */
  {"\x89", 0, 0x214B44}, /* East Asian ideograph */
  {"\x83", 0, 0x214B45}, /* East Asian ideograph */
  {"\x8A", 0, 0x214B46}, /* East Asian ideograph */
  {"\x86", 0, 0x214B48}, /* East Asian ideograph */
  {"\x8D", 0, 0x214B49}, /* East Asian ideograph */
  {"\xBA", 0, 0x214B4A}, /* East Asian ideograph */
  {"\xB5", 0, 0x214B4B}, /* East Asian ideograph */
  {"\xB6", 0, 0x214B4C}, /* East Asian ideograph */
  {"\xB4", 0, 0x214B4D}, /* East Asian ideograph */
  {"\xAA", 0, 0x214B4E}, /* East Asian ideograph */
  {"\xB3", 0, 0x214B4F}, /* East Asian ideograph */
  {"\xA2", 0, 0x214B50}, /* East Asian ideograph */
  {"\xA5", 0, 0x214B51}, /* East Asian ideograph */
  {"\xBF", 0, 0x214B57}, /* East Asian ideograph */
  {"\xB9", 0, 0x223D66}, /* East Asian ideograph */
  {"\x87", 0, 0x22595C}, /* East Asian ideograph */
  {"\x92", 0, 0x22595E}, /* East Asian ideograph */
  {"\xBC", 0, 0x225963}, /* East Asian ideograph */
  {"\xAE", 0, 0x225966}, /* East Asian ideograph */
  {"\xAF", 0, 0x225967}, /* East Asian ideograph */
  {"\x94", 0, 0x225969}, /* East Asian ideograph */
  {"\xAC", 0, 0x22596A}, /* East Asian ideograph */
  {"\xB0", 0, 0x22596C}, /* East Asian ideograph */
  {"\xAB", 0, 0x22596E}, /* East Asian ideograph */
  {"\x9A", 0, 0x225971}, /* East Asian ideograph */
  {"\x96", 0, 0x225978}, /* East Asian ideograph */
  {"\xA6", 0, 0x22597A}, /* East Asian ideograph */
  {"\xA8", 0, 0x225A21}, /* East Asian ideograph */
  {"\xA9", 0, 0x225A23}, /* East Asian ideograph */
  {"\xA0", 0, 0x225A28}, /* East Asian ideograph */
  {"\x9B", 0, 0x225A2A}, /* East Asian ideograph */
  {"\xA4", 0, 0x225A2B}, /* East Asian ideograph */
  {"\xB2", 0, 0x225A2C}, /* East Asian ideograph */
  {"\xAD", 0, 0x225A2D}, /* East Asian ideograph */
  {"\x95", 0, 0x225A30}, /* East Asian ideograph */
  {"\xBB", 0, 0x225A32}, /* East Asian ideograph */
  {"\x90", 0, 0x274B5F}, /* East Asian ideograph */
  {"\x8F", 0, 0x285B21}, /* East Asian ideograph */
  {"\xB1", 0, 0x3F5F49}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page159 = {
  marc8r_31page159_flat, 0
};
/* PAGE 158 */
struct yaz_iconv_trie_flat marc8r_31page158_flat[] = {
  {"\x8A", 0, 0x214B3A}, /* East Asian ideograph */
  {"\x80", 0, 0x214B3C}, /* East Asian ideograph */
  {"\x8D", 0, 0x214B3F}, /* East Asian ideograph */
  {"\xAD", 0, 0x214B40}, /* East Asian ideograph */
  {"\xAE", 0, 0x214B41}, /* East Asian ideograph */
  {"\xA0", 0, 0x214B42}, /* East Asian ideograph */
  {"\xBE", 0, 0x214B47}, /* East Asian ideograph */
  {"\x8F", 0, 0x225868}, /* East Asian ideograph */
  {"\x82", 0, 0x22586A}, /* East Asian ideograph */
  {"\x90", 0, 0x22586B}, /* East Asian ideograph */
  {"\x88", 0, 0x225870}, /* East Asian ideograph */
  {"\x8C", 0, 0x22587D}, /* East Asian ideograph */
  {"\x93", 0, 0x225921}, /* East Asian ideograph */
  {"\xAA", 0, 0x225927}, /* East Asian ideograph */
  {"\xA5", 0, 0x225928}, /* East Asian ideograph */
  {"\x99", 0, 0x22592A}, /* East Asian ideograph */
  {"\xAF", 0, 0x22592B}, /* East Asian ideograph */
  {"\x94", 0, 0x22592F}, /* East Asian ideograph */
  {"\x9B", 0, 0x225930}, /* East Asian ideograph */
  {"\x96", 0, 0x225932}, /* East Asian ideograph */
  {"\xA7", 0, 0x225936}, /* East Asian ideograph */
  {"\xA3", 0, 0x225938}, /* East Asian ideograph */
  {"\x9E", 0, 0x22593A}, /* East Asian ideograph */
  {"\xA6", 0, 0x22593C}, /* East Asian ideograph */
  {"\xA9", 0, 0x22593F}, /* East Asian ideograph */
  {"\xB6", 0, 0x225945}, /* East Asian ideograph */
  {"\xBA", 0, 0x225947}, /* East Asian ideograph */
  {"\xB8", 0, 0x22594A}, /* East Asian ideograph */
  {"\xB5", 0, 0x225954}, /* East Asian ideograph */
  {"\xBD", 0, 0x22595A}, /* East Asian ideograph */
  {"\xB7", 0, 0x225970}, /* East Asian ideograph */
  {"\xB2", 0, 0x274B57}, /* East Asian ideograph */
  {"\x91", 0, 0x274B6B}, /* East Asian ideograph */
  {"\x89", 0, 0x2D4B35}, /* East Asian ideograph */
  {"\x8E", 0, 0x2D4B3F}, /* East Asian ideograph */
  {"\xB1", 0, 0x4C5C3A}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page158 = {
  marc8r_31page158_flat, 0
};
/* PAGE 157 */
struct yaz_iconv_trie_flat marc8r_31page157_flat[] = {
  {"\x80", 0, 0x214B2F}, /* East Asian ideograph */
  {"\x84", 0, 0x214B30}, /* East Asian ideograph */
  {"\x87", 0, 0x214B31}, /* East Asian ideograph */
  {"\x89", 0, 0x214B32}, /* East Asian ideograph */
  {"\x8B", 0, 0x214B33}, /* East Asian ideograph */
  {"\x96", 0, 0x214B34}, /* East Asian ideograph */
  {"\x9F", 0, 0x214B35}, /* East Asian ideograph */
  {"\xA8", 0, 0x214B36}, /* East Asian ideograph */
  {"\xA9", 0, 0x214B37}, /* East Asian ideograph */
  {"\xAB", 0, 0x214B38}, /* East Asian ideograph */
  {"\xBB", 0, 0x214B39}, /* East Asian ideograph */
  {"\xB7", 0, 0x214B3B}, /* East Asian ideograph */
  {"\xB2", 0, 0x214B3E}, /* East Asian ideograph */
  {"\x8D", 0, 0x216437}, /* East Asian ideograph */
  {"\x81", 0, 0x22583B}, /* East Asian ideograph */
  {"\x88", 0, 0x22583F}, /* East Asian ideograph */
  {"\x8E", 0, 0x225842}, /* East Asian ideograph */
  {"\x95", 0, 0x225846}, /* East Asian ideograph */
  {"\x92", 0, 0x225847}, /* East Asian ideograph */
  {"\x97", 0, 0x225848}, /* East Asian ideograph */
  {"\x93", 0, 0x22584C}, /* East Asian ideograph */
  {"\x94", 0, 0x22584D}, /* East Asian ideograph */
  {"\x9E", 0, 0x225851}, /* East Asian ideograph */
  {"\xA6", 0, 0x225852}, /* East Asian ideograph */
  {"\xA5", 0, 0x22585D}, /* East Asian ideograph */
  {"\xA2", 0, 0x225862}, /* East Asian ideograph */
  {"\xA0", 0, 0x225863}, /* East Asian ideograph */
  {"\xB6", 0, 0x225867}, /* East Asian ideograph */
  {"\xBF", 0, 0x22586F}, /* East Asian ideograph */
  {"\xBC", 0, 0x225935}, /* East Asian ideograph */
  {"\xB0", 0, 0x274B47}, /* East Asian ideograph */
  {"\x9B", 0, 0x274B5E}, /* East Asian ideograph */
  {"\x91", 0, 0x274B64}, /* East Asian ideograph */
  {"\xAF", 0, 0x274B67}, /* East Asian ideograph */
  {"\xBA", 0, 0x274B69}, /* East Asian ideograph */
  {"\xAE", 0, 0x285A47}, /* East Asian ideograph */
  {"\x85", 0, 0x2D3954}, /* East Asian ideograph */
  {"\xB3", 0, 0x2E5A40}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page157 = {
  marc8r_31page157_flat, 0
};
/* PAGE 156 */
struct yaz_iconv_trie_flat marc8r_31page156_flat[] = {
  {"\x84", 0, 0x214A7E}, /* East Asian ideograph */
  {"\x85", 0, 0x214B23}, /* East Asian ideograph */
  {"\x90", 0, 0x214B24}, /* East Asian ideograph */
  {"\x97", 0, 0x214B26}, /* East Asian ideograph */
  {"\xA8", 0, 0x214B27}, /* East Asian ideograph */
  {"\xB0", 0, 0x214B28}, /* East Asian ideograph */
  {"\xB2", 0, 0x214B29}, /* East Asian ideograph */
  {"\xB7", 0, 0x214B2A}, /* East Asian ideograph */
  {"\xB8", 0, 0x214B2B}, /* East Asian ideograph */
  {"\xB5", 0, 0x214B2C}, /* East Asian ideograph */
  {"\xBA", 0, 0x214B2D}, /* East Asian ideograph */
  {"\xBB", 0, 0x214B2E}, /* East Asian ideograph */
  {"\x87", 0, 0x22575A}, /* East Asian ideograph */
  {"\x88", 0, 0x22575B}, /* East Asian ideograph */
  {"\x89", 0, 0x22575C}, /* East Asian ideograph */
  {"\x80", 0, 0x225765}, /* East Asian ideograph */
  {"\x8D", 0, 0x225768}, /* East Asian ideograph */
  {"\x92", 0, 0x22576B}, /* East Asian ideograph */
  {"\x9E", 0, 0x225772}, /* East Asian ideograph */
  {"\x9D", 0, 0x225774}, /* East Asian ideograph */
  {"\xA0", 0, 0x225779}, /* East Asian ideograph */
  {"\x98", 0, 0x22577B}, /* East Asian ideograph */
  {"\xA2", 0, 0x22577E}, /* East Asian ideograph */
  {"\x8B", 0, 0x225821}, /* East Asian ideograph */
  {"\xA7", 0, 0x225825}, /* East Asian ideograph */
  {"\xAC", 0, 0x225829}, /* East Asian ideograph */
  {"\xAB", 0, 0x22582B}, /* East Asian ideograph */
  {"\xAF", 0, 0x22582F}, /* East Asian ideograph */
  {"\xBC", 0, 0x225836}, /* East Asian ideograph */
  {"\xBE", 0, 0x225838}, /* East Asian ideograph */
  {"\xAD", 0, 0x274B2D}, /* East Asian ideograph */
  {"\x83", 0, 0x2D3556}, /* East Asian ideograph */
  {"\xAA", 0, 0x2D4B22}, /* East Asian ideograph */
  {"\xA3", 0, 0x4B4B2B}, /* East Asian ideograph */
  {"\x8F", 0, 0x4B5963}, /* East Asian ideograph */
  {"\x8E", 0, 0x517954}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page156 = {
  marc8r_31page156_flat, 0
};
/* PAGE 155 */
struct yaz_iconv_trie_flat marc8r_31page155_flat[] = {
  {"\x9C", 0, 0x214A74}, /* East Asian ideograph */
  {"\x9B", 0, 0x214A75}, /* East Asian ideograph */
  {"\x93", 0, 0x214A76}, /* East Asian ideograph */
  {"\x96", 0, 0x214A77}, /* East Asian ideograph */
  {"\x99", 0, 0x214A78}, /* East Asian ideograph */
  {"\xB6", 0, 0x214A79}, /* East Asian ideograph */
  {"\xB7", 0, 0x214A7A}, /* East Asian ideograph */
  {"\xA9", 0, 0x214A7B}, /* East Asian ideograph */
  {"\xA5", 0, 0x214A7C}, /* East Asian ideograph */
  {"\xB4", 0, 0x214A7D}, /* East Asian ideograph */
  {"\xBF", 0, 0x214B21}, /* East Asian ideograph */
  {"\xBE", 0, 0x214B22}, /* East Asian ideograph */
  {"\x82", 0, 0x225729}, /* East Asian ideograph */
  {"\x81", 0, 0x22572D}, /* East Asian ideograph */
  {"\x9D", 0, 0x225731}, /* East Asian ideograph */
  {"\x8B", 0, 0x225735}, /* East Asian ideograph */
  {"\x97", 0, 0x225736}, /* East Asian ideograph */
  {"\x87", 0, 0x22573B}, /* East Asian ideograph */
  {"\x98", 0, 0x22573E}, /* East Asian ideograph */
  {"\x9E", 0, 0x225742}, /* East Asian ideograph */
  {"\xB1", 0, 0x225746}, /* East Asian ideograph */
  {"\xB8", 0, 0x225749}, /* East Asian ideograph */
  {"\xA2", 0, 0x22574A}, /* East Asian ideograph */
  {"\xB2", 0, 0x22574C}, /* East Asian ideograph */
  {"\xAC", 0, 0x22574D}, /* East Asian ideograph */
  {"\xA7", 0, 0x22574E}, /* East Asian ideograph */
  {"\xAB", 0, 0x22574F}, /* East Asian ideograph */
  {"\xAF", 0, 0x225752}, /* East Asian ideograph */
  {"\xA8", 0, 0x225755}, /* East Asian ideograph */
  {"\xBB", 0, 0x22575F}, /* East Asian ideograph */
  {"\xBA", 0, 0x225762}, /* East Asian ideograph */
  {"\x8E", 0, 0x274B2C}, /* East Asian ideograph */
  {"\xAE", 0, 0x274B2E}, /* East Asian ideograph */
  {"\xA1", 0, 0x274B2F}, /* East Asian ideograph */
  {"\x83", 0, 0x28582B}, /* East Asian ideograph */
  {"\x95", 0, 0x285836}, /* East Asian ideograph */
  {"\xAA", 0, 0x2D595F}, /* East Asian ideograph */
  {"\x8A", 0, 0x2F5D5C}, /* East Asian ideograph */
  {"\x9F", 0, 0x4B4B2C}, /* East Asian ideograph */
  {"\xB9", 0, 0x70622A}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page155 = {
  marc8r_31page155_flat, 0
};
/* PAGE 154 */
struct yaz_iconv_trie_flat marc8r_31page154_flat[] = {
  {"\x84", 0, 0x214A65}, /* East Asian ideograph */
  {"\x82", 0, 0x214A66}, /* East Asian ideograph */
  {"\x99", 0, 0x214A67}, /* East Asian ideograph */
  {"\x80", 0, 0x214A68}, /* East Asian ideograph */
  {"\x8E", 0, 0x214A69}, /* East Asian ideograph */
  {"\x97", 0, 0x214A6A}, /* East Asian ideograph */
  {"\x90", 0, 0x214A6B}, /* East Asian ideograph */
  {"\xA1", 0, 0x214A6C}, /* East Asian ideograph */
  {"\xA9", 0, 0x214A6D}, /* East Asian ideograph */
  {"\xA0", 0, 0x214A6E}, /* East Asian ideograph */
  {"\xBC", 0, 0x214A6F}, /* East Asian ideograph */
  {"\xB9", 0, 0x214A70}, /* East Asian ideograph */
  {"\xBD", 0, 0x214A72}, /* East Asian ideograph */
  {"\xB7", 0, 0x214A73}, /* East Asian ideograph */
  {"\x86", 0, 0x225651}, /* East Asian ideograph */
  {"\x83", 0, 0x225658}, /* East Asian ideograph */
  {"\x81", 0, 0x22565B}, /* East Asian ideograph */
  {"\x96", 0, 0x225660}, /* East Asian ideograph */
  {"\x92", 0, 0x225664}, /* East Asian ideograph */
  {"\x89", 0, 0x225667}, /* East Asian ideograph */
  {"\x8C", 0, 0x22566C}, /* East Asian ideograph */
  {"\x9B", 0, 0x22566E}, /* East Asian ideograph */
  {"\x8D", 0, 0x22566F}, /* East Asian ideograph */
  {"\xA8", 0, 0x225673}, /* East Asian ideograph */
  {"\xAB", 0, 0x225676}, /* East Asian ideograph */
  {"\xA5", 0, 0x225679}, /* East Asian ideograph */
  {"\xBA", 0, 0x22567E}, /* East Asian ideograph */
  {"\xB4", 0, 0x225724}, /* East Asian ideograph */
  {"\xBE", 0, 0x225725}, /* East Asian ideograph */
  {"\xBB", 0, 0x22572C}, /* East Asian ideograph */
  {"\xB3", 0, 0x22572E}, /* East Asian ideograph */
  {"\xAD", 0, 0x274A70}, /* East Asian ideograph */
  {"\x88", 0, 0x274A72}, /* East Asian ideograph */
  {"\xB1", 0, 0x274A7E}, /* East Asian ideograph */
  {"\xAF", 0, 0x274B22}, /* East Asian ideograph */
  {"\xAE", 0, 0x274B23}, /* East Asian ideograph */
  {"\xAC", 0, 0x274B27}, /* East Asian ideograph */
  {"\x9E", 0, 0x274B28}, /* East Asian ideograph */
  {"\xB2", 0, 0x28575F}, /* East Asian ideograph */
  {"\xB8", 0, 0x2D5965}, /* East Asian ideograph */
  {"\xB0", 0, 0x4B4A78}, /* East Asian ideograph */
  {"\xA2", 0, 0x4B5964}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page154 = {
  marc8r_31page154_flat, 0
};
/* PAGE 153 */
struct yaz_iconv_trie_flat marc8r_31page153_flat[] = {
  {"\x81", 0, 0x214A5B}, /* East Asian ideograph */
  {"\x80", 0, 0x214A5C}, /* East Asian ideograph */
  {"\x84", 0, 0x214A5D}, /* East Asian ideograph */
  {"\x96", 0, 0x214A5E}, /* East Asian ideograph */
  {"\x92", 0, 0x214A5F}, /* East Asian ideograph */
  {"\x9B", 0, 0x214A60}, /* East Asian ideograph */
  {"\xA2", 0, 0x214A61}, /* East Asian ideograph */
  {"\xA7", 0, 0x214A62}, /* East Asian ideograph */
  {"\xAC", 0, 0x214A63}, /* East Asian ideograph */
  {"\xAF", 0, 0x214A64}, /* East Asian ideograph */
  {"\x89", 0, 0x225574}, /* East Asian ideograph */
  {"\x8B", 0, 0x22557C}, /* East Asian ideograph */
  {"\x8D", 0, 0x225622}, /* East Asian ideograph */
  {"\x8F", 0, 0x225628}, /* East Asian ideograph */
  {"\xA8", 0, 0x225648}, /* East Asian ideograph */
  {"\xAB", 0, 0x22564C}, /* East Asian ideograph */
  {"\xB0", 0, 0x22564E}, /* East Asian ideograph */
  {"\xB4", 0, 0x22564F}, /* East Asian ideograph */
  {"\xB5", 0, 0x225652}, /* East Asian ideograph */
  {"\xBC", 0, 0x225656}, /* East Asian ideograph */
  {"\x8A", 0, 0x274A61}, /* East Asian ideograph */
  {"\xB6", 0, 0x274A68}, /* East Asian ideograph */
  {"\xB9", 0, 0x274A79}, /* East Asian ideograph */
  {"\xB7", 0, 0x274B2A}, /* East Asian ideograph */
  {"\xB8", 0, 0x28575E}, /* East Asian ideograph */
  {"\x87", 0, 0x2D392F}, /* East Asian ideograph */
  {"\x82", 0, 0x2D4A5B}, /* East Asian ideograph */
  {"\xB2", 0, 0x2D5960}, /* East Asian ideograph */
  {"\xA0", 0, 0x4B4A62}, /* East Asian ideograph */
  {"\x9F", 0, 0x4C5638}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page153 = {
  marc8r_31page153_flat, 0
};
/* PAGE 152 */
struct yaz_iconv_trie_flat marc8r_31page152_flat[] = {
  {"\x86", 0, 0x214A46}, /* East Asian ideograph */
  {"\x87", 0, 0x214A47}, /* East Asian ideograph */
  {"\x88", 0, 0x214A48}, /* East Asian ideograph */
  {"\x8C", 0, 0x214A49}, /* East Asian ideograph */
  {"\x92", 0, 0x214A4A}, /* East Asian ideograph */
  {"\x96", 0, 0x214A4B}, /* East Asian ideograph */
  {"\x98", 0, 0x214A4C}, /* East Asian ideograph */
  {"\x99", 0, 0x214A4D}, /* East Asian ideograph */
  {"\x9B", 0, 0x214A4E}, /* East Asian ideograph */
  {"\x9F", 0, 0x214A4F}, /* East Asian ideograph */
  {"\x9D", 0, 0x214A50}, /* East Asian ideograph */
  {"\xA2", 0, 0x214A51}, /* East Asian ideograph */
  {"\xA1", 0, 0x214A52}, /* East Asian ideograph */
  {"\xA0", 0, 0x214A53}, /* East Asian ideograph */
  {"\xA7", 0, 0x214A54}, /* East Asian ideograph */
  {"\xA9", 0, 0x214A55}, /* East Asian ideograph */
  {"\xAF", 0, 0x214A56}, /* East Asian ideograph */
  {"\xB2", 0, 0x214A57}, /* East Asian ideograph */
  {"\xB4", 0, 0x214A58}, /* East Asian ideograph */
  {"\xB9", 0, 0x214A59}, /* East Asian ideograph */
  {"\xBD", 0, 0x214A5A}, /* East Asian ideograph */
  {"\x81", 0, 0x225543}, /* East Asian ideograph */
  {"\x82", 0, 0x225544}, /* East Asian ideograph */
  {"\x90", 0, 0x22554F}, /* East Asian ideograph */
  {"\x8F", 0, 0x225551}, /* East Asian ideograph */
  {"\x93", 0, 0x225552}, /* East Asian ideograph */
  {"\x95", 0, 0x225553}, /* East Asian ideograph */
  {"\x9A", 0, 0x225556}, /* East Asian ideograph */
  {"\xA3", 0, 0x225559}, /* East Asian ideograph */
  {"\xB3", 0, 0x225561}, /* East Asian ideograph */
  {"\xAE", 0, 0x225563}, /* East Asian ideograph */
  {"\xB6", 0, 0x225566}, /* East Asian ideograph */
  {"\xB7", 0, 0x225568}, /* East Asian ideograph */
  {"\xBE", 0, 0x22556B}, /* East Asian ideograph */
  {"\xBC", 0, 0x22556D}, /* East Asian ideograph */
  {"\xBF", 0, 0x225571}, /* East Asian ideograph */
  {"\x8D", 0, 0x274A4C}, /* East Asian ideograph */
  {"\xB5", 0, 0x274A5A}, /* East Asian ideograph */
  {"\xBA", 0, 0x274A62}, /* East Asian ideograph */
  {"\x80", 0, 0x2D3C6E}, /* East Asian ideograph */
  {"\x8B", 0, 0x33502B}, /* East Asian ideograph */
  {"\xA6", 0, 0x3F4A60}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page152 = {
  marc8r_31page152_flat, 0
};
/* PAGE 151 */
struct yaz_iconv_trie_flat marc8r_31page151_flat[] = {
  {"\x86", 0, 0x214A35}, /* East Asian ideograph */
  {"\x8D", 0, 0x214A36}, /* East Asian ideograph */
  {"\x90", 0, 0x214A37}, /* East Asian ideograph */
  {"\x9B", 0, 0x214A38}, /* East Asian ideograph */
  {"\xA8", 0, 0x214A39}, /* East Asian ideograph */
  {"\xAA", 0, 0x214A3A}, /* East Asian ideograph */
  {"\xAD", 0, 0x214A3B}, /* East Asian ideograph */
  {"\xAC", 0, 0x214A3C}, /* East Asian ideograph */
  {"\xB0", 0, 0x214A3D}, /* East Asian ideograph */
  {"\xB5", 0, 0x214A3E}, /* East Asian ideograph (variant of EACC 4B4A3E) */
  {"\xB6", 0, 0x214A3F}, /* East Asian ideograph */
  {"\xB8", 0, 0x214A40}, /* East Asian ideograph */
  {"\xB9", 0, 0x214A41}, /* East Asian ideograph */
  {"\xBA", 0, 0x214A42}, /* East Asian ideograph */
  {"\xBB", 0, 0x214A43}, /* East Asian ideograph */
  {"\xBD", 0, 0x214A44}, /* East Asian ideograph */
  {"\xBE", 0, 0x214A45}, /* East Asian ideograph */
  {"\x8C", 0, 0x22544B}, /* East Asian ideograph */
  {"\x8E", 0, 0x22545B}, /* East Asian ideograph */
  {"\x8A", 0, 0x22545E}, /* East Asian ideograph */
  {"\x97", 0, 0x225460}, /* East Asian ideograph */
  {"\x87", 0, 0x225461}, /* East Asian ideograph */
  {"\x95", 0, 0x225466}, /* East Asian ideograph */
  {"\x93", 0, 0x225469}, /* East Asian ideograph */
  {"\x98", 0, 0x22546E}, /* East Asian ideograph */
  {"\x8B", 0, 0x225471}, /* East Asian ideograph */
  {"\x9A", 0, 0x225479}, /* East Asian ideograph */
  {"\x9F", 0, 0x22547D}, /* East Asian ideograph */
  {"\x9D", 0, 0x225521}, /* East Asian ideograph */
  {"\xA5", 0, 0x225529}, /* East Asian ideograph */
  {"\xA6", 0, 0x22552A}, /* East Asian ideograph */
  {"\xBF", 0, 0x225541}, /* East Asian ideograph */
  {"\xB1", 0, 0x273E77}, /* East Asian ideograph */
  {"\xB7", 0, 0x274A42}, /* East Asian ideograph */
  {"\xBC", 0, 0x4B316A}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page151 = {
  marc8r_31page151_flat, 0
};
/* PAGE 150 */
struct yaz_iconv_trie_flat marc8r_31page150_flat[] = {
  {"\x99", 0, 0x21497E}, /* East Asian ideograph */
  {"\x89", 0, 0x214A22}, /* East Asian ideograph */
  {"\x90", 0, 0x214A23}, /* East Asian ideograph */
  {"\x88", 0, 0x214A24}, /* East Asian ideograph */
  {"\x9C", 0, 0x214A25}, /* East Asian ideograph */
  {"\x92", 0, 0x214A26}, /* East Asian ideograph */
  {"\x95", 0, 0x214A28}, /* East Asian ideograph */
  {"\x8E", 0, 0x214A29}, /* East Asian ideograph */
  {"\x83", 0, 0x214A2A}, /* East Asian ideograph */
  {"\x84", 0, 0x214A2B}, /* East Asian ideograph */
  {"\xAE", 0, 0x214A2C}, /* East Asian ideograph */
  {"\xA7", 0, 0x214A2D}, /* East Asian ideograph */
  {"\x9F", 0, 0x214A2E}, /* East Asian ideograph */
  {"\xA5", 0, 0x214A2F}, /* East Asian ideograph */
  {"\xAD", 0, 0x214A30}, /* East Asian ideograph */
  {"\xA6", 0, 0x214A31}, /* East Asian ideograph */
  {"\xAC", 0, 0x214A32}, /* East Asian ideograph */
  {"\xB4", 0, 0x214A33}, /* East Asian ideograph */
  {"\xBB", 0, 0x214A34}, /* East Asian ideograph */
  {"\x91", 0, 0x225367}, /* East Asian ideograph */
  {"\x87", 0, 0x225369}, /* East Asian ideograph */
  {"\x8A", 0, 0x22536D}, /* East Asian ideograph */
  {"\x8F", 0, 0x22536F}, /* East Asian ideograph */
  {"\x96", 0, 0x225370}, /* East Asian ideograph */
  {"\x82", 0, 0x225375}, /* East Asian ideograph */
  {"\x85", 0, 0x225377}, /* East Asian ideograph */
  {"\x9D", 0, 0x225421}, /* East Asian ideograph */
  {"\x80", 0, 0x225422}, /* East Asian ideograph */
  {"\x81", 0, 0x225424}, /* East Asian ideograph */
  {"\x94", 0, 0x225426}, /* East Asian ideograph */
  {"\x8B", 0, 0x225429}, /* East Asian ideograph */
  {"\x9E", 0, 0x22542A}, /* East Asian ideograph */
  {"\xAB", 0, 0x225432}, /* East Asian ideograph */
  {"\xA8", 0, 0x225436}, /* East Asian ideograph */
  {"\xB5", 0, 0x22543A}, /* East Asian ideograph */
  {"\xB3", 0, 0x22543D}, /* East Asian ideograph */
  {"\xA1", 0, 0x22543F}, /* East Asian ideograph */
  {"\xA0", 0, 0x225447}, /* East Asian ideograph */
  {"\xBC", 0, 0x22544F}, /* East Asian ideograph */
  {"\xB9", 0, 0x225456}, /* East Asian ideograph */
  {"\xBE", 0, 0x2E5452}, /* East Asian ideograph */
  {"\xBF", 0, 0x33525B}, /* East Asian ideograph */
  {"\x97", 0, 0x4B4A38}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page150 = {
  marc8r_31page150_flat, 0
};
/* PAGE 149 */
struct yaz_iconv_trie_flat marc8r_31page149_flat[] = {
  {"\x99", 0, 0x214977}, /* East Asian ideograph */
  {"\x8A", 0, 0x214978}, /* East Asian ideograph */
  {"\x84", 0, 0x214979}, /* East Asian ideograph */
  {"\x9F", 0, 0x21497A}, /* East Asian ideograph */
  {"\xA8", 0, 0x21497B}, /* East Asian ideograph */
  {"\xAC", 0, 0x21497C}, /* East Asian ideograph */
  {"\xB1", 0, 0x21497D}, /* East Asian ideograph */
  {"\xBE", 0, 0x214A21}, /* East Asian ideograph */
  {"\xB9", 0, 0x214A27}, /* East Asian ideograph */
  {"\x87", 0, 0x22527B}, /* East Asian ideograph */
  {"\x92", 0, 0x225323}, /* East Asian ideograph */
  {"\x80", 0, 0x22532B}, /* East Asian ideograph */
  {"\x89", 0, 0x22532C}, /* East Asian ideograph */
  {"\x85", 0, 0x225332}, /* East Asian ideograph */
  {"\x96", 0, 0x225333}, /* East Asian ideograph */
  {"\x98", 0, 0x225339}, /* East Asian ideograph */
  {"\x97", 0, 0x22533C}, /* East Asian ideograph */
  {"\xB5", 0, 0x22533E}, /* East Asian ideograph */
  {"\xA9", 0, 0x22533F}, /* East Asian ideograph */
  {"\xA5", 0, 0x225342}, /* East Asian ideograph */
  {"\x9E", 0, 0x225346}, /* East Asian ideograph */
  {"\xB2", 0, 0x225347}, /* East Asian ideograph */
  {"\x9B", 0, 0x22534A}, /* East Asian ideograph */
  {"\xAF", 0, 0x22534E}, /* East Asian ideograph */
  {"\xA4", 0, 0x225351}, /* East Asian ideograph */
  {"\xA0", 0, 0x225352}, /* East Asian ideograph */
  {"\x9A", 0, 0x225355}, /* East Asian ideograph */
  {"\xB3", 0, 0x225357}, /* East Asian ideograph */
  {"\xB4", 0, 0x225359}, /* East Asian ideograph */
  {"\xB7", 0, 0x22536A}, /* East Asian ideograph */
  {"\xBA", 0, 0x225372}, /* East Asian ideograph */
  {"\xBF", 0, 0x22537A}, /* East Asian ideograph */
  {"\xB8", 0, 0x22537C}, /* East Asian ideograph */
  {"\x8F", 0, 0x2D4A34}, /* East Asian ideograph */
  {"\x94", 0, 0x2D5E26}, /* East Asian ideograph */
  {"\x88", 0, 0x4B4977}, /* East Asian ideograph */
  {"\x95", 0, 0x695F70}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page149 = {
  marc8r_31page149_flat, 0
};
/* PAGE 148 */
struct yaz_iconv_trie_flat marc8r_31page148_flat[] = {
  {"\xAE", 0, 0x214963}, /* East Asian ideograph */
  {"\x8E", 0, 0x214969}, /* East Asian ideograph */
  {"\x89", 0, 0x21496A}, /* East Asian ideograph */
  {"\x99", 0, 0x21496B}, /* East Asian ideograph */
  {"\xA4", 0, 0x21496C}, /* East Asian ideograph */
  {"\xA9", 0, 0x21496D}, /* East Asian ideograph */
  {"\x9C", 0, 0x21496E}, /* East Asian ideograph */
  {"\xAC", 0, 0x21496F}, /* East Asian ideograph */
  {"\xA6", 0, 0x214970}, /* East Asian ideograph */
  {"\xA7", 0, 0x214971}, /* East Asian ideograph */
  {"\x9E", 0, 0x214972}, /* East Asian ideograph */
  {"\xA5", 0, 0x214973}, /* East Asian ideograph */
  {"\x8C", 0, 0x214974}, /* East Asian ideograph */
  {"\xBD", 0, 0x214975}, /* East Asian ideograph */
  {"\xB7", 0, 0x225248}, /* East Asian ideograph */
  {"\x86", 0, 0x225251}, /* East Asian ideograph */
  {"\x92", 0, 0x225252}, /* East Asian ideograph */
  {"\x8F", 0, 0x225254}, /* East Asian ideograph */
  {"\x9D", 0, 0x225255}, /* East Asian ideograph */
  {"\x81", 0, 0x225256}, /* East Asian ideograph */
  {"\xA0", 0, 0x225257}, /* East Asian ideograph */
  {"\xB5", 0, 0x225259}, /* East Asian ideograph */
  {"\xB3", 0, 0x22525A}, /* East Asian ideograph */
  {"\x83", 0, 0x22525C}, /* East Asian ideograph */
  {"\x9A", 0, 0x22525D}, /* East Asian ideograph */
  {"\xB6", 0, 0x22525E}, /* East Asian ideograph */
  {"\x8B", 0, 0x225260}, /* East Asian ideograph */
  {"\x87", 0, 0x225262}, /* East Asian ideograph */
  {"\xA8", 0, 0x225265}, /* East Asian ideograph */
  {"\xB1", 0, 0x225266}, /* East Asian ideograph */
  {"\x9F", 0, 0x225267}, /* East Asian ideograph */
  {"\x90", 0, 0x225269}, /* East Asian ideograph */
  {"\x93", 0, 0x22526B}, /* East Asian ideograph */
  {"\x84", 0, 0x225270}, /* East Asian ideograph */
  {"\xB2", 0, 0x225276}, /* East Asian ideograph */
  {"\xB8", 0, 0x225278}, /* East Asian ideograph */
  {"\xBB", 0, 0x22527C}, /* East Asian ideograph */
  {"\xBC", 0, 0x225336}, /* East Asian ideograph */
  {"\x85", 0, 0x2D5E24}, /* East Asian ideograph */
  {"\x8A", 0, 0x2E3870}, /* East Asian ideograph */
  {"\x9B", 0, 0x2E525D}, /* East Asian ideograph */
  {"\x96", 0, 0x334342}, /* East Asian ideograph */
  {"\xA2", 0, 0x345175}, /* East Asian ideograph */
  {"\xBA", 0, 0x4C523A}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page148 = {
  marc8r_31page148_flat, 0
};
/* PAGE 147 */
struct yaz_iconv_trie_flat marc8r_31page147_flat[] = {
  {"\x89", 0, 0x21495F}, /* East Asian ideograph */
  {"\x8A", 0, 0x214960}, /* East Asian ideograph */
  {"\x99", 0, 0x214962}, /* East Asian ideograph */
  {"\x9A", 0, 0x214964}, /* East Asian ideograph */
  {"\xB6", 0, 0x214965}, /* East Asian ideograph */
  {"\xA1", 0, 0x214966}, /* East Asian ideograph */
  {"\xB0", 0, 0x214967}, /* East Asian ideograph */
  {"\xA6", 0, 0x214968}, /* East Asian ideograph */
  {"\x84", 0, 0x225144}, /* East Asian ideograph */
  {"\x90", 0, 0x22514A}, /* East Asian ideograph */
  {"\x83", 0, 0x22514C}, /* East Asian ideograph */
  {"\x91", 0, 0x225155}, /* East Asian ideograph */
  {"\x92", 0, 0x225156}, /* East Asian ideograph */
  {"\x8C", 0, 0x22515C}, /* East Asian ideograph */
  {"\x93", 0, 0x225166}, /* East Asian ideograph */
  {"\x80", 0, 0x225168}, /* East Asian ideograph */
  {"\x9E", 0, 0x22516C}, /* East Asian ideograph */
  {"\xB4", 0, 0x22516D}, /* East Asian ideograph */
  {"\xA0", 0, 0x22516E}, /* East Asian ideograph */
  {"\xBF", 0, 0x22516F}, /* East Asian ideograph */
  {"\xB1", 0, 0x225174}, /* East Asian ideograph */
  {"\xAD", 0, 0x225175}, /* East Asian ideograph */
  {"\xB9", 0, 0x225227}, /* East Asian ideograph */
  {"\xB5", 0, 0x225228}, /* East Asian ideograph */
  {"\xBB", 0, 0x22522C}, /* East Asian ideograph */
  {"\x9C", 0, 0x22522E}, /* East Asian ideograph */
  {"\xBD", 0, 0x225232}, /* East Asian ideograph */
  {"\xAF", 0, 0x225235}, /* East Asian ideograph */
  {"\xA9", 0, 0x22523B}, /* East Asian ideograph */
  {"\xAE", 0, 0x225243}, /* East Asian ideograph */
  {"\x96", 0, 0x274A25}, /* East Asian ideograph */
  {"\xBC", 0, 0x2D4A26}, /* East Asian ideograph */
  {"\xB3", 0, 0x334968}, /* East Asian ideograph */
  {"\x98", 0, 0x345452}, /* East Asian ideograph */
  {"\x95", 0, 0x4B4973}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page147 = {
  marc8r_31page147_flat, 0
};
/* PAGE 146 */
struct yaz_iconv_trie_flat marc8r_31page146_flat[] = {
  {"\x8A", 0, 0x214958}, /* East Asian ideograph */
  {"\xA4", 0, 0x214959}, /* East Asian ideograph */
  {"\x98", 0, 0x21495A}, /* East Asian ideograph */
  {"\x88", 0, 0x21495B}, /* East Asian ideograph */
  {"\x99", 0, 0x21495C}, /* East Asian ideograph */
  {"\x8F", 0, 0x21495D}, /* East Asian ideograph */
  {"\xB9", 0, 0x21495E}, /* East Asian ideograph */
  {"\xBD", 0, 0x214961}, /* East Asian ideograph */
  {"\xBE", 0, 0x217627}, /* East Asian ideograph */
  {"\xAA", 0, 0x225078}, /* East Asian ideograph */
  {"\xA5", 0, 0x22507B}, /* East Asian ideograph */
  {"\x9C", 0, 0x22507C}, /* East Asian ideograph */
  {"\x93", 0, 0x22507D}, /* East Asian ideograph */
  {"\x9D", 0, 0x225122}, /* East Asian ideograph */
  {"\xA1", 0, 0x225123}, /* East Asian ideograph */
  {"\xA3", 0, 0x225126}, /* East Asian ideograph */
  {"\xA0", 0, 0x225128}, /* East Asian ideograph */
  {"\x94", 0, 0x22512B}, /* East Asian ideograph */
  {"\x91", 0, 0x22512E}, /* East Asian ideograph */
  {"\x8B", 0, 0x225138}, /* East Asian ideograph */
  {"\x90", 0, 0x22513A}, /* East Asian ideograph */
  {"\x87", 0, 0x22513B}, /* East Asian ideograph */
  {"\x9A", 0, 0x22513C}, /* East Asian ideograph */
  {"\x86", 0, 0x22513D}, /* East Asian ideograph */
  {"\xBA", 0, 0x22513F}, /* East Asian ideograph */
  {"\xB7", 0, 0x225142}, /* East Asian ideograph */
  {"\xB3", 0, 0x225148}, /* East Asian ideograph */
  {"\xB4", 0, 0x225150}, /* East Asian ideograph */
  {"\xB6", 0, 0x225160}, /* East Asian ideograph */
  {"\xAF", 0, 0x225167}, /* East Asian ideograph */
  {"\xA6", 0, 0x27496D}, /* East Asian ideograph */
  {"\xAD", 0, 0x27497D}, /* East Asian ideograph */
  {"\xAB", 0, 0x27497E}, /* East Asian ideograph */
  {"\xA7", 0, 0x274A26}, /* East Asian ideograph */
  {"\x9B", 0, 0x274A30}, /* East Asian ideograph */
  {"\xA9", 0, 0x274A33}, /* East Asian ideograph */
  {"\x81", 0, 0x274A36}, /* East Asian ideograph */
  {"\x82", 0, 0x274A38}, /* East Asian ideograph */
  {"\x83", 0, 0x285150}, /* East Asian ideograph */
  {"\xA8", 0, 0x285424}, /* East Asian ideograph */
  {"\xAC", 0, 0x28544F}, /* East Asian ideograph */
  {"\xB1", 0, 0x2D4954}, /* East Asian ideograph */
  {"\x9F", 0, 0x2D496B}, /* East Asian ideograph */
  {"\x96", 0, 0x33494A}, /* East Asian ideograph */
  {"\x80", 0, 0x706C43}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page146 = {
  marc8r_31page146_flat, 0
};
/* PAGE 145 */
struct yaz_iconv_trie_flat marc8r_31page145_flat[] = {
  {"\x95", 0, 0x21494B}, /* East Asian ideograph */
  {"\x8E", 0, 0x21494C}, /* East Asian ideograph */
  {"\x92", 0, 0x21494D}, /* East Asian ideograph */
  {"\x99", 0, 0x21494E}, /* East Asian ideograph */
  {"\x8A", 0, 0x21494F}, /* East Asian ideograph */
  {"\xAB", 0, 0x214950}, /* East Asian ideograph */
  {"\xBA", 0, 0x214951}, /* East Asian ideograph */
  {"\xAC", 0, 0x214952}, /* East Asian ideograph */
  {"\xB3", 0, 0x214953}, /* East Asian ideograph */
  {"\xAF", 0, 0x214954}, /* East Asian ideograph */
  {"\xAD", 0, 0x214955}, /* East Asian ideograph */
  {"\xAE", 0, 0x214956}, /* East Asian ideograph */
  {"\xB8", 0, 0x214957}, /* East Asian ideograph */
  {"\x93", 0, 0x225040}, /* East Asian ideograph */
  {"\x86", 0, 0x225042}, /* East Asian ideograph */
  {"\x96", 0, 0x225048}, /* East Asian ideograph */
  {"\x84", 0, 0x225049}, /* East Asian ideograph */
  {"\x81", 0, 0x22504A}, /* East Asian ideograph */
  {"\x88", 0, 0x225056}, /* East Asian ideograph */
  {"\x98", 0, 0x225057}, /* East Asian ideograph */
  {"\x8C", 0, 0x225059}, /* East Asian ideograph */
  {"\xB7", 0, 0x22505C}, /* East Asian ideograph */
  {"\xA1", 0, 0x225062}, /* East Asian ideograph */
  {"\xA3", 0, 0x225063}, /* East Asian ideograph */
  {"\xA7", 0, 0x22506F}, /* East Asian ideograph */
  {"\xB5", 0, 0x225071}, /* East Asian ideograph */
  {"\xBF", 0, 0x225072}, /* East Asian ideograph */
  {"\xA9", 0, 0x225073}, /* East Asian ideograph */
  {"\xBC", 0, 0x27496A}, /* East Asian ideograph */
  {"\x80", 0, 0x27496F}, /* East Asian ideograph */
  {"\xBD", 0, 0x274A21}, /* East Asian ideograph */
  {"\x89", 0, 0x274A37}, /* East Asian ideograph */
  {"\xB9", 0, 0x27626A}, /* East Asian ideograph */
  {"\x9C", 0, 0x285252}, /* East Asian ideograph */
  {"\x9D", 0, 0x28533C}, /* East Asian ideograph */
  {"\xB0", 0, 0x2D4956}, /* East Asian ideograph */
  {"\xA4", 0, 0x2D4971}, /* East Asian ideograph */
  {"\x85", 0, 0x2D526B}, /* East Asian ideograph */
  {"\xB1", 0, 0x2E506D}, /* East Asian ideograph */
  {"\x94", 0, 0x39526B}, /* East Asian ideograph */
  {"\xBB", 0, 0x706C42}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page145 = {
  marc8r_31page145_flat, 0
};
/* PAGE 144 */
struct yaz_iconv_trie_flat marc8r_31page144_flat[] = {
  {"\x8C", 0, 0x214940}, /* East Asian ideograph */
  {"\x91", 0, 0x214941}, /* East Asian ideograph */
  {"\x98", 0, 0x214942}, /* East Asian ideograph */
  {"\xA3", 0, 0x214943}, /* East Asian ideograph */
  {"\xA4", 0, 0x214944}, /* East Asian ideograph */
  {"\xAB", 0, 0x214945}, /* East Asian ideograph */
  {"\xB0", 0, 0x214946}, /* East Asian ideograph */
  {"\xB6", 0, 0x214947}, /* East Asian ideograph */
  {"\xBC", 0, 0x214948}, /* East Asian ideograph */
  {"\xB8", 0, 0x214949}, /* East Asian ideograph */
  {"\xBD", 0, 0x21494A}, /* East Asian ideograph */
  {"\x83", 0, 0x224F5D}, /* East Asian ideograph */
  {"\x84", 0, 0x224F61}, /* East Asian ideograph */
  {"\x87", 0, 0x224F67}, /* East Asian ideograph */
  {"\x89", 0, 0x224F69}, /* East Asian ideograph */
  {"\x95", 0, 0x224F6B}, /* East Asian ideograph */
  {"\x92", 0, 0x224F71}, /* East Asian ideograph */
  {"\x9C", 0, 0x224F73}, /* East Asian ideograph */
  {"\x99", 0, 0x224F78}, /* East Asian ideograph */
  {"\x9E", 0, 0x224F7B}, /* East Asian ideograph */
  {"\xA1", 0, 0x224F7C}, /* East Asian ideograph */
  {"\x9D", 0, 0x224F7D}, /* East Asian ideograph */
  {"\xA6", 0, 0x225025}, /* East Asian ideograph */
  {"\xA5", 0, 0x225027}, /* East Asian ideograph */
  {"\xA8", 0, 0x225028}, /* East Asian ideograph */
  {"\x94", 0, 0x225029}, /* East Asian ideograph */
  {"\xB4", 0, 0x225039}, /* East Asian ideograph */
  {"\xBA", 0, 0x22503B}, /* East Asian ideograph */
  {"\xAD", 0, 0x274842}, /* East Asian ideograph */
  {"\xBE", 0, 0x27494A}, /* East Asian ideograph */
  {"\xAF", 0, 0x274A24}, /* East Asian ideograph */
  {"\xBF", 0, 0x274A31}, /* East Asian ideograph */
  {"\xB5", 0, 0x275F6F}, /* East Asian ideograph */
  {"\x8F", 0, 0x284F7D}, /* East Asian ideograph */
  {"\xAE", 0, 0x2D3272}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page144 = {
  marc8r_31page144_flat, 0
};
/* PAGE 143 */
struct yaz_iconv_trie_flat marc8r_31page143_flat[] = {
  {"\x8B", 0, 0x214931}, /* East Asian ideograph */
  {"\x89", 0, 0x214932}, /* East Asian ideograph */
  {"\x86", 0, 0x214933}, /* East Asian ideograph */
  {"\x91", 0, 0x214935}, /* East Asian ideograph */
  {"\x8F", 0, 0x214937}, /* East Asian ideograph */
  {"\x9B", 0, 0x214938}, /* East Asian ideograph */
  {"\x9A", 0, 0x214939}, /* East Asian ideograph */
  {"\xA8", 0, 0x21493A}, /* East Asian ideograph */
  {"\x9D", 0, 0x21493B}, /* East Asian ideograph */
  {"\x95", 0, 0x21493C}, /* East Asian ideograph */
  {"\x9F", 0, 0x21493D}, /* East Asian ideograph */
  {"\xBE", 0, 0x21493F}, /* East Asian ideograph */
  {"\x85", 0, 0x224E66}, /* East Asian ideograph */
  {"\x8C", 0, 0x224E67}, /* East Asian ideograph */
  {"\x8D", 0, 0x224E6A}, /* East Asian ideograph */
  {"\xA6", 0, 0x224E72}, /* East Asian ideograph */
  {"\xA0", 0, 0x224F24}, /* East Asian ideograph */
  {"\xA7", 0, 0x224F26}, /* East Asian ideograph */
  {"\x9E", 0, 0x224F2B}, /* East Asian ideograph (variant of EACC 4C4F2B) */
  {"\xAE", 0, 0x224F2F}, /* East Asian ideograph */
  {"\xAD", 0, 0x224F31}, /* East Asian ideograph */
  {"\xA1", 0, 0x224F35}, /* East Asian ideograph */
  {"\x98", 0, 0x224F39}, /* East Asian ideograph */
  {"\xA3", 0, 0x224F3A}, /* East Asian ideograph */
  {"\xBC", 0, 0x224F41}, /* East Asian ideograph */
  {"\xB5", 0, 0x224F44}, /* East Asian ideograph */
  {"\xB4", 0, 0x224F51}, /* East Asian ideograph */
  {"\xB9", 0, 0x224F53}, /* East Asian ideograph */
  {"\xBA", 0, 0x224F54}, /* East Asian ideograph */
  {"\x81", 0, 0x2D4853}, /* East Asian ideograph */
  {"\xAC", 0, 0x2D493A}, /* East Asian ideograph */
  {"\xB2", 0, 0x2E4E41}, /* East Asian ideograph */
  {"\xB0", 0, 0x333D4C}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page143 = {
  marc8r_31page143_flat, 0
};
/* PAGE 142 */
struct yaz_iconv_trie_dir marc8r_31page142_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {144, 0, 0},
  {145, 0, 0},
  {146, 0, 0},
  {147, 0, 0},
  {148, 0, 0},
  {149, 0, 0},
  {150, 0, 0},
  {151, 0, 0},
  {152, 0, 0},
  {153, 0, 0},
  {154, 0, 0},
  {155, 0, 0},
  {156, 0, 0},
  {157, 0, 0},
  {158, 0, 0},
  {159, 0, 0},
  {160, 0, 0},
  {161, 0, 0},
  {162, 0, 0},
  {163, 0, 0},
  {164, 0, 0},
  {165, 0, 0},
  {166, 0, 0},
  {167, 0, 0},
  {168, 0, 0},
  {169, 0, 0},
  {170, 0, 0},
  {171, 0, 0},
  {172, 0, 0},
  {173, 0, 0},
  {174, 0, 0},
  {175, 0, 0},
  {176, 0, 0},
  {177, 0, 0},
  {178, 0, 0},
  {179, 0, 0},
  {180, 0, 0},
  {181, 0, 0},
  {182, 0, 0},
  {184, 0, 0},
  {185, 0, 0},
  {186, 0, 0},
  {187, 0, 0},
  {188, 0, 0},
  {189, 0, 0},
  {190, 0, 0},
  {191, 0, 0},
  {192, 0, 0},
  {193, 0, 0},
  {194, 0, 0},
  {195, 0, 0},
  {196, 0, 0},
  {197, 0, 0},
  {198, 0, 0},
  {199, 0, 0},
  {200, 0, 0},
  {201, 0, 0},
  {202, 0, 0},
  {203, 0, 0},
  {332, 0, 0},
  {204, 0, 0},
  {205, 0, 0},
  {206, 0, 0},
  {207, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page142 = {
  0, marc8r_31page142_dir
};
/* PAGE 141 */
struct yaz_iconv_trie_flat marc8r_31page141_flat[] = {
  {"\x82", 0, 0x21487A}, /* East Asian ideograph */
  {"\x83", 0, 0x21487C}, /* East Asian ideograph */
  {"\x81", 0, 0x214922}, /* East Asian ideograph */
  {"\x80", 0, 0x214924}, /* East Asian ideograph */
  {"\x9F", 0, 0x214926}, /* East Asian ideograph */
  {"\x98", 0, 0x214927}, /* East Asian ideograph */
  {"\xB1", 0, 0x214928}, /* East Asian ideograph */
  {"\xA0", 0, 0x214929}, /* East Asian ideograph */
  {"\xAF", 0, 0x21492A}, /* East Asian ideograph */
  {"\xAB", 0, 0x21492B}, /* East Asian ideograph (variant of EACC 4B492B) */
  {"\xA1", 0, 0x21492C}, /* East Asian ideograph */
  {"\xA4", 0, 0x21492D}, /* East Asian ideograph */
  {"\xBA", 0, 0x214934}, /* East Asian ideograph */
  {"\xBE", 0, 0x214936}, /* East Asian ideograph */
  {"\x86", 0, 0x224D7C}, /* East Asian ideograph */
  {"\x87", 0, 0x224E26}, /* East Asian ideograph */
  {"\x89", 0, 0x224E2D}, /* East Asian ideograph */
  {"\x88", 0, 0x224E2F}, /* East Asian ideograph */
  {"\x8A", 0, 0x224E32}, /* East Asian ideograph */
  {"\x99", 0, 0x224E43}, /* East Asian ideograph */
  {"\x9A", 0, 0x224E44}, /* East Asian ideograph */
  {"\x94", 0, 0x224E50}, /* East Asian ideograph */
  {"\xA9", 0, 0x224E56}, /* East Asian ideograph */
  {"\xB8", 0, 0x224E57}, /* East Asian ideograph */
  {"\x9E", 0, 0x224E5D}, /* East Asian ideograph */
  {"\xAE", 0, 0x224E5E}, /* East Asian ideograph */
  {"\xB0", 0, 0x224E62}, /* East Asian ideograph */
  {"\x91", 0, 0x27493A}, /* East Asian ideograph */
  {"\x92", 0, 0x27493C}, /* East Asian ideograph */
  {"\xBC", 0, 0x2D4738}, /* East Asian ideograph */
  {"\x95", 0, 0x2D4844}, /* East Asian ideograph */
  {"\xB6", 0, 0x2D5E61}, /* East Asian ideograph */
  {"\xAC", 0, 0x334755}, /* East Asian ideograph */
  {"\x9B", 0, 0x455564}, /* East Asian ideograph (Version J extension) */
  {"\xB3", 0, 0x4B4874}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page141 = {
  marc8r_31page141_flat, 0
};
/* PAGE 140 */
struct yaz_iconv_trie_flat marc8r_31page140_flat[] = {
  {"\x88", 0, 0x21486A}, /* East Asian ideograph */
  {"\x84", 0, 0x21486B}, /* East Asian ideograph */
  {"\x97", 0, 0x21486E}, /* East Asian ideograph */
  {"\x86", 0, 0x214871}, /* East Asian ideograph */
  {"\x8E", 0, 0x214872}, /* East Asian ideograph */
  {"\xB1", 0, 0x21487B}, /* East Asian ideograph */
  {"\xA7", 0, 0x21487D}, /* East Asian ideograph */
  {"\xA1", 0, 0x21487E}, /* East Asian ideograph */
  {"\xA4", 0, 0x214921}, /* East Asian ideograph */
  {"\xB3", 0, 0x214925}, /* East Asian ideograph */
  {"\x80", 0, 0x21492E}, /* East Asian ideograph */
  {"\x95", 0, 0x224C64}, /* East Asian ideograph */
  {"\x9D", 0, 0x224D24}, /* East Asian ideograph */
  {"\x87", 0, 0x224D27}, /* East Asian ideograph */
  {"\x90", 0, 0x224D35}, /* East Asian ideograph */
  {"\x8D", 0, 0x224D37}, /* East Asian ideograph */
  {"\x92", 0, 0x224D39}, /* East Asian ideograph */
  {"\x89", 0, 0x224D3A}, /* East Asian ideograph */
  {"\x8C", 0, 0x224D3C}, /* East Asian ideograph */
  {"\x8B", 0, 0x224D4D}, /* East Asian ideograph */
  {"\xB6", 0, 0x224D73}, /* East Asian ideograph */
  {"\x9F", 0, 0x224D74}, /* East Asian ideograph */
  {"\xA6", 0, 0x224D79}, /* East Asian ideograph */
  {"\xBC", 0, 0x224D7D}, /* East Asian ideograph */
  {"\xAA", 0, 0x224E21}, /* East Asian ideograph */
  {"\xBF", 0, 0x224E25}, /* East Asian ideograph */
  {"\xA0", 0, 0x224E30}, /* East Asian ideograph */
  {"\xB4", 0, 0x224E35}, /* East Asian ideograph */
  {"\xAF", 0, 0x224E37}, /* East Asian ideograph */
  {"\xA8", 0, 0x224E3C}, /* East Asian ideograph */
  {"\xA5", 0, 0x224E40}, /* East Asian ideograph */
  {"\xB0", 0, 0x224E41}, /* East Asian ideograph */
  {"\xAE", 0, 0x224E42}, /* East Asian ideograph */
  {"\x9C", 0, 0x27493F}, /* East Asian ideograph */
  {"\x94", 0, 0x2D4756}, /* East Asian ideograph */
  {"\x82", 0, 0x2D486B}, /* East Asian ideograph */
  {"\xA3", 0, 0x2E4873}, /* East Asian ideograph */
  {"\xB9", 0, 0x33475E}, /* East Asian ideograph */
  {"\x81", 0, 0x33492E}, /* East Asian ideograph */
  {"\x91", 0, 0x4B484C}, /* East Asian ideograph */
  {"\x99", 0, 0x4C4D63}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page140 = {
  marc8r_31page140_flat, 0
};
/* PAGE 139 */
struct yaz_iconv_trie_flat marc8r_31page139_flat[] = {
  {"\xBC", 0, 0x214869}, /* East Asian ideograph */
  {"\x91", 0, 0x21486C}, /* East Asian ideograph */
  {"\xA4", 0, 0x21486D}, /* East Asian ideograph */
  {"\x94", 0, 0x21486F}, /* East Asian ideograph */
  {"\xBA", 0, 0x214870}, /* East Asian ideograph */
  {"\xAD", 0, 0x214873}, /* East Asian ideograph */
  {"\x9B", 0, 0x214874}, /* East Asian ideograph */
  {"\xAE", 0, 0x214875}, /* East Asian ideograph */
  {"\xB8", 0, 0x214876}, /* East Asian ideograph */
  {"\xA6", 0, 0x214877}, /* East Asian ideograph */
  {"\xB0", 0, 0x214878}, /* East Asian ideograph */
  {"\x98", 0, 0x214879}, /* East Asian ideograph */
  {"\xA3", 0, 0x224C3D}, /* East Asian ideograph */
  {"\x81", 0, 0x224C62}, /* East Asian ideograph */
  {"\x89", 0, 0x224C6B}, /* East Asian ideograph */
  {"\xBE", 0, 0x224D23}, /* East Asian ideograph */
  {"\xAF", 0, 0x224D2B}, /* East Asian ideograph */
  {"\x9A", 0, 0x224D2F}, /* East Asian ideograph */
  {"\xA0", 0, 0x224D30}, /* East Asian ideograph */
  {"\xA2", 0, 0x224D3D}, /* East Asian ideograph (variant of EACC 4C4D3D) */
  {"\xAC", 0, 0x224D4B}, /* East Asian ideograph */
  {"\x95", 0, 0x224D5A}, /* East Asian ideograph */
  {"\xB2", 0, 0x224D5F}, /* East Asian ideograph */
  {"\x97", 0, 0x224D62}, /* East Asian ideograph */
  {"\x9F", 0, 0x224D63}, /* East Asian ideograph */
  {"\x9D", 0, 0x224D68}, /* East Asian ideograph */
  {"\x9E", 0, 0x224E2E}, /* East Asian ideograph */
  {"\x87", 0, 0x27493D}, /* East Asian ideograph */
  {"\x8B", 0, 0x284E41}, /* East Asian ideograph */
  {"\x8D", 0, 0x284E62}, /* East Asian ideograph */
  {"\x84", 0, 0x2D485C}, /* East Asian ideograph */
  {"\x9C", 0, 0x2D4874}, /* East Asian ideograph */
  {"\xB4", 0, 0x2E4E72}, /* East Asian ideograph */
  {"\x85", 0, 0x4B4940}, /* East Asian ideograph */
  {"\x86", 0, 0x4C4F24}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page139 = {
  marc8r_31page139_flat, 0
};
/* PAGE 138 */
struct yaz_iconv_trie_flat marc8r_31page138_flat[] = {
  {"\xB3", 0, 0x21484D}, /* East Asian ideograph */
  {"\xA9", 0, 0x214851}, /* East Asian ideograph */
  {"\x94", 0, 0x214852}, /* East Asian ideograph */
  {"\xBE", 0, 0x214853}, /* East Asian ideograph */
  {"\xAC", 0, 0x214854}, /* East Asian ideograph */
  {"\xB2", 0, 0x214855}, /* East Asian ideograph */
  {"\x8F", 0, 0x214856}, /* East Asian ideograph */
  {"\xA2", 0, 0x214857}, /* East Asian ideograph (variant of EACC 4B4857) */
  {"\xA3", 0, 0x214859}, /* East Asian ideograph */
  {"\xB8", 0, 0x21485A}, /* East Asian ideograph */
  {"\x95", 0, 0x21485B}, /* East Asian ideograph */
  {"\xB1", 0, 0x21485C}, /* East Asian ideograph */
  {"\x82", 0, 0x21485D}, /* East Asian ideograph */
  {"\x86", 0, 0x21485E}, /* East Asian ideograph */
  {"\xAB", 0, 0x214860}, /* East Asian ideograph */
  {"\xAF", 0, 0x214861}, /* East Asian ideograph */
  {"\xA0", 0, 0x214862}, /* East Asian ideograph */
  {"\xBF", 0, 0x214863}, /* East Asian ideograph */
  {"\x81", 0, 0x214865}, /* East Asian ideograph */
  {"\x91", 0, 0x214866}, /* East Asian ideograph */
  {"\xAA", 0, 0x214868}, /* East Asian ideograph */
  {"\xB7", 0, 0x224C30}, /* East Asian ideograph */
  {"\x89", 0, 0x224C35}, /* East Asian ideograph */
  {"\xBB", 0, 0x224C3C}, /* East Asian ideograph */
  {"\x92", 0, 0x224C3E}, /* East Asian ideograph */
  {"\xA6", 0, 0x224C3F}, /* East Asian ideograph */
  {"\x9A", 0, 0x224C41}, /* East Asian ideograph */
  {"\x99", 0, 0x224C43}, /* East Asian ideograph */
  {"\x80", 0, 0x224C44}, /* East Asian ideograph */
  {"\xA4", 0, 0x224C4B}, /* East Asian ideograph */
  {"\x98", 0, 0x224C51}, /* East Asian ideograph */
  {"\x9F", 0, 0x224C57}, /* East Asian ideograph */
  {"\x8A", 0, 0x224C5A}, /* East Asian ideograph */
  {"\xB6", 0, 0x224C5E}, /* East Asian ideograph */
  {"\xAD", 0, 0x224C65}, /* East Asian ideograph */
  {"\xB4", 0, 0x224C67}, /* East Asian ideograph */
  {"\xB0", 0, 0x224C6D}, /* East Asian ideograph */
  {"\x88", 0, 0x224C78}, /* East Asian ideograph */
  {"\x8E", 0, 0x224C79}, /* East Asian ideograph */
  {"\xB5", 0, 0x224C7B}, /* East Asian ideograph */
  {"\x8B", 0, 0x224D44}, /* East Asian ideograph */
  {"\x93", 0, 0x284F6B}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page138 = {
  marc8r_31page138_flat, 0
};
/* PAGE 137 */
struct yaz_iconv_trie_flat marc8r_31page137_flat[] = {
  {"\xB6", 0, 0x214838}, /* East Asian ideograph */
  {"\xAF", 0, 0x21483B}, /* East Asian ideograph */
  {"\xA2", 0, 0x21483C}, /* East Asian ideograph */
  {"\x9D", 0, 0x21483D}, /* East Asian ideograph */
  {"\xA5", 0, 0x21483F}, /* East Asian ideograph */
  {"\x98", 0, 0x214840}, /* East Asian ideograph */
  {"\x90", 0, 0x214841}, /* East Asian ideograph */
  {"\xBC", 0, 0x214844}, /* East Asian ideograph */
  {"\xAB", 0, 0x214845}, /* East Asian ideograph */
  {"\xAA", 0, 0x21484A}, /* East Asian ideograph */
  {"\x96", 0, 0x21484B}, /* East Asian ideograph */
  {"\x9C", 0, 0x21484C}, /* East Asian ideograph */
  {"\x8A", 0, 0x224A60}, /* East Asian ideograph */
  {"\x84", 0, 0x224B2C}, /* East Asian ideograph */
  {"\x8B", 0, 0x224B3B}, /* East Asian ideograph */
  {"\x9B", 0, 0x224B45}, /* East Asian ideograph */
  {"\x9F", 0, 0x224B46}, /* East Asian ideograph */
  {"\x8F", 0, 0x224B4A}, /* East Asian ideograph */
  {"\x93", 0, 0x224B4D}, /* East Asian ideograph */
  {"\xA0", 0, 0x224B4F}, /* East Asian ideograph */
  {"\xB1", 0, 0x224B51}, /* East Asian ideograph */
  {"\xA8", 0, 0x224B57}, /* East Asian ideograph */
  {"\x92", 0, 0x224B59}, /* East Asian ideograph */
  {"\xA7", 0, 0x224B5A}, /* East Asian ideograph */
  {"\x8E", 0, 0x224B5E}, /* East Asian ideograph */
  {"\xBD", 0, 0x224B61}, /* East Asian ideograph */
  {"\xBB", 0, 0x224B69}, /* East Asian ideograph */
  {"\xB3", 0, 0x224B6C}, /* East Asian ideograph */
  {"\xB7", 0, 0x224B6D}, /* East Asian ideograph */
  {"\xA4", 0, 0x224B75}, /* East Asian ideograph */
  {"\xB4", 0, 0x224C24}, /* East Asian ideograph */
  {"\xB2", 0, 0x224C26}, /* East Asian ideograph */
  {"\xB5", 0, 0x224C29}, /* East Asian ideograph */
  {"\x88", 0, 0x224D58}, /* East Asian ideograph */
  {"\x83", 0, 0x274878}, /* East Asian ideograph */
  {"\x85", 0, 0x274934}, /* East Asian ideograph */
  {"\xBA", 0, 0x2D3B52}, /* East Asian ideograph */
  {"\xA6", 0, 0x2E4A6B}, /* East Asian ideograph */
  {"\x86", 0, 0x2E4C7B}, /* East Asian ideograph */
  {"\x80", 0, 0x4B4858}, /* East Asian ideograph */
  {"\x89", 0, 0x4B4866}, /* East Asian ideograph */
  {"\x82", 0, 0x695E63}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page137 = {
  marc8r_31page137_flat, 0
};
/* PAGE 136 */
struct yaz_iconv_trie_flat marc8r_31page136_flat[] = {
  {"\x93", 0, 0x214837}, /* East Asian ideograph */
  {"\x82", 0, 0x214839}, /* East Asian ideograph */
  {"\x85", 0, 0x214842}, /* East Asian ideograph */
  {"\x87", 0, 0x214843}, /* East Asian ideograph */
  {"\x91", 0, 0x214846}, /* East Asian ideograph */
  {"\x8B", 0, 0x214847}, /* East Asian ideograph */
  {"\x84", 0, 0x214848}, /* East Asian ideograph */
  {"\x94", 0, 0x214849}, /* East Asian ideograph */
  {"\xB4", 0, 0x21484E}, /* East Asian ideograph */
  {"\xAC", 0, 0x21484F}, /* East Asian ideograph */
  {"\xBE", 0, 0x214850}, /* East Asian ideograph */
  {"\xBF", 0, 0x214858}, /* East Asian ideograph */
  {"\xAF", 0, 0x21485F}, /* East Asian ideograph */
  {"\xB2", 0, 0x214864}, /* East Asian ideograph */
  {"\x8C", 0, 0x214867}, /* East Asian ideograph */
  {"\x8E", 0, 0x224B43}, /* East Asian ideograph */
  {"\x88", 0, 0x224B48}, /* East Asian ideograph */
  {"\x98", 0, 0x224B49}, /* East Asian ideograph */
  {"\x99", 0, 0x224B60}, /* East Asian ideograph */
  {"\x81", 0, 0x224B63}, /* East Asian ideograph */
  {"\x89", 0, 0x224B6A}, /* East Asian ideograph */
  {"\x8F", 0, 0x224B79}, /* East Asian ideograph */
  {"\x8A", 0, 0x224B7C}, /* East Asian ideograph */
  {"\x95", 0, 0x224B7D}, /* East Asian ideograph */
  {"\x83", 0, 0x224C21}, /* East Asian ideograph */
  {"\xB8", 0, 0x224C2E}, /* East Asian ideograph */
  {"\xBD", 0, 0x224C34}, /* East Asian ideograph */
  {"\xB6", 0, 0x224C42}, /* East Asian ideograph */
  {"\xB9", 0, 0x224C60}, /* East Asian ideograph */
  {"\xAE", 0, 0x224C61}, /* East Asian ideograph */
  {"\xBA", 0, 0x224C76}, /* East Asian ideograph */
  {"\xAB", 0, 0x224C77}, /* East Asian ideograph */
  {"\xA1", 0, 0x274858}, /* East Asian ideograph */
  {"\x9E", 0, 0x27485F}, /* East Asian ideograph */
  {"\xA8", 0, 0x274928}, /* East Asian ideograph */
  {"\xA5", 0, 0x27492B}, /* East Asian ideograph */
  {"\xA4", 0, 0x274936}, /* East Asian ideograph */
  {"\xA9", 0, 0x274942}, /* East Asian ideograph */
  {"\xA6", 0, 0x274944}, /* East Asian ideograph */
  {"\x97", 0, 0x284D59}, /* East Asian ideograph */
  {"\xA2", 0, 0x284E66}, /* East Asian ideograph */
  {"\xA0", 0, 0x284F61}, /* East Asian ideograph */
  {"\x9F", 0, 0x285029}, /* East Asian ideograph */
  {"\x9A", 0, 0x2D4850}, /* East Asian ideograph */
  {"\xB7", 0, 0x2F5D3C}, /* East Asian ideograph */
  {"\x9D", 0, 0x4C4F26}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page136 = {
  marc8r_31page136_flat, 0
};
/* PAGE 135 */
struct yaz_iconv_trie_flat marc8r_31page135_flat[] = {
  {"\xA1", 0, 0x21477A}, /* East Asian ideograph */
  {"\xB8", 0, 0x21477B}, /* East Asian ideograph */
  {"\xB2", 0, 0x21477C}, /* East Asian ideograph */
  {"\xA0", 0, 0x21477E}, /* East Asian ideograph */
  {"\x9A", 0, 0x214822}, /* East Asian ideograph */
  {"\xAF", 0, 0x214824}, /* East Asian ideograph */
  {"\xA3", 0, 0x214827}, /* East Asian ideograph */
  {"\xA4", 0, 0x214828}, /* East Asian ideograph */
  {"\x9B", 0, 0x214829}, /* East Asian ideograph */
  {"\xA5", 0, 0x21482A}, /* East Asian ideograph */
  {"\xBA", 0, 0x21482C}, /* East Asian ideograph */
  {"\xAD", 0, 0x21482E}, /* East Asian ideograph */
  {"\xB4", 0, 0x21482F}, /* East Asian ideograph */
  {"\xAC", 0, 0x214830}, /* East Asian ideograph */
  {"\xA6", 0, 0x214831}, /* East Asian ideograph */
  {"\xBE", 0, 0x214833}, /* East Asian ideograph */
  {"\x99", 0, 0x214835}, /* East Asian ideograph */
  {"\x9D", 0, 0x214836}, /* East Asian ideograph */
  {"\x8F", 0, 0x224979}, /* East Asian ideograph */
  {"\x92", 0, 0x224A44}, /* East Asian ideograph */
  {"\x9F", 0, 0x224A4C}, /* East Asian ideograph */
  {"\xA7", 0, 0x224A50}, /* East Asian ideograph */
  {"\xBC", 0, 0x224A58}, /* East Asian ideograph */
  {"\xA8", 0, 0x224B22}, /* East Asian ideograph */
  {"\xB1", 0, 0x224B26}, /* East Asian ideograph */
  {"\xAE", 0, 0x224B2E}, /* East Asian ideograph */
  {"\xB6", 0, 0x224B30}, /* East Asian ideograph */
  {"\xB0", 0, 0x224B33}, /* East Asian ideograph */
  {"\xB9", 0, 0x224B36}, /* East Asian ideograph */
  {"\xAA", 0, 0x224B40}, /* East Asian ideograph */
  {"\xA2", 0, 0x224B42}, /* East Asian ideograph */
  {"\x8A", 0, 0x274774}, /* East Asian ideograph */
  {"\x8D", 0, 0x274854}, /* East Asian ideograph */
  {"\x90", 0, 0x27485A}, /* East Asian ideograph */
  {"\x97", 0, 0x274864}, /* East Asian ideograph */
  {"\x94", 0, 0x274865}, /* East Asian ideograph */
  {"\x8E", 0, 0x274933}, /* East Asian ideograph */
  {"\x91", 0, 0x284E30}, /* East Asian ideograph */
  {"\x87", 0, 0x2D482F}, /* East Asian ideograph */
  {"\xA9", 0, 0x2D4845}, /* East Asian ideograph */
  {"\xAB", 0, 0x334729}, /* East Asian ideograph */
  {"\x88", 0, 0x3F4926}, /* East Asian ideograph */
  {"\x95", 0, 0x454774}, /* East Asian ideograph */
  {"\x85", 0, 0x4B4761}, /* East Asian ideograph */
  {"\x93", 0, 0x4B484A}, /* East Asian ideograph */
  {"\x8B", 0, 0x4B492E}, /* East Asian ideograph */
  {"\x96", 0, 0x4B4931}, /* East Asian ideograph */
  {"\x8C", 0, 0x4C4C35}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page135 = {
  marc8r_31page135_flat, 0
};
/* PAGE 134 */
struct yaz_iconv_trie_flat marc8r_31page134_flat[] = {
  {"\x94", 0, 0x214779}, /* East Asian ideograph */
  {"\xA7", 0, 0x21477D}, /* East Asian ideograph */
  {"\x9B", 0, 0x214821}, /* East Asian ideograph */
  {"\x96", 0, 0x214823}, /* East Asian ideograph */
  {"\xAE", 0, 0x214825}, /* East Asian ideograph */
  {"\x98", 0, 0x214826}, /* East Asian ideograph */
  {"\x8A", 0, 0x21482B}, /* East Asian ideograph */
  {"\xAF", 0, 0x21482D}, /* East Asian ideograph */
  {"\x8D", 0, 0x214832}, /* East Asian ideograph */
  {"\x83", 0, 0x214834}, /* East Asian ideograph */
  {"\x89", 0, 0x224A55}, /* East Asian ideograph */
  {"\x8B", 0, 0x224A62}, /* East Asian ideograph */
  {"\xA2", 0, 0x224A66}, /* East Asian ideograph */
  {"\x91", 0, 0x224A6A}, /* East Asian ideograph */
  {"\x84", 0, 0x224A6B}, /* East Asian ideograph */
  {"\xA3", 0, 0x224A6D}, /* East Asian ideograph */
  {"\xB3", 0, 0x224A71}, /* East Asian ideograph */
  {"\x8F", 0, 0x224A74}, /* East Asian ideograph */
  {"\x8E", 0, 0x224A77}, /* East Asian ideograph */
  {"\x9C", 0, 0x224B24}, /* East Asian ideograph */
  {"\x9E", 0, 0x224B28}, /* East Asian ideograph */
  {"\x9D", 0, 0x224B31}, /* East Asian ideograph */
  {"\xB2", 0, 0x224B32}, /* East Asian ideograph */
  {"\x93", 0, 0x224B34}, /* East Asian ideograph */
  {"\xB1", 0, 0x224B37}, /* East Asian ideograph */
  {"\xA9", 0, 0x224B38}, /* East Asian ideograph */
  {"\xAB", 0, 0x224B39}, /* East Asian ideograph */
  {"\xB6", 0, 0x224B3E}, /* East Asian ideograph */
  {"\x8C", 0, 0x224B41}, /* East Asian ideograph */
  {"\xBF", 0, 0x274844}, /* East Asian ideograph */
  {"\xBE", 0, 0x274943}, /* East Asian ideograph */
  {"\xBC", 0, 0x2E493B}, /* East Asian ideograph */
  {"\x9F", 0, 0x334730}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page134 = {
  marc8r_31page134_flat, 0
};
/* PAGE 133 */
struct yaz_iconv_trie_flat marc8r_31page133_flat[] = {
  {"\x99", 0, 0x214758}, /* East Asian ideograph */
  {"\x9A", 0, 0x214759}, /* East Asian ideograph */
  {"\xB3", 0, 0x21475A}, /* East Asian ideograph */
  {"\xA4", 0, 0x21475C}, /* East Asian ideograph */
  {"\xA1", 0, 0x21475E}, /* East Asian ideograph */
  {"\x92", 0, 0x21475F}, /* East Asian ideograph */
  {"\xB8", 0, 0x214761}, /* East Asian ideograph */
  {"\x87", 0, 0x214762}, /* East Asian ideograph */
  {"\x8B", 0, 0x214763}, /* East Asian ideograph */
  {"\x85", 0, 0x214764}, /* East Asian ideograph */
  {"\x9E", 0, 0x214765}, /* East Asian ideograph */
  {"\xBA", 0, 0x214768}, /* East Asian ideograph */
  {"\xB9", 0, 0x214769}, /* East Asian ideograph */
  {"\x8C", 0, 0x21476A}, /* East Asian ideograph */
  {"\xB7", 0, 0x21476B}, /* East Asian ideograph */
  {"\x91", 0, 0x21476D}, /* East Asian ideograph */
  {"\xB1", 0, 0x21476E}, /* East Asian ideograph */
  {"\xA8", 0, 0x21476F}, /* East Asian ideograph */
  {"\xAB", 0, 0x214770}, /* East Asian ideograph */
  {"\x98", 0, 0x214771}, /* East Asian ideograph */
  {"\xBB", 0, 0x214772}, /* East Asian ideograph */
  {"\xAE", 0, 0x214773}, /* East Asian ideograph */
  {"\xB5", 0, 0x214774}, /* East Asian ideograph */
  {"\x86", 0, 0x214776}, /* East Asian ideograph */
  {"\xAA", 0, 0x214777}, /* East Asian ideograph */
  {"\x84", 0, 0x214778}, /* East Asian ideograph */
  {"\xAF", 0, 0x224935}, /* East Asian ideograph */
  {"\xAC", 0, 0x224960}, /* East Asian ideograph */
  {"\xA2", 0, 0x22496C}, /* East Asian ideograph */
  {"\x95", 0, 0x22496D}, /* East Asian ideograph */
  {"\xA9", 0, 0x22496E}, /* East Asian ideograph */
  {"\xB6", 0, 0x224971}, /* East Asian ideograph */
  {"\x9F", 0, 0x224A2A}, /* East Asian ideograph */
  {"\x93", 0, 0x224A2D}, /* East Asian ideograph */
  {"\xBC", 0, 0x224A32}, /* East Asian ideograph */
  {"\x9D", 0, 0x224A35}, /* East Asian ideograph */
  {"\x9C", 0, 0x224A36}, /* East Asian ideograph */
  {"\x9B", 0, 0x224A39}, /* East Asian ideograph */
  {"\xB0", 0, 0x224A46}, /* East Asian ideograph */
  {"\xA6", 0, 0x224A4A}, /* East Asian ideograph */
  {"\x80", 0, 0x27487B}, /* East Asian ideograph */
  {"\x96", 0, 0x2D514A}, /* East Asian ideograph */
  {"\xA5", 0, 0x2E4C35}, /* East Asian ideograph */
  {"\xA0", 0, 0x2E4E5D}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page133 = {
  marc8r_31page133_flat, 0
};
/* PAGE 132 */
struct yaz_iconv_trie_flat marc8r_31page132_flat[] = {
  {"\x95", 0, 0x21474A}, /* East Asian ideograph */
  {"\x87", 0, 0x21474E}, /* East Asian ideograph */
  {"\x88", 0, 0x21474F}, /* East Asian ideograph */
  {"\x93", 0, 0x214751}, /* East Asian ideograph */
  {"\x89", 0, 0x214752}, /* East Asian ideograph */
  {"\xBC", 0, 0x21475B}, /* East Asian ideograph */
  {"\xB2", 0, 0x21475D}, /* East Asian ideograph */
  {"\xAE", 0, 0x214760}, /* East Asian ideograph */
  {"\xAF", 0, 0x214766}, /* East Asian ideograph */
  {"\xB5", 0, 0x214767}, /* East Asian ideograph */
  {"\xB8", 0, 0x21476C}, /* East Asian ideograph */
  {"\x8E", 0, 0x214775}, /* East Asian ideograph */
  {"\xA5", 0, 0x224877}, /* East Asian ideograph */
  {"\x92", 0, 0x22487D}, /* East Asian ideograph */
  {"\x91", 0, 0x224929}, /* East Asian ideograph */
  {"\x81", 0, 0x22492C}, /* East Asian ideograph */
  {"\x8A", 0, 0x22492E}, /* East Asian ideograph */
  {"\x85", 0, 0x22493B}, /* East Asian ideograph */
  {"\x94", 0, 0x224943}, /* East Asian ideograph */
  {"\x98", 0, 0x224948}, /* East Asian ideograph */
  {"\x96", 0, 0x22494F}, /* East Asian ideograph */
  {"\xAB", 0, 0x224959}, /* East Asian ideograph */
  {"\xB4", 0, 0x22495A}, /* East Asian ideograph */
  {"\xAA", 0, 0x22495C}, /* East Asian ideograph */
  {"\xAC", 0, 0x22496A}, /* East Asian ideograph */
  {"\xB7", 0, 0x22496B}, /* East Asian ideograph */
  {"\xBF", 0, 0x22497B}, /* East Asian ideograph */
  {"\xA4", 0, 0x224A3D}, /* East Asian ideograph */
  {"\x82", 0, 0x27384D}, /* East Asian ideograph */
  {"\x8C", 0, 0x27477D}, /* East Asian ideograph */
  {"\xA1", 0, 0x274831}, /* East Asian ideograph */
  {"\xA8", 0, 0x274855}, /* East Asian ideograph */
  {"\x9F", 0, 0x274859}, /* East Asian ideograph */
  {"\xA6", 0, 0x27486D}, /* East Asian ideograph */
  {"\xA7", 0, 0x27486E}, /* East Asian ideograph */
  {"\x9B", 0, 0x27492D}, /* East Asian ideograph */
  {"\xA9", 0, 0x27492E}, /* East Asian ideograph */
  {"\x9E", 0, 0x284971}, /* East Asian ideograph */
  {"\x9D", 0, 0x284D27}, /* East Asian ideograph */
  {"\xA0", 0, 0x284D49}, /* East Asian ideograph */
  {"\x99", 0, 0x4B4759}, /* East Asian ideograph */
  {"\xA3", 0, 0x4B4835}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page132 = {
  marc8r_31page132_flat, 0
};
/* PAGE 131 */
struct yaz_iconv_trie_flat marc8r_31page131_flat[] = {
  {"\x8B", 0, 0x21473C}, /* East Asian ideograph */
  {"\xB2", 0, 0x21473D}, /* East Asian ideograph */
  {"\xA5", 0, 0x21473E}, /* East Asian ideograph */
  {"\xB1", 0, 0x21473F}, /* East Asian ideograph */
  {"\xAA", 0, 0x214740}, /* East Asian ideograph */
  {"\x8C", 0, 0x214741}, /* East Asian ideograph */
  {"\x9E", 0, 0x214742}, /* East Asian ideograph */
  {"\x97", 0, 0x214743}, /* East Asian ideograph */
  {"\xBB", 0, 0x214744}, /* East Asian ideograph */
  {"\x9B", 0, 0x214745}, /* East Asian ideograph */
  {"\xB6", 0, 0x214746}, /* East Asian ideograph */
  {"\xBD", 0, 0x214747}, /* East Asian ideograph */
  {"\xBE", 0, 0x214748}, /* East Asian ideograph */
  {"\x9D", 0, 0x224837}, /* East Asian ideograph */
  {"\xA8", 0, 0x22483B}, /* East Asian ideograph */
  {"\xB9", 0, 0x224844}, /* East Asian ideograph */
  {"\xA6", 0, 0x22484D}, /* East Asian ideograph */
  {"\xA7", 0, 0x22484E}, /* East Asian ideograph */
  {"\x8F", 0, 0x22484F}, /* East Asian ideograph */
  {"\x8A", 0, 0x224850}, /* East Asian ideograph */
  {"\xBF", 0, 0x224851}, /* East Asian ideograph */
  {"\x87", 0, 0x22485A}, /* East Asian ideograph */
  {"\x84", 0, 0x22485B}, /* East Asian ideograph */
  {"\xAE", 0, 0x224860}, /* East Asian ideograph */
  {"\xB5", 0, 0x224861}, /* East Asian ideograph */
  {"\xBA", 0, 0x224862}, /* East Asian ideograph */
  {"\x99", 0, 0x224864}, /* East Asian ideograph */
  {"\x8E", 0, 0x224867}, /* East Asian ideograph */
  {"\xAB", 0, 0x22486A}, /* East Asian ideograph */
  {"\x91", 0, 0x22486B}, /* East Asian ideograph */
  {"\x80", 0, 0x22486C}, /* East Asian ideograph */
  {"\xA4", 0, 0x22486D}, /* East Asian ideograph */
  {"\xB3", 0, 0x22486F}, /* East Asian ideograph */
  {"\xB4", 0, 0x22492F}, /* East Asian ideograph (variant of EACC 34492F) */
  {"\x81", 0, 0x27486F}, /* East Asian ideograph */
  {"\x92", 0, 0x274941}, /* East Asian ideograph */
  {"\xBC", 0, 0x274F5C}, /* East Asian ideograph */
  {"\xA9", 0, 0x2D4729}, /* East Asian ideograph */
  {"\xB8", 0, 0x2E4D3D}, /* East Asian ideograph */
  {"\x9A", 0, 0x334740}, /* East Asian ideograph */
  {"\x9F", 0, 0x33474A}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page131 = {
  marc8r_31page131_flat, 0
};
/* PAGE 130 */
struct yaz_iconv_trie_flat marc8r_31page130_flat[] = {
  {"\x81", 0, 0x21473B}, /* East Asian ideograph */
  {"\xAA", 0, 0x214749}, /* East Asian ideograph */
  {"\xB8", 0, 0x21474B}, /* East Asian ideograph */
  {"\xA6", 0, 0x21474C}, /* East Asian ideograph */
  {"\x99", 0, 0x21474D}, /* East Asian ideograph */
  {"\xAC", 0, 0x214750}, /* East Asian ideograph */
  {"\xAE", 0, 0x214753}, /* East Asian ideograph */
  {"\xB4", 0, 0x214754}, /* East Asian ideograph */
  {"\x9A", 0, 0x214755}, /* East Asian ideograph */
  {"\xA9", 0, 0x214756}, /* East Asian ideograph */
  {"\xB7", 0, 0x214757}, /* East Asian ideograph */
  {"\xA3", 0, 0x224873}, /* East Asian ideograph */
  {"\xAD", 0, 0x224925}, /* East Asian ideograph */
  {"\xAF", 0, 0x224926}, /* East Asian ideograph */
  {"\xA1", 0, 0x224928}, /* East Asian ideograph */
  {"\xB9", 0, 0x224934}, /* East Asian ideograph */
  {"\xBF", 0, 0x224939}, /* East Asian ideograph */
  {"\xA5", 0, 0x22493C}, /* East Asian ideograph */
  {"\x9E", 0, 0x22493E}, /* East Asian ideograph */
  {"\xA7", 0, 0x224940}, /* East Asian ideograph */
  {"\xA0", 0, 0x224946}, /* East Asian ideograph */
  {"\xBC", 0, 0x22494B}, /* East Asian ideograph */
  {"\xB0", 0, 0x22494C}, /* East Asian ideograph */
  {"\x85", 0, 0x274768}, /* East Asian ideograph */
  {"\x8B", 0, 0x274830}, /* East Asian ideograph */
  {"\x91", 0, 0x274833}, /* East Asian ideograph */
  {"\x86", 0, 0x274863}, /* East Asian ideograph */
  {"\x87", 0, 0x274871}, /* East Asian ideograph */
  {"\x93", 0, 0x27487C}, /* East Asian ideograph */
  {"\x8A", 0, 0x274922}, /* East Asian ideograph */
  {"\x8E", 0, 0x274926}, /* East Asian ideograph */
  {"\x8F", 0, 0x274937}, /* East Asian ideograph */
  {"\x83", 0, 0x284934}, /* East Asian ideograph */
  {"\x88", 0, 0x284B28}, /* East Asian ideograph */
  {"\x92", 0, 0x284C2E}, /* East Asian ideograph */
  {"\x94", 0, 0x284D2B}, /* East Asian ideograph */
  {"\x8D", 0, 0x284E42}, /* East Asian ideograph */
  {"\xA4", 0, 0x2E4747}, /* East Asian ideograph */
  {"\x84", 0, 0x33476F}, /* East Asian ideograph */
  {"\x9C", 0, 0x394928}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page130 = {
  marc8r_31page130_flat, 0
};
/* PAGE 129 */
struct yaz_iconv_trie_flat marc8r_31page129_flat[] = {
  {"\xB3", 0, 0x21467E}, /* East Asian ideograph */
  {"\xA3", 0, 0x214721}, /* East Asian ideograph */
  {"\xB0", 0, 0x214722}, /* East Asian ideograph */
  {"\x93", 0, 0x214724}, /* East Asian ideograph */
  {"\xA5", 0, 0x214726}, /* East Asian ideograph */
  {"\x84", 0, 0x214729}, /* East Asian ideograph */
  {"\x95", 0, 0x21472A}, /* East Asian ideograph */
  {"\xA2", 0, 0x21472B}, /* East Asian ideograph */
  {"\xB1", 0, 0x21472F}, /* East Asian ideograph */
  {"\x81", 0, 0x214730}, /* East Asian ideograph */
  {"\x85", 0, 0x214732}, /* East Asian ideograph */
  {"\x97", 0, 0x214733}, /* East Asian ideograph */
  {"\x9B", 0, 0x214735}, /* East Asian ideograph */
  {"\xA1", 0, 0x214736}, /* East Asian ideograph */
  {"\x8A", 0, 0x214738}, /* East Asian ideograph */
  {"\x8C", 0, 0x214739}, /* East Asian ideograph */
  {"\x89", 0, 0x21473A}, /* East Asian ideograph */
  {"\xAB", 0, 0x224762}, /* East Asian ideograph */
  {"\xAE", 0, 0x224763}, /* East Asian ideograph */
  {"\x80", 0, 0x224764}, /* East Asian ideograph */
  {"\xAF", 0, 0x224766}, /* East Asian ideograph */
  {"\xB5", 0, 0x224772}, /* East Asian ideograph */
  {"\x82", 0, 0x22477D}, /* East Asian ideograph */
  {"\x98", 0, 0x224824}, /* East Asian ideograph */
  {"\x86", 0, 0x224826}, /* East Asian ideograph */
  {"\x8E", 0, 0x224828}, /* East Asian ideograph */
  {"\xA9", 0, 0x224829}, /* East Asian ideograph */
  {"\xB2", 0, 0x22482D}, /* East Asian ideograph */
  {"\xA0", 0, 0x22482F}, /* East Asian ideograph */
  {"\x91", 0, 0x224830}, /* East Asian ideograph */
  {"\x92", 0, 0x224832}, /* East Asian ideograph */
  {"\x9A", 0, 0x22485C}, /* East Asian ideograph */
  {"\xBE", 0, 0x27474E}, /* East Asian ideograph */
  {"\xAA", 0, 0x274759}, /* East Asian ideograph */
  {"\xBC", 0, 0x27486C}, /* East Asian ideograph */
  {"\xBD", 0, 0x274921}, /* East Asian ideograph */
  {"\x9E", 0, 0x274927}, /* East Asian ideograph */
  {"\xBB", 0, 0x274932}, /* East Asian ideograph */
  {"\xA8", 0, 0x27584C}, /* East Asian ideograph */
  {"\xB6", 0, 0x284E3E}, /* East Asian ideograph */
  {"\xB7", 0, 0x284F26}, /* East Asian ideograph */
  {"\xB8", 0, 0x284F39}, /* East Asian ideograph */
  {"\x90", 0, 0x2E4670}, /* East Asian ideograph */
  {"\x99", 0, 0x2E492F}, /* East Asian ideograph */
  {"\x94", 0, 0x2E6F35}, /* East Asian ideograph */
  {"\x9D", 0, 0x33483B}, /* East Asian ideograph */
  {"\x96", 0, 0x335461}, /* East Asian ideograph */
  {"\xBA", 0, 0x454738}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page129 = {
  marc8r_31page129_flat, 0
};
/* PAGE 128 */
struct yaz_iconv_trie_flat marc8r_31page128_flat[] = {
  {"\x9B", 0, 0x21466A}, /* East Asian ideograph */
  {"\x81", 0, 0x21466B}, /* East Asian ideograph */
  {"\x8C", 0, 0x21466F}, /* East Asian ideograph */
  {"\x90", 0, 0x214670}, /* East Asian ideograph */
  {"\x96", 0, 0x214674}, /* East Asian ideograph */
  {"\x89", 0, 0x214676}, /* East Asian ideograph (variant of EACC 4B4676) */
  {"\x99", 0, 0x214677}, /* East Asian ideograph */
  {"\x92", 0, 0x21467A}, /* East Asian ideograph */
  {"\x83", 0, 0x21467B}, /* East Asian ideograph */
  {"\xB1", 0, 0x21467C}, /* East Asian ideograph */
  {"\xB8", 0, 0x214723}, /* East Asian ideograph */
  {"\xAB", 0, 0x214725}, /* East Asian ideograph */
  {"\xBD", 0, 0x214727}, /* East Asian ideograph */
  {"\xB3", 0, 0x214728}, /* East Asian ideograph */
  {"\xBC", 0, 0x21472C}, /* East Asian ideograph */
  {"\xAE", 0, 0x21472D}, /* East Asian ideograph */
  {"\xB9", 0, 0x21472E}, /* East Asian ideograph */
  {"\xBE", 0, 0x214731}, /* East Asian ideograph */
  {"\xBB", 0, 0x214734}, /* East Asian ideograph */
  {"\xBF", 0, 0x214737}, /* East Asian ideograph */
  {"\x86", 0, 0x224732}, /* East Asian ideograph */
  {"\x84", 0, 0x22473B}, /* East Asian ideograph */
  {"\x94", 0, 0x22473E}, /* East Asian ideograph */
  {"\x8F", 0, 0x224740}, /* East Asian ideograph */
  {"\x9D", 0, 0x224749}, /* East Asian ideograph */
  {"\x9A", 0, 0x22474B}, /* East Asian ideograph */
  {"\x93", 0, 0x22474D}, /* East Asian ideograph */
  {"\x87", 0, 0x224751}, /* East Asian ideograph */
  {"\x95", 0, 0x224756}, /* East Asian ideograph */
  {"\x82", 0, 0x22475A}, /* East Asian ideograph */
  {"\xA0", 0, 0x22475C}, /* East Asian ideograph */
  {"\xAC", 0, 0x224767}, /* East Asian ideograph */
  {"\xAD", 0, 0x22476E}, /* East Asian ideograph (variant of EACC 4C476E) */
  {"\xAF", 0, 0x224770}, /* East Asian ideograph */
  {"\xBA", 0, 0x22477A}, /* East Asian ideograph */
  {"\xB4", 0, 0x224833}, /* East Asian ideograph */
  {"\xA6", 0, 0x274777}, /* East Asian ideograph */
  {"\x9F", 0, 0x27483D}, /* East Asian ideograph */
  {"\x85", 0, 0x274841}, /* East Asian ideograph */
  {"\xA7", 0, 0x274848}, /* East Asian ideograph */
  {"\xAA", 0, 0x27484F}, /* East Asian ideograph */
  {"\x88", 0, 0x274931}, /* East Asian ideograph */
  {"\xA5", 0, 0x27493B}, /* East Asian ideograph */
  {"\xA4", 0, 0x284C41}, /* East Asian ideograph */
  {"\xA9", 0, 0x284D58}, /* East Asian ideograph */
  {"\xA3", 0, 0x284F5D}, /* East Asian ideograph */
  {"\xB2", 0, 0x2D467C}, /* East Asian ideograph */
  {"\xA1", 0, 0x33467A}, /* East Asian ideograph */
  {"\xA2", 0, 0x4B4921}, /* East Asian ideograph */
  {"\x8D", 0, 0x4B6A26}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page128 = {
  marc8r_31page128_flat, 0
};
/* PAGE 127 */
struct yaz_iconv_trie_flat marc8r_31page127_flat[] = {
  {"\x81", 0, 0x21465E}, /* East Asian ideograph */
  {"\x80", 0, 0x214660}, /* East Asian ideograph */
  {"\x82", 0, 0x214661}, /* East Asian ideograph */
  {"\x9E", 0, 0x214662}, /* East Asian ideograph */
  {"\x97", 0, 0x214663}, /* East Asian ideograph */
  {"\x9F", 0, 0x214664}, /* East Asian ideograph */
  {"\x99", 0, 0x214665}, /* East Asian ideograph */
  {"\xA0", 0, 0x214666}, /* East Asian ideograph */
  {"\x95", 0, 0x214667}, /* East Asian ideograph */
  {"\x90", 0, 0x214668}, /* East Asian ideograph */
  {"\x9D", 0, 0x214669}, /* East Asian ideograph */
  {"\xBA", 0, 0x21466D}, /* East Asian ideograph */
  {"\xAA", 0, 0x21466E}, /* East Asian ideograph */
  {"\xB2", 0, 0x214671}, /* East Asian ideograph */
  {"\xB0", 0, 0x214672}, /* East Asian ideograph */
  {"\xA8", 0, 0x214673}, /* East Asian ideograph */
  {"\xBE", 0, 0x214678}, /* East Asian ideograph */
  {"\xBD", 0, 0x214679}, /* East Asian ideograph */
  {"\x86", 0, 0x224678}, /* East Asian ideograph */
  {"\x92", 0, 0x22467A}, /* East Asian ideograph */
  {"\xA2", 0, 0x22467B}, /* East Asian ideograph */
  {"\x8A", 0, 0x22467C}, /* East Asian ideograph */
  {"\x9C", 0, 0x224724}, /* East Asian ideograph */
  {"\x9B", 0, 0x224726}, /* East Asian ideograph */
  {"\x8D", 0, 0x224727}, /* East Asian ideograph */
  {"\x8B", 0, 0x22472B}, /* East Asian ideograph */
  {"\x94", 0, 0x22472C}, /* East Asian ideograph */
  {"\xA3", 0, 0x22472D}, /* East Asian ideograph */
  {"\xB8", 0, 0x224730}, /* East Asian ideograph */
  {"\xB4", 0, 0x224731}, /* East Asian ideograph */
  {"\xB6", 0, 0x224733}, /* East Asian ideograph */
  {"\xAC", 0, 0x224738}, /* East Asian ideograph */
  {"\xA7", 0, 0x224739}, /* East Asian ideograph */
  {"\xA5", 0, 0x224742}, /* East Asian ideograph */
  {"\xAF", 0, 0x224747}, /* East Asian ideograph */
  {"\xA9", 0, 0x22474A}, /* East Asian ideograph */
  {"\xAD", 0, 0x22474C}, /* East Asian ideograph */
  {"\xAE", 0, 0x224752}, /* East Asian ideograph */
  {"\x87", 0, 0x273451}, /* East Asian ideograph */
  {"\xA4", 0, 0x27482D}, /* East Asian ideograph */
  {"\x89", 0, 0x274857}, /* East Asian ideograph */
  {"\x8E", 0, 0x2D4735}, /* East Asian ideograph */
  {"\xB9", 0, 0x2D4746}, /* East Asian ideograph */
  {"\xB3", 0, 0x2E4731}, /* East Asian ideograph */
  {"\xA1", 0, 0x334665}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page127 = {
  marc8r_31page127_flat, 0
};
/* PAGE 126 */
struct yaz_iconv_trie_flat marc8r_31page126_flat[] = {
  {"\x8F", 0, 0x21464C}, /* East Asian ideograph */
  {"\x91", 0, 0x21464D}, /* East Asian ideograph */
  {"\x90", 0, 0x21464E}, /* East Asian ideograph */
  {"\x93", 0, 0x21464F}, /* East Asian ideograph */
  {"\x96", 0, 0x214650}, /* East Asian ideograph */
  {"\x9B", 0, 0x214651}, /* East Asian ideograph */
  {"\x9F", 0, 0x214652}, /* East Asian ideograph */
  {"\xA7", 0, 0x214653}, /* East Asian ideograph */
  {"\xA6", 0, 0x214654}, /* East Asian ideograph */
  {"\xA3", 0, 0x214655}, /* East Asian ideograph */
  {"\xA8", 0, 0x214656}, /* East Asian ideograph */
  {"\xA4", 0, 0x214657}, /* East Asian ideograph */
  {"\xAB", 0, 0x214658}, /* East Asian ideograph */
  {"\xAE", 0, 0x214659}, /* East Asian ideograph */
  {"\xB3", 0, 0x21465A}, /* East Asian ideograph */
  {"\xAF", 0, 0x21465B}, /* East Asian ideograph (variant of EACC 45465B) */
  {"\xB4", 0, 0x21465C}, /* East Asian ideograph */
  {"\xB8", 0, 0x21465D}, /* East Asian ideograph */
  {"\xB9", 0, 0x21643F}, /* East Asian ideograph */
  {"\x86", 0, 0x224644}, /* East Asian ideograph */
  {"\x84", 0, 0x224648}, /* East Asian ideograph */
  {"\x85", 0, 0x22464A}, /* East Asian ideograph */
  {"\x88", 0, 0x22464C}, /* East Asian ideograph */
  {"\x8C", 0, 0x224651}, /* East Asian ideograph */
  {"\x8D", 0, 0x224652}, /* East Asian ideograph */
  {"\x95", 0, 0x224659}, /* East Asian ideograph */
  {"\x98", 0, 0x22465A}, /* East Asian ideograph */
  {"\x99", 0, 0x22465B}, /* East Asian ideograph */
  {"\x9A", 0, 0x22465C}, /* East Asian ideograph */
  {"\x9D", 0, 0x22465E}, /* East Asian ideograph */
  {"\xA0", 0, 0x224660}, /* East Asian ideograph */
  {"\xA1", 0, 0x224662}, /* East Asian ideograph */
  {"\xAA", 0, 0x224664}, /* East Asian ideograph */
  {"\xAD", 0, 0x224666}, /* East Asian ideograph */
  {"\xB0", 0, 0x224667}, /* East Asian ideograph */
  {"\xAC", 0, 0x224668}, /* East Asian ideograph */
  {"\xB1", 0, 0x224669}, /* East Asian ideograph */
  {"\xBB", 0, 0x224670}, /* East Asian ideograph */
  {"\xBF", 0, 0x224674}, /* East Asian ideograph */
  {"\x94", 0, 0x274655}, /* East Asian ideograph */
  {"\xA2", 0, 0x274658}, /* East Asian ideograph */
  {"\x87", 0, 0x284651}, /* East Asian ideograph */
  {"\xA9", 0, 0x284668}, /* East Asian ideograph */
  {"\x82", 0, 0x2D4A60}, /* East Asian ideograph */
  {"\xB7", 0, 0x33333C}, /* East Asian ideograph */
  {"\xBE", 0, 0x394735}, /* East Asian ideograph */
  {"\x97", 0, 0x4B4655}, /* East Asian ideograph */
  {"\xB2", 0, 0x4B465A}, /* East Asian ideograph */
  {"\xBD", 0, 0x513B52}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page126 = {
  marc8r_31page126_flat, 0
};
/* PAGE 125 */
struct yaz_iconv_trie_flat marc8r_31page125_flat[] = {
  {"\x80", 0, 0x21463D}, /* East Asian ideograph */
  {"\x85", 0, 0x21463F}, /* East Asian ideograph */
  {"\x86", 0, 0x214640}, /* East Asian ideograph */
  {"\x8B", 0, 0x214641}, /* East Asian ideograph */
  {"\x8D", 0, 0x214642}, /* East Asian ideograph */
  {"\x8F", 0, 0x214643}, /* East Asian ideograph */
  {"\x92", 0, 0x214644}, /* East Asian ideograph */
  {"\x94", 0, 0x214646}, /* East Asian ideograph */
  {"\x97", 0, 0x214647}, /* East Asian ideograph */
  {"\x9B", 0, 0x214648}, /* East Asian ideograph */
  {"\xAB", 0, 0x214649}, /* East Asian ideograph */
  {"\xAF", 0, 0x21464A}, /* East Asian ideograph */
  {"\xBD", 0, 0x21464B}, /* East Asian ideograph */
  {"\x88", 0, 0x224554}, /* East Asian ideograph */
  {"\x96", 0, 0x22455B}, /* East Asian ideograph */
  {"\x9A", 0, 0x224560}, /* East Asian ideograph */
  {"\x9C", 0, 0x224562}, /* East Asian ideograph */
  {"\x9D", 0, 0x224563}, /* East Asian ideograph */
  {"\x9F", 0, 0x224565}, /* East Asian ideograph */
  {"\xA7", 0, 0x22456F}, /* East Asian ideograph */
  {"\xAA", 0, 0x224570}, /* East Asian ideograph */
  {"\xA8", 0, 0x224571}, /* East Asian ideograph */
  {"\xB6", 0, 0x22462A}, /* East Asian ideograph */
  {"\xB3", 0, 0x22462C}, /* East Asian ideograph */
  {"\xB8", 0, 0x224633}, /* East Asian ideograph */
  {"\xBA", 0, 0x224637}, /* East Asian ideograph */
  {"\xB9", 0, 0x224638}, /* East Asian ideograph */
  {"\xBF", 0, 0x224642}, /* East Asian ideograph */
  {"\x99", 0, 0x274257}, /* East Asian ideograph */
  {"\x95", 0, 0x274C33}, /* East Asian ideograph */
  {"\x82", 0, 0x275B52}, /* East Asian ideograph */
  {"\xB5", 0, 0x284642}, /* East Asian ideograph */
  {"\xA1", 0, 0x28464C}, /* East Asian ideograph */
  {"\x98", 0, 0x2D4647}, /* East Asian ideograph */
  {"\xAC", 0, 0x2D4B45}, /* East Asian ideograph */
  {"\x93", 0, 0x2D532C}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page125 = {
  marc8r_31page125_flat, 0
};
/* PAGE 124 */
struct yaz_iconv_trie_flat marc8r_31page124_flat[] = {
  {"\x83", 0, 0x21462F}, /* East Asian ideograph */
  {"\x86", 0, 0x214630}, /* East Asian ideograph */
  {"\x8A", 0, 0x214631}, /* East Asian ideograph */
  {"\x89", 0, 0x214632}, /* East Asian ideograph */
  {"\x98", 0, 0x214633}, /* East Asian ideograph */
  {"\x96", 0, 0x214634}, /* East Asian ideograph */
  {"\xA4", 0, 0x214635}, /* East Asian ideograph */
  {"\xAE", 0, 0x214636}, /* East Asian ideograph */
  {"\xAF", 0, 0x214637}, /* East Asian ideograph */
  {"\xB2", 0, 0x214638}, /* East Asian ideograph */
  {"\xB5", 0, 0x214639}, /* East Asian ideograph */
  {"\xB7", 0, 0x21463A}, /* East Asian ideograph */
  {"\xBA", 0, 0x21463B}, /* East Asian ideograph */
  {"\xBC", 0, 0x21463C}, /* East Asian ideograph */
  {"\xBF", 0, 0x21463E}, /* East Asian ideograph */
  {"\x82", 0, 0x224471}, /* East Asian ideograph */
  {"\x84", 0, 0x224473}, /* East Asian ideograph */
  {"\x8D", 0, 0x224479}, /* East Asian ideograph */
  {"\x95", 0, 0x22447B}, /* East Asian ideograph */
  {"\x99", 0, 0x224525}, /* East Asian ideograph */
  {"\x9B", 0, 0x224529}, /* East Asian ideograph */
  {"\xA3", 0, 0x224535}, /* East Asian ideograph */
  {"\xA2", 0, 0x224536}, /* East Asian ideograph */
  {"\xAA", 0, 0x224538}, /* East Asian ideograph */
  {"\xAB", 0, 0x224539}, /* East Asian ideograph */
  {"\xAD", 0, 0x22453B}, /* East Asian ideograph */
  {"\xB0", 0, 0x22453D}, /* East Asian ideograph */
  {"\xB3", 0, 0x22453F}, /* East Asian ideograph */
  {"\xBD", 0, 0x224547}, /* East Asian ideograph */
  {"\x8B", 0, 0x274633}, /* East Asian ideograph */
  {"\x87", 0, 0x274635}, /* East Asian ideograph */
  {"\x93", 0, 0x274636}, /* East Asian ideograph */
  {"\xA1", 0, 0x274637}, /* East Asian ideograph */
  {"\xB4", 0, 0x274640}, /* East Asian ideograph */
  {"\x9A", 0, 0x284539}, /* East Asian ideograph */
  {"\x80", 0, 0x2D3929}, /* East Asian ideograph */
  {"\xBB", 0, 0x33463C}, /* East Asian ideograph */
  {"\x9E", 0, 0x3F5F35}, /* East Asian ideograph */
  {"\x81", 0, 0x4B462E}, /* East Asian ideograph */
  {"\xB1", 0, 0x4B4638}, /* East Asian ideograph */
  {"\x92", 0, 0x4B5F35}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page124 = {
  marc8r_31page124_flat, 0
};
/* PAGE 123 */
struct yaz_iconv_trie_flat marc8r_31page123_flat[] = {
  {"\x87", 0, 0x214579}, /* East Asian ideograph */
  {"\x89", 0, 0x21457A}, /* East Asian ideograph */
  {"\x8C", 0, 0x21457B}, /* East Asian ideograph */
  {"\x90", 0, 0x21457C}, /* East Asian ideograph */
  {"\x99", 0, 0x21457D}, /* East Asian ideograph */
  {"\x9F", 0, 0x21457E}, /* East Asian ideograph */
  {"\xA1", 0, 0x214621}, /* East Asian ideograph */
  {"\xA3", 0, 0x214623}, /* East Asian ideograph */
  {"\xA4", 0, 0x214624}, /* East Asian ideograph */
  {"\xA5", 0, 0x214625}, /* East Asian ideograph */
  {"\xA6", 0, 0x214627}, /* East Asian ideograph */
  {"\xAA", 0, 0x214628}, /* East Asian ideograph */
  {"\xB2", 0, 0x214629}, /* East Asian ideograph */
  {"\xB7", 0, 0x21462A}, /* East Asian ideograph */
  {"\xB8", 0, 0x21462B}, /* East Asian ideograph */
  {"\xB9", 0, 0x21462C}, /* East Asian ideograph */
  {"\xBB", 0, 0x21462D}, /* East Asian ideograph */
  {"\xBF", 0, 0x21462E}, /* East Asian ideograph */
  {"\x86", 0, 0x224437}, /* East Asian ideograph */
  {"\x81", 0, 0x224438}, /* East Asian ideograph */
  {"\x80", 0, 0x22443A}, /* East Asian ideograph */
  {"\x82", 0, 0x22443B}, /* East Asian ideograph */
  {"\x83", 0, 0x22443C}, /* East Asian ideograph */
  {"\x88", 0, 0x22443E}, /* East Asian ideograph */
  {"\x8A", 0, 0x22443F}, /* East Asian ideograph */
  {"\x8E", 0, 0x224446}, /* East Asian ideograph (variant of EACC 4C4446) */
  {"\x97", 0, 0x22444A}, /* East Asian ideograph */
  {"\x94", 0, 0x22444C}, /* East Asian ideograph */
  {"\x95", 0, 0x22444E}, /* East Asian ideograph */
  {"\x9C", 0, 0x224451}, /* East Asian ideograph */
  {"\x9E", 0, 0x224453}, /* East Asian ideograph */
  {"\xA0", 0, 0x224454}, /* East Asian ideograph */
  {"\xAB", 0, 0x22445B}, /* East Asian ideograph */
  {"\xAC", 0, 0x22445D}, /* East Asian ideograph */
  {"\xAE", 0, 0x22445F}, /* East Asian ideograph */
  {"\xB1", 0, 0x224461}, /* East Asian ideograph */
  {"\xBE", 0, 0x22446B}, /* East Asian ideograph */
  {"\xBC", 0, 0x274638}, /* East Asian ideograph */
  {"\xA2", 0, 0x2D353C}, /* East Asian ideograph */
  {"\xBA", 0, 0x2D462C}, /* East Asian ideograph */
  {"\x9B", 0, 0x334256}, /* East Asian ideograph */
  {"\xAF", 0, 0x336321}, /* East Asian ideograph */
  {"\xA7", 0, 0x4B3B67}, /* East Asian ideograph */
  {"\x93", 0, 0x4B4621}, /* East Asian ideograph */
  {"\xB4", 0, 0x4B462A}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page123 = {
  marc8r_31page123_flat, 0
};
/* PAGE 122 */
struct yaz_iconv_trie_flat marc8r_31page122_flat[] = {
  {"\x84", 0, 0x21456E}, /* East Asian ideograph */
  {"\x8A", 0, 0x214570}, /* East Asian ideograph */
  {"\x96", 0, 0x214571}, /* East Asian ideograph */
  {"\xA1", 0, 0x214573}, /* East Asian ideograph */
  {"\xA3", 0, 0x214574}, /* East Asian ideograph */
  {"\xBE", 0, 0x214576}, /* East Asian ideograph */
  {"\xBA", 0, 0x214577}, /* East Asian ideograph */
  {"\xBD", 0, 0x214578}, /* East Asian ideograph */
  {"\x81", 0, 0x224352}, /* East Asian ideograph */
  {"\x83", 0, 0x224358}, /* East Asian ideograph */
  {"\x8D", 0, 0x22435F}, /* East Asian ideograph */
  {"\x89", 0, 0x224360}, /* East Asian ideograph */
  {"\x8E", 0, 0x224361}, /* East Asian ideograph */
  {"\x91", 0, 0x224367}, /* East Asian ideograph */
  {"\x99", 0, 0x22436D}, /* East Asian ideograph */
  {"\x97", 0, 0x22436E}, /* East Asian ideograph */
  {"\x9E", 0, 0x224372}, /* East Asian ideograph */
  {"\xAC", 0, 0x22437E}, /* East Asian ideograph */
  {"\xB5", 0, 0x22442A}, /* East Asian ideograph */
  {"\xB7", 0, 0x22442C}, /* East Asian ideograph */
  {"\xBB", 0, 0x22442D}, /* East Asian ideograph */
  {"\xB9", 0, 0x224432}, /* East Asian ideograph */
  {"\xBF", 0, 0x224435}, /* East Asian ideograph */
  {"\xB2", 0, 0x273F3C}, /* East Asian ideograph */
  {"\xA0", 0, 0x27457A}, /* East Asian ideograph (duplicate simplified) */
  {"\xA7", 0, 0x27457C}, /* East Asian ideograph */
  {"\xA4", 0, 0x27457E}, /* East Asian ideograph */
  {"\xA2", 0, 0x274621}, /* East Asian ideograph */
  {"\xB8", 0, 0x2D3642}, /* East Asian ideograph */
  {"\x9D", 0, 0x2D616A}, /* East Asian ideograph */
  {"\x92", 0, 0x394944}, /* East Asian ideograph */
  {"\x85", 0, 0x4C4359}, /* East Asian ideograph */
  {"\x9F", 0, 0x695D36}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page122 = {
  marc8r_31page122_flat, 0
};
/* PAGE 121 */
struct yaz_iconv_trie_flat marc8r_31page121_flat[] = {
  {"\x83", 0, 0x214565}, /* East Asian ideograph */
  {"\xA5", 0, 0x214569}, /* East Asian ideograph */
  {"\x9A", 0, 0x21456A}, /* East Asian ideograph */
  {"\x9D", 0, 0x21456B}, /* East Asian ideograph */
  {"\x9B", 0, 0x21456C}, /* East Asian ideograph */
  {"\x93", 0, 0x21456D}, /* East Asian ideograph */
  {"\xBB", 0, 0x21456F}, /* East Asian ideograph */
  {"\x88", 0, 0x224255}, /* East Asian ideograph */
  {"\x8A", 0, 0x224264}, /* East Asian ideograph */
  {"\xA6", 0, 0x224279}, /* East Asian ideograph */
  {"\xAD", 0, 0x22427E}, /* East Asian ideograph */
  {"\x8C", 0, 0x224325}, /* East Asian ideograph */
  {"\x91", 0, 0x224328}, /* East Asian ideograph */
  {"\x9F", 0, 0x224333}, /* East Asian ideograph */
  {"\x8D", 0, 0x224334}, /* East Asian ideograph */
  {"\x9E", 0, 0x224335}, /* East Asian ideograph */
  {"\xAC", 0, 0x224337}, /* East Asian ideograph */
  {"\xB3", 0, 0x224339}, /* East Asian ideograph */
  {"\xA7", 0, 0x22433A}, /* East Asian ideograph */
  {"\xAB", 0, 0x22433F}, /* East Asian ideograph */
  {"\xAA", 0, 0x224340}, /* East Asian ideograph */
  {"\xB1", 0, 0x224344}, /* East Asian ideograph */
  {"\xA8", 0, 0x224345}, /* East Asian ideograph */
  {"\xB5", 0, 0x224348}, /* East Asian ideograph */
  {"\xBD", 0, 0x22434E}, /* East Asian ideograph */
  {"\xBA", 0, 0x224350}, /* East Asian ideograph */
  {"\xB8", 0, 0x224359}, /* East Asian ideograph */
  {"\x89", 0, 0x2D4569}, /* East Asian ideograph */
  {"\x81", 0, 0x2E403D}, /* East Asian ideograph */
  {"\x82", 0, 0x39447D}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page121 = {
  marc8r_31page121_flat, 0
};
/* PAGE 120 */
struct yaz_iconv_trie_flat marc8r_31page120_flat[] = {
  {"\x80", 0, 0x21455E}, /* East Asian ideograph */
  {"\x94", 0, 0x21455F}, /* East Asian ideograph */
  {"\x84", 0, 0x214560}, /* East Asian ideograph */
  {"\xA2", 0, 0x214561}, /* East Asian ideograph */
  {"\x9C", 0, 0x214562}, /* East Asian ideograph */
  {"\xB8", 0, 0x214563}, /* East Asian ideograph */
  {"\xB3", 0, 0x214564}, /* East Asian ideograph */
  {"\xBB", 0, 0x214566}, /* East Asian ideograph */
  {"\xAC", 0, 0x214568}, /* East Asian ideograph */
  {"\xAF", 0, 0x223B7D}, /* East Asian ideograph */
  {"\x8D", 0, 0x224173}, /* East Asian ideograph */
  {"\xA8", 0, 0x224175}, /* East Asian ideograph */
  {"\xA5", 0, 0x224177}, /* East Asian ideograph */
  {"\x96", 0, 0x224179}, /* East Asian ideograph */
  {"\x89", 0, 0x224223}, /* East Asian ideograph */
  {"\x91", 0, 0x224224}, /* East Asian ideograph */
  {"\x9F", 0, 0x224226}, /* East Asian ideograph */
  {"\x92", 0, 0x22422A}, /* East Asian ideograph */
  {"\xA3", 0, 0x22422B}, /* East Asian ideograph */
  {"\x99", 0, 0x224234}, /* East Asian ideograph */
  {"\x9D", 0, 0x224235}, /* East Asian ideograph */
  {"\x9B", 0, 0x224237}, /* East Asian ideograph */
  {"\xA0", 0, 0x224242}, /* East Asian ideograph */
  {"\x90", 0, 0x224247}, /* East Asian ideograph */
  {"\x9E", 0, 0x224249}, /* East Asian ideograph */
  {"\x87", 0, 0x22424A}, /* East Asian ideograph */
  {"\x8E", 0, 0x22424B}, /* East Asian ideograph */
  {"\xAB", 0, 0x224251}, /* East Asian ideograph */
  {"\xAE", 0, 0x224257}, /* East Asian ideograph */
  {"\xBF", 0, 0x22425D}, /* East Asian ideograph */
  {"\xB4", 0, 0x224268}, /* East Asian ideograph */
  {"\x97", 0, 0x2D563F}, /* East Asian ideograph */
  {"\xA9", 0, 0x2E4174}, /* East Asian ideograph */
  {"\x98", 0, 0x4B563F}, /* East Asian ideograph */
  {"\xAA", 0, 0x4C4333}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page120 = {
  marc8r_31page120_flat, 0
};
/* PAGE 119 */
struct yaz_iconv_trie_flat marc8r_31page119_flat[] = {
  {"\x98", 0, 0x214551}, /* East Asian ideograph */
  {"\x99", 0, 0x214552}, /* East Asian ideograph */
  {"\xA2", 0, 0x214553}, /* East Asian ideograph */
  {"\x84", 0, 0x214554}, /* East Asian ideograph */
  {"\xAB", 0, 0x214556}, /* East Asian ideograph */
  {"\x87", 0, 0x214559}, /* East Asian ideograph */
  {"\xA1", 0, 0x21455A}, /* East Asian ideograph */
  {"\x8B", 0, 0x21455B}, /* East Asian ideograph */
  {"\x9F", 0, 0x21455D}, /* East Asian ideograph */
  {"\xA3", 0, 0x224129}, /* East Asian ideograph */
  {"\xA7", 0, 0x224137}, /* East Asian ideograph */
  {"\x83", 0, 0x224139}, /* East Asian ideograph */
  {"\x9A", 0, 0x22413C}, /* East Asian ideograph */
  {"\x88", 0, 0x224140}, /* East Asian ideograph */
  {"\x90", 0, 0x224141}, /* East Asian ideograph */
  {"\x92", 0, 0x224142}, /* East Asian ideograph */
  {"\xB2", 0, 0x224143}, /* East Asian ideograph */
  {"\xB7", 0, 0x224146}, /* East Asian ideograph */
  {"\x9B", 0, 0x224147}, /* East Asian ideograph */
  {"\x9E", 0, 0x22414A}, /* East Asian ideograph */
  {"\x9C", 0, 0x22414B}, /* East Asian ideograph */
  {"\x91", 0, 0x22414F}, /* East Asian ideograph */
  {"\x96", 0, 0x224151}, /* East Asian ideograph */
  {"\xBA", 0, 0x224156}, /* East Asian ideograph */
  {"\xA4", 0, 0x22416D}, /* East Asian ideograph */
  {"\xBD", 0, 0x22417E}, /* East Asian ideograph */
  {"\xBF", 0, 0x224222}, /* East Asian ideograph */
  {"\xBE", 0, 0x224236}, /* East Asian ideograph */
  {"\xB9", 0, 0x27456D}, /* East Asian ideograph */
  {"\xBC", 0, 0x284335}, /* East Asian ideograph */
  {"\xA6", 0, 0x2D3C5F}, /* East Asian ideograph */
  {"\xB1", 0, 0x4B4569}, /* East Asian ideograph */
  {"\xA5", 0, 0x4C433F}, /* East Asian ideograph */
  {"\xB8", 0, 0x695C71}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page119 = {
  marc8r_31page119_flat, 0
};
/* PAGE 118 */
struct yaz_iconv_trie_flat marc8r_31page118_flat[] = {
  {"\x9F", 0, 0x214542}, /* East Asian ideograph */
  {"\xA3", 0, 0x214544}, /* East Asian ideograph */
  {"\x81", 0, 0x214546}, /* East Asian ideograph */
  {"\x99", 0, 0x214547}, /* East Asian ideograph */
  {"\x9E", 0, 0x214549}, /* East Asian ideograph */
  {"\x93", 0, 0x21454A}, /* East Asian ideograph */
  {"\xA1", 0, 0x21454B}, /* East Asian ideograph */
  {"\x8A", 0, 0x21454D}, /* East Asian ideograph */
  {"\x82", 0, 0x21454E}, /* East Asian ideograph */
  {"\x85", 0, 0x21454F}, /* East Asian ideograph */
  {"\xBD", 0, 0x214550}, /* East Asian ideograph */
  {"\xB9", 0, 0x214555}, /* East Asian ideograph */
  {"\xBA", 0, 0x214557}, /* East Asian ideograph */
  {"\xB8", 0, 0x214558}, /* East Asian ideograph */
  {"\xB5", 0, 0x21455C}, /* East Asian ideograph */
  {"\x92", 0, 0x22403D}, /* East Asian ideograph */
  {"\x91", 0, 0x22403E}, /* East Asian ideograph */
  {"\x80", 0, 0x224041}, /* East Asian ideograph */
  {"\x8B", 0, 0x22404B}, /* East Asian ideograph */
  {"\x97", 0, 0x224054}, /* East Asian ideograph */
  {"\xAB", 0, 0x22405E}, /* East Asian ideograph */
  {"\xA0", 0, 0x224060}, /* East Asian ideograph */
  {"\x9B", 0, 0x224067}, /* East Asian ideograph */
  {"\xAD", 0, 0x224068}, /* East Asian ideograph */
  {"\x98", 0, 0x22406E}, /* East Asian ideograph */
  {"\x9D", 0, 0x224072}, /* East Asian ideograph */
  {"\x8C", 0, 0x224075}, /* East Asian ideograph */
  {"\x8F", 0, 0x224076}, /* East Asian ideograph */
  {"\x94", 0, 0x224128}, /* East Asian ideograph */
  {"\xB3", 0, 0x22413A}, /* East Asian ideograph */
  {"\xB2", 0, 0x22413B}, /* East Asian ideograph */
  {"\xA8", 0, 0x22413F}, /* East Asian ideograph */
  {"\xBE", 0, 0x224145}, /* East Asian ideograph */
  {"\xB6", 0, 0x224153}, /* East Asian ideograph */
  {"\xBF", 0, 0x224158}, /* East Asian ideograph */
  {"\xB1", 0, 0x27456F}, /* East Asian ideograph */
  {"\xAF", 0, 0x28422B}, /* East Asian ideograph */
  {"\xA2", 0, 0x2F252D}, /* East Asian ideograph */
  {"\x90", 0, 0x45456D}, /* East Asian ideograph */
  {"\xAA", 0, 0x4B4556}, /* East Asian ideograph */
  {"\xA9", 0, 0x4B4570}, /* East Asian ideograph */
  {"\xAE", 0, 0x695C53}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page118 = {
  marc8r_31page118_flat, 0
};
/* PAGE 117 */
struct yaz_iconv_trie_flat marc8r_31page117_flat[] = {
  {"\x81", 0, 0x214535}, /* East Asian ideograph */
  {"\x8B", 0, 0x214539}, /* East Asian ideograph */
  {"\x93", 0, 0x21453A}, /* East Asian ideograph */
  {"\x8C", 0, 0x21453D}, /* East Asian ideograph */
  {"\x90", 0, 0x21453F}, /* East Asian ideograph */
  {"\x8D", 0, 0x214540}, /* East Asian ideograph */
  {"\xA8", 0, 0x214543}, /* East Asian ideograph */
  {"\xAA", 0, 0x214545}, /* East Asian ideograph */
  {"\xBD", 0, 0x214548}, /* East Asian ideograph */
  {"\xB3", 0, 0x21454C}, /* East Asian ideograph */
  {"\x8E", 0, 0x223F50}, /* East Asian ideograph */
  {"\x8A", 0, 0x223F51}, /* East Asian ideograph */
  {"\x99", 0, 0x223F68}, /* East Asian ideograph */
  {"\x96", 0, 0x223F6D}, /* East Asian ideograph */
  {"\x91", 0, 0x223F78}, /* East Asian ideograph */
  {"\xB6", 0, 0x223F7A}, /* East Asian ideograph */
  {"\x95", 0, 0x223F7E}, /* East Asian ideograph */
  {"\x94", 0, 0x224034}, /* East Asian ideograph */
  {"\x83", 0, 0x224038}, /* East Asian ideograph */
  {"\xA6", 0, 0x224046}, /* East Asian ideograph */
  {"\xA5", 0, 0x22404C}, /* East Asian ideograph */
  {"\xA9", 0, 0x22404D}, /* East Asian ideograph */
  {"\xBC", 0, 0x224050}, /* East Asian ideograph */
  {"\xA7", 0, 0x224056}, /* East Asian ideograph */
  {"\xAB", 0, 0x224057}, /* East Asian ideograph */
  {"\xB1", 0, 0x22405B}, /* East Asian ideograph */
  {"\xBF", 0, 0x22405F}, /* East Asian ideograph */
  {"\xAD", 0, 0x224064}, /* East Asian ideograph */
  {"\xAE", 0, 0x22407C}, /* East Asian ideograph */
  {"\xB0", 0, 0x224123}, /* East Asian ideograph */
  {"\xB2", 0, 0x224124}, /* East Asian ideograph */
  {"\xB9", 0, 0x22416C}, /* East Asian ideograph */
  {"\x9F", 0, 0x274564}, /* East Asian ideograph */
  {"\x9B", 0, 0x274566}, /* East Asian ideograph */
  {"\xA0", 0, 0x28433A}, /* East Asian ideograph */
  {"\x85", 0, 0x2D4444}, /* East Asian ideograph */
  {"\xA3", 0, 0x2E3645}, /* East Asian ideograph */
  {"\xBB", 0, 0x395829}, /* East Asian ideograph */
  {"\x98", 0, 0x4B4544}, /* East Asian ideograph */
  {"\x87", 0, 0x4C3F68}, /* East Asian ideograph */
  {"\x9E", 0, 0x4C4339}, /* East Asian ideograph */
  {"\x9D", 0, 0x695C4F}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page117 = {
  marc8r_31page117_flat, 0
};
/* PAGE 116 */
struct yaz_iconv_trie_flat marc8r_31page116_flat[] = {
  {"\x86", 0, 0x214530}, /* East Asian ideograph */
  {"\xA8", 0, 0x214531}, /* East Asian ideograph */
  {"\x95", 0, 0x214532}, /* East Asian ideograph */
  {"\x9C", 0, 0x214533}, /* East Asian ideograph */
  {"\x94", 0, 0x214534}, /* East Asian ideograph */
  {"\xB7", 0, 0x214536}, /* East Asian ideograph */
  {"\xAE", 0, 0x214537}, /* East Asian ideograph */
  {"\x9B", 0, 0x214538}, /* East Asian ideograph */
  {"\xBB", 0, 0x21453B}, /* East Asian ideograph */
  {"\xAB", 0, 0x21453C}, /* East Asian ideograph */
  {"\xAD", 0, 0x21453E}, /* East Asian ideograph */
  {"\xB4", 0, 0x214541}, /* East Asian ideograph */
  {"\x80", 0, 0x223E7D}, /* East Asian ideograph */
  {"\x85", 0, 0x223F2D}, /* East Asian ideograph */
  {"\x8A", 0, 0x223F44}, /* East Asian ideograph */
  {"\xA0", 0, 0x223F45}, /* East Asian ideograph */
  {"\xB1", 0, 0x223F46}, /* East Asian ideograph */
  {"\x8D", 0, 0x223F59}, /* East Asian ideograph */
  {"\x91", 0, 0x223F5A}, /* East Asian ideograph */
  {"\xAA", 0, 0x223F5C}, /* East Asian ideograph */
  {"\xBC", 0, 0x223F60}, /* East Asian ideograph */
  {"\xA7", 0, 0x223F61}, /* East Asian ideograph */
  {"\x9E", 0, 0x223F65}, /* East Asian ideograph */
  {"\x8E", 0, 0x223F6A}, /* East Asian ideograph */
  {"\xA5", 0, 0x223F75}, /* East Asian ideograph */
  {"\xBE", 0, 0x223F77}, /* East Asian ideograph */
  {"\xBF", 0, 0x224027}, /* East Asian ideograph */
  {"\xA3", 0, 0x22402D}, /* East Asian ideograph */
  {"\xA4", 0, 0x22402E}, /* East Asian ideograph */
  {"\x96", 0, 0x22454D}, /* East Asian ideograph */
  {"\x88", 0, 0x27456A}, /* East Asian ideograph */
  {"\x84", 0, 0x274571}, /* East Asian ideograph */
  {"\x87", 0, 0x284337}, /* East Asian ideograph */
  {"\x89", 0, 0x284359}, /* East Asian ideograph */
  {"\x98", 0, 0x2D4E24}, /* East Asian ideograph */
  {"\xB2", 0, 0x2E3F2D}, /* East Asian ideograph */
  {"\xA6", 0, 0x45304C}, /* East Asian ideograph */
  {"\x82", 0, 0x4B4545}, /* East Asian ideograph */
  {"\x81", 0, 0x695C43}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page116 = {
  marc8r_31page116_flat, 0
};
/* PAGE 115 */
struct yaz_iconv_trie_flat marc8r_31page115_flat[] = {
  {"\x94", 0, 0x214523}, /* East Asian ideograph */
  {"\xB7", 0, 0x214525}, /* East Asian ideograph */
  {"\xB5", 0, 0x214526}, /* East Asian ideograph */
  {"\x9A", 0, 0x214527}, /* East Asian ideograph */
  {"\xA0", 0, 0x214528}, /* East Asian ideograph */
  {"\xAB", 0, 0x214529}, /* East Asian ideograph */
  {"\x8A", 0, 0x21452A}, /* East Asian ideograph */
  {"\xA8", 0, 0x21452B}, /* East Asian ideograph */
  {"\x9E", 0, 0x21452C}, /* East Asian ideograph */
  {"\xAD", 0, 0x21452D}, /* East Asian ideograph */
  {"\xB9", 0, 0x21452E}, /* East Asian ideograph */
  {"\x93", 0, 0x21452F}, /* East Asian ideograph */
  {"\xB4", 0, 0x223E53}, /* East Asian ideograph */
  {"\xA2", 0, 0x223E58}, /* East Asian ideograph */
  {"\x98", 0, 0x223E5D}, /* East Asian ideograph */
  {"\x97", 0, 0x223E5F}, /* East Asian ideograph */
  {"\xB1", 0, 0x223E61}, /* East Asian ideograph */
  {"\x85", 0, 0x223E64}, /* East Asian ideograph */
  {"\x9D", 0, 0x223E65}, /* East Asian ideograph */
  {"\xAE", 0, 0x223E69}, /* East Asian ideograph */
  {"\xA3", 0, 0x223E6A}, /* East Asian ideograph */
  {"\x88", 0, 0x223E6B}, /* East Asian ideograph */
  {"\xAA", 0, 0x223E70}, /* East Asian ideograph */
  {"\xAC", 0, 0x223E7A}, /* East Asian ideograph */
  {"\x8E", 0, 0x223E7B}, /* East Asian ideograph */
  {"\x92", 0, 0x223F21}, /* East Asian ideograph */
  {"\x9B", 0, 0x223F25}, /* East Asian ideograph */
  {"\xB8", 0, 0x223F35}, /* East Asian ideograph */
  {"\xBB", 0, 0x223F37}, /* East Asian ideograph */
  {"\xA9", 0, 0x223F3B}, /* East Asian ideograph */
  {"\x84", 0, 0x223F3D}, /* East Asian ideograph */
  {"\xAF", 0, 0x223F3E}, /* East Asian ideograph */
  {"\xBC", 0, 0x27454A}, /* East Asian ideograph */
  {"\xA6", 0, 0x283F30}, /* East Asian ideograph */
  {"\x82", 0, 0x2D443A}, /* East Asian ideograph */
  {"\xB3", 0, 0x2D4466}, /* East Asian ideograph */
  {"\xBD", 0, 0x2D454E}, /* East Asian ideograph */
  {"\x99", 0, 0x2D5468}, /* East Asian ideograph */
  {"\x95", 0, 0x4B4553}, /* East Asian ideograph */
  {"\x9C", 0, 0x4B533B}, /* East Asian ideograph */
  {"\xBE", 0, 0x695C39}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page115 = {
  marc8r_31page115_flat, 0
};
/* PAGE 114 */
struct yaz_iconv_trie_flat marc8r_31page114_flat[] = {
  {"\x8D", 0, 0x214474}, /* East Asian ideograph */
  {"\x85", 0, 0x214475}, /* East Asian ideograph */
  {"\x92", 0, 0x21447C}, /* East Asian ideograph */
  {"\x8E", 0, 0x214521}, /* East Asian ideograph */
  {"\xB0", 0, 0x214524}, /* East Asian ideograph */
  {"\xAC", 0, 0x223D50}, /* East Asian ideograph */
  {"\x97", 0, 0x223D51}, /* East Asian ideograph */
  {"\x8C", 0, 0x223D53}, /* East Asian ideograph */
  {"\x8B", 0, 0x223D56}, /* East Asian ideograph */
  {"\x84", 0, 0x223D59}, /* East Asian ideograph */
  {"\x8A", 0, 0x223D5B}, /* East Asian ideograph */
  {"\x89", 0, 0x223D5C}, /* East Asian ideograph */
  {"\xA9", 0, 0x223D5D}, /* East Asian ideograph */
  {"\xAA", 0, 0x223D63}, /* East Asian ideograph */
  {"\x90", 0, 0x223D6A}, /* East Asian ideograph */
  {"\x93", 0, 0x223D7C}, /* East Asian ideograph */
  {"\x87", 0, 0x223E21}, /* East Asian ideograph */
  {"\x9A", 0, 0x223E23}, /* East Asian ideograph */
  {"\x99", 0, 0x223E24}, /* East Asian ideograph */
  {"\x9B", 0, 0x223E2B}, /* East Asian ideograph */
  {"\x88", 0, 0x223E39}, /* East Asian ideograph */
  {"\x91", 0, 0x223E44}, /* East Asian ideograph */
  {"\xB8", 0, 0x223E55}, /* East Asian ideograph */
  {"\xBF", 0, 0x223E60}, /* East Asian ideograph */
  {"\xB2", 0, 0x223E66}, /* East Asian ideograph */
  {"\xB9", 0, 0x223E6E}, /* East Asian ideograph */
  {"\xB7", 0, 0x223E73}, /* East Asian ideograph */
  {"\xB3", 0, 0x223E7E}, /* East Asian ideograph */
  {"\xBD", 0, 0x223F32}, /* East Asian ideograph */
  {"\xB4", 0, 0x223F3A}, /* East Asian ideograph */
  {"\xAD", 0, 0x274553}, /* East Asian ideograph */
  {"\x9F", 0, 0x27456B}, /* East Asian ideograph */
  {"\xA0", 0, 0x284056}, /* East Asian ideograph */
  {"\xA4", 0, 0x284366}, /* East Asian ideograph */
  {"\xB6", 0, 0x2D446B}, /* East Asian ideograph */
  {"\x81", 0, 0x2D4543}, /* East Asian ideograph */
  {"\xBE", 0, 0x2D502B}, /* East Asian ideograph */
  {"\x8F", 0, 0x2E3B22}, /* East Asian ideograph */
  {"\x98", 0, 0x334527}, /* East Asian ideograph */
  {"\x80", 0, 0x346126}, /* East Asian ideograph */
  {"\x9C", 0, 0x4B4561}, /* East Asian ideograph */
  {"\xA2", 0, 0x4C3F7A}, /* East Asian ideograph */
  {"\xA6", 0, 0x695B7B}, /* East Asian ideograph */
  {"\xA5", 0, 0x695C29}, /* East Asian ideograph */
  {"\xA8", 0, 0x695C2D}, /* East Asian ideograph */
  {"\xA3", 0, 0x695C30}, /* East Asian ideograph */
  {"\xA1", 0, 0x695C31}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page114 = {
  marc8r_31page114_flat, 0
};
/* PAGE 113 */
struct yaz_iconv_trie_flat marc8r_31page113_flat[] = {
  {"\x95", 0, 0x21446B}, /* East Asian ideograph */
  {"\xBA", 0, 0x21446C}, /* East Asian ideograph */
  {"\x84", 0, 0x21446D}, /* East Asian ideograph */
  {"\xB2", 0, 0x21446E}, /* East Asian ideograph */
  {"\x92", 0, 0x21446F}, /* East Asian ideograph */
  {"\xA3", 0, 0x214470}, /* East Asian ideograph */
  {"\x9F", 0, 0x214471}, /* East Asian ideograph */
  {"\x8B", 0, 0x214472}, /* East Asian ideograph */
  {"\xAE", 0, 0x214473}, /* East Asian ideograph */
  {"\xA7", 0, 0x214476}, /* East Asian ideograph */
  {"\xA0", 0, 0x214477}, /* East Asian ideograph */
  {"\xB5", 0, 0x214478}, /* East Asian ideograph */
  {"\x8D", 0, 0x214479}, /* East Asian ideograph */
  {"\x97", 0, 0x21447A}, /* East Asian ideograph */
  {"\x98", 0, 0x21447B}, /* East Asian ideograph */
  {"\xB9", 0, 0x21447D}, /* East Asian ideograph */
  {"\x9A", 0, 0x21447E}, /* East Asian ideograph */
  {"\x89", 0, 0x214522}, /* East Asian ideograph */
  {"\x93", 0, 0x223D58}, /* East Asian ideograph */
  {"\xAC", 0, 0x223D62}, /* East Asian ideograph */
  {"\xAA", 0, 0x223D64}, /* East Asian ideograph */
  {"\x96", 0, 0x223D6E}, /* East Asian ideograph */
  {"\xAB", 0, 0x223D6F}, /* East Asian ideograph */
  {"\xB1", 0, 0x223D73}, /* East Asian ideograph */
  {"\xBD", 0, 0x223D78}, /* East Asian ideograph */
  {"\xBC", 0, 0x223D79}, /* East Asian ideograph */
  {"\xB3", 0, 0x223D7B}, /* East Asian ideograph */
  {"\x9E", 0, 0x223E2A}, /* East Asian ideograph */
  {"\xBB", 0, 0x223E2D}, /* East Asian ideograph */
  {"\xA1", 0, 0x223E33}, /* East Asian ideograph */
  {"\x91", 0, 0x223E37}, /* East Asian ideograph */
  {"\x90", 0, 0x223E38}, /* East Asian ideograph */
  {"\xA8", 0, 0x223E3E}, /* East Asian ideograph */
  {"\xB0", 0, 0x223E3F}, /* East Asian ideograph */
  {"\x83", 0, 0x223E40}, /* East Asian ideograph */
  {"\x94", 0, 0x223E46}, /* East Asian ideograph */
  {"\xAF", 0, 0x223E47}, /* East Asian ideograph */
  {"\x86", 0, 0x223E49}, /* East Asian ideograph */
  {"\x87", 0, 0x223E4B}, /* East Asian ideograph */
  {"\x80", 0, 0x274561}, /* East Asian ideograph */
  {"\x82", 0, 0x284350}, /* East Asian ideograph */
  {"\x8A", 0, 0x2D4472}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page113 = {
  marc8r_31page113_flat, 0
};
/* PAGE 112 */
struct yaz_iconv_trie_flat marc8r_31page112_flat[] = {
  {"\x81", 0, 0x214457}, /* East Asian ideograph */
  {"\x93", 0, 0x214458}, /* East Asian ideograph */
  {"\xAF", 0, 0x214459}, /* East Asian ideograph */
  {"\xB0", 0, 0x21445B}, /* East Asian ideograph */
  {"\xA7", 0, 0x21445C}, /* East Asian ideograph */
  {"\x97", 0, 0x21445D}, /* East Asian ideograph */
  {"\xB5", 0, 0x21445E}, /* East Asian ideograph */
  {"\xB3", 0, 0x21445F}, /* East Asian ideograph */
  {"\xA2", 0, 0x214460}, /* East Asian ideograph */
  {"\xB1", 0, 0x214462}, /* East Asian ideograph */
  {"\x9D", 0, 0x214463}, /* East Asian ideograph */
  {"\xAD", 0, 0x214464}, /* East Asian ideograph */
  {"\x86", 0, 0x214465}, /* East Asian ideograph */
  {"\x85", 0, 0x214466}, /* East Asian ideograph */
  {"\xA8", 0, 0x214467}, /* East Asian ideograph */
  {"\x9F", 0, 0x214468}, /* East Asian ideograph */
  {"\x94", 0, 0x214469}, /* East Asian ideograph */
  {"\x83", 0, 0x21446A}, /* East Asian ideograph */
  {"\xB2", 0, 0x223C6E}, /* East Asian ideograph */
  {"\x9B", 0, 0x223C71}, /* East Asian ideograph */
  {"\xB6", 0, 0x223C74}, /* East Asian ideograph */
  {"\x82", 0, 0x223C76}, /* East Asian ideograph */
  {"\x90", 0, 0x223C7A}, /* East Asian ideograph */
  {"\x9C", 0, 0x223D22}, /* East Asian ideograph */
  {"\xA9", 0, 0x223D2E}, /* East Asian ideograph */
  {"\x98", 0, 0x223D30}, /* East Asian ideograph */
  {"\x8B", 0, 0x223D32}, /* East Asian ideograph */
  {"\xA0", 0, 0x223D33}, /* East Asian ideograph */
  {"\xA3", 0, 0x223D39}, /* East Asian ideograph */
  {"\x8F", 0, 0x223D40}, /* East Asian ideograph */
  {"\x8E", 0, 0x223D44}, /* East Asian ideograph */
  {"\xB4", 0, 0x223D4B}, /* East Asian ideograph */
  {"\xA5", 0, 0x22697E}, /* East Asian ideograph */
  {"\xA6", 0, 0x273924}, /* East Asian ideograph */
  {"\xBC", 0, 0x284257}, /* East Asian ideograph */
  {"\xB9", 0, 0x2D4564}, /* East Asian ideograph */
  {"\xBA", 0, 0x4B6258}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page112 = {
  marc8r_31page112_flat, 0
};
/* PAGE 111 */
struct yaz_iconv_trie_flat marc8r_31page111_flat[] = {
  {"\x88", 0, 0x214442}, /* East Asian ideograph */
  {"\x93", 0, 0x214445}, /* East Asian ideograph */
  {"\x86", 0, 0x214446}, /* East Asian ideograph */
  {"\x82", 0, 0x214447}, /* East Asian ideograph */
  {"\x94", 0, 0x214448}, /* East Asian ideograph */
  {"\x91", 0, 0x21444B}, /* East Asian ideograph */
  {"\x90", 0, 0x21444D}, /* East Asian ideograph */
  {"\x83", 0, 0x214451}, /* East Asian ideograph */
  {"\x80", 0, 0x214452}, /* East Asian ideograph */
  {"\x85", 0, 0x214454}, /* East Asian ideograph */
  {"\xB6", 0, 0x21445A}, /* East Asian ideograph */
  {"\xBF", 0, 0x214461}, /* East Asian ideograph */
  {"\x89", 0, 0x223C30}, /* East Asian ideograph */
  {"\x8B", 0, 0x223C37}, /* East Asian ideograph */
  {"\x8E", 0, 0x223C44}, /* East Asian ideograph */
  {"\x8D", 0, 0x223C4A}, /* East Asian ideograph */
  {"\x84", 0, 0x223C4F}, /* East Asian ideograph */
  {"\x9D", 0, 0x223C55}, /* East Asian ideograph */
  {"\x9E", 0, 0x223C56}, /* East Asian ideograph */
  {"\x9A", 0, 0x223C65}, /* East Asian ideograph */
  {"\xAB", 0, 0x223C68}, /* East Asian ideograph */
  {"\xAC", 0, 0x223C69}, /* East Asian ideograph */
  {"\xB9", 0, 0x223C6B}, /* East Asian ideograph */
  {"\xBE", 0, 0x223C72}, /* East Asian ideograph */
  {"\xB2", 0, 0x223D21}, /* East Asian ideograph */
  {"\xAD", 0, 0x223D25}, /* East Asian ideograph */
  {"\xAF", 0, 0x223D34}, /* East Asian ideograph */
  {"\xB4", 0, 0x223D3B}, /* East Asian ideograph */
  {"\xB5", 0, 0x223D3C}, /* East Asian ideograph */
  {"\xB7", 0, 0x223D3F}, /* East Asian ideograph */
  {"\xBB", 0, 0x223D43}, /* East Asian ideograph */
  {"\xA2", 0, 0x27452B}, /* East Asian ideograph */
  {"\xA9", 0, 0x274546}, /* East Asian ideograph */
  {"\xA8", 0, 0x27454C}, /* East Asian ideograph */
  {"\xA6", 0, 0x274557}, /* East Asian ideograph */
  {"\xA5", 0, 0x27455B}, /* East Asian ideograph */
  {"\xA3", 0, 0x27455F}, /* East Asian ideograph */
  {"\xA7", 0, 0x274562}, /* East Asian ideograph */
  {"\xA4", 0, 0x284027}, /* East Asian ideograph */
  {"\xA1", 0, 0x284140}, /* East Asian ideograph */
  {"\xAE", 0, 0x2D4425}, /* East Asian ideograph */
  {"\x92", 0, 0x2D444B}, /* East Asian ideograph */
  {"\x8C", 0, 0x2D447D}, /* East Asian ideograph */
  {"\x81", 0, 0x2D5440}, /* East Asian ideograph */
  {"\x8A", 0, 0x2E3D62}, /* East Asian ideograph */
  {"\x95", 0, 0x3A4034}, /* East Asian ideograph */
  {"\x9F", 0, 0x4B4476}, /* East Asian ideograph */
  {"\x9C", 0, 0x4B456F}, /* East Asian ideograph */
  {"\x99", 0, 0x4C3A5B}, /* East Asian ideograph */
  {"\xA0", 0, 0x4C3B22}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page111 = {
  marc8r_31page111_flat, 0
};
/* PAGE 110 */
struct yaz_iconv_trie_flat marc8r_31page110_flat[] = {
  {"\x85", 0, 0x21443D}, /* East Asian ideograph */
  {"\xA1", 0, 0x214443}, /* East Asian ideograph */
  {"\xB8", 0, 0x214444}, /* East Asian ideograph */
  {"\x97", 0, 0x214449}, /* East Asian ideograph */
  {"\xBD", 0, 0x21444A}, /* East Asian ideograph */
  {"\xA9", 0, 0x21444C}, /* East Asian ideograph */
  {"\xB9", 0, 0x21444E}, /* East Asian ideograph */
  {"\xAA", 0, 0x214453}, /* East Asian ideograph */
  {"\xBC", 0, 0x214455}, /* East Asian ideograph */
  {"\x93", 0, 0x214456}, /* East Asian ideograph (variant of EACC 4B4456) */
  {"\x90", 0, 0x223B4E}, /* East Asian ideograph */
  {"\x83", 0, 0x223B60}, /* East Asian ideograph */
  {"\x82", 0, 0x223B6D}, /* East Asian ideograph */
  {"\x86", 0, 0x223B78}, /* East Asian ideograph */
  {"\xBE", 0, 0x223C31}, /* East Asian ideograph */
  {"\x94", 0, 0x223C36}, /* East Asian ideograph */
  {"\x9E", 0, 0x223C38}, /* East Asian ideograph */
  {"\xB3", 0, 0x223C3B}, /* East Asian ideograph */
  {"\xB1", 0, 0x223C40}, /* East Asian ideograph */
  {"\xB2", 0, 0x223C41}, /* East Asian ideograph */
  {"\xB5", 0, 0x223C42}, /* East Asian ideograph */
  {"\xBB", 0, 0x223C43}, /* East Asian ideograph */
  {"\xAB", 0, 0x223C47}, /* East Asian ideograph */
  {"\xAD", 0, 0x223C48}, /* East Asian ideograph */
  {"\xB4", 0, 0x223C58}, /* East Asian ideograph */
  {"\x92", 0, 0x223C59}, /* East Asian ideograph */
  {"\x9F", 0, 0x223D65}, /* East Asian ideograph */
  {"\x80", 0, 0x274469}, /* East Asian ideograph */
  {"\x96", 0, 0x27446E}, /* East Asian ideograph */
  {"\x8B", 0, 0x274471}, /* East Asian ideograph */
  {"\x88", 0, 0x274476}, /* East Asian ideograph */
  {"\xB7", 0, 0x274544}, /* East Asian ideograph */
  {"\x87", 0, 0x274547}, /* East Asian ideograph */
  {"\x91", 0, 0x274555}, /* East Asian ideograph */
  {"\x89", 0, 0x27456C}, /* East Asian ideograph */
  {"\x8F", 0, 0x27456E}, /* East Asian ideograph */
  {"\x8E", 0, 0x284333}, /* East Asian ideograph */
  {"\x8A", 0, 0x284339}, /* East Asian ideograph */
  {"\x8C", 0, 0x284345}, /* East Asian ideograph */
  {"\xA2", 0, 0x2D4440}, /* East Asian ideograph */
  {"\x9D", 0, 0x2D4562}, /* East Asian ideograph */
  {"\x84", 0, 0x4B4537}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page110 = {
  marc8r_31page110_flat, 0
};
/* PAGE 109 */
struct yaz_iconv_trie_flat marc8r_31page109_flat[] = {
  {"\x93", 0, 0x21442E}, /* East Asian ideograph */
  {"\xB1", 0, 0x21442F}, /* East Asian ideograph */
  {"\xBF", 0, 0x214430}, /* East Asian ideograph */
  {"\x94", 0, 0x214431}, /* East Asian ideograph */
  {"\x84", 0, 0x214432}, /* East Asian ideograph */
  {"\x90", 0, 0x214434}, /* East Asian ideograph */
  {"\x91", 0, 0x214435}, /* East Asian ideograph */
  {"\xAF", 0, 0x214436}, /* East Asian ideograph */
  {"\xA9", 0, 0x214437}, /* East Asian ideograph */
  {"\xAC", 0, 0x214439}, /* East Asian ideograph */
  {"\xA5", 0, 0x21443A}, /* East Asian ideograph */
  {"\xBA", 0, 0x21443B}, /* East Asian ideograph */
  {"\x9A", 0, 0x21443C}, /* East Asian ideograph */
  {"\x9E", 0, 0x21443E}, /* East Asian ideograph */
  {"\x8F", 0, 0x214440}, /* East Asian ideograph */
  {"\xB3", 0, 0x214441}, /* East Asian ideograph */
  {"\xB4", 0, 0x214450}, /* East Asian ideograph */
  {"\xB9", 0, 0x223B44}, /* East Asian ideograph */
  {"\xBC", 0, 0x223B4C}, /* East Asian ideograph */
  {"\x88", 0, 0x223B51}, /* East Asian ideograph */
  {"\x8C", 0, 0x223B54}, /* East Asian ideograph */
  {"\x85", 0, 0x223B58}, /* East Asian ideograph */
  {"\xB8", 0, 0x223B61}, /* East Asian ideograph */
  {"\x98", 0, 0x223B63}, /* East Asian ideograph */
  {"\xA4", 0, 0x223B6F}, /* East Asian ideograph */
  {"\x99", 0, 0x223B70}, /* East Asian ideograph */
  {"\x9B", 0, 0x223B71}, /* East Asian ideograph */
  {"\x9F", 0, 0x223B74}, /* East Asian ideograph */
  {"\xB7", 0, 0x223B75}, /* East Asian ideograph */
  {"\xB6", 0, 0x223B7A}, /* East Asian ideograph */
  {"\xAE", 0, 0x223B7C}, /* East Asian ideograph */
  {"\x82", 0, 0x223C23}, /* East Asian ideograph */
  {"\xA3", 0, 0x223C24}, /* East Asian ideograph */
  {"\x8A", 0, 0x223C26}, /* East Asian ideograph */
  {"\x8E", 0, 0x223C28}, /* East Asian ideograph */
  {"\xA2", 0, 0x223C29}, /* East Asian ideograph */
  {"\xB2", 0, 0x223C2A}, /* East Asian ideograph */
  {"\x83", 0, 0x223C2B}, /* East Asian ideograph */
  {"\x9D", 0, 0x223C2D}, /* East Asian ideograph */
  {"\xA7", 0, 0x223C2F}, /* East Asian ideograph */
  {"\xA0", 0, 0x274563}, /* East Asian ideograph */
  {"\x9C", 0, 0x274565}, /* East Asian ideograph */
  {"\xBD", 0, 0x28405E}, /* East Asian ideograph */
  {"\xB0", 0, 0x2D3931}, /* East Asian ideograph */
  {"\x86", 0, 0x2D4039}, /* East Asian ideograph */
  {"\xBE", 0, 0x2D4437}, /* East Asian ideograph */
  {"\x92", 0, 0x33485E}, /* East Asian ideograph */
  {"\x81", 0, 0x335445}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page109 = {
  marc8r_31page109_flat, 0
};
/* PAGE 108 */
struct yaz_iconv_trie_flat marc8r_31page108_flat[] = {
  {"\x8B", 0, 0x21437C}, /* East Asian ideograph */
  {"\x95", 0, 0x21437D}, /* East Asian ideograph */
  {"\x89", 0, 0x21437E}, /* East Asian ideograph */
  {"\x87", 0, 0x214421}, /* East Asian ideograph */
  {"\x9D", 0, 0x214423}, /* East Asian ideograph */
  {"\x97", 0, 0x214424}, /* East Asian ideograph */
  {"\x9C", 0, 0x214428}, /* East Asian ideograph */
  {"\x9A", 0, 0x21442A}, /* East Asian ideograph */
  {"\x90", 0, 0x21442B}, /* East Asian ideograph */
  {"\xAF", 0, 0x214433}, /* East Asian ideograph */
  {"\xB6", 0, 0x214438}, /* East Asian ideograph */
  {"\xB8", 0, 0x21443F}, /* East Asian ideograph */
  {"\x93", 0, 0x223A75}, /* East Asian ideograph */
  {"\x9F", 0, 0x223A7A}, /* East Asian ideograph */
  {"\x85", 0, 0x223A7C}, /* East Asian ideograph */
  {"\x92", 0, 0x223B22}, /* East Asian ideograph */
  {"\x91", 0, 0x223B25}, /* East Asian ideograph */
  {"\x99", 0, 0x223B26}, /* East Asian ideograph */
  {"\xA4", 0, 0x223B28}, /* East Asian ideograph */
  {"\x8F", 0, 0x223B2E}, /* East Asian ideograph */
  {"\x98", 0, 0x223B31}, /* East Asian ideograph (variant of EACC 4C3B31) */
  {"\xAC", 0, 0x223B39}, /* East Asian ideograph */
  {"\xA0", 0, 0x223B3B}, /* East Asian ideograph */
  {"\xA1", 0, 0x223B3F}, /* East Asian ideograph */
  {"\x8D", 0, 0x223B48}, /* East Asian ideograph */
  {"\x8C", 0, 0x223B49}, /* East Asian ideograph */
  {"\xBB", 0, 0x223B5C}, /* East Asian ideograph */
  {"\xB0", 0, 0x223B5F}, /* East Asian ideograph */
  {"\xB7", 0, 0x223B64}, /* East Asian ideograph */
  {"\xB5", 0, 0x223B72}, /* East Asian ideograph */
  {"\xB3", 0, 0x223B77}, /* East Asian ideograph */
  {"\xAE", 0, 0x223B79}, /* East Asian ideograph */
  {"\xB2", 0, 0x223B7E}, /* East Asian ideograph */
  {"\xB9", 0, 0x223C21}, /* East Asian ideograph */
  {"\xAD", 0, 0x274468}, /* East Asian ideograph */
  {"\xA3", 0, 0x27447A}, /* East Asian ideograph */
  {"\x81", 0, 0x274526}, /* East Asian ideograph */
  {"\xAB", 0, 0x27452F}, /* East Asian ideograph */
  {"\x84", 0, 0x274539}, /* East Asian ideograph */
  {"\xAA", 0, 0x274540}, /* East Asian ideograph */
  {"\xA2", 0, 0x274549}, /* East Asian ideograph */
  {"\x9E", 0, 0x27454F}, /* East Asian ideograph */
  {"\xA7", 0, 0x283D30}, /* East Asian ideograph */
  {"\xA8", 0, 0x283D6E}, /* East Asian ideograph */
  {"\xA5", 0, 0x284340}, /* East Asian ideograph */
  {"\xB4", 0, 0x2D4049}, /* East Asian ideograph */
  {"\x80", 0, 0x2D442D}, /* East Asian ideograph */
  {"\xB1", 0, 0x3A3B7D}, /* East Asian ideograph */
  {"\xA9", 0, 0x4B442D}, /* East Asian ideograph */
  {"\xA6", 0, 0x4C4345}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page108 = {
  marc8r_31page108_flat, 0
};
/* PAGE 107 */
struct yaz_iconv_trie_flat marc8r_31page107_flat[] = {
  {"\x9E", 0, 0x214371}, /* East Asian ideograph */
  {"\x91", 0, 0x214372}, /* East Asian ideograph */
  {"\x8E", 0, 0x214373}, /* East Asian ideograph */
  {"\x9C", 0, 0x214374}, /* East Asian ideograph */
  {"\x90", 0, 0x214375}, /* East Asian ideograph */
  {"\x96", 0, 0x214376}, /* East Asian ideograph */
  {"\x9F", 0, 0x214377}, /* East Asian ideograph */
  {"\x8F", 0, 0x214378}, /* East Asian ideograph */
  {"\x89", 0, 0x214379}, /* East Asian ideograph */
  {"\xAD", 0, 0x21437B}, /* East Asian ideograph */
  {"\xB7", 0, 0x214422}, /* East Asian ideograph */
  {"\xAF", 0, 0x214425}, /* East Asian ideograph */
  {"\xB1", 0, 0x214426}, /* East Asian ideograph */
  {"\xB3", 0, 0x214427}, /* East Asian ideograph */
  {"\xB5", 0, 0x214429}, /* East Asian ideograph */
  {"\xBE", 0, 0x21442D}, /* East Asian ideograph */
  {"\x97", 0, 0x223A58}, /* East Asian ideograph */
  {"\x85", 0, 0x223A5B}, /* East Asian ideograph */
  {"\x87", 0, 0x223A5C}, /* East Asian ideograph */
  {"\x9D", 0, 0x223A60}, /* East Asian ideograph */
  {"\x95", 0, 0x223A61}, /* East Asian ideograph */
  {"\x8C", 0, 0x223A66}, /* East Asian ideograph */
  {"\x99", 0, 0x223A67}, /* East Asian ideograph */
  {"\x88", 0, 0x223A68}, /* East Asian ideograph */
  {"\xA3", 0, 0x223A6B}, /* East Asian ideograph */
  {"\x93", 0, 0x223A6E}, /* East Asian ideograph */
  {"\x8A", 0, 0x223A71}, /* East Asian ideograph */
  {"\xBC", 0, 0x223A78}, /* East Asian ideograph */
  {"\xBB", 0, 0x223B21}, /* East Asian ideograph */
  {"\xB6", 0, 0x223B23}, /* East Asian ideograph */
  {"\xB2", 0, 0x223B30}, /* East Asian ideograph */
  {"\xAA", 0, 0x223B32}, /* East Asian ideograph */
  {"\xA5", 0, 0x27314C}, /* East Asian ideograph */
  {"\xB0", 0, 0x273241}, /* East Asian ideograph */
  {"\xA1", 0, 0x274463}, /* East Asian ideograph */
  {"\xA8", 0, 0x27452A}, /* East Asian ideograph */
  {"\x83", 0, 0x274570}, /* East Asian ideograph */
  {"\x80", 0, 0x27463B}, /* East Asian ideograph */
  {"\xBF", 0, 0x275E65}, /* East Asian ideograph */
  {"\x82", 0, 0x275F4B}, /* East Asian ideograph */
  {"\xA9", 0, 0x283F5C}, /* East Asian ideograph */
  {"\x86", 0, 0x2D4461}, /* East Asian ideograph */
  {"\xA0", 0, 0x2D453A}, /* East Asian ideograph */
  {"\x81", 0, 0x4C3A55}, /* East Asian ideograph */
  {"\xA4", 0, 0x4C3B60}, /* East Asian ideograph */
  {"\xA2", 0, 0x694C5D}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page107 = {
  marc8r_31page107_flat, 0
};
/* PAGE 106 */
struct yaz_iconv_trie_flat marc8r_31page106_flat[] = {
  {"\x91", 0, 0x21433A}, /* East Asian ideograph */
  {"\x97", 0, 0x21433E}, /* East Asian ideograph */
  {"\x87", 0, 0x21433F}, /* East Asian ideograph */
  {"\x89", 0, 0x214340}, /* East Asian ideograph */
  {"\x88", 0, 0x214341}, /* East Asian ideograph */
  {"\x96", 0, 0x214342}, /* East Asian ideograph */
  {"\xA2", 0, 0x214343}, /* East Asian ideograph */
  {"\xAB", 0, 0x214344}, /* East Asian ideograph */
  {"\xB4", 0, 0x214345}, /* East Asian ideograph */
  {"\xAE", 0, 0x214346}, /* East Asian ideograph */
  {"\xB9", 0, 0x21434A}, /* East Asian ideograph */
  {"\x84", 0, 0x223870}, /* East Asian ideograph */
  {"\x8C", 0, 0x223871}, /* East Asian ideograph */
  {"\x93", 0, 0x223872}, /* East Asian ideograph */
  {"\x8B", 0, 0x223875}, /* East Asian ideograph */
  {"\x90", 0, 0x223876}, /* East Asian ideograph */
  {"\x94", 0, 0x223879}, /* East Asian ideograph */
  {"\x8A", 0, 0x22387A}, /* East Asian ideograph */
  {"\x98", 0, 0x22387C}, /* East Asian ideograph */
  {"\x8D", 0, 0x22387D}, /* East Asian ideograph */
  {"\xA0", 0, 0x22392A}, /* East Asian ideograph */
  {"\x9D", 0, 0x223932}, /* East Asian ideograph */
  {"\xB2", 0, 0x22393A}, /* East Asian ideograph */
  {"\xB5", 0, 0x223940}, /* East Asian ideograph */
  {"\xAA", 0, 0x223941}, /* East Asian ideograph */
  {"\xAC", 0, 0x223943}, /* East Asian ideograph */
  {"\xB1", 0, 0x223947}, /* East Asian ideograph */
  {"\xBE", 0, 0x22394F}, /* East Asian ideograph */
  {"\xBB", 0, 0x22395A}, /* East Asian ideograph */
  {"\x82", 0, 0x274344}, /* East Asian ideograph */
  {"\xA7", 0, 0x27434B}, /* East Asian ideograph */
  {"\x8E", 0, 0x2D4329}, /* East Asian ideograph */
  {"\x81", 0, 0x2D4348}, /* East Asian ideograph */
  {"\xA6", 0, 0x2D4349}, /* East Asian ideograph */
  {"\xA8", 0, 0x4B4347}, /* East Asian ideograph */
  {"\xB8", 0, 0x4B4D73}, /* East Asian ideograph */
  {"\x83", 0, 0x695A73}, /* East Asian ideograph */
  {"\xBC", 0, 0x695A7E}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page106 = {
  marc8r_31page106_flat, 0
};
/* PAGE 105 */
struct yaz_iconv_trie_flat marc8r_31page105_flat[] = {
  {"\x8F", 0, 0x21432C}, /* East Asian ideograph */
  {"\x82", 0, 0x21432D}, /* East Asian ideograph */
  {"\x92", 0, 0x21432E}, /* East Asian ideograph */
  {"\x89", 0, 0x21432F}, /* East Asian ideograph */
  {"\x83", 0, 0x214330}, /* East Asian ideograph */
  {"\x8C", 0, 0x214331}, /* East Asian ideograph */
  {"\x9D", 0, 0x214332}, /* East Asian ideograph */
  {"\xA4", 0, 0x214333}, /* East Asian ideograph */
  {"\xA8", 0, 0x214334}, /* East Asian ideograph */
  {"\xA6", 0, 0x214335}, /* East Asian ideograph */
  {"\x9A", 0, 0x214336}, /* East Asian ideograph */
  {"\xAF", 0, 0x214337}, /* East Asian ideograph */
  {"\xAE", 0, 0x214338}, /* East Asian ideograph */
  {"\xB4", 0, 0x214339}, /* East Asian ideograph (variant of EACC 4B4339) */
  {"\xB0", 0, 0x21433B}, /* East Asian ideograph */
  {"\xB6", 0, 0x21433C}, /* East Asian ideograph */
  {"\xBA", 0, 0x21433D}, /* East Asian ideograph */
  {"\x85", 0, 0x223831}, /* East Asian ideograph */
  {"\x9F", 0, 0x223832}, /* East Asian ideograph */
  {"\xA5", 0, 0x22383D}, /* East Asian ideograph */
  {"\x9C", 0, 0x22383E}, /* East Asian ideograph */
  {"\xA1", 0, 0x22383F}, /* East Asian ideograph */
  {"\x9B", 0, 0x223848}, /* East Asian ideograph */
  {"\x99", 0, 0x223849}, /* East Asian ideograph */
  {"\xA7", 0, 0x22384A}, /* East Asian ideograph */
  {"\x9E", 0, 0x22384C}, /* East Asian ideograph */
  {"\x97", 0, 0x22384D}, /* East Asian ideograph */
  {"\xBE", 0, 0x223850}, /* East Asian ideograph */
  {"\xAC", 0, 0x223851}, /* East Asian ideograph */
  {"\xB8", 0, 0x22385A}, /* East Asian ideograph */
  {"\xB3", 0, 0x223860}, /* East Asian ideograph */
  {"\xAD", 0, 0x223866}, /* East Asian ideograph */
  {"\xB7", 0, 0x223868}, /* East Asian ideograph */
  {"\x96", 0, 0x274340}, /* East Asian ideograph */
  {"\x95", 0, 0x274341}, /* East Asian ideograph */
  {"\x93", 0, 0x274348}, /* East Asian ideograph */
  {"\x94", 0, 0x28395C}, /* East Asian ideograph */
  {"\xA2", 0, 0x2D433B}, /* East Asian ideograph */
  {"\xBB", 0, 0x2D433E}, /* East Asian ideograph */
  {"\x81", 0, 0x2F5E7D}, /* East Asian ideograph */
  {"\x8B", 0, 0x33432F}, /* East Asian ideograph */
  {"\x84", 0, 0x394330}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page105 = {
  marc8r_31page105_flat, 0
};
/* PAGE 104 */
struct yaz_iconv_trie_flat marc8r_31page104_flat[] = {
  {"\x86", 0, 0x21427B}, /* East Asian ideograph */
  {"\x94", 0, 0x21427C}, /* East Asian ideograph */
  {"\x8C", 0, 0x21427D}, /* East Asian ideograph */
  {"\x80", 0, 0x21427E}, /* East Asian ideograph */
  {"\x8E", 0, 0x214321}, /* East Asian ideograph */
  {"\x93", 0, 0x214322}, /* East Asian ideograph */
  {"\x82", 0, 0x214323}, /* East Asian ideograph */
  {"\x8F", 0, 0x214324}, /* East Asian ideograph */
  {"\xA5", 0, 0x214325}, /* East Asian ideograph */
  {"\xA7", 0, 0x214326}, /* East Asian ideograph */
  {"\xAF", 0, 0x214327}, /* East Asian ideograph */
  {"\xAD", 0, 0x214328}, /* East Asian ideograph */
  {"\xA0", 0, 0x214329}, /* East Asian ideograph */
  {"\x9F", 0, 0x21432A}, /* East Asian ideograph */
  {"\xA8", 0, 0x21432B}, /* East Asian ideograph */
  {"\x89", 0, 0x22375A}, /* East Asian ideograph */
  {"\x8A", 0, 0x22375E}, /* East Asian ideograph */
  {"\x83", 0, 0x223764}, /* East Asian ideograph */
  {"\x91", 0, 0x22376A}, /* East Asian ideograph */
  {"\x95", 0, 0x22376B}, /* East Asian ideograph */
  {"\x84", 0, 0x22376D}, /* East Asian ideograph */
  {"\xB1", 0, 0x22376E}, /* East Asian ideograph */
  {"\xA1", 0, 0x223772}, /* East Asian ideograph */
  {"\xAC", 0, 0x223775}, /* East Asian ideograph */
  {"\xB5", 0, 0x223777}, /* East Asian ideograph */
  {"\x9E", 0, 0x22377C}, /* East Asian ideograph */
  {"\xBA", 0, 0x22377D}, /* East Asian ideograph */
  {"\xB3", 0, 0x223827}, /* East Asian ideograph */
  {"\xAB", 0, 0x223828}, /* East Asian ideograph */
  {"\xB4", 0, 0x22382B}, /* East Asian ideograph */
  {"\xA4", 0, 0x22382C}, /* East Asian ideograph */
  {"\xBC", 0, 0x274332}, /* East Asian ideograph */
  {"\xBE", 0, 0x276058}, /* East Asian ideograph */
  {"\x99", 0, 0x283955}, /* East Asian ideograph */
  {"\x87", 0, 0x2D345B}, /* East Asian ideograph */
  {"\x9A", 0, 0x2D3F24}, /* East Asian ideograph */
  {"\xB0", 0, 0x2D4327}, /* East Asian ideograph */
  {"\xB6", 0, 0x2D4343}, /* East Asian ideograph */
  {"\x9C", 0, 0x2D5F2E}, /* East Asian ideograph */
  {"\x9D", 0, 0x2E3A26}, /* East Asian ideograph */
  {"\xBF", 0, 0x4B434D}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page104 = {
  marc8r_31page104_flat, 0
};
/* PAGE 103 */
struct yaz_iconv_trie_flat marc8r_31page103_flat[] = {
  {"\x81", 0, 0x21426A}, /* East Asian ideograph */
  {"\x85", 0, 0x21426B}, /* East Asian ideograph */
  {"\x8E", 0, 0x21426C}, /* East Asian ideograph */
  {"\x8B", 0, 0x21426D}, /* East Asian ideograph */
  {"\x8C", 0, 0x21426E}, /* East Asian ideograph */
  {"\x8F", 0, 0x21426F}, /* East Asian ideograph */
  {"\x97", 0, 0x214270}, /* East Asian ideograph */
  {"\x96", 0, 0x214271}, /* East Asian ideograph */
  {"\xA2", 0, 0x214272}, /* East Asian ideograph */
  {"\xA5", 0, 0x214273}, /* East Asian ideograph */
  {"\xA9", 0, 0x214275}, /* East Asian ideograph */
  {"\xAC", 0, 0x214276}, /* East Asian ideograph */
  {"\xAD", 0, 0x214277}, /* East Asian ideograph */
  {"\xA8", 0, 0x214278}, /* East Asian ideograph */
  {"\xB1", 0, 0x214279}, /* East Asian ideograph */
  {"\xBA", 0, 0x21427A}, /* East Asian ideograph */
  {"\x86", 0, 0x223731}, /* East Asian ideograph */
  {"\x83", 0, 0x223732}, /* East Asian ideograph */
  {"\x84", 0, 0x223733}, /* East Asian ideograph */
  {"\x82", 0, 0x223734}, /* East Asian ideograph */
  {"\x90", 0, 0x22373B}, /* East Asian ideograph */
  {"\x92", 0, 0x22373C}, /* East Asian ideograph */
  {"\x9B", 0, 0x223744}, /* East Asian ideograph */
  {"\x9C", 0, 0x223745}, /* East Asian ideograph */
  {"\x9D", 0, 0x223747}, /* East Asian ideograph */
  {"\x9F", 0, 0x223748}, /* East Asian ideograph */
  {"\xA1", 0, 0x22374A}, /* East Asian ideograph */
  {"\xA4", 0, 0x22374E}, /* East Asian ideograph */
  {"\xB4", 0, 0x223754}, /* East Asian ideograph */
  {"\xB0", 0, 0x223755}, /* East Asian ideograph */
  {"\xBB", 0, 0x22375B}, /* East Asian ideograph */
  {"\xBC", 0, 0x22375C}, /* East Asian ideograph */
  {"\xB6", 0, 0x27432D}, /* East Asian ideograph */
  {"\xB7", 0, 0x27434D}, /* East Asian ideograph */
  {"\xA0", 0, 0x274966}, /* East Asian ideograph */
  {"\xA7", 0, 0x275435}, /* East Asian ideograph */
  {"\xA6", 0, 0x27565A}, /* East Asian ideograph */
  {"\xA3", 0, 0x2D4272}, /* East Asian ideograph */
  {"\xAE", 0, 0x2D4277}, /* East Asian ideograph */
  {"\xAF", 0, 0x334277}, /* East Asian ideograph */
  {"\x99", 0, 0x4C3744}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page103 = {
  marc8r_31page103_flat, 0
};
/* PAGE 102 */
struct yaz_iconv_trie_flat marc8r_31page102_flat[] = {
  {"\x82", 0, 0x214256}, /* East Asian ideograph */
  {"\x83", 0, 0x214257}, /* East Asian ideograph */
  {"\x87", 0, 0x214258}, /* East Asian ideograph */
  {"\x91", 0, 0x214259}, /* East Asian ideograph */
  {"\x90", 0, 0x21425A}, /* East Asian ideograph */
  {"\x99", 0, 0x21425C}, /* East Asian ideograph */
  {"\x9C", 0, 0x21425D}, /* East Asian ideograph */
  {"\x9F", 0, 0x21425E}, /* East Asian ideograph */
  {"\xA1", 0, 0x21425F}, /* East Asian ideograph */
  {"\xA4", 0, 0x214260}, /* East Asian ideograph */
  {"\xA5", 0, 0x214261}, /* East Asian ideograph */
  {"\xA7", 0, 0x214262}, /* East Asian ideograph */
  {"\xAC", 0, 0x214263}, /* East Asian ideograph */
  {"\xAF", 0, 0x214264}, /* East Asian ideograph */
  {"\xB0", 0, 0x214265}, /* East Asian ideograph */
  {"\xB7", 0, 0x214266}, /* East Asian ideograph */
  {"\xB9", 0, 0x214267}, /* East Asian ideograph */
  {"\xBD", 0, 0x214269}, /* East Asian ideograph */
  {"\xAB", 0, 0x214E2D}, /* East Asian ideograph */
  {"\x85", 0, 0x223664}, /* East Asian ideograph */
  {"\x8C", 0, 0x22366E}, /* East Asian ideograph */
  {"\x92", 0, 0x223670}, /* East Asian ideograph */
  {"\x95", 0, 0x223671}, /* East Asian ideograph */
  {"\x9B", 0, 0x223675}, /* East Asian ideograph */
  {"\x9D", 0, 0x223677}, /* East Asian ideograph */
  {"\xA0", 0, 0x22367A}, /* East Asian ideograph */
  {"\xA8", 0, 0x223722}, /* East Asian ideograph */
  {"\xA6", 0, 0x223723}, /* East Asian ideograph */
  {"\xAE", 0, 0x223727}, /* East Asian ideograph */
  {"\xB6", 0, 0x22372A}, /* East Asian ideograph */
  {"\xB8", 0, 0x22372C}, /* East Asian ideograph */
  {"\xBF", 0, 0x22372F}, /* East Asian ideograph */
  {"\xA9", 0, 0x274263}, /* East Asian ideograph */
  {"\xAD", 0, 0x274266}, /* East Asian ideograph */
  {"\x97", 0, 0x276167}, /* East Asian ideograph */
  {"\x8E", 0, 0x27627E}, /* East Asian ideograph */
  {"\x93", 0, 0x283671}, /* East Asian ideograph */
  {"\x88", 0, 0x2D3A60}, /* East Asian ideograph */
  {"\x8B", 0, 0x2D627E}, /* East Asian ideograph */
  {"\xB5", 0, 0x2E3729}, /* East Asian ideograph */
  {"\x8D", 0, 0x335830}, /* East Asian ideograph */
  {"\x89", 0, 0x33627D}, /* East Asian ideograph */
  {"\xBC", 0, 0x393052}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page102 = {
  marc8r_31page102_flat, 0
};
/* PAGE 101 */
struct yaz_iconv_trie_flat marc8r_31page101_flat[] = {
  {"\x85", 0, 0x214242}, /* East Asian ideograph */
  {"\x88", 0, 0x214243}, /* East Asian ideograph */
  {"\x8E", 0, 0x214244}, /* East Asian ideograph */
  {"\x96", 0, 0x214245}, /* East Asian ideograph */
  {"\x91", 0, 0x214246}, /* East Asian ideograph */
  {"\x97", 0, 0x214247}, /* East Asian ideograph */
  {"\x9D", 0, 0x214248}, /* East Asian ideograph */
  {"\x98", 0, 0x214249}, /* East Asian ideograph */
  {"\x8F", 0, 0x21424A}, /* East Asian ideograph */
  {"\xA6", 0, 0x21424B}, /* East Asian ideograph */
  {"\xA2", 0, 0x21424C}, /* East Asian ideograph */
  {"\xA3", 0, 0x21424D}, /* East Asian ideograph */
  {"\x9E", 0, 0x21424E}, /* East Asian ideograph */
  {"\xAC", 0, 0x214250}, /* East Asian ideograph */
  {"\xB2", 0, 0x214251}, /* East Asian ideograph */
  {"\xB5", 0, 0x214252}, /* East Asian ideograph */
  {"\xB7", 0, 0x214253}, /* East Asian ideograph */
  {"\xB8", 0, 0x214254}, /* East Asian ideograph */
  {"\xB4", 0, 0x214255}, /* East Asian ideograph */
  {"\x81", 0, 0x22357C}, /* East Asian ideograph */
  {"\x82", 0, 0x223634}, /* East Asian ideograph */
  {"\x89", 0, 0x223636}, /* East Asian ideograph */
  {"\x94", 0, 0x22363E}, /* East Asian ideograph */
  {"\x95", 0, 0x22363F}, /* East Asian ideograph */
  {"\xA7", 0, 0x223645}, /* East Asian ideograph */
  {"\xA1", 0, 0x223647}, /* East Asian ideograph */
  {"\xAD", 0, 0x22364F}, /* East Asian ideograph */
  {"\xBA", 0, 0x223654}, /* East Asian ideograph */
  {"\xAB", 0, 0x226055}, /* East Asian ideograph */
  {"\x8C", 0, 0x274252}, /* East Asian ideograph */
  {"\xB0", 0, 0x274254}, /* East Asian ideograph */
  {"\x9B", 0, 0x274256}, /* East Asian ideograph */
  {"\xBF", 0, 0x2E3654}, /* East Asian ideograph */
  {"\x99", 0, 0x334244}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page101 = {
  marc8r_31page101_flat, 0
};
/* PAGE 100 */
struct yaz_iconv_trie_flat marc8r_31page100_flat[] = {
  {"\x86", 0, 0x21422C}, /* East Asian ideograph */
  {"\x80", 0, 0x21422D}, /* East Asian ideograph */
  {"\x8F", 0, 0x214231}, /* East Asian ideograph */
  {"\x98", 0, 0x214232}, /* East Asian ideograph */
  {"\x94", 0, 0x214233}, /* East Asian ideograph */
  {"\x99", 0, 0x214234}, /* East Asian ideograph */
  {"\x9D", 0, 0x214235}, /* East Asian ideograph */
  {"\x9C", 0, 0x214236}, /* East Asian ideograph */
  {"\xA3", 0, 0x214237}, /* East Asian ideograph */
  {"\xA4", 0, 0x214238}, /* East Asian ideograph */
  {"\xAB", 0, 0x214239}, /* East Asian ideograph */
  {"\xAA", 0, 0x21423A}, /* East Asian ideograph */
  {"\xAC", 0, 0x21423B}, /* East Asian ideograph */
  {"\xAF", 0, 0x21423C}, /* East Asian ideograph */
  {"\xB6", 0, 0x21423D}, /* East Asian ideograph */
  {"\xB9", 0, 0x21423E}, /* East Asian ideograph */
  {"\xBB", 0, 0x21423F}, /* East Asian ideograph */
  {"\xBE", 0, 0x214240}, /* East Asian ideograph */
  {"\xBF", 0, 0x214241}, /* East Asian ideograph */
  {"\xB5", 0, 0x217874}, /* East Asian ideograph */
  {"\x84", 0, 0x223546}, /* East Asian ideograph */
  {"\x88", 0, 0x22354F}, /* East Asian ideograph */
  {"\x89", 0, 0x223553}, /* East Asian ideograph */
  {"\x9A", 0, 0x223559}, /* East Asian ideograph */
  {"\x96", 0, 0x22355B}, /* East Asian ideograph */
  {"\x9B", 0, 0x223561}, /* East Asian ideograph */
  {"\xA7", 0, 0x223569}, /* East Asian ideograph */
  {"\xA2", 0, 0x22356D}, /* East Asian ideograph */
  {"\xA9", 0, 0x22356F}, /* East Asian ideograph */
  {"\xA5", 0, 0x223572}, /* East Asian ideograph */
  {"\xAE", 0, 0x223577}, /* East Asian ideograph */
  {"\xB8", 0, 0x22362C}, /* East Asian ideograph */
  {"\x92", 0, 0x28356D}, /* East Asian ideograph */
  {"\xB4", 0, 0x2D416E}, /* East Asian ideograph */
  {"\xB7", 0, 0x2D525D}, /* East Asian ideograph */
  {"\x9F", 0, 0x2E3144}, /* East Asian ideograph */
  {"\xA8", 0, 0x2E3328}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page100 = {
  marc8r_31page100_flat, 0
};
/* PAGE 99 */
struct yaz_iconv_trie_flat marc8r_31page99_flat[] = {
  {"\x85", 0, 0x214173}, /* East Asian ideograph */
  {"\x81", 0, 0x214174}, /* East Asian ideograph */
  {"\x98", 0, 0x214175}, /* East Asian ideograph */
  {"\x8A", 0, 0x214176}, /* East Asian ideograph */
  {"\x82", 0, 0x214178}, /* East Asian ideograph */
  {"\x8B", 0, 0x21417A}, /* East Asian ideograph */
  {"\x8D", 0, 0x21417B}, /* East Asian ideograph */
  {"\x9A", 0, 0x21417C}, /* East Asian ideograph */
  {"\x84", 0, 0x21417D}, /* East Asian ideograph */
  {"\x87", 0, 0x21417E}, /* East Asian ideograph */
  {"\x8E", 0, 0x214221}, /* East Asian ideograph */
  {"\x94", 0, 0x214222}, /* East Asian ideograph */
  {"\x92", 0, 0x214223}, /* East Asian ideograph */
  {"\xA0", 0, 0x214225}, /* East Asian ideograph */
  {"\xB0", 0, 0x214226}, /* East Asian ideograph */
  {"\xA6", 0, 0x214227}, /* East Asian ideograph */
  {"\xAC", 0, 0x214228}, /* East Asian ideograph */
  {"\xB1", 0, 0x214229}, /* East Asian ideograph */
  {"\xB4", 0, 0x21422A}, /* East Asian ideograph */
  {"\xB2", 0, 0x21422B}, /* East Asian ideograph */
  {"\xBE", 0, 0x21422E}, /* East Asian ideograph */
  {"\xBB", 0, 0x21422F}, /* East Asian ideograph */
  {"\xBA", 0, 0x214230}, /* East Asian ideograph */
  {"\x97", 0, 0x22346A}, /* East Asian ideograph */
  {"\x93", 0, 0x22346C}, /* East Asian ideograph */
  {"\x90", 0, 0x223475}, /* East Asian ideograph */
  {"\xAF", 0, 0x22352A}, /* East Asian ideograph */
  {"\xA1", 0, 0x22352D}, /* East Asian ideograph */
  {"\xA5", 0, 0x22352E}, /* East Asian ideograph */
  {"\xAB", 0, 0x223531}, /* East Asian ideograph */
  {"\xA2", 0, 0x223533}, /* East Asian ideograph */
  {"\xAD", 0, 0x223536}, /* East Asian ideograph */
  {"\xA4", 0, 0x223538}, /* East Asian ideograph */
  {"\xB7", 0, 0x223542}, /* East Asian ideograph */
  {"\xBD", 0, 0x22354B}, /* East Asian ideograph */
  {"\x9E", 0, 0x27422F}, /* East Asian ideograph */
  {"\xA3", 0, 0x2D4153}, /* East Asian ideograph */
  {"\xA7", 0, 0x2D5434}, /* East Asian ideograph */
  {"\x80", 0, 0x3A2F7C}, /* East Asian ideograph */
  {"\xB6", 0, 0x695A31}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page99 = {
  marc8r_31page99_flat, 0
};
/* PAGE 98 */
struct yaz_iconv_trie_flat marc8r_31page98_flat[] = {
  {"\x9E", 0, 0x214162}, /* East Asian ideograph */
  {"\xA4", 0, 0x214163}, /* East Asian ideograph */
  {"\x87", 0, 0x214164}, /* East Asian ideograph */
  {"\x88", 0, 0x214165}, /* East Asian ideograph */
  {"\xA5", 0, 0x214166}, /* East Asian ideograph */
  {"\xB0", 0, 0x214167}, /* East Asian ideograph */
  {"\x93", 0, 0x214168}, /* East Asian ideograph */
  {"\x95", 0, 0x214169}, /* East Asian ideograph */
  {"\x92", 0, 0x21416A}, /* East Asian ideograph */
  {"\xA9", 0, 0x21416B}, /* East Asian ideograph */
  {"\x91", 0, 0x21416C}, /* East Asian ideograph */
  {"\xAE", 0, 0x21416D}, /* East Asian ideograph */
  {"\xB2", 0, 0x21416E}, /* East Asian ideograph */
  {"\xAD", 0, 0x21416F}, /* East Asian ideograph */
  {"\x9A", 0, 0x214170}, /* East Asian ideograph */
  {"\xAB", 0, 0x214171}, /* East Asian ideograph */
  {"\xAC", 0, 0x214172}, /* East Asian ideograph */
  {"\xBB", 0, 0x214177}, /* East Asian ideograph */
  {"\xBC", 0, 0x214179}, /* East Asian ideograph */
  {"\xBF", 0, 0x214224}, /* East Asian ideograph */
  {"\x82", 0, 0x223427}, /* East Asian ideograph */
  {"\x9D", 0, 0x22343C}, /* East Asian ideograph */
  {"\x99", 0, 0x22343F}, /* East Asian ideograph */
  {"\x8F", 0, 0x223442}, /* East Asian ideograph */
  {"\x96", 0, 0x22344D}, /* East Asian ideograph */
  {"\xA2", 0, 0x22344E}, /* East Asian ideograph */
  {"\x90", 0, 0x223454}, /* East Asian ideograph */
  {"\xB6", 0, 0x22345B}, /* East Asian ideograph */
  {"\x98", 0, 0x223461}, /* East Asian ideograph */
  {"\x9F", 0, 0x223462}, /* East Asian ideograph */
  {"\xA7", 0, 0x223465}, /* East Asian ideograph */
  {"\xB3", 0, 0x223466}, /* East Asian ideograph */
  {"\xBE", 0, 0x223474}, /* East Asian ideograph */
  {"\xB5", 0, 0x27422C}, /* East Asian ideograph */
  {"\xB7", 0, 0x283542}, /* East Asian ideograph */
  {"\x84", 0, 0x28355B}, /* East Asian ideograph */
  {"\xBA", 0, 0x283561}, /* East Asian ideograph */
  {"\xA6", 0, 0x2D4031}, /* East Asian ideograph */
  {"\x85", 0, 0x2D4122}, /* East Asian ideograph */
  {"\x83", 0, 0x2D4176}, /* East Asian ideograph */
  {"\xB9", 0, 0x4B423A}, /* East Asian ideograph */
  {"\xB8", 0, 0x4C354A}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page98 = {
  marc8r_31page98_flat, 0
};
/* PAGE 97 */
struct yaz_iconv_trie_flat marc8r_31page97_flat[] = {
  {"\x98", 0, 0x214157}, /* East Asian ideograph */
  {"\xA9", 0, 0x214158}, /* East Asian ideograph */
  {"\x94", 0, 0x214159}, /* East Asian ideograph */
  {"\x92", 0, 0x21415A}, /* East Asian ideograph */
  {"\xAF", 0, 0x21415B}, /* East Asian ideograph */
  {"\xB8", 0, 0x21415C}, /* East Asian ideograph */
  {"\xB9", 0, 0x21415D}, /* East Asian ideograph */
  {"\xBA", 0, 0x21415E}, /* East Asian ideograph */
  {"\x9F", 0, 0x21415F}, /* East Asian ideograph */
  {"\x91", 0, 0x214160}, /* East Asian ideograph */
  {"\xA7", 0, 0x214161}, /* East Asian ideograph */
  {"\x81", 0, 0x223345}, /* East Asian ideograph */
  {"\x80", 0, 0x223353}, /* East Asian ideograph */
  {"\x9B", 0, 0x223368}, /* East Asian ideograph */
  {"\x8F", 0, 0x22336A}, /* East Asian ideograph */
  {"\xAB", 0, 0x22336C}, /* East Asian ideograph */
  {"\xB6", 0, 0x22336F}, /* East Asian ideograph */
  {"\xB4", 0, 0x223376}, /* East Asian ideograph */
  {"\xBD", 0, 0x223378}, /* East Asian ideograph */
  {"\xB3", 0, 0x22337B}, /* East Asian ideograph */
  {"\x8E", 0, 0x223423}, /* East Asian ideograph */
  {"\xA4", 0, 0x223424}, /* East Asian ideograph */
  {"\x9E", 0, 0x223428}, /* East Asian ideograph */
  {"\xBB", 0, 0x22342C}, /* East Asian ideograph */
  {"\x9C", 0, 0x22342E}, /* East Asian ideograph */
  {"\x86", 0, 0x274230}, /* East Asian ideograph */
  {"\x84", 0, 0x274235}, /* East Asian ideograph */
  {"\x8A", 0, 0x274238}, /* East Asian ideograph */
  {"\x88", 0, 0x28352A}, /* East Asian ideograph */
  {"\x85", 0, 0x283546}, /* East Asian ideograph */
  {"\x87", 0, 0x2D4152}, /* East Asian ideograph */
  {"\x83", 0, 0x394022}, /* East Asian ideograph */
  {"\xAD", 0, 0x394042}, /* East Asian ideograph */
  {"\x82", 0, 0x4B4235}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page97 = {
  marc8r_31page97_flat, 0
};
/* PAGE 96 */
struct yaz_iconv_trie_flat marc8r_31page96_flat[] = {
  {"\x9E", 0, 0x214149}, /* East Asian ideograph */
  {"\xAA", 0, 0x21414A}, /* East Asian ideograph */
  {"\xBE", 0, 0x21414B}, /* East Asian ideograph */
  {"\x93", 0, 0x21414C}, /* East Asian ideograph */
  {"\x8F", 0, 0x21414D}, /* East Asian ideograph */
  {"\x94", 0, 0x21414E}, /* East Asian ideograph */
  {"\x8D", 0, 0x21414F}, /* East Asian ideograph */
  {"\xAD", 0, 0x214150}, /* East Asian ideograph */
  {"\xBD", 0, 0x214151}, /* East Asian ideograph */
  {"\x96", 0, 0x214152}, /* East Asian ideograph */
  {"\x97", 0, 0x214153}, /* East Asian ideograph */
  {"\x9C", 0, 0x214154}, /* East Asian ideograph */
  {"\xB6", 0, 0x214155}, /* East Asian ideograph */
  {"\xAC", 0, 0x214156}, /* East Asian ideograph */
  {"\x92", 0, 0x22327E}, /* East Asian ideograph */
  {"\x90", 0, 0x223322}, /* East Asian ideograph */
  {"\xB4", 0, 0x223324}, /* East Asian ideograph */
  {"\x9B", 0, 0x223329}, /* East Asian ideograph */
  {"\xA0", 0, 0x22332B}, /* East Asian ideograph */
  {"\xA4", 0, 0x22332C}, /* East Asian ideograph */
  {"\xA6", 0, 0x22332F}, /* East Asian ideograph */
  {"\x8C", 0, 0x223331}, /* East Asian ideograph */
  {"\x95", 0, 0x223336}, /* East Asian ideograph */
  {"\x98", 0, 0x223337}, /* East Asian ideograph */
  {"\x8E", 0, 0x223338}, /* East Asian ideograph */
  {"\xA2", 0, 0x22333B}, /* East Asian ideograph */
  {"\xA1", 0, 0x22333D}, /* East Asian ideograph */
  {"\xB0", 0, 0x223344}, /* East Asian ideograph */
  {"\xB5", 0, 0x223348}, /* East Asian ideograph */
  {"\x89", 0, 0x22334C}, /* East Asian ideograph */
  {"\x8A", 0, 0x223351}, /* East Asian ideograph */
  {"\x87", 0, 0x223359}, /* East Asian ideograph */
  {"\xBB", 0, 0x22335B}, /* East Asian ideograph */
  {"\xBF", 0, 0x22335D}, /* East Asian ideograph */
  {"\x82", 0, 0x27415F}, /* East Asian ideograph */
  {"\x81", 0, 0x274229}, /* East Asian ideograph */
  {"\x80", 0, 0x274234}, /* East Asian ideograph */
  {"\x85", 0, 0x27423A}, /* East Asian ideograph */
  {"\xAF", 0, 0x2D4132}, /* East Asian ideograph */
  {"\xA8", 0, 0x2D4150}, /* East Asian ideograph */
  {"\x86", 0, 0x2D4539}, /* East Asian ideograph */
  {"\x8B", 0, 0x2E3028}, /* East Asian ideograph */
  {"\xA5", 0, 0x334131}, /* East Asian ideograph */
  {"\x83", 0, 0x3F516D}, /* East Asian ideograph */
  {"\xBA", 0, 0x4B4236}, /* East Asian ideograph */
  {"\xA7", 0, 0x4B4975}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page96 = {
  marc8r_31page96_flat, 0
};
/* PAGE 95 */
struct yaz_iconv_trie_flat marc8r_31page95_flat[] = {
  {"\x86", 0, 0x214138}, /* East Asian ideograph */
  {"\x89", 0, 0x214139}, /* East Asian ideograph */
  {"\x8D", 0, 0x21413A}, /* East Asian ideograph */
  {"\xA1", 0, 0x21413B}, /* East Asian ideograph */
  {"\x80", 0, 0x21413C}, /* East Asian ideograph */
  {"\xA9", 0, 0x21413D}, /* East Asian ideograph */
  {"\x90", 0, 0x21413E}, /* East Asian ideograph */
  {"\x9A", 0, 0x21413F}, /* East Asian ideograph */
  {"\x96", 0, 0x214140}, /* East Asian ideograph */
  {"\xAD", 0, 0x214141}, /* East Asian ideograph */
  {"\xAE", 0, 0x214142}, /* East Asian ideograph */
  {"\x8F", 0, 0x214143}, /* East Asian ideograph */
  {"\xA3", 0, 0x214144}, /* East Asian ideograph */
  {"\xB4", 0, 0x214145}, /* East Asian ideograph */
  {"\x9B", 0, 0x214146}, /* East Asian ideograph (variant of EACC 454146) */
  {"\x92", 0, 0x214147}, /* East Asian ideograph */
  {"\xAA", 0, 0x214148}, /* East Asian ideograph */
  {"\x9E", 0, 0x223243}, /* East Asian ideograph */
  {"\xA5", 0, 0x223244}, /* East Asian ideograph */
  {"\x93", 0, 0x223247}, /* East Asian ideograph */
  {"\x83", 0, 0x223250}, /* East Asian ideograph */
  {"\xB5", 0, 0x223252}, /* East Asian ideograph */
  {"\xA6", 0, 0x223258}, /* East Asian ideograph */
  {"\xA0", 0, 0x22325B}, /* East Asian ideograph */
  {"\x95", 0, 0x22325C}, /* East Asian ideograph */
  {"\xB6", 0, 0x22325D}, /* East Asian ideograph */
  {"\xB2", 0, 0x22325E}, /* East Asian ideograph */
  {"\xB8", 0, 0x22325F}, /* East Asian ideograph */
  {"\x85", 0, 0x223266}, /* East Asian ideograph */
  {"\xB9", 0, 0x22326A}, /* East Asian ideograph */
  {"\xAB", 0, 0x223272}, /* East Asian ideograph */
  {"\x9D", 0, 0x223273}, /* East Asian ideograph */
  {"\x91", 0, 0x223276}, /* East Asian ideograph */
  {"\x84", 0, 0x223279}, /* East Asian ideograph */
  {"\x9C", 0, 0x22327A}, /* East Asian ideograph */
  {"\x97", 0, 0x22327B}, /* East Asian ideograph */
  {"\xBD", 0, 0x27423B}, /* East Asian ideograph */
  {"\xBF", 0, 0x283466}, /* East Asian ideograph */
  {"\x8E", 0, 0x2D4066}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page95 = {
  marc8r_31page95_flat, 0
};
/* PAGE 94 */
struct yaz_iconv_trie_flat marc8r_31page94_flat[] = {
  {"\xA5", 0, 0x214076}, /* East Asian ideograph */
  {"\xA0", 0, 0x214078}, /* East Asian ideograph */
  {"\x96", 0, 0x214079}, /* East Asian ideograph */
  {"\xA7", 0, 0x21407A}, /* East Asian ideograph */
  {"\x83", 0, 0x21407D}, /* East Asian ideograph */
  {"\x98", 0, 0x214122}, /* East Asian ideograph */
  {"\x9B", 0, 0x214123}, /* East Asian ideograph */
  {"\xAA", 0, 0x214124}, /* East Asian ideograph */
  {"\xA9", 0, 0x214126}, /* East Asian ideograph */
  {"\x8C", 0, 0x214127}, /* East Asian ideograph */
  {"\x89", 0, 0x214128}, /* East Asian ideograph */
  {"\xA2", 0, 0x214129}, /* East Asian ideograph */
  {"\x99", 0, 0x21412A}, /* East Asian ideograph */
  {"\xA1", 0, 0x21412B}, /* East Asian ideograph */
  {"\x88", 0, 0x21412C}, /* East Asian ideograph */
  {"\xAC", 0, 0x21412D}, /* East Asian ideograph */
  {"\x92", 0, 0x21412F}, /* East Asian ideograph */
  {"\xA3", 0, 0x214130}, /* East Asian ideograph */
  {"\x8F", 0, 0x214132}, /* East Asian ideograph */
  {"\xA8", 0, 0x214133}, /* East Asian ideograph */
  {"\x84", 0, 0x214136}, /* East Asian ideograph */
  {"\x80", 0, 0x214137}, /* East Asian ideograph */
  {"\xB6", 0, 0x22316A}, /* East Asian ideograph */
  {"\x82", 0, 0x22316B}, /* East Asian ideograph */
  {"\x9F", 0, 0x22316E}, /* East Asian ideograph */
  {"\x9E", 0, 0x223172}, /* East Asian ideograph */
  {"\x81", 0, 0x223179}, /* East Asian ideograph */
  {"\x97", 0, 0x22317B}, /* East Asian ideograph */
  {"\xAB", 0, 0x22317D}, /* East Asian ideograph */
  {"\x87", 0, 0x223225}, /* East Asian ideograph */
  {"\x8E", 0, 0x223227}, /* East Asian ideograph */
  {"\x86", 0, 0x22322A}, /* East Asian ideograph */
  {"\xAF", 0, 0x223230}, /* East Asian ideograph */
  {"\xB1", 0, 0x223237}, /* East Asian ideograph */
  {"\xB0", 0, 0x223238}, /* East Asian ideograph */
  {"\xAE", 0, 0x223239}, /* East Asian ideograph */
  {"\x90", 0, 0x22323B}, /* East Asian ideograph */
  {"\xAD", 0, 0x22323D}, /* East Asian ideograph */
  {"\xBD", 0, 0x22324F}, /* East Asian ideograph */
  {"\xBE", 0, 0x223270}, /* East Asian ideograph */
  {"\xB4", 0, 0x274160}, /* East Asian ideograph */
  {"\xB3", 0, 0x27417D}, /* East Asian ideograph */
  {"\xB7", 0, 0x27422B}, /* East Asian ideograph */
  {"\xBA", 0, 0x28342C}, /* East Asian ideograph */
  {"\xBC", 0, 0x28342E}, /* East Asian ideograph */
  {"\xB8", 0, 0x283457}, /* East Asian ideograph */
  {"\xB2", 0, 0x2D4141}, /* East Asian ideograph */
  {"\x8A", 0, 0x3F404F}, /* East Asian ideograph */
  {"\xB5", 0, 0x69595E}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page94 = {
  marc8r_31page94_flat, 0
};
/* PAGE 93 */
struct yaz_iconv_trie_flat marc8r_31page93_flat[] = {
  {"\x82", 0, 0x214069}, /* East Asian ideograph */
  {"\x95", 0, 0x21406B}, /* East Asian ideograph */
  {"\x8E", 0, 0x21406E}, /* East Asian ideograph */
  {"\x8F", 0, 0x21406F}, /* East Asian ideograph */
  {"\x90", 0, 0x214070}, /* East Asian ideograph */
  {"\x89", 0, 0x214071}, /* East Asian ideograph */
  {"\xA9", 0, 0x214077}, /* East Asian ideograph */
  {"\xB2", 0, 0x21407B}, /* East Asian ideograph */
  {"\xB7", 0, 0x21407C}, /* East Asian ideograph */
  {"\xAB", 0, 0x21407E}, /* East Asian ideograph */
  {"\xA7", 0, 0x214121}, /* East Asian ideograph */
  {"\xB1", 0, 0x214125}, /* East Asian ideograph */
  {"\xB6", 0, 0x214131}, /* East Asian ideograph */
  {"\xBB", 0, 0x214134}, /* East Asian ideograph */
  {"\xA8", 0, 0x214135}, /* East Asian ideograph (variant of EACC 4B4135) */
  {"\xA0", 0, 0x223132}, /* East Asian ideograph */
  {"\x85", 0, 0x223142}, /* East Asian ideograph */
  {"\x83", 0, 0x223144}, /* East Asian ideograph */
  {"\x93", 0, 0x223147}, /* East Asian ideograph */
  {"\xA4", 0, 0x223148}, /* East Asian ideograph */
  {"\x84", 0, 0x22314A}, /* East Asian ideograph */
  {"\x97", 0, 0x223158}, /* East Asian ideograph */
  {"\x98", 0, 0x22315B}, /* East Asian ideograph */
  {"\x8B", 0, 0x22315C}, /* East Asian ideograph */
  {"\x94", 0, 0x22315F}, /* East Asian ideograph */
  {"\xBD", 0, 0x223168}, /* East Asian ideograph */
  {"\xAC", 0, 0x22316C}, /* East Asian ideograph */
  {"\xBF", 0, 0x223173}, /* East Asian ideograph */
  {"\xBA", 0, 0x223226}, /* East Asian ideograph */
  {"\xB5", 0, 0x22322F}, /* East Asian ideograph */
  {"\xBC", 0, 0x22323A}, /* East Asian ideograph */
  {"\xAD", 0, 0x223241}, /* East Asian ideograph */
  {"\x9F", 0, 0x27414F}, /* East Asian ideograph */
  {"\xA3", 0, 0x274153}, /* East Asian ideograph */
  {"\x9E", 0, 0x274165}, /* East Asian ideograph */
  {"\xAE", 0, 0x27417C}, /* East Asian ideograph */
  {"\xA1", 0, 0x274224}, /* East Asian ideograph */
  {"\x86", 0, 0x27513D}, /* East Asian ideograph */
  {"\x8C", 0, 0x2D3324}, /* East Asian ideograph */
  {"\x9C", 0, 0x2D4154}, /* East Asian ideograph */
  {"\x8D", 0, 0x2E2F7C}, /* East Asian ideograph */
  {"\xB4", 0, 0x33516D}, /* East Asian ideograph */
  {"\xA2", 0, 0x4B4146}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page93 = {
  marc8r_31page93_flat, 0
};
/* PAGE 92 */
struct yaz_iconv_trie_flat marc8r_31page92_flat[] = {
  {"\x89", 0, 0x214057}, /* East Asian ideograph */
  {"\x96", 0, 0x214058}, /* East Asian ideograph */
  {"\x88", 0, 0x21405B}, /* East Asian ideograph */
  {"\x81", 0, 0x21405D}, /* East Asian ideograph */
  {"\x87", 0, 0x214061}, /* East Asian ideograph */
  {"\x91", 0, 0x214064}, /* East Asian ideograph */
  {"\xAA", 0, 0x21406A}, /* East Asian ideograph */
  {"\xBE", 0, 0x21406C}, /* East Asian ideograph */
  {"\xAF", 0, 0x21406D}, /* East Asian ideograph */
  {"\xAB", 0, 0x214073}, /* East Asian ideograph */
  {"\xA8", 0, 0x214074}, /* East Asian ideograph */
  {"\xBA", 0, 0x214075}, /* East Asian ideograph */
  {"\xBD", 0, 0x21412E}, /* East Asian ideograph */
  {"\x8D", 0, 0x223072}, /* East Asian ideograph */
  {"\x8C", 0, 0x223131}, /* East Asian ideograph */
  {"\xB1", 0, 0x22313A}, /* East Asian ideograph */
  {"\xB5", 0, 0x223145}, /* East Asian ideograph */
  {"\xB6", 0, 0x223149}, /* East Asian ideograph */
  {"\xB9", 0, 0x223154}, /* East Asian ideograph */
  {"\xBC", 0, 0x22315A}, /* East Asian ideograph */
  {"\x9F", 0, 0x27406C}, /* East Asian ideograph */
  {"\x82", 0, 0x274123}, /* East Asian ideograph */
  {"\xA5", 0, 0x274142}, /* East Asian ideograph */
  {"\x9A", 0, 0x27415B}, /* East Asian ideograph */
  {"\xA0", 0, 0x274168}, /* East Asian ideograph */
  {"\x9E", 0, 0x274177}, /* East Asian ideograph */
  {"\xA1", 0, 0x27417A}, /* East Asian ideograph */
  {"\xA4", 0, 0x274225}, /* East Asian ideograph */
  {"\x9B", 0, 0x274237}, /* East Asian ideograph */
  {"\xA2", 0, 0x283462}, /* East Asian ideograph */
  {"\xB2", 0, 0x2E313A}, /* East Asian ideograph */
  {"\x8E", 0, 0x2E337B}, /* East Asian ideograph */
  {"\xA3", 0, 0x4B412A}, /* East Asian ideograph */
  {"\xBF", 0, 0x4B4147}, /* East Asian ideograph */
  {"\x99", 0, 0x4B5434}, /* East Asian ideograph */
  {"\x9D", 0, 0x4C3474}, /* East Asian ideograph */
  {"\xA7", 0, 0x69594B}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page92 = {
  marc8r_31page92_flat, 0
};
/* PAGE 91 */
struct yaz_iconv_trie_dir marc8r_31page91_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x21403F} /* East Asian ideograph */,
  {0, 0, 0x22306A} /* East Asian ideograph */,
  {0, 0, 0x21403A} /* East Asian ideograph */,
  {0, 0, 0x274222} /* East Asian ideograph */,
  {0, 0, 0x214056} /* East Asian ideograph */,
  {0, 0, 0x21404E} /* East Asian ideograph */,
  {0, 0, 0x21404A} /* East Asian ideograph */,
  {0, 0, 0x214039} /* East Asian ideograph */,
  {0, 0, 0x2D4171} /* East Asian ideograph */,
  {0, 0, 0x214045} /* East Asian ideograph */,
  {0, 0, 0x21403B} /* East Asian ideograph */,
  {0, 0, 0x214052} /* East Asian ideograph */,
  {0, 0, 0x214054} /* East Asian ideograph */,
  {0, 0, 0x2D4067} /* East Asian ideograph */,
  {0, 0, 0x214049} /* East Asian ideograph (variant of EACC 4B4049) */,
  {0, 0, 0x223057} /* East Asian ideograph */,
  {0, 0, 0x214041} /* East Asian ideograph */,
  {0, 0, 0x214042} /* East Asian ideograph */,
  {0, 0, 0x214046} /* East Asian ideograph */,
  {0, 0, 0x334050} /* East Asian ideograph */,
  {0, 0, 0x214050} /* East Asian ideograph */,
  {0, 0, 0x214055} /* East Asian ideograph */,
  {0, 0, 0x214051} /* East Asian ideograph */,
  {0, 0, 0x21404B} /* East Asian ideograph */,
  {0, 0, 0x21404C} /* East Asian ideograph */,
  {0, 0, 0x214043} /* East Asian ideograph */,
  {0, 0, 0x21403D} /* East Asian ideograph */,
  {0, 0, 0x4B403D} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x274228} /* East Asian ideograph */,
  {0, 0, 0x39417C} /* East Asian ideograph */,
  {0, 0, 0x33422A} /* East Asian ideograph */,
  {0, 0, 0x274231} /* East Asian ideograph */,
  {0, 0, 0x27413C} /* East Asian ideograph */,
  {0, 0, 0x223061} /* East Asian ideograph */,
  {0, 0, 0x274174} /* East Asian ideograph */,
  {0, 0, 0x274233} /* East Asian ideograph */,
  {0, 0, 0x274226} /* East Asian ideograph */,
  {0, 0, 0x274166} /* East Asian ideograph */,
  {0, 0, 0x27417E} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x214065} /* East Asian ideograph */,
  {0, 0, 0x21405C} /* East Asian ideograph */,
  {0, 0, 0x21405E} /* East Asian ideograph */,
  {0, 0, 0x21405F} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x214062} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x21405A} /* East Asian ideograph */,
  {0, 0, 0x214066} /* East Asian ideograph (variant of EACC 4B4066) */,
  {0, 0, 0x223125} /* East Asian ideograph */,
  {0, 0, 0x223137} /* East Asian ideograph */,
  {0, 0, 0x214060} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x214059} /* East Asian ideograph */,
  {0, 0, 0x214063} /* East Asian ideograph */,
  {0, 0, 0x2D3457} /* East Asian ideograph */,
  {0, 0, 0x214067} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page91 = {
  0, marc8r_31page91_dir
};
/* PAGE 90 */
struct yaz_iconv_trie_flat marc8r_31page90_flat[] = {
  {"\x96", 0, 0x214025}, /* East Asian ideograph */
  {"\x97", 0, 0x214026}, /* East Asian ideograph */
  {"\x92", 0, 0x214027}, /* East Asian ideograph */
  {"\x89", 0, 0x214029}, /* East Asian ideograph */
  {"\x80", 0, 0x21402C}, /* East Asian ideograph */
  {"\x8A", 0, 0x21402D}, /* East Asian ideograph */
  {"\x84", 0, 0x214032}, /* East Asian ideograph */
  {"\x95", 0, 0x214033}, /* East Asian ideograph */
  {"\x91", 0, 0x214034}, /* East Asian ideograph */
  {"\x98", 0, 0x214035}, /* East Asian ideograph */
  {"\x93", 0, 0x214038}, /* East Asian ideograph */
  {"\xA8", 0, 0x21403C}, /* East Asian ideograph */
  {"\xBF", 0, 0x21403E}, /* East Asian ideograph */
  {"\xB9", 0, 0x214040}, /* East Asian ideograph */
  {"\xAB", 0, 0x214044}, /* East Asian ideograph */
  {"\xBD", 0, 0x214047}, /* East Asian ideograph */
  {"\xBC", 0, 0x214048}, /* East Asian ideograph */
  {"\xAC", 0, 0x21404D}, /* East Asian ideograph */
  {"\xB1", 0, 0x21404F}, /* East Asian ideograph */
  {"\xB5", 0, 0x214053}, /* East Asian ideograph */
  {"\x86", 0, 0x223031}, /* East Asian ideograph */
  {"\x8E", 0, 0x223032}, /* East Asian ideograph */
  {"\xA3", 0, 0x223041}, /* East Asian ideograph */
  {"\x82", 0, 0x223043}, /* East Asian ideograph */
  {"\x85", 0, 0x223046}, /* East Asian ideograph */
  {"\x9D", 0, 0x22304B}, /* East Asian ideograph */
  {"\xA6", 0, 0x223056}, /* East Asian ideograph */
  {"\xB6", 0, 0x223069}, /* East Asian ideograph */
  {"\xA5", 0, 0x273844}, /* East Asian ideograph */
  {"\xA1", 0, 0x274136}, /* East Asian ideograph */
  {"\xA2", 0, 0x274155}, /* East Asian ideograph */
  {"\x9A", 0, 0x274171}, /* East Asian ideograph */
  {"\xA4", 0, 0x275948}, /* East Asian ideograph */
  {"\x9F", 0, 0x28336F}, /* East Asian ideograph */
  {"\xA0", 0, 0x28337B}, /* East Asian ideograph */
  {"\xBB", 0, 0x2D313A}, /* East Asian ideograph */
  {"\x83", 0, 0x2D404C}, /* East Asian ideograph */
  {"\x94", 0, 0x2D404F}, /* East Asian ideograph */
  {"\x9B", 0, 0x334045}, /* East Asian ideograph */
  {"\x9E", 0, 0x33417E}, /* East Asian ideograph */
  {"\x9C", 0, 0x4B4046}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page90 = {
  marc8r_31page90_flat, 0
};
/* PAGE 89 */
struct yaz_iconv_trie_flat marc8r_31page89_flat[] = {
  {"\x80", 0, 0x213F75}, /* East Asian ideograph */
  {"\x81", 0, 0x213F76}, /* East Asian ideograph */
  {"\x88", 0, 0x213F78}, /* East Asian ideograph */
  {"\x89", 0, 0x213F79}, /* East Asian ideograph */
  {"\x8B", 0, 0x213F7A}, /* East Asian ideograph */
  {"\x93", 0, 0x213F7D}, /* East Asian ideograph */
  {"\x94", 0, 0x213F7E}, /* East Asian ideograph */
  {"\x92", 0, 0x214021}, /* East Asian ideograph */
  {"\x9B", 0, 0x214022}, /* East Asian ideograph */
  {"\xA3", 0, 0x214023}, /* East Asian ideograph */
  {"\x98", 0, 0x214024}, /* East Asian ideograph */
  {"\xB6", 0, 0x214028}, /* East Asian ideograph */
  {"\xBF", 0, 0x21402A}, /* East Asian ideograph */
  {"\xB9", 0, 0x21402B}, /* East Asian ideograph */
  {"\xAD", 0, 0x21402E}, /* East Asian ideograph */
  {"\xBC", 0, 0x21402F}, /* East Asian ideograph */
  {"\xBE", 0, 0x214030}, /* East Asian ideograph */
  {"\xAF", 0, 0x214031}, /* East Asian ideograph */
  {"\xAE", 0, 0x214036}, /* East Asian ideograph */
  {"\xB3", 0, 0x214037}, /* East Asian ideograph */
  {"\x83", 0, 0x222F75}, /* East Asian ideograph */
  {"\x86", 0, 0x222F77}, /* East Asian ideograph */
  {"\x85", 0, 0x222F78}, /* East Asian ideograph */
  {"\x8A", 0, 0x222F79}, /* East Asian ideograph */
  {"\x90", 0, 0x222F7A}, /* East Asian ideograph */
  {"\x9E", 0, 0x222F7C}, /* East Asian ideograph */
  {"\xA8", 0, 0x223026}, /* East Asian ideograph */
  {"\xA0", 0, 0x223028}, /* East Asian ideograph */
  {"\x9A", 0, 0x22302B}, /* East Asian ideograph */
  {"\xA2", 0, 0x22302C}, /* East Asian ideograph */
  {"\xA6", 0, 0x22302D}, /* East Asian ideograph */
  {"\xA7", 0, 0x27383B}, /* East Asian ideograph */
  {"\xAB", 0, 0x27407D}, /* East Asian ideograph */
  {"\xAA", 0, 0x27407E}, /* East Asian ideograph */
  {"\xAC", 0, 0x27413F}, /* East Asian ideograph */
  {"\x91", 0, 0x27416E}, /* East Asian ideograph */
  {"\xA9", 0, 0x27422A}, /* East Asian ideograph */
  {"\xB0", 0, 0x27422E}, /* East Asian ideograph */
  {"\x87", 0, 0x274975}, /* East Asian ideograph */
  {"\x8E", 0, 0x275129}, /* East Asian ideograph */
  {"\x8D", 0, 0x28736D}, /* East Asian ideograph */
  {"\x95", 0, 0x2D403F}, /* East Asian ideograph */
  {"\xB1", 0, 0x2D4147}, /* East Asian ideograph */
  {"\xB5", 0, 0x4B3052}, /* East Asian ideograph */
  {"\xBA", 0, 0x4B4053}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page89 = {
  marc8r_31page89_flat, 0
};
/* PAGE 88 */
struct yaz_iconv_trie_flat marc8r_31page88_flat[] = {
  {"\x80", 0, 0x213F5C}, /* East Asian ideograph */
  {"\x88", 0, 0x213F5D}, /* East Asian ideograph */
  {"\x8A", 0, 0x213F5E}, /* East Asian ideograph */
  {"\x8E", 0, 0x213F5F}, /* East Asian ideograph */
  {"\x8D", 0, 0x213F60}, /* East Asian ideograph */
  {"\x8C", 0, 0x213F61}, /* East Asian ideograph */
  {"\x90", 0, 0x213F62}, /* East Asian ideograph */
  {"\x92", 0, 0x213F63}, /* East Asian ideograph */
  {"\x91", 0, 0x213F64}, /* East Asian ideograph */
  {"\x96", 0, 0x213F65}, /* East Asian ideograph */
  {"\x95", 0, 0x213F66}, /* East Asian ideograph */
  {"\x9B", 0, 0x213F67}, /* East Asian ideograph */
  {"\x9A", 0, 0x213F68}, /* East Asian ideograph */
  {"\x9F", 0, 0x213F69}, /* East Asian ideograph */
  {"\xA1", 0, 0x213F6A}, /* East Asian ideograph */
  {"\xA2", 0, 0x213F6B}, /* East Asian ideograph */
  {"\xAA", 0, 0x213F6C}, /* East Asian ideograph */
  {"\xAE", 0, 0x213F6D}, /* East Asian ideograph */
  {"\xB0", 0, 0x213F6E}, /* East Asian ideograph */
  {"\xB2", 0, 0x213F6F}, /* East Asian ideograph */
  {"\xB4", 0, 0x213F70}, /* East Asian ideograph */
  {"\xB3", 0, 0x213F71}, /* East Asian ideograph */
  {"\xB6", 0, 0x213F72}, /* East Asian ideograph */
  {"\xBF", 0, 0x213F73}, /* East Asian ideograph */
  {"\xBE", 0, 0x213F74}, /* East Asian ideograph */
  {"\x81", 0, 0x222F3D}, /* East Asian ideograph */
  {"\x84", 0, 0x222F41}, /* East Asian ideograph */
  {"\x87", 0, 0x222F43}, /* East Asian ideograph */
  {"\x89", 0, 0x222F44}, /* East Asian ideograph */
  {"\x94", 0, 0x222F47}, /* East Asian ideograph */
  {"\xA3", 0, 0x222F56}, /* East Asian ideograph */
  {"\xA5", 0, 0x222F5B}, /* East Asian ideograph */
  {"\xA4", 0, 0x222F5D}, /* East Asian ideograph */
  {"\xA9", 0, 0x222F61}, /* East Asian ideograph */
  {"\xAD", 0, 0x222F67}, /* East Asian ideograph */
  {"\xB9", 0, 0x222F6E}, /* East Asian ideograph */
  {"\xBA", 0, 0x222F6F}, /* East Asian ideograph */
  {"\xBD", 0, 0x222F70}, /* East Asian ideograph */
  {"\x98", 0, 0x273F6E}, /* East Asian ideograph */
  {"\x8F", 0, 0x273F6F}, /* East Asian ideograph */
  {"\x86", 0, 0x282F43}, /* East Asian ideograph */
  {"\x8B", 0, 0x282F47}, /* East Asian ideograph */
  {"\x97", 0, 0x282F66}, /* East Asian ideograph */
  {"\x9E", 0, 0x2D3F67}, /* East Asian ideograph */
  {"\xA6", 0, 0x2D3F6E}, /* East Asian ideograph */
  {"\xAF", 0, 0x2D3F6F}, /* East Asian ideograph */
  {"\xBB", 0, 0x4B3F74}, /* East Asian ideograph */
  {"\x9D", 0, 0x4B5A23}, /* East Asian ideograph */
  {"\xAC", 0, 0x4C2F61}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page88 = {
  marc8r_31page88_flat, 0
};
/* PAGE 87 */
struct yaz_iconv_trie_flat marc8r_31page87_flat[] = {
  {"\x8D", 0, 0x213F49}, /* East Asian ideograph */
  {"\x89", 0, 0x213F4A}, /* East Asian ideograph */
  {"\x82", 0, 0x213F4D}, /* East Asian ideograph */
  {"\x87", 0, 0x213F4E}, /* East Asian ideograph */
  {"\x88", 0, 0x213F4F}, /* East Asian ideograph */
  {"\x8A", 0, 0x213F50}, /* East Asian ideograph */
  {"\xA3", 0, 0x213F51}, /* East Asian ideograph */
  {"\xA6", 0, 0x213F52}, /* East Asian ideograph */
  {"\xB2", 0, 0x213F53}, /* East Asian ideograph (variant of EACC 4B3F53) */
  {"\xB7", 0, 0x213F54}, /* East Asian ideograph */
  {"\xB6", 0, 0x213F55}, /* East Asian ideograph */
  {"\xB8", 0, 0x213F56}, /* East Asian ideograph */
  {"\xB5", 0, 0x213F57}, /* East Asian ideograph */
  {"\xBA", 0, 0x213F58}, /* East Asian ideograph */
  {"\xBE", 0, 0x213F59}, /* East Asian ideograph */
  {"\xBF", 0, 0x213F5A}, /* East Asian ideograph */
  {"\xBC", 0, 0x213F5B}, /* East Asian ideograph */
  {"\x8B", 0, 0x222E5A}, /* East Asian ideograph */
  {"\x8C", 0, 0x222E5C}, /* East Asian ideograph */
  {"\x86", 0, 0x222E5D}, /* East Asian ideograph */
  {"\xA0", 0, 0x222E71}, /* East Asian ideograph */
  {"\xA5", 0, 0x222E77}, /* East Asian ideograph */
  {"\x9C", 0, 0x222E7D}, /* East Asian ideograph */
  {"\x9F", 0, 0x222E7E}, /* East Asian ideograph */
  {"\xB3", 0, 0x222F29}, /* East Asian ideograph */
  {"\x92", 0, 0x273F55}, /* East Asian ideograph */
  {"\x90", 0, 0x2D3F54}, /* East Asian ideograph */
  {"\xBD", 0, 0x2D4621}, /* East Asian ideograph */
  {"\xB4", 0, 0x333F58}, /* East Asian ideograph */
  {"\x83", 0, 0x393439}, /* East Asian ideograph */
  {"\x9E", 0, 0x3F5564}, /* East Asian ideograph */
  {"\x91", 0, 0x4B3F51}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page87 = {
  marc8r_31page87_flat, 0
};
/* PAGE 86 */
struct yaz_iconv_trie_flat marc8r_31page86_flat[] = {
  {"\x82", 0, 0x213F33}, /* East Asian ideograph */
  {"\xA7", 0, 0x213F3D}, /* East Asian ideograph */
  {"\xB2", 0, 0x213F3E}, /* East Asian ideograph */
  {"\x91", 0, 0x213F3F}, /* East Asian ideograph */
  {"\x8E", 0, 0x213F40}, /* East Asian ideograph */
  {"\xAB", 0, 0x213F41}, /* East Asian ideograph */
  {"\xA4", 0, 0x213F42}, /* East Asian ideograph */
  {"\xAC", 0, 0x213F43}, /* East Asian ideograph */
  {"\x9A", 0, 0x213F44}, /* East Asian ideograph */
  {"\xA9", 0, 0x213F45}, /* East Asian ideograph */
  {"\x94", 0, 0x213F46}, /* East Asian ideograph */
  {"\x8A", 0, 0x213F47}, /* East Asian ideograph */
  {"\xB6", 0, 0x213F48}, /* East Asian ideograph */
  {"\x90", 0, 0x213F4B}, /* East Asian ideograph */
  {"\xBE", 0, 0x213F4C}, /* East Asian ideograph */
  {"\x83", 0, 0x222D6B}, /* East Asian ideograph */
  {"\x8B", 0, 0x222E23}, /* East Asian ideograph */
  {"\x9D", 0, 0x222E32}, /* East Asian ideograph */
  {"\xA6", 0, 0x222E33}, /* East Asian ideograph */
  {"\xA2", 0, 0x222E3D}, /* East Asian ideograph */
  {"\xA8", 0, 0x222E40}, /* East Asian ideograph */
  {"\x9C", 0, 0x222E42}, /* East Asian ideograph */
  {"\xAF", 0, 0x222E43}, /* East Asian ideograph */
  {"\x96", 0, 0x222E45}, /* East Asian ideograph */
  {"\x97", 0, 0x222E46}, /* East Asian ideograph */
  {"\xAD", 0, 0x222E47}, /* East Asian ideograph */
  {"\x92", 0, 0x222E4C}, /* East Asian ideograph */
  {"\xAE", 0, 0x222E52}, /* East Asian ideograph */
  {"\x8D", 0, 0x222E55}, /* East Asian ideograph */
  {"\xBA", 0, 0x222E68}, /* East Asian ideograph */
  {"\xB8", 0, 0x222E6A}, /* East Asian ideograph */
  {"\x87", 0, 0x273F45}, /* East Asian ideograph */
  {"\x99", 0, 0x2D3661}, /* East Asian ideograph */
  {"\x85", 0, 0x2D3F3A}, /* East Asian ideograph */
  {"\xB7", 0, 0x706340}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page86 = {
  marc8r_31page86_flat, 0
};
/* PAGE 85 */
struct yaz_iconv_trie_flat marc8r_31page85_flat[] = {
  {"\x88", 0, 0x213F21}, /* East Asian ideograph */
  {"\xA8", 0, 0x213F22}, /* East Asian ideograph */
  {"\x8C", 0, 0x213F26}, /* East Asian ideograph */
  {"\x8D", 0, 0x213F27}, /* East Asian ideograph */
  {"\x8B", 0, 0x213F28}, /* East Asian ideograph */
  {"\x87", 0, 0x213F2C}, /* East Asian ideograph */
  {"\xB7", 0, 0x213F2D}, /* East Asian ideograph */
  {"\xB6", 0, 0x213F2E}, /* East Asian ideograph */
  {"\xA7", 0, 0x213F2F}, /* East Asian ideograph */
  {"\xB0", 0, 0x213F30}, /* East Asian ideograph */
  {"\x9A", 0, 0x213F31}, /* East Asian ideograph */
  {"\x9D", 0, 0x213F32}, /* East Asian ideograph */
  {"\xBC", 0, 0x213F34}, /* East Asian ideograph */
  {"\xA2", 0, 0x213F35}, /* East Asian ideograph */
  {"\xAE", 0, 0x213F36}, /* East Asian ideograph */
  {"\x95", 0, 0x213F37}, /* East Asian ideograph */
  {"\x98", 0, 0x213F38}, /* East Asian ideograph */
  {"\xA3", 0, 0x213F39}, /* East Asian ideograph */
  {"\x9F", 0, 0x213F3A}, /* East Asian ideograph */
  {"\xAB", 0, 0x213F3B}, /* East Asian ideograph */
  {"\xBE", 0, 0x213F3C}, /* East Asian ideograph */
  {"\x89", 0, 0x222D48}, /* East Asian ideograph */
  {"\x8A", 0, 0x222D4A}, /* East Asian ideograph */
  {"\x90", 0, 0x222D51}, /* East Asian ideograph */
  {"\x81", 0, 0x222D5B}, /* East Asian ideograph */
  {"\x86", 0, 0x222D61}, /* East Asian ideograph */
  {"\x9E", 0, 0x222D66}, /* East Asian ideograph */
  {"\xB5", 0, 0x222D67}, /* East Asian ideograph */
  {"\xB4", 0, 0x222D68}, /* East Asian ideograph */
  {"\xB1", 0, 0x222D70}, /* East Asian ideograph */
  {"\xAA", 0, 0x222D74}, /* East Asian ideograph */
  {"\xB3", 0, 0x222D77}, /* East Asian ideograph */
  {"\xA4", 0, 0x222D79}, /* East Asian ideograph */
  {"\x93", 0, 0x222D7B}, /* East Asian ideograph */
  {"\xAF", 0, 0x222E2C}, /* East Asian ideograph */
  {"\xA5", 0, 0x222E2D}, /* East Asian ideograph */
  {"\x9C", 0, 0x222E2F}, /* East Asian ideograph */
  {"\x91", 0, 0x273F59}, /* East Asian ideograph */
  {"\x99", 0, 0x2D3F31}, /* East Asian ideograph */
  {"\x84", 0, 0x334449}, /* East Asian ideograph */
  {"\x82", 0, 0x393E4C}, /* East Asian ideograph */
  {"\x8E", 0, 0x3F3F24}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page85 = {
  marc8r_31page85_flat, 0
};
/* PAGE 84 */
struct yaz_iconv_trie_flat marc8r_31page84_flat[] = {
  {"\x8F", 0, 0x213E6B}, /* East Asian ideograph */
  {"\x9C", 0, 0x213E6C}, /* East Asian ideograph */
  {"\x9F", 0, 0x213E6E}, /* East Asian ideograph */
  {"\x9A", 0, 0x213E72}, /* East Asian ideograph */
  {"\x95", 0, 0x213E73}, /* East Asian ideograph */
  {"\xA3", 0, 0x213E75}, /* East Asian ideograph */
  {"\x9B", 0, 0x213E77}, /* East Asian ideograph */
  {"\x8E", 0, 0x213E78}, /* East Asian ideograph */
  {"\x80", 0, 0x213E79}, /* East Asian ideograph */
  {"\x81", 0, 0x213E7A}, /* East Asian ideograph */
  {"\x89", 0, 0x213E7C}, /* East Asian ideograph */
  {"\x88", 0, 0x213E7D}, /* East Asian ideograph */
  {"\xBC", 0, 0x213F24}, /* East Asian ideograph */
  {"\xBE", 0, 0x213F29}, /* East Asian ideograph */
  {"\xA7", 0, 0x213F2A}, /* East Asian ideograph */
  {"\xB4", 0, 0x213F2B}, /* East Asian ideograph */
  {"\x94", 0, 0x222C70}, /* East Asian ideograph */
  {"\x83", 0, 0x222C73}, /* East Asian ideograph */
  {"\x99", 0, 0x222C75}, /* East Asian ideograph */
  {"\x8D", 0, 0x222C7D}, /* East Asian ideograph */
  {"\x8A", 0, 0x222D2A}, /* East Asian ideograph */
  {"\x90", 0, 0x222D2C}, /* East Asian ideograph */
  {"\x92", 0, 0x222D32}, /* East Asian ideograph */
  {"\xA5", 0, 0x222D37}, /* East Asian ideograph */
  {"\xA1", 0, 0x222D3F}, /* East Asian ideograph */
  {"\x86", 0, 0x222D43}, /* East Asian ideograph */
  {"\xAB", 0, 0x222D4E}, /* East Asian ideograph */
  {"\xA9", 0, 0x222D50}, /* East Asian ideograph */
  {"\xB0", 0, 0x222D58}, /* East Asian ideograph */
  {"\xB7", 0, 0x222D5E}, /* East Asian ideograph */
  {"\xA4", 0, 0x273F42}, /* East Asian ideograph */
  {"\xBF", 0, 0x276055}, /* East Asian ideograph */
  {"\xA6", 0, 0x282E4C}, /* East Asian ideograph */
  {"\xBD", 0, 0x2D3464}, /* East Asian ideograph */
  {"\xA0", 0, 0x2D3F27}, /* East Asian ideograph */
  {"\xAC", 0, 0x2D5856}, /* East Asian ideograph */
  {"\xA8", 0, 0x2E2D79}, /* East Asian ideograph */
  {"\xB3", 0, 0x333F5B}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page84 = {
  marc8r_31page84_flat, 0
};
/* PAGE 83 */
struct yaz_iconv_trie_flat marc8r_31page83_flat[] = {
  {"\xA6", 0, 0x213E58}, /* East Asian ideograph */
  {"\x8B", 0, 0x213E59}, /* East Asian ideograph */
  {"\x85", 0, 0x213E5B}, /* East Asian ideograph (variant of EACC 4B3E5B) */
  {"\x91", 0, 0x213E5D}, /* East Asian ideograph */
  {"\xA0", 0, 0x213E60}, /* East Asian ideograph */
  {"\xA1", 0, 0x213E61}, /* East Asian ideograph */
  {"\x9C", 0, 0x213E62}, /* East Asian ideograph */
  {"\x98", 0, 0x213E63}, /* East Asian ideograph */
  {"\x95", 0, 0x213E64}, /* East Asian ideograph */
  {"\x86", 0, 0x213E67}, /* East Asian ideograph */
  {"\x9A", 0, 0x213E69}, /* East Asian ideograph */
  {"\x9F", 0, 0x213E6A}, /* East Asian ideograph */
  {"\xB3", 0, 0x213E6D}, /* East Asian ideograph */
  {"\xB0", 0, 0x213E6F}, /* East Asian ideograph */
  {"\xBB", 0, 0x213E70}, /* East Asian ideograph */
  {"\xBA", 0, 0x213E71}, /* East Asian ideograph */
  {"\xB9", 0, 0x213E74}, /* East Asian ideograph */
  {"\xB4", 0, 0x213E76}, /* East Asian ideograph */
  {"\xB6", 0, 0x213E7B}, /* East Asian ideograph */
  {"\xB1", 0, 0x213E7E}, /* East Asian ideograph */
  {"\x87", 0, 0x222C3E}, /* East Asian ideograph */
  {"\x93", 0, 0x222C47}, /* East Asian ideograph */
  {"\x94", 0, 0x222C48}, /* East Asian ideograph */
  {"\x8E", 0, 0x222C4E}, /* East Asian ideograph */
  {"\x8F", 0, 0x222C51}, /* East Asian ideograph */
  {"\x99", 0, 0x222C53}, /* East Asian ideograph */
  {"\x9D", 0, 0x222C56}, /* East Asian ideograph */
  {"\x84", 0, 0x222C5D}, /* East Asian ideograph */
  {"\xA3", 0, 0x222C62}, /* East Asian ideograph */
  {"\xA2", 0, 0x222C66}, /* East Asian ideograph */
  {"\xA5", 0, 0x222C67}, /* East Asian ideograph */
  {"\x9B", 0, 0x222C69}, /* East Asian ideograph */
  {"\xA9", 0, 0x222C6E}, /* East Asian ideograph */
  {"\xBD", 0, 0x222C7C}, /* East Asian ideograph */
  {"\xB2", 0, 0x222D34}, /* East Asian ideograph */
  {"\xB8", 0, 0x222D3B}, /* East Asian ideograph */
  {"\xBC", 0, 0x222D41}, /* East Asian ideograph */
  {"\xAC", 0, 0x273E6C}, /* East Asian ideograph */
  {"\xAD", 0, 0x273F31}, /* East Asian ideograph */
  {"\xA8", 0, 0x273F38}, /* East Asian ideograph */
  {"\xAF", 0, 0x273F39}, /* East Asian ideograph */
  {"\xAE", 0, 0x273F44}, /* East Asian ideograph */
  {"\xAB", 0, 0x273F47}, /* East Asian ideograph */
  {"\xA7", 0, 0x273F5B}, /* East Asian ideograph */
  {"\x8A", 0, 0x27614B}, /* East Asian ideograph */
  {"\xAA", 0, 0x2D3D75}, /* East Asian ideograph */
  {"\xB7", 0, 0x2D573B}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page83 = {
  marc8r_31page83_flat, 0
};
/* PAGE 82 */
struct yaz_iconv_trie_flat marc8r_31page82_flat[] = {
  {"\x8C", 0, 0x213E4A}, /* East Asian ideograph */
  {"\xA6", 0, 0x213E4B}, /* East Asian ideograph */
  {"\x9F", 0, 0x213E4D}, /* East Asian ideograph */
  {"\x9A", 0, 0x213E4E}, /* East Asian ideograph */
  {"\x96", 0, 0x213E4F}, /* East Asian ideograph */
  {"\x84", 0, 0x213E50}, /* East Asian ideograph */
  {"\x8D", 0, 0x213E51}, /* East Asian ideograph */
  {"\xA3", 0, 0x213E52}, /* East Asian ideograph */
  {"\x89", 0, 0x213E53}, /* East Asian ideograph */
  {"\x94", 0, 0x213E54}, /* East Asian ideograph */
  {"\xA0", 0, 0x213E55}, /* East Asian ideograph */
  {"\xA8", 0, 0x213E56}, /* East Asian ideograph */
  {"\xB4", 0, 0x213E57}, /* East Asian ideograph */
  {"\xB6", 0, 0x213E5C}, /* East Asian ideograph */
  {"\xB5", 0, 0x213E5E}, /* East Asian ideograph */
  {"\xBB", 0, 0x213E5F}, /* East Asian ideograph */
  {"\xBC", 0, 0x213E65}, /* East Asian ideograph */
  {"\xB2", 0, 0x213E66}, /* East Asian ideograph */
  {"\xB8", 0, 0x213E68}, /* East Asian ideograph */
  {"\x8A", 0, 0x222C24}, /* East Asian ideograph */
  {"\x92", 0, 0x222C2B}, /* East Asian ideograph */
  {"\x9D", 0, 0x222C2C}, /* East Asian ideograph */
  {"\x81", 0, 0x222C2D}, /* East Asian ideograph */
  {"\x9E", 0, 0x222C2F}, /* East Asian ideograph */
  {"\x83", 0, 0x222C30}, /* East Asian ideograph */
  {"\x97", 0, 0x222C32}, /* East Asian ideograph */
  {"\xA7", 0, 0x222C34}, /* East Asian ideograph */
  {"\x95", 0, 0x222C3A}, /* East Asian ideograph */
  {"\xB0", 0, 0x222C42}, /* East Asian ideograph */
  {"\xBE", 0, 0x222C46}, /* East Asian ideograph */
  {"\xB3", 0, 0x222C54}, /* East Asian ideograph */
  {"\xB1", 0, 0x222C60}, /* East Asian ideograph */
  {"\xAF", 0, 0x273F41}, /* East Asian ideograph */
  {"\xAC", 0, 0x273F56}, /* East Asian ideograph */
  {"\xAD", 0, 0x282D77}, /* East Asian ideograph */
  {"\xAB", 0, 0x282D79}, /* East Asian ideograph */
  {"\x9B", 0, 0x2E2B74}, /* East Asian ideograph */
  {"\x8B", 0, 0x33354E}, /* East Asian ideograph */
  {"\xBD", 0, 0x33475F}, /* East Asian ideograph */
  {"\xAA", 0, 0x393E61}, /* East Asian ideograph */
  {"\xA4", 0, 0x396C6B}, /* East Asian ideograph */
  {"\xA9", 0, 0x4B3E7E}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page82 = {
  marc8r_31page82_flat, 0
};
/* PAGE 81 */
struct yaz_iconv_trie_flat marc8r_31page81_flat[] = {
  {"\x99", 0, 0x213E38}, /* East Asian ideograph */
  {"\xA3", 0, 0x213E39}, /* East Asian ideograph */
  {"\xA8", 0, 0x213E3A}, /* East Asian ideograph */
  {"\x83", 0, 0x213E3B}, /* East Asian ideograph */
  {"\xA5", 0, 0x213E3C}, /* East Asian ideograph */
  {"\x90", 0, 0x213E3D}, /* East Asian ideograph */
  {"\xAD", 0, 0x213E3E}, /* East Asian ideograph */
  {"\xA2", 0, 0x213E3F}, /* East Asian ideograph */
  {"\x86", 0, 0x213E40}, /* East Asian ideograph (variant of EACC 4B3E40) */
  {"\x8D", 0, 0x213E41}, /* East Asian ideograph */
  {"\xAB", 0, 0x213E42}, /* East Asian ideograph */
  {"\xA9", 0, 0x213E43}, /* East Asian ideograph */
  {"\xAC", 0, 0x213E44}, /* East Asian ideograph */
  {"\xAF", 0, 0x213E45}, /* East Asian ideograph */
  {"\xAA", 0, 0x213E46}, /* East Asian ideograph */
  {"\xA4", 0, 0x213E47}, /* East Asian ideograph */
  {"\xB0", 0, 0x213E48}, /* East Asian ideograph */
  {"\x95", 0, 0x213E49}, /* East Asian ideograph */
  {"\xBF", 0, 0x213E4C}, /* East Asian ideograph */
  {"\x94", 0, 0x222B53}, /* East Asian ideograph */
  {"\x9D", 0, 0x222B57}, /* East Asian ideograph */
  {"\x87", 0, 0x222B5A}, /* East Asian ideograph */
  {"\x89", 0, 0x222B5E}, /* East Asian ideograph */
  {"\x93", 0, 0x222B5F}, /* East Asian ideograph */
  {"\xA7", 0, 0x222B68}, /* East Asian ideograph */
  {"\x8C", 0, 0x222B6F}, /* East Asian ideograph */
  {"\x81", 0, 0x222B71}, /* East Asian ideograph */
  {"\xB7", 0, 0x222B72}, /* East Asian ideograph */
  {"\x82", 0, 0x222B74}, /* East Asian ideograph */
  {"\x9F", 0, 0x222B76}, /* East Asian ideograph */
  {"\xA1", 0, 0x222B7A}, /* East Asian ideograph */
  {"\xB6", 0, 0x273E61}, /* East Asian ideograph */
  {"\xBB", 0, 0x273E70}, /* East Asian ideograph */
  {"\xBC", 0, 0x273E7E}, /* East Asian ideograph */
  {"\xB8", 0, 0x273F3A}, /* East Asian ideograph */
  {"\xB3", 0, 0x273F4E}, /* East Asian ideograph */
  {"\x8B", 0, 0x273F5C}, /* East Asian ideograph */
  {"\xBD", 0, 0x282D34}, /* East Asian ideograph */
  {"\xBA", 0, 0x282D5E}, /* East Asian ideograph */
  {"\xB9", 0, 0x282E79}, /* East Asian ideograph */
  {"\xA0", 0, 0x2D3E2B}, /* East Asian ideograph */
  {"\x92", 0, 0x2D3E40}, /* East Asian ideograph */
  {"\xB5", 0, 0x2D3E60}, /* East Asian ideograph */
  {"\x9A", 0, 0x2E2B5B}, /* East Asian ideograph */
  {"\x8A", 0, 0x393460}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page81 = {
  marc8r_31page81_flat, 0
};
/* PAGE 80 */
struct yaz_iconv_trie_flat marc8r_31page80_flat[] = {
  {"\x94", 0, 0x213E29}, /* East Asian ideograph */
  {"\xB5", 0, 0x213E2A}, /* East Asian ideograph (variant of EACC 4B3E2A) */
  {"\xAA", 0, 0x213E2B}, /* East Asian ideograph */
  {"\xAF", 0, 0x213E2C}, /* East Asian ideograph */
  {"\x96", 0, 0x213E2D}, /* East Asian ideograph */
  {"\x9D", 0, 0x213E2E}, /* East Asian ideograph */
  {"\x8F", 0, 0x213E2F}, /* East Asian ideograph */
  {"\xA1", 0, 0x213E30}, /* East Asian ideograph */
  {"\xA0", 0, 0x213E31}, /* East Asian ideograph */
  {"\xA8", 0, 0x213E32}, /* East Asian ideograph */
  {"\xA5", 0, 0x213E33}, /* East Asian ideograph */
  {"\xA7", 0, 0x213E34}, /* East Asian ideograph */
  {"\x8E", 0, 0x213E35}, /* East Asian ideograph */
  {"\x95", 0, 0x213E36}, /* East Asian ideograph */
  {"\x92", 0, 0x213E37}, /* East Asian ideograph */
  {"\xA6", 0, 0x222B2A}, /* East Asian ideograph */
  {"\xA9", 0, 0x222B2C}, /* East Asian ideograph */
  {"\xAB", 0, 0x222B2D}, /* East Asian ideograph */
  {"\x99", 0, 0x222B30}, /* East Asian ideograph */
  {"\x88", 0, 0x222B31}, /* East Asian ideograph */
  {"\x8A", 0, 0x222B36}, /* East Asian ideograph */
  {"\x8C", 0, 0x222B37}, /* East Asian ideograph */
  {"\x9B", 0, 0x222B38}, /* East Asian ideograph */
  {"\x97", 0, 0x222B3C}, /* East Asian ideograph */
  {"\xB3", 0, 0x222B3D}, /* East Asian ideograph */
  {"\x8D", 0, 0x222B45}, /* East Asian ideograph */
  {"\x90", 0, 0x222B46}, /* East Asian ideograph */
  {"\xB9", 0, 0x222B4B}, /* East Asian ideograph */
  {"\x93", 0, 0x222B50}, /* East Asian ideograph */
  {"\x85", 0, 0x273E5E}, /* East Asian ideograph */
  {"\x81", 0, 0x273F28}, /* East Asian ideograph */
  {"\x86", 0, 0x273F2B}, /* East Asian ideograph */
  {"\x82", 0, 0x273F3B}, /* East Asian ideograph */
  {"\x9C", 0, 0x273F4B}, /* East Asian ideograph */
  {"\x80", 0, 0x273F54}, /* East Asian ideograph */
  {"\xBB", 0, 0x27516D}, /* East Asian ideograph */
  {"\x84", 0, 0x282D74}, /* East Asian ideograph */
  {"\x83", 0, 0x282E52}, /* East Asian ideograph */
  {"\xBF", 0, 0x282E5C}, /* East Asian ideograph */
  {"\xBC", 0, 0x282E7E}, /* East Asian ideograph */
  {"\xB1", 0, 0x336C6B}, /* East Asian ideograph */
  {"\xBA", 0, 0x69576A}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page80 = {
  marc8r_31page80_flat, 0
};
/* PAGE 79 */
struct yaz_iconv_trie_flat marc8r_31page79_flat[] = {
  {"\xBC", 0, 0x21352A}, /* East Asian ideograph */
  {"\x81", 0, 0x214347}, /* East Asian ideograph */
  {"\x89", 0, 0x214348}, /* East Asian ideograph */
  {"\x86", 0, 0x214349}, /* East Asian ideograph */
  {"\x96", 0, 0x21434B}, /* East Asian ideograph */
  {"\x99", 0, 0x21434C}, /* East Asian ideograph */
  {"\xA0", 0, 0x21434D}, /* East Asian ideograph */
  {"\x9D", 0, 0x21434E}, /* East Asian ideograph */
  {"\xA6", 0, 0x21434F}, /* East Asian ideograph */
  {"\xB0", 0, 0x214350}, /* East Asian ideograph */
  {"\xB2", 0, 0x214351}, /* East Asian ideograph */
  {"\xB3", 0, 0x214352}, /* East Asian ideograph */
  {"\xB4", 0, 0x214353}, /* East Asian ideograph */
  {"\xB7", 0, 0x214354}, /* East Asian ideograph */
  {"\xB8", 0, 0x214355}, /* East Asian ideograph */
  {"\xB9", 0, 0x214356}, /* East Asian ideograph */
  {"\xBE", 0, 0x214358}, /* East Asian ideograph */
  {"\xBF", 0, 0x214359}, /* East Asian ideograph */
  {"\x88", 0, 0x22394E}, /* East Asian ideograph */
  {"\x80", 0, 0x223954}, /* East Asian ideograph */
  {"\x87", 0, 0x223955}, /* East Asian ideograph */
  {"\x84", 0, 0x22395C}, /* East Asian ideograph */
  {"\x8F", 0, 0x223960}, /* East Asian ideograph */
  {"\x9A", 0, 0x223971}, /* East Asian ideograph */
  {"\x9B", 0, 0x223972}, /* East Asian ideograph */
  {"\xA2", 0, 0x223973}, /* East Asian ideograph */
  {"\xA1", 0, 0x223976}, /* East Asian ideograph */
  {"\xA8", 0, 0x223978}, /* East Asian ideograph */
  {"\xA9", 0, 0x22397C}, /* East Asian ideograph */
  {"\xAC", 0, 0x2D432E}, /* East Asian ideograph */
  {"\x8D", 0, 0x2E3936}, /* East Asian ideograph */
  {"\x9C", 0, 0x39525B}, /* East Asian ideograph */
  {"\xB5", 0, 0x4B4352}, /* East Asian ideograph */
  {"\xBD", 0, 0x4B4358}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page79 = {
  marc8r_31page79_flat, 0
};
/* PAGE 78 */
struct yaz_iconv_trie_flat marc8r_31page78_flat[] = {
  {"\x80", 0, 0x213335}, /* East Asian ideograph */
  {"\x83", 0, 0x21435A}, /* East Asian ideograph */
  {"\x88", 0, 0x21435B}, /* East Asian ideograph */
  {"\x89", 0, 0x21435C}, /* East Asian ideograph */
  {"\x8D", 0, 0x21435D}, /* East Asian ideograph */
  {"\x8B", 0, 0x21435E}, /* East Asian ideograph */
  {"\x97", 0, 0x21435F}, /* East Asian ideograph */
  {"\x95", 0, 0x214360}, /* East Asian ideograph */
  {"\x94", 0, 0x214361}, /* East Asian ideograph */
  {"\x9B", 0, 0x214362}, /* East Asian ideograph */
  {"\x9D", 0, 0x214363}, /* East Asian ideograph */
  {"\x9F", 0, 0x214364}, /* East Asian ideograph */
  {"\xA7", 0, 0x214366}, /* East Asian ideograph */
  {"\xA8", 0, 0x214367}, /* East Asian ideograph */
  {"\xAC", 0, 0x214369}, /* East Asian ideograph */
  {"\xAB", 0, 0x21436A}, /* East Asian ideograph */
  {"\xAA", 0, 0x21436B}, /* East Asian ideograph */
  {"\xBD", 0, 0x21436D}, /* East Asian ideograph */
  {"\xB1", 0, 0x21436F}, /* East Asian ideograph */
  {"\xB5", 0, 0x214370}, /* East Asian ideograph */
  {"\x86", 0, 0x216C7B}, /* East Asian ideograph */
  {"\x85", 0, 0x223A28}, /* East Asian ideograph */
  {"\x8F", 0, 0x223A30}, /* East Asian ideograph */
  {"\x90", 0, 0x223A31}, /* East Asian ideograph */
  {"\x92", 0, 0x223A33}, /* East Asian ideograph */
  {"\x93", 0, 0x223A34}, /* East Asian ideograph */
  {"\x99", 0, 0x223A38}, /* East Asian ideograph */
  {"\x98", 0, 0x223A39}, /* East Asian ideograph */
  {"\xA3", 0, 0x223A47}, /* East Asian ideograph */
  {"\xBE", 0, 0x223A4C}, /* East Asian ideograph */
  {"\xBF", 0, 0x223A4E}, /* East Asian ideograph */
  {"\x8A", 0, 0x22775C}, /* East Asian ideograph */
  {"\x91", 0, 0x227775}, /* East Asian ideograph */
  {"\xA0", 0, 0x22792E}, /* East Asian ideograph */
  {"\xA5", 0, 0x22797E}, /* East Asian ideograph */
  {"\xB4", 0, 0x274558}, /* East Asian ideograph */
  {"\xBA", 0, 0x27455D}, /* East Asian ideograph */
  {"\xAE", 0, 0x275746}, /* East Asian ideograph */
  {"\xAD", 0, 0x276B5F}, /* East Asian ideograph */
  {"\x96", 0, 0x2D435F}, /* East Asian ideograph */
  {"\xA2", 0, 0x2D4362}, /* East Asian ideograph */
  {"\x9E", 0, 0x2D4364}, /* East Asian ideograph */
  {"\xB6", 0, 0x2D4370}, /* East Asian ideograph */
  {"\xB8", 0, 0x2E2F7A}, /* East Asian ideograph */
  {"\x82", 0, 0x334357}, /* East Asian ideograph */
  {"\xA6", 0, 0x395564}, /* East Asian ideograph */
  {"\xAF", 0, 0x455746}, /* East Asian ideograph */
  {"\xB7", 0, 0x695B37}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page78 = {
  marc8r_31page78_flat, 0
};
/* PAGE 77 */
struct yaz_iconv_trie_flat marc8r_31page77_flat[] = {
  {"\x83", 0, 0x213D78}, /* East Asian ideograph */
  {"\x85", 0, 0x213D79}, /* East Asian ideograph */
  {"\x99", 0, 0x213D7A}, /* East Asian ideograph */
  {"\x98", 0, 0x213D7B}, /* East Asian ideograph */
  {"\x8C", 0, 0x213D7C}, /* East Asian ideograph */
  {"\x96", 0, 0x213D7D}, /* East Asian ideograph */
  {"\x8D", 0, 0x213E21}, /* East Asian ideograph */
  {"\xAB", 0, 0x213E22}, /* East Asian ideograph */
  {"\xA0", 0, 0x213E23}, /* East Asian ideograph */
  {"\xB1", 0, 0x213E24}, /* East Asian ideograph */
  {"\xBD", 0, 0x213E25}, /* East Asian ideograph */
  {"\x9D", 0, 0x213E26}, /* East Asian ideograph */
  {"\xB5", 0, 0x213E27}, /* East Asian ideograph */
  {"\xBF", 0, 0x213E28}, /* East Asian ideograph */
  {"\x89", 0, 0x222A57}, /* East Asian ideograph */
  {"\x91", 0, 0x222A5F}, /* East Asian ideograph */
  {"\x92", 0, 0x222A61}, /* East Asian ideograph */
  {"\x90", 0, 0x222A63}, /* East Asian ideograph */
  {"\x8E", 0, 0x222A67}, /* East Asian ideograph */
  {"\xAD", 0, 0x222A68}, /* East Asian ideograph */
  {"\xAE", 0, 0x222A72}, /* East Asian ideograph */
  {"\xB8", 0, 0x222A73}, /* East Asian ideograph */
  {"\xA1", 0, 0x222A78}, /* East Asian ideograph */
  {"\xA4", 0, 0x222A7B}, /* East Asian ideograph */
  {"\xAA", 0, 0x222B24}, /* East Asian ideograph */
  {"\xB0", 0, 0x273E57}, /* East Asian ideograph */
  {"\xBE", 0, 0x273F29}, /* East Asian ideograph */
  {"\xA7", 0, 0x273F33}, /* East Asian ideograph */
  {"\x86", 0, 0x273F48}, /* East Asian ideograph */
  {"\x8F", 0, 0x273F58}, /* East Asian ideograph */
  {"\x97", 0, 0x27586D}, /* East Asian ideograph */
  {"\xBB", 0, 0x2D4574}, /* East Asian ideograph */
  {"\x88", 0, 0x333066}, /* East Asian ideograph */
  {"\x9E", 0, 0x343875}, /* East Asian ideograph */
  {"\x9C", 0, 0x4B3F4A}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page77 = {
  marc8r_31page77_flat, 0
};
/* PAGE 76 */
struct yaz_iconv_trie_flat marc8r_31page76_flat[] = {
  {"\x80", 0, 0x213D5C}, /* East Asian ideograph */
  {"\x85", 0, 0x213D60}, /* East Asian ideograph */
  {"\x88", 0, 0x213D61}, /* East Asian ideograph */
  {"\x8B", 0, 0x213D62}, /* East Asian ideograph */
  {"\x8A", 0, 0x213D63}, /* East Asian ideograph */
  {"\x87", 0, 0x213D64}, /* East Asian ideograph */
  {"\x8C", 0, 0x213D65}, /* East Asian ideograph */
  {"\x92", 0, 0x213D66}, /* East Asian ideograph */
  {"\x91", 0, 0x213D67}, /* East Asian ideograph */
  {"\x90", 0, 0x213D68}, /* East Asian ideograph */
  {"\x98", 0, 0x213D69}, /* East Asian ideograph */
  {"\x97", 0, 0x213D6A}, /* East Asian ideograph */
  {"\x99", 0, 0x213D6B}, /* East Asian ideograph */
  {"\x9E", 0, 0x213D6C}, /* East Asian ideograph */
  {"\xA9", 0, 0x213D6F}, /* East Asian ideograph */
  {"\xAA", 0, 0x213D71}, /* East Asian ideograph */
  {"\xAC", 0, 0x213D72}, /* East Asian ideograph */
  {"\xAE", 0, 0x213D73}, /* East Asian ideograph */
  {"\xB9", 0, 0x213D74}, /* East Asian ideograph */
  {"\xB7", 0, 0x213D75}, /* East Asian ideograph */
  {"\xB5", 0, 0x213D76}, /* East Asian ideograph */
  {"\xBD", 0, 0x213D77}, /* East Asian ideograph */
  {"\x82", 0, 0x222A23}, /* East Asian ideograph */
  {"\x89", 0, 0x222A27}, /* East Asian ideograph */
  {"\x94", 0, 0x222A2B}, /* East Asian ideograph */
  {"\x9C", 0, 0x222A39}, /* East Asian ideograph */
  {"\x9A", 0, 0x222A3D}, /* East Asian ideograph */
  {"\xAF", 0, 0x222A46}, /* East Asian ideograph */
  {"\xBC", 0, 0x222A50}, /* East Asian ideograph */
  {"\x84", 0, 0x273D67}, /* East Asian ideograph */
  {"\x81", 0, 0x273D76}, /* East Asian ideograph */
  {"\x93", 0, 0x2D3D6C}, /* East Asian ideograph */
  {"\xB4", 0, 0x2D3D76}, /* East Asian ideograph */
  {"\xA1", 0, 0x2D4E79}, /* East Asian ideograph */
  {"\xA7", 0, 0x2D5C3F}, /* East Asian ideograph */
  {"\xA8", 0, 0x2D5C40}, /* East Asian ideograph */
  {"\xAD", 0, 0x2E7328}, /* East Asian ideograph */
  {"\x8F", 0, 0x2F4A4A}, /* East Asian ideograph */
  {"\xA0", 0, 0x33314C}, /* East Asian ideograph */
  {"\xBA", 0, 0x333251}, /* East Asian ideograph */
  {"\xB3", 0, 0x333D75}, /* East Asian ideograph */
  {"\x95", 0, 0x4B314C}, /* East Asian ideograph */
  {"\x83", 0, 0x4B3D5C}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page76 = {
  marc8r_31page76_flat, 0
};
/* PAGE 75 */
struct yaz_iconv_trie_flat marc8r_31page75_flat[] = {
  {"\x86", 0, 0x213D4A}, /* East Asian ideograph */
  {"\x88", 0, 0x213D4B}, /* East Asian ideograph */
  {"\x8C", 0, 0x213D4C}, /* East Asian ideograph */
  {"\x8E", 0, 0x213D4D}, /* East Asian ideograph */
  {"\x97", 0, 0x213D4E}, /* East Asian ideograph */
  {"\x99", 0, 0x213D4F}, /* East Asian ideograph */
  {"\x9D", 0, 0x213D50}, /* East Asian ideograph */
  {"\xA2", 0, 0x213D51}, /* East Asian ideograph */
  {"\xA4", 0, 0x213D52}, /* East Asian ideograph */
  {"\xA5", 0, 0x213D53}, /* East Asian ideograph */
  {"\xAC", 0, 0x213D54}, /* East Asian ideograph */
  {"\xA9", 0, 0x213D55}, /* East Asian ideograph */
  {"\xAD", 0, 0x213D57}, /* East Asian ideograph */
  {"\xB0", 0, 0x213D58}, /* East Asian ideograph */
  {"\xB1", 0, 0x213D59}, /* East Asian ideograph */
  {"\xB9", 0, 0x213D5B}, /* East Asian ideograph */
  {"\xBF", 0, 0x213D5E}, /* East Asian ideograph */
  {"\xBC", 0, 0x213D5F}, /* East Asian ideograph */
  {"\xAA", 0, 0x215646}, /* East Asian ideograph */
  {"\x80", 0, 0x22295C}, /* East Asian ideograph */
  {"\x84", 0, 0x22295F}, /* East Asian ideograph */
  {"\x8D", 0, 0x222962}, /* East Asian ideograph */
  {"\x90", 0, 0x222968}, /* East Asian ideograph */
  {"\x94", 0, 0x222969}, /* East Asian ideograph */
  {"\x96", 0, 0x22296A}, /* East Asian ideograph */
  {"\x98", 0, 0x22296C}, /* East Asian ideograph */
  {"\xA0", 0, 0x222970}, /* East Asian ideograph */
  {"\xA1", 0, 0x222971}, /* East Asian ideograph */
  {"\xA3", 0, 0x222972}, /* East Asian ideograph */
  {"\xA7", 0, 0x222974}, /* East Asian ideograph */
  {"\xB2", 0, 0x222978}, /* East Asian ideograph */
  {"\xB3", 0, 0x222979}, /* East Asian ideograph */
  {"\xB4", 0, 0x22297C}, /* East Asian ideograph */
  {"\x93", 0, 0x273746}, /* East Asian ideograph (duplicate simplified) */
  {"\xBB", 0, 0x273D74}, /* East Asian ideograph */
  {"\x92", 0, 0x27462B}, /* East Asian ideograph */
  {"\x95", 0, 0x275D74}, /* East Asian ideograph */
  {"\x8A", 0, 0x2D3D48}, /* East Asian ideograph */
  {"\x9C", 0, 0x2D3D50}, /* East Asian ideograph */
  {"\x91", 0, 0x2E2968}, /* East Asian ideograph */
  {"\xB7", 0, 0x333078}, /* East Asian ideograph */
  {"\xAB", 0, 0x395F49}, /* East Asian ideograph */
  {"\xA6", 0, 0x453D53}, /* East Asian ideograph */
  {"\x81", 0, 0x69573B}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page75 = {
  marc8r_31page75_flat, 0
};
/* PAGE 74 */
struct yaz_iconv_trie_flat marc8r_31page74_flat[] = {
  {"\x84", 0, 0x213D36}, /* East Asian ideograph */
  {"\x88", 0, 0x213D37}, /* East Asian ideograph */
  {"\x8A", 0, 0x213D38}, /* East Asian ideograph */
  {"\x8F", 0, 0x213D39}, /* East Asian ideograph */
  {"\x92", 0, 0x213D3A}, /* East Asian ideograph */
  {"\x93", 0, 0x213D3B}, /* East Asian ideograph */
  {"\x95", 0, 0x213D3C}, /* East Asian ideograph */
  {"\x94", 0, 0x213D3D}, /* East Asian ideograph */
  {"\x98", 0, 0x213D3E}, /* East Asian ideograph */
  {"\x97", 0, 0x213D3F}, /* East Asian ideograph */
  {"\x9B", 0, 0x213D40}, /* East Asian ideograph */
  {"\x9F", 0, 0x213D41}, /* East Asian ideograph */
  {"\xA6", 0, 0x213D42}, /* East Asian ideograph */
  {"\xA7", 0, 0x213D43}, /* East Asian ideograph */
  {"\xA9", 0, 0x213D44}, /* East Asian ideograph */
  {"\xAD", 0, 0x213D45}, /* East Asian ideograph */
  {"\xB1", 0, 0x213D46}, /* East Asian ideograph */
  {"\xB5", 0, 0x213D47}, /* East Asian ideograph */
  {"\xB7", 0, 0x213D48}, /* East Asian ideograph */
  {"\xBC", 0, 0x213D49}, /* East Asian ideograph */
  {"\x87", 0, 0x222935}, /* East Asian ideograph */
  {"\x8B", 0, 0x22293A}, /* East Asian ideograph */
  {"\xA8", 0, 0x22294A}, /* East Asian ideograph */
  {"\xA2", 0, 0x22294B}, /* East Asian ideograph */
  {"\xA3", 0, 0x22294C}, /* East Asian ideograph */
  {"\xA4", 0, 0x22294D}, /* East Asian ideograph */
  {"\xB3", 0, 0x222951}, /* East Asian ideograph */
  {"\xB0", 0, 0x222952}, /* East Asian ideograph */
  {"\xB8", 0, 0x222958}, /* East Asian ideograph */
  {"\xA0", 0, 0x273D47}, /* East Asian ideograph */
  {"\xB9", 0, 0x273D4B}, /* East Asian ideograph */
  {"\xA5", 0, 0x273D4C}, /* East Asian ideograph */
  {"\xAF", 0, 0x273D4D}, /* East Asian ideograph */
  {"\x83", 0, 0x27446D}, /* East Asian ideograph */
  {"\x82", 0, 0x274C34}, /* East Asian ideograph */
  {"\x80", 0, 0x275E53}, /* East Asian ideograph */
  {"\xAA", 0, 0x282951}, /* East Asian ideograph */
  {"\x8C", 0, 0x2D3021}, /* East Asian ideograph */
  {"\x8D", 0, 0x2D3051}, /* East Asian ideograph */
  {"\xBA", 0, 0x333D48}, /* East Asian ideograph */
  {"\x90", 0, 0x4B3051}, /* East Asian ideograph */
  {"\x89", 0, 0x4B393A}, /* East Asian ideograph */
  {"\xBE", 0, 0x4B3D4B}, /* East Asian ideograph */
  {"\x81", 0, 0x4B5B5E}, /* East Asian ideograph */
  {"\x96", 0, 0x695737}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page74 = {
  marc8r_31page74_flat, 0
};
/* PAGE 73 */
struct yaz_iconv_trie_dir marc8r_31page73_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {272, 0, 0},
  {273, 0, 0},
  {274, 0, 0},
  {275, 0, 0},
  {276, 0, 0},
  {277, 0, 0},
  {278, 0, 0},
  {279, 0, 0},
  {280, 0, 0},
  {281, 0, 0},
  {282, 0, 0},
  {283, 0, 0},
  {284, 0, 0},
  {285, 0, 0},
  {286, 0, 0},
  {287, 0, 0},
  {288, 0, 0},
  {289, 0, 0},
  {331, 0, 0},
  {334, 0, 0},
  {335, 0, 0},
  {290, 0, 0},
  {291, 0, 0},
  {292, 0, 0},
  {293, 0, 0},
  {294, 0, 0},
  {295, 0, 0},
  {296, 0, 0},
  {297, 0, 0},
  {298, 0, 0},
  {299, 0, 0},
  {300, 0, 0},
  {301, 0, 0},
  {302, 0, 0},
  {303, 0, 0},
  {304, 0, 0},
  {305, 0, 0},
  {306, 0, 0},
  {307, 0, 0},
  {308, 0, 0},
  {309, 0, 0},
  {310, 0, 0},
  {311, 0, 0},
  {312, 0, 0},
  {313, 0, 0},
  {314, 0, 0},
  {315, 0, 0},
  {316, 0, 0},
  {317, 0, 0},
  {318, 0, 0},
  {336, 0, 0},
  {319, 0, 0},
  {320, 0, 0},
  {321, 0, 0},
  {322, 0, 0},
  {323, 0, 0},
  {324, 0, 0},
  {325, 0, 0},
  {326, 0, 0},
  {327, 0, 0},
  {328, 0, 0},
  {329, 0, 0},
  {271, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page73 = {
  0, marc8r_31page73_dir
};
/* PAGE 72 */
struct yaz_iconv_trie_flat marc8r_31page72_flat[] = {
  {"\x82", 0, 0x213C7D}, /* East Asian ideograph */
  {"\x81", 0, 0x213C7E}, /* East Asian ideograph */
  {"\x8A", 0, 0x213D22}, /* East Asian ideograph */
  {"\x89", 0, 0x213D23}, /* East Asian ideograph */
  {"\x88", 0, 0x213D24}, /* East Asian ideograph */
  {"\x93", 0, 0x213D25}, /* East Asian ideograph */
  {"\x96", 0, 0x213D26}, /* East Asian ideograph */
  {"\xA2", 0, 0x213D27}, /* East Asian ideograph */
  {"\x9A", 0, 0x213D28}, /* East Asian ideograph */
  {"\x9D", 0, 0x213D29}, /* East Asian ideograph */
  {"\xA3", 0, 0x213D2A}, /* East Asian ideograph (variant of EACC 4B3D2A) */
  {"\x9F", 0, 0x213D2B}, /* East Asian ideograph */
  {"\xA0", 0, 0x213D2C}, /* East Asian ideograph */
  {"\xAC", 0, 0x213D2E}, /* East Asian ideograph */
  {"\xB3", 0, 0x213D2F}, /* East Asian ideograph */
  {"\xB7", 0, 0x213D30}, /* East Asian ideograph */
  {"\xB6", 0, 0x213D32}, /* East Asian ideograph */
  {"\xBA", 0, 0x213D33}, /* East Asian ideograph */
  {"\xBF", 0, 0x213D34}, /* East Asian ideograph */
  {"\x84", 0, 0x22284C}, /* East Asian ideograph */
  {"\x8C", 0, 0x222851}, /* East Asian ideograph */
  {"\x8B", 0, 0x222855}, /* East Asian ideograph */
  {"\x8D", 0, 0x222857}, /* East Asian ideograph */
  {"\x92", 0, 0x22285A}, /* East Asian ideograph */
  {"\x91", 0, 0x22285B}, /* East Asian ideograph */
  {"\x95", 0, 0x22285C}, /* East Asian ideograph */
  {"\x94", 0, 0x22285F}, /* East Asian ideograph */
  {"\x99", 0, 0x222860}, /* East Asian ideograph */
  {"\x8E", 0, 0x222861}, /* East Asian ideograph */
  {"\xA1", 0, 0x222868}, /* East Asian ideograph */
  {"\xA7", 0, 0x22286D}, /* East Asian ideograph */
  {"\xA8", 0, 0x222871}, /* East Asian ideograph */
  {"\xAD", 0, 0x22287C}, /* East Asian ideograph */
  {"\xB1", 0, 0x222921}, /* East Asian ideograph */
  {"\xB4", 0, 0x222923}, /* East Asian ideograph */
  {"\xBE", 0, 0x2D3D34}, /* East Asian ideograph */
  {"\xB5", 0, 0x2D5B69}, /* East Asian ideograph */
  {"\x8F", 0, 0x2E284C}, /* East Asian ideograph */
  {"\xA9", 0, 0x334F37}, /* East Asian ideograph */
  {"\xB8", 0, 0x335B70}, /* East Asian ideograph */
  {"\xBC", 0, 0x39303A}, /* East Asian ideograph */
  {"\xBB", 0, 0x453768}, /* East Asian ideograph */
  {"\x90", 0, 0x46284C}, /* East Asian ideograph */
  {"\x83", 0, 0x4B3D27}, /* East Asian ideograph */
  {"\xB0", 0, 0x4B3D2F}, /* East Asian ideograph */
  {"\x9B", 0, 0x4C2867}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page72 = {
  marc8r_31page72_flat, 0
};
/* PAGE 71 */
struct yaz_iconv_trie_flat marc8r_31page71_flat[] = {
  {"\x8F", 0, 0x213C6C}, /* East Asian ideograph */
  {"\x87", 0, 0x213C6D}, /* East Asian ideograph */
  {"\x8A", 0, 0x213C6E}, /* East Asian ideograph */
  {"\x9A", 0, 0x213C6F}, /* East Asian ideograph */
  {"\x97", 0, 0x213C70}, /* East Asian ideograph */
  {"\x96", 0, 0x213C71}, /* East Asian ideograph */
  {"\x9C", 0, 0x213C72}, /* East Asian ideograph */
  {"\x95", 0, 0x213C73}, /* East Asian ideograph */
  {"\xA0", 0, 0x213C74}, /* East Asian ideograph */
  {"\xA6", 0, 0x213C75}, /* East Asian ideograph */
  {"\xAB", 0, 0x213C76}, /* East Asian ideograph */
  {"\xA7", 0, 0x213C77}, /* East Asian ideograph */
  {"\xAD", 0, 0x213C78}, /* East Asian ideograph */
  {"\xB7", 0, 0x213C79}, /* East Asian ideograph */
  {"\xB8", 0, 0x213C7A}, /* East Asian ideograph */
  {"\xB6", 0, 0x213C7B}, /* East Asian ideograph */
  {"\xB5", 0, 0x213C7C}, /* East Asian ideograph */
  {"\xBE", 0, 0x213D21}, /* East Asian ideograph */
  {"\x80", 0, 0x222777}, /* East Asian ideograph */
  {"\x8B", 0, 0x22277E}, /* East Asian ideograph */
  {"\xA4", 0, 0x22282F}, /* East Asian ideograph */
  {"\xA5", 0, 0x222835}, /* East Asian ideograph */
  {"\xAF", 0, 0x222836}, /* East Asian ideograph */
  {"\xB9", 0, 0x222842}, /* East Asian ideograph */
  {"\xB3", 0, 0x22284B}, /* East Asian ideograph */
  {"\x93", 0, 0x273C76}, /* East Asian ideograph */
  {"\x9F", 0, 0x273D27}, /* East Asian ideograph */
  {"\x99", 0, 0x273D2B}, /* East Asian ideograph */
  {"\x9E", 0, 0x273D2D}, /* East Asian ideograph */
  {"\x90", 0, 0x273D2E}, /* East Asian ideograph */
  {"\x86", 0, 0x273F2E}, /* East Asian ideograph */
  {"\x94", 0, 0x273F4A}, /* East Asian ideograph */
  {"\x84", 0, 0x27552D}, /* East Asian ideograph */
  {"\x91", 0, 0x282868}, /* East Asian ideograph */
  {"\xBD", 0, 0x2D3B2A}, /* East Asian ideograph */
  {"\xBF", 0, 0x2D3D2B}, /* East Asian ideograph */
  {"\x85", 0, 0x2D6260}, /* East Asian ideograph */
  {"\x83", 0, 0x333D2A}, /* East Asian ideograph */
  {"\x81", 0, 0x333D2F}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page71 = {
  marc8r_31page71_flat, 0
};
/* PAGE 70 */
struct yaz_iconv_trie_flat marc8r_31page70_flat[] = {
  {"\x85", 0, 0x213C56}, /* East Asian ideograph */
  {"\x80", 0, 0x213C58}, /* East Asian ideograph */
  {"\x8C", 0, 0x213C59}, /* East Asian ideograph */
  {"\x9B", 0, 0x213C5A}, /* East Asian ideograph */
  {"\x94", 0, 0x213C5B}, /* East Asian ideograph */
  {"\x97", 0, 0x213C5C}, /* East Asian ideograph */
  {"\x95", 0, 0x213C5D}, /* East Asian ideograph */
  {"\xA3", 0, 0x213C5E}, /* East Asian ideograph */
  {"\xA2", 0, 0x213C5F}, /* East Asian ideograph */
  {"\x9F", 0, 0x213C60}, /* East Asian ideograph */
  {"\xAB", 0, 0x213C61}, /* East Asian ideograph */
  {"\xB3", 0, 0x213C63}, /* East Asian ideograph */
  {"\xB4", 0, 0x213C65}, /* East Asian ideograph */
  {"\xBB", 0, 0x213C68}, /* East Asian ideograph */
  {"\xBC", 0, 0x213C69}, /* East Asian ideograph */
  {"\xBD", 0, 0x213C6A}, /* East Asian ideograph */
  {"\xBE", 0, 0x213C6B}, /* East Asian ideograph */
  {"\x84", 0, 0x222735}, /* East Asian ideograph */
  {"\x83", 0, 0x222736}, /* East Asian ideograph */
  {"\x82", 0, 0x222739}, /* East Asian ideograph */
  {"\x8E", 0, 0x22273F}, /* East Asian ideograph */
  {"\x98", 0, 0x222747}, /* East Asian ideograph */
  {"\x88", 0, 0x222748}, /* East Asian ideograph */
  {"\x9E", 0, 0x222757}, /* East Asian ideograph */
  {"\xA1", 0, 0x222758}, /* East Asian ideograph */
  {"\xA8", 0, 0x22275D}, /* East Asian ideograph */
  {"\xAC", 0, 0x22275F}, /* East Asian ideograph */
  {"\xAA", 0, 0x222760}, /* East Asian ideograph */
  {"\xAE", 0, 0x222763}, /* East Asian ideograph */
  {"\xAD", 0, 0x222764}, /* East Asian ideograph */
  {"\xB0", 0, 0x222765}, /* East Asian ideograph */
  {"\xB5", 0, 0x22276D}, /* East Asian ideograph */
  {"\xB6", 0, 0x273032}, /* East Asian ideograph */
  {"\xB2", 0, 0x27304C}, /* East Asian ideograph */
  {"\xBF", 0, 0x273D2A}, /* East Asian ideograph */
  {"\xB8", 0, 0x2D3177}, /* East Asian ideograph */
  {"\x87", 0, 0x2D3C61}, /* East Asian ideograph */
  {"\xB9", 0, 0x3F304C}, /* East Asian ideograph */
  {"\xBA", 0, 0x456260}, /* East Asian ideograph */
  {"\xA4", 0, 0x4B3C5E}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page70 = {
  marc8r_31page70_flat, 0
};
/* PAGE 69 */
struct yaz_iconv_trie_flat marc8r_31page69_flat[] = {
  {"\x82", 0, 0x213C44}, /* East Asian ideograph */
  {"\x86", 0, 0x213C46}, /* East Asian ideograph */
  {"\x9A", 0, 0x213C49}, /* East Asian ideograph */
  {"\x96", 0, 0x213C4A}, /* East Asian ideograph */
  {"\x95", 0, 0x213C4B}, /* East Asian ideograph */
  {"\x9B", 0, 0x213C4C}, /* East Asian ideograph */
  {"\x91", 0, 0x213C4D}, /* East Asian ideograph */
  {"\x9D", 0, 0x213C4E}, /* East Asian ideograph */
  {"\xA5", 0, 0x213C4F}, /* East Asian ideograph */
  {"\xAB", 0, 0x213C51}, /* East Asian ideograph */
  {"\xB3", 0, 0x213C52}, /* East Asian ideograph */
  {"\xB6", 0, 0x213C53}, /* East Asian ideograph */
  {"\xB8", 0, 0x213C54}, /* East Asian ideograph */
  {"\xB7", 0, 0x213C55}, /* East Asian ideograph */
  {"\xBD", 0, 0x213C57}, /* East Asian ideograph */
  {"\x80", 0, 0x222662}, /* East Asian ideograph */
  {"\x94", 0, 0x222672}, /* East Asian ideograph */
  {"\x97", 0, 0x222673}, /* East Asian ideograph */
  {"\x99", 0, 0x222676}, /* East Asian ideograph */
  {"\x92", 0, 0x222677}, /* East Asian ideograph */
  {"\x9F", 0, 0x222678}, /* East Asian ideograph */
  {"\xA3", 0, 0x22267A}, /* East Asian ideograph */
  {"\xA1", 0, 0x22267B}, /* East Asian ideograph */
  {"\xA2", 0, 0x222722}, /* East Asian ideograph */
  {"\xA8", 0, 0x222724}, /* East Asian ideograph */
  {"\x83", 0, 0x273138}, /* East Asian ideograph */
  {"\x85", 0, 0x273C4F}, /* East Asian ideograph */
  {"\x88", 0, 0x273C51}, /* East Asian ideograph */
  {"\x90", 0, 0x273C52}, /* East Asian ideograph */
  {"\xA6", 0, 0x273C53}, /* East Asian ideograph */
  {"\xA7", 0, 0x273C58}, /* East Asian ideograph */
  {"\xBC", 0, 0x273C5C}, /* East Asian ideograph */
  {"\x81", 0, 0x273C5E}, /* East Asian ideograph */
  {"\x9C", 0, 0x273C60}, /* East Asian ideograph */
  {"\xAE", 0, 0x273C61}, /* East Asian ideograph */
  {"\x8C", 0, 0x274F36}, /* East Asian ideograph */
  {"\x98", 0, 0x275048}, /* East Asian ideograph */
  {"\xAD", 0, 0x27555D}, /* East Asian ideograph */
  {"\x8F", 0, 0x282736}, /* East Asian ideograph */
  {"\xBB", 0, 0x282747}, /* East Asian ideograph */
  {"\xB1", 0, 0x28275F}, /* East Asian ideograph */
  {"\x8B", 0, 0x2D5124}, /* East Asian ideograph */
  {"\xAC", 0, 0x2D5760}, /* East Asian ideograph */
  {"\xB2", 0, 0x2F3B63}, /* East Asian ideograph */
  {"\xB0", 0, 0x3F462B}, /* East Asian ideograph */
  {"\xAF", 0, 0x4B3C53}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page69 = {
  marc8r_31page69_flat, 0
};
/* PAGE 68 */
struct yaz_iconv_trie_flat marc8r_31page68_flat[] = {
  {"\x8D", 0, 0x213C30}, /* East Asian ideograph */
  {"\x92", 0, 0x213C31}, /* East Asian ideograph */
  {"\x94", 0, 0x213C32}, /* East Asian ideograph */
  {"\x96", 0, 0x213C33}, /* East Asian ideograph */
  {"\x9D", 0, 0x213C34}, /* East Asian ideograph */
  {"\x9E", 0, 0x213C35}, /* East Asian ideograph */
  {"\xA2", 0, 0x213C36}, /* East Asian ideograph */
  {"\xA5", 0, 0x213C37}, /* East Asian ideograph */
  {"\xA8", 0, 0x213C38}, /* East Asian ideograph */
  {"\xA7", 0, 0x213C39}, /* East Asian ideograph */
  {"\xA6", 0, 0x213C3A}, /* East Asian ideograph */
  {"\xAB", 0, 0x213C3B}, /* East Asian ideograph */
  {"\xAE", 0, 0x213C3C}, /* East Asian ideograph */
  {"\xB1", 0, 0x213C3D}, /* East Asian ideograph */
  {"\xB2", 0, 0x213C3E}, /* East Asian ideograph */
  {"\xB3", 0, 0x213C3F}, /* East Asian ideograph */
  {"\xB4", 0, 0x213C40}, /* East Asian ideograph */
  {"\xB7", 0, 0x213C41}, /* East Asian ideograph */
  {"\xBD", 0, 0x213C42}, /* East Asian ideograph */
  {"\xBE", 0, 0x213C43}, /* East Asian ideograph */
  {"\xA1", 0, 0x215B69}, /* East Asian ideograph */
  {"\x83", 0, 0x22263E}, /* East Asian ideograph */
  {"\x87", 0, 0x222644}, /* East Asian ideograph */
  {"\x89", 0, 0x222646}, /* East Asian ideograph */
  {"\x8B", 0, 0x222647}, /* East Asian ideograph */
  {"\x98", 0, 0x22264E}, /* East Asian ideograph */
  {"\x9B", 0, 0x222650}, /* East Asian ideograph */
  {"\x9C", 0, 0x222652}, /* East Asian ideograph */
  {"\xA4", 0, 0x222656}, /* East Asian ideograph */
  {"\x85", 0, 0x273C32}, /* East Asian ideograph */
  {"\xA9", 0, 0x276023}, /* East Asian ideograph */
  {"\xAF", 0, 0x282659}, /* East Asian ideograph */
  {"\xA3", 0, 0x2D3C36}, /* East Asian ideograph */
  {"\xB5", 0, 0x4B346B}, /* East Asian ideograph */
  {"\x93", 0, 0x4B3C32}, /* East Asian ideograph */
  {"\x8C", 0, 0x4B3C33}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page68 = {
  marc8r_31page68_flat, 0
};
/* PAGE 67 */
struct yaz_iconv_trie_flat marc8r_31page67_flat[] = {
  {"\x84", 0, 0x213C2A}, /* East Asian ideograph */
  {"\x87", 0, 0x213C2B}, /* East Asian ideograph */
  {"\x9D", 0, 0x213C2C}, /* East Asian ideograph */
  {"\xBC", 0, 0x213C2D}, /* East Asian ideograph */
  {"\xBD", 0, 0x213C2E}, /* East Asian ideograph */
  {"\xBA", 0, 0x213C2F}, /* East Asian ideograph (variant of EACC 4B3C2F) */
  {"\x82", 0, 0x22254D}, /* East Asian ideograph */
  {"\x8E", 0, 0x222551}, /* East Asian ideograph */
  {"\x81", 0, 0x22255A}, /* East Asian ideograph */
  {"\x92", 0, 0x222566}, /* East Asian ideograph */
  {"\x99", 0, 0x222568}, /* East Asian ideograph */
  {"\x97", 0, 0x222569}, /* East Asian ideograph */
  {"\xA2", 0, 0x22256A}, /* East Asian ideograph */
  {"\xA1", 0, 0x222573}, /* East Asian ideograph */
  {"\x93", 0, 0x222575}, /* East Asian ideograph */
  {"\xA0", 0, 0x222577}, /* East Asian ideograph */
  {"\x94", 0, 0x22257B}, /* East Asian ideograph */
  {"\xAC", 0, 0x22257E}, /* East Asian ideograph */
  {"\xA7", 0, 0x222626}, /* East Asian ideograph */
  {"\xB0", 0, 0x22262A}, /* East Asian ideograph */
  {"\xB4", 0, 0x22262E}, /* East Asian ideograph */
  {"\xAE", 0, 0x22262F}, /* East Asian ideograph */
  {"\xB6", 0, 0x222630}, /* East Asian ideograph */
  {"\xB8", 0, 0x222632}, /* East Asian ideograph */
  {"\xBF", 0, 0x222634}, /* East Asian ideograph */
  {"\xB7", 0, 0x222636}, /* East Asian ideograph */
  {"\x8B", 0, 0x2D3B79}, /* East Asian ideograph */
  {"\x8C", 0, 0x4B3B79}, /* East Asian ideograph */
  {"\x90", 0, 0x695657}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page67 = {
  marc8r_31page67_flat, 0
};
/* PAGE 66 */
struct yaz_iconv_trie_flat marc8r_31page66_flat[] = {
  {"\x8C", 0, 0x213C27}, /* East Asian ideograph */
  {"\x90", 0, 0x213C28}, /* East Asian ideograph */
  {"\xA9", 0, 0x213C29}, /* East Asian ideograph */
  {"\x8B", 0, 0x222474}, /* East Asian ideograph */
  {"\x97", 0, 0x222476}, /* East Asian ideograph */
  {"\x92", 0, 0x222526}, /* East Asian ideograph */
  {"\x8E", 0, 0x222528}, /* East Asian ideograph */
  {"\x99", 0, 0x22252C}, /* East Asian ideograph */
  {"\x87", 0, 0x22252D}, /* East Asian ideograph */
  {"\x82", 0, 0x222531}, /* East Asian ideograph */
  {"\xB4", 0, 0x222534}, /* East Asian ideograph */
  {"\xAF", 0, 0x222539}, /* East Asian ideograph */
  {"\xAB", 0, 0x22253A}, /* East Asian ideograph */
  {"\xB5", 0, 0x22253F}, /* East Asian ideograph */
  {"\x8A", 0, 0x222544}, /* East Asian ideograph */
  {"\xAC", 0, 0x222549}, /* East Asian ideograph */
  {"\xA2", 0, 0x22254A}, /* East Asian ideograph */
  {"\xB9", 0, 0x222550}, /* East Asian ideograph */
  {"\xBE", 0, 0x222560}, /* East Asian ideograph */
  {"\x9D", 0, 0x28255A}, /* East Asian ideograph */
  {"\x98", 0, 0x282632}, /* East Asian ideograph */
  {"\x9C", 0, 0x4B3C21}, /* East Asian ideograph */
  {"\x9B", 0, 0x4C2532}, /* East Asian ideograph */
  {"\xB3", 0, 0x4C2539}, /* East Asian ideograph */
  {"\xB6", 0, 0x69564E}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page66 = {
  marc8r_31page66_flat, 0
};
/* PAGE 65 */
struct yaz_iconv_trie_flat marc8r_31page65_flat[] = {
  {"\x81", 0, 0x213B73}, /* East Asian ideograph */
  {"\x87", 0, 0x213B7B}, /* East Asian ideograph */
  {"\x86", 0, 0x213B7C}, /* East Asian ideograph */
  {"\x9B", 0, 0x213B7D}, /* East Asian ideograph */
  {"\x96", 0, 0x213B7E}, /* East Asian ideograph */
  {"\x8E", 0, 0x213C21}, /* East Asian ideograph */
  {"\x91", 0, 0x213C22}, /* East Asian ideograph */
  {"\xA2", 0, 0x213C23}, /* East Asian ideograph */
  {"\xA9", 0, 0x213C24}, /* East Asian ideograph */
  {"\x94", 0, 0x213C25}, /* East Asian ideograph */
  {"\x99", 0, 0x213C26}, /* East Asian ideograph */
  {"\x80", 0, 0x222434}, /* East Asian ideograph */
  {"\x9E", 0, 0x222449}, /* East Asian ideograph */
  {"\x92", 0, 0x22244A}, /* East Asian ideograph */
  {"\x9A", 0, 0x222450}, /* East Asian ideograph */
  {"\x8C", 0, 0x222452}, /* East Asian ideograph */
  {"\xA0", 0, 0x222453}, /* East Asian ideograph */
  {"\xA1", 0, 0x222454}, /* East Asian ideograph */
  {"\xA7", 0, 0x222457}, /* East Asian ideograph */
  {"\x8D", 0, 0x222458}, /* East Asian ideograph */
  {"\xA6", 0, 0x22245A}, /* East Asian ideograph */
  {"\xAE", 0, 0x22245D}, /* East Asian ideograph */
  {"\xA4", 0, 0x222469}, /* East Asian ideograph */
  {"\xB6", 0, 0x222471}, /* East Asian ideograph */
  {"\xBE", 0, 0x222472}, /* East Asian ideograph */
  {"\xB4", 0, 0x222477}, /* East Asian ideograph */
  {"\xBF", 0, 0x222525}, /* East Asian ideograph */
  {"\xBD", 0, 0x222527}, /* East Asian ideograph */
  {"\xB2", 0, 0x22252F}, /* East Asian ideograph */
  {"\xAD", 0, 0x273C2A}, /* East Asian ideograph */
  {"\x83", 0, 0x282458}, /* East Asian ideograph */
  {"\x82", 0, 0x282569}, /* East Asian ideograph */
  {"\x97", 0, 0x2D3B6E}, /* East Asian ideograph */
  {"\x88", 0, 0x2D3B7B}, /* East Asian ideograph */
  {"\x90", 0, 0x2D3C22}, /* East Asian ideograph */
  {"\x98", 0, 0x2D3C26}, /* East Asian ideograph */
  {"\x9F", 0, 0x2E257B}, /* East Asian ideograph */
  {"\x8B", 0, 0x39553C}, /* East Asian ideograph */
  {"\x95", 0, 0x4B3B7E}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page65 = {
  marc8r_31page65_flat, 0
};
/* PAGE 64 */
struct yaz_iconv_trie_flat marc8r_31page64_flat[] = {
  {"\x99", 0, 0x213B72}, /* East Asian ideograph */
  {"\xBD", 0, 0x213B74}, /* East Asian ideograph */
  {"\xAD", 0, 0x213B75}, /* East Asian ideograph */
  {"\xBB", 0, 0x213B76}, /* East Asian ideograph */
  {"\xA8", 0, 0x213B77}, /* East Asian ideograph */
  {"\xB0", 0, 0x213B78}, /* East Asian ideograph */
  {"\xB6", 0, 0x213B79}, /* East Asian ideograph */
  {"\xAA", 0, 0x213B7A}, /* East Asian ideograph */
  {"\x81", 0, 0x22236D}, /* East Asian ideograph */
  {"\x95", 0, 0x222370}, /* East Asian ideograph */
  {"\x93", 0, 0x222378}, /* East Asian ideograph */
  {"\xA0", 0, 0x222426}, /* East Asian ideograph */
  {"\x92", 0, 0x222428}, /* East Asian ideograph */
  {"\x9D", 0, 0x222429}, /* East Asian ideograph */
  {"\x8B", 0, 0x22242B}, /* East Asian ideograph */
  {"\x87", 0, 0x222430}, /* East Asian ideograph */
  {"\x9C", 0, 0x222431}, /* East Asian ideograph */
  {"\xBF", 0, 0x22243B}, /* East Asian ideograph */
  {"\xAB", 0, 0x22243C}, /* East Asian ideograph */
  {"\xB4", 0, 0x222441}, /* East Asian ideograph */
  {"\xB1", 0, 0x222446}, /* East Asian ideograph */
  {"\xA1", 0, 0x273B74}, /* East Asian ideograph */
  {"\xA6", 0, 0x273C31}, /* East Asian ideograph */
  {"\xA4", 0, 0x282577}, /* East Asian ideograph */
  {"\x84", 0, 0x282626}, /* East Asian ideograph */
  {"\xA9", 0, 0x2D3B77}, /* East Asian ideograph */
  {"\xAF", 0, 0x2D3B78}, /* East Asian ideograph */
  {"\xA5", 0, 0x4B3C23}, /* East Asian ideograph */
  {"\xBA", 0, 0x4B4E39}, /* East Asian ideograph */
  {"\x85", 0, 0x695632}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page64 = {
  marc8r_31page64_flat, 0
};
/* PAGE 63 */
struct yaz_iconv_trie_flat marc8r_31page63_flat[] = {
  {"\x90", 0, 0x213B67}, /* East Asian ideograph */
  {"\x8C", 0, 0x213B68}, /* East Asian ideograph */
  {"\x91", 0, 0x213B69}, /* East Asian ideograph */
  {"\x94", 0, 0x213B6A}, /* East Asian ideograph */
  {"\xB7", 0, 0x213B6B}, /* East Asian ideograph */
  {"\xB8", 0, 0x213B6C}, /* East Asian ideograph */
  {"\xA1", 0, 0x213B6E}, /* East Asian ideograph */
  {"\xAB", 0, 0x213B6F}, /* East Asian ideograph */
  {"\xB1", 0, 0x213B71}, /* East Asian ideograph */
  {"\x8F", 0, 0x222346}, /* East Asian ideograph */
  {"\x88", 0, 0x222349}, /* East Asian ideograph */
  {"\x8D", 0, 0x22234B}, /* East Asian ideograph */
  {"\x99", 0, 0x22234D}, /* East Asian ideograph */
  {"\xA6", 0, 0x222355}, /* East Asian ideograph */
  {"\xA0", 0, 0x222357}, /* East Asian ideograph */
  {"\xA2", 0, 0x22235C}, /* East Asian ideograph */
  {"\xB5", 0, 0x222360}, /* East Asian ideograph */
  {"\xA7", 0, 0x222361}, /* East Asian ideograph */
  {"\xA8", 0, 0x222366}, /* East Asian ideograph */
  {"\xAC", 0, 0x222367}, /* East Asian ideograph */
  {"\xA3", 0, 0x22236B}, /* East Asian ideograph */
  {"\xB6", 0, 0x22236C}, /* East Asian ideograph */
  {"\xAD", 0, 0x22236F}, /* East Asian ideograph */
  {"\x9B", 0, 0x273B79}, /* East Asian ideograph */
  {"\x9A", 0, 0x273C28}, /* East Asian ideograph */
  {"\x96", 0, 0x273C2B}, /* East Asian ideograph */
  {"\xB3", 0, 0x273C2E}, /* East Asian ideograph */
  {"\xA9", 0, 0x273C33}, /* East Asian ideograph */
  {"\x81", 0, 0x274629}, /* East Asian ideograph */
  {"\x82", 0, 0x275954}, /* East Asian ideograph */
  {"\x98", 0, 0x282441}, /* East Asian ideograph */
  {"\xBF", 0, 0x282647}, /* East Asian ideograph */
  {"\xBD", 0, 0x342453}, /* East Asian ideograph */
  {"\x97", 0, 0x393B6E}, /* East Asian ideograph */
  {"\xBB", 0, 0x69562E}, /* East Asian ideograph */
  {"\xBC", 0, 0x695630}, /* East Asian ideograph */
  {"\xBE", 0, 0x695633}, /* East Asian ideograph */
  {"\x9C", 0, 0x706131}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page63 = {
  marc8r_31page63_flat, 0
};
/* PAGE 62 */
struct yaz_iconv_trie_flat marc8r_31page62_flat[] = {
  {"\x80", 0, 0x213B50}, /* East Asian ideograph */
  {"\x81", 0, 0x213B51}, /* East Asian ideograph */
  {"\x86", 0, 0x213B54}, /* East Asian ideograph */
  {"\x85", 0, 0x213B55}, /* East Asian ideograph */
  {"\x88", 0, 0x213B56}, /* East Asian ideograph */
  {"\x8E", 0, 0x213B57}, /* East Asian ideograph */
  {"\x8B", 0, 0x213B58}, /* East Asian ideograph */
  {"\x8D", 0, 0x213B59}, /* East Asian ideograph */
  {"\x95", 0, 0x213B5A}, /* East Asian ideograph */
  {"\x91", 0, 0x213B5B}, /* East Asian ideograph */
  {"\x90", 0, 0x213B5C}, /* East Asian ideograph */
  {"\x9B", 0, 0x213B5D}, /* East Asian ideograph */
  {"\xA0", 0, 0x213B5E}, /* East Asian ideograph */
  {"\x9C", 0, 0x213B5F}, /* East Asian ideograph */
  {"\xA2", 0, 0x213B60}, /* East Asian ideograph */
  {"\xA4", 0, 0x213B61}, /* East Asian ideograph (variant of EACC 4B3B61) */
  {"\xA5", 0, 0x213B62}, /* East Asian ideograph */
  {"\xAC", 0, 0x213B63}, /* East Asian ideograph */
  {"\xAF", 0, 0x213B64}, /* East Asian ideograph */
  {"\xB1", 0, 0x213B65}, /* East Asian ideograph */
  {"\xB9", 0, 0x213B66}, /* East Asian ideograph */
  {"\x98", 0, 0x217E27}, /* East Asian ideograph */
  {"\x97", 0, 0x222235}, /* East Asian ideograph */
  {"\x84", 0, 0x222265}, /* East Asian ideograph */
  {"\x89", 0, 0x222267}, /* East Asian ideograph */
  {"\x99", 0, 0x222279}, /* East Asian ideograph */
  {"\x9D", 0, 0x22227B}, /* East Asian ideograph */
  {"\x9F", 0, 0x22227C}, /* East Asian ideograph */
  {"\xA3", 0, 0x222323}, /* East Asian ideograph */
  {"\xA7", 0, 0x222329}, /* East Asian ideograph */
  {"\xA8", 0, 0x22232B}, /* East Asian ideograph */
  {"\xAD", 0, 0x222330}, /* East Asian ideograph */
  {"\xAE", 0, 0x222331}, /* East Asian ideograph */
  {"\xB4", 0, 0x222337}, /* East Asian ideograph */
  {"\xB3", 0, 0x222339}, /* East Asian ideograph */
  {"\xB7", 0, 0x22233B}, /* East Asian ideograph */
  {"\xBA", 0, 0x22233C}, /* East Asian ideograph */
  {"\xBC", 0, 0x222340}, /* East Asian ideograph */
  {"\xA1", 0, 0x273B60}, /* East Asian ideograph */
  {"\x82", 0, 0x273B61}, /* East Asian ideograph */
  {"\x9E", 0, 0x273B63}, /* East Asian ideograph */
  {"\xBF", 0, 0x273C2D}, /* East Asian ideograph */
  {"\x8F", 0, 0x27415A}, /* East Asian ideograph */
  {"\xA6", 0, 0x28232B}, /* East Asian ideograph */
  {"\x8A", 0, 0x2D3B54}, /* East Asian ideograph */
  {"\xA9", 0, 0x4B5A7E}, /* East Asian ideograph */
  {"\x93", 0, 0x4C2330}, /* East Asian ideograph */
  {"\xB6", 0, 0x4C233F}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page62 = {
  marc8r_31page62_flat, 0
};
/* PAGE 61 */
struct yaz_iconv_trie_flat marc8r_31page61_flat[] = {
  {"\x86", 0, 0x213B21}, /* East Asian ideograph */
  {"\x87", 0, 0x213B22}, /* East Asian ideograph */
  {"\x85", 0, 0x213B23}, /* East Asian ideograph */
  {"\x84", 0, 0x213B24}, /* East Asian ideograph */
  {"\x82", 0, 0x213B25}, /* East Asian ideograph */
  {"\x8C", 0, 0x213B27}, /* East Asian ideograph */
  {"\x92", 0, 0x213B28}, /* East Asian ideograph */
  {"\x90", 0, 0x213B29}, /* East Asian ideograph */
  {"\x93", 0, 0x213B2A}, /* East Asian ideograph */
  {"\xA1", 0, 0x213B2B}, /* East Asian ideograph */
  {"\xA5", 0, 0x213B2C}, /* East Asian ideograph */
  {"\xA8", 0, 0x213B2D}, /* East Asian ideograph */
  {"\xA2", 0, 0x213B2E}, /* East Asian ideograph */
  {"\xA4", 0, 0x213B2F}, /* East Asian ideograph */
  {"\x9E", 0, 0x213B30}, /* East Asian ideograph */
  {"\xA6", 0, 0x213B31}, /* East Asian ideograph */
  {"\xA7", 0, 0x213B32}, /* East Asian ideograph */
  {"\x9F", 0, 0x213B33}, /* East Asian ideograph */
  {"\xAE", 0, 0x213B34}, /* East Asian ideograph */
  {"\xAC", 0, 0x213B35}, /* East Asian ideograph */
  {"\xA9", 0, 0x213B36}, /* East Asian ideograph */
  {"\xAB", 0, 0x213B37}, /* East Asian ideograph */
  {"\xB5", 0, 0x213B38}, /* East Asian ideograph */
  {"\xB6", 0, 0x213B39}, /* East Asian ideograph */
  {"\xB8", 0, 0x213B3A}, /* East Asian ideograph */
  {"\xBA", 0, 0x213B3B}, /* East Asian ideograph */
  {"\x81", 0, 0x217E59}, /* East Asian ideograph */
  {"\x89", 0, 0x217E60}, /* East Asian ideograph */
  {"\x94", 0, 0x217E68}, /* East Asian ideograph */
  {"\x83", 0, 0x217E6A}, /* East Asian ideograph */
  {"\x96", 0, 0x217E6E}, /* East Asian ideograph */
  {"\x97", 0, 0x217E75}, /* East Asian ideograph */
  {"\xA0", 0, 0x217E79}, /* East Asian ideograph */
  {"\xAA", 0, 0x217E7E}, /* East Asian ideograph */
  {"\xB0", 0, 0x222224}, /* East Asian ideograph */
  {"\xAF", 0, 0x222225}, /* East Asian ideograph */
  {"\xBF", 0, 0x273877}, /* East Asian ideograph */
  {"\x9D", 0, 0x273B2E}, /* East Asian ideograph */
  {"\xBB", 0, 0x273B42}, /* East Asian ideograph */
  {"\xB9", 0, 0x273B43}, /* East Asian ideograph */
  {"\xBC", 0, 0x273B44}, /* East Asian ideograph */
  {"\xB3", 0, 0x393B39}, /* East Asian ideograph */
  {"\x98", 0, 0x395230}, /* East Asian ideograph */
  {"\xBE", 0, 0x4B3B43}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page61 = {
  marc8r_31page61_flat, 0
};
/* PAGE 60 */
struct yaz_iconv_trie_flat marc8r_31page60_flat[] = {
  {"\x87", 0, 0x213A65}, /* East Asian ideograph */
  {"\x88", 0, 0x213A66}, /* East Asian ideograph */
  {"\x89", 0, 0x213A67}, /* East Asian ideograph */
  {"\x85", 0, 0x213A68}, /* East Asian ideograph */
  {"\x8C", 0, 0x213A69}, /* East Asian ideograph */
  {"\x8B", 0, 0x213A6A}, /* East Asian ideograph */
  {"\x8F", 0, 0x213A6B}, /* East Asian ideograph */
  {"\x97", 0, 0x213A6C}, /* East Asian ideograph */
  {"\x9A", 0, 0x213A6D}, /* East Asian ideograph */
  {"\x9C", 0, 0x213A6E}, /* East Asian ideograph */
  {"\x98", 0, 0x213A6F}, /* East Asian ideograph */
  {"\x99", 0, 0x213A70}, /* East Asian ideograph */
  {"\x9B", 0, 0x213A71}, /* East Asian ideograph */
  {"\xA5", 0, 0x213A72}, /* East Asian ideograph */
  {"\xA3", 0, 0x213A73}, /* East Asian ideograph */
  {"\xA6", 0, 0x213A74}, /* East Asian ideograph */
  {"\xA4", 0, 0x213A75}, /* East Asian ideograph */
  {"\xA2", 0, 0x213A76}, /* East Asian ideograph */
  {"\xB0", 0, 0x213A77}, /* East Asian ideograph */
  {"\xB8", 0, 0x213A78}, /* East Asian ideograph */
  {"\xB5", 0, 0x213A7A}, /* East Asian ideograph */
  {"\xB4", 0, 0x213A7B}, /* East Asian ideograph */
  {"\xAE", 0, 0x213A7C}, /* East Asian ideograph */
  {"\xB9", 0, 0x213A7D}, /* East Asian ideograph */
  {"\xB3", 0, 0x213A7E}, /* East Asian ideograph */
  {"\xBF", 0, 0x213B26}, /* East Asian ideograph */
  {"\x80", 0, 0x217E32}, /* East Asian ideograph */
  {"\x84", 0, 0x217E34}, /* East Asian ideograph */
  {"\x82", 0, 0x217E35}, /* East Asian ideograph */
  {"\x95", 0, 0x217E40}, /* East Asian ideograph */
  {"\x93", 0, 0x217E43}, /* East Asian ideograph */
  {"\xAC", 0, 0x217E49}, /* East Asian ideograph */
  {"\xA7", 0, 0x217E52}, /* East Asian ideograph */
  {"\xB7", 0, 0x217E55}, /* East Asian ideograph */
  {"\xB6", 0, 0x27323E}, /* East Asian ideograph */
  {"\x9E", 0, 0x273B31}, /* East Asian ideograph */
  {"\x81", 0, 0x273B32}, /* East Asian ideograph */
  {"\xBD", 0, 0x273B35}, /* East Asian ideograph */
  {"\xA1", 0, 0x273B36}, /* East Asian ideograph */
  {"\xA0", 0, 0x273B38}, /* East Asian ideograph */
  {"\x9D", 0, 0x273B39}, /* East Asian ideograph */
  {"\xAA", 0, 0x273F3E}, /* East Asian ideograph */
  {"\x83", 0, 0x274A53}, /* East Asian ideograph */
  {"\xBE", 0, 0x275A29}, /* East Asian ideograph */
  {"\x8D", 0, 0x2D5323}, /* East Asian ideograph */
  {"\x9F", 0, 0x4B3B31}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page60 = {
  marc8r_31page60_flat, 0
};
/* PAGE 59 */
struct yaz_iconv_trie_flat marc8r_31page59_flat[] = {
  {"\x80", 0, 0x213A4C}, /* East Asian ideograph */
  {"\x90", 0, 0x213A4D}, /* East Asian ideograph */
  {"\x91", 0, 0x213A4E}, /* East Asian ideograph */
  {"\x93", 0, 0x213A4F}, /* East Asian ideograph */
  {"\x94", 0, 0x213A50}, /* East Asian ideograph */
  {"\x95", 0, 0x213A51}, /* East Asian ideograph */
  {"\x97", 0, 0x213A52}, /* East Asian ideograph */
  {"\x98", 0, 0x213A53}, /* East Asian ideograph */
  {"\x9D", 0, 0x213A54}, /* East Asian ideograph */
  {"\x9C", 0, 0x213A55}, /* East Asian ideograph */
  {"\x9F", 0, 0x213A57}, /* East Asian ideograph */
  {"\xA3", 0, 0x213A58}, /* East Asian ideograph */
  {"\xA4", 0, 0x213A59}, /* East Asian ideograph */
  {"\xA9", 0, 0x213A5A}, /* East Asian ideograph */
  {"\xAB", 0, 0x213A5B}, /* East Asian ideograph */
  {"\xB0", 0, 0x213A5C}, /* East Asian ideograph */
  {"\xB3", 0, 0x213A5D}, /* East Asian ideograph */
  {"\xB1", 0, 0x213A5E}, /* East Asian ideograph */
  {"\xB5", 0, 0x213A5F}, /* East Asian ideograph */
  {"\xB8", 0, 0x213A60}, /* East Asian ideograph */
  {"\xBA", 0, 0x213A61}, /* East Asian ideograph */
  {"\xBD", 0, 0x213A62}, /* East Asian ideograph */
  {"\xBF", 0, 0x213A63}, /* East Asian ideograph */
  {"\x85", 0, 0x217D6E}, /* East Asian ideograph */
  {"\x8C", 0, 0x217D74}, /* East Asian ideograph */
  {"\x8B", 0, 0x217D76}, /* East Asian ideograph */
  {"\x96", 0, 0x217D7C}, /* East Asian ideograph */
  {"\x9B", 0, 0x217E21}, /* East Asian ideograph */
  {"\xA2", 0, 0x217E23}, /* East Asian ideograph */
  {"\xA5", 0, 0x217E24}, /* East Asian ideograph */
  {"\xA7", 0, 0x217E25}, /* East Asian ideograph */
  {"\xAC", 0, 0x217E28}, /* East Asian ideograph */
  {"\xAE", 0, 0x217E2A}, /* East Asian ideograph */
  {"\xBB", 0, 0x217E30}, /* East Asian ideograph */
  {"\xBC", 0, 0x217E31}, /* East Asian ideograph */
  {"\x99", 0, 0x273A5B}, /* East Asian ideograph */
  {"\x9A", 0, 0x273A5F}, /* East Asian ideograph */
  {"\xA6", 0, 0x273A60}, /* East Asian ideograph */
  {"\xAA", 0, 0x273A63}, /* East Asian ideograph */
  {"\x83", 0, 0x2D3974}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page59 = {
  marc8r_31page59_flat, 0
};
/* PAGE 58 */
struct yaz_iconv_trie_flat marc8r_31page58_flat[] = {
  {"\x89", 0, 0x213A42}, /* East Asian ideograph */
  {"\x8B", 0, 0x213A43}, /* East Asian ideograph */
  {"\x8C", 0, 0x213A44}, /* East Asian ideograph */
  {"\xB4", 0, 0x213A46}, /* East Asian ideograph */
  {"\x9D", 0, 0x213A47}, /* East Asian ideograph */
  {"\xAA", 0, 0x213A48}, /* East Asian ideograph */
  {"\xA4", 0, 0x213A49}, /* East Asian ideograph */
  {"\xB0", 0, 0x213A4A}, /* East Asian ideograph */
  {"\xB8", 0, 0x213A4B}, /* East Asian ideograph */
  {"\x88", 0, 0x217D2B}, /* East Asian ideograph */
  {"\x8D", 0, 0x217D2E}, /* East Asian ideograph */
  {"\x83", 0, 0x217D38}, /* East Asian ideograph */
  {"\x97", 0, 0x217D3D}, /* East Asian ideograph */
  {"\x96", 0, 0x217D3E}, /* East Asian ideograph */
  {"\x99", 0, 0x217D40}, /* East Asian ideograph */
  {"\x9B", 0, 0x217D47}, /* East Asian ideograph */
  {"\xA1", 0, 0x217D48}, /* East Asian ideograph */
  {"\xAC", 0, 0x217D52}, /* East Asian ideograph */
  {"\xB2", 0, 0x217D59}, /* East Asian ideograph */
  {"\xBF", 0, 0x217D63}, /* East Asian ideograph */
  {"\xAD", 0, 0x333944}, /* East Asian ideograph */
  {"\xBE", 0, 0x333F55}, /* East Asian ideograph */
  {"\xA2", 0, 0x4B3974}, /* East Asian ideograph */
  {"\xB7", 0, 0x4B3A49}, /* East Asian ideograph */
  {"\xB6", 0, 0x69554E}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page58 = {
  marc8r_31page58_flat, 0
};
/* PAGE 57 */
struct yaz_iconv_trie_flat marc8r_31page57_flat[] = {
  {"\x8C", 0, 0x213A32}, /* East Asian ideograph */
  {"\x81", 0, 0x213A33}, /* East Asian ideograph */
  {"\x89", 0, 0x213A34}, /* East Asian ideograph */
  {"\x82", 0, 0x213A38}, /* East Asian ideograph */
  {"\xA1", 0, 0x213A3A}, /* East Asian ideograph */
  {"\x97", 0, 0x213A3B}, /* East Asian ideograph */
  {"\x96", 0, 0x213A3C}, /* East Asian ideograph */
  {"\xA3", 0, 0x213A3D}, /* East Asian ideograph */
  {"\xA9", 0, 0x213A3E}, /* East Asian ideograph */
  {"\x98", 0, 0x213A3F}, /* East Asian ideograph */
  {"\xA6", 0, 0x213A40}, /* East Asian ideograph */
  {"\xBB", 0, 0x213A41}, /* East Asian ideograph */
  {"\xB5", 0, 0x213A45}, /* East Asian ideograph */
  {"\x8F", 0, 0x217B69}, /* East Asian ideograph */
  {"\x88", 0, 0x217C39}, /* East Asian ideograph */
  {"\x84", 0, 0x217C41}, /* East Asian ideograph */
  {"\x91", 0, 0x217C49}, /* East Asian ideograph */
  {"\x93", 0, 0x217C59}, /* East Asian ideograph */
  {"\x9C", 0, 0x217C60}, /* East Asian ideograph */
  {"\xA5", 0, 0x217C6D}, /* East Asian ideograph */
  {"\xA0", 0, 0x217C6E}, /* East Asian ideograph */
  {"\xAA", 0, 0x217C72}, /* East Asian ideograph */
  {"\x9A", 0, 0x217C7B}, /* East Asian ideograph */
  {"\xAB", 0, 0x217C7C}, /* East Asian ideograph */
  {"\xBF", 0, 0x217D26}, /* East Asian ideograph */
  {"\xBD", 0, 0x217D2A}, /* East Asian ideograph */
  {"\x94", 0, 0x273A48}, /* East Asian ideograph */
  {"\xB1", 0, 0x277D40}, /* East Asian ideograph */
  {"\x92", 0, 0x277D48}, /* East Asian ideograph */
  {"\xBA", 0, 0x2D3A41}, /* East Asian ideograph */
  {"\x8B", 0, 0x2D3A47}, /* East Asian ideograph */
  {"\x90", 0, 0x453666}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page57 = {
  marc8r_31page57_flat, 0
};
/* PAGE 56 */
struct yaz_iconv_trie_flat marc8r_31page56_flat[] = {
  {"\x9A", 0, 0x213A2D}, /* East Asian ideograph */
  {"\x92", 0, 0x213A2E}, /* East Asian ideograph */
  {"\xBC", 0, 0x213A30}, /* East Asian ideograph */
  {"\x9B", 0, 0x213A31}, /* East Asian ideograph */
  {"\xBE", 0, 0x213A35}, /* East Asian ideograph */
  {"\xBD", 0, 0x213A36}, /* East Asian ideograph */
  {"\xB2", 0, 0x213A37}, /* East Asian ideograph */
  {"\xB3", 0, 0x213A39}, /* East Asian ideograph */
  {"\x8A", 0, 0x217B65}, /* East Asian ideograph */
  {"\x9F", 0, 0x217B71}, /* East Asian ideograph */
  {"\xA0", 0, 0x217B75}, /* East Asian ideograph */
  {"\xA6", 0, 0x217C21}, /* East Asian ideograph */
  {"\x8C", 0, 0x217C22}, /* East Asian ideograph */
  {"\xA7", 0, 0x217C24}, /* East Asian ideograph */
  {"\x9E", 0, 0x217C25}, /* East Asian ideograph */
  {"\xA2", 0, 0x217C26}, /* East Asian ideograph */
  {"\x9C", 0, 0x217C27}, /* East Asian ideograph */
  {"\x96", 0, 0x217C29}, /* East Asian ideograph */
  {"\x93", 0, 0x217C30}, /* East Asian ideograph */
  {"\xAC", 0, 0x217C31}, /* East Asian ideograph */
  {"\xAE", 0, 0x217C34}, /* East Asian ideograph */
  {"\x95", 0, 0x217C35}, /* East Asian ideograph */
  {"\xAF", 0, 0x217C36}, /* East Asian ideograph */
  {"\xB5", 0, 0x217C3E}, /* East Asian ideograph */
  {"\xB7", 0, 0x217C45}, /* East Asian ideograph */
  {"\x90", 0, 0x217C4A}, /* East Asian ideograph */
  {"\xB8", 0, 0x217C4F}, /* East Asian ideograph */
  {"\xBA", 0, 0x217C50}, /* East Asian ideograph */
  {"\xAA", 0, 0x217C52}, /* East Asian ideograph */
  {"\xB1", 0, 0x217C5B}, /* East Asian ideograph */
  {"\xBF", 0, 0x2D3F2A}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page56 = {
  marc8r_31page56_flat, 0
};
/* PAGE 55 */
struct yaz_iconv_trie_flat marc8r_31page55_flat[] = {
  {"\x86", 0, 0x213A21}, /* East Asian ideograph */
  {"\x89", 0, 0x213A22}, /* East Asian ideograph */
  {"\xAA", 0, 0x213A23}, /* East Asian ideograph */
  {"\x8A", 0, 0x213A25}, /* East Asian ideograph */
  {"\x80", 0, 0x213A26}, /* East Asian ideograph */
  {"\xA6", 0, 0x213A27}, /* East Asian ideograph */
  {"\x81", 0, 0x213A28}, /* East Asian ideograph */
  {"\xA2", 0, 0x213A2A}, /* East Asian ideograph */
  {"\x9A", 0, 0x213A2B}, /* East Asian ideograph */
  {"\xB7", 0, 0x213A2C}, /* East Asian ideograph */
  {"\xBF", 0, 0x213A2F}, /* East Asian ideograph */
  {"\xA0", 0, 0x217B2C}, /* East Asian ideograph */
  {"\xA7", 0, 0x217B31}, /* East Asian ideograph */
  {"\x9E", 0, 0x217B3B}, /* East Asian ideograph */
  {"\xAD", 0, 0x217B3C}, /* East Asian ideograph */
  {"\x95", 0, 0x217B3E}, /* East Asian ideograph */
  {"\x90", 0, 0x217B48}, /* East Asian ideograph */
  {"\xA5", 0, 0x217B49}, /* East Asian ideograph */
  {"\xA4", 0, 0x217B52}, /* East Asian ideograph */
  {"\xBA", 0, 0x217B6A}, /* East Asian ideograph */
  {"\xBC", 0, 0x217C28}, /* East Asian ideograph */
  {"\xB5", 0, 0x273A43}, /* East Asian ideograph */
  {"\xB4", 0, 0x273A4A}, /* East Asian ideograph */
  {"\xB6", 0, 0x273A4B}, /* East Asian ideograph */
  {"\xA3", 0, 0x2D3970}, /* East Asian ideograph */
  {"\xAC", 0, 0x334770}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page55 = {
  marc8r_31page55_flat, 0
};
/* PAGE 54 */
struct yaz_iconv_trie_flat marc8r_31page54_flat[] = {
  {"\x83", 0, 0x21396B}, /* East Asian ideograph */
  {"\x81", 0, 0x21396F}, /* East Asian ideograph */
  {"\x91", 0, 0x213973}, /* East Asian ideograph */
  {"\x98", 0, 0x213974}, /* East Asian ideograph */
  {"\xA3", 0, 0x213975}, /* East Asian ideograph */
  {"\x9C", 0, 0x213976}, /* East Asian ideograph */
  {"\x93", 0, 0x213977}, /* East Asian ideograph */
  {"\xA0", 0, 0x213979}, /* East Asian ideograph */
  {"\x9F", 0, 0x21397A}, /* East Asian ideograph */
  {"\x9B", 0, 0x21397B}, /* East Asian ideograph */
  {"\x8C", 0, 0x21397C}, /* East Asian ideograph */
  {"\xA9", 0, 0x21397D}, /* East Asian ideograph */
  {"\xA5", 0, 0x21397E}, /* East Asian ideograph */
  {"\xB6", 0, 0x213A24}, /* East Asian ideograph */
  {"\xBC", 0, 0x213A29}, /* East Asian ideograph */
  {"\x80", 0, 0x217A51}, /* East Asian ideograph */
  {"\xAA", 0, 0x217A6E}, /* East Asian ideograph */
  {"\x96", 0, 0x217A75}, /* East Asian ideograph */
  {"\x89", 0, 0x217A78}, /* East Asian ideograph */
  {"\x92", 0, 0x217A7E}, /* East Asian ideograph */
  {"\xB8", 0, 0x217B3A}, /* East Asian ideograph */
  {"\xB5", 0, 0x217B3D}, /* East Asian ideograph */
  {"\xAC", 0, 0x217B41}, /* East Asian ideograph */
  {"\x84", 0, 0x273A28}, /* East Asian ideograph */
  {"\xB4", 0, 0x273A41}, /* East Asian ideograph */
  {"\x87", 0, 0x273A44}, /* East Asian ideograph */
  {"\x85", 0, 0x277B3C}, /* East Asian ideograph */
  {"\xB2", 0, 0x277C24}, /* East Asian ideograph */
  {"\x86", 0, 0x277D2B}, /* East Asian ideograph */
  {"\x88", 0, 0x277D74}, /* East Asian ideograph */
  {"\xB1", 0, 0x2D397B}, /* East Asian ideograph */
  {"\xBF", 0, 0x2D3A26}, /* East Asian ideograph */
  {"\x9A", 0, 0x4B3666}, /* East Asian ideograph */
  {"\xAF", 0, 0x4B397B}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page54 = {
  marc8r_31page54_flat, 0
};
/* PAGE 53 */
struct yaz_iconv_trie_flat marc8r_31page53_flat[] = {
  {"\x91", 0, 0x21395B}, /* East Asian ideograph */
  {"\x86", 0, 0x21395D}, /* East Asian ideograph */
  {"\x90", 0, 0x21395E}, /* East Asian ideograph */
  {"\x97", 0, 0x21395F}, /* East Asian ideograph */
  {"\x92", 0, 0x213961}, /* East Asian ideograph */
  {"\x93", 0, 0x213962}, /* East Asian ideograph */
  {"\x8A", 0, 0x213963}, /* East Asian ideograph */
  {"\x8B", 0, 0x213965}, /* East Asian ideograph */
  {"\x94", 0, 0x213966}, /* East Asian ideograph */
  {"\xA3", 0, 0x213967}, /* East Asian ideograph */
  {"\xBF", 0, 0x213969}, /* East Asian ideograph */
  {"\x98", 0, 0x21396A}, /* East Asian ideograph */
  {"\xA8", 0, 0x21396C}, /* East Asian ideograph */
  {"\xA5", 0, 0x21396D}, /* East Asian ideograph */
  {"\xAA", 0, 0x21396E}, /* East Asian ideograph */
  {"\xBB", 0, 0x213970}, /* East Asian ideograph */
  {"\xA6", 0, 0x213971}, /* East Asian ideograph */
  {"\x9A", 0, 0x213972}, /* East Asian ideograph */
  {"\xAC", 0, 0x213978}, /* East Asian ideograph */
  {"\x85", 0, 0x217A24}, /* East Asian ideograph */
  {"\x8F", 0, 0x217A28}, /* East Asian ideograph */
  {"\x81", 0, 0x217A3E}, /* East Asian ideograph */
  {"\xB9", 0, 0x217A43}, /* East Asian ideograph */
  {"\xB8", 0, 0x217A44}, /* East Asian ideograph */
  {"\xAE", 0, 0x217A4F}, /* East Asian ideograph */
  {"\xB1", 0, 0x217A50}, /* East Asian ideograph */
  {"\x9E", 0, 0x217A52}, /* East Asian ideograph */
  {"\xBD", 0, 0x217A56}, /* East Asian ideograph */
  {"\xB6", 0, 0x217A5D}, /* East Asian ideograph */
  {"\x9D", 0, 0x217A5E}, /* East Asian ideograph */
  {"\xBA", 0, 0x217A5F}, /* East Asian ideograph */
  {"\xA4", 0, 0x217A61}, /* East Asian ideograph */
  {"\x9C", 0, 0x275624}, /* East Asian ideograph */
  {"\x99", 0, 0x2D3956}, /* East Asian ideograph */
  {"\x89", 0, 0x333963}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page53 = {
  marc8r_31page53_flat, 0
};
/* PAGE 52 */
struct yaz_iconv_trie_flat marc8r_31page52_flat[] = {
  {"\x84", 0, 0x213945}, /* East Asian ideograph */
  {"\x83", 0, 0x213946}, /* East Asian ideograph */
  {"\x82", 0, 0x21394A}, /* East Asian ideograph */
  {"\x81", 0, 0x21394B}, /* East Asian ideograph */
  {"\xA8", 0, 0x21394C}, /* East Asian ideograph */
  {"\x92", 0, 0x21394D}, /* East Asian ideograph */
  {"\xA4", 0, 0x21394F}, /* East Asian ideograph */
  {"\xA3", 0, 0x213950}, /* East Asian ideograph */
  {"\x93", 0, 0x213951}, /* East Asian ideograph */
  {"\x9E", 0, 0x213952}, /* East Asian ideograph */
  {"\x9D", 0, 0x213953}, /* East Asian ideograph */
  {"\x99", 0, 0x213954}, /* East Asian ideograph */
  {"\xA5", 0, 0x213955}, /* East Asian ideograph */
  {"\x8A", 0, 0x213956}, /* East Asian ideograph */
  {"\x96", 0, 0x213957}, /* East Asian ideograph */
  {"\xBE", 0, 0x213958}, /* East Asian ideograph */
  {"\xBB", 0, 0x213959}, /* East Asian ideograph */
  {"\xAE", 0, 0x21395A}, /* East Asian ideograph */
  {"\xB9", 0, 0x21395C}, /* East Asian ideograph */
  {"\xAF", 0, 0x213960}, /* East Asian ideograph */
  {"\xA7", 0, 0x217969}, /* East Asian ideograph */
  {"\x98", 0, 0x21796B}, /* East Asian ideograph */
  {"\x9A", 0, 0x21796F}, /* East Asian ideograph */
  {"\xA0", 0, 0x217971}, /* East Asian ideograph */
  {"\x97", 0, 0x21797C}, /* East Asian ideograph */
  {"\x90", 0, 0x217A21}, /* East Asian ideograph */
  {"\xB5", 0, 0x217A25}, /* East Asian ideograph */
  {"\xBA", 0, 0x217A2A}, /* East Asian ideograph */
  {"\xB8", 0, 0x217A2C}, /* East Asian ideograph */
  {"\xB2", 0, 0x217A35}, /* East Asian ideograph */
  {"\xB7", 0, 0x217A3A}, /* East Asian ideograph */
  {"\x86", 0, 0x273953}, /* East Asian ideograph */
  {"\x87", 0, 0x273A27}, /* East Asian ideograph */
  {"\x88", 0, 0x273A36}, /* East Asian ideograph */
  {"\xAA", 0, 0x273A3B}, /* East Asian ideograph */
  {"\xA9", 0, 0x273A45}, /* East Asian ideograph */
  {"\xAB", 0, 0x277C36}, /* East Asian ideograph */
  {"\xAC", 0, 0x2D394D}, /* East Asian ideograph */
  {"\x8D", 0, 0x2D7A44}, /* East Asian ideograph */
  {"\xB3", 0, 0x393944}, /* East Asian ideograph */
  {"\x9B", 0, 0x69562C}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page52 = {
  marc8r_31page52_flat, 0
};
/* PAGE 51 */
struct yaz_iconv_trie_flat marc8r_31page51_flat[] = {
  {"\x94", 0, 0x21392F}, /* East Asian ideograph */
  {"\x89", 0, 0x213930}, /* East Asian ideograph */
  {"\x88", 0, 0x213931}, /* East Asian ideograph */
  {"\x87", 0, 0x213932}, /* East Asian ideograph */
  {"\x84", 0, 0x213933}, /* East Asian ideograph */
  {"\x95", 0, 0x213934}, /* East Asian ideograph */
  {"\x91", 0, 0x213935}, /* East Asian ideograph */
  {"\x8E", 0, 0x213936}, /* East Asian ideograph */
  {"\x8F", 0, 0x213937}, /* East Asian ideograph */
  {"\x90", 0, 0x213938}, /* East Asian ideograph */
  {"\x97", 0, 0x213939}, /* East Asian ideograph */
  {"\x98", 0, 0x21393A}, /* East Asian ideograph */
  {"\x9A", 0, 0x21393B}, /* East Asian ideograph */
  {"\xA0", 0, 0x21393C}, /* East Asian ideograph */
  {"\xA2", 0, 0x21393D}, /* East Asian ideograph */
  {"\xA7", 0, 0x21393E}, /* East Asian ideograph */
  {"\xA9", 0, 0x21393F}, /* East Asian ideograph */
  {"\xAA", 0, 0x213940}, /* East Asian ideograph */
  {"\xAE", 0, 0x213941}, /* East Asian ideograph */
  {"\xB3", 0, 0x213942}, /* East Asian ideograph */
  {"\xB4", 0, 0x213943}, /* East Asian ideograph */
  {"\xB6", 0, 0x213944}, /* East Asian ideograph */
  {"\xB8", 0, 0x213947}, /* East Asian ideograph */
  {"\xBD", 0, 0x213948}, /* East Asian ideograph */
  {"\xB9", 0, 0x213949}, /* East Asian ideograph */
  {"\x80", 0, 0x217933}, /* East Asian ideograph */
  {"\x8D", 0, 0x217938}, /* East Asian ideograph */
  {"\x93", 0, 0x217943}, /* East Asian ideograph */
  {"\x9C", 0, 0x21794B}, /* East Asian ideograph */
  {"\xA1", 0, 0x21794F}, /* East Asian ideograph */
  {"\xAC", 0, 0x217954}, /* East Asian ideograph */
  {"\xAD", 0, 0x217955}, /* East Asian ideograph */
  {"\xBC", 0, 0x217965}, /* East Asian ideograph */
  {"\x81", 0, 0x27393F}, /* East Asian ideograph */
  {"\x8B", 0, 0x273941}, /* East Asian ideograph */
  {"\x96", 0, 0x277954}, /* East Asian ideograph */
  {"\x82", 0, 0x4B3938}, /* East Asian ideograph */
  {"\xA5", 0, 0x4B393E}, /* East Asian ideograph */
  {"\xA8", 0, 0x4B7954}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page51 = {
  marc8r_31page51_flat, 0
};
/* PAGE 50 */
struct yaz_iconv_trie_flat marc8r_31page50_flat[] = {
  {"\x8F", 0, 0x213878}, /* East Asian ideograph */
  {"\x94", 0, 0x213879}, /* East Asian ideograph */
  {"\x95", 0, 0x21387A}, /* East Asian ideograph */
  {"\x96", 0, 0x21387B}, /* East Asian ideograph */
  {"\x99", 0, 0x21387C}, /* East Asian ideograph */
  {"\x9A", 0, 0x21387D}, /* East Asian ideograph */
  {"\x9C", 0, 0x21387E}, /* East Asian ideograph */
  {"\xA0", 0, 0x213921}, /* East Asian ideograph */
  {"\xA4", 0, 0x213922}, /* East Asian ideograph */
  {"\xA5", 0, 0x213923}, /* East Asian ideograph */
  {"\xA2", 0, 0x213924}, /* East Asian ideograph */
  {"\xA7", 0, 0x213925}, /* East Asian ideograph */
  {"\xAA", 0, 0x213926}, /* East Asian ideograph */
  {"\xAB", 0, 0x213927}, /* East Asian ideograph */
  {"\xA9", 0, 0x213928}, /* East Asian ideograph */
  {"\xAD", 0, 0x213929}, /* East Asian ideograph */
  {"\xAE", 0, 0x21392A}, /* East Asian ideograph */
  {"\xB1", 0, 0x21392B}, /* East Asian ideograph */
  {"\xB7", 0, 0x21392C}, /* East Asian ideograph */
  {"\xBE", 0, 0x21392E}, /* East Asian ideograph */
  {"\x82", 0, 0x217870}, /* East Asian ideograph */
  {"\x86", 0, 0x217873}, /* East Asian ideograph */
  {"\x90", 0, 0x21787A}, /* East Asian ideograph */
  {"\xAC", 0, 0x217928}, /* East Asian ideograph */
  {"\xAF", 0, 0x21792B}, /* East Asian ideograph */
  {"\xBC", 0, 0x217930}, /* East Asian ideograph */
  {"\x91", 0, 0x22545C}, /* East Asian ideograph */
  {"\x87", 0, 0x273240}, /* East Asian ideograph */
  {"\xB9", 0, 0x27392E}, /* East Asian ideograph */
  {"\xBA", 0, 0x273940}, /* East Asian ideograph */
  {"\x8D", 0, 0x273D6F}, /* East Asian ideograph */
  {"\x84", 0, 0x275647}, /* East Asian ideograph */
  {"\xB8", 0, 0x275861}, /* East Asian ideograph */
  {"\xB4", 0, 0x276046}, /* East Asian ideograph */
  {"\x98", 0, 0x2D346A}, /* East Asian ideograph */
  {"\x80", 0, 0x2D3877}, /* East Asian ideograph */
  {"\x9F", 0, 0x2D3921}, /* East Asian ideograph */
  {"\xB2", 0, 0x334369}, /* East Asian ideograph */
  {"\x9B", 0, 0x4B387D}, /* East Asian ideograph */
  {"\x89", 0, 0x4B594B}, /* East Asian ideograph */
  {"\x8A", 0, 0x4B7874}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page50 = {
  marc8r_31page50_flat, 0
};
/* PAGE 49 */
struct yaz_iconv_trie_flat marc8r_31page49_flat[] = {
  {"\x87", 0, 0x213864}, /* East Asian ideograph (variant of EACC 4B3864) */
  {"\x85", 0, 0x213865}, /* East Asian ideograph */
  {"\x81", 0, 0x213866}, /* East Asian ideograph */
  {"\x95", 0, 0x213868}, /* East Asian ideograph */
  {"\x93", 0, 0x213869}, /* East Asian ideograph */
  {"\x91", 0, 0x21386A}, /* East Asian ideograph */
  {"\x99", 0, 0x21386B}, /* East Asian ideograph */
  {"\x98", 0, 0x21386C}, /* East Asian ideograph */
  {"\x9F", 0, 0x21386D}, /* East Asian ideograph */
  {"\x9E", 0, 0x21386E}, /* East Asian ideograph */
  {"\xA2", 0, 0x21386F}, /* East Asian ideograph */
  {"\xA4", 0, 0x213870}, /* East Asian ideograph */
  {"\xA9", 0, 0x213871}, /* East Asian ideograph */
  {"\xAB", 0, 0x213872}, /* East Asian ideograph */
  {"\xAC", 0, 0x213873}, /* East Asian ideograph */
  {"\xAF", 0, 0x213874}, /* East Asian ideograph */
  {"\xBA", 0, 0x213876}, /* East Asian ideograph */
  {"\xBD", 0, 0x213877}, /* East Asian ideograph */
  {"\x88", 0, 0x21783A}, /* East Asian ideograph */
  {"\x86", 0, 0x21784B}, /* East Asian ideograph */
  {"\x96", 0, 0x217850}, /* East Asian ideograph */
  {"\x92", 0, 0x217854}, /* East Asian ideograph */
  {"\x8E", 0, 0x217856}, /* East Asian ideograph */
  {"\xA0", 0, 0x21785A}, /* East Asian ideograph */
  {"\x9A", 0, 0x21785E}, /* East Asian ideograph */
  {"\xBC", 0, 0x21786C}, /* East Asian ideograph */
  {"\xAE", 0, 0x273874}, /* East Asian ideograph */
  {"\xB6", 0, 0x273876}, /* East Asian ideograph */
  {"\xB3", 0, 0x27463C}, /* East Asian ideograph */
  {"\xB0", 0, 0x275274}, /* East Asian ideograph */
  {"\x8A", 0, 0x2D386E}, /* East Asian ideograph */
  {"\xB7", 0, 0x2D3876}, /* East Asian ideograph */
  {"\xBB", 0, 0x2D3A2F}, /* East Asian ideograph */
  {"\xB9", 0, 0x333021}, /* East Asian ideograph */
  {"\x9C", 0, 0x347431}, /* East Asian ideograph */
  {"\xB2", 0, 0x395A2F}, /* East Asian ideograph */
  {"\xB1", 0, 0x4B3021}, /* East Asian ideograph */
  {"\x8C", 0, 0x4B3870}, /* East Asian ideograph */
  {"\x97", 0, 0x69545C}, /* East Asian ideograph */
  {"\xA5", 0, 0x69545F}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page49 = {
  marc8r_31page49_flat, 0
};
/* PAGE 48 */
struct yaz_iconv_trie_flat marc8r_31page48_flat[] = {
  {"\x83", 0, 0x213857}, /* East Asian ideograph */
  {"\x8A", 0, 0x21385A}, /* East Asian ideograph */
  {"\x85", 0, 0x21385C}, /* East Asian ideograph */
  {"\x93", 0, 0x21385D}, /* East Asian ideograph */
  {"\x9E", 0, 0x21385E}, /* East Asian ideograph */
  {"\x80", 0, 0x21385F}, /* East Asian ideograph */
  {"\xB3", 0, 0x213860}, /* East Asian ideograph */
  {"\x9C", 0, 0x213861}, /* East Asian ideograph */
  {"\xAE", 0, 0x213862}, /* East Asian ideograph */
  {"\x9F", 0, 0x213863}, /* East Asian ideograph */
  {"\xBE", 0, 0x213867}, /* East Asian ideograph */
  {"\xA8", 0, 0x216267}, /* East Asian ideograph */
  {"\x9A", 0, 0x217755}, /* East Asian ideograph */
  {"\x92", 0, 0x217758}, /* East Asian ideograph */
  {"\x8E", 0, 0x21775A}, /* East Asian ideograph */
  {"\x89", 0, 0x21775C}, /* East Asian ideograph */
  {"\x9B", 0, 0x217760}, /* East Asian ideograph */
  {"\x88", 0, 0x217763}, /* East Asian ideograph */
  {"\x90", 0, 0x217765}, /* East Asian ideograph */
  {"\x98", 0, 0x217768}, /* East Asian ideograph */
  {"\x81", 0, 0x217770}, /* East Asian ideograph */
  {"\xA9", 0, 0x21777B}, /* East Asian ideograph */
  {"\xA1", 0, 0x21777E}, /* East Asian ideograph */
  {"\xB1", 0, 0x217824}, /* East Asian ideograph */
  {"\xAD", 0, 0x21782B}, /* East Asian ideograph */
  {"\xA0", 0, 0x21782E}, /* East Asian ideograph */
  {"\xA3", 0, 0x217830}, /* East Asian ideograph */
  {"\xA6", 0, 0x217832}, /* East Asian ideograph */
  {"\xBC", 0, 0x217841}, /* East Asian ideograph */
  {"\xBF", 0, 0x217849}, /* East Asian ideograph */
  {"\xBA", 0, 0x21784C}, /* East Asian ideograph */
  {"\x99", 0, 0x274A46}, /* East Asian ideograph */
  {"\x96", 0, 0x2D3854}, /* East Asian ideograph */
  {"\xAB", 0, 0x2D4550}, /* East Asian ideograph */
  {"\xBB", 0, 0x2D4A46}, /* East Asian ideograph */
  {"\x9D", 0, 0x346622}, /* East Asian ideograph */
  {"\x97", 0, 0x4B385E}, /* East Asian ideograph */
  {"\xB9", 0, 0x695451}, /* East Asian ideograph */
  {"\xB8", 0, 0x695457}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page48 = {
  marc8r_31page48_flat, 0
};
/* PAGE 47 */
struct yaz_iconv_trie_flat marc8r_31page47_flat[] = {
  {"\x9E", 0, 0x21384C}, /* East Asian ideograph */
  {"\x97", 0, 0x21384D}, /* East Asian ideograph */
  {"\x98", 0, 0x21384E}, /* East Asian ideograph */
  {"\x91", 0, 0x21384F}, /* East Asian ideograph */
  {"\xAB", 0, 0x213850}, /* East Asian ideograph */
  {"\x8C", 0, 0x213851}, /* East Asian ideograph */
  {"\x9A", 0, 0x213852}, /* East Asian ideograph */
  {"\xAD", 0, 0x213853}, /* East Asian ideograph */
  {"\x94", 0, 0x213854}, /* East Asian ideograph */
  {"\xA2", 0, 0x213855}, /* East Asian ideograph */
  {"\x8A", 0, 0x213856}, /* East Asian ideograph */
  {"\xBE", 0, 0x213858}, /* East Asian ideograph */
  {"\xB5", 0, 0x213859}, /* East Asian ideograph */
  {"\xB9", 0, 0x21385B}, /* East Asian ideograph */
  {"\x87", 0, 0x21765F}, /* East Asian ideograph */
  {"\x84", 0, 0x21767D}, /* East Asian ideograph */
  {"\x88", 0, 0x217721}, /* East Asian ideograph */
  {"\x8E", 0, 0x217730}, /* East Asian ideograph */
  {"\x9D", 0, 0x217733}, /* East Asian ideograph */
  {"\x99", 0, 0x217735}, /* East Asian ideograph */
  {"\x8B", 0, 0x217737}, /* East Asian ideograph */
  {"\xA5", 0, 0x21773D}, /* East Asian ideograph */
  {"\xAC", 0, 0x217740}, /* East Asian ideograph */
  {"\x92", 0, 0x217742}, /* East Asian ideograph */
  {"\xA4", 0, 0x217745}, /* East Asian ideograph */
  {"\x93", 0, 0x217747}, /* East Asian ideograph */
  {"\x8F", 0, 0x217748}, /* East Asian ideograph */
  {"\x8D", 0, 0x21774D}, /* East Asian ideograph */
  {"\x96", 0, 0x21774E}, /* East Asian ideograph */
  {"\x80", 0, 0x21775F}, /* East Asian ideograph */
  {"\xBC", 0, 0x217761}, /* East Asian ideograph */
  {"\xBD", 0, 0x21776B}, /* East Asian ideograph */
  {"\xBF", 0, 0x21776F}, /* East Asian ideograph */
  {"\xB2", 0, 0x2D384A}, /* East Asian ideograph */
  {"\x9F", 0, 0x2D5550}, /* East Asian ideograph */
  {"\xA9", 0, 0x2D6251}, /* East Asian ideograph */
  {"\xA1", 0, 0x4B3850}, /* East Asian ideograph (variant of EACC 213850) */
  {"\x81", 0, 0x4B386C}, /* East Asian ideograph */
  {"\xB0", 0, 0x69544B}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page47 = {
  marc8r_31page47_flat, 0
};
/* PAGE 46 */
struct yaz_iconv_trie_flat marc8r_31page46_flat[] = {
  {"\x8A", 0, 0x21383E}, /* East Asian ideograph */
  {"\x85", 0, 0x21383F}, /* East Asian ideograph */
  {"\x82", 0, 0x213840}, /* East Asian ideograph */
  {"\x86", 0, 0x213841}, /* East Asian ideograph */
  {"\xB1", 0, 0x213844}, /* East Asian ideograph */
  {"\xAF", 0, 0x213845}, /* East Asian ideograph */
  {"\xB5", 0, 0x213846}, /* East Asian ideograph */
  {"\xAA", 0, 0x213847}, /* East Asian ideograph */
  {"\xB0", 0, 0x213848}, /* East Asian ideograph */
  {"\xA4", 0, 0x213849}, /* East Asian ideograph */
  {"\xB4", 0, 0x21384A}, /* East Asian ideograph */
  {"\xA1", 0, 0x21384B}, /* East Asian ideograph */
  {"\x89", 0, 0x21756A}, /* East Asian ideograph */
  {"\x83", 0, 0x21762B}, /* East Asian ideograph */
  {"\x80", 0, 0x217633}, /* East Asian ideograph */
  {"\x87", 0, 0x217636}, /* East Asian ideograph */
  {"\x8E", 0, 0x217639}, /* East Asian ideograph */
  {"\x8F", 0, 0x21763B}, /* East Asian ideograph */
  {"\x90", 0, 0x21763E}, /* East Asian ideograph */
  {"\x8D", 0, 0x217640}, /* East Asian ideograph */
  {"\x81", 0, 0x217648}, /* East Asian ideograph */
  {"\x92", 0, 0x217649}, /* East Asian ideograph */
  {"\x8C", 0, 0x217650}, /* East Asian ideograph */
  {"\x93", 0, 0x217651}, /* East Asian ideograph */
  {"\x8B", 0, 0x217656}, /* East Asian ideograph */
  {"\x84", 0, 0x217659}, /* East Asian ideograph */
  {"\x9B", 0, 0x217667}, /* East Asian ideograph */
  {"\x99", 0, 0x217669}, /* East Asian ideograph */
  {"\xB3", 0, 0x21766A}, /* East Asian ideograph */
  {"\x9E", 0, 0x21766C}, /* East Asian ideograph */
  {"\xBF", 0, 0x21766D}, /* East Asian ideograph */
  {"\xA7", 0, 0x217671}, /* East Asian ideograph */
  {"\xA8", 0, 0x217676}, /* East Asian ideograph */
  {"\xAE", 0, 0x217678}, /* East Asian ideograph */
  {"\x9D", 0, 0x21767A}, /* East Asian ideograph */
  {"\x98", 0, 0x217723}, /* East Asian ideograph */
  {"\xAD", 0, 0x217729}, /* East Asian ideograph */
  {"\xA0", 0, 0x21772B}, /* East Asian ideograph */
  {"\xBD", 0, 0x217749}, /* East Asian ideograph */
  {"\x91", 0, 0x27385B}, /* East Asian ideograph */
  {"\x95", 0, 0x273862}, /* East Asian ideograph */
  {"\xBA", 0, 0x2D4C2C}, /* East Asian ideograph */
  {"\xA6", 0, 0x2D5F2C}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page46 = {
  marc8r_31page46_flat, 0
};
/* PAGE 45 */
struct yaz_iconv_trie_flat marc8r_31page45_flat[] = {
  {"\x94", 0, 0x213835}, /* East Asian ideograph */
  {"\x82", 0, 0x213836}, /* East Asian ideograph */
  {"\x8E", 0, 0x213837}, /* East Asian ideograph */
  {"\x8B", 0, 0x213838}, /* East Asian ideograph */
  {"\x83", 0, 0x213839}, /* East Asian ideograph */
  {"\xB9", 0, 0x21383A}, /* East Asian ideograph */
  {"\xB7", 0, 0x21383B}, /* East Asian ideograph */
  {"\xBA", 0, 0x21383C}, /* East Asian ideograph */
  {"\x9F", 0, 0x21383D}, /* East Asian ideograph */
  {"\xA4", 0, 0x213842}, /* East Asian ideograph */
  {"\xA0", 0, 0x213843}, /* East Asian ideograph */
  {"\x87", 0, 0x217560}, /* East Asian ideograph */
  {"\x9B", 0, 0x217571}, /* East Asian ideograph */
  {"\x95", 0, 0x217573}, /* East Asian ideograph */
  {"\x92", 0, 0x217577}, /* East Asian ideograph */
  {"\x86", 0, 0x21757E}, /* East Asian ideograph */
  {"\x84", 0, 0x217622}, /* East Asian ideograph */
  {"\xA3", 0, 0x217629}, /* East Asian ideograph */
  {"\xBB", 0, 0x21762A}, /* East Asian ideograph */
  {"\xB6", 0, 0x21762C}, /* East Asian ideograph */
  {"\xA6", 0, 0x21762D}, /* East Asian ideograph */
  {"\xAD", 0, 0x217631}, /* East Asian ideograph */
  {"\xAC", 0, 0x217635}, /* East Asian ideograph */
  {"\xB4", 0, 0x21763D}, /* East Asian ideograph */
  {"\xAF", 0, 0x217643}, /* East Asian ideograph */
  {"\xBD", 0, 0x21764D}, /* East Asian ideograph */
  {"\xB8", 0, 0x21764E}, /* East Asian ideograph */
  {"\xB0", 0, 0x217652}, /* East Asian ideograph */
  {"\xB3", 0, 0x217658}, /* East Asian ideograph */
  {"\x8F", 0, 0x21765A}, /* East Asian ideograph */
  {"\x9D", 0, 0x21765B}, /* East Asian ideograph */
  {"\xB5", 0, 0x217726}, /* East Asian ideograph */
  {"\x9A", 0, 0x27767A}, /* East Asian ideograph */
  {"\x98", 0, 0x277742}, /* East Asian ideograph */
  {"\x99", 0, 0x277745}, /* East Asian ideograph */
  {"\xBC", 0, 0x2D3C21}, /* East Asian ideograph */
  {"\x9C", 0, 0x335D3B}, /* East Asian ideograph */
  {"\x80", 0, 0x4B382E}, /* East Asian ideograph */
  {"\x93", 0, 0x4B7577}, /* East Asian ideograph */
  {"\x96", 0, 0x695442}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page45 = {
  marc8r_31page45_flat, 0
};
/* PAGE 44 */
struct yaz_iconv_trie_flat marc8r_31page44_flat[] = {
  {"\x83", 0, 0x213827}, /* East Asian ideograph */
  {"\x82", 0, 0x21382E}, /* East Asian ideograph */
  {"\xA0", 0, 0x213830}, /* East Asian ideograph */
  {"\x8B", 0, 0x213831}, /* East Asian ideograph */
  {"\xA3", 0, 0x213832}, /* East Asian ideograph */
  {"\xAE", 0, 0x213833}, /* East Asian ideograph */
  {"\xA2", 0, 0x213834}, /* East Asian ideograph */
  {"\x8A", 0, 0x217475}, /* East Asian ideograph */
  {"\x89", 0, 0x21752E}, /* East Asian ideograph */
  {"\x88", 0, 0x217533}, /* East Asian ideograph */
  {"\x9F", 0, 0x217538}, /* East Asian ideograph */
  {"\x90", 0, 0x217539}, /* East Asian ideograph */
  {"\x93", 0, 0x21753A}, /* East Asian ideograph */
  {"\x9E", 0, 0x21753F}, /* East Asian ideograph */
  {"\xB5", 0, 0x217540}, /* East Asian ideograph */
  {"\x9A", 0, 0x217543}, /* East Asian ideograph */
  {"\x94", 0, 0x217545}, /* East Asian ideograph */
  {"\xA4", 0, 0x217547}, /* East Asian ideograph */
  {"\x99", 0, 0x217548}, /* East Asian ideograph */
  {"\x8C", 0, 0x217549}, /* East Asian ideograph */
  {"\x97", 0, 0x21754B}, /* East Asian ideograph */
  {"\x9D", 0, 0x21754E}, /* East Asian ideograph */
  {"\x9C", 0, 0x217552}, /* East Asian ideograph */
  {"\xA7", 0, 0x217554}, /* East Asian ideograph */
  {"\xA1", 0, 0x217557}, /* East Asian ideograph */
  {"\x95", 0, 0x21755B}, /* East Asian ideograph */
  {"\xB8", 0, 0x21755F}, /* East Asian ideograph */
  {"\xBE", 0, 0x21756C}, /* East Asian ideograph */
  {"\xA9", 0, 0x27383E}, /* East Asian ideograph */
  {"\xAB", 0, 0x27385A}, /* East Asian ideograph */
  {"\xA6", 0, 0x273867}, /* East Asian ideograph */
  {"\x92", 0, 0x27386C}, /* East Asian ideograph */
  {"\x84", 0, 0x27386D}, /* East Asian ideograph */
  {"\xAD", 0, 0x277638}, /* East Asian ideograph */
  {"\xB2", 0, 0x277748}, /* East Asian ideograph */
  {"\x85", 0, 0x27785A}, /* East Asian ideograph */
  {"\x86", 0, 0x27785E}, /* East Asian ideograph */
  {"\x9B", 0, 0x2D7552}, /* East Asian ideograph */
  {"\xBB", 0, 0x4B3871}, /* East Asian ideograph */
  {"\xB3", 0, 0x695438}, /* East Asian ideograph */
  {"\xAA", 0, 0x69543A}, /* East Asian ideograph */
  {"\xB0", 0, 0x69543B}, /* East Asian ideograph */
  {"\xB4", 0, 0x705B71}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page44 = {
  marc8r_31page44_flat, 0
};
/* PAGE 43 */
struct yaz_iconv_trie_flat marc8r_31page43_flat[] = {
  {"\x91", 0, 0x21377C}, /* East Asian ideograph */
  {"\x8A", 0, 0x21377D}, /* East Asian ideograph */
  {"\x80", 0, 0x213821}, /* East Asian ideograph */
  {"\x87", 0, 0x213822}, /* East Asian ideograph */
  {"\x8D", 0, 0x213823}, /* East Asian ideograph */
  {"\x8E", 0, 0x213825}, /* East Asian ideograph */
  {"\xAA", 0, 0x213828}, /* East Asian ideograph */
  {"\xA9", 0, 0x213829}, /* East Asian ideograph */
  {"\xB7", 0, 0x21382A}, /* East Asian ideograph */
  {"\xA1", 0, 0x21382B}, /* East Asian ideograph */
  {"\xA4", 0, 0x21382C}, /* East Asian ideograph */
  {"\xA6", 0, 0x21382D}, /* East Asian ideograph */
  {"\xBC", 0, 0x21382F}, /* East Asian ideograph */
  {"\x89", 0, 0x217463}, /* East Asian ideograph */
  {"\x85", 0, 0x217465}, /* East Asian ideograph */
  {"\x8B", 0, 0x217468}, /* East Asian ideograph */
  {"\x8C", 0, 0x217469}, /* East Asian ideograph */
  {"\xA8", 0, 0x217470}, /* East Asian ideograph */
  {"\xAD", 0, 0x217477}, /* East Asian ideograph */
  {"\xB4", 0, 0x217479}, /* East Asian ideograph */
  {"\xA7", 0, 0x21747A}, /* East Asian ideograph */
  {"\xB0", 0, 0x217526}, /* East Asian ideograph */
  {"\xB1", 0, 0x217528}, /* East Asian ideograph */
  {"\xAE", 0, 0x21752A}, /* East Asian ideograph */
  {"\xB6", 0, 0x21752D}, /* East Asian ideograph */
  {"\xBF", 0, 0x217530}, /* East Asian ideograph */
  {"\xB5", 0, 0x217531}, /* East Asian ideograph */
  {"\xBB", 0, 0x217532}, /* East Asian ideograph */
  {"\xB3", 0, 0x217535}, /* East Asian ideograph */
  {"\x9E", 0, 0x273855}, /* East Asian ideograph */
  {"\x97", 0, 0x273856}, /* East Asian ideograph */
  {"\x9F", 0, 0x273860}, /* East Asian ideograph */
  {"\xA0", 0, 0x273861}, /* East Asian ideograph */
  {"\x9B", 0, 0x273864}, /* East Asian ideograph */
  {"\x8F", 0, 0x27386E}, /* East Asian ideograph */
  {"\x9C", 0, 0x27386F}, /* East Asian ideograph */
  {"\x9D", 0, 0x273871}, /* East Asian ideograph */
  {"\x90", 0, 0x273C77}, /* East Asian ideograph */
  {"\x9A", 0, 0x2D383F}, /* East Asian ideograph */
  {"\xAB", 0, 0x2D3C70}, /* East Asian ideograph */
  {"\xAF", 0, 0x33386E}, /* East Asian ideograph */
  {"\x82", 0, 0x395E71}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page43 = {
  marc8r_31page43_flat, 0
};
/* PAGE 42 */
struct yaz_iconv_trie_flat marc8r_31page42_flat[] = {
  {"\x83", 0, 0x21376D}, /* East Asian ideograph */
  {"\x88", 0, 0x21376E}, /* East Asian ideograph */
  {"\x8B", 0, 0x21376F}, /* East Asian ideograph */
  {"\x8D", 0, 0x213770}, /* East Asian ideograph */
  {"\x92", 0, 0x213771}, /* East Asian ideograph */
  {"\x93", 0, 0x213772}, /* East Asian ideograph */
  {"\x98", 0, 0x213773}, /* East Asian ideograph */
  {"\x96", 0, 0x213774}, /* East Asian ideograph */
  {"\x9F", 0, 0x213775}, /* East Asian ideograph */
  {"\xAD", 0, 0x213777}, /* East Asian ideograph */
  {"\xAF", 0, 0x213778}, /* East Asian ideograph */
  {"\xB0", 0, 0x213779}, /* East Asian ideograph */
  {"\xA8", 0, 0x21377A}, /* East Asian ideograph */
  {"\xB3", 0, 0x21377B}, /* East Asian ideograph */
  {"\xBE", 0, 0x213824}, /* East Asian ideograph */
  {"\x85", 0, 0x217427}, /* East Asian ideograph */
  {"\x84", 0, 0x217428}, /* East Asian ideograph */
  {"\x82", 0, 0x217429}, /* East Asian ideograph */
  {"\x8A", 0, 0x21742C}, /* East Asian ideograph */
  {"\x89", 0, 0x21742D}, /* East Asian ideograph */
  {"\x87", 0, 0x21742E}, /* East Asian ideograph */
  {"\x8C", 0, 0x217430}, /* East Asian ideograph */
  {"\x95", 0, 0x217431}, /* East Asian ideograph */
  {"\x94", 0, 0x217432}, /* East Asian ideograph */
  {"\x9A", 0, 0x217435}, /* East Asian ideograph */
  {"\x9B", 0, 0x217436}, /* East Asian ideograph */
  {"\x9C", 0, 0x217437}, /* East Asian ideograph */
  {"\x9D", 0, 0x217439}, /* East Asian ideograph */
  {"\x9E", 0, 0x21743A}, /* East Asian ideograph */
  {"\xA4", 0, 0x217441}, /* East Asian ideograph */
  {"\xAE", 0, 0x217442}, /* East Asian ideograph */
  {"\xA9", 0, 0x217443}, /* East Asian ideograph */
  {"\xB8", 0, 0x217448}, /* East Asian ideograph */
  {"\xAA", 0, 0x21744C}, /* East Asian ideograph */
  {"\xBF", 0, 0x21746A}, /* East Asian ideograph */
  {"\x86", 0, 0x273772}, /* East Asian ideograph */
  {"\xBA", 0, 0x27384A}, /* East Asian ideograph */
  {"\xB9", 0, 0x27386B}, /* East Asian ideograph */
  {"\xA3", 0, 0x27526F}, /* East Asian ideograph */
  {"\x80", 0, 0x2D376F}, /* East Asian ideograph */
  {"\xBB", 0, 0x2D3830}, /* East Asian ideograph */
  {"\xAC", 0, 0x343A5B}, /* East Asian ideograph */
  {"\xA7", 0, 0x4B3869}, /* East Asian ideograph */
  {"\xA6", 0, 0x695429}, /* East Asian ideograph */
  {"\xB7", 0, 0x69542A}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page42 = {
  marc8r_31page42_flat, 0
};
/* PAGE 41 */
struct yaz_iconv_trie_flat marc8r_31page41_flat[] = {
  {"\x80", 0, 0x21375C}, /* East Asian ideograph */
  {"\x81", 0, 0x21375D}, /* East Asian ideograph */
  {"\x82", 0, 0x21375E}, /* East Asian ideograph */
  {"\x8A", 0, 0x213760}, /* East Asian ideograph */
  {"\x89", 0, 0x213761}, /* East Asian ideograph */
  {"\x88", 0, 0x213762}, /* East Asian ideograph */
  {"\x91", 0, 0x213764}, /* East Asian ideograph */
  {"\x9B", 0, 0x213765}, /* East Asian ideograph */
  {"\x9A", 0, 0x213766}, /* East Asian ideograph */
  {"\xA0", 0, 0x213767}, /* East Asian ideograph */
  {"\x9E", 0, 0x213768}, /* East Asian ideograph */
  {"\xA4", 0, 0x213769}, /* East Asian ideograph */
  {"\xB1", 0, 0x21376B}, /* East Asian ideograph */
  {"\xBA", 0, 0x21376C}, /* East Asian ideograph */
  {"\x83", 0, 0x21735B}, /* East Asian ideograph */
  {"\x85", 0, 0x217360}, /* East Asian ideograph */
  {"\x8F", 0, 0x217362}, /* East Asian ideograph */
  {"\x8D", 0, 0x217367}, /* East Asian ideograph */
  {"\x94", 0, 0x21736A}, /* East Asian ideograph */
  {"\x97", 0, 0x21736B}, /* East Asian ideograph */
  {"\x9D", 0, 0x21736D}, /* East Asian ideograph */
  {"\xA1", 0, 0x21736F}, /* East Asian ideograph */
  {"\x9F", 0, 0x217370}, /* East Asian ideograph */
  {"\xAB", 0, 0x217375}, /* East Asian ideograph */
  {"\xAE", 0, 0x217376}, /* East Asian ideograph */
  {"\xA7", 0, 0x217377}, /* East Asian ideograph */
  {"\xBB", 0, 0x217379}, /* East Asian ideograph */
  {"\xB7", 0, 0x21737E}, /* East Asian ideograph */
  {"\xB9", 0, 0x217421}, /* East Asian ideograph */
  {"\xBF", 0, 0x217424}, /* East Asian ideograph */
  {"\xAF", 0, 0x27376F}, /* East Asian ideograph */
  {"\xB4", 0, 0x273770}, /* East Asian ideograph */
  {"\xAD", 0, 0x273771}, /* East Asian ideograph */
  {"\xA2", 0, 0x273773}, /* East Asian ideograph */
  {"\xBE", 0, 0x273774}, /* East Asian ideograph */
  {"\xB0", 0, 0x274D57}, /* East Asian ideograph */
  {"\xB5", 0, 0x27742E}, /* East Asian ideograph */
  {"\xAC", 0, 0x2D3768}, /* East Asian ideograph */
  {"\x93", 0, 0x2D7345}, /* East Asian ideograph */
  {"\xB2", 0, 0x393770}, /* East Asian ideograph */
  {"\x8C", 0, 0x39563C}, /* East Asian ideograph */
  {"\x98", 0, 0x4B3768}, /* East Asian ideograph */
  {"\xBD", 0, 0x4B376F}, /* East Asian ideograph */
  {"\xA3", 0, 0x4B3773}, /* East Asian ideograph */
  {"\xB3", 0, 0x4B3774}, /* East Asian ideograph */
  {"\x8E", 0, 0x695375}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page41 = {
  marc8r_31page41_flat, 0
};
/* PAGE 40 */
struct yaz_iconv_trie_flat marc8r_31page40_flat[] = {
  {"\x80", 0, 0x21374E}, /* East Asian ideograph */
  {"\x8E", 0, 0x21374F}, /* East Asian ideograph */
  {"\x85", 0, 0x213750}, /* East Asian ideograph */
  {"\x87", 0, 0x213751}, /* East Asian ideograph */
  {"\x90", 0, 0x213752}, /* East Asian ideograph */
  {"\x8F", 0, 0x213753}, /* East Asian ideograph */
  {"\x95", 0, 0x213754}, /* East Asian ideograph */
  {"\xAE", 0, 0x213755}, /* East Asian ideograph (variant of EACC 453755) */
  {"\xA8", 0, 0x213756}, /* East Asian ideograph */
  {"\xB0", 0, 0x213757}, /* East Asian ideograph */
  {"\xA5", 0, 0x213758}, /* East Asian ideograph */
  {"\xB7", 0, 0x213759}, /* East Asian ideograph */
  {"\xB4", 0, 0x21375A}, /* East Asian ideograph */
  {"\xB6", 0, 0x21375B}, /* East Asian ideograph */
  {"\xBC", 0, 0x21375F}, /* East Asian ideograph */
  {"\x93", 0, 0x217325}, /* East Asian ideograph */
  {"\x8C", 0, 0x217328}, /* East Asian ideograph */
  {"\xBA", 0, 0x217332}, /* East Asian ideograph */
  {"\x86", 0, 0x217334}, /* East Asian ideograph */
  {"\x84", 0, 0x217335}, /* East Asian ideograph */
  {"\x91", 0, 0x217336}, /* East Asian ideograph */
  {"\x8A", 0, 0x217337}, /* East Asian ideograph */
  {"\x9E", 0, 0x21733E}, /* East Asian ideograph */
  {"\x9C", 0, 0x217341}, /* East Asian ideograph */
  {"\x9A", 0, 0x217342}, /* East Asian ideograph */
  {"\x99", 0, 0x217345}, /* East Asian ideograph */
  {"\xAD", 0, 0x21734B}, /* East Asian ideograph */
  {"\xA6", 0, 0x21734C}, /* East Asian ideograph */
  {"\xAC", 0, 0x21734E}, /* East Asian ideograph */
  {"\xB2", 0, 0x217353}, /* East Asian ideograph */
  {"\xB3", 0, 0x21735A}, /* East Asian ideograph */
  {"\xA3", 0, 0x27375E}, /* East Asian ideograph */
  {"\xA0", 0, 0x4B4937}, /* East Asian ideograph */
  {"\xAF", 0, 0x4D3359}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page40 = {
  marc8r_31page40_flat, 0
};
/* PAGE 39 */
struct yaz_iconv_trie_flat marc8r_31page39_flat[] = {
  {"\x8E", 0, 0x213734}, /* East Asian ideograph */
  {"\x97", 0, 0x213739}, /* East Asian ideograph */
  {"\x93", 0, 0x21373B}, /* East Asian ideograph */
  {"\x99", 0, 0x21373F}, /* East Asian ideograph */
  {"\xAB", 0, 0x213741}, /* East Asian ideograph */
  {"\xA4", 0, 0x213742}, /* East Asian ideograph */
  {"\xA9", 0, 0x213743}, /* East Asian ideograph */
  {"\xB8", 0, 0x213744}, /* East Asian ideograph */
  {"\xB4", 0, 0x213745}, /* East Asian ideograph */
  {"\xB9", 0, 0x213746}, /* East Asian ideograph */
  {"\xA5", 0, 0x213747}, /* East Asian ideograph */
  {"\xAA", 0, 0x213748}, /* East Asian ideograph */
  {"\xA8", 0, 0x213749}, /* East Asian ideograph */
  {"\xB1", 0, 0x21374A}, /* East Asian ideograph */
  {"\xAF", 0, 0x21374B}, /* East Asian ideograph */
  {"\xA2", 0, 0x21374C}, /* East Asian ideograph (variant of EACC 4B374C) */
  {"\xAC", 0, 0x21374D}, /* East Asian ideograph */
  {"\x82", 0, 0x217247}, /* East Asian ideograph */
  {"\x8C", 0, 0x217248}, /* East Asian ideograph */
  {"\x8B", 0, 0x21724B}, /* East Asian ideograph */
  {"\x80", 0, 0x217252}, /* East Asian ideograph */
  {"\x89", 0, 0x217257}, /* East Asian ideograph */
  {"\x81", 0, 0x217258}, /* East Asian ideograph */
  {"\x98", 0, 0x21725C}, /* East Asian ideograph */
  {"\x94", 0, 0x21725E}, /* East Asian ideograph */
  {"\x8D", 0, 0x217269}, /* East Asian ideograph */
  {"\x8F", 0, 0x21726C}, /* East Asian ideograph */
  {"\xB0", 0, 0x21726E}, /* East Asian ideograph */
  {"\x9F", 0, 0x21726F}, /* East Asian ideograph */
  {"\xBC", 0, 0x217270}, /* East Asian ideograph */
  {"\xA0", 0, 0x217272}, /* East Asian ideograph */
  {"\xB6", 0, 0x217278}, /* East Asian ideograph */
  {"\xA6", 0, 0x21727A}, /* East Asian ideograph */
  {"\xB3", 0, 0x21727B}, /* East Asian ideograph */
  {"\xAD", 0, 0x21727C}, /* East Asian ideograph */
  {"\xB2", 0, 0x21727E}, /* East Asian ideograph */
  {"\x9C", 0, 0x273754}, /* East Asian ideograph */
  {"\x90", 0, 0x2D3749}, /* East Asian ideograph */
  {"\xBA", 0, 0x694838}, /* East Asian ideograph */
  {"\xBB", 0, 0x706067}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page39 = {
  marc8r_31page39_flat, 0
};
/* PAGE 38 */
struct yaz_iconv_trie_flat marc8r_31page38_flat[] = {
  {"\x80", 0, 0x213724}, /* East Asian ideograph */
  {"\x9B", 0, 0x213725}, /* East Asian ideograph */
  {"\x96", 0, 0x213727}, /* East Asian ideograph */
  {"\x88", 0, 0x213729}, /* East Asian ideograph */
  {"\x9F", 0, 0x21372A}, /* East Asian ideograph */
  {"\x86", 0, 0x21372C}, /* East Asian ideograph (variant of EACC 4B372C) */
  {"\x89", 0, 0x21372D}, /* East Asian ideograph */
  {"\x94", 0, 0x21372E}, /* East Asian ideograph */
  {"\x8E", 0, 0x21372F}, /* East Asian ideograph */
  {"\x97", 0, 0x213730}, /* East Asian ideograph */
  {"\x8D", 0, 0x213731}, /* East Asian ideograph */
  {"\xAE", 0, 0x213732}, /* East Asian ideograph */
  {"\xAF", 0, 0x213733}, /* East Asian ideograph */
  {"\xB6", 0, 0x213735}, /* East Asian ideograph */
  {"\xB2", 0, 0x213736}, /* East Asian ideograph */
  {"\xBB", 0, 0x213737}, /* East Asian ideograph */
  {"\xB9", 0, 0x213738}, /* East Asian ideograph */
  {"\xBF", 0, 0x21373C}, /* East Asian ideograph */
  {"\xB4", 0, 0x21373D}, /* East Asian ideograph */
  {"\xB7", 0, 0x21373E}, /* East Asian ideograph */
  {"\xB0", 0, 0x213740}, /* East Asian ideograph */
  {"\x85", 0, 0x21712A}, /* East Asian ideograph */
  {"\xA7", 0, 0x21717E}, /* East Asian ideograph */
  {"\x92", 0, 0x217225}, /* East Asian ideograph */
  {"\x8F", 0, 0x217228}, /* East Asian ideograph */
  {"\x9E", 0, 0x21722E}, /* East Asian ideograph */
  {"\x8C", 0, 0x217231}, /* East Asian ideograph */
  {"\x9C", 0, 0x217234}, /* East Asian ideograph */
  {"\x90", 0, 0x217235}, /* East Asian ideograph */
  {"\x81", 0, 0x217236}, /* East Asian ideograph */
  {"\x93", 0, 0x217238}, /* East Asian ideograph */
  {"\x82", 0, 0x21723C}, /* East Asian ideograph */
  {"\x9D", 0, 0x217242}, /* East Asian ideograph */
  {"\xB5", 0, 0x217255}, /* East Asian ideograph */
  {"\xA0", 0, 0x21725D}, /* East Asian ideograph */
  {"\xAA", 0, 0x217260}, /* East Asian ideograph */
  {"\xBD", 0, 0x217261}, /* East Asian ideograph */
  {"\xAC", 0, 0x217264}, /* East Asian ideograph */
  {"\xB8", 0, 0x217267}, /* East Asian ideograph */
  {"\xAB", 0, 0x21726B}, /* East Asian ideograph */
  {"\xA4", 0, 0x27375B}, /* East Asian ideograph */
  {"\xB1", 0, 0x273764}, /* East Asian ideograph */
  {"\xA9", 0, 0x2D5941}, /* East Asian ideograph */
  {"\x91", 0, 0x393573}, /* East Asian ideograph */
  {"\xA3", 0, 0x706054}, /* East Asian ideograph */
  {"\xAD", 0, 0x706058}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page38 = {
  marc8r_31page38_flat, 0
};
/* PAGE 37 */
struct yaz_iconv_trie_flat marc8r_31page37_flat[] = {
  {"\xA8", 0, 0x213673}, /* East Asian ideograph */
  {"\x9F", 0, 0x213674}, /* East Asian ideograph */
  {"\x91", 0, 0x213675}, /* East Asian ideograph */
  {"\x9C", 0, 0x213676}, /* East Asian ideograph */
  {"\xA6", 0, 0x213677}, /* East Asian ideograph */
  {"\x87", 0, 0x213678}, /* East Asian ideograph */
  {"\x93", 0, 0x213679}, /* East Asian ideograph */
  {"\x8E", 0, 0x21367A}, /* East Asian ideograph */
  {"\xA3", 0, 0x21367B}, /* East Asian ideograph */
  {"\xAF", 0, 0x21367C}, /* East Asian ideograph */
  {"\xA4", 0, 0x21367D}, /* East Asian ideograph */
  {"\x85", 0, 0x21367E}, /* East Asian ideograph */
  {"\x9A", 0, 0x213721}, /* East Asian ideograph */
  {"\x86", 0, 0x213722}, /* East Asian ideograph */
  {"\xA1", 0, 0x213723}, /* East Asian ideograph */
  {"\xBE", 0, 0x213726}, /* East Asian ideograph */
  {"\xB7", 0, 0x213728}, /* East Asian ideograph */
  {"\xBD", 0, 0x21372B}, /* East Asian ideograph */
  {"\xA7", 0, 0x216C50}, /* East Asian ideograph */
  {"\xA2", 0, 0x217143}, /* East Asian ideograph (variant of EACC 2D7143) */
  {"\xB4", 0, 0x217156}, /* East Asian ideograph */
  {"\x8C", 0, 0x217158}, /* East Asian ideograph */
  {"\x90", 0, 0x217159}, /* East Asian ideograph */
  {"\x9B", 0, 0x21715A}, /* East Asian ideograph */
  {"\x8D", 0, 0x21715B}, /* East Asian ideograph */
  {"\x9E", 0, 0x21715C}, /* East Asian ideograph */
  {"\x99", 0, 0x21715D}, /* East Asian ideograph */
  {"\x83", 0, 0x21715E}, /* East Asian ideograph */
  {"\x89", 0, 0x21715F}, /* East Asian ideograph */
  {"\x8A", 0, 0x217161}, /* East Asian ideograph */
  {"\x9D", 0, 0x217162}, /* East Asian ideograph */
  {"\x94", 0, 0x217164}, /* East Asian ideograph */
  {"\x84", 0, 0x217165}, /* East Asian ideograph */
  {"\xA9", 0, 0x217169}, /* East Asian ideograph */
  {"\x8F", 0, 0x21716F}, /* East Asian ideograph */
  {"\x92", 0, 0x217170}, /* East Asian ideograph */
  {"\xA5", 0, 0x217175}, /* East Asian ideograph */
  {"\x96", 0, 0x217177}, /* East Asian ideograph */
  {"\x81", 0, 0x217178}, /* East Asian ideograph */
  {"\xB2", 0, 0x217179}, /* East Asian ideograph */
  {"\xBB", 0, 0x217224}, /* East Asian ideograph */
  {"\xB8", 0, 0x217227}, /* East Asian ideograph */
  {"\xB9", 0, 0x21722B}, /* East Asian ideograph */
  {"\xB6", 0, 0x217239}, /* East Asian ideograph */
  {"\xBF", 0, 0x217244}, /* East Asian ideograph */
  {"\xB3", 0, 0x27374B}, /* East Asian ideograph */
  {"\xAB", 0, 0x27375D}, /* East Asian ideograph */
  {"\xAC", 0, 0x4B356A}, /* East Asian ideograph */
  {"\xAA", 0, 0x70603A}, /* East Asian ideograph */
  {"\xB5", 0, 0x70604C}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page37 = {
  marc8r_31page37_flat, 0
};
/* PAGE 36 */
struct yaz_iconv_trie_flat marc8r_31page36_flat[] = {
  {"\xA7", 0, 0x21365A}, /* East Asian ideograph */
  {"\x80", 0, 0x21365B}, /* East Asian ideograph */
  {"\x94", 0, 0x21365F}, /* East Asian ideograph */
  {"\x87", 0, 0x213660}, /* East Asian ideograph */
  {"\x9C", 0, 0x213661}, /* East Asian ideograph */
  {"\x8B", 0, 0x213662}, /* East Asian ideograph */
  {"\xAA", 0, 0x213663}, /* East Asian ideograph */
  {"\xB3", 0, 0x213664}, /* East Asian ideograph */
  {"\x8A", 0, 0x213665}, /* East Asian ideograph */
  {"\x83", 0, 0x213666}, /* East Asian ideograph */
  {"\xB1", 0, 0x213667}, /* East Asian ideograph */
  {"\xAE", 0, 0x213668}, /* East Asian ideograph */
  {"\x82", 0, 0x213669}, /* East Asian ideograph */
  {"\x9F", 0, 0x21366A}, /* East Asian ideograph */
  {"\x9D", 0, 0x21366B}, /* East Asian ideograph */
  {"\x98", 0, 0x21366C}, /* East Asian ideograph */
  {"\x9A", 0, 0x21366D}, /* East Asian ideograph */
  {"\xAC", 0, 0x21366F}, /* East Asian ideograph */
  {"\x89", 0, 0x213670}, /* East Asian ideograph */
  {"\xB2", 0, 0x213671}, /* East Asian ideograph */
  {"\xBB", 0, 0x213672}, /* East Asian ideograph */
  {"\x84", 0, 0x21523F}, /* East Asian ideograph */
  {"\x91", 0, 0x217123}, /* East Asian ideograph */
  {"\xA8", 0, 0x217126}, /* East Asian ideograph */
  {"\xAD", 0, 0x217127}, /* East Asian ideograph */
  {"\x93", 0, 0x21712D}, /* East Asian ideograph */
  {"\x86", 0, 0x21712F}, /* East Asian ideograph */
  {"\x88", 0, 0x217134}, /* East Asian ideograph */
  {"\xB4", 0, 0x217136}, /* East Asian ideograph */
  {"\x81", 0, 0x217144}, /* East Asian ideograph */
  {"\x8E", 0, 0x217145}, /* East Asian ideograph */
  {"\xB5", 0, 0x217147}, /* East Asian ideograph */
  {"\x8F", 0, 0x217149}, /* East Asian ideograph */
  {"\xA4", 0, 0x217150}, /* East Asian ideograph */
  {"\x92", 0, 0x217151}, /* East Asian ideograph */
  {"\x99", 0, 0x217152}, /* East Asian ideograph */
  {"\xBD", 0, 0x273731}, /* East Asian ideograph */
  {"\xB7", 0, 0x273745}, /* East Asian ideograph */
  {"\xBE", 0, 0x27735A}, /* East Asian ideograph */
  {"\xAB", 0, 0x2D3547}, /* East Asian ideograph */
  {"\x9E", 0, 0x39365E}, /* East Asian ideograph */
  {"\xB0", 0, 0x396074}, /* East Asian ideograph */
  {"\xB6", 0, 0x4B4A2E}, /* East Asian ideograph */
  {"\xB9", 0, 0x70602D}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page36 = {
  marc8r_31page36_flat, 0
};
/* PAGE 35 */
struct yaz_iconv_trie_flat marc8r_31page35_flat[] = {
  {"\x96", 0, 0x213644}, /* East Asian ideograph */
  {"\x86", 0, 0x213646}, /* East Asian ideograph */
  {"\x8F", 0, 0x213648}, /* East Asian ideograph */
  {"\x9E", 0, 0x213649}, /* East Asian ideograph */
  {"\xA6", 0, 0x21364A}, /* East Asian ideograph */
  {"\xAA", 0, 0x21364B}, /* East Asian ideograph */
  {"\x8A", 0, 0x21364C}, /* East Asian ideograph */
  {"\x84", 0, 0x21364D}, /* East Asian ideograph */
  {"\x9C", 0, 0x21364E}, /* East Asian ideograph */
  {"\x83", 0, 0x213650}, /* East Asian ideograph */
  {"\xA1", 0, 0x213652}, /* East Asian ideograph */
  {"\xA3", 0, 0x213654}, /* East Asian ideograph */
  {"\x95", 0, 0x213655}, /* East Asian ideograph */
  {"\xA4", 0, 0x213658}, /* East Asian ideograph */
  {"\xBB", 0, 0x21365C}, /* East Asian ideograph */
  {"\xBC", 0, 0x21365D}, /* East Asian ideograph */
  {"\xBE", 0, 0x21366E}, /* East Asian ideograph */
  {"\x93", 0, 0x21424F}, /* East Asian ideograph */
  {"\xB5", 0, 0x21704B}, /* East Asian ideograph */
  {"\xB3", 0, 0x21704D}, /* East Asian ideograph */
  {"\x8C", 0, 0x21704E}, /* East Asian ideograph */
  {"\xB6", 0, 0x21704F}, /* East Asian ideograph */
  {"\x8D", 0, 0x217050}, /* East Asian ideograph */
  {"\x9A", 0, 0x217051}, /* East Asian ideograph */
  {"\x90", 0, 0x217055}, /* East Asian ideograph */
  {"\x88", 0, 0x217058}, /* East Asian ideograph */
  {"\x91", 0, 0x21705A}, /* East Asian ideograph */
  {"\xA2", 0, 0x217060}, /* East Asian ideograph */
  {"\x89", 0, 0x217064}, /* East Asian ideograph */
  {"\x80", 0, 0x21706A}, /* East Asian ideograph */
  {"\x85", 0, 0x217070}, /* East Asian ideograph */
  {"\x81", 0, 0x21707B}, /* East Asian ideograph */
  {"\xA5", 0, 0x21707D}, /* East Asian ideograph */
  {"\xB7", 0, 0x217125}, /* East Asian ideograph */
  {"\x99", 0, 0x21714B}, /* East Asian ideograph */
  {"\xAC", 0, 0x273678}, /* East Asian ideograph */
  {"\xA7", 0, 0x273727}, /* East Asian ideograph */
  {"\xB8", 0, 0x273733}, /* East Asian ideograph */
  {"\xAD", 0, 0x27375C}, /* East Asian ideograph */
  {"\xAE", 0, 0x277345}, /* East Asian ideograph */
  {"\x97", 0, 0x2D3644}, /* East Asian ideograph */
  {"\x9F", 0, 0x2D424F}, /* East Asian ideograph */
  {"\x94", 0, 0x39424F}, /* East Asian ideograph */
  {"\x9D", 0, 0x69533B}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page35 = {
  marc8r_31page35_flat, 0
};
/* PAGE 34 */
struct yaz_iconv_trie_flat marc8r_31page34_flat[] = {
  {"\x81", 0, 0x213634}, /* East Asian ideograph */
  {"\x90", 0, 0x213636}, /* East Asian ideograph */
  {"\x94", 0, 0x213638}, /* East Asian ideograph */
  {"\x86", 0, 0x213641}, /* East Asian ideograph */
  {"\x89", 0, 0x213642}, /* East Asian ideograph */
  {"\xB3", 0, 0x213645}, /* East Asian ideograph */
  {"\xB7", 0, 0x213647}, /* East Asian ideograph (Version J extension) */
  {"\xB1", 0, 0x21364F}, /* East Asian ideograph */
  {"\xAC", 0, 0x213651}, /* East Asian ideograph */
  {"\xBE", 0, 0x213653}, /* East Asian ideograph */
  {"\xAF", 0, 0x213656}, /* East Asian ideograph */
  {"\xAE", 0, 0x213657}, /* East Asian ideograph */
  {"\xB8", 0, 0x213659}, /* East Asian ideograph */
  {"\xA7", 0, 0x21365E}, /* East Asian ideograph */
  {"\x9A", 0, 0x216F7B}, /* East Asian ideograph */
  {"\x87", 0, 0x216F7D}, /* East Asian ideograph */
  {"\x97", 0, 0x217023}, /* East Asian ideograph */
  {"\x8A", 0, 0x21702B}, /* East Asian ideograph */
  {"\x98", 0, 0x21702E}, /* East Asian ideograph */
  {"\x84", 0, 0x217030}, /* East Asian ideograph */
  {"\x88", 0, 0x217034}, /* East Asian ideograph */
  {"\x8E", 0, 0x21703E}, /* East Asian ideograph */
  {"\xA3", 0, 0x217044}, /* East Asian ideograph */
  {"\x8F", 0, 0x217046}, /* East Asian ideograph */
  {"\x91", 0, 0x217047}, /* East Asian ideograph */
  {"\xBC", 0, 0x217053}, /* East Asian ideograph */
  {"\xB9", 0, 0x217057}, /* East Asian ideograph */
  {"\xAD", 0, 0x217059}, /* East Asian ideograph */
  {"\xAA", 0, 0x21705D}, /* East Asian ideograph */
  {"\xB6", 0, 0x217061}, /* East Asian ideograph */
  {"\xB0", 0, 0x217068}, /* East Asian ideograph */
  {"\xB5", 0, 0x21706B}, /* East Asian ideograph */
  {"\xBF", 0, 0x217079}, /* East Asian ideograph */
  {"\xA4", 0, 0x27366D}, /* East Asian ideograph */
  {"\xA0", 0, 0x273732}, /* East Asian ideograph */
  {"\xA2", 0, 0x277169}, /* East Asian ideograph */
  {"\x9B", 0, 0x277234}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page34 = {
  marc8r_31page34_flat, 0
};
/* PAGE 33 */
struct yaz_iconv_trie_flat marc8r_31page33_flat[] = {
  {"\x80", 0, 0x213624}, /* East Asian ideograph */
  {"\x87", 0, 0x213628}, /* East Asian ideograph */
  {"\x89", 0, 0x213629}, /* East Asian ideograph */
  {"\x84", 0, 0x21362A}, /* East Asian ideograph */
  {"\x82", 0, 0x21362B}, /* East Asian ideograph */
  {"\x81", 0, 0x21362D}, /* East Asian ideograph */
  {"\x8E", 0, 0x21362F}, /* East Asian ideograph */
  {"\x88", 0, 0x213633}, /* East Asian ideograph */
  {"\xBC", 0, 0x213635}, /* East Asian ideograph */
  {"\xAA", 0, 0x213637}, /* East Asian ideograph */
  {"\xBA", 0, 0x213639}, /* East Asian ideograph */
  {"\xA5", 0, 0x21363A}, /* East Asian ideograph */
  {"\xAE", 0, 0x21363B}, /* East Asian ideograph */
  {"\xB2", 0, 0x21363C}, /* East Asian ideograph */
  {"\xA8", 0, 0x21363D}, /* East Asian ideograph */
  {"\xA1", 0, 0x21363E}, /* East Asian ideograph */
  {"\xA9", 0, 0x21363F}, /* East Asian ideograph */
  {"\xAD", 0, 0x213640}, /* East Asian ideograph */
  {"\xA6", 0, 0x213643}, /* East Asian ideograph */
  {"\x8F", 0, 0x216F5C}, /* East Asian ideograph */
  {"\x9E", 0, 0x216F6B}, /* East Asian ideograph */
  {"\x96", 0, 0x216F6C}, /* East Asian ideograph */
  {"\x86", 0, 0x216F74}, /* East Asian ideograph */
  {"\xA2", 0, 0x216F7C}, /* East Asian ideograph */
  {"\xBD", 0, 0x217024}, /* East Asian ideograph */
  {"\xA7", 0, 0x217025}, /* East Asian ideograph */
  {"\xB3", 0, 0x217027}, /* East Asian ideograph */
  {"\xA4", 0, 0x21702A}, /* East Asian ideograph */
  {"\xBF", 0, 0x21702D}, /* East Asian ideograph */
  {"\xAF", 0, 0x217032}, /* East Asian ideograph */
  {"\xB6", 0, 0x217038}, /* East Asian ideograph */
  {"\xB7", 0, 0x217039}, /* East Asian ideograph */
  {"\x91", 0, 0x273649}, /* East Asian ideograph */
  {"\x9F", 0, 0x273671}, /* East Asian ideograph */
  {"\x9D", 0, 0x273747}, /* East Asian ideograph */
  {"\x8D", 0, 0x276036}, /* East Asian ideograph */
  {"\x94", 0, 0x277239}, /* East Asian ideograph */
  {"\x93", 0, 0x277255}, /* East Asian ideograph */
  {"\x92", 0, 0x277272}, /* East Asian ideograph */
  {"\x95", 0, 0x27727A}, /* East Asian ideograph */
  {"\x99", 0, 0x27727E}, /* East Asian ideograph */
  {"\x9C", 0, 0x277328}, /* East Asian ideograph */
  {"\x97", 0, 0x335941}, /* East Asian ideograph */
  {"\x8C", 0, 0x4B357B}, /* East Asian ideograph */
  {"\x98", 0, 0x695326}, /* East Asian ideograph */
  {"\x90", 0, 0x705F51}, /* East Asian ideograph */
  {"\x9A", 0, 0x705F61}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page33 = {
  marc8r_31page33_flat, 0
};
/* PAGE 32 */
struct yaz_iconv_trie_flat marc8r_31page32_flat[] = {
  {"\x95", 0, 0x21356B}, /* East Asian ideograph */
  {"\x96", 0, 0x21356D}, /* East Asian ideograph */
  {"\x92", 0, 0x213571}, /* East Asian ideograph */
  {"\x84", 0, 0x213572}, /* East Asian ideograph */
  {"\x86", 0, 0x213575}, /* East Asian ideograph */
  {"\x8B", 0, 0x213576}, /* East Asian ideograph */
  {"\x8C", 0, 0x213577}, /* East Asian ideograph */
  {"\x90", 0, 0x213578}, /* East Asian ideograph */
  {"\x9A", 0, 0x21357C}, /* East Asian ideograph */
  {"\x8E", 0, 0x21357D}, /* East Asian ideograph */
  {"\xA9", 0, 0x21357E}, /* East Asian ideograph */
  {"\xAA", 0, 0x213621}, /* East Asian ideograph */
  {"\xA8", 0, 0x213622}, /* East Asian ideograph */
  {"\xAC", 0, 0x213623}, /* East Asian ideograph */
  {"\xB3", 0, 0x213625}, /* East Asian ideograph */
  {"\xA6", 0, 0x213626}, /* East Asian ideograph */
  {"\xAB", 0, 0x213627}, /* East Asian ideograph */
  {"\xB1", 0, 0x213630}, /* East Asian ideograph */
  {"\xBB", 0, 0x213631}, /* East Asian ideograph */
  {"\xAF", 0, 0x213632}, /* East Asian ideograph */
  {"\x9C", 0, 0x216F2F}, /* East Asian ideograph */
  {"\x88", 0, 0x216F35}, /* East Asian ideograph */
  {"\x82", 0, 0x216F39}, /* East Asian ideograph */
  {"\x91", 0, 0x216F3B}, /* East Asian ideograph */
  {"\x94", 0, 0x216F42}, /* East Asian ideograph */
  {"\x8D", 0, 0x216F49}, /* East Asian ideograph */
  {"\xA4", 0, 0x216F55}, /* East Asian ideograph */
  {"\xA1", 0, 0x216F58}, /* East Asian ideograph */
  {"\xAD", 0, 0x216F5A}, /* East Asian ideograph */
  {"\xBA", 0, 0x216F5B}, /* East Asian ideograph */
  {"\xBE", 0, 0x216F5E}, /* East Asian ideograph */
  {"\xA5", 0, 0x216F60}, /* East Asian ideograph */
  {"\xA7", 0, 0x216F63}, /* East Asian ideograph */
  {"\xB5", 0, 0x216F64}, /* East Asian ideograph */
  {"\xA2", 0, 0x216F66}, /* East Asian ideograph */
  {"\xBC", 0, 0x216F69}, /* East Asian ideograph */
  {"\xB7", 0, 0x216F6A}, /* East Asian ideograph */
  {"\xAE", 0, 0x216F6D}, /* East Asian ideograph */
  {"\xBF", 0, 0x216F71}, /* East Asian ideograph */
  {"\x80", 0, 0x27373D}, /* East Asian ideograph */
  {"\x9B", 0, 0x27374E}, /* East Asian ideograph */
  {"\x99", 0, 0x273756}, /* East Asian ideograph */
  {"\xB8", 0, 0x276250}, /* East Asian ideograph */
  {"\xBD", 0, 0x2D3758}, /* East Asian ideograph */
  {"\x8F", 0, 0x2D584D}, /* East Asian ideograph */
  {"\xB2", 0, 0x334F71}, /* East Asian ideograph */
  {"\x9D", 0, 0x705F50}, /* East Asian ideograph */
  {"\xB4", 0, 0x705F54}, /* East Asian ideograph */
  {"\xA3", 0, 0x705F5B}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page32 = {
  marc8r_31page32_flat, 0
};
/* PAGE 31 */
struct yaz_iconv_trie_flat marc8r_31page31_flat[] = {
  {"\x8E", 0, 0x213551}, /* East Asian ideograph */
  {"\x80", 0, 0x213554}, /* East Asian ideograph */
  {"\x86", 0, 0x213556}, /* East Asian ideograph */
  {"\x83", 0, 0x213558}, /* East Asian ideograph */
  {"\x8A", 0, 0x21355F}, /* East Asian ideograph */
  {"\x88", 0, 0x213560}, /* East Asian ideograph */
  {"\x82", 0, 0x213564}, /* East Asian ideograph */
  {"\xB3", 0, 0x213568}, /* East Asian ideograph */
  {"\xA2", 0, 0x213569}, /* East Asian ideograph */
  {"\xB5", 0, 0x21356A}, /* East Asian ideograph */
  {"\xB8", 0, 0x21356C}, /* East Asian ideograph */
  {"\xB7", 0, 0x21356E}, /* East Asian ideograph */
  {"\xBB", 0, 0x21356F}, /* East Asian ideograph */
  {"\xBC", 0, 0x213573}, /* East Asian ideograph */
  {"\xA8", 0, 0x213574}, /* East Asian ideograph */
  {"\xBD", 0, 0x213579}, /* East Asian ideograph */
  {"\xB6", 0, 0x21357A}, /* East Asian ideograph */
  {"\xB1", 0, 0x21357B}, /* East Asian ideograph */
  {"\x8C", 0, 0x216E6C}, /* East Asian ideograph */
  {"\x85", 0, 0x216E6D}, /* East Asian ideograph */
  {"\x94", 0, 0x216E79}, /* East Asian ideograph */
  {"\x8F", 0, 0x216F21}, /* East Asian ideograph */
  {"\x9F", 0, 0x216F2E}, /* East Asian ideograph */
  {"\xBF", 0, 0x216F37}, /* East Asian ideograph */
  {"\xAD", 0, 0x216F3A}, /* East Asian ideograph */
  {"\xAB", 0, 0x216F43}, /* East Asian ideograph */
  {"\xA3", 0, 0x216F4A}, /* East Asian ideograph */
  {"\xB4", 0, 0x216F4B}, /* East Asian ideograph */
  {"\xA6", 0, 0x216F52}, /* East Asian ideograph */
  {"\xA4", 0, 0x216F53}, /* East Asian ideograph */
  {"\xB2", 0, 0x216F67}, /* East Asian ideograph */
  {"\xB0", 0, 0x216F68}, /* East Asian ideograph */
  {"\x98", 0, 0x27363E}, /* East Asian ideograph */
  {"\x9C", 0, 0x273721}, /* East Asian ideograph */
  {"\x9B", 0, 0x273722}, /* East Asian ideograph */
  {"\x95", 0, 0x27372E}, /* East Asian ideograph */
  {"\x93", 0, 0x273762}, /* East Asian ideograph */
  {"\x99", 0, 0x276F69}, /* East Asian ideograph */
  {"\x97", 0, 0x277030}, /* East Asian ideograph */
  {"\x92", 0, 0x277267}, /* East Asian ideograph */
  {"\x96", 0, 0x27734C}, /* East Asian ideograph */
  {"\xAA", 0, 0x2D3571}, /* East Asian ideograph */
  {"\x89", 0, 0x33355C}, /* East Asian ideograph */
  {"\x8B", 0, 0x4D386F}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page31 = {
  marc8r_31page31_flat, 0
};
/* PAGE 30 */
struct yaz_iconv_trie_dir marc8r_31page30_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x275055} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x213547} /* East Asian ideograph */,
  {0, 0, 0x213546} /* East Asian ideograph */,
  {0, 0, 0x33365A} /* East Asian ideograph */,
  {0, 0, 0x21354A} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x275E5D} /* East Asian ideograph */,
  {0, 0, 0x213540} /* East Asian ideograph */,
  {0, 0, 0x213544} /* East Asian ideograph */,
  {0, 0, 0x21353F} /* East Asian ideograph */,
  {0, 0, 0x213543} /* East Asian ideograph */,
  {0, 0, 0x213545} /* East Asian ideograph */,
  {0, 0, 0x273D65} /* East Asian ideograph */,
  {0, 0, 0x213542} /* East Asian ideograph */,
  {0, 0, 0x213541} /* East Asian ideograph */,
  {0, 0, 0x273755} /* East Asian ideograph */,
  {0, 0, 0x213548} /* East Asian ideograph */,
  {0, 0, 0x273751} /* East Asian ideograph */,
  {0, 0, 0x216E61} /* East Asian ideograph */,
  {0, 0, 0x333564} /* East Asian ideograph */,
  {0, 0, 0x705F39} /* East Asian ideograph */,
  {0, 0, 0x27367A} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x216E6F} /* East Asian ideograph */,
  {0, 0, 0x213550} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x21354E} /* East Asian ideograph */,
  {0, 0, 0x21354F} /* East Asian ideograph */,
  {0, 0, 0x213566} /* East Asian ideograph */,
  {0, 0, 0x21355A} /* East Asian ideograph */,
  {0, 0, 0x216E76} /* East Asian ideograph */,
  {0, 0, 0x216F26} /* East Asian ideograph */,
  {0, 0, 0x216F27} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x213559} /* East Asian ideograph */,
  {0, 0, 0x213553} /* East Asian ideograph */,
  {0, 0, 0x273744} /* East Asian ideograph */,
  {0, 0, 0x213567} /* East Asian ideograph */,
  {0, 0, 0x216F24} /* East Asian ideograph */,
  {0, 0, 0x213565} /* East Asian ideograph */,
  {0, 0, 0x27527B} /* East Asian ideograph */,
  {0, 0, 0x21354D} /* East Asian ideograph */,
  {0, 0, 0x21355E} /* East Asian ideograph */,
  {0, 0, 0x27424F} /* East Asian ideograph */,
  {0, 0, 0x216E78} /* East Asian ideograph */,
  {0, 0, 0x213555} /* East Asian ideograph */,
  {0, 0, 0x216E70} /* East Asian ideograph */,
  {0, 0, 0x21355C} /* East Asian ideograph */,
  {0, 0, 0x2D355C} /* East Asian ideograph */,
  {0, 0, 0x21355D} /* East Asian ideograph */,
  {0, 0, 0x21355B} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x213562} /* East Asian ideograph */,
  {0, 0, 0x213563} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x213561} /* East Asian ideograph */,
  {0, 0, 0x213557} /* East Asian ideograph */,
  {0, 0, 0x216E7D} /* East Asian ideograph */,
  {0, 0, 0x213552} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page30 = {
  0, marc8r_31page30_dir
};
/* PAGE 29 */
struct yaz_iconv_trie_flat marc8r_31page29_flat[] = {
  {"\x84", 0, 0x213475}, /* East Asian ideograph */
  {"\x9A", 0, 0x213476}, /* East Asian ideograph */
  {"\x9D", 0, 0x213477}, /* East Asian ideograph */
  {"\x9F", 0, 0x213478}, /* East Asian ideograph */
  {"\xA5", 0, 0x213479}, /* East Asian ideograph */
  {"\xAD", 0, 0x21347A}, /* East Asian ideograph */
  {"\xB2", 0, 0x21347B}, /* East Asian ideograph */
  {"\xBB", 0, 0x21347C}, /* East Asian ideograph */
  {"\x80", 0, 0x216D5D}, /* East Asian ideograph */
  {"\x8E", 0, 0x216D64}, /* East Asian ideograph */
  {"\x93", 0, 0x216D66}, /* East Asian ideograph */
  {"\x94", 0, 0x216D67}, /* East Asian ideograph */
  {"\x99", 0, 0x216D6D}, /* East Asian ideograph */
  {"\xA4", 0, 0x216D7A}, /* East Asian ideograph */
  {"\xAB", 0, 0x216D7B}, /* East Asian ideograph */
  {"\xB5", 0, 0x216E2C}, /* East Asian ideograph */
  {"\xB9", 0, 0x216E2E}, /* East Asian ideograph */
  {"\xAF", 0, 0x222D56}, /* East Asian ideograph */
  {"\x8C", 0, 0x27347A}, /* East Asian ideograph */
  {"\x89", 0, 0x27347B}, /* East Asian ideograph */
  {"\x8B", 0, 0x273869}, /* East Asian ideograph */
  {"\x95", 0, 0x273C7E}, /* East Asian ideograph */
  {"\x82", 0, 0x273D2C}, /* East Asian ideograph */
  {"\x85", 0, 0x273D2F}, /* East Asian ideograph */
  {"\x86", 0, 0x274349}, /* East Asian ideograph (duplicate simplified) */
  {"\xB6", 0, 0x274F25}, /* East Asian ideograph */
  {"\xBF", 0, 0x275164}, /* East Asian ideograph (variant of EACC 455164) */
  {"\x98", 0, 0x275D3D}, /* East Asian ideograph */
  {"\x8D", 0, 0x276D6D}, /* East Asian ideograph */
  {"\xA3", 0, 0x276E2A}, /* East Asian ideograph */
  {"\xA2", 0, 0x2D3C7D}, /* East Asian ideograph */
  {"\xA0", 0, 0x2D3C7E}, /* East Asian ideograph */
  {"\xAE", 0, 0x2D3D29}, /* East Asian ideograph */
  {"\x96", 0, 0x2D3D2D}, /* East Asian ideograph */
  {"\x9B", 0, 0x2D3D2F}, /* East Asian ideograph */
  {"\xA8", 0, 0x333D28}, /* East Asian ideograph */
  {"\xA9", 0, 0x3A284C}, /* East Asian ideograph (variant of EACC 4C284C) */
  {"\xB3", 0, 0x4B375A}, /* East Asian ideograph */
  {"\xA6", 0, 0x4B3D24}, /* East Asian ideograph */
  {"\xB0", 0, 0x4B3D2C}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page29 = {
  marc8r_31page29_flat, 0
};
/* PAGE 28 */
struct yaz_iconv_trie_dir marc8r_31page28_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x213455} /* East Asian ideograph */,
  {0, 0, 0x213457} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x213458} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x213459} /* East Asian ideograph */,
  {0, 0, 0x27345F} /* East Asian ideograph */,
  {0, 0, 0x21345B} /* East Asian ideograph */,
  {0, 0, 0x21345A} /* East Asian ideograph */,
  {0, 0, 0x21345D} /* East Asian ideograph (variant of EACC 2D345D) */,
  {0, 0, 0x21345C} /* East Asian ideograph */,
  {0, 0, 0x39302D} /* East Asian ideograph */,
  {0, 0, 0x216D41} /* East Asian ideograph */,
  {0, 0, 0x216D42} /* East Asian ideograph */,
  {0, 0, 0x27553C} /* East Asian ideograph */,
  {0, 0, 0x273460} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x213462} /* East Asian ideograph */,
  {0, 0, 0x21345F} /* East Asian ideograph */,
  {0, 0, 0x213461} /* East Asian ideograph */,
  {0, 0, 0x213460} /* East Asian ideograph */,
  {0, 0, 0x273668} /* East Asian ideograph */,
  {0, 0, 0x275A2F} /* East Asian ideograph */,
  {0, 0, 0x213463} /* East Asian ideograph */,
  {0, 0, 0x4B3668} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x213464} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x275573} /* East Asian ideograph */,
  {0, 0, 0x216D4B} /* East Asian ideograph */,
  {0, 0, 0x213466} /* East Asian ideograph */,
  {0, 0, 0x216E58} /* East Asian ideograph */,
  {0, 0, 0x27313C} /* East Asian ideograph */,
  {0, 0, 0x213467} /* East Asian ideograph */,
  {0, 0, 0x274D3F} /* East Asian ideograph */,
  {0, 0, 0x216D4C} /* East Asian ideograph */,
  {0, 0, 0x295D3C} /* East Asian ideograph */,
  {0, 0, 0x216D4E} /* East Asian ideograph */,
  {0, 0, 0x213469} /* East Asian ideograph */,
  {0, 0, 0x2D5424} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x275C6B} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x275749} /* East Asian ideograph */,
  {0, 0, 0x216D53} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x21346B} /* East Asian ideograph */,
  {0, 0, 0x21346A} /* East Asian ideograph */,
  {0, 0, 0x21346C} /* East Asian ideograph */,
  {0, 0, 0x21346D} /* East Asian ideograph */,
  {0, 0, 0x216D57} /* East Asian ideograph */,
  {0, 0, 0x2D346E} /* East Asian ideograph */,
  {0, 0, 0x2D3473} /* East Asian ideograph */,
  {0, 0, 0x21346F} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x27407B} /* East Asian ideograph */,
  {0, 0, 0x213471} /* East Asian ideograph */,
  {0, 0, 0x3F3E47} /* East Asian ideograph */,
  {0, 0, 0x216D58} /* East Asian ideograph */,
  {0, 0, 0x213473} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x21346E} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x213474} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page28 = {
  0, marc8r_31page28_dir
};
/* PAGE 27 */
struct yaz_iconv_trie_flat marc8r_31page27_flat[] = {
  {"\xB5", 0, 0x21344B}, /* East Asian ideograph */
  {"\x83", 0, 0x21347D}, /* East Asian ideograph */
  {"\x88", 0, 0x21347E}, /* East Asian ideograph */
  {"\x89", 0, 0x213521}, /* East Asian ideograph */
  {"\x8B", 0, 0x213522}, /* East Asian ideograph */
  {"\x8A", 0, 0x213523}, /* East Asian ideograph */
  {"\x8D", 0, 0x213524}, /* East Asian ideograph */
  {"\x96", 0, 0x213525}, /* East Asian ideograph */
  {"\x94", 0, 0x213526}, /* East Asian ideograph */
  {"\x97", 0, 0x213527}, /* East Asian ideograph */
  {"\x9B", 0, 0x213528}, /* East Asian ideograph */
  {"\x9F", 0, 0x213529}, /* East Asian ideograph */
  {"\xA2", 0, 0x21352B}, /* East Asian ideograph */
  {"\xA3", 0, 0x21352C}, /* East Asian ideograph */
  {"\xB8", 0, 0x21352D}, /* East Asian ideograph */
  {"\xA4", 0, 0x21352E}, /* East Asian ideograph */
  {"\xAE", 0, 0x21352F}, /* East Asian ideograph */
  {"\xAF", 0, 0x213530}, /* East Asian ideograph */
  {"\xA9", 0, 0x213531}, /* East Asian ideograph */
  {"\xB3", 0, 0x213532}, /* East Asian ideograph */
  {"\xBC", 0, 0x213533}, /* East Asian ideograph */
  {"\xA8", 0, 0x213534}, /* East Asian ideograph */
  {"\xA6", 0, 0x213535}, /* East Asian ideograph */
  {"\xAC", 0, 0x213536}, /* East Asian ideograph */
  {"\xAB", 0, 0x213537}, /* East Asian ideograph */
  {"\xB0", 0, 0x213538}, /* East Asian ideograph (duplicate simplified) */
  {"\xA5", 0, 0x213539}, /* East Asian ideograph */
  {"\xB1", 0, 0x21353A}, /* East Asian ideograph */
  {"\xAD", 0, 0x21353B}, /* East Asian ideograph */
  {"\xAA", 0, 0x21353C}, /* East Asian ideograph */
  {"\xB2", 0, 0x21353D}, /* East Asian ideograph */
  {"\x90", 0, 0x216E3E}, /* East Asian ideograph */
  {"\x9A", 0, 0x216E48}, /* East Asian ideograph */
  {"\xBB", 0, 0x216E57}, /* East Asian ideograph */
  {"\x82", 0, 0x27347D}, /* East Asian ideograph */
  {"\xB9", 0, 0x27372C}, /* East Asian ideograph */
  {"\xBD", 0, 0x273740}, /* East Asian ideograph */
  {"\x91", 0, 0x274C7B}, /* East Asian ideograph */
  {"\xB6", 0, 0x27554F}, /* East Asian ideograph */
  {"\xB7", 0, 0x27564A}, /* East Asian ideograph */
  {"\x98", 0, 0x27594B}, /* East Asian ideograph */
  {"\x8C", 0, 0x275F4E}, /* East Asian ideograph */
  {"\x99", 0, 0x2D4249}, /* East Asian ideograph */
  {"\xA0", 0, 0x2D4C3C}, /* East Asian ideograph */
  {"\xA1", 0, 0x2D4D65}, /* East Asian ideograph */
  {"\x81", 0, 0x33347D}, /* East Asian ideograph */
  {"\x9C", 0, 0x333529}, /* East Asian ideograph */
  {"\x8E", 0, 0x33423D}, /* East Asian ideograph */
  {"\xBA", 0, 0x69525D}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page27 = {
  marc8r_31page27_flat, 0
};
/* PAGE 26 */
struct yaz_iconv_trie_flat marc8r_31page26_flat[] = {
  {"\x85", 0, 0x213441}, /* East Asian ideograph */
  {"\x86", 0, 0x213442}, /* East Asian ideograph */
  {"\x88", 0, 0x213443}, /* East Asian ideograph */
  {"\x8D", 0, 0x213444}, /* East Asian ideograph */
  {"\x90", 0, 0x213445}, /* East Asian ideograph */
  {"\x8F", 0, 0x213446}, /* East Asian ideograph */
  {"\x95", 0, 0x213447}, /* East Asian ideograph */
  {"\x96", 0, 0x213448}, /* East Asian ideograph */
  {"\x97", 0, 0x213449}, /* East Asian ideograph */
  {"\x99", 0, 0x21344A}, /* East Asian ideograph */
  {"\x9D", 0, 0x21344C}, /* East Asian ideograph */
  {"\xA1", 0, 0x21344D}, /* East Asian ideograph */
  {"\xA0", 0, 0x21344E}, /* East Asian ideograph */
  {"\xA3", 0, 0x21344F}, /* East Asian ideograph */
  {"\xAA", 0, 0x213450}, /* East Asian ideograph */
  {"\xAF", 0, 0x213451}, /* East Asian ideograph */
  {"\xB1", 0, 0x213452}, /* East Asian ideograph */
  {"\xB9", 0, 0x213453}, /* East Asian ideograph */
  {"\xBE", 0, 0x213454}, /* East Asian ideograph */
  {"\xBF", 0, 0x213456}, /* East Asian ideograph */
  {"\x87", 0, 0x216C69}, /* East Asian ideograph */
  {"\x83", 0, 0x216C6A}, /* East Asian ideograph */
  {"\x8A", 0, 0x216C6E}, /* East Asian ideograph */
  {"\x8B", 0, 0x216C6F}, /* East Asian ideograph */
  {"\x91", 0, 0x216C77}, /* East Asian ideograph */
  {"\x9A", 0, 0x216D23}, /* East Asian ideograph */
  {"\x9C", 0, 0x216D24}, /* East Asian ideograph */
  {"\x9F", 0, 0x216D25}, /* East Asian ideograph */
  {"\xAD", 0, 0x216D2E}, /* East Asian ideograph */
  {"\xB0", 0, 0x216D33}, /* East Asian ideograph */
  {"\xB5", 0, 0x216D36}, /* East Asian ideograph */
  {"\xB8", 0, 0x216D3A}, /* East Asian ideograph */
  {"\xBD", 0, 0x216D3E}, /* East Asian ideograph */
  {"\xAE", 0, 0x273452}, /* East Asian ideograph */
  {"\xBA", 0, 0x273455}, /* East Asian ideograph */
  {"\xBB", 0, 0x275D31}, /* East Asian ideograph */
  {"\xA6", 0, 0x276D2E}, /* East Asian ideograph */
  {"\xB3", 0, 0x4B393F}, /* East Asian ideograph */
  {"\x82", 0, 0x694677}, /* East Asian ideograph */
  {"\x81", 0, 0x694C68}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page26 = {
  marc8r_31page26_flat, 0
};
/* PAGE 25 */
struct yaz_iconv_trie_flat marc8r_31page25_flat[] = {
  {"\x87", 0, 0x21342D}, /* East Asian ideograph */
  {"\x83", 0, 0x21342E}, /* East Asian ideograph */
  {"\x81", 0, 0x21342F}, /* East Asian ideograph */
  {"\x89", 0, 0x213430}, /* East Asian ideograph */
  {"\x98", 0, 0x213431}, /* East Asian ideograph */
  {"\x92", 0, 0x213432}, /* East Asian ideograph */
  {"\x99", 0, 0x213433}, /* East Asian ideograph */
  {"\x95", 0, 0x213434}, /* East Asian ideograph */
  {"\x9E", 0, 0x213435}, /* East Asian ideograph */
  {"\x9B", 0, 0x213436}, /* East Asian ideograph */
  {"\x9D", 0, 0x213437}, /* East Asian ideograph */
  {"\xA2", 0, 0x213438}, /* East Asian ideograph */
  {"\xA4", 0, 0x213439}, /* East Asian ideograph */
  {"\x9F", 0, 0x21343A}, /* East Asian ideograph */
  {"\xB5", 0, 0x21343C}, /* East Asian ideograph */
  {"\xB8", 0, 0x21343D}, /* East Asian ideograph */
  {"\xBB", 0, 0x21343E}, /* East Asian ideograph */
  {"\xBF", 0, 0x213440}, /* East Asian ideograph */
  {"\x97", 0, 0x214357}, /* East Asian ideograph */
  {"\x8A", 0, 0x216C3C}, /* East Asian ideograph */
  {"\x8D", 0, 0x216C3D}, /* East Asian ideograph */
  {"\x90", 0, 0x216C40}, /* East Asian ideograph */
  {"\x91", 0, 0x216C41}, /* East Asian ideograph */
  {"\x94", 0, 0x216C46}, /* East Asian ideograph */
  {"\x96", 0, 0x216C48}, /* East Asian ideograph */
  {"\xA3", 0, 0x216C4C}, /* East Asian ideograph */
  {"\xA1", 0, 0x216C4E}, /* East Asian ideograph */
  {"\xA9", 0, 0x216C53}, /* East Asian ideograph */
  {"\xB0", 0, 0x216C58}, /* East Asian ideograph */
  {"\xB1", 0, 0x216C5A}, /* East Asian ideograph */
  {"\xB7", 0, 0x216C5E}, /* East Asian ideograph */
  {"\xB9", 0, 0x216C61}, /* East Asian ideograph */
  {"\xBA", 0, 0x216C62}, /* East Asian ideograph */
  {"\xBC", 0, 0x216C64}, /* East Asian ideograph */
  {"\x8B", 0, 0x273436}, /* East Asian ideograph */
  {"\xB3", 0, 0x2D3436}, /* East Asian ideograph */
  {"\xA7", 0, 0x2D343D}, /* East Asian ideograph */
  {"\xBE", 0, 0x2D3539}, /* East Asian ideograph */
  {"\x85", 0, 0x2E363F}, /* East Asian ideograph */
  {"\xA6", 0, 0x33337B}, /* East Asian ideograph */
  {"\xA0", 0, 0x453F6D}, /* East Asian ideograph */
  {"\xB2", 0, 0x4B3436}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page25 = {
  marc8r_31page25_flat, 0
};
/* PAGE 24 */
struct yaz_iconv_trie_flat marc8r_31page24_flat[] = {
  {"\x83", 0, 0x21337C}, /* East Asian ideograph */
  {"\x88", 0, 0x21337D}, /* East Asian ideograph */
  {"\x87", 0, 0x21337E}, /* East Asian ideograph */
  {"\x8D", 0, 0x213421}, /* East Asian ideograph */
  {"\x89", 0, 0x213422}, /* East Asian ideograph */
  {"\x91", 0, 0x213423}, /* East Asian ideograph */
  {"\x9B", 0, 0x213424}, /* East Asian ideograph */
  {"\x9F", 0, 0x213425}, /* East Asian ideograph */
  {"\xA0", 0, 0x213426}, /* East Asian ideograph */
  {"\xA3", 0, 0x213427}, /* East Asian ideograph */
  {"\xAB", 0, 0x213428}, /* East Asian ideograph */
  {"\xA9", 0, 0x213429}, /* East Asian ideograph */
  {"\xAC", 0, 0x21342A}, /* East Asian ideograph */
  {"\xAA", 0, 0x21342B}, /* East Asian ideograph */
  {"\xBE", 0, 0x21342C}, /* East Asian ideograph */
  {"\x82", 0, 0x216B74}, /* East Asian ideograph */
  {"\x81", 0, 0x216B75}, /* East Asian ideograph */
  {"\x8C", 0, 0x216B79}, /* East Asian ideograph */
  {"\x8A", 0, 0x216B7A}, /* East Asian ideograph */
  {"\x90", 0, 0x216B7C}, /* East Asian ideograph */
  {"\x93", 0, 0x216C21}, /* East Asian ideograph */
  {"\x96", 0, 0x216C27}, /* East Asian ideograph */
  {"\x98", 0, 0x216C29}, /* East Asian ideograph */
  {"\x9A", 0, 0x216C2B}, /* East Asian ideograph */
  {"\x99", 0, 0x216C2C}, /* East Asian ideograph */
  {"\xA6", 0, 0x216C2E}, /* East Asian ideograph */
  {"\xAD", 0, 0x216C31}, /* East Asian ideograph */
  {"\xAE", 0, 0x216C33}, /* East Asian ideograph */
  {"\xBB", 0, 0x216C37}, /* East Asian ideograph */
  {"\xBC", 0, 0x216C38}, /* East Asian ideograph */
  {"\xB2", 0, 0x27342F}, /* East Asian ideograph */
  {"\xA1", 0, 0x273433}, /* East Asian ideograph */
  {"\xA8", 0, 0x273434}, /* East Asian ideograph */
  {"\xB3", 0, 0x273435}, /* East Asian ideograph */
  {"\xBF", 0, 0x273438}, /* East Asian ideograph */
  {"\xB1", 0, 0x27343C}, /* East Asian ideograph */
  {"\x9D", 0, 0x27343D}, /* East Asian ideograph */
  {"\x9E", 0, 0x275B5F}, /* East Asian ideograph */
  {"\xB5", 0, 0x2D335F}, /* East Asian ideograph */
  {"\x94", 0, 0x2D3421}, /* East Asian ideograph */
  {"\xA2", 0, 0x2D343C}, /* East Asian ideograph */
  {"\xB9", 0, 0x334243}, /* East Asian ideograph */
  {"\xB4", 0, 0x4B3435}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page24 = {
  marc8r_31page24_flat, 0
};
/* PAGE 23 */
struct yaz_iconv_trie_flat marc8r_31page23_flat[] = {
  {"\x81", 0, 0x213366}, /* East Asian ideograph */
  {"\x83", 0, 0x213368}, /* East Asian ideograph */
  {"\x8D", 0, 0x213369}, /* East Asian ideograph */
  {"\x8C", 0, 0x21336A}, /* East Asian ideograph */
  {"\x8B", 0, 0x21336B}, /* East Asian ideograph */
  {"\x8A", 0, 0x21336C}, /* East Asian ideograph */
  {"\x87", 0, 0x21336D}, /* East Asian ideograph */
  {"\x9C", 0, 0x21336E}, /* East Asian ideograph */
  {"\x96", 0, 0x21336F}, /* East Asian ideograph */
  {"\x9B", 0, 0x213370}, /* East Asian ideograph */
  {"\x94", 0, 0x213371}, /* East Asian ideograph */
  {"\x9D", 0, 0x213372}, /* East Asian ideograph */
  {"\xAA", 0, 0x213373}, /* East Asian ideograph */
  {"\xAF", 0, 0x213374}, /* East Asian ideograph */
  {"\xB2", 0, 0x213375}, /* East Asian ideograph */
  {"\xB4", 0, 0x213376}, /* East Asian ideograph */
  {"\xA9", 0, 0x213377}, /* East Asian ideograph */
  {"\xB5", 0, 0x213378}, /* East Asian ideograph */
  {"\xBD", 0, 0x21337A}, /* East Asian ideograph */
  {"\xBF", 0, 0x21337B}, /* East Asian ideograph */
  {"\x84", 0, 0x216B3E}, /* East Asian ideograph */
  {"\x89", 0, 0x216B43}, /* East Asian ideograph */
  {"\xA0", 0, 0x216B47}, /* East Asian ideograph */
  {"\x9A", 0, 0x216B4B}, /* East Asian ideograph */
  {"\x92", 0, 0x216B4C}, /* East Asian ideograph */
  {"\x9E", 0, 0x216B4D}, /* East Asian ideograph */
  {"\x9F", 0, 0x216B50}, /* East Asian ideograph */
  {"\x95", 0, 0x216B53}, /* East Asian ideograph */
  {"\xAE", 0, 0x216B5B}, /* East Asian ideograph */
  {"\xA8", 0, 0x216B5E}, /* East Asian ideograph */
  {"\xB8", 0, 0x216B6B}, /* East Asian ideograph */
  {"\x80", 0, 0x273376}, /* East Asian ideograph */
  {"\xA7", 0, 0x27337E}, /* East Asian ideograph */
  {"\x91", 0, 0x273421}, /* East Asian ideograph */
  {"\x82", 0, 0x273423}, /* East Asian ideograph */
  {"\x90", 0, 0x276B5B}, /* East Asian ideograph */
  {"\xA5", 0, 0x2D3372}, /* East Asian ideograph */
  {"\xB3", 0, 0x2D6B5F}, /* East Asian ideograph */
  {"\xA1", 0, 0x2E3172}, /* East Asian ideograph */
  {"\xB0", 0, 0x333377}, /* East Asian ideograph */
  {"\xA4", 0, 0x333423}, /* East Asian ideograph */
  {"\x97", 0, 0x335E2F}, /* East Asian ideograph */
  {"\x8F", 0, 0x336B33}, /* East Asian ideograph */
  {"\xB7", 0, 0x395E2F}, /* East Asian ideograph */
  {"\x99", 0, 0x396B33}, /* East Asian ideograph */
  {"\xB1", 0, 0x453421}, /* East Asian ideograph */
  {"\xA3", 0, 0x4B3421}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page23 = {
  marc8r_31page23_flat, 0
};
/* PAGE 22 */
struct yaz_iconv_trie_dir marc8r_31page22_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x21334F} /* East Asian ideograph */,
  {0, 0, 0x213350} /* East Asian ideograph */,
  {0, 0, 0x2D334F} /* East Asian ideograph */,
  {0, 0, 0x213351} /* East Asian ideograph */,
  {0, 0, 0x4B3351} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x213353} /* East Asian ideograph */,
  {0, 0, 0x213352} /* East Asian ideograph */,
  {0, 0, 0x213354} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x213355} /* East Asian ideograph */,
  {0, 0, 0x4B3355} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x27545C} /* East Asian ideograph */,
  {0, 0, 0x213359} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x213356} /* East Asian ideograph */,
  {0, 0, 0x27337C} /* East Asian ideograph */,
  {0, 0, 0x216B24} /* East Asian ideograph */,
  {0, 0, 0x2D4029} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x216B26} /* East Asian ideograph */,
  {0, 0, 0x213357} /* East Asian ideograph */,
  {0, 0, 0x273422} /* East Asian ideograph */,
  {0, 0, 0x27336D} /* East Asian ideograph */,
  {0, 0, 0x273370} /* East Asian ideograph */,
  {0, 0, 0x273378} /* East Asian ideograph */,
  {0, 0, 0x216B2A} /* East Asian ideograph */,
  {0, 0, 0x21574E} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x396B2F} /* East Asian ideograph */,
  {0, 0, 0x21335C} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x21335A} /* East Asian ideograph */,
  {0, 0, 0x21335B} /* East Asian ideograph */,
  {0, 0, 0x2D3428} /* East Asian ideograph */,
  {0, 0, 0x393428} /* East Asian ideograph */,
  {0, 0, 0x21335D} /* East Asian ideograph */,
  {0, 0, 0x21335E} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x4B335B} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x276B3E} /* East Asian ideograph */,
  {0, 0, 0x27605E} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x213362} /* East Asian ideograph */,
  {0, 0, 0x216B33} /* East Asian ideograph */,
  {0, 0, 0x216B37} /* East Asian ideograph */,
  {0, 0, 0x216B39} /* East Asian ideograph */,
  {0, 0, 0x2D3366} /* East Asian ideograph */,
  {0, 0, 0x216B36} /* East Asian ideograph */,
  {0, 0, 0x27576C} /* East Asian ideograph */,
  {0, 0, 0x213361} /* East Asian ideograph */,
  {0, 0, 0x21335F} /* East Asian ideograph */,
  {0, 0, 0x213367} /* East Asian ideograph */,
  {0, 0, 0x213363} /* East Asian ideograph */,
  {0, 0, 0x213360} /* East Asian ideograph */,
  {0, 0, 0x333428} /* East Asian ideograph */,
  {0, 0, 0x276B7A} /* East Asian ideograph */,
  {0, 0, 0x4B576C} /* East Asian ideograph */,
  {0, 0, 0x276B79} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page22 = {
  0, marc8r_31page22_dir
};
/* PAGE 21 */
struct yaz_iconv_trie_dir marc8r_31page21_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {81, 0, 0},
  {82, 0, 0},
  {83, 0, 0},
  {84, 0, 0},
  {85, 0, 0},
  {86, 0, 0},
  {87, 0, 0},
  {88, 0, 0},
  {89, 0, 0},
  {90, 0, 0},
  {91, 0, 0},
  {92, 0, 0},
  {93, 0, 0},
  {94, 0, 0},
  {95, 0, 0},
  {96, 0, 0},
  {97, 0, 0},
  {98, 0, 0},
  {99, 0, 0},
  {100, 0, 0},
  {101, 0, 0},
  {102, 0, 0},
  {103, 0, 0},
  {104, 0, 0},
  {105, 0, 0},
  {106, 0, 0},
  {107, 0, 0},
  {80, 0, 0},
  {79, 0, 0},
  {108, 0, 0},
  {109, 0, 0},
  {110, 0, 0},
  {111, 0, 0},
  {112, 0, 0},
  {113, 0, 0},
  {114, 0, 0},
  {115, 0, 0},
  {116, 0, 0},
  {117, 0, 0},
  {118, 0, 0},
  {119, 0, 0},
  {120, 0, 0},
  {121, 0, 0},
  {122, 0, 0},
  {123, 0, 0},
  {124, 0, 0},
  {125, 0, 0},
  {126, 0, 0},
  {127, 0, 0},
  {128, 0, 0},
  {129, 0, 0},
  {130, 0, 0},
  {132, 0, 0},
  {131, 0, 0},
  {133, 0, 0},
  {134, 0, 0},
  {136, 0, 0},
  {135, 0, 0},
  {138, 0, 0},
  {137, 0, 0},
  {139, 0, 0},
  {140, 0, 0},
  {141, 0, 0},
  {142, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page21 = {
  0, marc8r_31page21_dir
};
/* PAGE 20 */
struct yaz_iconv_trie_flat marc8r_31page20_flat[] = {
  {"\x80", 0, 0x21332E}, /* East Asian ideograph */
  {"\x89", 0, 0x21332F}, /* East Asian ideograph */
  {"\x8C", 0, 0x213330}, /* East Asian ideograph */
  {"\x8D", 0, 0x213331}, /* East Asian ideograph */
  {"\x92", 0, 0x213332}, /* East Asian ideograph */
  {"\x91", 0, 0x213333}, /* East Asian ideograph */
  {"\x95", 0, 0x213334}, /* East Asian ideograph */
  {"\x97", 0, 0x213336}, /* East Asian ideograph */
  {"\xA0", 0, 0x213337}, /* East Asian ideograph */
  {"\xA5", 0, 0x213339}, /* East Asian ideograph */
  {"\xB0", 0, 0x21333C}, /* East Asian ideograph */
  {"\xB6", 0, 0x21333D}, /* East Asian ideograph */
  {"\xB7", 0, 0x21333E}, /* East Asian ideograph */
  {"\x87", 0, 0x216425}, /* East Asian ideograph */
  {"\x82", 0, 0x216967}, /* East Asian ideograph */
  {"\x84", 0, 0x216969}, /* East Asian ideograph */
  {"\x8F", 0, 0x21696E}, /* East Asian ideograph */
  {"\x94", 0, 0x216970}, /* East Asian ideograph */
  {"\x93", 0, 0x216971}, /* East Asian ideograph */
  {"\x96", 0, 0x216975}, /* East Asian ideograph */
  {"\xA1", 0, 0x21697B}, /* East Asian ideograph */
  {"\xA3", 0, 0x21697C}, /* East Asian ideograph */
  {"\xAA", 0, 0x216A22}, /* East Asian ideograph */
  {"\xAB", 0, 0x216A23}, /* East Asian ideograph */
  {"\xB1", 0, 0x216A26}, /* East Asian ideograph */
  {"\xBC", 0, 0x216A35}, /* East Asian ideograph */
  {"\xBB", 0, 0x273340}, /* East Asian ideograph */
  {"\x99", 0, 0x273B37}, /* East Asian ideograph */
  {"\x88", 0, 0x273B6E}, /* East Asian ideograph */
  {"\xB2", 0, 0x27574A}, /* East Asian ideograph (duplicate simplified) */
  {"\x9B", 0, 0x275B34}, /* East Asian ideograph */
  {"\x9C", 0, 0x275B64}, /* East Asian ideograph */
  {"\xAF", 0, 0x27612D}, /* East Asian ideograph */
  {"\xAC", 0, 0x276276}, /* East Asian ideograph */
  {"\x81", 0, 0x277360}, /* East Asian ideograph */
  {"\x90", 0, 0x2D3332}, /* East Asian ideograph */
  {"\xA2", 0, 0x2D3852}, /* East Asian ideograph */
  {"\xA8", 0, 0x2D3B27}, /* East Asian ideograph */
  {"\xB3", 0, 0x2D466D}, /* East Asian ideograph */
  {"\xB5", 0, 0x2D4730}, /* East Asian ideograph */
  {"\xA4", 0, 0x2D7E6A}, /* East Asian ideograph */
  {"\x8A", 0, 0x333330}, /* East Asian ideograph */
  {"\x85", 0, 0x4B3321}, /* East Asian ideograph */
  {"\x86", 0, 0x4B3772}, /* East Asian ideograph */
  {"\xA6", 0, 0x4B3B22}, /* East Asian ideograph */
  {"\xA9", 0, 0x4B3B37}, /* East Asian ideograph */
  {"\xBD", 0, 0x4B4741}, /* East Asian ideograph */
  {"\xB4", 0, 0x516A26}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page20 = {
  marc8r_31page20_flat, 0
};
/* PAGE 19 */
struct yaz_iconv_trie_dir marc8r_31page19_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x21326C} /* East Asian ideograph */,
  {0, 0, 0x21326E} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x21326D} /* East Asian ideograph */,
  {0, 0, 0x213270} /* East Asian ideograph */,
  {0, 0, 0x21326F} /* East Asian ideograph */,
  {0, 0, 0x213271} /* East Asian ideograph */,
  {0, 0, 0x213273} /* East Asian ideograph */,
  {0, 0, 0x213274} /* East Asian ideograph */,
  {0, 0, 0x213272} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x27336B} /* East Asian ideograph */,
  {0, 0, 0x213275} /* East Asian ideograph */,
  {0, 0, 0x213277} /* East Asian ideograph */,
  {0, 0, 0x2D3279} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x33327A} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x21327A} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x213279} /* East Asian ideograph */,
  {0, 0, 0x213278} /* East Asian ideograph */,
  {0, 0, 0x27327B} /* East Asian ideograph */,
  {0, 0, 0x21327B} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x216951} /* East Asian ideograph */,
  {0, 0, 0x27626F} /* East Asian ideograph */,
  {0, 0, 0x216952} /* East Asian ideograph */,
  {0, 0, 0x21327C} /* East Asian ideograph */,
  {0, 0, 0x216955} /* East Asian ideograph */,
  {0, 0, 0x216956} /* East Asian ideograph */,
  {0, 0, 0x216958} /* East Asian ideograph */,
  {0, 0, 0x216A73} /* East Asian ideograph */,
  {0, 0, 0x216959} /* East Asian ideograph */,
  {0, 0, 0x21327D} /* East Asian ideograph */,
  {0, 0, 0x21695C} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x21327E} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x213321} /* East Asian ideograph */,
  {0, 0, 0x213322} /* East Asian ideograph */,
  {0, 0, 0x213323} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x213324} /* East Asian ideograph */,
  {0, 0, 0x213327} /* East Asian ideograph */,
  {0, 0, 0x213325} /* East Asian ideograph */,
  {0, 0, 0x213326} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x27563E} /* East Asian ideograph */,
  {0, 0, 0x213328} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x275E69} /* East Asian ideograph */,
  {0, 0, 0x275433} /* East Asian ideograph */,
  {0, 0, 0x213329} /* East Asian ideograph */,
  {0, 0, 0x21332A} /* East Asian ideograph */,
  {0, 0, 0x21332B} /* East Asian ideograph */,
  {0, 0, 0x21332C} /* East Asian ideograph */,
  {0, 0, 0x215521} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x276071} /* East Asian ideograph */,
  {0, 0, 0x21332D} /* East Asian ideograph */,
  {0, 0, 0x274B2B} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x3F5631} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8r_31page19 = {
  0, marc8r_31page19_dir
};
/* PAGE 18 */
struct yaz_iconv_trie_flat marc8r_31page18_flat[] = {
  {"\x80", 0, 0x213259}, /* East Asian ideograph */
  {"\x84", 0, 0x21325A}, /* East Asian ideograph */
  {"\x82", 0, 0x21325E}, /* East Asian ideograph */
  {"\x8D", 0, 0x21325F}, /* East Asian ideograph */
  {"\x88", 0, 0x213260}, /* East Asian ideograph */
  {"\x89", 0, 0x213261}, /* East Asian ideograph */
  {"\x90", 0, 0x213262}, /* East Asian ideograph */
  {"\x98", 0, 0x213263}, /* East Asian ideograph */
  {"\x92", 0, 0x213264}, /* East Asian ideograph */
  {"\x94", 0, 0x213265}, /* East Asian ideograph */
  {"\xAA", 0, 0x213266}, /* East Asian ideograph */
  {"\x9F", 0, 0x213267}, /* East Asian ideograph */
  {"\xA1", 0, 0x213268}, /* East Asian ideograph */
  {"\xB2", 0, 0x213269}, /* East Asian ideograph */
  {"\xB7", 0, 0x21326A}, /* East Asian ideograph */
  {"\xBC", 0, 0x21326B}, /* East Asian ideograph */
  {"\x8E", 0, 0x21685B}, /* East Asian ideograph */
  {"\x85", 0, 0x21685F}, /* East Asian ideograph */
  {"\x86", 0, 0x216865}, /* East Asian ideograph */
  {"\x87", 0, 0x216866}, /* East Asian ideograph */
  {"\x8F", 0, 0x216867}, /* East Asian ideograph */
  {"\x8B", 0, 0x216869}, /* East Asian ideograph */
  {"\x81", 0, 0x21686D}, /* East Asian ideograph */
  {"\x95", 0, 0x216871}, /* East Asian ideograph */
  {"\x93", 0, 0x216872}, /* East Asian ideograph */
  {"\x9A", 0, 0x216878}, /* East Asian ideograph */
  {"\xA6", 0, 0x21687E}, /* East Asian ideograph */
  {"\xA4", 0, 0x216929}, /* East Asian ideograph */
  {"\xA9", 0, 0x21692B}, /* East Asian ideograph */
  {"\xB1", 0, 0x216930}, /* East Asian ideograph */
  {"\xB5", 0, 0x21693E}, /* East Asian ideograph */
  {"\xB3", 0, 0x216940}, /* East Asian ideograph */
  {"\xBA", 0, 0x216944}, /* East Asian ideograph */
  {"\xB9", 0, 0x216947}, /* East Asian ideograph */
  {"\xBB", 0, 0x216948}, /* East Asian ideograph */
  {"\xBF", 0, 0x27327A}, /* East Asian ideograph */
  {"\x8C", 0, 0x2D3251}, /* East Asian ideograph */
  {"\x9E", 0, 0x2D3944}, /* East Asian ideograph */
  {"\x97", 0, 0x2D4228}, /* East Asian ideograph */
  {"\x96", 0, 0x695130}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page18 = {
  marc8r_31page18_flat, 0
};
/* PAGE 17 */
struct yaz_iconv_trie_flat marc8r_31page17_flat[] = {
  {"\x85", 0, 0x213249}, /* East Asian ideograph */
  {"\xA7", 0, 0x21324E}, /* East Asian ideograph */
  {"\xAE", 0, 0x21324F}, /* East Asian ideograph */
  {"\xB1", 0, 0x213250}, /* East Asian ideograph */
  {"\xA5", 0, 0x213251}, /* East Asian ideograph */
  {"\x96", 0, 0x213252}, /* East Asian ideograph */
  {"\xAD", 0, 0x213253}, /* East Asian ideograph */
  {"\x9A", 0, 0x213254}, /* East Asian ideograph */
  {"\x95", 0, 0x213255}, /* East Asian ideograph */
  {"\x8F", 0, 0x213257}, /* East Asian ideograph */
  {"\x91", 0, 0x213258}, /* East Asian ideograph */
  {"\xBB", 0, 0x21325B}, /* East Asian ideograph */
  {"\xB5", 0, 0x21325C}, /* East Asian ideograph */
  {"\xB9", 0, 0x21325D}, /* East Asian ideograph */
  {"\x87", 0, 0x216771}, /* East Asian ideograph */
  {"\x89", 0, 0x216775}, /* East Asian ideograph */
  {"\x8A", 0, 0x21677B}, /* East Asian ideograph */
  {"\x82", 0, 0x216822}, /* East Asian ideograph */
  {"\x8D", 0, 0x21682E}, /* East Asian ideograph */
  {"\x94", 0, 0x216832}, /* East Asian ideograph */
  {"\xAF", 0, 0x216834}, /* East Asian ideograph */
  {"\xA6", 0, 0x216835}, /* East Asian ideograph */
  {"\xB4", 0, 0x21683A}, /* East Asian ideograph */
  {"\x8E", 0, 0x21683B}, /* East Asian ideograph */
  {"\x9D", 0, 0x21683C}, /* East Asian ideograph */
  {"\xB3", 0, 0x216841}, /* East Asian ideograph */
  {"\xA8", 0, 0x216842}, /* East Asian ideograph */
  {"\xB0", 0, 0x216844}, /* East Asian ideograph */
  {"\x99", 0, 0x216846}, /* East Asian ideograph */
  {"\xAC", 0, 0x216855}, /* East Asian ideograph */
  {"\xBC", 0, 0x216861}, /* East Asian ideograph */
  {"\xBE", 0, 0x216868}, /* East Asian ideograph */
  {"\xBD", 0, 0x21686A}, /* East Asian ideograph */
  {"\xA3", 0, 0x2D3253}, /* East Asian ideograph */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page17 = {
  marc8r_31page17_flat, 0
};
/* PAGE 16 */
struct yaz_iconv_trie_flat marc8r_31page16_flat[] = {
  {"\x8D", 0, 0x21323D}, /* East Asian ideograph */
  {"\xA2", 0, 0x21323E}, /* East Asian ideograph */
  {"\x85", 0, 0x21323F}, /* East Asian ideograph */
  {"\x99", 0, 0x213240}, /* East Asian ideograph */
  {"\x91", 0, 0x213241}, /* East Asian ideograph */
  {"\x80", 0, 0x213242}, /* East Asian ideograph */
  {"\x96", 0, 0x213243}, /* East Asian ideograph */
  {"\x98", 0, 0x213244}, /* East Asian ideograph */
  {"\xAD", 0, 0x213245}, /* East Asian ideograph */
  {"\xB3", 0, 0x213246}, /* East Asian ideograph */
  {"\xB5", 0, 0x213247}, /* East Asian ideograph */
  {"\xB2", 0, 0x213248}, /* East Asian ideograph */
  {"\xBE", 0, 0x21324A}, /* East Asian ideograph */
  {"\xAC", 0, 0x21324B}, /* East Asian ideograph */
  {"\xB7", 0, 0x21324C}, /* East Asian ideograph */
  {"\xAF", 0, 0x21324D}, /* East Asian ideograph */
  {"\x94", 0, 0x21674E}, /* East Asian ideograph */
  {"\x9E", 0, 0x216750}, /* East Asian ideograph */
  {"\x9B", 0, 0x216752}, /* East Asian ideograph */
  {"\x9A", 0, 0x216753}, /* East Asian ideograph */
  {"\xA3", 0, 0x216757}, /* East Asian ideograph */
  {"\x8C", 0, 0x21675A}, /* East Asian ideograph */
  {"\x88", 0, 0x21675C}, /* East Asian ideograph */
  {"\x8E", 0, 0x216762}, /* East Asian ideograph */
  {"\x95", 0, 0x216764}, /* East Asian ideograph */
  {"\xA6", 0, 0x216767}, /* East Asian ideograph */
  {"\x92", 0, 0x21676A}, /* East Asian ideograph */
  {"\x9C", 0, 0x21676C}, /* East Asian ideograph */
  {"\xB4", 0, 0x21677C}, /* East Asian ideograph */
  {"\xBA", 0, 0x21682C}, /* East Asian ideograph */
  {"\xA7", 0, 0x273262}, /* East Asian ideograph */
  {"\xA8", 0, 0x273269}, /* East Asian ideograph */
  {"\xA9", 0, 0x276944}, /* East Asian ideograph */
  {"\xA5", 0, 0x276948}, /* East Asian ideograph */
  {"\xBB", 0, 0x2D325F}, /* East Asian ideograph (variant of EACC 4B325F) */
  {"", 0, 0}
};
struct yaz_iconv_trie marc8r_31page16 = {
  marc8r_31page16_flat, 0
};
/* PAGE 15 */
struct yaz_iconv_trie_flat marc8r_31page15_flat[] = {
  {"\x9C", 0, 0x21322E}, /* East Asian ideograph */
  {"\x8F", 0, 0x21322F}, /* East Asian ideograph */
  {"\xA5", 0, 0x213230}, /* East Asian ideograph */
  {"\x87", 0, 0x213231}, /* East Asian ideograph */
  {"\x9A", 0, 0x213232}, /* East Asian ideograph */
  {"\x89", 0, 0x213233}, /* East Asian ideograph */
  {"\x83", 0, 0x213234}, /* East Asian ideograph */
  {"\xB4", 0, 0x213235}, /* East Asian ideograph */
  {"\xB6", 0, 0x213236}, /* East Asian ideograph */
  {"\x8E", 0, 0x213237}, /* East Asian ideograph */
  {"\xB5", 0, 0x213238}, /* East Asian ideograph */
  {"\x8C", 0, 0x213239}, /* East Asian ideograph */
  {"\x95", 0, 0x21323A}, /* East Asian ideograph */
  {"\xB7", 0, 0x21323C}, /* East Asian ideograph */
  {"\xBD", 0, 0x213256}, /* East Asian ideograph */
  {"\xAF", 0, 0x216722}, /* East Asian ideograph */
  {"\x90", 0, 0x216723}, /* East Asian ideograph */
  {"\xB0", 0, 0x216725}, /* East Asian ideograph */
  {"\x93", 0, 0x216729}, /* East Asian ideograph */
  {"\xAA", 0, 0x21672A}, /* East Asian ideograph */
  {"\x96", 0, 0x21672C}, /* East Asian ideograph */
  {"\xAD", 0, 0x216731}, /* East Asian ideograph */
  {"\x9D", 0, 0x2167