.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.TH XScreenSaver 1 "30-Oct-99" "X Version 11"
.SH NAME
xmatrix - simulates the computer displays from the movie
.SH SYNOPSIS
.B xmatrix
[\-display \fIhost:display.screen\fP] [\-window] [\-root] [\-install]
[\-visual \fIvisual\fP] 
[\-delay \fIusecs\fP] 
[\-density \fIpercentage\fP]
[\-top | \-bottom | \-both]
[\-small | \-large]
[\-trace]
[\-mode \fImode\fP]
[\-phone \fInumber\fP]
[\-fps]
.SH DESCRIPTION
The \fIxmatrix\fP program draws dropping characters similar to what
is seen on the computer monitors in the Wachowski brothers' film,
"The Matrix".  

Also see
.BR glmatrix (MANSUFFIX)
for a 3D rendering of the similar effect that appeared in the title
sequence of the movie.
.SH OPTIONS
.I xmatrix
accepts the following options:
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-install
Install a private colormap for the window.
.TP 8
.B \-visual \fIvisual\fP\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-delay \fIusecs\fP
The delay between steps of the animation, in microseconds: default 10000.
.TP 8
.B \-density \fIpercentage\fP
The approximate percentage of the screen that should be filled with 
characters at any given time.  Default 75%.

When running in a window, typing \fB+\fP will increase the density and 
typing \fB-\fP will decrease it.  Typing \fB0\fP will momentarily
drain the screen.
.TP 8
.B \-top\fP | \fB\-bottom\fP | \fB\-both
If \fB\-top\fP is specified, the characters will only drop in from the
top of the screen as sliding columns of characters.  If \fB\-bottom\fP
is specified, then instead of sliding columns, the characters will appear
as columns that grow downwards and are erased from above.  If \fB\-both\fP
is specified, then a mixture of both styles will be used.  The default
is \fB\-both\fP.

When running in a window, typing \fB[\fP will switch to top-mode, 
typing \fB\]\fP will switch to bottom-mode, and typing \fB\\\fP will
switch to both-mode.
.TP 8
.B \-small\fP | \fB\-large
These options specify the sizes of the characters.  The default
is \fB\-large\fP.
.TP 8
.B \-mode trace
Start off with a representation of a phone number being traced.  
When the number is finally found, display The Matrix as usual.
This is the default.
.TP 8
.B \-phone\fP \fInumber\fP
The phone number to trace, if \fB\-trace\fP is specified.
.TP 8
.B \-mode crack
Start off by shutting down the power grid.
.TP 8
.B \-mode binary
Instead of displaying Matrix glyphs, only display ones and zeros.
.TP 8
.B \-mode hexadecimal
Instead of displaying Matrix glyphs, display hexadecimal digits.
.TP 8
.B \-mode dna
Instead of displaying Matrix glyphs, display genetic code
(guanine, adenine, thymine, and cytosine.)
.TP 8
.B \-mode ascii
Instead of displaying Matrix glyphs, display random ASCII characters.
.TP 8
.B \-mode pipe
Instead of displaying random characters, display the output of a subprocess,
as ASCII.
.TP 8
.B \-program \fIsh-command\fP
The command to run to generate the text to display.  This option may
be any string acceptable to /bin/sh.  The program will be run at the
end of a pty or pipe, and any characters that it prints to
\fIstdout\fP will be placed in the feeders for xmatrix. If the program
exits, it will be launched again after xmatrix has processed all the
text it produced.

For example:
.EX
xmatrix -program 'echo Hello World'
xmatrix -ascii -program 'ps -eo comm | rev'
xmatrix -program 'od -txC -w6 /dev/random'
xmatrix -program 'cat /dev/random'
.EE
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR glmatrix (MANSUFFIX),
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 1999-2003 by Jamie Zawinski.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Jamie Zawinski <jwz@jwz.org>, 25-Apr-99.
