/*
 * Copyright (c) 2001-2009 XORP, Inc.
 * See the XORP LICENSE.lgpl file for licensing, conditions, and warranties
 * on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'tgt-gen'.
 */

#ident "$XORP: xorp/xrl/targets/vrrp_base.cc,v 1.2 2009/01/05 18:31:15 jtc Exp $"


#include "vrrp_base.hh"


XrlVrrpTargetBase::XrlVrrpTargetBase(XrlCmdMap* cmds)
    : _cmds(cmds)
{
    if (_cmds)
	add_handlers();
}

XrlVrrpTargetBase::~XrlVrrpTargetBase()
{
    if (_cmds)
	remove_handlers();
}

bool
XrlVrrpTargetBase::set_command_map(XrlCmdMap* cmds)
{
    if (_cmds == 0 && cmds) {
        _cmds = cmds;
        add_handlers();
        return true;
    }
    if (_cmds && cmds == 0) {
	remove_handlers();
        _cmds = cmds;
        return true;
    }
    return false;
}

const XrlCmdError
XrlVrrpTargetBase::handle_common_0_1_get_target_name(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_target_name");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string name;
    try {
	XrlCmdError e = common_0_1_get_target_name(
	    name);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_target_name", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("name", name);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlVrrpTargetBase::handle_common_0_1_get_version(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_version");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string version;
    try {
	XrlCmdError e = common_0_1_get_version(
	    version);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("version", version);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlVrrpTargetBase::handle_common_0_1_get_status(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_status");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t status;
    string reason;
    try {
	XrlCmdError e = common_0_1_get_status(
	    status,
	    reason);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_status", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("status", status);
	pxa_outputs->add("reason", reason);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlVrrpTargetBase::handle_common_0_1_shutdown(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/shutdown");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = common_0_1_shutdown();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/shutdown", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlVrrpTargetBase::handle_vrrp_0_1_add_vrid(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "vrrp/0.1/add_vrid");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = vrrp_0_1_add_vrid(
	    xa_inputs.get(0, "ifname").text(),
	    xa_inputs.get(1, "vifname").text(),
	    xa_inputs.get(2, "vrid").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "vrrp/0.1/add_vrid", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlVrrpTargetBase::handle_vrrp_0_1_delete_vrid(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "vrrp/0.1/delete_vrid");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = vrrp_0_1_delete_vrid(
	    xa_inputs.get(0, "ifname").text(),
	    xa_inputs.get(1, "vifname").text(),
	    xa_inputs.get(2, "vrid").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "vrrp/0.1/delete_vrid", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlVrrpTargetBase::handle_vrrp_0_1_set_priority(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "vrrp/0.1/set_priority");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = vrrp_0_1_set_priority(
	    xa_inputs.get(0, "ifname").text(),
	    xa_inputs.get(1, "vifname").text(),
	    xa_inputs.get(2, "vrid").uint32(),
	    xa_inputs.get(3, "priority").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "vrrp/0.1/set_priority", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlVrrpTargetBase::handle_vrrp_0_1_set_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "vrrp/0.1/set_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = vrrp_0_1_set_interval(
	    xa_inputs.get(0, "ifname").text(),
	    xa_inputs.get(1, "vifname").text(),
	    xa_inputs.get(2, "vrid").uint32(),
	    xa_inputs.get(3, "interval").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "vrrp/0.1/set_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlVrrpTargetBase::handle_vrrp_0_1_set_preempt(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "vrrp/0.1/set_preempt");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = vrrp_0_1_set_preempt(
	    xa_inputs.get(0, "ifname").text(),
	    xa_inputs.get(1, "vifname").text(),
	    xa_inputs.get(2, "vrid").uint32(),
	    xa_inputs.get(3, "preempt").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "vrrp/0.1/set_preempt", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlVrrpTargetBase::handle_vrrp_0_1_set_disable(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "vrrp/0.1/set_disable");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = vrrp_0_1_set_disable(
	    xa_inputs.get(0, "ifname").text(),
	    xa_inputs.get(1, "vifname").text(),
	    xa_inputs.get(2, "vrid").uint32(),
	    xa_inputs.get(3, "disable").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "vrrp/0.1/set_disable", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlVrrpTargetBase::handle_vrrp_0_1_add_ip(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "vrrp/0.1/add_ip");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = vrrp_0_1_add_ip(
	    xa_inputs.get(0, "ifname").text(),
	    xa_inputs.get(1, "vifname").text(),
	    xa_inputs.get(2, "vrid").uint32(),
	    xa_inputs.get(3, "ip").ipv4());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "vrrp/0.1/add_ip", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlVrrpTargetBase::handle_vrrp_0_1_delete_ip(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "vrrp/0.1/delete_ip");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = vrrp_0_1_delete_ip(
	    xa_inputs.get(0, "ifname").text(),
	    xa_inputs.get(1, "vifname").text(),
	    xa_inputs.get(2, "vrid").uint32(),
	    xa_inputs.get(3, "ip").ipv4());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "vrrp/0.1/delete_ip", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlVrrpTargetBase::handle_vrrp_0_1_get_ifs(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "vrrp/0.1/get_ifs");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList ifs;
    try {
	XrlCmdError e = vrrp_0_1_get_ifs(
	    ifs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "vrrp/0.1/get_ifs", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("ifs", ifs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlVrrpTargetBase::handle_vrrp_0_1_get_vifs(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "vrrp/0.1/get_vifs");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList vifs;
    try {
	XrlCmdError e = vrrp_0_1_get_vifs(
	    xa_inputs.get(0, "ifname").text(),
	    vifs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "vrrp/0.1/get_vifs", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("vifs", vifs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlVrrpTargetBase::handle_vrrp_0_1_get_vrids(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "vrrp/0.1/get_vrids");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList vrids;
    try {
	XrlCmdError e = vrrp_0_1_get_vrids(
	    xa_inputs.get(0, "ifname").text(),
	    xa_inputs.get(1, "vifname").text(),
	    vrids);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "vrrp/0.1/get_vrids", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("vrids", vrids);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlVrrpTargetBase::handle_vrrp_0_1_get_vrid_info(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "vrrp/0.1/get_vrid_info");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string state;
    IPv4 master;
    try {
	XrlCmdError e = vrrp_0_1_get_vrid_info(
	    xa_inputs.get(0, "ifname").text(),
	    xa_inputs.get(1, "vifname").text(),
	    xa_inputs.get(2, "vrid").uint32(),
	    state,
	    master);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "vrrp/0.1/get_vrid_info", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("state", state);
	pxa_outputs->add("master", master);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlVrrpTargetBase::handle_raw_packet4_client_0_1_recv(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 10) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(10), XORP_UINT_CAST(xa_inputs.size()), "raw_packet4_client/0.1/recv");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_packet4_client_0_1_recv(
	    xa_inputs.get(0, "if_name").text(),
	    xa_inputs.get(1, "vif_name").text(),
	    xa_inputs.get(2, "src_address").ipv4(),
	    xa_inputs.get(3, "dst_address").ipv4(),
	    xa_inputs.get(4, "ip_protocol").uint32(),
	    xa_inputs.get(5, "ip_ttl").int32(),
	    xa_inputs.get(6, "ip_tos").int32(),
	    xa_inputs.get(7, "ip_router_alert").boolean(),
	    xa_inputs.get(8, "ip_internet_control").boolean(),
	    xa_inputs.get(9, "payload").binary());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_packet4_client/0.1/recv", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlVrrpTargetBase::handle_raw_link_client_0_1_recv(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "raw_link_client/0.1/recv");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_link_client_0_1_recv(
	    xa_inputs.get(0, "if_name").text(),
	    xa_inputs.get(1, "vif_name").text(),
	    xa_inputs.get(2, "src_address").mac(),
	    xa_inputs.get(3, "dst_address").mac(),
	    xa_inputs.get(4, "ether_type").uint32(),
	    xa_inputs.get(5, "payload").binary());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_link_client/0.1/recv", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

void
XrlVrrpTargetBase::add_handlers()
{
	if (_cmds->add_handler("common/0.1/get_target_name",
	    callback(this, &XrlVrrpTargetBase::handle_common_0_1_get_target_name)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "vrrp", "common/0.1/get_target_name");
	}
	if (_cmds->add_handler("common/0.1/get_version",
	    callback(this, &XrlVrrpTargetBase::handle_common_0_1_get_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "vrrp", "common/0.1/get_version");
	}
	if (_cmds->add_handler("common/0.1/get_status",
	    callback(this, &XrlVrrpTargetBase::handle_common_0_1_get_status)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "vrrp", "common/0.1/get_status");
	}
	if (_cmds->add_handler("common/0.1/shutdown",
	    callback(this, &XrlVrrpTargetBase::handle_common_0_1_shutdown)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "vrrp", "common/0.1/shutdown");
	}
	if (_cmds->add_handler("vrrp/0.1/add_vrid",
	    callback(this, &XrlVrrpTargetBase::handle_vrrp_0_1_add_vrid)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "vrrp", "vrrp/0.1/add_vrid");
	}
	if (_cmds->add_handler("vrrp/0.1/delete_vrid",
	    callback(this, &XrlVrrpTargetBase::handle_vrrp_0_1_delete_vrid)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "vrrp", "vrrp/0.1/delete_vrid");
	}
	if (_cmds->add_handler("vrrp/0.1/set_priority",
	    callback(this, &XrlVrrpTargetBase::handle_vrrp_0_1_set_priority)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "vrrp", "vrrp/0.1/set_priority");
	}
	if (_cmds->add_handler("vrrp/0.1/set_interval",
	    callback(this, &XrlVrrpTargetBase::handle_vrrp_0_1_set_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "vrrp", "vrrp/0.1/set_interval");
	}
	if (_cmds->add_handler("vrrp/0.1/set_preempt",
	    callback(this, &XrlVrrpTargetBase::handle_vrrp_0_1_set_preempt)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "vrrp", "vrrp/0.1/set_preempt");
	}
	if (_cmds->add_handler("vrrp/0.1/set_disable",
	    callback(this, &XrlVrrpTargetBase::handle_vrrp_0_1_set_disable)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "vrrp", "vrrp/0.1/set_disable");
	}
	if (_cmds->add_handler("vrrp/0.1/add_ip",
	    callback(this, &XrlVrrpTargetBase::handle_vrrp_0_1_add_ip)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "vrrp", "vrrp/0.1/add_ip");
	}
	if (_cmds->add_handler("vrrp/0.1/delete_ip",
	    callback(this, &XrlVrrpTargetBase::handle_vrrp_0_1_delete_ip)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "vrrp", "vrrp/0.1/delete_ip");
	}
	if (_cmds->add_handler("vrrp/0.1/get_ifs",
	    callback(this, &XrlVrrpTargetBase::handle_vrrp_0_1_get_ifs)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "vrrp", "vrrp/0.1/get_ifs");
	}
	if (_cmds->add_handler("vrrp/0.1/get_vifs",
	    callback(this, &XrlVrrpTargetBase::handle_vrrp_0_1_get_vifs)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "vrrp", "vrrp/0.1/get_vifs");
	}
	if (_cmds->add_handler("vrrp/0.1/get_vrids",
	    callback(this, &XrlVrrpTargetBase::handle_vrrp_0_1_get_vrids)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "vrrp", "vrrp/0.1/get_vrids");
	}
	if (_cmds->add_handler("vrrp/0.1/get_vrid_info",
	    callback(this, &XrlVrrpTargetBase::handle_vrrp_0_1_get_vrid_info)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "vrrp", "vrrp/0.1/get_vrid_info");
	}
	if (_cmds->add_handler("raw_packet4_client/0.1/recv",
	    callback(this, &XrlVrrpTargetBase::handle_raw_packet4_client_0_1_recv)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "vrrp", "raw_packet4_client/0.1/recv");
	}
	if (_cmds->add_handler("raw_link_client/0.1/recv",
	    callback(this, &XrlVrrpTargetBase::handle_raw_link_client_0_1_recv)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "vrrp", "raw_link_client/0.1/recv");
	}
	_cmds->finalize();
}

void
XrlVrrpTargetBase::remove_handlers()
{
	_cmds->remove_handler("common/0.1/get_target_name");
	_cmds->remove_handler("common/0.1/get_version");
	_cmds->remove_handler("common/0.1/get_status");
	_cmds->remove_handler("common/0.1/shutdown");
	_cmds->remove_handler("vrrp/0.1/add_vrid");
	_cmds->remove_handler("vrrp/0.1/delete_vrid");
	_cmds->remove_handler("vrrp/0.1/set_priority");
	_cmds->remove_handler("vrrp/0.1/set_interval");
	_cmds->remove_handler("vrrp/0.1/set_preempt");
	_cmds->remove_handler("vrrp/0.1/set_disable");
	_cmds->remove_handler("vrrp/0.1/add_ip");
	_cmds->remove_handler("vrrp/0.1/delete_ip");
	_cmds->remove_handler("vrrp/0.1/get_ifs");
	_cmds->remove_handler("vrrp/0.1/get_vifs");
	_cmds->remove_handler("vrrp/0.1/get_vrids");
	_cmds->remove_handler("vrrp/0.1/get_vrid_info");
	_cmds->remove_handler("raw_packet4_client/0.1/recv");
	_cmds->remove_handler("raw_link_client/0.1/recv");
}
