/******************************************************************
 
        MUSCLE SmartCard Development ( http://www.musclecard.com )
            Title  : xcardCreateObj.h
            Author : David Corcoran
            Date   : 10/05/01
	    License: Copyright (C) 2001 David Corcoran
	             <corcoran@linuxnet.com>
            Purpose: This provides functionality for the xcard
	             personalization tool for the musclecard.
 
********************************************************************/ 

#ifndef xcardCreateObj_included
#define xcardCreateObj_included

#include "xcardCreateObjData.h"
#include "xcardMain.h"

#ifdef MSC_TARGET_OSX
#include <PCSC/musclecard.h>
#else
#include <musclecard.h>
#endif

class xcardCreateObj : public xcardCreateObjData
{
    Q_OBJECT

public:

    MSCLPTokenConnection pConnect;
    xcardMain *mainWindow;
    char *selectFile;
    QString importFile;
    bool isFileOK;

    xcardCreateObj(
		   MSCLPTokenConnection pConn,
		   xcardMain *mainWin,
		   char *optFile,
		   QWidget *parent = NULL,
		   const char *name = NULL );

    virtual ~xcardCreateObj();

    void XCCheckInputFile();

    protected slots:

    virtual void XCCreateObjectClicked();
    virtual void XCCancelCreateObjectClicked();
    virtual void XCCreateInputButtonClicked();
};
#endif // xcardCreateObj_included
