/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class DiscreteAngle {
    private SortedSet angles = new TreeSet();

    public double getAngle(double d2) {
        if (this.angles.isEmpty()) {
            return d2;
        }
        Iterator iterator = this.angles.iterator();
        Double d3 = (Double)iterator.next();
        if (!iterator.hasNext()) {
            return d3;
        }
        while (iterator.hasNext()) {
            Double d4 = (Double)iterator.next();
            double d5 = (d4 - d3) / 2.0 + d3;
            if (d2 <= d5) {
                return d3;
            }
            d3 = d4;
        }
        return d3;
    }

    public Double addAngle(double d2) {
        Double d3 = new Double(d2);
        this.angles.add(d3);
        return d3;
    }

    public boolean removeAngle(double d2) {
        Iterator iterator = this.angles.iterator();
        while (iterator.hasNext()) {
            Double d3 = (Double)iterator.next();
            if (d3 != d2) continue;
            return this.removeAngle(d3);
        }
        return false;
    }

    public boolean removeAngle(Double d2) {
        return d2 != null ? this.angles.remove(d2) : false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Angles: ");
        Iterator iterator = this.angles.iterator();
        while (iterator.hasNext()) {
            Double d2 = (Double)iterator.next();
            stringBuffer.append(d2);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        DiscreteAngle discreteAngle = new DiscreteAngle();
        discreteAngle.addAngle(0.0);
        discreteAngle.addAngle(90.0);
        discreteAngle.addAngle(180.0);
        discreteAngle.addAngle(270.0);
        discreteAngle.addAngle(360.0);
        discreteAngle.addAngle(10.0);
        discreteAngle.addAngle(190.0);
        System.out.println("  0 results in " + discreteAngle.getAngle(0.0));
        System.out.println("  1 results in " + discreteAngle.getAngle(1.0));
        System.out.println("  5 results in " + discreteAngle.getAngle(5.0));
        System.out.println(" 80 results in " + discreteAngle.getAngle(80.0));
        System.out.println(" 90 results in " + discreteAngle.getAngle(90.0));
        System.out.println("170 results in " + discreteAngle.getAngle(170.0));
        System.out.println("185 results in " + discreteAngle.getAngle(185.0));
        System.out.println("186 results in " + discreteAngle.getAngle(186.0));
        System.out.println("231 results in " + discreteAngle.getAngle(231.0));
        System.out.println("359 results in " + discreteAngle.getAngle(359.0));
    }
}

