/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ppm;

import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.freehep.graphicsio.ppm.ImageEncoder;

public class PPMEncoder
extends ImageEncoder {
    private List comments = new ArrayList();

    public PPMEncoder(Image image, OutputStream outputStream) throws IOException {
        super(image, (DataOutput)new DataOutputStream(outputStream));
    }

    public PPMEncoder(Image image, DataOutput dataOutput) throws IOException {
        super(image, dataOutput);
    }

    public PPMEncoder(ImageProducer imageProducer, OutputStream outputStream) throws IOException {
        super(imageProducer, (DataOutput)new DataOutputStream(outputStream));
    }

    public PPMEncoder(ImageProducer imageProducer, DataOutput dataOutput) throws IOException {
        super(imageProducer, dataOutput);
    }

    public void addComment(String string) {
        this.comments.add(string);
    }

    protected void encodeStart(int n2, int n3) throws IOException {
        this.writeString("P6\n");
        Iterator iterator = this.comments.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.writeString("# " + string + "\n");
        }
        this.writeString(n2 + " " + n3 + "\n");
        this.writeString("255\n");
    }

    void writeString(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this.out.write(byArray);
    }

    protected void encodePixels(int n2, int n3, int n4, int n5, int[] nArray, int n6, int n7) throws IOException {
        byte[] byArray = new byte[n4 * 3];
        for (int i2 = 0; i2 < n5; ++i2) {
            int n8 = n6 + i2 * n7;
            for (int i3 = 0; i3 < n4; ++i3) {
                int n9 = n8 + i3;
                int n10 = i3 * 3;
                byArray[n10] = (byte)((nArray[n9] & 0xFF0000) >> 16);
                byArray[n10 + 1] = (byte)((nArray[n9] & 0xFF00) >> 8);
                byArray[n10 + 2] = (byte)(nArray[n9] & 0xFF);
            }
            this.out.write(byArray);
        }
    }

    protected void encodeDone() throws IOException {
    }
}

