/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.freehep.graphicsio.font.truetype.TTFInput;

public class TTFFileInput
extends TTFInput {
    private RandomAccessFile ttf;
    private long offset;
    private long length;
    private long checksum;

    public TTFFileInput(RandomAccessFile randomAccessFile, long l2, long l3, long l4) throws IOException {
        this.ttf = randomAccessFile;
        this.offset = l2;
        this.length = l3;
        this.checksum = l4;
    }

    public void seek(long l2) throws IOException {
        this.ttf.seek(this.offset + l2);
    }

    long getPointer() throws IOException {
        return this.ttf.getFilePointer() - this.offset;
    }

    public int readByte() throws IOException {
        return this.ttf.readUnsignedByte();
    }

    public int readRawByte() throws IOException {
        return this.ttf.readByte() & 0xFF;
    }

    public short readShort() throws IOException {
        return this.ttf.readShort();
    }

    public int readUShort() throws IOException {
        return this.ttf.readUnsignedShort();
    }

    public int readLong() throws IOException {
        return this.ttf.readInt();
    }

    public long readULong() throws IOException {
        byte[] byArray = new byte[4];
        this.ttf.readFully(byArray);
        long l2 = 0L;
        long l3 = 1L;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            l2 += (long)(byArray[3 - i2] & 0xFF) * l3;
            l3 *= 256L;
        }
        return l2;
    }

    public byte readChar() throws IOException {
        return this.ttf.readByte();
    }

    public void readFully(byte[] byArray) throws IOException {
        this.ttf.readFully(byArray);
    }

    public String toString() {
        return this.offset + "-" + (this.offset + this.length - 1L) + " - " + this.checksum;
    }
}

