/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.io.IOException;
import org.freehep.graphicsio.font.truetype.TTFTable;

public class TTFCMapTable
extends TTFTable {
    public int version;
    public EncodingTable[] encodingTable;

    public String getTag() {
        return "cmap";
    }

    public void readTable() throws IOException {
        int n2;
        this.version = this.ttf.readUShort();
        this.encodingTable = new EncodingTable[this.ttf.readUShort()];
        for (n2 = 0; n2 < this.encodingTable.length; ++n2) {
            this.encodingTable[n2] = new EncodingTable();
            this.encodingTable[n2].readHeader();
        }
        for (n2 = 0; n2 < this.encodingTable.length; ++n2) {
            this.encodingTable[n2].readBody();
        }
    }

    public String toString() {
        String string = super.toString() + " v" + this.version;
        for (int i2 = 0; i2 < this.encodingTable.length; ++i2) {
            string = string + "\n  " + this.encodingTable[i2];
        }
        return string;
    }

    public class EncodingTable {
        public int platformID;
        public int encodingID;
        public long offset;
        public int format;
        public int length;
        public int version;
        public TableFormat tableFormat;

        public void readHeader() throws IOException {
            this.platformID = TTFCMapTable.this.ttf.readUShort();
            this.encodingID = TTFCMapTable.this.ttf.readUShort();
            this.offset = TTFCMapTable.this.ttf.readULong();
        }

        public void readBody() throws IOException {
            TTFCMapTable.this.ttf.seek(this.offset);
            this.format = TTFCMapTable.this.ttf.readUShort();
            this.length = TTFCMapTable.this.ttf.readUShort();
            this.version = TTFCMapTable.this.ttf.readUShort();
            switch (this.format) {
                case 0: {
                    this.tableFormat = new TableFormat0();
                    break;
                }
                case 4: {
                    this.tableFormat = new TableFormat4();
                    break;
                }
                case 2: 
                case 6: {
                    System.err.println("Unimplementet encoding table format: " + this.format);
                    break;
                }
                default: {
                    System.err.println("Illegal value for encoding table format: " + this.format);
                }
            }
            if (this.tableFormat != null) {
                this.tableFormat.read();
            }
        }

        public String toString() {
            String string = "[encoding] PID:" + this.platformID + " EID:" + this.encodingID + " format:" + this.format + " v" + this.version + (this.tableFormat != null ? this.tableFormat.toString() : " [no data read]");
            return string;
        }
    }

    public abstract class TableFormat {
        public abstract void read() throws IOException;

        public abstract int getGlyphIndex(int var1);
    }

    public class TableFormat0
    extends TableFormat {
        public int[] glyphIdArray = new int[256];

        public void read() throws IOException {
            for (int i2 = 0; i2 < this.glyphIdArray.length; ++i2) {
                this.glyphIdArray[i2] = TTFCMapTable.this.ttf.readByte();
            }
        }

        public String toString() {
            String string = "";
            for (int i2 = 0; i2 < this.glyphIdArray.length; ++i2) {
                if (i2 % 16 == 0) {
                    string = string + "\n    " + Integer.toHexString(i2 / 16) + "x: ";
                }
                String string2 = this.glyphIdArray[i2] + "";
                while (string2.length() < 3) {
                    string2 = " " + string2;
                }
                string = string + string2 + " ";
            }
            return string;
        }

        public int getGlyphIndex(int n2) {
            return this.glyphIdArray[n2];
        }
    }

    public class TableFormat4
    extends TableFormat {
        public int segCount;
        public int[] endCount;
        public int[] startCount;
        public int[] idRangeOffset;
        public short[] idDelta;

        public void read() throws IOException {
            this.segCount = TTFCMapTable.this.ttf.readUShort() / 2;
            TTFCMapTable.this.ttf.readUShort();
            TTFCMapTable.this.ttf.readUShort();
            TTFCMapTable.this.ttf.readUShort();
            this.endCount = TTFCMapTable.this.ttf.readUShortArray(this.segCount);
            int n2 = TTFCMapTable.this.ttf.readUShort();
            if (n2 != 0) {
                System.err.println("reservedPad not 0, but " + n2 + ".");
            }
            this.startCount = TTFCMapTable.this.ttf.readUShortArray(this.endCount.length);
            this.idDelta = TTFCMapTable.this.ttf.readShortArray(this.endCount.length);
            this.idRangeOffset = TTFCMapTable.this.ttf.readUShortArray(this.endCount.length);
        }

        public String toString() {
            String string = "\n   " + this.endCount.length + " sections:";
            for (int i2 = 0; i2 < this.endCount.length; ++i2) {
                string = string + "\n    " + this.startCount[i2] + " to " + this.endCount[i2] + " : " + this.idDelta[i2] + " (" + this.idRangeOffset[i2] + ")";
            }
            return string;
        }

        public int getGlyphIndex(int n2) {
            return 0;
        }
    }
}

