/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphics2d.font.Lookup;

public abstract class FontTable {
    private Hashtable table = new Hashtable();

    public abstract CharTable getEncodingTable();

    protected abstract void firstRequest(Entry var1, boolean var2, String var3) throws IOException;

    protected abstract String createFontReference(Font var1);

    protected abstract Font substituteFont(Font var1);

    public String fontReference(Font font, boolean bl2, String string) {
        String string2 = this.getKey(font = this.substituteFont(font));
        Entry entry = (Entry)this.table.get(string2);
        if (entry == null) {
            entry = new Entry(font, this.getEncodingTable(font));
            try {
                this.firstRequest(entry, bl2, string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.table.put(string2, entry);
        }
        return entry.ref;
    }

    private String getKey(Font font) {
        Map<TextAttribute, ?> map = font.getAttributes();
        StringBuffer stringBuffer = new StringBuffer(font.getName());
        stringBuffer.append("[WEIGHT:");
        stringBuffer.append(map.get(TextAttribute.WEIGHT));
        stringBuffer.append("]");
        stringBuffer.append("[POSTURE:");
        stringBuffer.append(map.get(TextAttribute.POSTURE));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static void normalize(Map map) {
        String string = (String)map.get(TextAttribute.FAMILY);
        if (string.toLowerCase().endsWith(".bold")) {
            map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            int n2 = string.toLowerCase().indexOf(".bold");
            string = string.substring(0, n2);
        } else if (string.toLowerCase().endsWith(".italic")) {
            map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            int n3 = string.toLowerCase().indexOf(".bold");
            string = string.substring(0, n3);
        } else if (string.toLowerCase().endsWith(".plain")) {
            int n4 = string.toLowerCase().indexOf(".plain");
            string = string.substring(0, n4);
        }
        string = string.substring(0, 1).toUpperCase() + string.substring(1, string.length());
        map.put(TextAttribute.FAMILY, string);
    }

    public Collection getEntries() {
        return this.table.values();
    }

    private CharTable getEncodingTable(Font font) {
        String string = font.getName().toLowerCase();
        if (string.indexOf("symbol") >= 0) {
            return Lookup.getInstance().getTable("Symbol");
        }
        if (string.indexOf("zapfdingbats") >= 0) {
            return Lookup.getInstance().getTable("Zapfdingbats");
        }
        return this.getEncodingTable();
    }

    protected class Entry {
        private Font font;
        private String ref;
        private CharTable encoding;
        private boolean written;

        private Entry(Font font, CharTable charTable) {
            Map<TextAttribute, ?> map = font.getAttributes();
            map.put(TextAttribute.SIZE, new Float(1000.0));
            map.remove(TextAttribute.TRANSFORM);
            map.remove(TextAttribute.SUPERSCRIPT);
            this.font = new Font(map);
            this.ref = FontTable.this.createFontReference(this.font);
            this.encoding = charTable;
            this.written = false;
        }

        public Font getFont() {
            return this.font;
        }

        public String getReference() {
            return this.ref;
        }

        protected void setReference(String string) {
            this.ref = string;
        }

        public CharTable getEncoding() {
            return this.encoding;
        }

        public void setWritten(boolean bl2) {
            this.written = bl2;
        }

        public boolean isWritten() {
            return this.written;
        }

        public String toString() {
            return this.ref + "=" + this.font;
        }
    }
}

