/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;

public class PolyBezier16
extends EMFTag {
    private Rectangle bounds;
    private int numberOfPoints;
    private Point[] points;

    public PolyBezier16() {
        super(85, 1);
    }

    public PolyBezier16(Rectangle rectangle, int n2, Point[] pointArray) {
        this();
        this.bounds = rectangle;
        this.numberOfPoints = n2;
        this.points = pointArray;
    }

    public EMFTag read(int n2, EMFInputStream eMFInputStream, int n3) throws IOException {
        Rectangle rectangle = eMFInputStream.readRECTL();
        int n4 = eMFInputStream.readDWORD();
        PolyBezier16 polyBezier16 = new PolyBezier16(rectangle, n4, eMFInputStream.readPOINTS(n4));
        return polyBezier16;
    }

    public void write(int n2, EMFOutputStream eMFOutputStream) throws IOException {
        eMFOutputStream.writeRECTL(this.bounds);
        eMFOutputStream.writeDWORD(this.numberOfPoints);
        eMFOutputStream.writePOINTS(this.numberOfPoints, this.points);
    }

    public String toString() {
        return super.toString() + "\n" + "  bounds: " + this.bounds + "\n" + "  #points: " + this.numberOfPoints;
    }
}

