/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Font;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.gdi.LogFontW;
import org.freehep.graphicsio.emf.gdi.Panose;

public class ExtLogFontW
implements EMFConstants {
    private LogFontW font;
    private String fullName;
    private String style;
    private int version;
    private int styleSize;
    private int match;
    private byte[] vendorID;
    private int culture;
    private Panose panose;

    public ExtLogFontW(LogFontW logFontW, String string, String string2, int n2, int n3, int n4, byte[] byArray, int n5, Panose panose) {
        this.font = logFontW;
        this.fullName = string;
        this.style = string2;
        this.version = n2;
        this.styleSize = n3;
        this.match = n4;
        this.vendorID = byArray;
        this.culture = n5;
        this.panose = panose;
    }

    public ExtLogFontW(Font font) {
        this.font = new LogFontW(font);
        this.fullName = "";
        this.style = "";
        this.version = 0;
        this.styleSize = 0;
        this.match = 0;
        this.vendorID = new byte[]{0, 0, 0, 0};
        this.culture = 0;
        this.panose = new Panose();
    }

    public ExtLogFontW(EMFInputStream eMFInputStream) throws IOException {
        this.font = new LogFontW(eMFInputStream);
        this.fullName = eMFInputStream.readWCHAR(64);
        this.style = eMFInputStream.readWCHAR(32);
        this.version = eMFInputStream.readDWORD();
        this.styleSize = eMFInputStream.readDWORD();
        this.match = eMFInputStream.readDWORD();
        eMFInputStream.readDWORD();
        this.vendorID = eMFInputStream.readBYTE(4);
        this.culture = eMFInputStream.readDWORD();
        this.panose = new Panose(eMFInputStream);
        eMFInputStream.readWORD();
    }

    public void write(EMFOutputStream eMFOutputStream) throws IOException {
        this.font.write(eMFOutputStream);
        eMFOutputStream.writeWCHAR(this.fullName, 64);
        eMFOutputStream.writeWCHAR(this.style, 32);
        eMFOutputStream.writeDWORD(this.version);
        eMFOutputStream.writeDWORD(this.styleSize);
        eMFOutputStream.writeDWORD(this.match);
        eMFOutputStream.writeDWORD(0);
        eMFOutputStream.writeBYTE(this.vendorID);
        eMFOutputStream.writeDWORD(this.culture);
        this.panose.write(eMFOutputStream);
        eMFOutputStream.writeWORD(0);
    }

    public String toString() {
        return super.toString() + "\n" + "  LogFontW\n" + this.font.toString() + "\n" + "    fullname: " + this.fullName + "\n" + "    style: " + this.style + "\n" + "    version: " + this.version + "\n" + "    stylesize: " + this.styleSize + "\n" + "    match: " + this.match + "\n" + "    vendorID: " + this.vendorID + "\n" + "    culture: " + this.culture + "\n" + this.panose.toString();
    }
}

