/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Stack;
import org.freehep.graphicsio.QuadToCubicPathConstructor;

public abstract class CubicToLinePathConstructor
extends QuadToCubicPathConstructor {
    private double resolution;

    protected CubicToLinePathConstructor() {
        this(0.025);
    }

    protected CubicToLinePathConstructor(double d2) {
        this.resolution = Math.abs(d2);
    }

    public void cubic(double d2, double d3, double d4, double d5, double d6, double d7) throws IOException {
        Object object;
        Stack<Object> stack = new Stack<Object>();
        Point2D.Double double_ = new Point2D.Double(this.currentX, this.currentY);
        Point2D.Double double_2 = new Point2D.Double(d2, d3);
        Point2D.Double double_3 = new Point2D.Double(d4, d5);
        Point2D.Double double_4 = new Point2D.Double(d6, d7);
        Stack<Object> stack2 = new Stack<Object>();
        stack2.push(new ControlSet(double_, double_2, double_3, double_4));
        while (!stack2.empty()) {
            object = (ControlSet)stack2.pop();
            if (((ControlSet)object).breadth() > this.resolution) {
                stack2.push(object);
                stack2.push(((ControlSet)object).bisect());
                continue;
            }
            stack.push(object);
        }
        while (!stack.empty()) {
            object = ((ControlSet)stack.pop()).getPoint();
            this.line(((Point2D)object).getX(), ((Point2D)object).getY());
        }
        super.cubic(d2, d3, d4, d5, d6, d7);
    }

    class ControlSet {
        private Point2D point0;
        private Point2D point1;
        private Point2D point2;
        private Point2D point3;

        public ControlSet(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
            this.point0 = point2D;
            this.point1 = point2D2;
            this.point2 = point2D3;
            this.point3 = point2D4;
        }

        public double breadth() {
            double d2 = this.point0.getX();
            double d3 = this.point0.getY();
            double d4 = this.point1.getX();
            double d5 = this.point1.getY();
            double d6 = this.point2.getX();
            double d7 = this.point2.getY();
            double d8 = this.point3.getX();
            double d9 = this.point3.getY();
            if (Math.abs(d2 - d8) < CubicToLinePathConstructor.this.resolution && Math.abs(d3 - d9) < CubicToLinePathConstructor.this.resolution) {
                double d10 = Math.abs(d4 - d2) + Math.abs(d5 - d3);
                double d11 = Math.abs(d6 - d2) + Math.abs(d7 - d3);
                return Math.max(d11, d10);
            }
            double d12 = d3 - d9;
            double d13 = d8 - d2;
            double d14 = Math.sqrt(d12 * d12 + d13 * d13);
            double d15 = d8 * d3 - d2 * d9;
            double d16 = Math.abs(d12 * d6 + d13 * d7 - d15) / d14;
            double d17 = Math.abs(d12 * d4 + d13 * d5 - d15) / d14;
            return Math.max(d16, d17);
        }

        public ControlSet bisect() {
            Point2D point2D = this.average(this.point0, this.point1);
            Point2D point2D2 = this.average(this.point1, this.point2);
            Point2D point2D3 = this.average(this.point2, this.point3);
            Point2D point2D4 = this.average(point2D, point2D2);
            Point2D point2D5 = this.average(point2D2, point2D3);
            Point2D point2D6 = this.average(point2D4, point2D5);
            ControlSet controlSet = new ControlSet(point2D6, point2D5, point2D3, this.point3);
            this.point1 = point2D;
            this.point2 = point2D4;
            this.point3 = point2D6;
            return controlSet;
        }

        public Point2D average(Point2D point2D, Point2D point2D2) {
            return new Point2D.Double((point2D.getX() + point2D2.getX()) / 2.0, (point2D.getY() + point2D2.getY()) / 2.0);
        }

        public Point2D getPoint() {
            return this.point3;
        }
    }
}

