(require 'sgml-mode)
(defconst phtml-font-lock-keywords nil)
; use defconst since we need to initialize it unconditionally
(defconst phtml-font-lock-keywords
    (append (list
	     '("^[ \t]*\\(!!\\|#\\).*$" . font-lock-comment-face) ; !! style comments
	     '("^[ \t]*!.*$" . font-lock-string-face) ; wims commands
	     '("^[ \t]*\\(![ls]et[ \t]*\\)?\\([A-za-z_0-9()\\$]+\\)[ \t]*=.*$"  ; assignments
	      . '((0 font-lock-string-face nil nil) (2 font-lock-variable-name-face t nil)))
	     '("\\(^\\|[^!]\\)\\(![a-z]+\\)" . (2 font-lock-keyword-face t nil)) ; command keywords
	     '("\\$\\([A-Za-z_0-9]+\\|([^)]*)\\|\\[[^]]*\\]\\)" . (0 font-lock-type-face t nil)) ; variables
	     (cons
	      (eval-when-compile
		(concat "\\<"
			(regexp-opt
			 '("and" "or" "chars" "items" "words" "lines" "char" "item" "word" "line"
			   "of" "into" "between" "by" "in" "to" "step" "iswordof" "notwordof"
			   "isvarof" "notvarof" "isvariableof" "notvariableof" "isitemof" "notitemdof"
			   "islineof" "notlinedof" "isin" "notin") t)
			"\\>"))
	      '(0 font-lock-keyword-face t nil))) ; misc keywords
	    sgml-font-lock-keywords))

(defun phtml-indent-line ()
  (interactive)
  (let ((indent 0))
    ;; first look in the last line
    (save-excursion
      (beginning-of-line)
      (if (re-search-backward "^[^\n]" nil t) ; return to last line
	  (let ((end (save-excursion (forward-line 1) (point))))
	    (skip-chars-forward " \t" end)
	    (setq indent (current-column))
	    (if (looking-at "!\\([a-z]+\\)") ; found a command!
		(let ((cmd (match-string 1)))
		  (if (string-match
		       (eval-when-compile
			 (concat "^" (regexp-opt '("if" "ifval" "for" "else") t) "$"))
		       cmd)
		      (setq indent (+ indent 4))))))))
    (save-excursion
      (beginning-of-line)
      (if (looking-at "[ \t]*!\\([a-z]+\\)") ; This line contains a command!
	  (let ((cmd (match-string 1)))
	    (if (string-match
		 (eval-when-compile
		   (concat "^" (regexp-opt '("else" "endif" "next") t) "$"))
		cmd)
	    (setq indent (- indent 4))))))
    (if (< indent 0) (setq indent 0))
    (let ((opoint (point-marker)))
      (beginning-of-line)
      (delete-region (point) (progn (skip-chars-forward " \t") (point)))
      (indent-to indent 0)
      (if (> opoint (point))
	  (goto-char opoint))
      (move-marker opoint nil))))


(define-derived-mode phtml-mode html-mode "WimsPhtml"
  "Major mode for Wims Programmable HTML.
\\{phtml-mode-map}"
  (make-local-variable 'indent-line-function)
  (setq indent-line-function 'phtml-indent-line)
  (make-local-variable 'font-lock-defaults)
  (setq font-lock-defaults
	'((phtml-font-lock-keywords)
	  t
	  nil)))

(define-key phtml-mode-map "\t" 'phtml-indent-line)
(define-key phtml-mode-map "\xd" 'reindent-then-newline-and-indent)
(provide 'phtml-mode)



