/**
 * Fonction.java
 *
 * Created on Jul 2, 2006
 */
package maths;

/**
 * Cette interface represente une fonction complexe avec des valeurs entiers
 * avec un parametre complexe et un parametre entier. Utilisee pour representer des
 * ensembles / fonctions definies sur le plan.
 *
 * @author Nicolae
 */
public interface Fonction {
	
	/**
	 * Etablit les valeurs des deux parametres : un complexe et l'autre entier.
	 *
	 * @param re partie reele du parametre complexe.
	 * @param im partie imaginaire du parametre complexe.
	 * @param n le parametre entier.
	 */
	public void setPar(double re, double im, int n);	
	
	/**
	 * Renvoie la valeur entiere de la fonction en <code>z = x + iy</code>.
	 *
	 * @param x partie reele du point.
	 * @param y partie imaginaire du point.
	 * @return la valeur de la fonction.
	 */
	public int getVal(double x, double y);
}
