/*
 * OutputApp.h
 *
 * Copyright (C) 2003 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _OUTPUT_APP_H
#define _OUTPUT_APP_H

extern bool parseCommandlineArgumentOutput(int & i,int argc, char** argv);

class OutputApp {
public:
                        OutputApp();

    bool                GetKeepURLs() const { return _keepURLs; }        
    void		SetKeepURLs(bool flag) { _keepURLs = flag; }

    void                SetIndent(int value) {_indent = value;}
    int    	        GetIndent(void) {return _indent;}

    void                SetFloatDigits(int value);
    int    	        GetFloatDigits(void) {return _floatDigits;}


    bool                GetIncludeProtos() const { return _includeProtos; }
    void		SetIncludeProtos(bool flag) { _includeProtos = flag; }

    bool                GetkrFormating() const { return _krFormating; }
    void		SetkrFormating(bool flag) { _krFormating = flag; }

    bool                GetCompress() const { return _compress; }
    void		SetCompress(bool flag) { _compress = flag; }

    void		OutputSetDefaults();

    void                OutputLoadPreferences();
    void                OutputSavePreferences();


private:
    bool                _keepURLs;
    int                 _indent;
    int                 _floatDigits;
    bool                _krFormating;
    bool                _includeProtos;
    bool                _compress;    
};

#endif

