/*
 * NodeMovieTexture.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "NodeMovieTexture.h"
#include "Proto.h"
#include "FieldValue.h"
#include "SFBool.h"
#include "SFFloat.h"
#include "SFTime.h"
#include "MFString.h"
#include "Field.h"	    // for FF_URL
#include "ExposedField.h"

ProtoMovieTexture::ProtoMovieTexture(Scene *scene)
  : Proto(scene, "MovieTexture")
{
    loop.set(
          addExposedField(SFBOOL, "loop", new SFBool(false)));
    speed.set(
          addExposedField(SFFLOAT, "speed", new SFFloat(1.0f)));

    ExposedField* start = new 
                          ExposedField(SFTIME, "startTime", new SFTime(0.0)); 
    start->setFlags(EIF_RECOMMENDED);
    startTime.set(addExposedField(start));

    ExposedField* stop = new
                         ExposedField(SFTIME, "stopTime", new SFTime(0.0));
    stop->setFlags(EIF_RECOMMENDED);
    stopTime.set(addExposedField(stop));

    url.set(
          addExposedField(MFSTRING, "url", new MFString(), FF_URL, NULL));
    repeatS.set(
          addField(SFBOOL, "repeatS", new SFBool(true)));
    repeatT.set(
          addField(SFBOOL, "repeatT", new SFBool(true)));
    addEventOut(SFTIME, "duration_changed");
    addEventOut(SFBOOL, "isActive");
}

Node *
ProtoMovieTexture::create(Scene *scene)
{ 
    return new NodeMovieTexture(scene, this);
}

NodeMovieTexture::NodeMovieTexture(Scene *scene, Proto *def)
  : Node(scene, def)
{
}

