/*
 * NodeGroup.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_GROUP_H
#define _NODE_GROUP_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif

#include "SFMFTypes.h"

class NodeNurbsGroup;

class ProtoGroup : public Proto {
public:
		    ProtoGroup(Scene *scene);
		    ProtoGroup(Scene *scene, const char *name);
    virtual Node   *create(Scene *scene);

    void	    addElements(void);

    FieldIndex children;
    FieldIndex bboxCenter;
    FieldIndex bboxSize;
};

class NodeGroup : public Node {
public:
		    NodeGroup(Scene *scene, Proto *proto);
		    NodeGroup(NodeNurbsGroup *nurbsGroup);

    virtual int	    getType() const { return NODE_GROUP; }
    virtual Node   *copy() const { return new NodeGroup(*this); }
    virtual int	    getNodeClass() const { return CHILD_NODE; }

    virtual int     countPolygons(void);
    virtual int     countPrimitives(void);

    virtual void    flip(int index);

    virtual void    preDraw();
    virtual void    draw();

    fieldMacros(MFNode,  children,   ProtoGroup)
    fieldMacros(SFVec3f, bboxCenter, ProtoGroup)
    fieldMacros(SFVec3f, bboxSize,   ProtoGroup)

};

#endif // _NODE_GROUP_H
