#!/bin/sh
#set -x

OS=`sw_vers | awk '/ProductVersion:/ {split($2,a,".");print a[1] "." a[2]}'`

if test "$OS" = "10.3" ; then
   OS="Panther"
fi

if test "$OS" = "10.2" ; then
   OS="Jaguar"
fi

VERSION=`sh ../../batch/getversion.sh`
MAYOR=`awk -v version=$VERSION -v col=pl 'BEGIN {split(version,a,col);print a[1]}'`
rm -rf /tmp/white_dune-$VERSION
(cd ../../.. && cp -r white_dune-$VERSION /tmp) && \
cd /tmp/white_dune-$VERSION && make realclean && \
./configure --with-optimization --with-buginlesstif --without-devil --with-helpurl="http://www.csv.ica.uni-stuttgart.de/vrml/dune/docs/index.html" && make &&
rm -f desktop/macosx/white_dune.app/Contents/MacOS/dune &&
cp bin/dune desktop/macosx/white_dune.app/Contents/MacOS &&
strip desktop/macosx/white_dune.app/Contents/MacOS/dune &&
batch/repair_apple_bugs.sh &&
chmod +x desktop/macosx/white_dune.app/Contents/MacOS/*dune* &&
awk -v mayor=$MAYOR '{sub("<string>0.27</string>","<string>" mayor "</string>");print $0}' \
     desktop/macosx/white_dune.app/Contents/Info.plist > /tmp/$$_Info.plist &&
cp /tmp/$$_Info.plist desktop/macosx/white_dune.app/Contents/Info.plist &&
rm /tmp/$$_Info.plist &&
cp -r docs desktop/macosx/white_dune.app/Contents/Resources/WhiteDuneHelp &&
cd desktop/macosx && 
tar -cf /tmp/white_dune-MacOSX-$OS-$VERSION.tar white_dune.app && 
gzip -9f /tmp/white_dune-MacOSX-$OS-$VERSION.tar &&
echo stuffit expander compatible archive is /tmp/white_dune-MacOSX-$OS-$VERSION.tar.gz 

