/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

using namespace std;

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>

#include "output_common.h"


string
wf_shell_comment(const string& comment, int indent_level) {
  string str;
  if (comment.empty())
    return str;

  unsigned int pos, oldpos = 0;
  do {
    pos = comment.find('\n', oldpos);
    for (int i = 0; i < indent_level; i++)
      str += "  ";
    str += "# " + comment.substr(oldpos, pos - oldpos) + '\n';
    oldpos = pos + 1;
  } while (pos != string::npos);

  return str;
}

/* RV@@2 test
   cout << '[' << wf_shell_comment("coin") << ']' << endl;
   cout << '[' << wf_shell_comment("coin\nzap") << ']' << endl;
   cout << '[' << wf_shell_comment("coin\nzap\n") << ']' << endl;
   cout << '[' << wf_shell_comment("coin\nzap\n\n\n") << ']' << endl;
*/
