#!/bin/sh

# realign one or more time series volumes to a specific reference
# image using SPM8


# some defaults
MATLABPATH=/usr/local/spm8
SPM8_MATLAB_CMD="/usr/local/bin/matlab2009b -nodesktop -nosplash -nojvm"
REF='ref.nii'
INFILE='data.nii'
OUTFILE=

printhelp() {
  echo "  "
  echo "VoxBo spm8_realign script"
  echo "summary: script for realigning using SPM8"
  echo "usage:"
  echo "  spm8_realign <flags>"
  echo "the following flags are honored:"
  echo "  -i <name>   file to realign"
  echo "  -r <name>   3D ref volume"
  echo "  -o <name>   set output file name (default: r is prepended)"
  echo "  -h          print this help"
  echo "  "
}

if [[ $# -lt 3 ]] ; then
  printhelp;
  exit;
fi

while getopts ho:i:r: opt; do
  case "$opt" in
    h) printhelp; exit;  ;;
    i) INFILE=$OPTARG ;;
    r) REF=$OPTARG ;;
    o) OUTFILE=$OPTARG ;;
    \\?) echo "argh!" ;;
  esac
done

DIR=`dirname $INFILE`
FNAME=`basename $INFILE`

echo "+------------------------------+"
echo "| SPM8 realignment bash script |"
echo "+------------------------------+"
echo "    ref: " $REF
if [[ -n $OUTFILE ]] ; then
  echo "outfile: " $OUTFILE
else
  echo "outfile: " $DIR/r$FNAME
fi

$SPM8_MATLAB_CMD << EOF
spm_defaults;
global defaults;
cd $DIR

rflags1.quality = 1;
rflags1.weight = {''};
rflags1.interp = 2;
rflags1.wrap   = [0 0 0];
rflags1.sep    = 4;
rflags1.fwhm   = 5;
rflags1.rtm    = 0;
rflags2.prefix   = 'r';
rflags2.mask      = 1;
rflags2.interp    = 4;
rflags2.wrap      = [0 0 0];
rflags2.which     = 2;

refplus=strvcat('$REF','$FNAME');
spm_realign(refplus,rflags1)
spm_reslice('$FNAME',rflags2)
exit
EOF

echo

if [[ ! -f $DIR/r$FNAME ]] ; then exit 1 ; fi

if [[ -n $OUTFILE ]] ; then
  mv $DIR/r$FNAME $DIR/$OUTFILE
fi

exit 0
