#!/usr/bin/env python
"""
Plot function defined on numpy meshgrid using viper.
This demo requires scikits.delaunay. To install:
svn co http://svn.scipy.org/svn/scikits/trunk/delaunay
(sudo) python setup.py install (--prefix=some/other/place)
"""

__copyright__ = "(C) 2008 Rolv Erlend Bredesen and Simula Research Laboratory"
__author__ = 'Rolv Erlend Bredesen <rolv@simula.no>'
__date__ = '2008.11.12'
__license__ = 'GNU LGPL Version 2.1.'


import numpy as N
from scikits.delaunay import Triangulation # deb: python-scikits-delaunay
import viper

from scipy.special import j0
x0 = y0 = -10
dx = dy = 0.25
ny = 80; nx = 40

x = x0 + dx * N.arange(nx)
y = y0 + dy * N.arange(ny)
u0 = j0(N.sqrt(x**2+y[:,None]**2))

X, Y = N.meshgrid(x, y) # shape is ny, nx

coordinates = N.array(N.vstack((X.flat, Y.flat, N.zeros(X.size))).T)
cells = Triangulation(X.flat, Y.flat).triangle_nodes
data = N.array(u0.flat)

v = viper.Viper(coordinates=coordinates,
               cells=cells,
               x=data,
               warpscalar=True)

v.azimuth(10)
v.elevate(-40)
v.ren.ResetCamera()

step = 0.2
Nperiods = 10
for scale in N.sin(N.arange(N.pi*0.5, Nperiods*N.pi, step)):
   data[:] = u0.flat*scale
   v.update()

#v.interactive()
