/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 1.0.4
 * December 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef FILEICONDIALOG_H
#define FILEICONDIALOG_H
#include <vdk/forms.h>
#include <vdk/vdkstring.h>
#include <vdk/gtkiconfilesel.h>
/*!
  \class VDKFileIconDialog
  \brief Provides a file dialog with file icons
  \par Usage:
  \code
  VDKString selection;
  VDKFileIconDialog* dlg = new VDKFileIconDialog(
                             this,
			     &selection,
			     "title"
			     );
  dlg->ShowModal();
  printf("\nfile selection:%s",
                     !selection.isNull() ?
		     (char*) selection :
		     "nihil");
  fflush(stdout);
  \endcode
 */
class VDKFileIconDialog: public VDKForm
{
    static void ok_or_cancel_clicked(GtkWidget *widget, gpointer data);
 protected:
  VDKString *selection;
 public:
  VDKFileIconDialog(VDKForm* owner,
		VDKString* selection,
		char* title = "");
  virtual ~VDKFileIconDialog();
  virtual bool CanClose();
  virtual void Setup(void);
};

#endif
