/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/


#include "vdk/slider.h"
#include "vdk/forms.h"

/*
the signal sender
is the adjustment inside scale widget.
 */
void VDKSlider::ValueChanged(GtkWidget *wid, gpointer gp)
{
  g_return_if_fail(wid != NULL);
  g_return_if_fail(gp != NULL);
  VDKSlider* obj = reinterpret_cast<VDKSlider*> (gp);
  obj->Value(GTK_ADJUSTMENT(wid)->value);
  obj->SignalEmit(value_changed_signal);
#ifdef USE_SIGCPLUSPLUS
     obj->OnSliderValueChanged(obj, obj->Value);
#endif /* USE_SIGCPLUSPLUS */
}

VDKSlider::VDKSlider(VDKForm* owner,
		     float defValue,
		     float lower,
		     float upper,
		     float step,
		     int mode,
		     int w,
		     int h):
  VDKObject(owner),
  Value("Value",this,defValue,&VDKSlider::SetValue),
  Digits("Digits",this,1,&VDKSlider::SetDigits),
  UpdatePolicy("UpdatePolicy",this,update_discontinuos,
	       &VDKSlider::SetUpdatePolicy),
  LowerBound("LowerBound",this,lower,&VDKSlider::SetLowerBound,
	     &VDKSlider::GetLowerBound),
  UpperBound("UpperBound",this,lower,&VDKSlider::SetUpperBound,
	     &VDKSlider::GetUpperBound),
  Step("Step",this,step, &VDKSlider::SetStep, &VDKSlider::GetStep)
{
  adj = gtk_adjustment_new (defValue, lower, upper+step, step, step, step);
  widget = mode == h_box ? 
    gtk_hscale_new (GTK_ADJUSTMENT (adj)) :
    gtk_vscale_new (GTK_ADJUSTMENT (adj)); 
  gtk_widget_set_size_request (GTK_WIDGET (widget), w, h);
  gtk_range_set_update_policy (GTK_RANGE (widget), 
			       (GtkUpdateType) update_discontinuos);
  gtk_scale_set_digits (GTK_SCALE (widget), 1);
  gtk_scale_set_draw_value (GTK_SCALE (widget), TRUE);
  gtk_signal_connect(adj,"value_changed",
		     GTK_SIGNAL_FUNC(VDKSlider::ValueChanged), 
		     (gpointer) this);
  ConnectDefaultSignals();
}
 

VDKSlider::~VDKSlider()
{
} 


void 
VDKSlider::SetValue(float f)
{
  /*
GtkWidget* widget = WrappedWidget();
GtkRange* range = &(GTK_SCALE(widget)->range);
GtkAdjustment* adj = gtk_range_get_adjustment(range);
  */
// setting value
gtk_adjustment_set_value(GTK_ADJUSTMENT(adj),f);
Value(f); 
}

float 
VDKSlider::GetStep(void)
{
  return  GTK_ADJUSTMENT(adj)->step_increment;
}

void 
VDKSlider::SetStep(float f)
{
  GTK_ADJUSTMENT(adj)->step_increment = f;
}

float 
VDKSlider::GetLowerBound(void)
{
  return GTK_ADJUSTMENT(adj)->lower;
}

void 
VDKSlider::SetLowerBound(float f)
{
  GTK_ADJUSTMENT(adj)->lower = f;
}

float 
VDKSlider::GetUpperBound(void)
{
  return GTK_ADJUSTMENT(adj)->upper;
}

void 
VDKSlider::SetUpperBound(float f)
{
  GTK_ADJUSTMENT(adj)->upper = f;
}
