// The UMLet source code is distributed under the terms of the GPL; see license.txt
package com.umlet.element.custom;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

import com.umlet.constants.Constants;
import com.umlet.element.base.Entity;

@SuppressWarnings("serial")
public class RegionEndState extends Entity {

	@Override
	public void paintEntity(Graphics g) {
		Graphics2D g2 = (Graphics2D) g;
		g2.setFont(this.getHandler().getZoomedFont());
		colorize(g2); // enable colors
		g2.setColor(activeColor);
		Constants.getFRC(g2);

		g2.drawOval(0, 0, this.getWidth() - 1, this.getHeight() - 1);
		AffineTransform at = g2.getTransform();
		AffineTransform at2 = (AffineTransform) at.clone();
		at2.rotate(Math.toRadians(45), getWidth() / 2, getHeight() / 2);
		g2.setTransform(at2);
		g2.drawLine(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
		g2.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight());
		g2.setTransform(at);

	}

	@Override
	public int getPossibleResizeDirections() {
		return 0;
	} // deny size changes
}
