/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */


// UgDataset : collection of all UgData-based instance.

#ifndef UG_DATASET_H
#define UG_DATASET_H

#include <glib.h>
#include <ug_data.h>

#ifdef __cplusplus
extern "C" {
#endif

#define	UG_DATASET_COMMON(dataset)			( (UgDataCommon*) ((dataset)->pair[0].value) )
#define	UG_DATASET_PROXY(dataset)			( (UgDataProxy*)  ((dataset)->pair[1].value) )
#define	UG_DATASET_PROGRESS(dataset)		( (UgProgress*)   ((dataset)->pair[2].value) )
#define	UG_DATASET_APP(dataset)				( (UgDataApp*)    ((dataset)->pair[3].value) )
#define	UG_DATASET_APP_CLASS(dataset)		( (dataset)->pair[3].key )

typedef struct	UgDataset_			UgDataset;		// collection of all UgData-based instance.
typedef struct	UgDataPair_			UgDataPair;		// UgDataClass and UgData pair

// GDestroyNotify
typedef void	(*UgDestroyFunc)	(gpointer user_data);

extern	const	UgDataClass*		UgDatasetClass;

// ----------------------------------------------------------------------------
// UgDataPair : a pair for UgDataClass and it's instance.
struct UgDataPair_
{
	const UgDataClass*	key;
	UgData*				value;
};

// ----------------------------------------------------------------------------
// UgDataset : collection of all UgData-based instance.
struct UgDataset_
{
	UG_DATA_MEMBERS (UgDataset);
//	const UgDataClass*	data_class;
//	UgDataset*			next;
//	UgDataset*			prev;

	// protected --------------------------------
//	struct Protected {
	UgDataPair*		pair;
	guint			pair_len;
	guint			pair_alloc_len;
//	} protected;

	// public, but can't copy -------------------
	UgDestroyFunc	destroy_func;
	gpointer		destroy_data;
	gpointer		user_data;
};

// Gets the element at the given position in a list.
gpointer	ug_dataset_get	(UgDataset* dataset, const UgDataClass* data_class, guint nth);

// Removes the element at the given position in a list.
void		ug_dataset_remove (UgDataset* dataset, const UgDataClass* data_class, guint nth);

// If nth instance of data_class exist, return nth instance.
// If nth instance of data_class not exist, alloc new instance in tail and return it.
gpointer	ug_dataset_realloc (UgDataset* dataset, const UgDataClass* data_class, guint nth);

gpointer	ug_dataset_alloc_front (UgDataset* dataset, const UgDataClass* data_class);
gpointer	ug_dataset_alloc_back  (UgDataset* dataset, const UgDataClass* data_class);

// ----------------------------------------------
// UgDataset list functions
guint		ug_dataset_list_length (UgDataset* dataset, const UgDataClass* data_class);

UgData**	ug_dataset_alloc_list (UgDataset* dataset, const UgDataClass* data_class);

UgData**	ug_dataset_get_list (UgDataset* dataset, const UgDataClass* data_class);

// free old list in dataset and set list with new_list.
void		ug_dataset_set_list (UgDataset* dataset, const UgDataClass* data_class, gpointer new_list);

// free old list in dataset and copy src_list to dataset.
void		ug_dataset_copy_list (UgDataset* dataset, const UgDataClass* data_class, gpointer src_list);

// Cuts the element at the given position in a list.
gpointer	ug_dataset_cut_list (UgDataset* dataset, const UgDataClass* data_class, guint nth);

// ----------------------------------------------
// for backward compatible
extern	GMarkupParser	ug_dataset_parser;
void	ug_dataset_in_markup (UgDataset** dataset, GMarkupParseContext* context);
void	ug_dataset_to_markup (UgDataset** dataset, UgMarkup* markup);


#ifdef __cplusplus
}
#endif

#endif  // End of UG_DATASET_H

