/* rygel-media-export-media-cache.c generated by valac, the Vala compiler
 * generated from rygel-media-export-media-cache.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <gio/gio.h>
#include <rygel.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_MEDIA_DB_OBJECT_TYPE (rygel_media_db_object_type_get_type ())

#define RYGEL_TYPE_MEDIA_EXPORT_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_EXPORT_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_EXPORT_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_IS_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_EXPORT_MEDIA_CACHE))
#define RYGEL_IS_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_EXPORT_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_EXPORT_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;
typedef struct _RygelMediaExportMediaCachePrivate RygelMediaExportMediaCachePrivate;

#define RYGEL_TYPE_MEDIA_EXPORT_DATABASE (rygel_media_export_database_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_EXPORT_DATABASE, RygelMediaExportDatabase))
#define RYGEL_MEDIA_EXPORT_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_EXPORT_DATABASE, RygelMediaExportDatabaseClass))
#define RYGEL_IS_MEDIA_EXPORT_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_EXPORT_DATABASE))
#define RYGEL_IS_MEDIA_EXPORT_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_EXPORT_DATABASE))
#define RYGEL_MEDIA_EXPORT_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_EXPORT_DATABASE, RygelMediaExportDatabaseClass))

typedef struct _RygelMediaExportDatabase RygelMediaExportDatabase;
typedef struct _RygelMediaExportDatabaseClass RygelMediaExportDatabaseClass;

#define RYGEL_TYPE_MEDIA_EXPORT_DB_OBJECT_FACTORY (rygel_media_export_db_object_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_EXPORT_DB_OBJECT_FACTORY, RygelMediaExportDBObjectFactory))
#define RYGEL_MEDIA_EXPORT_DB_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_EXPORT_DB_OBJECT_FACTORY, RygelMediaExportDBObjectFactoryClass))
#define RYGEL_IS_MEDIA_EXPORT_DB_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_EXPORT_DB_OBJECT_FACTORY))
#define RYGEL_IS_MEDIA_EXPORT_DB_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_EXPORT_DB_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_DB_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_EXPORT_DB_OBJECT_FACTORY, RygelMediaExportDBObjectFactoryClass))

typedef struct _RygelMediaExportDBObjectFactory RygelMediaExportDBObjectFactory;
typedef struct _RygelMediaExportDBObjectFactoryClass RygelMediaExportDBObjectFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _Block6Data Block6Data;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;

typedef enum  {
	RYGEL_MEDIA_DB_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_DB_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_DB_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_DB_ERROR_UNSUPPORTED
} RygelMediaDBError;
#define RYGEL_MEDIA_DB_ERROR rygel_media_db_error_quark ()
typedef enum  {
	RYGEL_MEDIA_DB_OBJECT_TYPE_CONTAINER,
	RYGEL_MEDIA_DB_OBJECT_TYPE_ITEM
} RygelMediaDBObjectType;

struct _RygelMediaExportMediaCache {
	GObject parent_instance;
	RygelMediaExportMediaCachePrivate * priv;
};

struct _RygelMediaExportMediaCacheClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportMediaCachePrivate {
	RygelMediaExportDatabase* db;
	RygelMediaExportDBObjectFactory* factory;
};

typedef gboolean (*RygelMediaExportDatabaseRowCallback) (sqlite3_stmt* stmt, void* user_data);
typedef enum  {
	RYGEL_DATABASE_ERROR_IO_ERROR,
	RYGEL_DATABASE_ERROR_SQLITE_ERROR
} RygelDatabaseError;
#define RYGEL_DATABASE_ERROR rygel_database_error_quark ()
struct _Block1Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	RygelMediaObject* parent;
};

struct _Block2Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	gint count;
};

struct _Block3Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	gboolean exists;
	gint64 tmp_timestamp;
};

struct _Block4Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	GeeArrayList* children;
	RygelMediaContainer* parent;
};

struct _Block5Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	GeeArrayList* children;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	gboolean schema_ok;
};

struct _Block8Data {
	int _ref_count_;
	Block6Data * _data6_;
	gint rows;
};

struct _Block6Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	gint old_version;
};

struct _Block9Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	GeeQueue* queue;
};

struct _Block10Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	RygelMediaObject* object;
};

struct _Block11Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	GeeArrayList* children;
};

struct _Block12Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	GeeArrayList* data;
};


static gpointer rygel_media_export_media_cache_parent_class = NULL;

GQuark rygel_media_db_error_quark (void);
GType rygel_media_db_object_type_get_type (void);
GType rygel_media_export_media_cache_get_type (void);
GType rygel_media_export_database_get_type (void);
GType rygel_media_export_db_object_factory_get_type (void);
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_EXPORT_MEDIA_CACHE, RygelMediaExportMediaCachePrivate))
enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_schema_version "5"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_META_DATA_TABLE_STRING "CREATE TABLE meta_data (size INTEGER NOT NULL, " "mime_type TEXT NOT NULL, " "duration INTEGER, " "width INTEGER, " "height INTEGER, " "class TEXT NOT NULL, " "author TEXT, " "album TEXT, " "date TEXT, " "bitrate INTEGER, " "sample_freq INTEGER, " "bits_per_sample INTEGER, " "channels INTEGER, " "track INTEGER, " "color_depth INTEGER, " "object_fk TEXT UNIQUE CONSTRAINT " "object_fk_id REFERENCES Object(upnp_id) " "ON DELETE CASCADE);"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_SCHEMA_STRING "CREATE TABLE schema_info (version TEXT NOT NULL); " "CREATE TABLE object_type (id INTEGER PRIMARY KEY, " "desc TEXT NOT NULL);" RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_META_DATA_TABLE_STRING "CREATE TABLE object (parent TEXT CONSTRAINT parent_fk_id " "REFERENCES Object(upnp_id), " "upnp_id TEXT PRIMARY KEY, " "type_fk INTEGER CONSTRAINT type_fk_id " "REFERENCES Object_Type(id), " "title TEXT NOT NULL, " "timestamp INTEGER NOT NULL);" "CREATE TABLE uri (object_fk TEXT " "CONSTRAINT object_fk_id REFERENCES Object(upnp_id) " "ON DELETE CASCADE, " "uri TEXT NOT NULL);" "INSERT INTO object_type (id, desc) VALUES (0, 'Container'); " "INSERT INTO object_type (id, desc) VALUES (1, 'Item'); " "INSERT INTO schema_info (version) VALUES ('" RYGEL_MEDIA_EXPORT_MEDIA_CACHE_schema_version "'); "
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_CLOSURE_TABLE "CREATE TABLE closure (ancestor TEXT, descendant TEXT, depth INTEGER)"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_CLOSURE_TRIGGER_STRING "CREATE TRIGGER trgr_update_closure " "AFTER INSERT ON Object " "FOR EACH ROW BEGIN " "INSERT INTO Closure (ancestor, descendant, depth) " "VALUES (NEW.upnp_id, NEW.upnp_id, 0); " "INSERT INTO Closure (ancestor, descendant, depth) " "SELECT ancestor, NEW.upnp_id, depth + 1 FROM Closure " "WHERE descendant = NEW.parent;" "END;" "CREATE TRIGGER trgr_delete_closure " "AFTER DELETE ON Object " "FOR EACH ROW BEGIN " "DELETE FROM Closure WHERE descendant = OLD.upnp_id;" "END;"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_TRIGGER_STRING "CREATE TRIGGER trgr_delete_metadata " "BEFORE DELETE ON Object " "FOR EACH ROW BEGIN " "DELETE FROM meta_data WHERE meta_data.object_fk = OLD.upnp_id; " "END;" "CREATE TRIGGER trgr_delete_uris " "BEFORE DELETE ON Object " "FOR EACH ROW BEGIN " "DELETE FROM Uri WHERE Uri.object_fk = OLD.upnp_id;" "END;"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_INDICES_STRING "CREATE INDEX idx_parent on Object(parent);" "CREATE INDEX idx_uri_fk on Uri(object_fk);" "CREATE INDEX idx_meta_data_fk on meta_data(object_fk);" "CREATE INDEX idx_closure on Closure(descendant,depth);"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_SAVE_META_DATA_STRING "INSERT OR REPLACE INTO meta_data " "(size, mime_type, width, height, class, " "author, album, date, bitrate, " "sample_freq, bits_per_sample, channels, " "track, color_depth, duration, object_fk) VALUES " "(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_INSERT_OBJECT_STRING "INSERT INTO Object (upnp_id, title, type_fk, parent, timestamp) " "VALUES (?,?,?,?,?)"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPDATE_OBJECT_STRING "UPDATE Object SET title = ?, timestamp = ? WHERE upnp_id = ?"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_INSERT_URI_STRING "INSERT INTO Uri (object_fk, uri) VALUES (?,?)"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_DELETE_URI_STRING "DELETE FROM Uri WHERE object_fk = ?"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_DELETE_BY_ID_STRING "DELETE FROM Object WHERE upnp_id IN " "(SELECT descendant FROM closure WHERE ancestor = ?)"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_OBJECT_WITH_PATH "SELECT o.type_fk, o.title, m.size, m.mime_type, m.width, m.height, " "m.class, m.author, m.album, m.date, m.bitrate, m.sample_freq, " "m.bits_per_sample, m.channels, m.track, m.color_depth, " "m.duration, o.parent, o.upnp_id " "FROM Object o " "JOIN Closure c ON (o.upnp_id = c.ancestor) " "LEFT OUTER JOIN meta_data m ON (o.upnp_id = m.object_fk) " "WHERE c.descendant = ? ORDER BY c.depth DESC"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CHILDREN_STRING "SELECT o.type_fk, o.title, m.size, m.mime_type, " "m.width, m.height, m.class, m.author, m.album, " "m.date, m.bitrate, m.sample_freq, m.bits_per_sample, " "m.channels, m.track, m.color_depth, m.duration, " "o.upnp_id, o.parent, o.timestamp " "FROM Object o LEFT OUTER JOIN meta_data m " "ON o.upnp_id = m.object_fk " "WHERE o.parent = ? " "ORDER BY o.type_fk ASC, " "m.class ASC, " "m.track ASC, " "o.title ASC " "LIMIT ?,?"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_OBJECTS_BY_FILTER_STRING "SELECT DISTINCT o.type_fk, o.title, m.size, m.mime_type, " "m.width, m.height, m.class, m.author, m.album, " "m.date, m.bitrate, m.sample_freq, m.bits_per_sample, " "m.channels, m.track, m.color_depth, m.duration, " "o.upnp_id, o.parent, o.timestamp " "FROM Object o " "JOIN Closure c ON o.upnp_id = c.descendant AND c.ancestor = ? " "LEFT OUTER JOIN meta_data m " "ON o.upnp_id = m.object_fk " "LEFT OUTER JOIN Uri u ON u.object_fk = o.upnp_id " "WHERE %s " "ORDER BY o.type_fk ASC, " "m.class ASC, " "m.track ASC, " "o.title ASC " "LIMIT ?,?"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_URI_GET_STRING "SELECT uri FROM Uri WHERE Uri.object_fk = ?"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CHILDREN_COUNT_STRING "SELECT COUNT(upnp_id) FROM Object WHERE Object.parent = ?"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_OBJECT_EXISTS_STRING "SELECT COUNT(upnp_id), timestamp FROM Object WHERE Object.upnp_id = ?"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CHILD_ID_STRING "SELECT upnp_id FROM OBJECT WHERE parent = ?"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPDATE_V3_V4_STRING_2 "UPDATE meta_data SET object_fk = " "(SELECT upnp_id FROM Object WHERE metadata_fk = meta_data.id)"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPDATE_V3_V4_STRING_3 "ALTER TABLE Object ADD timestamp INTEGER"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPDATE_V3_V4_STRING_4 "UPDATE Object SET timestamp = 0"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_META_DATA_COLUMN_STRING "SELECT DISTINCT %s FROM meta_data AS m %s " "ORDER BY %s LIMIT ?,?"
GQuark rygel_database_error_quark (void);
gint rygel_media_export_database_exec (RygelMediaExportDatabase* self, const char* sql, GValue* values, int values_length1, RygelMediaExportDatabaseRowCallback callback, void* callback_target, GCancellable* cancellable, GError** error);
static void _vala_GValue_array_free (GValue* array, gint array_length);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const char* id, GError** error);
void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
void rygel_media_export_database_begin (RygelMediaExportDatabase* self, GError** error);
static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self, RygelMediaObject* item, GError** error);
static void rygel_media_export_media_cache_save_uris (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
void rygel_media_export_database_commit (RygelMediaExportDatabase* self, GError** error);
void rygel_media_export_database_rollback (RygelMediaExportDatabase* self);
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
static void rygel_media_export_media_cache_save_metadata (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error);
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error);
static void rygel_media_export_media_cache_remove_uris (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
static void rygel_media_export_media_cache_update_object_internal (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
void rygel_media_export_media_cache_update_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self, RygelMediaContainer* parent, const char* object_id, sqlite3_stmt* statement);
static gboolean _lambda0_ (sqlite3_stmt* statement, Block1Data* _data1_);
static gboolean __lambda0__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const char* object_id, GError** error);
RygelMediaItem* rygel_media_export_media_cache_get_item (RygelMediaExportMediaCache* self, const char* item_id, GError** error);
RygelMediaContainer* rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self, const char* container_id, GError** error);
static gboolean _lambda2_ (sqlite3_stmt* statement, Block2Data* _data2_);
static gboolean __lambda2__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const char* container_id, GError** error);
static gboolean _lambda3_ (sqlite3_stmt* statement, Block3Data* _data3_);
static gboolean __lambda3__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, const char* object_id, gint64* timestamp, GError** error);
static gboolean _lambda4_ (sqlite3_stmt* statement, Block4Data* _data4_);
static gboolean __lambda4__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
GeeArrayList* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self, const char* container_id, glong offset, glong max_count, GError** error);
static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self, guint max_count);
static char* rygel_media_export_media_cache_search_expression_to_sql (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, GValueArray* args, GError** error);
GeeArrayList* rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self, const char* filter, GValueArray* args, const char* container_id, glong offset, glong max_count, GError** error);
GeeList* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const char* container_id, guint offset, guint max_count, GError** error);
static gboolean _lambda5_ (sqlite3_stmt* statement, Block5Data* _data5_);
static gboolean __lambda5__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self, const char* name, GError** error);
RygelMediaExportDBObjectFactory* rygel_media_export_db_object_factory_new (void);
RygelMediaExportDBObjectFactory* rygel_media_export_db_object_factory_construct (GType object_type);
RygelMediaExportMediaCache* rygel_media_export_media_cache_new (const char* name, GError** error);
RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type, const char* name, GError** error);
RygelMediaExportMediaCache* rygel_media_export_media_cache_new_with_factory (const char* name, RygelMediaExportDBObjectFactory* factory, GError** error);
RygelMediaExportMediaCache* rygel_media_export_media_cache_construct_with_factory (GType object_type, const char* name, RygelMediaExportDBObjectFactory* factory, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_new (const char* name, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_construct (GType object_type, const char* name, GError** error);
static gboolean _lambda6_ (sqlite3_stmt* statement, Block6Data* _data6_);
static gboolean __lambda6__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static gboolean _lambda7_ (sqlite3_stmt* statement, Block7Data* _data7_);
static gboolean __lambda7__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
static void rygel_media_export_media_cache_update_v3_v4 (RygelMediaExportMediaCache* self);
static void rygel_media_export_media_cache_update_v4_v5 (RygelMediaExportMediaCache* self);
static gboolean _lambda9_ (sqlite3_stmt* statement, Block8Data* _data8_);
static gboolean __lambda9__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
static gboolean _lambda8_ (sqlite3_stmt* statement, Block9Data* _data9_);
static gboolean __lambda8__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
void rygel_media_export_database_analyze (RygelMediaExportDatabase* self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (Block9Data* _data9_);
void rygel_media_export_database_null (GValue* result);
static gboolean _lambda1_ (sqlite3_stmt* statement, Block10Data* _data10_);
static gboolean __lambda1__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (Block10Data* _data10_);
static void rygel_media_export_media_cache_add_uris (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
RygelMediaContainer* rygel_media_export_db_object_factory_get_container (RygelMediaExportDBObjectFactory* self, RygelMediaExportMediaCache* media_db, const char* id, const char* title, guint child_count);
RygelMediaItem* rygel_media_export_db_object_factory_get_item (RygelMediaExportDBObjectFactory* self, RygelMediaExportMediaCache* media_db, RygelMediaContainer* parent, const char* id, const char* title, const char* upnp_class);
static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self, sqlite3_stmt* statement, RygelMediaItem* item);
static gboolean _lambda10_ (sqlite3_stmt* statement, Block11Data* _data11_);
static gboolean __lambda10__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const char* container_id, GError** error);
static char* rygel_media_export_media_cache_logical_expression_to_sql (RygelMediaExportMediaCache* self, RygelLogicalExpression* expression, GValueArray* args, GError** error);
static char* rygel_media_export_media_cache_relational_expression_to_sql (RygelMediaExportMediaCache* self, RygelRelationalExpression* exp, GValueArray* args, GError** error);
static char* rygel_media_export_media_cache_map_operand_to_column (RygelMediaExportMediaCache* self, const char* operand, GError** error);
static gboolean _lambda11_ (sqlite3_stmt* statement, Block12Data* _data12_);
static gboolean __lambda11__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (Block12Data* _data12_);
GeeList* rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self, const char* column, const char* filter, GValueArray* args, glong offset, glong max_count, GError** error);
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const char* attribute, RygelSearchExpression* expression, glong offset, glong max_count, GError** error);
static void rygel_media_export_media_cache_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark rygel_media_db_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_db_error-quark");
}


GType rygel_media_db_object_type_get_type (void) {
	static volatile gsize rygel_media_db_object_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_db_object_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_MEDIA_DB_OBJECT_TYPE_CONTAINER, "RYGEL_MEDIA_DB_OBJECT_TYPE_CONTAINER", "container"}, {RYGEL_MEDIA_DB_OBJECT_TYPE_ITEM, "RYGEL_MEDIA_DB_OBJECT_TYPE_ITEM", "item"}, {0, NULL, NULL}};
		GType rygel_media_db_object_type_type_id;
		rygel_media_db_object_type_type_id = g_enum_register_static ("RygelMediaDBObjectType", values);
		g_once_init_leave (&rygel_media_db_object_type_type_id__volatile, rygel_media_db_object_type_type_id);
	}
	return rygel_media_db_object_type_type_id__volatile;
}


static void _vala_GValue_array_free (GValue* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}


#line 248 "rygel-media-export-media-cache.vala"
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const char* id, GError** error) {
#line 364 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
	GValue* _tmp2_;
	gint _values_size_;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
#line 248 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 248 "rygel-media-export-media-cache.vala"
	g_return_if_fail (id != NULL);
#line 376 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, id), _tmp0_), _tmp1_), values_length1 = 1, _values_size_ = values_length1, _tmp2_);
#line 250 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_DELETE_BY_ID_STRING, values, values_length1, NULL, NULL, NULL, &_inner_error_);
#line 381 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			return;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
#line 251 "rygel-media-export-media-cache.vala"
	g_signal_emit_by_name (self, "object-removed", id);
#line 396 "rygel-media-export-media-cache.c"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


#line 254 "rygel-media-export-media-cache.vala"
void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error) {
#line 403 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
#line 254 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 254 "rygel-media-export-media-cache.vala"
	g_return_if_fail (object != NULL);
#line 409 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 256 "rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_remove_by_id (self, object->id, &_inner_error_);
#line 413 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
#line 258 "rygel-media-export-media-cache.vala"
	if (RYGEL_IS_MEDIA_ITEM (object)) {
#line 259 "rygel-media-export-media-cache.vala"
		g_signal_emit_by_name (self, "item-removed", object->id);
#line 428 "rygel-media-export-media-cache.c"
	} else {
#line 260 "rygel-media-export-media-cache.vala"
		if (RYGEL_IS_MEDIA_CONTAINER (object)) {
#line 261 "rygel-media-export-media-cache.vala"
			g_signal_emit_by_name (self, "container-removed", object->id);
#line 434 "rygel-media-export-media-cache.c"
		} else {
			_inner_error_ = g_error_new_literal (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_INVALID_TYPE, _ ("Invalid object type"));
			{
				if ((_inner_error_->domain == RYGEL_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


#line 267 "rygel-media-export-media-cache.vala"
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error) {
#line 459 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
#line 267 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 267 "rygel-media-export-media-cache.vala"
	g_return_if_fail (container != NULL);
#line 465 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	{
#line 269 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (self->priv->db, &_inner_error_);
#line 470 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch2_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 270 "rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) container, &_inner_error_);
#line 481 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch2_rygel_database_error;
			}
			goto __finally2;
		}
#line 271 "rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_save_uris (self, (RygelMediaObject*) container, &_inner_error_);
#line 490 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch2_rygel_database_error;
			}
			goto __finally2;
		}
#line 272 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (self->priv->db, &_inner_error_);
#line 499 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch2_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 273 "rygel-media-export-media-cache.vala"
		g_signal_emit_by_name (self, "object-added", ((RygelMediaObject*) container)->id);
#line 274 "rygel-media-export-media-cache.vala"
		g_signal_emit_by_name (self, "container-added", ((RygelMediaObject*) container)->id);
#line 512 "rygel-media-export-media-cache.c"
	}
	goto __finally2;
	__catch2_rygel_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 276 "rygel-media-export-media-cache.vala"
			rygel_media_export_database_rollback (self->priv->db);
#line 523 "rygel-media-export-media-cache.c"
			_inner_error_ = _g_error_copy0 (_error_);
			{
				_g_error_free0 (_error_);
				goto __finally2;
			}
			_g_error_free0 (_error_);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


#line 282 "rygel-media-export-media-cache.vala"
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error) {
#line 542 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
#line 282 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 282 "rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 548 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	{
#line 284 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (self->priv->db, &_inner_error_);
#line 553 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch3_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 285 "rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_save_metadata (self, item, &_inner_error_);
#line 564 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch3_rygel_database_error;
			}
			goto __finally3;
		}
#line 286 "rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) item, &_inner_error_);
#line 573 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch3_rygel_database_error;
			}
			goto __finally3;
		}
#line 287 "rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_save_uris (self, (RygelMediaObject*) item, &_inner_error_);
#line 582 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch3_rygel_database_error;
			}
			goto __finally3;
		}
#line 288 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (self->priv->db, &_inner_error_);
#line 591 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch3_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 289 "rygel-media-export-media-cache.vala"
		g_signal_emit_by_name (self, "object-added", ((RygelMediaObject*) item)->id);
#line 290 "rygel-media-export-media-cache.vala"
		g_signal_emit_by_name (self, "item-added", ((RygelMediaObject*) item)->id);
#line 604 "rygel-media-export-media-cache.c"
	}
	goto __finally3;
	__catch3_rygel_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 292 "rygel-media-export-media-cache.vala"
			g_warning (_ ("Failed to add item with ID %s: %s"), ((RygelMediaObject*) item)->id, _error_->message);
#line 295 "rygel-media-export-media-cache.vala"
			rygel_media_export_database_rollback (self->priv->db);
#line 617 "rygel-media-export-media-cache.c"
			_inner_error_ = _g_error_copy0 (_error_);
			{
				_g_error_free0 (_error_);
				goto __finally3;
			}
			_g_error_free0 (_error_);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


#line 301 "rygel-media-export-media-cache.vala"
void rygel_media_export_media_cache_update_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error) {
#line 636 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
#line 301 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 301 "rygel-media-export-media-cache.vala"
	g_return_if_fail (object != NULL);
#line 642 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	{
#line 303 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (self->priv->db, &_inner_error_);
#line 647 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
#line 304 "rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_remove_uris (self, object, &_inner_error_);
#line 653 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
#line 305 "rygel-media-export-media-cache.vala"
		if (RYGEL_IS_MEDIA_ITEM (object)) {
#line 659 "rygel-media-export-media-cache.c"
			RygelMediaObject* _tmp0_;
#line 306 "rygel-media-export-media-cache.vala"
			rygel_media_export_media_cache_save_metadata (self, (_tmp0_ = object, RYGEL_IS_MEDIA_ITEM (_tmp0_) ? ((RygelMediaItem*) _tmp0_) : NULL), &_inner_error_);
#line 663 "rygel-media-export-media-cache.c"
			if (_inner_error_ != NULL) {
				goto __catch4_g_error;
			}
		}
#line 308 "rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_update_object_internal (self, object, &_inner_error_);
#line 670 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
#line 309 "rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_save_uris (self, object, &_inner_error_);
#line 676 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
#line 310 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (self->priv->db, &_inner_error_);
#line 682 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
#line 311 "rygel-media-export-media-cache.vala"
		g_signal_emit_by_name (self, "object-updated", object->id);
#line 312 "rygel-media-export-media-cache.vala"
		if (RYGEL_IS_MEDIA_ITEM (object)) {
#line 313 "rygel-media-export-media-cache.vala"
			g_signal_emit_by_name (self, "item-updated", object->id);
#line 692 "rygel-media-export-media-cache.c"
		} else {
#line 314 "rygel-media-export-media-cache.vala"
			if (RYGEL_IS_MEDIA_CONTAINER (object)) {
#line 315 "rygel-media-export-media-cache.vala"
				g_signal_emit_by_name (self, "container-updated", object->id);
#line 698 "rygel-media-export-media-cache.c"
			}
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 318 "rygel-media-export-media-cache.vala"
			g_warning (_ ("Failed to add item with ID %s: %s"), object->id, _error_->message);
#line 321 "rygel-media-export-media-cache.vala"
			rygel_media_export_database_rollback (self->priv->db);
#line 713 "rygel-media-export-media-cache.c"
			_inner_error_ = _g_error_copy0 (_error_);
			{
				_g_error_free0 (_error_);
				goto __finally4;
			}
			_g_error_free0 (_error_);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 331 "rygel-media-export-media-cache.vala"
static gboolean _lambda0_ (sqlite3_stmt* statement, Block1Data* _data1_) {
#line 737 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	RygelMediaObject* _tmp0_;
	RygelMediaContainer* parent_container;
	RygelMediaObject* object;
	RygelMediaObject* _tmp1_;
	self = _data1_->self;
#line 331 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 332 "rygel-media-export-media-cache.vala"
	parent_container = _g_object_ref0 ((_tmp0_ = _data1_->parent, RYGEL_IS_MEDIA_CONTAINER (_tmp0_) ? ((RygelMediaContainer*) _tmp0_) : NULL));
#line 333 "rygel-media-export-media-cache.vala"
	object = rygel_media_export_media_cache_get_object_from_statement (self, parent_container, sqlite3_column_text (statement, 18), statement);
#line 336 "rygel-media-export-media-cache.vala"
	rygel_media_object_set_parent_ref (object, parent_container);
#line 337 "rygel-media-export-media-cache.vala"
	_data1_->parent = (_tmp1_ = _g_object_ref0 (object), _g_object_unref0 (_data1_->parent), _tmp1_);
#line 755 "rygel-media-export-media-cache.c"
	result = TRUE;
	_g_object_unref0 (parent_container);
	_g_object_unref0 (object);
#line 339 "rygel-media-export-media-cache.vala"
	return result;
#line 761 "rygel-media-export-media-cache.c"
}


#line 331 "rygel-media-export-media-cache.vala"
static gboolean __lambda0__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 767 "rygel-media-export-media-cache.c"
	return _lambda0_ (stmt, self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	++_data1_->_ref_count_;
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if ((--_data1_->_ref_count_) == 0) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->parent);
		g_slice_free (Block1Data, _data1_);
	}
}


#line 327 "rygel-media-export-media-cache.vala"
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const char* object_id, GError** error) {
#line 789 "rygel-media-export-media-cache.c"
	RygelMediaObject* result = NULL;
	GError * _inner_error_;
	Block1Data* _data1_;
	GValue* _tmp2_;
	gint _values_size_;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
	RygelMediaExportDatabaseRowCallback _tmp3_;
	GDestroyNotify cb_target_destroy_notify = NULL;
	void* cb_target = NULL;
	RygelMediaExportDatabaseRowCallback cb;
#line 327 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 327 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (object_id != NULL, NULL);
#line 807 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, object_id), _tmp0_), _tmp1_), values_length1 = 1, _values_size_ = values_length1, _tmp2_);
	_data1_->parent = NULL;
	cb = (_tmp3_ = __lambda0__rygel_media_export_database_row_callback, cb_target = block1_data_ref (_data1_), cb_target_destroy_notify = block1_data_unref, _tmp3_);
#line 342 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_OBJECT_WITH_PATH, values, values_length1, cb, cb_target, NULL, &_inner_error_);
#line 817 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
			cb = NULL;
			cb_target = NULL;
			cb_target_destroy_notify = NULL;
			block1_data_unref (_data1_);
			return NULL;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
			cb = NULL;
			cb_target = NULL;
			cb_target_destroy_notify = NULL;
			block1_data_unref (_data1_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _g_object_ref0 (_data1_->parent);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
	cb = NULL;
	cb_target = NULL;
	cb_target_destroy_notify = NULL;
	block1_data_unref (_data1_);
#line 344 "rygel-media-export-media-cache.vala"
	return result;
#line 849 "rygel-media-export-media-cache.c"
}


#line 347 "rygel-media-export-media-cache.vala"
RygelMediaItem* rygel_media_export_media_cache_get_item (RygelMediaExportMediaCache* self, const char* item_id, GError** error) {
#line 855 "rygel-media-export-media-cache.c"
	RygelMediaItem* result = NULL;
	GError * _inner_error_;
	RygelMediaObject* object;
	gboolean _tmp0_ = FALSE;
	RygelMediaObject* _tmp1_;
#line 347 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 347 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (item_id != NULL, NULL);
#line 865 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 349 "rygel-media-export-media-cache.vala"
	object = rygel_media_export_media_cache_get_object (self, item_id, &_inner_error_);
#line 869 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 350 "rygel-media-export-media-cache.vala"
	if (object != NULL) {
#line 350 "rygel-media-export-media-cache.vala"
		_tmp0_ = !RYGEL_IS_MEDIA_ITEM (object);
#line 884 "rygel-media-export-media-cache.c"
	} else {
#line 350 "rygel-media-export-media-cache.vala"
		_tmp0_ = FALSE;
#line 888 "rygel-media-export-media-cache.c"
	}
#line 350 "rygel-media-export-media-cache.vala"
	if (_tmp0_) {
#line 892 "rygel-media-export-media-cache.c"
		_inner_error_ = g_error_new (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_INVALID_TYPE, _ ("Object %s is not an item"), item_id);
		{
			if ((_inner_error_->domain == RYGEL_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (object);
				return NULL;
			} else {
				_g_object_unref0 (object);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = _g_object_ref0 ((_tmp1_ = object, RYGEL_IS_MEDIA_ITEM (_tmp1_) ? ((RygelMediaItem*) _tmp1_) : NULL));
	_g_object_unref0 (object);
#line 355 "rygel-media-export-media-cache.vala"
	return result;
#line 911 "rygel-media-export-media-cache.c"
	_g_object_unref0 (object);
}


#line 358 "rygel-media-export-media-cache.vala"
RygelMediaContainer* rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self, const char* container_id, GError** error) {
#line 918 "rygel-media-export-media-cache.c"
	RygelMediaContainer* result = NULL;
	GError * _inner_error_;
	RygelMediaObject* object;
	gboolean _tmp0_ = FALSE;
	RygelMediaObject* _tmp1_;
#line 358 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 358 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 928 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 360 "rygel-media-export-media-cache.vala"
	object = rygel_media_export_media_cache_get_object (self, container_id, &_inner_error_);
#line 932 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 361 "rygel-media-export-media-cache.vala"
	if (object != NULL) {
#line 361 "rygel-media-export-media-cache.vala"
		_tmp0_ = !RYGEL_IS_MEDIA_CONTAINER (object);
#line 947 "rygel-media-export-media-cache.c"
	} else {
#line 361 "rygel-media-export-media-cache.vala"
		_tmp0_ = FALSE;
#line 951 "rygel-media-export-media-cache.c"
	}
#line 361 "rygel-media-export-media-cache.vala"
	if (_tmp0_) {
#line 955 "rygel-media-export-media-cache.c"
		_inner_error_ = g_error_new (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_INVALID_TYPE, "Object with id %s is not a" "MediaContainer", container_id);
		{
			if ((_inner_error_->domain == RYGEL_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (object);
				return NULL;
			} else {
				_g_object_unref0 (object);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = _g_object_ref0 ((_tmp1_ = object, RYGEL_IS_MEDIA_CONTAINER (_tmp1_) ? ((RygelMediaContainer*) _tmp1_) : NULL));
	_g_object_unref0 (object);
#line 367 "rygel-media-export-media-cache.vala"
	return result;
#line 974 "rygel-media-export-media-cache.c"
	_g_object_unref0 (object);
}


#line 376 "rygel-media-export-media-cache.vala"
static gboolean _lambda2_ (sqlite3_stmt* statement, Block2Data* _data2_) {
#line 981 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	self = _data2_->self;
#line 376 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 377 "rygel-media-export-media-cache.vala"
	_data2_->count = sqlite3_column_int (statement, 0);
#line 989 "rygel-media-export-media-cache.c"
	result = FALSE;
#line 379 "rygel-media-export-media-cache.vala"
	return result;
#line 993 "rygel-media-export-media-cache.c"
}


#line 376 "rygel-media-export-media-cache.vala"
static gboolean __lambda2__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 999 "rygel-media-export-media-cache.c"
	return _lambda2_ (stmt, self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	++_data2_->_ref_count_;
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if ((--_data2_->_ref_count_) == 0) {
		_g_object_unref0 (_data2_->self);
		g_slice_free (Block2Data, _data2_);
	}
}


#line 370 "rygel-media-export-media-cache.vala"
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const char* container_id, GError** error) {
#line 1020 "rygel-media-export-media-cache.c"
	gint result = 0;
	GError * _inner_error_;
	Block2Data* _data2_;
	GValue* _tmp2_;
	gint _values_size_;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
#line 370 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 370 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, 0);
#line 1034 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->count = 0;
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, container_id), _tmp0_), _tmp1_), values_length1 = 1, _values_size_ = values_length1, _tmp2_);
#line 374 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CHILDREN_COUNT_STRING, values, values_length1, __lambda2__rygel_media_export_database_row_callback, _data2_, NULL, &_inner_error_);
#line 1043 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block2_data_unref (_data2_);
			return 0;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block2_data_unref (_data2_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _data2_->count;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block2_data_unref (_data2_);
#line 382 "rygel-media-export-media-cache.vala"
	return result;
#line 1063 "rygel-media-export-media-cache.c"
}


#line 393 "rygel-media-export-media-cache.vala"
static gboolean _lambda3_ (sqlite3_stmt* statement, Block3Data* _data3_) {
#line 1069 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	self = _data3_->self;
#line 393 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 394 "rygel-media-export-media-cache.vala"
	_data3_->exists = sqlite3_column_int (statement, 0) == 1;
#line 395 "rygel-media-export-media-cache.vala"
	_data3_->tmp_timestamp = sqlite3_column_int64 (statement, 1);
#line 1079 "rygel-media-export-media-cache.c"
	result = FALSE;
#line 397 "rygel-media-export-media-cache.vala"
	return result;
#line 1083 "rygel-media-export-media-cache.c"
}


#line 393 "rygel-media-export-media-cache.vala"
static gboolean __lambda3__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 1089 "rygel-media-export-media-cache.c"
	return _lambda3_ (stmt, self);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	++_data3_->_ref_count_;
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if ((--_data3_->_ref_count_) == 0) {
		_g_object_unref0 (_data3_->self);
		g_slice_free (Block3Data, _data3_);
	}
}


#line 385 "rygel-media-export-media-cache.vala"
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, const char* object_id, gint64* timestamp, GError** error) {
#line 1110 "rygel-media-export-media-cache.c"
	gboolean result = FALSE;
	GError * _inner_error_;
	Block3Data* _data3_;
	GValue* _tmp2_;
	gint _values_size_;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
#line 385 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 385 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (object_id != NULL, FALSE);
#line 1124 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->exists = FALSE;
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, object_id), _tmp0_), _tmp1_), values_length1 = 1, _values_size_ = values_length1, _tmp2_);
	_data3_->tmp_timestamp = (gint64) 0;
#line 391 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_OBJECT_EXISTS_STRING, values, values_length1, __lambda3__rygel_media_export_database_row_callback, _data3_, NULL, &_inner_error_);
#line 1134 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block3_data_unref (_data3_);
			return FALSE;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block3_data_unref (_data3_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
#line 401 "rygel-media-export-media-cache.vala"
	*timestamp = _data3_->tmp_timestamp;
#line 1151 "rygel-media-export-media-cache.c"
	result = _data3_->exists;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block3_data_unref (_data3_);
#line 403 "rygel-media-export-media-cache.vala"
	return result;
#line 1157 "rygel-media-export-media-cache.c"
}


#line 416 "rygel-media-export-media-cache.vala"
static gboolean _lambda4_ (sqlite3_stmt* statement, Block4Data* _data4_) {
#line 1163 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	char* child_id;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	self = _data4_->self;
#line 416 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 417 "rygel-media-export-media-cache.vala"
	child_id = g_strdup (sqlite3_column_text (statement, 17));
#line 418 "rygel-media-export-media-cache.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data4_->children, _tmp0_ = rygel_media_export_media_cache_get_object_from_statement (self, _data4_->parent, child_id, statement));
#line 1176 "rygel-media-export-media-cache.c"
	_g_object_unref0 (_tmp0_);
#line 421 "rygel-media-export-media-cache.vala"
	rygel_media_object_set_parent_ref (_tmp1_ = (RygelMediaObject*) gee_abstract_list_last ((GeeAbstractList*) _data4_->children), _data4_->parent);
#line 1180 "rygel-media-export-media-cache.c"
	_g_object_unref0 (_tmp1_);
	result = TRUE;
	_g_free0 (child_id);
#line 423 "rygel-media-export-media-cache.vala"
	return result;
#line 1186 "rygel-media-export-media-cache.c"
}


#line 416 "rygel-media-export-media-cache.vala"
static gboolean __lambda4__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 1192 "rygel-media-export-media-cache.c"
	return _lambda4_ (stmt, self);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	++_data4_->_ref_count_;
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if ((--_data4_->_ref_count_) == 0) {
		_g_object_unref0 (_data4_->self);
		_g_object_unref0 (_data4_->children);
		_g_object_unref0 (_data4_->parent);
		g_slice_free (Block4Data, _data4_);
	}
}


#line 406 "rygel-media-export-media-cache.vala"
GeeArrayList* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self, const char* container_id, glong offset, glong max_count, GError** error) {
#line 1215 "rygel-media-export-media-cache.c"
	GeeArrayList* result = NULL;
	GError * _inner_error_;
	Block4Data* _data4_;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	GValue* _tmp6_;
	gint _values_size_;
	gint values_length1;
	GValue* _tmp5_ = NULL;
	GValue _tmp4_ = {0};
	GValue _tmp3_ = {0};
	GValue _tmp2_ = {0};
	GValue* values;
	RygelMediaExportDatabaseRowCallback _tmp7_;
	GDestroyNotify callback_target_destroy_notify = NULL;
	void* callback_target = NULL;
	RygelMediaExportDatabaseRowCallback callback;
#line 406 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 406 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 1237 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_data4_->children = gee_array_list_new (RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 411 "rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_export_media_cache_get_object (self, container_id, &_inner_error_);
#line 1245 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		block4_data_unref (_data4_);
		return NULL;
	}
	_data4_->parent = (_tmp1_ = _tmp0_, RYGEL_IS_MEDIA_CONTAINER (_tmp1_) ? ((RygelMediaContainer*) _tmp1_) : NULL);
	values = (_tmp6_ = (_tmp5_ = g_new0 (GValue, 3), _tmp5_[0] = (g_value_init (&_tmp2_, G_TYPE_STRING), g_value_set_string (&_tmp2_, container_id), _tmp2_), _tmp5_[1] = (g_value_init (&_tmp3_, G_TYPE_INT64), g_value_set_int64 (&_tmp3_, (gint64) offset), _tmp3_), _tmp5_[2] = (g_value_init (&_tmp4_, G_TYPE_INT64), g_value_set_int64 (&_tmp4_, (gint64) max_count), _tmp4_), _tmp5_), values_length1 = 3, _values_size_ = values_length1, _tmp6_);
	callback = (_tmp7_ = __lambda4__rygel_media_export_database_row_callback, callback_target = block4_data_ref (_data4_), callback_target_destroy_notify = block4_data_unref, _tmp7_);
#line 426 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CHILDREN_STRING, values, values_length1, callback, callback_target, NULL, &_inner_error_);
#line 1256 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
		callback = NULL;
		callback_target = NULL;
		callback_target_destroy_notify = NULL;
		block4_data_unref (_data4_);
		return NULL;
	}
	result = _g_object_ref0 (_data4_->children);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	block4_data_unref (_data4_);
#line 428 "rygel-media-export-media-cache.vala"
	return result;
#line 1276 "rygel-media-export-media-cache.c"
}


#line 431 "rygel-media-export-media-cache.vala"
static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self, guint max_count) {
#line 1282 "rygel-media-export-media-cache.c"
	guint result = 0U;
#line 431 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 432 "rygel-media-export-media-cache.vala"
	if (max_count == 0) {
#line 1288 "rygel-media-export-media-cache.c"
		result = (guint) (-1);
#line 433 "rygel-media-export-media-cache.vala"
		return result;
#line 1292 "rygel-media-export-media-cache.c"
	} else {
		result = max_count;
#line 435 "rygel-media-export-media-cache.vala"
		return result;
#line 1297 "rygel-media-export-media-cache.c"
	}
}


#line 439 "rygel-media-export-media-cache.vala"
GeeList* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const char* container_id, guint offset, guint max_count, GError** error) {
#line 1304 "rygel-media-export-media-cache.c"
	GeeList* result = NULL;
	GError * _inner_error_;
	GValueArray* args;
	char* filter;
	char* _tmp0_;
	guint max_objects;
	GeeArrayList* _tmp2_;
#line 439 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 439 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 1316 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 445 "rygel-media-export-media-cache.vala"
	args = g_value_array_new ((guint) 0);
#line 446 "rygel-media-export-media-cache.vala"
	filter = rygel_media_export_media_cache_search_expression_to_sql (self, expression, args, &_inner_error_);
#line 1322 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		return NULL;
	}
#line 448 "rygel-media-export-media-cache.vala"
	if (filter == NULL) {
#line 1330 "rygel-media-export-media-cache.c"
		result = (GeeList*) gee_array_list_new (RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
		_g_value_array_free0 (args);
		_g_free0 (filter);
#line 449 "rygel-media-export-media-cache.vala"
		return result;
#line 1336 "rygel-media-export-media-cache.c"
	}
#line 452 "rygel-media-export-media-cache.vala"
	g_debug (_ ("Original search: %s"), _tmp0_ = rygel_search_expression_to_string (expression));
#line 1340 "rygel-media-export-media-cache.c"
	_g_free0 (_tmp0_);
#line 453 "rygel-media-export-media-cache.vala"
	g_debug (_ ("Parsed search expression: %s"), filter);
#line 1344 "rygel-media-export-media-cache.c"
	{
		gint i;
#line 455 "rygel-media-export-media-cache.vala"
		i = 0;
#line 1349 "rygel-media-export-media-cache.c"
		{
			gboolean _tmp1_;
#line 455 "rygel-media-export-media-cache.vala"
			_tmp1_ = TRUE;
#line 455 "rygel-media-export-media-cache.vala"
			while (TRUE) {
#line 455 "rygel-media-export-media-cache.vala"
				if (!_tmp1_) {
#line 455 "rygel-media-export-media-cache.vala"
					i++;
#line 1360 "rygel-media-export-media-cache.c"
				}
#line 455 "rygel-media-export-media-cache.vala"
				_tmp1_ = FALSE;
#line 455 "rygel-media-export-media-cache.vala"
				if (!(i < args->n_values)) {
#line 455 "rygel-media-export-media-cache.vala"
					break;
#line 1368 "rygel-media-export-media-cache.c"
				}
#line 456 "rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:456: Arg %d: %s", i, g_value_get_string (g_value_array_get_nth (args, (guint) i)));
#line 1372 "rygel-media-export-media-cache.c"
			}
		}
	}
#line 459 "rygel-media-export-media-cache.vala"
	max_objects = rygel_media_export_media_cache_modify_limit (self, max_count);
#line 461 "rygel-media-export-media-cache.vala"
	_tmp2_ = rygel_media_export_media_cache_get_objects_by_filter (self, filter, args, container_id, (glong) offset, (glong) max_objects, &_inner_error_);
#line 1380 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		_g_free0 (filter);
		return NULL;
	}
	result = (GeeList*) _tmp2_;
	_g_value_array_free0 (args);
	_g_free0 (filter);
#line 461 "rygel-media-export-media-cache.vala"
	return result;
#line 1392 "rygel-media-export-media-cache.c"
}


#line 485 "rygel-media-export-media-cache.vala"
static gboolean _lambda5_ (sqlite3_stmt* statement, Block5Data* _data5_) {
#line 1398 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	char* child_id;
	char* parent_id;
	self = _data5_->self;
#line 485 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 1407 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 486 "rygel-media-export-media-cache.vala"
	child_id = g_strdup (sqlite3_column_text (statement, 17));
#line 487 "rygel-media-export-media-cache.vala"
	parent_id = g_strdup (sqlite3_column_text (statement, 18));
#line 1413 "rygel-media-export-media-cache.c"
	{
		RygelMediaObject* _tmp0_;
		RygelMediaObject* _tmp1_;
		RygelMediaContainer* parent;
#line 489 "rygel-media-export-media-cache.vala"
		_tmp0_ = rygel_media_export_media_cache_get_object (self, parent_id, &_inner_error_);
#line 1420 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch5_rygel_database_error;
			}
			_g_free0 (child_id);
			_g_free0 (parent_id);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
#line 489 "rygel-media-export-media-cache.vala"
		parent = (_tmp1_ = _tmp0_, RYGEL_IS_MEDIA_CONTAINER (_tmp1_) ? ((RygelMediaContainer*) _tmp1_) : NULL);
#line 490 "rygel-media-export-media-cache.vala"
		if (parent != NULL) {
#line 1435 "rygel-media-export-media-cache.c"
			RygelMediaObject* _tmp2_;
			RygelMediaObject* _tmp3_;
#line 491 "rygel-media-export-media-cache.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _data5_->children, _tmp2_ = rygel_media_export_media_cache_get_object_from_statement (self, parent, child_id, statement));
#line 1440 "rygel-media-export-media-cache.c"
			_g_object_unref0 (_tmp2_);
#line 494 "rygel-media-export-media-cache.vala"
			rygel_media_object_set_parent_ref (_tmp3_ = (RygelMediaObject*) gee_abstract_list_last ((GeeAbstractList*) _data5_->children), parent);
#line 1444 "rygel-media-export-media-cache.c"
			_g_object_unref0 (_tmp3_);
		} else {
#line 496 "rygel-media-export-media-cache.vala"
			g_warning ("Inconsistent database: item %s " "has no parent %s", child_id, parent_id);
#line 1449 "rygel-media-export-media-cache.c"
		}
		result = TRUE;
		_g_object_unref0 (parent);
		_g_free0 (child_id);
		_g_free0 (parent_id);
#line 502 "rygel-media-export-media-cache.vala"
		return result;
#line 1457 "rygel-media-export-media-cache.c"
	}
	goto __finally5;
	__catch5_rygel_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 504 "rygel-media-export-media-cache.vala"
			g_warning ("rygel-media-export-media-cache.vala:504: Failed to get parent item: %s", _error_->message);
#line 1468 "rygel-media-export-media-cache.c"
			result = FALSE;
			_g_error_free0 (_error_);
			_g_free0 (child_id);
			_g_free0 (parent_id);
#line 506 "rygel-media-export-media-cache.vala"
			return result;
#line 1475 "rygel-media-export-media-cache.c"
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_free0 (child_id);
		_g_free0 (parent_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_g_free0 (child_id);
	_g_free0 (parent_id);
}


#line 485 "rygel-media-export-media-cache.vala"
static gboolean __lambda5__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 1493 "rygel-media-export-media-cache.c"
	return _lambda5_ (stmt, self);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	++_data5_->_ref_count_;
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if ((--_data5_->_ref_count_) == 0) {
		_g_object_unref0 (_data5_->self);
		_g_object_unref0 (_data5_->children);
		g_slice_free (Block5Data, _data5_);
	}
}


#line 468 "rygel-media-export-media-cache.vala"
GeeArrayList* rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self, const char* filter, GValueArray* args, const char* container_id, glong offset, glong max_count, GError** error) {
#line 1515 "rygel-media-export-media-cache.c"
	GeeArrayList* result = NULL;
	GError * _inner_error_;
	Block5Data* _data5_;
	GValue _tmp0_ = {0};
	GValue v;
	GValue _tmp2_;
	GValue _tmp1_ = {0};
	GValue _tmp4_;
	GValue _tmp3_ = {0};
	RygelMediaExportDatabaseRowCallback _tmp5_;
	GDestroyNotify callback_target_destroy_notify = NULL;
	void* callback_target = NULL;
	RygelMediaExportDatabaseRowCallback callback;
	char* _tmp6_;
#line 468 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 468 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (filter != NULL, NULL);
#line 468 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 468 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 1538 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->children = gee_array_list_new (RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 476 "rygel-media-export-media-cache.vala"
	v = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, container_id), _tmp0_);
#line 477 "rygel-media-export-media-cache.vala"
	g_value_array_prepend (args, &v);
#line 478 "rygel-media-export-media-cache.vala"
	v = (_tmp2_ = (g_value_init (&_tmp1_, G_TYPE_LONG), g_value_set_long (&_tmp1_, offset), _tmp1_), G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL, _tmp2_);
#line 479 "rygel-media-export-media-cache.vala"
	g_value_array_append (args, &v);
#line 480 "rygel-media-export-media-cache.vala"
	v = (_tmp4_ = (g_value_init (&_tmp3_, G_TYPE_LONG), g_value_set_long (&_tmp3_, max_count), _tmp3_), G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL, _tmp4_);
#line 481 "rygel-media-export-media-cache.vala"
	g_value_array_append (args, &v);
#line 483 "rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:483: Parameters to bind: %u", args->n_values);
#line 1558 "rygel-media-export-media-cache.c"
	callback = (_tmp5_ = __lambda5__rygel_media_export_database_row_callback, callback_target = block5_data_ref (_data5_), callback_target_destroy_notify = block5_data_unref, _tmp5_);
#line 510 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, _tmp6_ = g_strdup_printf (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_OBJECTS_BY_FILTER_STRING, filter), args->values, (gint) args->n_values, callback, callback_target, NULL, &_inner_error_);
#line 1562 "rygel-media-export-media-cache.c"
	_g_free0 (_tmp6_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
		callback = NULL;
		callback_target = NULL;
		callback_target_destroy_notify = NULL;
		block5_data_unref (_data5_);
		return NULL;
	}
	result = _g_object_ref0 (_data5_->children);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	block5_data_unref (_data5_);
#line 514 "rygel-media-export-media-cache.vala"
	return result;
#line 1583 "rygel-media-export-media-cache.c"
}


#line 517 "rygel-media-export-media-cache.vala"
RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type, const char* name, GError** error) {
#line 1589 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
	RygelMediaExportMediaCache * self;
	RygelMediaExportDBObjectFactory* _tmp0_;
#line 517 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 1595 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 517 "rygel-media-export-media-cache.vala"
	self = (RygelMediaExportMediaCache*) g_object_new (object_type, NULL);
#line 518 "rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_open_db (self, name, &_inner_error_);
#line 1601 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		g_object_unref (self);
		return NULL;
	}
#line 519 "rygel-media-export-media-cache.vala"
	self->priv->factory = (_tmp0_ = rygel_media_export_db_object_factory_new (), _g_object_unref0 (self->priv->factory), _tmp0_);
#line 1609 "rygel-media-export-media-cache.c"
	return self;
}


#line 517 "rygel-media-export-media-cache.vala"
RygelMediaExportMediaCache* rygel_media_export_media_cache_new (const char* name, GError** error) {
#line 517 "rygel-media-export-media-cache.vala"
	return rygel_media_export_media_cache_construct (RYGEL_TYPE_MEDIA_EXPORT_MEDIA_CACHE, name, error);
#line 1618 "rygel-media-export-media-cache.c"
}


#line 522 "rygel-media-export-media-cache.vala"
RygelMediaExportMediaCache* rygel_media_export_media_cache_construct_with_factory (GType object_type, const char* name, RygelMediaExportDBObjectFactory* factory, GError** error) {
#line 1624 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
	RygelMediaExportMediaCache * self;
	RygelMediaExportDBObjectFactory* _tmp0_;
#line 522 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 522 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (factory != NULL, NULL);
#line 1632 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 522 "rygel-media-export-media-cache.vala"
	self = (RygelMediaExportMediaCache*) g_object_new (object_type, NULL);
#line 526 "rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_open_db (self, name, &_inner_error_);
#line 1638 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		g_object_unref (self);
		return NULL;
	}
#line 527 "rygel-media-export-media-cache.vala"
	self->priv->factory = (_tmp0_ = _g_object_ref0 (factory), _g_object_unref0 (self->priv->factory), _tmp0_);
#line 1646 "rygel-media-export-media-cache.c"
	return self;
}


#line 522 "rygel-media-export-media-cache.vala"
RygelMediaExportMediaCache* rygel_media_export_media_cache_new_with_factory (const char* name, RygelMediaExportDBObjectFactory* factory, GError** error) {
#line 522 "rygel-media-export-media-cache.vala"
	return rygel_media_export_media_cache_construct_with_factory (RYGEL_TYPE_MEDIA_EXPORT_MEDIA_CACHE, name, factory, error);
#line 1655 "rygel-media-export-media-cache.c"
}


#line 537 "rygel-media-export-media-cache.vala"
static gboolean _lambda6_ (sqlite3_stmt* statement, Block6Data* _data6_) {
#line 1661 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	self = _data6_->self;
#line 537 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 538 "rygel-media-export-media-cache.vala"
	_data6_->old_version = sqlite3_column_int (statement, 0);
#line 1669 "rygel-media-export-media-cache.c"
	result = FALSE;
#line 540 "rygel-media-export-media-cache.vala"
	return result;
#line 1673 "rygel-media-export-media-cache.c"
}


#line 537 "rygel-media-export-media-cache.vala"
static gboolean __lambda6__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 1679 "rygel-media-export-media-cache.c"
	return _lambda6_ (stmt, self);
}


#line 552 "rygel-media-export-media-cache.vala"
static gboolean _lambda7_ (sqlite3_stmt* statement, Block7Data* _data7_) {
#line 1686 "rygel-media-export-media-cache.c"
	Block6Data* _data6_;
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
#line 552 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 553 "rygel-media-export-media-cache.vala"
	_data7_->schema_ok = sqlite3_column_int (statement, 0) == 1;
#line 1696 "rygel-media-export-media-cache.c"
	result = FALSE;
#line 555 "rygel-media-export-media-cache.vala"
	return result;
#line 1700 "rygel-media-export-media-cache.c"
}


#line 552 "rygel-media-export-media-cache.vala"
static gboolean __lambda7__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 1706 "rygel-media-export-media-cache.c"
	return _lambda7_ (stmt, self);
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	++_data7_->_ref_count_;
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if ((--_data7_->_ref_count_) == 0) {
		block6_data_unref (_data7_->_data6_);
		g_slice_free (Block7Data, _data7_);
	}
}


#line 609 "rygel-media-export-media-cache.vala"
static gboolean _lambda9_ (sqlite3_stmt* statement, Block8Data* _data8_) {
#line 1727 "rygel-media-export-media-cache.c"
	Block6Data* _data6_;
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	_data6_ = _data8_->_data6_;
	self = _data6_->self;
#line 609 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 610 "rygel-media-export-media-cache.vala"
	_data8_->rows = sqlite3_column_int (statement, 0);
#line 1737 "rygel-media-export-media-cache.c"
	result = FALSE;
#line 612 "rygel-media-export-media-cache.vala"
	return result;
#line 1741 "rygel-media-export-media-cache.c"
}


#line 609 "rygel-media-export-media-cache.vala"
static gboolean __lambda9__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 1747 "rygel-media-export-media-cache.c"
	return _lambda9_ (stmt, self);
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	++_data8_->_ref_count_;
	return _data8_;
}


static void block8_data_unref (Block8Data* _data8_) {
	if ((--_data8_->_ref_count_) == 0) {
		block6_data_unref (_data8_->_data6_);
		g_slice_free (Block8Data, _data8_);
	}
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	++_data6_->_ref_count_;
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if ((--_data6_->_ref_count_) == 0) {
		_g_object_unref0 (_data6_->self);
		g_slice_free (Block6Data, _data6_);
	}
}


#line 530 "rygel-media-export-media-cache.vala"
static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self, const char* name, GError** error) {
#line 1782 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
	Block6Data* _data6_;
	RygelMediaExportDatabase* _tmp0_;
	RygelMediaExportDatabase* _tmp1_;
#line 530 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 530 "rygel-media-export-media-cache.vala"
	g_return_if_fail (name != NULL);
#line 1791 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
#line 531 "rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_export_database_new (name, &_inner_error_);
#line 1798 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		block6_data_unref (_data6_);
		return;
	}
#line 531 "rygel-media-export-media-cache.vala"
	self->priv->db = (_tmp1_ = _tmp0_, _g_object_unref0 (self->priv->db), _tmp1_);
#line 1806 "rygel-media-export-media-cache.c"
	_data6_->old_version = -1;
	{
		gint current_version;
#line 535 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, "SELECT version FROM schema_info", NULL, 0, __lambda6__rygel_media_export_database_row_callback, _data6_, NULL, &_inner_error_);
#line 1812 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch6_rygel_database_error;
			}
			block6_data_unref (_data6_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 542 "rygel-media-export-media-cache.vala"
		current_version = atoi (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_schema_version);
#line 543 "rygel-media-export-media-cache.vala"
		if (_data6_->old_version == current_version) {
#line 1826 "rygel-media-export-media-cache.c"
			Block7Data* _data7_;
			_data7_ = g_slice_new0 (Block7Data);
			_data7_->_ref_count_ = 1;
			_data7_->_data6_ = block6_data_ref (_data6_);
			_data7_->schema_ok = TRUE;
#line 546 "rygel-media-export-media-cache.vala"
			g_debug ("rygel-media-export-media-cache.vala:546: Media DB schema has current v" \
"ersion");
#line 547 "rygel-media-export-media-cache.vala"
			g_debug ("rygel-media-export-media-cache.vala:547: Checking for consistent schem" \
"a...");
#line 548 "rygel-media-export-media-cache.vala"
			rygel_media_export_database_exec (self->priv->db, "SELECT count(*) FROM sqlite_master WHERE sql " "LIKE 'CREATE TABLE Meta_Data%object_fk TEXT " "UNIQUE%'", NULL, 0, __lambda7__rygel_media_export_database_row_callback, _data7_, NULL, &_inner_error_);
#line 1838 "rygel-media-export-media-cache.c"
			if (_inner_error_ != NULL) {
				block7_data_unref (_data7_);
				if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
					goto __catch6_rygel_database_error;
				}
				block7_data_unref (_data7_);
				block6_data_unref (_data6_);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
#line 557 "rygel-media-export-media-cache.vala"
			if (!_data7_->schema_ok) {
#line 1852 "rygel-media-export-media-cache.c"
				{
#line 559 "rygel-media-export-media-cache.vala"
					g_message ("rygel-media-export-media-cache.vala:559: Found faulty schema, forcing " \
"full reindex");
#line 560 "rygel-media-export-media-cache.vala"
					rygel_media_export_database_begin (self->priv->db, &_inner_error_);
#line 1858 "rygel-media-export-media-cache.c"
					if (_inner_error_ != NULL) {
						goto __catch7_g_error;
					}
#line 561 "rygel-media-export-media-cache.vala"
					rygel_media_export_database_exec (self->priv->db, "DELETE FROM Object WHERE upnp_id IN (" "SELECT DISTINCT object_fk FROM meta_data)", NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 1864 "rygel-media-export-media-cache.c"
					if (_inner_error_ != NULL) {
						goto __catch7_g_error;
					}
#line 563 "rygel-media-export-media-cache.vala"
					rygel_media_export_database_exec (self->priv->db, "DROP TABLE Meta_Data", NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 1870 "rygel-media-export-media-cache.c"
					if (_inner_error_ != NULL) {
						goto __catch7_g_error;
					}
#line 564 "rygel-media-export-media-cache.vala"
					rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_META_DATA_TABLE_STRING, NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 1876 "rygel-media-export-media-cache.c"
					if (_inner_error_ != NULL) {
						goto __catch7_g_error;
					}
#line 565 "rygel-media-export-media-cache.vala"
					rygel_media_export_database_commit (self->priv->db, &_inner_error_);
#line 1882 "rygel-media-export-media-cache.c"
					if (_inner_error_ != NULL) {
						goto __catch7_g_error;
					}
				}
				goto __finally7;
				__catch7_g_error:
				{
					GError * _error_;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					{
						char* _tmp2_;
#line 567 "rygel-media-export-media-cache.vala"
						rygel_media_export_database_rollback (self->priv->db);
#line 568 "rygel-media-export-media-cache.vala"
						g_warning ("rygel-media-export-media-cache.vala:568: %s", _tmp2_ = g_strconcat ("Failed to force reindex to fix database: ", _error_->message, NULL));
#line 1899 "rygel-media-export-media-cache.c"
						_g_free0 (_tmp2_);
						_g_error_free0 (_error_);
					}
				}
				__finally7:
				if (_inner_error_ != NULL) {
					block7_data_unref (_data7_);
					if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
						goto __catch6_rygel_database_error;
					}
					block7_data_unref (_data7_);
					block6_data_unref (_data6_);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			block7_data_unref (_data7_);
		} else {
#line 573 "rygel-media-export-media-cache.vala"
			if (_data6_->old_version < current_version) {
#line 574 "rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:574: Older schema detected. Upgrad" \
"ing...");
#line 575 "rygel-media-export-media-cache.vala"
				switch (_data6_->old_version) {
#line 1925 "rygel-media-export-media-cache.c"
					case 3:
					{
#line 577 "rygel-media-export-media-cache.vala"
						rygel_media_export_media_cache_update_v3_v4 (self);
#line 578 "rygel-media-export-media-cache.vala"
						if (self->priv->db != NULL) {
#line 579 "rygel-media-export-media-cache.vala"
							rygel_media_export_media_cache_update_v4_v5 (self);
#line 1934 "rygel-media-export-media-cache.c"
						}
#line 581 "rygel-media-export-media-cache.vala"
						break;
#line 1938 "rygel-media-export-media-cache.c"
					}
					case 4:
					{
#line 583 "rygel-media-export-media-cache.vala"
						rygel_media_export_media_cache_update_v4_v5 (self);
#line 584 "rygel-media-export-media-cache.vala"
						break;
#line 1946 "rygel-media-export-media-cache.c"
					}
					default:
					{
						RygelMediaExportDatabase* _tmp3_;
#line 586 "rygel-media-export-media-cache.vala"
						g_warning ("rygel-media-export-media-cache.vala:586: Cannot upgrade");
#line 587 "rygel-media-export-media-cache.vala"
						self->priv->db = (_tmp3_ = NULL, _g_object_unref0 (self->priv->db), _tmp3_);
#line 588 "rygel-media-export-media-cache.vala"
						break;
#line 1957 "rygel-media-export-media-cache.c"
					}
				}
			} else {
				RygelMediaExportDatabase* _tmp4_;
#line 591 "rygel-media-export-media-cache.vala"
				g_warning ("The version \"%d\" of the detected database" " is newer than our supported version \"%d\"", _data6_->old_version, current_version);
#line 595 "rygel-media-export-media-cache.vala"
				self->priv->db = (_tmp4_ = NULL, _g_object_unref0 (self->priv->db), _tmp4_);
#line 1966 "rygel-media-export-media-cache.c"
				_inner_error_ = g_error_new_literal (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_GENERAL_ERROR, "Database format" " not supported");
				{
					if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
						goto __catch6_rygel_database_error;
					}
					goto __finally6;
				}
			}
		}
	}
	goto __finally6;
	__catch6_rygel_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 602 "rygel-media-export-media-cache.vala"
			g_debug ("rygel-media-export-media-cache.vala:602: %s", "Could not find schema version;" " checking for empty database...");
#line 1986 "rygel-media-export-media-cache.c"
			{
				Block8Data* _data8_;
				_data8_ = g_slice_new0 (Block8Data);
				_data8_->_ref_count_ = 1;
				_data8_->_data6_ = block6_data_ref (_data6_);
				_data8_->rows = -1;
#line 606 "rygel-media-export-media-cache.vala"
				rygel_media_export_database_exec (self->priv->db, "SELECT count(type) FROM sqlite_master " "WHERE rowid=1", NULL, 0, __lambda9__rygel_media_export_database_row_callback, _data8_, NULL, &_inner_error_);
#line 1995 "rygel-media-export-media-cache.c"
				if (_inner_error_ != NULL) {
					block8_data_unref (_data8_);
					if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
						goto __catch8_rygel_database_error;
					}
					block8_data_unref (_data8_);
					_g_error_free0 (_error_);
					block6_data_unref (_data6_);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
#line 614 "rygel-media-export-media-cache.vala"
				if (_data8_->rows == 0) {
#line 615 "rygel-media-export-media-cache.vala"
					g_debug ("rygel-media-export-media-cache.vala:615: Empty database, creating new " \
"schema version %s", RYGEL_MEDIA_EXPORT_MEDIA_CACHE_schema_version);
#line 617 "rygel-media-export-media-cache.vala"
					if (!rygel_media_export_media_cache_create_schema (self)) {
#line 2014 "rygel-media-export-media-cache.c"
						RygelMediaExportDatabase* _tmp5_;
#line 618 "rygel-media-export-media-cache.vala"
						self->priv->db = (_tmp5_ = NULL, _g_object_unref0 (self->priv->db), _tmp5_);
#line 2018 "rygel-media-export-media-cache.c"
						block8_data_unref (_data8_);
						_g_error_free0 (_error_);
						block6_data_unref (_data6_);
#line 620 "rygel-media-export-media-cache.vala"
						return;
#line 2024 "rygel-media-export-media-cache.c"
					}
				} else {
					RygelMediaExportDatabase* _tmp6_;
#line 623 "rygel-media-export-media-cache.vala"
					g_warning ("rygel-media-export-media-cache.vala:623: Incompatible schema... cannot" \
" proceed");
#line 624 "rygel-media-export-media-cache.vala"
					self->priv->db = (_tmp6_ = NULL, _g_object_unref0 (self->priv->db), _tmp6_);
#line 2032 "rygel-media-export-media-cache.c"
					block8_data_unref (_data8_);
					_g_error_free0 (_error_);
					block6_data_unref (_data6_);
#line 626 "rygel-media-export-media-cache.vala"
					return;
#line 2038 "rygel-media-export-media-cache.c"
				}
				block8_data_unref (_data8_);
			}
			goto __finally8;
			__catch8_rygel_database_error:
			{
				GError * _error_;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				{
					RygelMediaExportDatabase* _tmp7_;
#line 629 "rygel-media-export-media-cache.vala"
					g_warning ("rygel-media-export-media-cache.vala:629: Something weird going on: %s", _error_->message);
#line 630 "rygel-media-export-media-cache.vala"
					self->priv->db = (_tmp7_ = NULL, _g_object_unref0 (self->priv->db), _tmp7_);
#line 2054 "rygel-media-export-media-cache.c"
					_inner_error_ = g_error_new_literal (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_GENERAL_ERROR, "Invalid database");
					{
						_g_error_free0 (_error_);
						_g_error_free0 (_error_);
						block6_data_unref (_data6_);
						goto __finally8;
					}
					_g_error_free0 (_error_);
				}
			}
			__finally8:
			if (_inner_error_ != NULL) {
				_g_error_free0 (_error_);
				block6_data_unref (_data6_);
				goto __finally6;
			}
			_g_error_free0 (_error_);
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		block6_data_unref (_data6_);
		return;
	}
	block6_data_unref (_data6_);
}


#line 637 "rygel-media-export-media-cache.vala"
static void rygel_media_export_media_cache_update_v3_v4 (RygelMediaExportMediaCache* self) {
#line 2086 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
#line 637 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 2090 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	{
#line 639 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (self->priv->db, &_inner_error_);
#line 2095 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch9_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 640 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, "ALTER TABLE Meta_Data RENAME TO _Meta_Data", NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2106 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch9_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 641 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_META_DATA_TABLE_STRING, NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2117 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch9_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 642 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, "INSERT INTO meta_data (size, mime_type, duration, " "width, height, class, author, album, date, " "bitrate, sample_freq, bits_per_sample, channels, " "track, color_depth, object_fk) SELECT size, " "mime_type, duration, width, height, class, author, " "album, date, bitrate, sample_freq, bits_per_sample, " "channels, track, color_depth, o.upnp_id FROM " "_Meta_Data JOIN object o ON id = o.metadata_fk", NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2128 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch9_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 650 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, "DROP TABLE _Meta_Data", NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2139 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch9_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 651 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPDATE_V3_V4_STRING_3, NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2150 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch9_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 652 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPDATE_V3_V4_STRING_4, NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2161 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch9_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 653 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_TRIGGER_STRING, NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2172 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch9_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 654 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, "UPDATE schema_info SET version = '4'", NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2183 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch9_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 655 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (self->priv->db, &_inner_error_);
#line 2194 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch9_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally9;
	__catch9_rygel_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			RygelMediaExportDatabase* _tmp0_;
#line 657 "rygel-media-export-media-cache.vala"
			rygel_media_export_database_rollback (self->priv->db);
#line 658 "rygel-media-export-media-cache.vala"
			g_warning ("rygel-media-export-media-cache.vala:658: Database upgrade failed: %s", _error_->message);
#line 659 "rygel-media-export-media-cache.vala"
			self->priv->db = (_tmp0_ = NULL, _g_object_unref0 (self->priv->db), _tmp0_);
#line 2218 "rygel-media-export-media-cache.c"
			_g_error_free0 (_error_);
		}
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


#line 684 "rygel-media-export-media-cache.vala"
static gboolean _lambda8_ (sqlite3_stmt* statement, Block9Data* _data9_) {
#line 2233 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	self = _data9_->self;
#line 684 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 685 "rygel-media-export-media-cache.vala"
	gee_queue_offer (_data9_->queue, sqlite3_column_text (statement, 0));
#line 2241 "rygel-media-export-media-cache.c"
	result = TRUE;
#line 687 "rygel-media-export-media-cache.vala"
	return result;
#line 2245 "rygel-media-export-media-cache.c"
}


#line 684 "rygel-media-export-media-cache.vala"
static gboolean __lambda8__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 2251 "rygel-media-export-media-cache.c"
	return _lambda8_ (stmt, self);
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	++_data9_->_ref_count_;
	return _data9_;
}


static void block9_data_unref (Block9Data* _data9_) {
	if ((--_data9_->_ref_count_) == 0) {
		_g_object_unref0 (_data9_->self);
		_g_object_unref0 (_data9_->queue);
		g_slice_free (Block9Data, _data9_);
	}
}


#line 663 "rygel-media-export-media-cache.vala"
static void rygel_media_export_media_cache_update_v4_v5 (RygelMediaExportMediaCache* self) {
#line 2273 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
	Block9Data* _data9_;
#line 663 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 2278 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_data9_->queue = (GeeQueue*) gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	{
#line 666 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (self->priv->db, &_inner_error_);
#line 2287 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch10_rygel_database_error;
			}
			block9_data_unref (_data9_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 667 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, "DROP TRIGGER IF EXISTS trgr_delete_children", NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2299 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch10_rygel_database_error;
			}
			block9_data_unref (_data9_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 668 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_CLOSURE_TABLE, NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2311 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch10_rygel_database_error;
			}
			block9_data_unref (_data9_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 670 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, "ALTER TABLE Object RENAME TO _Object", NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2323 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch10_rygel_database_error;
			}
			block9_data_unref (_data9_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 671 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, "CREATE TABLE Object AS SELECT * FROM _Object", NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2335 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch10_rygel_database_error;
			}
			block9_data_unref (_data9_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 672 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, "DELETE FROM Object", NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2347 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch10_rygel_database_error;
			}
			block9_data_unref (_data9_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 673 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_CLOSURE_TRIGGER_STRING, NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2359 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch10_rygel_database_error;
			}
			block9_data_unref (_data9_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 674 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, "INSERT INTO _Object (upnp_id, type_fk, title, " "timestamp) VALUES ('0', 0, 'Root', 0)", NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2371 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch10_rygel_database_error;
			}
			block9_data_unref (_data9_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 676 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, "INSERT INTO Object (upnp_id, type_fk, title, " "timestamp) VALUES ('0', 0, 'Root', 0)", NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2383 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch10_rygel_database_error;
			}
			block9_data_unref (_data9_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 679 "rygel-media-export-media-cache.vala"
		gee_queue_offer (_data9_->queue, "0");
#line 680 "rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 2397 "rygel-media-export-media-cache.c"
			GValue* _tmp2_;
			gint _args_size_;
			gint args_length1;
			GValue* _tmp1_ = NULL;
			GValue _tmp0_ = {0};
			GValue* args;
#line 680 "rygel-media-export-media-cache.vala"
			if (!(!gee_collection_get_is_empty ((GeeCollection*) _data9_->queue))) {
#line 680 "rygel-media-export-media-cache.vala"
				break;
#line 2408 "rygel-media-export-media-cache.c"
			}
			args = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_take_string (&_tmp0_, (char*) gee_queue_poll (_data9_->queue)), _tmp0_), _tmp1_), args_length1 = 1, _args_size_ = args_length1, _tmp2_);
#line 682 "rygel-media-export-media-cache.vala"
			rygel_media_export_database_exec (self->priv->db, "SELECT upnp_id FROM _Object WHERE parent = ?", args, args_length1, __lambda8__rygel_media_export_database_row_callback, _data9_, NULL, &_inner_error_);
#line 2413 "rygel-media-export-media-cache.c"
			if (_inner_error_ != NULL) {
				args = (_vala_GValue_array_free (args, args_length1), NULL);
				if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
					goto __catch10_rygel_database_error;
				}
				args = (_vala_GValue_array_free (args, args_length1), NULL);
				block9_data_unref (_data9_);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
#line 690 "rygel-media-export-media-cache.vala"
			rygel_media_export_database_exec (self->priv->db, "INSERT INTO Object SELECT * FROM _OBJECT " "WHERE parent = ?", args, args_length1, NULL, NULL, NULL, &_inner_error_);
#line 2427 "rygel-media-export-media-cache.c"
			if (_inner_error_ != NULL) {
				args = (_vala_GValue_array_free (args, args_length1), NULL);
				if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
					goto __catch10_rygel_database_error;
				}
				args = (_vala_GValue_array_free (args, args_length1), NULL);
				block9_data_unref (_data9_);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			args = (_vala_GValue_array_free (args, args_length1), NULL);
		}
#line 694 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, "DROP TABLE Object", NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2443 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch10_rygel_database_error;
			}
			block9_data_unref (_data9_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 695 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, "ALTER TABLE _Object RENAME TO Object", NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2455 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch10_rygel_database_error;
			}
			block9_data_unref (_data9_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 698 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_CLOSURE_TRIGGER_STRING, NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2467 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch10_rygel_database_error;
			}
			block9_data_unref (_data9_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 699 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_INDICES_STRING, NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2479 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch10_rygel_database_error;
			}
			block9_data_unref (_data9_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 700 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, "UPDATE schema_info SET version = '5'", NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2491 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch10_rygel_database_error;
			}
			block9_data_unref (_data9_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 701 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (self->priv->db, &_inner_error_);
#line 2503 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch10_rygel_database_error;
			}
			block9_data_unref (_data9_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 702 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, "VACUUM", NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2515 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch10_rygel_database_error;
			}
			block9_data_unref (_data9_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 703 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_analyze (self->priv->db);
#line 2527 "rygel-media-export-media-cache.c"
	}
	goto __finally10;
	__catch10_rygel_database_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			RygelMediaExportDatabase* _tmp3_;
#line 705 "rygel-media-export-media-cache.vala"
			rygel_media_export_database_rollback (self->priv->db);
#line 706 "rygel-media-export-media-cache.vala"
			g_warning ("rygel-media-export-media-cache.vala:706: Database upgrade failed: %s", err->message);
#line 707 "rygel-media-export-media-cache.vala"
			self->priv->db = (_tmp3_ = NULL, _g_object_unref0 (self->priv->db), _tmp3_);
#line 2543 "rygel-media-export-media-cache.c"
			_g_error_free0 (err);
		}
	}
	__finally10:
	if (_inner_error_ != NULL) {
		block9_data_unref (_data9_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	block9_data_unref (_data9_);
}


#line 711 "rygel-media-export-media-cache.vala"
static void rygel_media_export_media_cache_update_object_internal (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error) {
#line 2560 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
	GValue* _tmp4_;
	gint _values_size_;
	gint values_length1;
	GValue* _tmp3_ = NULL;
	GValue _tmp2_ = {0};
	GValue _tmp1_ = {0};
	GValue _tmp0_ = {0};
	GValue* values;
#line 711 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 711 "rygel-media-export-media-cache.vala"
	g_return_if_fail (object != NULL);
#line 2574 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	values = (_tmp4_ = (_tmp3_ = g_new0 (GValue, 3), _tmp3_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, rygel_media_object_get_title (object)), _tmp0_), _tmp3_[1] = (g_value_init (&_tmp1_, G_TYPE_INT64), g_value_set_int64 (&_tmp1_, (gint64) object->modified), _tmp1_), _tmp3_[2] = (g_value_init (&_tmp2_, G_TYPE_STRING), g_value_set_string (&_tmp2_, object->id), _tmp2_), _tmp3_), values_length1 = 3, _values_size_ = values_length1, _tmp4_);
#line 715 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPDATE_OBJECT_STRING, values, values_length1, NULL, NULL, NULL, &_inner_error_);
#line 2579 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


#line 718 "rygel-media-export-media-cache.vala"
static void rygel_media_export_media_cache_remove_uris (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error) {
#line 2591 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
	GValue* _tmp2_;
	gint _values_size_;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
#line 718 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 718 "rygel-media-export-media-cache.vala"
	g_return_if_fail (object != NULL);
#line 2603 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, object->id), _tmp0_), _tmp1_), values_length1 = 1, _values_size_ = values_length1, _tmp2_);
#line 720 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_DELETE_URI_STRING, values, values_length1, NULL, NULL, NULL, &_inner_error_);
#line 2608 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


#line 723 "rygel-media-export-media-cache.vala"
static void rygel_media_export_media_cache_save_metadata (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error) {
#line 2620 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
	GValue* _tmp17_;
	gint _values_size_;
	gint values_length1;
	GValue* _tmp16_ = NULL;
	GValue _tmp15_ = {0};
	GValue _tmp14_ = {0};
	GValue _tmp13_ = {0};
	GValue _tmp12_ = {0};
	GValue _tmp11_ = {0};
	GValue _tmp10_ = {0};
	GValue _tmp9_ = {0};
	GValue _tmp8_ = {0};
	GValue _tmp7_ = {0};
	GValue _tmp6_ = {0};
	GValue _tmp5_ = {0};
	GValue _tmp4_ = {0};
	GValue _tmp3_ = {0};
	GValue _tmp2_ = {0};
	GValue _tmp1_ = {0};
	GValue _tmp0_ = {0};
	GValue* values;
#line 723 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 723 "rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 2647 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	values = (_tmp17_ = (_tmp16_ = g_new0 (GValue, 16), _tmp16_[0] = (g_value_init (&_tmp0_, G_TYPE_LONG), g_value_set_long (&_tmp0_, item->size), _tmp0_), _tmp16_[1] = (g_value_init (&_tmp1_, G_TYPE_STRING), g_value_set_string (&_tmp1_, item->mime_type), _tmp1_), _tmp16_[2] = (g_value_init (&_tmp2_, G_TYPE_INT), g_value_set_int (&_tmp2_, item->width), _tmp2_), _tmp16_[3] = (g_value_init (&_tmp3_, G_TYPE_INT), g_value_set_int (&_tmp3_, item->height), _tmp3_), _tmp16_[4] = (g_value_init (&_tmp4_, G_TYPE_STRING), g_value_set_string (&_tmp4_, ((RygelMediaObject*) item)->upnp_class), _tmp4_), _tmp16_[5] = (g_value_init (&_tmp5_, G_TYPE_STRING), g_value_set_string (&_tmp5_, item->author), _tmp5_), _tmp16_[6] = (g_value_init (&_tmp6_, G_TYPE_STRING), g_value_set_string (&_tmp6_, item->album), _tmp6_), _tmp16_[7] = (g_value_init (&_tmp7_, G_TYPE_STRING), g_value_set_string (&_tmp7_, item->date), _tmp7_), _tmp16_[8] = (g_value_init (&_tmp8_, G_TYPE_INT), g_value_set_int (&_tmp8_, item->bitrate), _tmp8_), _tmp16_[9] = (g_value_init (&_tmp9_, G_TYPE_INT), g_value_set_int (&_tmp9_, item->sample_freq), _tmp9_), _tmp16_[10] = (g_value_init (&_tmp10_, G_TYPE_INT), g_value_set_int (&_tmp10_, item->bits_per_sample), _tmp10_), _tmp16_[11] = (g_value_init (&_tmp11_, G_TYPE_INT), g_value_set_int (&_tmp11_, item->n_audio_channels), _tmp11_), _tmp16_[12] = (g_value_init (&_tmp12_, G_TYPE_INT), g_value_set_int (&_tmp12_, item->track_number), _tmp12_), _tmp16_[13] = (g_value_init (&_tmp13_, G_TYPE_INT), g_value_set_int (&_tmp13_, item->color_depth), _tmp13_), _tmp16_[14] = (g_value_init (&_tmp14_, G_TYPE_LONG), g_value_set_long (&_tmp14_, item->duration), _tmp14_), _tmp16_[15] = (g_value_init (&_tmp15_, G_TYPE_STRING), g_value_set_string (&_tmp15_, ((RygelMediaObject*) item)->id), _tmp15_), _tmp16_), values_length1 = 16, _values_size_ = values_length1, _tmp17_);
#line 740 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_SAVE_META_DATA_STRING, values, values_length1, NULL, NULL, NULL, &_inner_error_);
#line 2652 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


#line 743 "rygel-media-export-media-cache.vala"
static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self, RygelMediaObject* item, GError** error) {
#line 2664 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
	gint type;
	GValue parent = {0};
	GValue* _tmp10_;
	gint _values_size_;
	gint values_length1;
	GValue* _tmp9_ = NULL;
	GValue _tmp8_ = {0};
	GValue _tmp7_ = {0};
	GValue _tmp6_ = {0};
	GValue _tmp5_ = {0};
	GValue _tmp4_ = {0};
	GValue* values;
#line 743 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 743 "rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 2682 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 744 "rygel-media-export-media-cache.vala"
	type = (gint) RYGEL_MEDIA_DB_OBJECT_TYPE_CONTAINER;
#line 747 "rygel-media-export-media-cache.vala"
	if (RYGEL_IS_MEDIA_ITEM (item)) {
#line 748 "rygel-media-export-media-cache.vala"
		type = (gint) RYGEL_MEDIA_DB_OBJECT_TYPE_ITEM;
#line 2690 "rygel-media-export-media-cache.c"
	}
#line 751 "rygel-media-export-media-cache.vala"
	if (item->parent == NULL) {
#line 2694 "rygel-media-export-media-cache.c"
		GValue _tmp1_;
		GValue _tmp0_ = {0};
#line 752 "rygel-media-export-media-cache.vala"
		parent = (_tmp1_ = (rygel_media_export_database_null (&_tmp0_), _tmp0_), G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL, _tmp1_);
#line 2699 "rygel-media-export-media-cache.c"
	} else {
		GValue _tmp3_;
		GValue _tmp2_ = {0};
#line 754 "rygel-media-export-media-cache.vala"
		parent = (_tmp3_ = (g_value_init (&_tmp2_, G_TYPE_STRING), g_value_set_string (&_tmp2_, ((RygelMediaObject*) item->parent)->id), _tmp2_), G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL, _tmp3_);
#line 2705 "rygel-media-export-media-cache.c"
	}
	values = (_tmp10_ = (_tmp9_ = g_new0 (GValue, 5), _tmp9_[0] = (g_value_init (&_tmp4_, G_TYPE_STRING), g_value_set_string (&_tmp4_, item->id), _tmp4_), _tmp9_[1] = (g_value_init (&_tmp5_, G_TYPE_STRING), g_value_set_string (&_tmp5_, rygel_media_object_get_title (item)), _tmp5_), _tmp9_[2] = (g_value_init (&_tmp6_, G_TYPE_INT), g_value_set_int (&_tmp6_, type), _tmp6_), _tmp9_[3] = G_IS_VALUE (&parent) ? (g_value_init (&_tmp7_, G_VALUE_TYPE (&parent)), g_value_copy (&parent, &_tmp7_), _tmp7_) : parent, _tmp9_[4] = (g_value_init (&_tmp8_, G_TYPE_INT64), g_value_set_int64 (&_tmp8_, (gint64) item->modified), _tmp8_), _tmp9_), values_length1 = 5, _values_size_ = values_length1, _tmp10_);
#line 762 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_INSERT_OBJECT_STRING, values, values_length1, NULL, NULL, NULL, &_inner_error_);
#line 2710 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


#line 765 "rygel-media-export-media-cache.vala"
static void rygel_media_export_media_cache_save_uris (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error) {
#line 2724 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
#line 765 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 765 "rygel-media-export-media-cache.vala"
	g_return_if_fail (object != NULL);
#line 2730 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	{
		GeeIterator* _uri_it;
		_uri_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) object->uris);
#line 766 "rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 2737 "rygel-media-export-media-cache.c"
			char* uri;
			GValue* _tmp3_;
			gint _values_size_;
			gint values_length1;
			GValue* _tmp2_ = NULL;
			GValue _tmp1_ = {0};
			GValue _tmp0_ = {0};
			GValue* values;
#line 766 "rygel-media-export-media-cache.vala"
			if (!gee_iterator_next (_uri_it)) {
#line 766 "rygel-media-export-media-cache.vala"
				break;
#line 2750 "rygel-media-export-media-cache.c"
			}
#line 766 "rygel-media-export-media-cache.vala"
			uri = (char*) gee_iterator_get (_uri_it);
#line 2754 "rygel-media-export-media-cache.c"
			values = (_tmp3_ = (_tmp2_ = g_new0 (GValue, 2), _tmp2_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, object->id), _tmp0_), _tmp2_[1] = (g_value_init (&_tmp1_, G_TYPE_STRING), g_value_set_string (&_tmp1_, uri), _tmp1_), _tmp2_), values_length1 = 2, _values_size_ = values_length1, _tmp3_);
#line 768 "rygel-media-export-media-cache.vala"
			rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_INSERT_URI_STRING, values, values_length1, NULL, NULL, NULL, &_inner_error_);
#line 2758 "rygel-media-export-media-cache.c"
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (uri);
				values = (_vala_GValue_array_free (values, values_length1), NULL);
				_g_object_unref0 (_uri_it);
				return;
			}
			_g_free0 (uri);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
		}
		_g_object_unref0 (_uri_it);
	}
}


#line 780 "rygel-media-export-media-cache.vala"
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self) {
#line 2776 "rygel-media-export-media-cache.c"
	gboolean result = FALSE;
	GError * _inner_error_;
#line 780 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2781 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	{
#line 782 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (self->priv->db, &_inner_error_);
#line 2786 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
#line 783 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_SCHEMA_STRING, NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2792 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
#line 784 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_TRIGGER_STRING, NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2798 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
#line 785 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_CLOSURE_TABLE, NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2804 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
#line 786 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_INDICES_STRING, NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2810 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
#line 787 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CREATE_CLOSURE_TRIGGER_STRING, NULL, 0, NULL, NULL, NULL, &_inner_error_);
#line 2816 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
#line 788 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (self->priv->db, &_inner_error_);
#line 2822 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
#line 789 "rygel-media-export-media-cache.vala"
		rygel_media_export_database_analyze (self->priv->db);
#line 2828 "rygel-media-export-media-cache.c"
		result = TRUE;
#line 791 "rygel-media-export-media-cache.vala"
		return result;
#line 2832 "rygel-media-export-media-cache.c"
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 793 "rygel-media-export-media-cache.vala"
			g_warning ("rygel-media-export-media-cache.vala:793: Failed to create schema: %s", err->message);
#line 794 "rygel-media-export-media-cache.vala"
			rygel_media_export_database_rollback (self->priv->db);
#line 2845 "rygel-media-export-media-cache.c"
			_g_error_free0 (err);
		}
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
#line 797 "rygel-media-export-media-cache.vala"
	return result;
#line 2858 "rygel-media-export-media-cache.c"
}


#line 804 "rygel-media-export-media-cache.vala"
static gboolean _lambda1_ (sqlite3_stmt* statement, Block10Data* _data10_) {
#line 2864 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	self = _data10_->self;
#line 804 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 805 "rygel-media-export-media-cache.vala"
	if (RYGEL_IS_MEDIA_ITEM (_data10_->object)) {
#line 2872 "rygel-media-export-media-cache.c"
		RygelMediaObject* _tmp0_;
		RygelMediaItem* item;
#line 806 "rygel-media-export-media-cache.vala"
		item = _g_object_ref0 ((_tmp0_ = _data10_->object, RYGEL_IS_MEDIA_ITEM (_tmp0_) ? ((RygelMediaItem*) _tmp0_) : NULL));
#line 807 "rygel-media-export-media-cache.vala"
		rygel_media_item_add_uri (item, sqlite3_column_text (statement, 0), NULL);
#line 2879 "rygel-media-export-media-cache.c"
		_g_object_unref0 (item);
	} else {
#line 809 "rygel-media-export-media-cache.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _data10_->object->uris, sqlite3_column_text (statement, 0));
#line 2884 "rygel-media-export-media-cache.c"
	}
	result = TRUE;
#line 812 "rygel-media-export-media-cache.vala"
	return result;
#line 2889 "rygel-media-export-media-cache.c"
}


#line 804 "rygel-media-export-media-cache.vala"
static gboolean __lambda1__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 2895 "rygel-media-export-media-cache.c"
	return _lambda1_ (stmt, self);
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	++_data10_->_ref_count_;
	return _data10_;
}


static void block10_data_unref (Block10Data* _data10_) {
	if ((--_data10_->_ref_count_) == 0) {
		_g_object_unref0 (_data10_->self);
		_g_object_unref0 (_data10_->object);
		g_slice_free (Block10Data, _data10_);
	}
}


#line 800 "rygel-media-export-media-cache.vala"
static void rygel_media_export_media_cache_add_uris (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error) {
#line 2917 "rygel-media-export-media-cache.c"
	GError * _inner_error_;
	Block10Data* _data10_;
	GValue* _tmp2_;
	gint _values_size_;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
#line 800 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 800 "rygel-media-export-media-cache.vala"
	g_return_if_fail (object != NULL);
#line 2930 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_data10_->object = _g_object_ref0 (object);
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, _data10_->object->id), _tmp0_), _tmp1_), values_length1 = 1, _values_size_ = values_length1, _tmp2_);
#line 802 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_URI_GET_STRING, values, values_length1, __lambda1__rygel_media_export_database_row_callback, _data10_, NULL, &_inner_error_);
#line 2939 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block10_data_unref (_data10_);
			return;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block10_data_unref (_data10_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block10_data_unref (_data10_);
}


#line 816 "rygel-media-export-media-cache.vala"
static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self, RygelMediaContainer* parent, const char* object_id, sqlite3_stmt* statement) {
#line 2961 "rygel-media-export-media-cache.c"
	RygelMediaObject* result = NULL;
	GError * _inner_error_;
	RygelMediaObject* object;
#line 816 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 816 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (object_id != NULL, NULL);
#line 816 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, NULL);
#line 2971 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 819 "rygel-media-export-media-cache.vala"
	object = NULL;
#line 820 "rygel-media-export-media-cache.vala"
	switch (sqlite3_column_int (statement, 0)) {
#line 2977 "rygel-media-export-media-cache.c"
		case 0:
		{
			RygelMediaObject* _tmp0_;
#line 823 "rygel-media-export-media-cache.vala"
			object = (_tmp0_ = (RygelMediaObject*) rygel_media_export_db_object_factory_get_container (self->priv->factory, self, object_id, sqlite3_column_text (statement, 1), (guint) 0), _g_object_unref0 (object), _tmp0_);
#line 827 "rygel-media-export-media-cache.vala"
			break;
#line 2985 "rygel-media-export-media-cache.c"
		}
		case 1:
		{
			RygelMediaObject* _tmp1_;
			RygelMediaObject* _tmp2_;
#line 830 "rygel-media-export-media-cache.vala"
			object = (_tmp1_ = (RygelMediaObject*) rygel_media_export_db_object_factory_get_item (self->priv->factory, self, parent, object_id, sqlite3_column_text (statement, 1), sqlite3_column_text (statement, 6)), _g_object_unref0 (object), _tmp1_);
#line 835 "rygel-media-export-media-cache.vala"
			rygel_media_export_media_cache_fill_item (self, statement, (_tmp2_ = object, RYGEL_IS_MEDIA_ITEM (_tmp2_) ? ((RygelMediaItem*) _tmp2_) : NULL));
#line 836 "rygel-media-export-media-cache.vala"
			break;
#line 2997 "rygel-media-export-media-cache.c"
		}
		default:
		{
#line 838 "rygel-media-export-media-cache.vala"
			g_assert_not_reached ();
#line 3003 "rygel-media-export-media-cache.c"
		}
	}
	{
#line 842 "rygel-media-export-media-cache.vala"
		if (object != NULL) {
#line 843 "rygel-media-export-media-cache.vala"
			object->modified = (guint64) sqlite3_column_int64 (statement, 18);
#line 844 "rygel-media-export-media-cache.vala"
			rygel_media_export_media_cache_add_uris (self, object, &_inner_error_);
#line 3013 "rygel-media-export-media-cache.c"
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
					goto __catch12_rygel_database_error;
				}
				_g_object_unref0 (object);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	goto __finally12;
	__catch12_rygel_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			RygelMediaObject* _tmp3_;
#line 847 "rygel-media-export-media-cache.vala"
			g_warning ("rygel-media-export-media-cache.vala:847: Failed to load uris from data" \
"base: %s", _error_->message);
#line 848 "rygel-media-export-media-cache.vala"
			object = (_tmp3_ = NULL, _g_object_unref0 (object), _tmp3_);
#line 3037 "rygel-media-export-media-cache.c"
			_g_error_free0 (_error_);
		}
	}
	__finally12:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (object);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = object;
#line 850 "rygel-media-export-media-cache.vala"
	return result;
#line 3051 "rygel-media-export-media-cache.c"
}


#line 853 "rygel-media-export-media-cache.vala"
static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self, sqlite3_stmt* statement, RygelMediaItem* item) {
#line 3057 "rygel-media-export-media-cache.c"
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
#line 853 "rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 853 "rygel-media-export-media-cache.vala"
	g_return_if_fail (statement != NULL);
#line 853 "rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 854 "rygel-media-export-media-cache.vala"
	item->author = (_tmp0_ = g_strdup (sqlite3_column_text (statement, 7)), _g_free0 (item->author), _tmp0_);
#line 855 "rygel-media-export-media-cache.vala"
	item->album = (_tmp1_ = g_strdup (sqlite3_column_text (statement, 8)), _g_free0 (item->album), _tmp1_);
#line 856 "rygel-media-export-media-cache.vala"
	item->date = (_tmp2_ = g_strdup (sqlite3_column_text (statement, 9)), _g_free0 (item->date), _tmp2_);
#line 857 "rygel-media-export-media-cache.vala"
	item->mime_type = (_tmp3_ = g_strdup (sqlite3_column_text (statement, 3)), _g_free0 (item->mime_type), _tmp3_);
#line 858 "rygel-media-export-media-cache.vala"
	item->duration = (glong) sqlite3_column_int64 (statement, 16);
#line 860 "rygel-media-export-media-cache.vala"
	item->size = (glong) sqlite3_column_int64 (statement, 2);
#line 861 "rygel-media-export-media-cache.vala"
	item->bitrate = sqlite3_column_int (statement, 10);
#line 863 "rygel-media-export-media-cache.vala"
	item->sample_freq = sqlite3_column_int (statement, 11);
#line 864 "rygel-media-export-media-cache.vala"
	item->bits_per_sample = sqlite3_column_int (statement, 12);
#line 865 "rygel-media-export-media-cache.vala"
	item->n_audio_channels = sqlite3_column_int (statement, 13);
#line 866 "rygel-media-export-media-cache.vala"
	item->track_number = sqlite3_column_int (statement, 14);
#line 868 "rygel-media-export-media-cache.vala"
	item->width = sqlite3_column_int (statement, 4);
#line 869 "rygel-media-export-media-cache.vala"
	item->height = sqlite3_column_int (statement, 5);
#line 870 "rygel-media-export-media-cache.vala"
	item->color_depth = sqlite3_column_int (statement, 15);
#line 3096 "rygel-media-export-media-cache.c"
}


#line 880 "rygel-media-export-media-cache.vala"
static gboolean _lambda10_ (sqlite3_stmt* statement, Block11Data* _data11_) {
#line 3102 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	self = _data11_->self;
#line 880 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 881 "rygel-media-export-media-cache.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data11_->children, sqlite3_column_text (statement, 0));
#line 3110 "rygel-media-export-media-cache.c"
	result = TRUE;
#line 883 "rygel-media-export-media-cache.vala"
	return result;
#line 3114 "rygel-media-export-media-cache.c"
}


#line 880 "rygel-media-export-media-cache.vala"
static gboolean __lambda10__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 3120 "rygel-media-export-media-cache.c"
	return _lambda10_ (stmt, self);
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	++_data11_->_ref_count_;
	return _data11_;
}


static void block11_data_unref (Block11Data* _data11_) {
	if ((--_data11_->_ref_count_) == 0) {
		_g_object_unref0 (_data11_->self);
		_g_object_unref0 (_data11_->children);
		g_slice_free (Block11Data, _data11_);
	}
}


#line 873 "rygel-media-export-media-cache.vala"
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const char* container_id, GError** error) {
#line 3142 "rygel-media-export-media-cache.c"
	GeeArrayList* result = NULL;
	GError * _inner_error_;
	Block11Data* _data11_;
	GValue* _tmp2_;
	gint _values_size_;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
#line 873 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 873 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 3156 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_data11_->children = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, container_id), _tmp0_), _tmp1_), values_length1 = 1, _values_size_ = values_length1, _tmp2_);
#line 878 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CHILD_ID_STRING, values, values_length1, __lambda10__rygel_media_export_database_row_callback, _data11_, NULL, &_inner_error_);
#line 3165 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block11_data_unref (_data11_);
			return NULL;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block11_data_unref (_data11_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _g_object_ref0 (_data11_->children);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block11_data_unref (_data11_);
#line 886 "rygel-media-export-media-cache.vala"
	return result;
#line 3185 "rygel-media-export-media-cache.c"
}


#line 889 "rygel-media-export-media-cache.vala"
static char* rygel_media_export_media_cache_search_expression_to_sql (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, GValueArray* args, GError** error) {
#line 3191 "rygel-media-export-media-cache.c"
	char* result = NULL;
	GError * _inner_error_;
#line 889 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 889 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 3198 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 892 "rygel-media-export-media-cache.vala"
	if (expression == NULL) {
#line 3202 "rygel-media-export-media-cache.c"
		result = NULL;
#line 893 "rygel-media-export-media-cache.vala"
		return result;
#line 3206 "rygel-media-export-media-cache.c"
	}
#line 896 "rygel-media-export-media-cache.vala"
	if (RYGEL_IS_LOGICAL_EXPRESSION (expression)) {
#line 3210 "rygel-media-export-media-cache.c"
		RygelSearchExpression* _tmp0_;
		char* _tmp1_;
#line 897 "rygel-media-export-media-cache.vala"
		_tmp1_ = rygel_media_export_media_cache_logical_expression_to_sql (self, (_tmp0_ = expression, RYGEL_IS_LOGICAL_EXPRESSION (_tmp0_) ? ((RygelLogicalExpression*) _tmp0_) : NULL), args, &_inner_error_);
#line 3215 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		result = _tmp1_;
#line 897 "rygel-media-export-media-cache.vala"
		return result;
#line 3223 "rygel-media-export-media-cache.c"
	} else {
		RygelSearchExpression* _tmp2_;
		char* _tmp3_;
#line 900 "rygel-media-export-media-cache.vala"
		_tmp3_ = rygel_media_export_media_cache_relational_expression_to_sql (self, (_tmp2_ = expression, RYGEL_IS_RELATIONAL_EXPRESSION (_tmp2_) ? ((RygelRelationalExpression*) _tmp2_) : NULL), args, &_inner_error_);
#line 3229 "rygel-media-export-media-cache.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		result = _tmp3_;
#line 900 "rygel-media-export-media-cache.vala"
		return result;
#line 3237 "rygel-media-export-media-cache.c"
	}
}


#line 906 "rygel-media-export-media-cache.vala"
static char* rygel_media_export_media_cache_logical_expression_to_sql (RygelMediaExportMediaCache* self, RygelLogicalExpression* expression, GValueArray* args, GError** error) {
#line 3244 "rygel-media-export-media-cache.c"
	char* result = NULL;
	GError * _inner_error_;
	char* left_sql_string;
	char* right_sql_string;
	char* operator_sql_string;
#line 906 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 906 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 3254 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 909 "rygel-media-export-media-cache.vala"
	left_sql_string = rygel_media_export_media_cache_search_expression_to_sql (self, (RygelSearchExpression*) ((RygelSearchExpression*) expression)->operand1, args, &_inner_error_);
#line 3258 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 911 "rygel-media-export-media-cache.vala"
	right_sql_string = rygel_media_export_media_cache_search_expression_to_sql (self, (RygelSearchExpression*) ((RygelSearchExpression*) expression)->operand2, args, &_inner_error_);
#line 3265 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (left_sql_string);
		return NULL;
	}
#line 913 "rygel-media-export-media-cache.vala"
	operator_sql_string = g_strdup ("OR");
#line 915 "rygel-media-export-media-cache.vala"
	if (GPOINTER_TO_INT (((RygelSearchExpression*) expression)->op) == RYGEL_LOGICAL_OPERATOR_AND) {
#line 3275 "rygel-media-export-media-cache.c"
		char* _tmp0_;
#line 916 "rygel-media-export-media-cache.vala"
		operator_sql_string = (_tmp0_ = g_strdup ("AND"), _g_free0 (operator_sql_string), _tmp0_);
#line 3279 "rygel-media-export-media-cache.c"
	}
	result = g_strdup_printf ("(%s %s %s)", left_sql_string, operator_sql_string, right_sql_string);
	_g_free0 (left_sql_string);
	_g_free0 (right_sql_string);
	_g_free0 (operator_sql_string);
#line 919 "rygel-media-export-media-cache.vala"
	return result;
#line 3287 "rygel-media-export-media-cache.c"
}


#line 924 "rygel-media-export-media-cache.vala"
static char* rygel_media_export_media_cache_map_operand_to_column (RygelMediaExportMediaCache* self, const char* operand, GError** error) {
#line 3293 "rygel-media-export-media-cache.c"
	char* result = NULL;
	GError * _inner_error_;
	char* column;
	GQuark _tmp9_;
	const char* _tmp8_;
	static GQuark _tmp9__label0 = 0;
	static GQuark _tmp9__label1 = 0;
	static GQuark _tmp9__label2 = 0;
	static GQuark _tmp9__label3 = 0;
	static GQuark _tmp9__label4 = 0;
	static GQuark _tmp9__label5 = 0;
	static GQuark _tmp9__label6 = 0;
	static GQuark _tmp9__label7 = 0;
	static GQuark _tmp9__label8 = 0;
#line 924 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 924 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (operand != NULL, NULL);
#line 3312 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 925 "rygel-media-export-media-cache.vala"
	column = NULL;
#line 3316 "rygel-media-export-media-cache.c"
	_tmp8_ = operand;
	_tmp9_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
	if (_tmp9_ == ((0 != _tmp9__label0) ? _tmp9__label0 : (_tmp9__label0 = g_quark_from_static_string ("res"))))
	switch (0) {
		default:
		{
			char* _tmp0_;
#line 929 "rygel-media-export-media-cache.vala"
			column = (_tmp0_ = g_strdup ("u.uri"), _g_free0 (column), _tmp0_);
#line 930 "rygel-media-export-media-cache.vala"
			break;
#line 3328 "rygel-media-export-media-cache.c"
		}
	} else if (_tmp9_ == ((0 != _tmp9__label1) ? _tmp9__label1 : (_tmp9__label1 = g_quark_from_static_string ("@id"))))
	switch (0) {
		default:
		{
			char* _tmp1_;
#line 932 "rygel-media-export-media-cache.vala"
			column = (_tmp1_ = g_strdup ("o.upnp_id"), _g_free0 (column), _tmp1_);
#line 933 "rygel-media-export-media-cache.vala"
			break;
#line 3339 "rygel-media-export-media-cache.c"
		}
	} else if (_tmp9_ == ((0 != _tmp9__label2) ? _tmp9__label2 : (_tmp9__label2 = g_quark_from_static_string ("@parentID"))))
	switch (0) {
		default:
		{
			char* _tmp2_;
#line 935 "rygel-media-export-media-cache.vala"
			column = (_tmp2_ = g_strdup ("o.parent"), _g_free0 (column), _tmp2_);
#line 936 "rygel-media-export-media-cache.vala"
			break;
#line 3350 "rygel-media-export-media-cache.c"
		}
	} else if (_tmp9_ == ((0 != _tmp9__label3) ? _tmp9__label3 : (_tmp9__label3 = g_quark_from_static_string ("upnp:class"))))
	switch (0) {
		default:
		{
			char* _tmp3_;
#line 938 "rygel-media-export-media-cache.vala"
			column = (_tmp3_ = g_strdup ("m.class"), _g_free0 (column), _tmp3_);
#line 939 "rygel-media-export-media-cache.vala"
			break;
#line 3361 "rygel-media-export-media-cache.c"
		}
	} else if (_tmp9_ == ((0 != _tmp9__label4) ? _tmp9__label4 : (_tmp9__label4 = g_quark_from_static_string ("dc:title"))))
	switch (0) {
		default:
		{
			char* _tmp4_;
#line 941 "rygel-media-export-media-cache.vala"
			column = (_tmp4_ = g_strdup ("o.title"), _g_free0 (column), _tmp4_);
#line 942 "rygel-media-export-media-cache.vala"
			break;
#line 3372 "rygel-media-export-media-cache.c"
		}
	} else if ((_tmp9_ == ((0 != _tmp9__label5) ? _tmp9__label5 : (_tmp9__label5 = g_quark_from_static_string ("upnp:artist")))) || (_tmp9_ == ((0 != _tmp9__label6) ? _tmp9__label6 : (_tmp9__label6 = g_quark_from_static_string ("dc:creator")))))
	switch (0) {
		default:
		{
			char* _tmp5_;
#line 945 "rygel-media-export-media-cache.vala"
			column = (_tmp5_ = g_strdup ("m.author"), _g_free0 (column), _tmp5_);
#line 946 "rygel-media-export-media-cache.vala"
			break;
#line 3383 "rygel-media-export-media-cache.c"
		}
	} else if (_tmp9_ == ((0 != _tmp9__label7) ? _tmp9__label7 : (_tmp9__label7 = g_quark_from_static_string ("dc:date"))))
	switch (0) {
		default:
		{
			char* _tmp6_;
#line 948 "rygel-media-export-media-cache.vala"
			column = (_tmp6_ = g_strdup ("m.date"), _g_free0 (column), _tmp6_);
#line 949 "rygel-media-export-media-cache.vala"
			break;
#line 3394 "rygel-media-export-media-cache.c"
		}
	} else if (_tmp9_ == ((0 != _tmp9__label8) ? _tmp9__label8 : (_tmp9__label8 = g_quark_from_static_string ("upnp:album"))))
	switch (0) {
		default:
		{
			char* _tmp7_;
#line 951 "rygel-media-export-media-cache.vala"
			column = (_tmp7_ = g_strdup ("m.album"), _g_free0 (column), _tmp7_);
#line 952 "rygel-media-export-media-cache.vala"
			break;
#line 3405 "rygel-media-export-media-cache.c"
		}
	} else
	switch (0) {
		default:
		{
			char* message;
#line 954 "rygel-media-export-media-cache.vala"
			message = g_strdup_printf ("Unsupported column %s", operand);
#line 3414 "rygel-media-export-media-cache.c"
			_inner_error_ = g_error_new_literal (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_UNSUPPORTED, message);
			{
				g_propagate_error (error, _inner_error_);
				_g_free0 (message);
				_g_free0 (column);
				return NULL;
			}
		}
	}
	result = column;
#line 959 "rygel-media-export-media-cache.vala"
	return result;
#line 3427 "rygel-media-export-media-cache.c"
}


#line 962 "rygel-media-export-media-cache.vala"
static char* rygel_media_export_media_cache_relational_expression_to_sql (RygelMediaExportMediaCache* self, RygelRelationalExpression* exp, GValueArray* args, GError** error) {
#line 3433 "rygel-media-export-media-cache.c"
	char* result = NULL;
	GError * _inner_error_;
	char* sql_function;
	GValue* v;
	char* column;
#line 962 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 962 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 3443 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 965 "rygel-media-export-media-cache.vala"
	sql_function = NULL;
#line 966 "rygel-media-export-media-cache.vala"
	v = NULL;
#line 968 "rygel-media-export-media-cache.vala"
	column = rygel_media_export_media_cache_map_operand_to_column (self, (const char*) ((RygelSearchExpression*) exp)->operand1, &_inner_error_);
#line 3451 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (sql_function);
		_g_free0 (v);
		return NULL;
	}
#line 970 "rygel-media-export-media-cache.vala"
	switch (GPOINTER_TO_INT (((RygelSearchExpression*) exp)->op)) {
#line 3460 "rygel-media-export-media-cache.c"
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
		{
#line 972 "rygel-media-export-media-cache.vala"
			if (_vala_strcmp0 ((const char*) ((RygelSearchExpression*) exp)->operand2, "true") == 0) {
#line 3465 "rygel-media-export-media-cache.c"
				char* _tmp0_;
#line 973 "rygel-media-export-media-cache.vala"
				sql_function = (_tmp0_ = g_strdup ("IS NOT NULL AND %s != ''"), _g_free0 (sql_function), _tmp0_);
#line 3469 "rygel-media-export-media-cache.c"
			} else {
				char* _tmp1_;
#line 975 "rygel-media-export-media-cache.vala"
				sql_function = (_tmp1_ = g_strdup ("IS NULL OR %s = ''"), _g_free0 (sql_function), _tmp1_);
#line 3474 "rygel-media-export-media-cache.c"
			}
#line 977 "rygel-media-export-media-cache.vala"
			break;
#line 3478 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		{
			char* _tmp2_;
			GValue* _tmp4_;
			GValue* _tmp3_ = NULL;
#line 979 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp2_ = g_strdup ("="), _g_free0 (sql_function), _tmp2_);
#line 980 "rygel-media-export-media-cache.vala"
			v = (_tmp4_ = (_tmp3_ = g_new0 (GValue, 1), g_value_init (_tmp3_, G_TYPE_STRING), g_value_set_string (_tmp3_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp3_), _g_free0 (v), _tmp4_);
#line 981 "rygel-media-export-media-cache.vala"
			break;
#line 3491 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
		{
			char* _tmp5_;
			GValue* _tmp7_;
			GValue* _tmp6_ = NULL;
#line 983 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp5_ = g_strdup ("!="), _g_free0 (sql_function), _tmp5_);
#line 984 "rygel-media-export-media-cache.vala"
			v = (_tmp7_ = (_tmp6_ = g_new0 (GValue, 1), g_value_init (_tmp6_, G_TYPE_STRING), g_value_set_string (_tmp6_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp6_), _g_free0 (v), _tmp7_);
#line 985 "rygel-media-export-media-cache.vala"
			break;
#line 3504 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
		{
			char* _tmp8_;
			GValue* _tmp10_;
			GValue* _tmp9_ = NULL;
#line 987 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp8_ = g_strdup ("<"), _g_free0 (sql_function), _tmp8_);
#line 988 "rygel-media-export-media-cache.vala"
			v = (_tmp10_ = (_tmp9_ = g_new0 (GValue, 1), g_value_init (_tmp9_, G_TYPE_STRING), g_value_set_string (_tmp9_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp9_), _g_free0 (v), _tmp10_);
#line 989 "rygel-media-export-media-cache.vala"
			break;
#line 3517 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
		{
			char* _tmp11_;
			GValue* _tmp13_;
			GValue* _tmp12_ = NULL;
#line 991 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp11_ = g_strdup ("<="), _g_free0 (sql_function), _tmp11_);
#line 992 "rygel-media-export-media-cache.vala"
			v = (_tmp13_ = (_tmp12_ = g_new0 (GValue, 1), g_value_init (_tmp12_, G_TYPE_STRING), g_value_set_string (_tmp12_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp12_), _g_free0 (v), _tmp13_);
#line 993 "rygel-media-export-media-cache.vala"
			break;
#line 3530 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
		{
			char* _tmp14_;
			GValue* _tmp16_;
			GValue* _tmp15_ = NULL;
#line 995 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp14_ = g_strdup (">"), _g_free0 (sql_function), _tmp14_);
#line 996 "rygel-media-export-media-cache.vala"
			v = (_tmp16_ = (_tmp15_ = g_new0 (GValue, 1), g_value_init (_tmp15_, G_TYPE_STRING), g_value_set_string (_tmp15_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp15_), _g_free0 (v), _tmp16_);
#line 997 "rygel-media-export-media-cache.vala"
			break;
#line 3543 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
		{
			char* _tmp17_;
			GValue* _tmp19_;
			GValue* _tmp18_ = NULL;
#line 999 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp17_ = g_strdup (">="), _g_free0 (sql_function), _tmp17_);
#line 1000 "rygel-media-export-media-cache.vala"
			v = (_tmp19_ = (_tmp18_ = g_new0 (GValue, 1), g_value_init (_tmp18_, G_TYPE_STRING), g_value_set_string (_tmp18_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp18_), _g_free0 (v), _tmp19_);
#line 1001 "rygel-media-export-media-cache.vala"
			break;
#line 3556 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			char* _tmp20_;
			GValue* _tmp22_;
			GValue* _tmp21_ = NULL;
#line 1003 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp20_ = g_strdup ("LIKE"), _g_free0 (sql_function), _tmp20_);
#line 1004 "rygel-media-export-media-cache.vala"
			v = (_tmp22_ = (_tmp21_ = g_new0 (GValue, 1), g_value_init (_tmp21_, G_TYPE_STRING), g_value_take_string (_tmp21_, g_strdup_printf ("%%%s%%", (const char*) ((RygelSearchExpression*) exp)->operand2)), _tmp21_), _g_free0 (v), _tmp22_);
#line 1005 "rygel-media-export-media-cache.vala"
			break;
#line 3569 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_DOES_NOT_CONTAIN:
		{
			char* _tmp23_;
			GValue* _tmp25_;
			GValue* _tmp24_ = NULL;
#line 1007 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp23_ = g_strdup ("NOT LIKE"), _g_free0 (sql_function), _tmp23_);
#line 1008 "rygel-media-export-media-cache.vala"
			v = (_tmp25_ = (_tmp24_ = g_new0 (GValue, 1), g_value_init (_tmp24_, G_TYPE_STRING), g_value_take_string (_tmp24_, g_strdup_printf ("%%%s%%", (const char*) ((RygelSearchExpression*) exp)->operand2)), _tmp24_), _g_free0 (v), _tmp25_);
#line 1009 "rygel-media-export-media-cache.vala"
			break;
#line 3582 "rygel-media-export-media-cache.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
		{
			char* _tmp26_;
			GValue* _tmp28_;
			GValue* _tmp27_ = NULL;
#line 1011 "rygel-media-export-media-cache.vala"
			sql_function = (_tmp26_ = g_strdup ("LIKE"), _g_free0 (sql_function), _tmp26_);
#line 1012 "rygel-media-export-media-cache.vala"
			v = (_tmp28_ = (_tmp27_ = g_new0 (GValue, 1), g_value_init (_tmp27_, G_TYPE_STRING), g_value_take_string (_tmp27_, g_strdup_printf ("%s%%", (const char*) ((RygelSearchExpression*) exp)->operand2)), _tmp27_), _g_free0 (v), _tmp28_);
#line 1013 "rygel-media-export-media-cache.vala"
			break;
#line 3595 "rygel-media-export-media-cache.c"
		}
		default:
		{
#line 1015 "rygel-media-export-media-cache.vala"
			g_warning ("rygel-media-export-media-cache.vala:1015: Unsupported op %d", (gint) GPOINTER_TO_INT (((RygelSearchExpression*) exp)->op));
#line 1016 "rygel-media-export-media-cache.vala"
			break;
#line 3603 "rygel-media-export-media-cache.c"
		}
	}
#line 1019 "rygel-media-export-media-cache.vala"
	if (v != NULL) {
#line 1020 "rygel-media-export-media-cache.vala"
		g_value_array_append (args, v);
#line 3610 "rygel-media-export-media-cache.c"
	}
	result = g_strdup_printf ("%s %s ?", column, sql_function);
	_g_free0 (sql_function);
	_g_free0 (v);
	_g_free0 (column);
#line 1023 "rygel-media-export-media-cache.vala"
	return result;
#line 3618 "rygel-media-export-media-cache.c"
}


#line 1039 "rygel-media-export-media-cache.vala"
static gboolean _lambda11_ (sqlite3_stmt* statement, Block12Data* _data12_) {
#line 3624 "rygel-media-export-media-cache.c"
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	self = _data12_->self;
#line 1039 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, FALSE);
#line 1040 "rygel-media-export-media-cache.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data12_->data, sqlite3_column_text (statement, 0));
#line 3632 "rygel-media-export-media-cache.c"
	result = TRUE;
#line 1042 "rygel-media-export-media-cache.vala"
	return result;
#line 3636 "rygel-media-export-media-cache.c"
}


#line 1039 "rygel-media-export-media-cache.vala"
static gboolean __lambda11__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 3642 "rygel-media-export-media-cache.c"
	return _lambda11_ (stmt, self);
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
	++_data12_->_ref_count_;
	return _data12_;
}


static void block12_data_unref (Block12Data* _data12_) {
	if ((--_data12_->_ref_count_) == 0) {
		_g_object_unref0 (_data12_->self);
		_g_object_unref0 (_data12_->data);
		g_slice_free (Block12Data, _data12_);
	}
}


#line 1026 "rygel-media-export-media-cache.vala"
GeeList* rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self, const char* column, const char* filter, GValueArray* args, glong offset, glong max_count, GError** error) {
#line 3664 "rygel-media-export-media-cache.c"
	GeeList* result = NULL;
	GError * _inner_error_;
	Block12Data* _data12_;
	GValue _tmp0_ = {0};
	GValue v;
	GValue _tmp2_;
	GValue _tmp1_ = {0};
	RygelMediaExportDatabaseRowCallback _tmp3_;
	GDestroyNotify callback_target_destroy_notify = NULL;
	void* callback_target = NULL;
	RygelMediaExportDatabaseRowCallback callback;
	char* sql;
#line 1026 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1026 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (column != NULL, NULL);
#line 1026 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (filter != NULL, NULL);
#line 1026 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 3685 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
#line 1033 "rygel-media-export-media-cache.vala"
	v = (g_value_init (&_tmp0_, G_TYPE_LONG), g_value_set_long (&_tmp0_, offset), _tmp0_);
#line 1034 "rygel-media-export-media-cache.vala"
	g_value_array_append (args, &v);
#line 1035 "rygel-media-export-media-cache.vala"
	v = (_tmp2_ = (g_value_init (&_tmp1_, G_TYPE_LONG), g_value_set_long (&_tmp1_, max_count), _tmp1_), G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL, _tmp2_);
#line 1036 "rygel-media-export-media-cache.vala"
	g_value_array_append (args, &v);
#line 3698 "rygel-media-export-media-cache.c"
	_data12_->data = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	callback = (_tmp3_ = __lambda11__rygel_media_export_database_row_callback, callback_target = block12_data_ref (_data12_), callback_target_destroy_notify = block12_data_unref, _tmp3_);
#line 1045 "rygel-media-export-media-cache.vala"
	sql = g_strdup_printf (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_META_DATA_COLUMN_STRING, column, filter, column);
#line 1046 "rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (self->priv->db, sql, args->values, (gint) args->n_values, callback, callback_target, NULL, &_inner_error_);
#line 3705 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
		callback = NULL;
		callback_target = NULL;
		callback_target_destroy_notify = NULL;
		_g_free0 (sql);
		block12_data_unref (_data12_);
		return NULL;
	}
	result = _g_object_ref0 ((GeeList*) _data12_->data);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	_g_free0 (sql);
	block12_data_unref (_data12_);
#line 1048 "rygel-media-export-media-cache.vala"
	return result;
#line 3727 "rygel-media-export-media-cache.c"
}


#line 1051 "rygel-media-export-media-cache.vala"
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const char* attribute, RygelSearchExpression* expression, glong offset, glong max_count, GError** error) {
#line 3733 "rygel-media-export-media-cache.c"
	GeeList* result = NULL;
	GError * _inner_error_;
	GValueArray* args;
	char* filter;
	char* column;
	GeeList* _tmp2_;
#line 1051 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1051 "rygel-media-export-media-cache.vala"
	g_return_val_if_fail (attribute != NULL, NULL);
#line 3744 "rygel-media-export-media-cache.c"
	_inner_error_ = NULL;
#line 1057 "rygel-media-export-media-cache.vala"
	args = g_value_array_new ((guint) 0);
#line 1058 "rygel-media-export-media-cache.vala"
	filter = rygel_media_export_media_cache_search_expression_to_sql (self, expression, args, &_inner_error_);
#line 3750 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		return NULL;
	}
#line 1059 "rygel-media-export-media-cache.vala"
	if (filter != NULL) {
#line 3758 "rygel-media-export-media-cache.c"
		char* _tmp0_;
#line 1060 "rygel-media-export-media-cache.vala"
		filter = (_tmp0_ = g_strdup_printf (" WHERE %s ", filter), _g_free0 (filter), _tmp0_);
#line 3762 "rygel-media-export-media-cache.c"
	} else {
		char* _tmp1_;
#line 1062 "rygel-media-export-media-cache.vala"
		filter = (_tmp1_ = g_strdup (""), _g_free0 (filter), _tmp1_);
#line 3767 "rygel-media-export-media-cache.c"
	}
#line 1065 "rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:1065: Parsed filter: %s", filter);
#line 1067 "rygel-media-export-media-cache.vala"
	column = rygel_media_export_media_cache_map_operand_to_column (self, attribute, &_inner_error_);
#line 3773 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		_g_free0 (filter);
		return NULL;
	}
#line 1069 "rygel-media-export-media-cache.vala"
	_tmp2_ = rygel_media_export_media_cache_get_meta_data_column_by_filter (self, column, filter, args, offset, max_count, &_inner_error_);
#line 3782 "rygel-media-export-media-cache.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		_g_free0 (filter);
		_g_free0 (column);
		return NULL;
	}
	result = _tmp2_;
	_g_value_array_free0 (args);
	_g_free0 (filter);
	_g_free0 (column);
#line 1069 "rygel-media-export-media-cache.vala"
	return result;
#line 3796 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_class_init (RygelMediaExportMediaCacheClass * klass) {
	rygel_media_export_media_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportMediaCachePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_media_cache_finalize;
	g_signal_new ("object_added", RYGEL_TYPE_MEDIA_EXPORT_MEDIA_CACHE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("object_removed", RYGEL_TYPE_MEDIA_EXPORT_MEDIA_CACHE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("object_updated", RYGEL_TYPE_MEDIA_EXPORT_MEDIA_CACHE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("item_removed", RYGEL_TYPE_MEDIA_EXPORT_MEDIA_CACHE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("item_added", RYGEL_TYPE_MEDIA_EXPORT_MEDIA_CACHE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("item_updated", RYGEL_TYPE_MEDIA_EXPORT_MEDIA_CACHE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("container_added", RYGEL_TYPE_MEDIA_EXPORT_MEDIA_CACHE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("container_removed", RYGEL_TYPE_MEDIA_EXPORT_MEDIA_CACHE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("container_updated", RYGEL_TYPE_MEDIA_EXPORT_MEDIA_CACHE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void rygel_media_export_media_cache_instance_init (RygelMediaExportMediaCache * self) {
	self->priv = RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE (self);
}


static void rygel_media_export_media_cache_finalize (GObject* obj) {
	RygelMediaExportMediaCache * self;
	self = RYGEL_MEDIA_EXPORT_MEDIA_CACHE (obj);
	_g_object_unref0 (self->priv->db);
	_g_object_unref0 (self->priv->factory);
	G_OBJECT_CLASS (rygel_media_export_media_cache_parent_class)->finalize (obj);
}


GType rygel_media_export_media_cache_get_type (void) {
	static volatile gsize rygel_media_export_media_cache_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_media_cache_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMediaCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_media_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMediaCache), 0, (GInstanceInitFunc) rygel_media_export_media_cache_instance_init, NULL };
		GType rygel_media_export_media_cache_type_id;
		rygel_media_export_media_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportMediaCache", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_media_cache_type_id__volatile, rygel_media_export_media_cache_type_id);
	}
	return rygel_media_export_media_cache_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




