/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file CProfileTab.hxx
    \author Romain BONDUE
    \date 05/08/2005
    \warning This file should only be included from CProfileTab.h */
inline nsGUI::CProfileTab::operator ::GtkWidget* () throw()
{
    return GTK_WIDGET (m_pHBox);

} // operator ::GTkWidget* ()


inline void nsGUI::CProfileTab::AddProfile
                                (const nsUserData::CProfile& Profile) throw()
{
    SetProfile (CSelectableRowList::GetNbRow(), Profile);

} // AddProfile()


inline int nsGUI::CProfileTab::GetSelectedRow () const throw()
{
    return CSelectableRowList::GetSelectedRow();

} // GetProfile()


inline void nsGUI::CProfileTab::RowSelectedCallBack () throw()
{
    ::gtk_widget_set_sensitive (m_pDeleteButton, true);
    ::gtk_widget_set_sensitive (m_pEditButton, true);
    ::gtk_widget_set_sensitive (m_pApplyButton, true);

} // RowSelectedCallBack()


inline void nsGUI::CProfileTab::RowUnselectedCallBack () throw()
{
    ::gtk_widget_set_sensitive (m_pDeleteButton, false);
    ::gtk_widget_set_sensitive (m_pEditButton, false);
    ::gtk_widget_set_sensitive (m_pApplyButton, false);

} // RowUnselectedCallBack()


inline void nsGUI::CProfileTab::SetSelected (unsigned Pos, bool Value) throw()
{
    SetData (Pos, 0, Value);

} // SetSelected()
