# Code for the GUI interface to RoutePlanner
#
# Copyright (C) 1996-2001 Chris Lawrence
# This file may be freely distributed under the terms of the RoutePlanner
# license.  A copy should appear as 'LICENSE' in the archive that this
# file was included in.

import string
import gtk
import gobject
#from gnome.ui import *

class CityList:
    def __init__(self, wtree):
        self.wtree = wtree
        self.citywin = wtree.get_widget('choosecity')
        self.cityview = wtree.get_widget('citychooser')
        self.cityentry = wtree.get_widget('cityentry')
        self.showallbutton = wtree.get_widget('showall')
        self.visible = []

        self.citystore = gtk.ListStore(gobject.TYPE_PYOBJECT,
                                       gobject.TYPE_STRING)
        renderer = gtk.CellRendererText()
        col = gtk.TreeViewColumn('City', renderer, text=1)
        self.cityview.append_column(col)
        self.cityview.set_model(self.citystore)

        sel = self.cityview.get_selection()
        sel.set_mode(gtk.SELECTION_SINGLE)
        sel.connect("changed", self.on_citychooser_select_row)

        dict = {}
        for key in dir(self.__class__):
            dict[key] = getattr(self, key)
        self.wtree.signal_autoconnect(dict)

    def startup(self, city='', db=None, setfun=None, setdata=None):
        self.db = db
        #self.cities = map(str, db.cities)
        self.cities = db.cities

        # Update the CList
        self.update_citylist()
        if city and city in self.cities:
            cnum = self.cities.index(city)
            sel = self.cityview.get_selection()
            sel.select_path(cnum)
            self.selected = city
            self.selrow = cnum
        else:
            self.selected = self.selrow = None
            self.cityentry.set_text('')
        
        self.citywin.connect("delete_event", self.on_city_cancel_clicked)
        
        if setfun:
            self.callwhendone = (setfun, setdata)
        else:
            self.callwhendone = None

        self.cityentry.grab_focus()
        self.citywin.show()

    def on_citychooser_select_row(self, *args):
        sel = args[0]
        if isinstance(sel, gtk.TreeView):
            sel = sel.get_selection()

        model, it = sel.get_selected()
        if it:
            self.selected = model.get_value(it, 0)
            cityname = model.get_value(it, 1)
            self.cityentry.set_text(cityname)
            path = model.get_path(it)
            self.selrow = path[0]
        else:
            self.selected = self.selrow = None
            self.cityentry.set_text('')

    def on_citychooser_button_press_event(self, button, event, *args):
        if event.type == gtk.gdk._2BUTTON_PRESS and event.button == 1 and \
               self.cityview.get_selection().get_selected():
            self.on_city_ok_clicked()

    def on_cityentry_activate(self, *args):
        text = self.cityentry.get_text().decode('UTF-8')
        matching = self.db.CitiesMatchIndex(text, self.visible)
        if not matching:
            dialog = gtk.MessageDialog(self.citywin, type=gtk.MESSAGE_ERROR,
                                       message_format='No matching cities.',
                                       buttons=gtk.BUTTONS_CLOSE)
            dialog.run()
            dialog.destroy()
            return

        if len(matching) == 1:
            match, lmatch = matching[0], self.visible.index(matching[0])
            sel = self.cityview.get_selection()
            sel.select_path(lmatch)
            self.cityview.scroll_to_cell((lmatch,), None, False, 0.5, 0)
            if text.lower() == unicode(self.cities[match]).lower():
                self.on_city_ok_clicked()
            return

        self.update_citylist(tuple(matching))

    def on_city_ok_clicked(self, *args):
        if not self.selected:
            self.on_cityentry_activate()
            return

        self.citywin.hide()
        if self.callwhendone:
            #print self.selected
            setfun, setdata = self.callwhendone
            setfun(self.selected, self.selrow, setdata)
        self.citystore.clear()

    def on_city_cancel_clicked(self, *args):
        self.citywin.hide()
        self.citystore.clear()
        return True

    def on_city_showall_clicked(self, *args):
        self.update_citylist()

    def update_citylist(self, selected=()):
        if not selected:
            selected = range(len(self.cities))

        self.citystore.clear()

        for i in range(len(selected)):
            sel = selected[i]
            it = self.citystore.append()
            try:
                cityname = unicode(self.cities[sel])
            except:
                print self.cities[sel].city
            
            self.citystore.set(it, 0, self.cities[sel], 1, cityname)
            
        self.visible = list(selected)

        self.showallbutton.set_sensitive(len(selected) != len(self.cities))
