// indent by VIM 
// fieldsel.cpp
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997-1999

#include <qpushbutton.h>
#include <qlabel.h>
#include <qaccel.h>
#include <qcheckbox.h> 
#include <qlayout.h> 
#include "fieldsel.h"

FieldSelect::FieldSelect(Procview *pv, Proc *proc)
            : QDialog(0, "select fields"),
	      nbuttons(proc->allcats.size()),
	      disp_fields(nbuttons),
	      procview(pv)
{
	int half = (nbuttons + 1) / 2;
	updating = FALSE;

	setCaption("Select Custom Fields ");
	QBoxLayout * v_layout = new QVBoxLayout( this,8);
	v_layout->freeze();
	
    QGridLayout *grid=new QGridLayout (half,5,0);
	grid->setColSpacing (2, 40); 
	v_layout->addLayout(grid);

	buts = new QCheckBox*[nbuttons];
	for(int i = 0; i < nbuttons; i++) {
		QCheckBox *but = new QCheckBox(proc->allcats[i]->name, this);
		QLabel *desc = new QLabel(proc->allcats[i]->help, this);

		if(i < half)
		{
			grid->addWidget(but,i,0);
			grid->addWidget(desc,i,1);
		}
		else
		{
			grid->addWidget(but,i-half,3);
			grid->addWidget(desc,i-half,4);
		}
	
		buts[i] = but;
		connect(but, SIGNAL(toggled(bool)), this, SLOT(field_toggled(bool)));
	}
	update_boxes();


	QPushButton *closebut = new QPushButton("Close", this);
    closebut->setFocus();
	connect(closebut, SIGNAL(clicked()), SLOT(closed()));

	v_layout->addWidget(closebut);
	QAccel *acc = new QAccel(this);
	acc->connectItem(acc->insertItem(ALT + Key_W),this, SLOT(closed()));
}

// one of the fields was toggled (we don't know which one yet)
void FieldSelect::field_toggled(bool)
{
	if(updating) return;
	set_disp_fields();
	for(int i = 0; i < nbuttons; i++)
		if(buts[i]->isChecked() != disp_fields.testBit(i))
			if(buts[i]->isChecked())
				emit added_field(i);
			else
				emit removed_field(i);
}

void FieldSelect::closed()
{
    hide();
}

void FieldSelect::closeEvent(QCloseEvent *)
{
	closed();
}

void FieldSelect::set_disp_fields()
{
	disp_fields.fill(FALSE);
	int n = procview->cats.size();
	for(int i = 0; i < n; i++)
		disp_fields.setBit(procview->cats[i]->index);
}

void FieldSelect::update_boxes()
{
	set_disp_fields();
	updating = TRUE;
	for(int i = 0; i < nbuttons; i++)
		buts[i]->setChecked(disp_fields.testBit(i));
	updating = FALSE;
}


