/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "cfgtabpageaccountqbm.h"
#include "cfgtabpageaccountqbm.ui.h"
#include "kbanking.h"
#include "account.h"

#include <aqbanking/account.h>

#include <qcheckbox.h>
#include <qspinbox.h>



CfgTabPageAccountQbm::CfgTabPageAccountQbm(KBanking *ab,
                                           AB_ACCOUNT *a,
                                           QWidget *parent,
                                           const char *name,
                                           WFlags fl)
:QBCfgTabPageAccount(ab, "QBankManager", a, parent, name, fl)
,_banking(ab)
,_account(0)
,_mustAdd(false){
  _account=ab->findAccount(AB_Account_GetBankCode(a),
                           AB_Account_GetAccountNumber(a));
  if (!_account) {
    _account=new Account(ab, a);
    _mustAdd=true;
  }

  setHelpSubject("CfgTabPageAccountQbm");
  setDescription(tr("<p>General account settings of QBankManager.</p>"));

  _realPage=new CfgTabPageAccountQbmUi(this);
  addWidget(_realPage);
  _realPage->show();
}



CfgTabPageAccountQbm::~CfgTabPageAccountQbm() {
  if (_account && _mustAdd)
    delete _account;
}



bool CfgTabPageAccountQbm::fromGui() {
  _account
    ->setOptionUpdateTransactions(_realPage
				  ->updateTransactionsCheck
				  ->isChecked());
  _account
    ->setOptionUpdateBalance(_realPage
			     ->updateBalanceCheck
			     ->isChecked());
  _account
    ->setOptionUpdateStandingOrders(_realPage
				    ->updateStandingOrdersCheck
				    ->isChecked());
  _account
    ->setOptionUpdateDatedTransfers(_realPage
				    ->updateDatedTransfersCheck
				    ->isChecked());
  _account
    ->setOptionUpdatePending(_realPage
			     ->updatePendingCheck
			     ->isChecked());
  _account
    ->setOptionExcludeFromGlobalCall(_realPage
				     ->excludeFromAllCheck
				     ->isChecked());

  /* general page already has updated the user, because it comes before
   * this page. So we can now use the updated data to update our own
   * representation of the account. */
  _account->updateFromBankingAccount(getAccount());

  if (_mustAdd) {
    _banking->addAccount(_account);
    _mustAdd=false;
  }

  return true;
}



bool CfgTabPageAccountQbm::toGui() {
  _realPage
    ->updateTransactionsCheck
    ->setChecked(_account->getOptionUpdateTransactions());
  _realPage
    ->updateBalanceCheck
    ->setChecked(_account->getOptionUpdateBalance());
  _realPage
    ->updateStandingOrdersCheck
    ->setChecked(_account->getOptionUpdateStandingOrders());
  _realPage
    ->updateDatedTransfersCheck
    ->setChecked(_account->getOptionUpdateDatedTransfers());
  _realPage
    ->updatePendingCheck
    ->setChecked(_account->getOptionUpdatePending());
  _realPage
    ->excludeFromAllCheck
    ->setChecked(_account->getOptionExcludeFromGlobalCall());

  return true;
}



bool CfgTabPageAccountQbm::checkGui() {
  _account->setOptionUpdateTransactions(_realPage
                                        ->updateTransactionsCheck
                                        ->isChecked());
  _account->setOptionUpdateBalance(_realPage
                                   ->updateBalanceCheck
                                   ->isChecked());
  _account->setOptionUpdateStandingOrders(_realPage
                                          ->updateStandingOrdersCheck
                                          ->isChecked());
  _account->setOptionUpdateDatedTransfers(_realPage
                                          ->updateDatedTransfersCheck
                                          ->isChecked());
  _account->setOptionUpdatePending(_realPage
                                   ->updatePendingCheck
                                   ->isChecked());
  _account->setOptionExcludeFromGlobalCall(_realPage
                                           ->excludeFromAllCheck
                                           ->isChecked());

  return true;
}







