/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEEDITVARIABLEDIALOG_H
#define QALCULATEEDITVARIABLEDIALOG_H

#include <kdialogbase.h>

class QLabel;
class KComboBox;
class KLineEdit;
class QCheckBox;
class QPushButton;
class MathStructure;
class QalculateEditNamesDialog;
class KnownVariable;
class QGridLayout;

/**
@author Niklas Knutsson
*/
class QalculateEditVariableDialog : public KDialogBase {

	Q_OBJECT

public:

	QalculateEditVariableDialog(QWidget *parent = 0, const char *name = 0);
	virtual ~QalculateEditVariableDialog();

	KnownVariable *editVariable(QString category = QString::null, KnownVariable *v = NULL, MathStructure *initial_value = NULL, bool force_value = false);

	QalculateEditNamesDialog *names_edit_dialog;
	KnownVariable *edited_variable;
	KComboBox *categoryCombo;
	KLineEdit *valueEdit, *nameEdit, *titleEdit;
	QLabel *namesLabel, *titleLabel, *nameLabel, *valueLabel;
	QCheckBox *valueExactButton;
	QPushButton *namesButton;

private:

	MathStructure *init_value;
	bool force_init_value;

public slots:

	void editNames();
	void nameChanged(const QString&);
	
protected slots:
	
	void slotHelp();
	void slotOk();

};

#endif
