
/*
 * Copyright (C) 2002-2003 Stefan Holst
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: otk_slider.h 2316 2007-06-26 10:02:05Z mschwerin $
 *
 */

#ifndef HAVE_OTK_SLIDER_H
#define HAVE_OTK_SLIDER_H

typedef enum {
    OTK_SLIDER_VERTICAL,
    OTK_SLIDER_HORIZONTAL,
} otk_slider_orientation_t;


/**
 * Creates a new slider widget.
 *
 * @param value_format          The format in which the value is printed
 *                              into the slider. This format must contain
 *                              exactly one '%f' as the value is passed as a
 *                              double.
 * @param value_scale           Before printing the value it is multiplied
 *                              with this number.
 */
otk_widget_t *otk_slider_new (otk_t * otk, int x, int y, int w, int h,
                              int marker_w, int marker_h, bool simple_marker,
                              otk_slider_orientation_t orientation,
                              const char *value_format, double value_scale,
                              bool with_buttons, bool with_reset_button,
                              int def_value, int min_step,
                              int min_value, int max_value,
                              otk_int_get_cb_t get_value_cb,
                              void *get_value_cb_data,
                              otk_int_set_cb_t set_value_cb,
                              void *set_value_cb_data);

#endif /* HAVE_OTK_SLIDER_H */
