
/*
 * Copyright (C) 2002-2003 Stefan Holst
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: otk_globals.h 2519 2007-07-17 08:39:07Z mschwerin $
 *
 */

#ifndef HAVE_OTK_GLOBALS_H
#define HAVE_OTK_GLOBALS_H

#include "event.h"
#include "odk.h"

#define OSD_TEXT_PALETTE_TRANSPARENT    (0)
#define OSD_TEXT_PALETTE_BACKGROUND     (1)
#define OSD_TEXT_PALETTE_FOREGROUND     (10)

/// The OTK main data structure.
typedef struct otk_s otk_t;

/// The data structure of a widget.
typedef struct otk_widget_s otk_widget_t;

/// Callbacks to user methods.
typedef void (*otk_cb_t) (void *user_data);

/// Callback to update a widget.
typedef void (*otk_update_cb_t) (void *user_data, otk_widget_t * widget);

/// Callback to get an integer value.
typedef int (*otk_int_get_cb_t) (void *user_data);

/// Callback to set an integer value.
typedef int (*otk_int_set_cb_t) (void *user_data, int position);

/// Textpalette
typedef enum {
    OTK_PALETTE_LABEL,
    OTK_PALETTE_BUTTON,
    OTK_PALETTE_BUTTON_FOCUSED,
    OTK_PALETTE_BUTTON_DISABLED,
    OTK_PALETTE_SLIDER,
    OTK_PALETTE_SLIDER_FOCUSED,
    OTK_PALETTE_SLIDER_INVERSE,
} otk_palette_id_t;

/// Directions
typedef enum {
    OTK_DIRECTION_UP,
    OTK_DIRECTION_DOWN,
    OTK_DIRECTION_LEFT,
    OTK_DIRECTION_RIGHT
} otk_direction_t;

/// Initialize the oxine toolkit.
otk_t *otk_init (odk_t * odk, const char *skin_xml);

/// Free the oxine toolkit.
void otk_free (otk_t * otk);

/// Draw the screen.
void otk_draw (otk_t * otk);

/// Clear the screen.
void otk_clear (otk_t * otk);

/// Returns the pointer to the ODK data structure.
odk_t *otk_get_odk (otk_t * otk);

/// Returns the start of the selected palette.
int otk_get_palette (otk_t * otk, otk_palette_id_t id);

/// Returns the current window.
otk_widget_t *otk_get_current_window (otk_t * otk);

/// Sets the current window.
void otk_set_current_window (otk_t * otk, otk_widget_t * window);

/// Locks the drawing mutex.
void otk_draw_lock (otk_t * otk);

/// Unlocks the drawing mutex.
void otk_draw_unlock (otk_t * otk);

/**
 * Checks the width of the passed text and truncates the text to fit the
 * maximum width if necessary. 
 *
 * @param otk                   An OTK object.
 * @param text                  The string to check.
 * @param width                 The maximum width allowed.
 *
 * @return                      The returned string must be freed.
 */
char *otk_trunc_text_to_width (otk_t * otk, const char *text, int width);


/// Sets the focus to the previous widget and returns this widget.
otk_widget_t *otk_widget_get_prev_focus (otk_t * otk);


/// Sets the focus to the next widget and returns this widget.
otk_widget_t *otk_widget_get_next_focus (otk_t * otk);


/**
 * Searches for the neighbouring widget in the given direction. This method
 * searches for the nearest neighbouring widget of the widget that currently
 * has the focus.
 */
otk_widget_t *otk_widget_find_neighbour (otk_t * otk,
                                         otk_direction_t direction);


#endif /* HAVE_OTK_GLOBALS_H */
