
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: menu_filelist.h 2341 2007-06-27 09:51:03Z mschwerin $
 *
 */

#ifndef HAVE_FILELIST_MENU_H
#define HAVE_FILELIST_MENU_H


void show_menu_music (void *p);


void show_menu_video (void *p);


#ifdef HAVE_IMAGE_PLAYBACK
void show_menu_image (void *p);
#endif


void show_menu_media (void *p);


/**
 * Shows one of the four filelist menus. Which of them is called depends on
 * which of them was called last.
 */
void show_menu_filelist (void *p);


/**
 * Returns TRUE if one of the four filelist menus is the current menu.
 */
bool filelist_menu_is_current_menu (void);


void free_menu_filelist (void);


#endif /* HAVE_FILELIST_MENU_H */
