dnl
dnl checking for lirc
dnl
AC_DEFUN([AC_CHECK_LIRC], [
    AC_ARG_ENABLE([lirc], 
                  AC_HELP_STRING([--disable-lirc], 
                                 [do not activate LIRC support]),
                  [enable_lirc=$enableval], [enable_lirc=yes])

    if test x"$enable_lirc" = xyes; then
        have_lirc=yes
        AC_REQUIRE_CPP
        AC_CHECK_LIB(lirc_client, lirc_init,
                     [AC_CHECK_HEADER(lirc/lirc_client.h, true, have_lirc=no)], have_lirc=no)

        if test "$have_lirc" = "yes"; then
            if test x"$LIRC_PREFIX" != "x"; then
                lirc_libprefix="$LIRC_PREFIX/lib"
                LIRC_INCLUDE="-I$LIRC_PREFIX/include"
            fi
            for llirc in $lirc_libprefix /lib /lib64 /usr/lib /usr/lib64 /usr/local/lib /usr/local/lib64; do
                AC_CHECK_FILE(["$llirc/liblirc_client.a"],
                              [LIRC_LIBS="$llirc/liblirc_client.a"]
                              AC_DEFINE([HAVE_LIRC],,[Define this if you have the LIRC client library installed.]),,)
            done
        else
            AC_MSG_WARN([])
            AC_MSG_WARN([Please install the LIRC client library (liblirc-client) if you wish to])
            AC_MSG_WARN([control oxine using a remote control.])
            AC_MSG_WARN([])
        fi
    fi

    AC_SUBST(LIRC_LIBS)
    AC_SUBST(LIRC_INCLUDE)
])
