################################################################################
# OpenVAS Vulnerability Test
# $Id: gb_mediawiki_xss_vuln.nasl 6639 2010-01-15 15:11:27Z jan $
#
# MediaWiki XSS Vulnerability
#
# Authors:
# Rachana Shetty <srachana@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800982);
  script_version("$Revision: 7462 $: 1.0");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-4589");
  script_bugtraq_id(35662);
  script_name("MediaWiki XSS Vulnerability");
  desc = "
  Overview: This host is running MediaWiki and is prone to XSS
  Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to the error in 'Special:Block' script in the
  'getContribsLink' function in 'SpecialBlockip.php' page. It fails to
  properly sanitize user-supplied input while processing the 'ip'
  parameter.

  Impact:
  Successful exploitation will let the remote attackers to include arbitrary
  HTML or web scripts in the scope of the browser and allows to obtain
  sensitive information.

  Impact level: Application

  Affected Software/OS:
  MediaWiki version 1.14.0
  MediaWiki version 1.15.0

  Fix:
  Apply the patch or Upgrade to MediaWiki version to 1.14.1, 1.15.1 or higher,
  http://download.wikimedia.org/mediawiki/1.14/mediawiki-1.14.1.patch.gz
  http://download.wikimedia.org/mediawiki/1.15/mediawiki-1.15.1.patch.gz
  http://download.wikimedia.org/mediawiki/1.14/mediawiki-1.14.1.tar.gz
  http://download.wikimedia.org/mediawiki/1.15/mediawiki-1.15.1.tar.gz

  References:
  http://secunia.com/advisories/35818
  http://xforce.iss.net/xforce/xfdb/51687
  http://lists.wikimedia.org/pipermail/mediawiki-announce/2009-July/000087.html

  CVSS Score:
    CVSS Base Score        = 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score    = 3.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of MediaWiki");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Web application abuses");
  script_require_ports("Services/www", 80);
  script_dependencies("secpod_mediawiki_detect.nasl");
  script_require_keys("MediaWiki/Version");
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

wikiPort = get_http_port(default:80);
if(!wikiPort){
  exit(0);
}

mediawiki = get_kb_item("MediaWiki/Version");
if(!mediawiki){
  exit(0);
}

if(mediawiki != NULL)
{
  ## Grep for affected MediaWiki Versions 1.14.0 and 1.15.0
  if(version_is_equal(version:mediawiki, test_version:"1.14.0") ||
     version_is_equal(version:mediawiki, test_version:"1.15.0")){
    security_warning(wikiPort);
    exit(0);
  }
}
