###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for x11-driver-video-vesa MDKA-2007:069 (x11-driver-video-vesa)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830154);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDKA", value: "2007:069");
  script_name( "Mandriva Update for x11-driver-video-vesa MDKA-2007:069 (x11-driver-video-vesa)");
  desc = "

  Vulnerability Insight:

  X.org was crashing and/or corrupting the screen when the screen
  is resized using the Resize and Rotate (randr) server extension.
  The problem identified was that the vesa driver was trying to use
  outdated values for its frame buffer, and so causing problem. The
  updated package has a patch fixing this issue.

  Affected Software/OS:
  x11-driver-video-vesa on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-06/msg00043.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of x11-driver-video-vesa");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"x11-driver-video-vesa", rpm:"x11-driver-video-vesa~1.2.1~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}