###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for asterisk FEDORA-2008-2554
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860894);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "FEDORA", value: "2008-2554");
  script_cve_id("CVE-2008-1289", "CVE-2008-1332", "CVE-2008-1390");
  script_name( "Fedora Update for asterisk FEDORA-2008-2554");
  desc = "

  Vulnerability Insight:
  Asterisk is a complete PBX in software. It runs on Linux and provides
  all of the features you would expect from a PBX and more. Asterisk
  does voice over IP in three protocols, and can interoperate with
  almost all standards-based telephony equipment using relatively
  inexpensive hardware.


  Affected Software/OS:
  asterisk on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-March/msg00438.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of asterisk");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"asterisk", rpm:"asterisk~1.4.18.1~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}