//                                               -*- C++ -*-
/**
 * @file  PythonNumericalMathEvaluationImplementation.hxx
 * @brief This class binds a Python function to an Open TURNS' NumericalMathFunction
 *
 * (C) Copyright 2005-2010 EDF
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * \author $LastChangedBy: dutka $
 * \date   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 */

#ifndef OPENTURNS_PYTHONNUMERICALMATHFUNCTIONIMPLEMENTATION_HXX
#define OPENTURNS_PYTHONNUMERICALMATHFUNCTIONIMPLEMENTATION_HXX

#include "Python.h"
#include "NumericalMathEvaluationImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {


      /**
       * @class PythonNumericalMathEvaluationImplementation
       *
       * This class binds a Python function to an Open TURNS' NumericalMathFunction
       */
      class PythonNumericalMathEvaluationImplementation
	: public NumericalMathEvaluationImplementation
      {
	CLASSNAME;
      public:

	typedef NumericalMathEvaluationImplementation::Description              Description;
	typedef NumericalMathEvaluationImplementation::NumericalPoint           NumericalPoint;
	typedef NumericalMathEvaluationImplementation::Matrix                   Matrix;
	typedef NumericalMathEvaluationImplementation::InvalidArgumentException InvalidArgumentException;
	typedef NumericalMathEvaluationImplementation::InternalException        InternalException;
	typedef NumericalMathEvaluationImplementation::NumericalSample          NumericalSample;


	/** Default constructor */
	PythonNumericalMathEvaluationImplementation(PyObject * pyCallable);

	/** Copy constructor */
	PythonNumericalMathEvaluationImplementation(const PythonNumericalMathEvaluationImplementation & other);

	/** Virtual constructor */
	virtual PythonNumericalMathEvaluationImplementation * clone() const;

	/** Destructor */
	virtual ~PythonNumericalMathEvaluationImplementation();

	/** Comparison operator */
	Bool operator ==(const PythonNumericalMathEvaluationImplementation & other) const;

	/** String converter */
	virtual String str() const;


	/** Test for actual implementation */
	virtual Bool isActualImplementation() const;


	/* Here is the interface that all derived class must implement */
	
	/** Operator () */
	virtual NumericalPoint operator() (const NumericalPoint & in) const;
	/*	  throw(InvalidArgumentException,InternalException);*/

	//	virtual NumericalSample operator() (const NumericalSample & in) const
	//	  throw(InvalidArgumentException,InternalException);

	/** Accessor for input point dimension */
	virtual UnsignedLong getInputDimension() const;
	/*	  throw(InternalException);*/

	/** Accessor for output point dimension */
	virtual UnsignedLong getOutputDimension() const;
	/*	  throw(InternalException);*/


      protected:

    
      private:

	/** The underlying Python callable object */
	PyObject * pyObj_;

      }; /* class PythonNumericalMathEvaluationImplementation */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_PYTHONNUMERICALMATHFUNCTIONIMPLEMENTATION_HXX */
