// SWIG file NumericalMathFunction.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2010-01-27 14:00:03 +0100 (mer. 27 janv. 2010) $
// Id : $Id: NumericalMathFunction.i 1452 2010-01-27 13:00:03Z dutka $

%{
#include "NumericalMathFunction.hxx"
#include "PythonNumericalMathEvaluationImplementation.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Base::Func::NumericalMathFunction>
  {
    typedef _PyObject_ Type;
  };

  template <>
  inline
  OpenTURNS::Base::Func::NumericalMathFunction
  convert<_PyObject_,OpenTURNS::Base::Func::NumericalMathFunction>(PyObject * pyObj)
  {
   if (!PyCallable_Check( pyObj )) {
     throw OT::Base::Common::InvalidArgumentException(HERE) << "Argument is not a callable object (function or class)";
   }

   return OpenTURNS::Base::Func::NumericalMathFunction(new OpenTURNS::Base::Func::NumericalMathFunctionImplementation(new OpenTURNS::Base::Func::PythonNumericalMathEvaluationImplementation(pyObj) ) );

  }

} /* namespace OpenTURNS */

%}

%pythoncode %{

class OpenTURNSPythonFunction :

  def __init__(self, n=0, p=0) :
    self.n = n
    self.p = p
    pass

  def getInputDimension(self) :
    return self.n

  def getOutputDimension(self) :
    return self.p

  def __call__(self, X) :
    import types
    Y = None
    if ( type(X) not in (types.TupleType, types.ListType) ):
      raise TypeError("Expect sequence argument like a list or a tuple")
    if ( len(X) == 0 ):
      raise TypeError("Expect sequence argument of length > 0")
    if ( type(X[0]) not in (types.TupleType, types.ListType) ):
      Y = self.f(X)
      if ( type(Y) not in (types.TupleType, types.ListType) ): 
        raise TypeError("Expect sequence argument like a list or a tuple as f's return value. Check f method")
      if (len(Y) != self.p): 
        raise TypeError("Expect sequence argument of length %d. Got %d. Check f method" % (self.p, len(Y)) )
      return Y
#    else:
#      Y = self.fsample(X)
#      if ( type(Y) not in (types.TupleType, types.ListType) ): 
#        raise TypeError("Expect sequence argument like a list or a tuple as f's return value. Check fsample method")
#      if (len(Y) != len(X)): 
#        raise TypeError("Expect sequence argument of length %d. Got %d. Check fsample method" % (len(X), len(Y)) )
#      for i in range(len(X)):
#        if ( len(Y[i]) != self.p ):
#          raise TypeError("Expect sequence argument of length %d at position %d. Got %d. Check fsample method" % (self.p, i, len(Y[i])) )
      return Y

  def f(self, X) :
    return X

#  def fsample(self, X) :
#    Y = list()
#    for i in range(len(X)):
#      Y.append(self.f(X[i]))
#    return Y

%}

%template(NumericalMathFunctionImplementationTypedInterfaceObject)           OpenTURNS::Base::Common::TypedInterfaceObject<OpenTURNS::Base::Func::NumericalMathFunctionImplementation>;
%include NumericalMathFunction.hxx
namespace OpenTURNS { namespace Base { namespace Func {

%extend NumericalMathFunction {

NumericalMathFunction(const NumericalMathFunction & other)
{ return new OpenTURNS::Base::Func::NumericalMathFunction(other); }

NumericalMathFunction(PyObject * pyObj)
{
 return new OpenTURNS::Base::Func::NumericalMathFunction( OpenTURNS::convert<OpenTURNS::_PyObject_,OpenTURNS::Base::Func::NumericalMathFunction>(pyObj) );
}

OpenTURNS::Base::Type::NumericalPoint operator() (PyObject * pyObj) {
  return self->operator()( OpenTURNS::convert<OpenTURNS::_PySequence_, OpenTURNS::Base::Type::NumericalPoint>( pyObj ) );
}
}

}}}
