//                                               -*- C++ -*-
/**
 *  @file  t_StandardDistributionPolynomialFactory_std.cxx
 *  @brief The test file of class StandardDistributionPolynomialFactory for standard methods
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (mer, 21 mai 2008) $
 *  Id:      $Id: t_StandardDistributionPolynomialFactory_std.cxx 818 2008-05-21 15:44:02Z dutka $
 */
#include <iostream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "Exception.hxx"
#include "NumericalPoint.hxx"
#include "Collection.hxx"
#include "Distribution.hxx"
#include "Beta.hxx"
#include "ChiSquare.hxx"
#include "Epanechnikov.hxx"
#include "Exponential.hxx"
#include "Gamma.hxx"
#include "Gumbel.hxx"
#include "Laplace.hxx"
#include "Logistic.hxx"
#include "LogNormal.hxx"
#include "Normal.hxx"
#include "Rayleigh.hxx"
#include "Student.hxx"
#include "Triangular.hxx"
#include "Uniform.hxx"
#include "Weibull.hxx"
#include "StandardDistributionPolynomialFactory.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Uncertainty::Distribution;
using namespace OT::Uncertainty::Model;
using namespace OT::Uncertainty::Algorithm;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    const UnsignedLong iMax(5);
    Collection<Distribution> distributionCollection;
    distributionCollection.add(Laplace(1.0, 0.0));
    distributionCollection.add(Logistic(0.0, 1.0));
    distributionCollection.add(LogNormal(0.0, 1.0, 0.0));
    distributionCollection.add(Normal(0.0, 1.0));
    distributionCollection.add(Rayleigh(1.0));
    distributionCollection.add(Student(22));
    distributionCollection.add(Triangular(-1.0, 0.3, 1.0));
    distributionCollection.add(Uniform(-1.0,1.0));
    distributionCollection.add(Weibull(1.0, 3.0));
    for (UnsignedLong n = 0; n < distributionCollection.getSize(); ++n)
      {
        const Distribution distribution(distributionCollection[n]);
        const String name(distribution.getImplementation()->getClassName());
        StandardDistributionPolynomialFactory polynomialFactory(distribution);
        fullprint << "polynomialFactory(" << name << "=" << polynomialFactory << std::endl;
        for (UnsignedLong i = 0; i < iMax; ++i)
          fullprint << name << " polynomial(" << i << ")=" << polynomialFactory.build(i).__str__() << std::endl;
        NumericalPoint roots(polynomialFactory.getRoots(iMax - 1));
        fullprint << name << " polynomial(" << iMax - 1 << ") roots=" << roots << std::endl;
        NumericalPoint weights;
        NumericalPoint nodes(polynomialFactory.getNodesAndWeights(iMax - 1, weights));
        fullprint << name << " polynomial(" << iMax - 1 << ") nodes=" << nodes << " and weights=" << weights <<  std::endl;
      }
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
