//                                               -*- C++ -*-
/**
 *  @file  t_HypothesisTest_std.cxx
 *  @brief The test file of class Test
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: t_HypothesisTest_std.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include <iostream>
#include <iomanip>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include <cmath>
#include "HypothesisTest.hxx"
#include "NumericalSample.hxx"
#include "TestResult.hxx"
#include "NumericalPoint.hxx"
#include "Normal.hxx"
#include "Poisson.hxx"
#include "Geometric.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Stat;
using namespace OT::Base::Type;
using namespace OT::Uncertainty::Distribution;
using namespace OT::Uncertainty::StatTest;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);
  setRandomGenerator();
  
  UnsignedLong size(100);
  UnsignedLong dim(10);
  CorrelationMatrix R(dim);
  for (UnsignedLong i = 0; i < dim; i++)
    {
      for (UnsignedLong j = 0; j < i; j++)
	{
	  R(i, j) = (i + j + 1.0) / (2.0 * dim);
	}
    }
  NumericalPoint mean(dim, 2.0);
  NumericalPoint sigma(dim, 3.0);
  Normal distribution(mean, sigma, R);
  NumericalSample sample(distribution.getNumericalSample(size));
  NumericalSample sampleX(size, dim - 1);
  NumericalSample sampleY(size, 1);
  for (UnsignedLong i = 0; i < size; i++)
    {
      sampleY[i][0] = sample[i][0];
      for (UnsignedLong j = 1; j < dim; j++)
	{
	  sampleX[i][j - 1] = sample[i][j];
	}
    }
  NumericalSample sampleZ(size, 1);
  for (UnsignedLong i = 0; i < size; i++)
    {
      sampleZ[i][0] = sampleY[i][0] * sampleY[i][0];
    }

  NumericalSample discreteSample1(Poisson(0.1).getNumericalSample(size));
  NumericalSample discreteSample2(Geometric(0.4).getNumericalSample(size));

  // ChiSquared Independance test : test if two samples (of sizes not necessarily equal) are independant ?
  // Care : discrete samples only
  // H0 = independent samples
  // p-value threshold : probability of the H0 reject zone : 1-0.90 
  // p-value : probability (test variable decision > test variable decision evaluated on the samples)
  // Test = True <=> p-value > p-value threshold
  fullprint << "ChiSquared=" << HypothesisTest::ChiSquared(discreteSample1, discreteSample2, 0.90) << std::endl;
  fullprint << "ChiSquared2=" << HypothesisTest::ChiSquared(discreteSample1, discreteSample1, 0.90) << std::endl;

    
  // Pearson Test : test if two gaussian samples are independent (based on the evaluation of the linear correlation coefficient)
  // H0 : independent samples (linear correlation coefficient = 0)
  // Test = True <=> independent samples (linear correlation coefficient = 0)
  // p-value threshold : probability of the H0 reject zone : 1-0.90 
  // p-value : probability (test variable decision > test variable decision evaluated on the samples)
  // Test = True <=> p-value > p-value threshold

  fullprint << "Pearson=" << HypothesisTest::Pearson(sampleY, sampleZ, 0.90) << std::endl;


  // Smirnov Test : test if two samples (of sizes not necessarily equal) follow the same distribution
  // Care : continuous distributions only
  // H0 = same continuous distribution
  // Test = True <=> same distribution
  // p-value threshold : probability of the H0 reject zone : 1-0.90 
  // p-value : probability (test variable decision > test variable decision evaluated on the samples)
  // Test = True <=> p-value > p-value threshold

  fullprint << "Smirnov=" << HypothesisTest::Smirnov(sampleY, sampleZ, 0.90) << std::endl;

  // Spearman Test : test if two samples have a monotonous relation
  // H0 = no monotonous relation between both samples
  // Test = True <=> no monotonous relation
  // p-value threshold : probability of the H0 reject zone : 1-0.90 
  // p-value : probability (test variable decision > test variable decision evaluated on the samples)
  // Test = True <=> p-value > p-value threshold

  fullprint << "Spearman=" << HypothesisTest::Spearman(sampleY, sampleZ, 0.90) << std::endl;
  return ExitCode::Success;
}
