//                                               -*- C++ -*-
/**
 * @file  DistributionFactory.cxx
 * @brief Top-level class for all distribution factories
 *
 * (C) Copyright 2005-2010 EDF
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * \author $LastChangedBy: dutka $
 * \date   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 */

#include "DistributionFactory.hxx"
#include "Description.hxx"
#include "Path.hxx"
#include "Exception.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {

      CLASSNAMEINIT(DistributionFactory);

      /* Default constructor */
      DistributionFactory::DistributionFactory(const String & name)
	: Base::Common::TypedInterfaceObject<DistributionImplementationFactory>(new DistributionImplementationFactory(name))
      {
	// Nothing to do
      }

      /* Parameter constructor */
      DistributionFactory::DistributionFactory(const DistributionImplementationFactory & factory)
	: Base::Common::TypedInterfaceObject<DistributionImplementationFactory>(factory.clone())
      {
	// Nothing to do
      }

      /* String converter */
      String DistributionFactory::__repr__() const {
	OSS oss;
	oss << "class=" << DistributionFactory::GetClassName()
	    << " implementation=" << getImplementation()->__repr__();
	return oss;
      }

      /* String converter */
      String DistributionFactory::__str__() const {
	return getImplementation()->__str__();
      }

      /* Here is the interface that all derived class must implement */
      Distribution DistributionFactory::buildImplementation(const NumericalSample & sample) const /* throw(InvalidArgumentException, InternalException) */
      {
	return getImplementation()->buildImplementation(sample);
      }

      Distribution DistributionFactory::buildImplementation(const NumericalPointCollection & parameters) const /* throw(InvalidArgumentException, InternalException) */
      {
	return getImplementation()->buildImplementation(parameters);
      }

      Distribution DistributionFactory::buildImplementation() const /* throw(InvalidArgumentException, InternalException) */
      {
	return getImplementation()->buildImplementation();
      }

    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
