//                                               -*- C++ -*-
/**
 *  @file  PostAnalyticalImportanceSampling.hxx
 *  @brief PostAnalyticalImportanceSampling is an implementation of the importance sampling Montex Carlo simulation method
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-02 14:59:25 +0200 (mer, 02 mai 2007) $
 *  Id:      $Id: PostAnalyticalImportanceSampling.hxx 424 2007-05-02 12:59:25Z dutka $
 */
#ifndef OPENTURNS_POSTANALYTICALIMPORTANCESAMPLING_HXX
#define OPENTURNS_POSTANALYTICALIMPORTANCESAMPLING_HXX

#include "PostAnalyticalSimulation.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {

      /**
       * @class PostAnalyticalImportanceSampling
       */

      class PostAnalyticalImportanceSampling :
	public PostAnalyticalSimulation
      {

	CLASSNAME;
      public:

	typedef PostAnalyticalSimulation::NumericalSample          NumericalSample;
	typedef PostAnalyticalSimulation::InvalidArgumentException InvalidArgumentException;
	typedef PostAnalyticalSimulation::StandardEvent            StandardEvent;
	typedef PostAnalyticalSimulation::Distribution             Distribution;

	/** Constructor with parameters */
	PostAnalyticalImportanceSampling(const AnalyticalResult & AnalyticalResult) throw(InvalidArgumentException);

	/** Virtual constructor */
	virtual PostAnalyticalImportanceSampling * clone() const;

	/** String converter */
	String __repr__() const;

      private:

	/** Compute the block sample */
	NumericalSample computeBlockSample();

      } ; /* class PostAnalyticalImportanceSampling */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_POSTANALYTICALIMPORTANCESAMPLING_HXX */
