//                                               -*- C++ -*-
/**
 *  @file  NatafEllipticalDistributionEvaluation.hxx
 *  @brief Class for the Nataf transformation evaluation for elliptical
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: NatafEllipticalDistributionEvaluation.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_NATAFELLIPTICALDISTRIBUTIONEVALUATION_HXX
#define OPENTURNS_NATAFELLIPTICALDISTRIBUTIONEVALUATION_HXX

#include "OTprivate.hxx"
#include "LinearNumericalMathEvaluationImplementation.hxx"
#include "Matrix.hxx"
#include "NumericalPoint.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {


      /**
       * @class NatafEllipticalDistributionEvaluation
       *
       * This class offers an interface for the Nataf function for elliptical distributions
       */
      class NatafEllipticalDistributionEvaluation
	: public Base::Func::LinearNumericalMathEvaluationImplementation
      {
	CLASSNAME;
      public:

	typedef Base::Func::LinearNumericalMathEvaluationImplementation LinearNumericalMathEvaluationImplementation;
	typedef Base::Type::Matrix                                    Matrix;
	typedef Base::Type::SquareMatrix                              SquareMatrix;
	typedef Base::Type::NumericalPoint                            NumericalPoint;

	/** Parameter constructor */
	NatafEllipticalDistributionEvaluation(const NumericalPoint & mean,
					      const SquareMatrix & inverseCholesky);


	/** Gradient according to the marginal parameters */
	virtual Matrix parametersGradient(const NumericalPoint & in) const;
	  
	/** String converter */
	virtual String __repr__() const;

      protected:

    
      private:

      }; /* NatafEllipticalDistributionEvaluation */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_NATAFELLIPTICALDISTRIBUTIONEVALUATION_HXX */
