//                                               -*- C++ -*-
/**
 *  @file  CorrelationMatrix.cxx
 *  @brief The class CorrelationMatrix implements correlation matrices
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: CorrelationMatrix.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include "CorrelationMatrix.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Stat
    {

      CLASSNAMEINIT(CorrelationMatrix);

      /* Default constructor */
      CorrelationMatrix::CorrelationMatrix()
	: CovarianceMatrix(0)
      {
        // Nothing to do
      }
      
      /* Constructor with size (dim, which is the same for nbRows_ and nbColumns_ )*/
      CorrelationMatrix::CorrelationMatrix(const UnsignedLong dim)
	: CovarianceMatrix(dim)
      {
        // Nothing to do
      }
      
      /* Constructor from external collection */
      /* If the dimensions of the matrix and of the collection */
      /* do not match, either the collection is truncated */
      /* or the rest of the matrix is filled with zeros */
      CorrelationMatrix::CorrelationMatrix(const UnsignedLong dim, 
					   const OT::Base::Type::Collection<NumericalScalar> &elementsValues)
	: CovarianceMatrix(dim, elementsValues)
      {
        // Nothing to do
      }
      
      /* Constructor with implementation */
      CorrelationMatrix::CorrelationMatrix(const Implementation & i)
	: CovarianceMatrix(i) 
      {
        // Nothing to do
      }
      
      /* String converter */
      String CorrelationMatrix::__repr__() const
      {
	checkSymmetry();
	return OSS() << "class=" << getClassName()
		     << " dimension=" << this->getDimension()
		     << " implementation=" << getImplementation()->__repr__();
      }

      /* CorrelationMatrix transpose */
      CorrelationMatrix CorrelationMatrix::transpose () const 
      { 
        return *this;
      }
      
      /* CorrelationMatrix multiplication (must have consistent dimensions) */
      CorrelationMatrix CorrelationMatrix::operator * (const IdentityMatrix & m) const /* throw(InvalidDimensionException) */
      {
        return *this;
      }
      
    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */
