//                                               -*- C++ -*-
/**
 *  @file  BoundConstrainedAlgorithmImplementationResult.cxx
 *  @brief BoundConstrainedAlgorithmImplementationResult stores the result of a BoundConstrainedAlgorithmImplementation algorithm
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: BoundConstrainedAlgorithmImplementationResult.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include "BoundConstrainedAlgorithmImplementationResult.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optim
    {

      CLASSNAMEINIT(BoundConstrainedAlgorithmImplementationResult);

      static Base::Common::Factory<BoundConstrainedAlgorithmImplementationResult> RegisteredFactory("BoundConstrainedAlgorithmImplementationResult");

      /* Default constructor */
      BoundConstrainedAlgorithmImplementationResult::BoundConstrainedAlgorithmImplementationResult():
        PersistentObject(),
        optimizer_(NumericalPoint(1)),
        optimalValue_(0.0),
        optimization_(MINIMIZATION),
        evaluationsNumber_(0),
        absoluteError_(0.0),
        relativeError_(0.0),
        objectiveError_(0.0),
        constraintError_(0.0)
      {
        // Nothing to do
      }

      /* Standard constructor */
      BoundConstrainedAlgorithmImplementationResult::BoundConstrainedAlgorithmImplementationResult(const NumericalPoint & optimizer,
                                                                                                   const NumericalScalar optimalValue,
                                                                                                   const OptimizationProblem optimization,
                                                                                                   const UnsignedLong evaluationsNumber,
                                                                                                   const NumericalScalar absoluteError,
                                                                                                   const NumericalScalar relativeError,
                                                                                                   const NumericalScalar objectiveError,
                                                                                                   const NumericalScalar constraintError):
        PersistentObject(),
        optimizer_(optimizer),
        optimalValue_(optimalValue),
        optimization_(optimization),
        evaluationsNumber_(evaluationsNumber),
        absoluteError_(absoluteError),
        relativeError_(relativeError),
        objectiveError_(objectiveError),
        constraintError_(constraintError)
      {
        // Nothing to do
      }

      /* Virtual constructor */
      BoundConstrainedAlgorithmImplementationResult * BoundConstrainedAlgorithmImplementationResult::clone() const
      {
        return new BoundConstrainedAlgorithmImplementationResult(*this);
      }

      /* Optimizer accessors */
      BoundConstrainedAlgorithmImplementationResult::NumericalPoint BoundConstrainedAlgorithmImplementationResult::getOptimizer() const
      {
        return optimizer_;
      }

      void BoundConstrainedAlgorithmImplementationResult::setOptimizer(const NumericalPoint & optimizer)
      {
        optimizer_ = optimizer;
      }

      /* Optimal value accessors */
      NumericalScalar BoundConstrainedAlgorithmImplementationResult::getOptimalValue() const
      {
        return optimalValue_;
      }

      void BoundConstrainedAlgorithmImplementationResult::setOptimalValue(const NumericalScalar optimalValue)
      {
        optimalValue_ = optimalValue;
      }

      /* Optimization problem accessors */
      BoundConstrainedAlgorithmImplementationResult::OptimizationProblem BoundConstrainedAlgorithmImplementationResult::getOptimizationProblem() const
      {
        return optimization_;
      }

      void BoundConstrainedAlgorithmImplementationResult::setOptimizationProblem(const OptimizationProblem optimization)
      {
        optimization_ = optimization;
      }

      /* Iterations number accessor */
      UnsignedLong BoundConstrainedAlgorithmImplementationResult::getEvaluationsNumber() const
      {
        return evaluationsNumber_;
      }

      void BoundConstrainedAlgorithmImplementationResult::setEvaluationsNumber(const UnsignedLong evaluationsNumber)
      {
        evaluationsNumber_ = evaluationsNumber;
      }

      /* Absolute error accessor */
      NumericalScalar BoundConstrainedAlgorithmImplementationResult::getAbsoluteError() const
      {
        return absoluteError_;
      }

      void BoundConstrainedAlgorithmImplementationResult::setAbsoluteError(const NumericalScalar absoluteError)
      {
        absoluteError_ = absoluteError;
      }

      /* Relative error accessor */
      NumericalScalar BoundConstrainedAlgorithmImplementationResult::getRelativeError() const
      {
        return relativeError_;
      }

      void BoundConstrainedAlgorithmImplementationResult::setRelativeError(const NumericalScalar relativeError)
      {
        relativeError_ = relativeError;
      }

      /* Objective error accessor */
      NumericalScalar BoundConstrainedAlgorithmImplementationResult::getObjectiveError() const
      {
        return objectiveError_;
      }

      void BoundConstrainedAlgorithmImplementationResult::setObjectiveError(const NumericalScalar objectiveError)
      {
        objectiveError_ = objectiveError;
      }

      /* Constraint error accessor */
      NumericalScalar BoundConstrainedAlgorithmImplementationResult::getConstraintError() const
      {
        return constraintError_;
      }

      void BoundConstrainedAlgorithmImplementationResult::setConstraintError(const NumericalScalar constraintError)
      {
        constraintError_ = constraintError;
      }

      /* String converter */
      String BoundConstrainedAlgorithmImplementationResult::__repr__() const
      {
        OSS oss;
        oss << "class=" << BoundConstrainedAlgorithmImplementationResult::GetClassName()
            << " optimizer="            << optimizer_
            << " optimal value="        << optimalValue_
            << " optimization problem=" << optimization_
            << " evaluationsNumber="    << evaluationsNumber_
            << " absoluteError="        << absoluteError_
            << " relativeError="        << relativeError_
            << " objectiveError="       << objectiveError_
            << " constraintError="      << constraintError_;
        return oss;
      }

      /* Method save() stores the object through the StorageManager */
      void BoundConstrainedAlgorithmImplementationResult::save(StorageManager::Advocate & adv) const
      {
        PersistentObject::save(adv);
        adv.saveAttribute( "optimizer_", optimizer_ );
        adv.saveAttribute( "evaluationsNumber_", evaluationsNumber_ );
        adv.saveAttribute( "absoluteError_",     absoluteError_ );
        adv.saveAttribute( "relativeError_",     relativeError_ );
        adv.saveAttribute( "objectiveError_",    objectiveError_ );
        adv.saveAttribute( "constraintError_",   constraintError_ );
      }

      /* Method load() reloads the object from the StorageManager */
      void BoundConstrainedAlgorithmImplementationResult::load(StorageManager::Advocate & adv)
      {
        PersistentObject::load(adv);
        adv.loadAttribute( "optimizer_", optimizer_ );
        adv.loadAttribute( "evaluationsNumber_", evaluationsNumber_ );
        adv.loadAttribute( "absoluteError_",     absoluteError_ );
        adv.loadAttribute( "relativeError_",     relativeError_ );
        adv.loadAttribute( "objectiveError_",    objectiveError_ );
        adv.loadAttribute( "constraintError_",   constraintError_ );
      }

    } /* namespace Optim */
  } /* namespace Base */
} /* namespace OpenTURNS */
