//                                               -*- C++ -*-
/**
 *  @file  NumericalMathGradientImplementationFactory.cxx
 *  @brief The class NumericalMathGradientImplementationFactory creates NumericalMathGradientImplementation from external codes
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: NumericalMathGradientImplementationFactory.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include "WrapperFile.hxx"
#include "Exception.hxx"
#include "NumericalMathGradientImplementationFactory.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Func
    {

      CLASSNAMEINIT(NumericalMathGradientImplementationFactory);

      /* Default constructor */
      NumericalMathGradientImplementationFactory::NumericalMathGradientImplementationFactory()
      {
        // Nothing to do
      }

      /* String converter */
      String NumericalMathGradientImplementationFactory::__repr__() const
      {
	OSS oss;
	oss << "class=" << NumericalMathGradientImplementationFactory::GetClassName();
	return oss;
      }




      /* Implementation creation */
      NumericalMathGradientImplementationFactory::Implementation NumericalMathGradientImplementationFactory::buildImplementation(const String & functionName) const
	/* throw(InvalidArgumentException) */
      {
	return Implementation(buildObject(functionName));
      }

    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */
