# Copyright (C) 2000-2001 The OpenRPG Project
#
#       openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: gsclient.py
# Author: Chris Davis
# Maintainer:
# Version:
#   $Id: gsclient.py,v 1.34 2005/10/24 01:07:27 tdb30_ Exp $
#
# Description: The file contains code for the game server browser
#

__version__ = "$Id: gsclient.py,v 1.34 2005/10/24 01:07:27 tdb30_ Exp $"

import orpg.dirpath
from orpg.orpg_windows import *
from orpg.orpg_xml import *
import meta_server_lib
import orpg.tools.orpg_settings
import orpg.tools.rgbhex
import traceback

gs_host = 1
gs_join = 2
# constants

LIST_SERVER = wxNewId()
LIST_ROOM = wxNewId()
ADDRESS = wxNewId()

GS_CONNECT = wxNewId()
GS_DISCONNECT = wxNewId()
GS_SERVER_REFRESH = wxNewId()
GS_JOIN = wxNewId()
GS_JOINLOBBY = wxNewId()
GS_CREATE_ROOM = wxNewId()
GS_PWD = wxNewId()
GS_CLOSE = wxNewId()
OR_CLOSE = wxNewId()


class server_instance:
    def __init__(self, id, name="[Unknown]", users="0", address="127.0.0.1", port="6774"):
        self.id = id
        self.name = name
        self.user = users
        self.addy = address
        self.port = port

def server_instance_compare(x,y):
    """compares server insances for list sort"""
    DEV_SERVER = "OpenRPG DEV"
    xuser = 0
    yuser = 0
    try: xuser = int(x.user)
    except: pass
    try: yuser = int(y.user)
    except: pass

    if x.name.startswith(DEV_SERVER):
        if y.name.startswith(DEV_SERVER):
            if x.name > y.name: return 1
            elif x.name == y.name:
                if xuser < yuser: return 1
                elif xuser > yuser: return -1
                else: return 0
            else: return -1
        else: return -1
    elif y.name.startswith(DEV_SERVER): return 1
    elif xuser < yuser: return 1
    elif xuser == yuser:
        if x.name > y.name: return 1
        elif x.name == y.name: return 0
        else: return -1
    else: return -1


class game_server_panel(wxPanel):
    def __init__(self,parent,openrpg):
        wxPanel.__init__(self, parent, -1)
        self.parent = parent
        self.myopenrpg = openrpg
        self.password_manager = openrpg.get_component('password_manager') # passtool --SD 8/03
        self.frame = openrpg.get_component('frame')
        self.session = openrpg.get_component('session')
        self.settings = openrpg.get_component('settings')
        self.serverNameSet = 0
        self.last_motd = ""
        self.buttons = {}
        self.texts = {}
        self.svrList = []
        self.build_ctrls()
        self.refresh_server_list()
        self.refresh_room_list()
        EVT_SIZE(self, self.on_size)


#---------------------------------------------------------
# [START] Snowdog: Updated Game Server Window 12/02
#---------------------------------------------------------
    def build_ctrls(self):
        ## Section Sizers (with frame edges and text captions)
        self.box_sizers = {}
        self.box_sizers["server"] = wxBoxedSizer(self,"Server")
        self.box_sizers["window"] = wxBoxedSizer( self, "Exit" )
        self.box_sizers["room"] = wxBoxedSizer(self,"Rooms")
        self.box_sizers["c_room"] = wxBoxedSizer(self,"Create Room")


        ## fixed size Boxed Sizers
        self.box_sizers["c_room"].SetMySize( wxSize(200,125) )
        self.box_sizers["window"].SetMySize( wxSize(200,60) )


        ## Layout Sizers
        self.sizers = {}
        self.sizers["main"] = wxBoxSizer(wxHORIZONTAL)
        self.sizers["left"] = wxBoxSizer(wxVERTICAL)
        self.sizers["right"] = wxBoxSizer(wxVERTICAL)
        self.sizers["server"] = wxBoxSizer(wxVERTICAL)
        self.sizers["svrlst"] = wxBoxSizer(wxVERTICAL)
        self.sizers["option"] = wxBoxSizer(wxHORIZONTAL)
        self.sizers["close"] = wxBoxSizer(wxHORIZONTAL)
        self.sizers["c_room"] = wxBoxSizer(wxVERTICAL)
        self.sizers["rooms"] = wxBoxSizer(wxVERTICAL)
        self.sizers["join_buttons"] = wxBoxSizer(wxHORIZONTAL)
        self.sizers["cr_name"] = wxBoxSizer(wxHORIZONTAL)
        self.sizers["cr_pass"] = wxBoxSizer(wxHORIZONTAL)
        self.sizers["cr_admin"] = wxBoxSizer(wxHORIZONTAL)
        self.sizers["cr_make"] = wxBoxSizer(wxHORIZONTAL)

        ## List Objects
        self.server_list = wxListCtrl(self.box_sizers["server"],LIST_SERVER, style=wxLC_REPORT|wxSUNKEN_BORDER )
        self.server_list.InsertColumn(0,"Players",wxLIST_FORMAT_LEFT,0)
        self.server_list.InsertColumn(1,"Name",wxLIST_FORMAT_LEFT,0)

        self.room_list = wxListCtrl(self.box_sizers["room"],LIST_ROOM,style=wxLC_REPORT|wxSUNKEN_BORDER)
        self.room_list.InsertColumn(0,"Game",wxLIST_FORMAT_LEFT,0)
        self.room_list.InsertColumn(1,"Players",wxLIST_FORMAT_LEFT,0)
        self.room_list.InsertColumn(2,"PW",wxLIST_FORMAT_LEFT,0)


        ## Text Field Objects
        self.texts["address"] = wxTextCtrl(self.box_sizers["server"], ADDRESS)
        self.texts["room_name"]= wxTextCtrl(self.box_sizers["c_room"], -1)
        self.texts["room_pwd"]= wxTextCtrl(self.box_sizers["c_room"], -1)
        self.texts["room_pwd"].Enable(0)
        self.texts["room_boot_pwd"] = wxTextCtrl(self.box_sizers["c_room"],-1)
        self.texts["room_min_version"] = wxTextCtrl(self.box_sizers["c_room"],-1)


        ## Buttons
        self.buttons[GS_CONNECT] = wxButton(self.box_sizers["server"], GS_CONNECT, "Connect")
        self.buttons[GS_SERVER_REFRESH] = wxButton(self.box_sizers["server"], GS_SERVER_REFRESH, "Refresh")
        self.buttons[GS_DISCONNECT] = wxButton(self.box_sizers["server"], GS_DISCONNECT, "Disconnect")
        self.buttons[GS_JOIN] = wxButton(self.box_sizers["room"], GS_JOIN, "Join Room")
        self.buttons[GS_JOINLOBBY] = wxButton(self.box_sizers["room"], GS_JOINLOBBY, "Lobby")
        self.buttons[GS_CREATE_ROOM] = wxButton(self.box_sizers["c_room"], GS_CREATE_ROOM, "Create Room")
        self.buttons[GS_PWD] = wxCheckBox(self.box_sizers["c_room"], GS_PWD, "")
        self.buttons[OR_CLOSE] = wxButton(self.box_sizers["window"], OR_CLOSE,"Exit OpenRPG")
        self.buttons[GS_CLOSE] = wxButton(self.box_sizers["window"], GS_CLOSE,"Close Window")


        ## Layout Assemmbly -- Adding Objects to correct sizers
        self.sizers["option"].Add(self.buttons[GS_CONNECT] ,1,wxEXPAND )
        self.sizers["option"].Add(self.buttons[GS_SERVER_REFRESH],1,wxEXPAND )
        self.sizers["option"].Add(self.buttons[GS_DISCONNECT],1,wxEXPAND )

        self.sizers["server"].Add(wxStaticText(self.box_sizers["server"], -1, "Address: "),0,wxLEFT)
        self.sizers["server"].Add(self.texts["address"],0,wxEXPAND)
        self.sizers["server"].Add(wxStaticText(self.box_sizers["server"], -1, "Server List: "),0,wxLEFT)
        self.sizers["server"].Add(self.server_list,1,wxEXPAND)

        self.sizers["cr_name"].Add(wxStaticText(self.box_sizers["c_room"], -1, "Name: "),0,wxLEFT | wxALIGN_CENTER_VERTICAL)
        self.sizers["cr_name"].Add(self.texts["room_name"],1,wxEXPAND | wxALIGN_CENTER_VERTICAL)
        self.sizers["cr_pass"].Add(wxStaticText(self.box_sizers["c_room"],-1,"Pass:   "),0,wxLEFT | wxALIGN_CENTER_VERTICAL)
        self.sizers["cr_pass"].Add(self.buttons[GS_PWD],0,wxLEFT | wxALIGN_CENTER_VERTICAL)
        self.sizers["cr_pass"].Add(self.texts["room_pwd"],1,wxEXPAND | wxALIGN_CENTER_VERTICAL)
        self.sizers["cr_admin"].Add(wxStaticText(self.box_sizers["c_room"],-1,"Admin Pass: "),0,wxLEFT | wxALIGN_CENTER_VERTICAL)
        self.sizers["cr_admin"].Add(self.texts["room_boot_pwd"],1,wxEXPAND | wxALIGN_CENTER_VERTICAL)
        self.sizers["cr_admin"].Add(wxStaticText(self.box_sizers["c_room"],-1,"  Min. Ver.: "),0,wxLEFT | wxALIGN_CENTER_VERTICAL)
        self.sizers["cr_admin"].Add(self.texts["room_min_version"],1, wxALIGN_CENTER_VERTICAL)
        self.sizers["cr_make"].Add(self.buttons[GS_CREATE_ROOM],1,wxEXPAND )

        self.sizers["close"].Add( self.buttons[OR_CLOSE], 1, wxCENTER | wxEXPAND | wxALIGN_CENTER_VERTICAL )
        self.sizers["close"].Add( self.buttons[GS_CLOSE], 1, wxCENTER | wxEXPAND | wxALIGN_CENTER_VERTICAL )

        self.sizers["rooms"].Add(self.room_list,1,wxEXPAND)
        self.sizers["join_buttons"].Add(self.buttons[GS_JOINLOBBY],0,wxEXPAND)
        self.sizers["join_buttons"].Add(self.buttons[GS_JOIN],1,wxEXPAND)
        self.sizers["rooms"].Add(self.sizers["join_buttons"],0,wxEXPAND)

        ## bind intermediate sizers
        self.sizers["svrlst"].Add(self.sizers["server"],1,wxEXPAND)
        self.sizers["svrlst"].Add(self.sizers["option"],0,wxEXPAND| wxALIGN_CENTER_VERTICAL)

        self.sizers["c_room"].Add(self.sizers["cr_name"],0,wxEXPAND)
        self.sizers["c_room"].Add(self.sizers["cr_pass"],0,wxEXPAND)
        self.sizers["c_room"].Add(self.sizers["cr_admin"],0,wxEXPAND)
        self.sizers["c_room"].Add(self.sizers["cr_make"],0,wxEXPAND)




        ## Add sizers to framed sizers (aka panels)
        self.box_sizers["server"].set_sizer( self.sizers["svrlst"] )
        self.box_sizers["c_room"].set_sizer( self.sizers["c_room"] )
        self.box_sizers["window"].set_sizer( self.sizers["close"] )
        self.box_sizers["room"].set_sizer(self.sizers["rooms"])


        ## bind sizers
        self.sizers["right"].Add(self.box_sizers["room"],1,wxEXPAND)
        self.sizers["right"].Add(self.box_sizers["c_room"],0,wxEXPAND | wxALIGN_CENTER_VERTICAL)

        self.sizers["left"].Add(self.box_sizers["server"],1,wxEXPAND)
        self.sizers["left"].Add(self.box_sizers["window"],0,wxEXPAND | wxALIGN_CENTER_VERTICAL)

        self.sizers["main"].Add(self.sizers["left"],1,wxEXPAND)
        self.sizers["main"].Add(self.sizers["right"],1,wxEXPAND)

        self.SetSizer(self.sizers["main"])


        ## Event Handlers
        EVT_BUTTON(self, GS_CONNECT, self.on_button)
        EVT_BUTTON(self, GS_DISCONNECT, self.on_button)
        EVT_BUTTON(self, GS_CREATE_ROOM, self.on_button)
        EVT_BUTTON(self, GS_JOIN, self.on_button)
        EVT_BUTTON(self, GS_JOINLOBBY, self.on_button)
        EVT_BUTTON(self, GS_SERVER_REFRESH, self.on_button)
        EVT_BUTTON(self, GS_CLOSE, self.on_button)
        EVT_BUTTON(self, OR_CLOSE, self.on_button)
        EVT_CHECKBOX(self, GS_PWD, self.on_button)


        # Added double click handlers 5/05 -- Snowdog
        EVT_LIST_ITEM_ACTIVATED(self, LIST_SERVER, self.on_server_dbclick)
        EVT_LIST_ITEM_ACTIVATED(self, LIST_ROOM, self.on_room_dbclick)

        EVT_LIST_ITEM_SELECTED(self,LIST_ROOM,self.on_select)
        EVT_LIST_ITEM_SELECTED(self,LIST_SERVER,self.on_select)
        EVT_SET_FOCUS(self.texts['address'],self.on_text)
        self.set_connected(self.session.is_connected())
        self.cur_room_index = -1
        self.cur_server_index = -1

#---------------------------------------------------------
# [END] Snowdog: Updated Game Server Window 12/02
#---------------------------------------------------------



    #-----------------------------------------------------
    # on_server_dbclick()
    # support for double click selection of server.
    # 5/16/05 -- Snowdog
    #-----------------------------------------------------
    def on_server_dbclick(self, evt):
        #make sure address is updated just in case list select wasn't done
        self.on_select(evt)
        address = self.texts["address"].GetValue()
        if self.session.is_connected():
            if self.session.host_server == address :
                #currently connected to address. Do nothing.
                return
            else:
                #address differs, disconnect.
                self.frame.kill_mplay_session()
        self.do_connect(address)


    #-----------------------------------------------------
    # on_room_dbclick()
    # support for double click selection of server.
    # 5/16/05 -- Snowdog
    #-----------------------------------------------------
    def on_room_dbclick(self, evt):
        #make sure address is updated just in case list select wasn't done
        self.on_select(evt)

        if self.cur_room_index >= 0:
            if self.cur_room_index != 0:
                self.set_lobbybutton(1);
            else:
                self.set_lobbybutton(0);

            group_id = str(self.room_list.GetItemData(self.cur_room_index))
            group = self.session.get_group_info(group_id)
            pwd = ""
            if (group[2] == "True") or (group[2] == "1"):
                pwd = self.password_manager.GetPassword("room", group_id)
            else:
                pwd = ""
            self.session.send_join_group(group_id,pwd)



    def on_select(self,evt):
        id = evt.GetId()
        if id == LIST_ROOM:
            self.cur_room_index = evt.m_itemIndex
        elif id==LIST_SERVER:
            #self.cur_server_index = self.server_list.GetSelection()
            self.cur_server_index = evt.m_itemIndex

            self.name = self.svrList[self.cur_server_index].name
            address = self.svrList[self.cur_server_index].addy
            port = self.svrList[self.cur_server_index].port
            #self.name = self.servers[self.cur_server_index].getAttribute('name')
            #address = self.servers[self.cur_server_index].getAttribute('address')
            #port = self.servers[self.cur_server_index].getAttribute('port')
            self.texts["address"].SetValue(address+":"+str(port))

    def on_text(self,evt):
        id = evt.GetId()
        if (id == ADDRESS) and (self.cur_server_index >= 0):
            print "ADDRESS id = ", id, "index = ", self.cur_server_index
            #self.server_list.SetSelection(self.cur_server_index,false)
            self.cur_server_index = -1
        evt.Skip()

    def add_room(self,data):
        i = self.room_list.GetItemCount()
        if (data[2]=="1") or (data[2]=="True"): pwd="yes"
        else: pwd="no"
        self.room_list.InsertStringItem(i,data[1])
        self.room_list.SetStringItem(i,1,data[3])
        self.room_list.SetStringItem(i,2,pwd)
        self.room_list.SetItemData(i,int(data[0]))
        self.refresh_room_list()

    def del_room(self,data):
        i = self.room_list.FindItemData(-1,int(data[0]))
        self.room_list.DeleteItem(i)
        self.refresh_room_list()


#---------------------------------------------------------
# [START] Snowdog Password/Room Name altering code 12/02
#---------------------------------------------------------

    def update_room(self,data):
        #-------------------------------------------------------
        # Udated 12/02 by Snowdog
        # allows refresh of all room data not just player counts
        #-------------------------------------------------------
        i = self.room_list.FindItemData(-1,int(data[0]))
        if data[2]=="1" : pwd="yes"
        else: pwd="no"
        self.room_list.SetStringItem(i,0,data[1])
        self.room_list.SetStringItem(i,1,data[3])
        self.room_list.SetStringItem(i,2,pwd)
        self.refresh_room_list()

#---------------------------------------------------------
# [END] Snowdog Password/Room Name altering code 12/02
#---------------------------------------------------------

    def set_cur_room_text(self,name):
        pass
        #self.texts["cur_room"].SetLabel(name)
        #self.sizers["room"].Layout()


    def set_lobbybutton(self,allow):
        self.buttons[GS_JOINLOBBY].Enable(allow)

    def set_connected(self,connected):
        self.buttons[GS_CONNECT].Enable(not connected)
        self.buttons[GS_DISCONNECT].Enable(connected)
        self.buttons[GS_JOIN].Enable(connected)
        self.buttons[GS_CREATE_ROOM].Enable(connected)
        if not connected:
            self.buttons[GS_JOINLOBBY].Enable(connected)
            self.room_list.DeleteAllItems()
            self.set_cur_room_text("Not Connected!")
            self.cur_room_index = -1
            self.frame.status.set_connect_status("Not Connected")
        else:
            #data = self.session.get_my_group()
            self.frame.status.set_connect_status(self.name)
            self.set_cur_room_text("Lobby")

    def on_button(self,evt):
        id = evt.GetId()
        if id == GS_CONNECT:
            address = self.texts["address"].GetValue()
            ### check to see if this is a manual entry vs. list entry.
            try:
                dummy = self.name
            except:
                self.name = `address`
            self.do_connect(address)
        elif id == GS_DISCONNECT:
            self.frame.kill_mplay_session()
        elif id == GS_CREATE_ROOM:
            self.do_create_group()
        elif id == GS_JOIN:
            self.do_join_group()
        elif id == GS_JOINLOBBY:
            self.do_join_lobby()
        elif id == GS_SERVER_REFRESH:
            self.refresh_server_list()
        elif id == GS_PWD:
            self.texts["room_pwd"].Enable(evt.Checked())
        elif id == OR_CLOSE:
            dlg = wxMessageDialog(self,"Quit OpenRPG?","OpenRPG",wxYES_NO)
            if dlg.ShowModal() == wxID_YES:
                dlg.Destroy()
                self.frame.kill_mplay_session()
                self.frame.closed_confirmed()
        elif id == GS_CLOSE:
            # Potential BUG here.  type function didn't return useful
            # information, so we make the call assuming it's in a
            # wxPFrame, and catch the exception if it's not.
            # lame, but true.
            # a better way might be to look at the parent's dict or
            # __name__ or something

            # print self.parent.__name__ # this didn't work
            # print self.parent.__dict__  # this *might* be coerced into working
            # print self.parent.locals() # this didn't work

            # print 'browse panel closing'
            # print 'parent type is',type( self.parent )
            # print 'wxPFrame type is', type( wxPFrame )
            # if ( type( self.parent ) == type( wxPFrame ) ):
            #     self.parent.OnCloseWindow( self, None )
            # else:
            try:
                self.parent.OnCloseWindow( self, None )
            except:
                self.parent.Close()
            # self.parent.Close()

    def refresh_room_list(self):
        self.room_list.DeleteAllItems()
        groups = self.session.get_groups()
        for g in groups:
             i = self.room_list.GetItemCount()
             if (g[2]=="True") or (g[2]=="1") : pwd="yes"
             else: pwd="no"
             self.room_list.InsertStringItem(i,g[1])
             self.room_list.SetStringItem(i,1,g[3])
             self.room_list.SetStringItem(i,2,pwd)
             self.room_list.SetItemData(i,int(g[0]))
        self.colorize_group_list(groups)
        self.room_list.SortItems(cmp)

    def refresh_server_list(self):
        #dlg = do_progress_dlg(self,"Game Browser","Retrieving  Server List...",5)

        try:
            self.svrList = []
            self.server_list.DeleteAllItems()
            xml_dom = meta_server_lib.get_server_list(["2"]);
            #dlg.Update(1,"Parsing list...")
            node_list = xml_dom.getElementsByTagName('server')
            #dlg.Update(2)

            hex = orpg.tools.rgbhex.RGBHex()
            color1 = self.settings.get_setting("RoomColor_Active")
            color2 = self.settings.get_setting("RoomColor_Locked")
            color3 = self.settings.get_setting("RoomColor_Empty")
            color4 = self.settings.get_setting("RoomColor_Lobby")

            if len(node_list):
                length = len(node_list)
                part = 0
                partLength = 1.0/length



                for n in node_list:
                    if n.hasAttribute('id') and n.hasAttribute('name') and n.hasAttribute('num_users') and n.hasAttribute('address') and n.hasAttribute('port'):
                        self.svrList.append( server_instance(n.getAttribute('id'),n.getAttribute('name'), n.getAttribute('num_users'), n.getAttribute('address'),n.getAttribute('port')))

                self.svrList.sort(server_instance_compare)

                for n in self.svrList:
                    i = self.server_list.GetItemCount()
                    name = n.name
                    players = n.user

                    self.server_list.InsertStringItem(i,players)
                    self.server_list.SetStringItem(i,1,name)

                    r,g,b = hex.rgb_tuple(color1)
                    svrcolor = wxColour(red=r,green=g,blue=b)

                    if players == "0":
                        r,g,b = hex.rgb_tuple(color3)
                        svrcolor = wxColour(red=r,green=g,blue=b)

                    if n.name.startswith("OpenRPG DEV"):
                        r,g,b = hex.rgb_tuple(color2)
                        svrcolor = wxColour(red=r,green=g,blue=b)

                    item = self.server_list.GetItem(i)
                    item.SetTextColour(svrcolor)
                    self.server_list.SetItem(item)

                    part += partLength

                    #  wxProgressDialog.Update takes an int
                    #dlg.Update( 2 + part )

                self.servers = node_list

            # No server is currently selected!!!  Versus the broken and random 0!
            self.cur_server_index = -1

            if self.serverNameSet == 0:
                # Pointless to constantly set the address field to random
                # server.  This way, at least, if someone has their own local
                # server it can now easily be connected with.  Nor do we want
                # to reset this every time as it would wipe any previously
                # entered data or even the previously selected server data!
                # Localhost should probably be used but some systems are ultra/lame
                # broken about localhost use.
                self.texts["address"].SetValue( "127.0.0.1:6774" )
                self.serverNameSet = 1


##            dlg.Update(3,"Checking for new MOTD ...")

##            #xml_dom2 =  parseXml("<motd href='http://bennettsathome.com/testmotd.html'>")
##            #node_list = xml_dom2.getElementsByTagName('motd')
##            node_list = xml_dom.getElementsByTagName('motd')
##            if node_list:
##                #motd = node_list[0]._get_firstChild().toxml()
##                data = urllib.urlretrieve(node_list[0].getAttribute('href'))
##                file = open(data[0])
##                motd = file.read()
##                if motd != self.last_motd:
##                    self.last_motd = motd
##                    #motd_frame = wxHTMLFrame(self,"Important Message from OpenRPG",style = wxSTAY_ON_TOP | wxDEFAULT_FRAME_STYLE)
##                    #motd_frame.set_page(motd)
##                    #motd_frame.Show()
##                    self.frame.chat.Post(motd)
##                    wxMessageBox("There is an important bulletin diplayed in the Chat window","Bulletin")

            else:
                pass

            #  Allow xml_dom to be collected
            try:
                #xml_dom.unlink()
                pass
            except:
                pass


        except Exception, e:
            print "Server List not available."
            traceback.print_exc()

        #dlg.Update(4,"Done.")

        #dlg.Destroy()

    def failed_connection(self):
        if(self.cur_server_index >= 0):
            id = self.servers[self.cur_server_index].getAttribute('id')
            meta = self.servers[self.cur_server_index].getAttribute('meta')
            address = self.servers[self.cur_server_index].getAttribute('address')
            port = self.servers[self.cur_server_index].getAttribute('port')
            #  post_failed_connection will return a non-zero if the server
            #  was removed.  If it was, refresh the display
            if(meta_server_lib.post_failed_connection(id,meta=meta,address=address,port=port)):
                self.refresh_server_list()

    def do_connect(self,address):
        chat = self.myopenrpg.get_component('chat')
        chat.InfoPost("Locating server at "+address+"...")
        if self.session.connect(address):
            self.frame.start_timer()
        else:
            chat.SystemPost("Failed to connect to game server...")
            self.failed_connection()

    def do_join_lobby(self):
        self.cur_room_index = 0
        self.session.send_join_group("0","")
        self.set_lobbybutton(0);

    def do_join_group(self):
        if self.cur_room_index >= 0:
            if self.cur_room_index != 0:
                self.set_lobbybutton(1);
            else:
                self.set_lobbybutton(0);
            group_id = str(self.room_list.GetItemData(self.cur_room_index))
            group = self.session.get_group_info(group_id)
            pwd = ""
            if (group[2] == "True") or (group[2] == "1"):
                pwd = self.password_manager.GetPassword("room", group_id)
                #dlg = wxTextEntryDialog(self,"Password?","Join Private Room")
                #if dlg.ShowModal() == wxID_OK:
                #    pwd = dlg.GetValue()
                #dlg.Destroy()
            else:
                pwd = ""
            if pwd != None:#pwd==None means the user clicked "Cancel"
                self.session.send_join_group(group_id,pwd)


    def do_create_group(self):
        name = self.texts["room_name"].GetValue()
        boot_pwd = self.texts["room_boot_pwd"].GetValue()
        minversion = self.texts["room_min_version"].GetValue()

        #
        # Check for & in name.  We want to allow this becaus of its common use in D&D.
        #

        loc = name.find("&")
        oldloc=0
        while loc > -1:
            loc = name.find("&",oldloc)
            if loc > -1:
                b = name[:loc]
                e = name[loc+1:]
                name = b + "&amp;" + e
                oldloc = loc+1

        loc = name.find('"')
        oldloc=0
        while loc > -1:
            loc = name.find('"',oldloc)
            if loc > -1:
                b = name[:loc]
                e = name[loc+1:]
                name = b + "&#39;&#39;" + e
                oldloc = loc+1
        loc = name.find("'")
        oldloc=0
        while loc > -1:
            loc = name.find("'",oldloc)
            if loc > -1:
                b = name[:loc]
                e = name[loc+1:]
                name = b + "&#39;" + e
                oldloc = loc+1


        if self.buttons[GS_PWD].GetValue():
            pwd = self.texts["room_pwd"].GetValue()
        else:
            pwd = ""
        if name == "":
            wxMessageBox("Invalid Name","Error");
        else:
            msg = "%s is creating room \'%s.\'" % (self.session.name, name)
            self.session.send( msg )
            self.session.send_create_group(name,pwd,boot_pwd,minversion)
            self.set_lobbybutton(1); #enable the Lobby quickbutton


#---------------------------------------------------------
# [START] Snowdog: Updated Game Server Window 12/02
#---------------------------------------------------------

    def on_size(self,evt):
        (w,h) = self.GetClientSizeTuple()
        w = w/2
        w2 = w*2

        self.sizers["main"].SetDimension(0,0,w2,h)

        # set column widths for room list
        (lw, lh) = self.room_list.GetClientSizeTuple()
        self.room_list.SetColumnWidth(0, lw-80)
        self.room_list.SetColumnWidth(1, 50)
        self.room_list.SetColumnWidth(2, 30)

        # set column widths for server list
        (lw, lh) = self.server_list.GetClientSizeTuple()
        lw = lw/4
        self.server_list.SetColumnWidth(0, lw)
        self.server_list.SetColumnWidth(1, lw*3)


#---------------------------------------------------------
# [END] Snowdog: Updated Game Server Window 12/02
#---------------------------------------------------------


    def colorize_group_list(self, groups):
        try:
            hex = orpg.tools.rgbhex.RGBHex()
            color1 = self.settings.get_setting("RoomColor_Active")
            color2 = self.settings.get_setting("RoomColor_Locked")
            color3 = self.settings.get_setting("RoomColor_Empty")
            color4 = self.settings.get_setting("RoomColor_Lobby")


            for gr in groups:

                item_list_location = self.room_list.FindItemData(-1,int(gr[0]))
                if item_list_location != -1:
                    item = self.room_list.GetItem(item_list_location)
                    r,g,b = hex.rgb_tuple(color1)
                    color = wxColour(red=r,green=g,blue=b)

                    #passworded rooms with players get marked in dark red
                    if gr[2]=="1" or gr[2]=="True":
                        r,g,b = hex.rgb_tuple(color2)
                        color = wxColour(red=r,green=g,blue=b)

                    #all empty rooms marked in light grey
                    if gr[3] == "0":
                        r,g,b = hex.rgb_tuple(color3)
                        color = wxColour(red=r,green=g,blue=b)

                    #Lobby always marked in blue
                    if gr[0] == "0":
                        r,g,b = hex.rgb_tuple(color4)
                        color = wxColour(red=r,green=g,blue=b)

                    item.SetTextColour(color)
                    self.room_list.SetItem(item)
        except:
            traceback.print_exc()
