/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
#ifndef _SFXMODULE_HXX
#define _SFXMODULE_HXX	// intern
#define _SFXMOD_HXX		// extern

#include "sal/config.h"
#include "sfx2/dllapi.h"
#include <sfx2/shell.hxx>
#include <sfx2/imgdef.hxx>
#include <sal/types.h>
class ImageList;

class SfxAcceleratorManager;
class SfxBindings;
class SfxObjectFactory;
class ModalDialog;
class SfxObjectFactory;
class SfxModuleArr_Impl;
class SfxModule_Impl;
class SfxSlotPool;
struct SfxChildWinContextFactory;
struct SfxChildWinFactory;
struct SfxMenuCtrlFactory;
struct SfxStbCtrlFactory;
struct SfxTbxCtrlFactory;
class SfxTbxCtrlFactArr_Impl;
class SfxChildWinFactArr_Impl;
class SfxMenuCtrlFactArr_Impl;
class SfxStbCtrlFactArr_Impl;
class SfxTabPage;
class Window;

//====================================================================

class SFX2_DLLPUBLIC SfxModule : public SfxShell
{
private:
	ResMgr*                     pResMgr;
    sal_Bool                    bDummy : 1;
	SfxModule_Impl*             pImpl;

//#if 0 // _SOLAR__PRIVATE
	SAL_DLLPRIVATE void Construct_Impl();
//#endif

public:
								TYPEINFO();
								SFX_DECL_INTERFACE(SFX_INTERFACE_SFXMODULE)

								SfxModule( ResMgr* pMgrP, sal_Bool bDummy,
									SfxObjectFactory* pFactoryP, ... );
								~SfxModule();

    ResMgr*                     GetResMgr() const { return SfxShell::GetResMgr(); }
    virtual ResMgr*             GetResMgr();
	SfxSlotPool*				GetSlotPool() const;

	void						RegisterToolBoxControl(SfxTbxCtrlFactory*);
	void                        RegisterChildWindow(SfxChildWinFactory*);
	void                        RegisterChildWindowContext( sal_uInt16,	SfxChildWinContextFactory* );
	void                        RegisterStatusBarControl(SfxStbCtrlFactory*);
	void                        RegisterMenuControl(SfxMenuCtrlFactory*);

	virtual SfxTabPage*			CreateTabPage( sal_uInt16 nId,
											   Window* pParent,
											   const SfxItemSet& rSet );
    virtual void                Invalidate(USHORT nId = 0);
	BOOL						IsActive() const;

    static SfxModule*           GetActiveModule( SfxViewFrame* pFrame=NULL );

//#if 0 // _SOLAR__PRIVATE
    SAL_DLLPRIVATE static SfxModuleArr_Impl& GetModules_Impl();
    SAL_DLLPRIVATE static void DestroyModules_Impl();
    SAL_DLLPRIVATE SfxTbxCtrlFactArr_Impl* GetTbxCtrlFactories_Impl() const;
    SAL_DLLPRIVATE SfxStbCtrlFactArr_Impl* GetStbCtrlFactories_Impl() const;
    SAL_DLLPRIVATE SfxMenuCtrlFactArr_Impl* GetMenuCtrlFactories_Impl() const;
    SAL_DLLPRIVATE SfxChildWinFactArr_Impl* GetChildWinFactories_Impl() const;
    SAL_DLLPRIVATE ImageList* GetImageList_Impl( BOOL bBig );
    SAL_DLLPRIVATE ImageList* GetImageList_Impl( BOOL bBig, BOOL bHiContrast );
//#endif
};

#endif

